import { s as styleInject, e as _inherits, f as _createClass, h as _classCallCheck, i as _callSuper, _ as _asyncToGenerator, a as _regenerator, r as _regeneratorValues, o as _createForOfIteratorHelper, g as _objectSpread2, n as _defineProperty, d as _slicedToArray, l as _extends, j as _toConsumableArray, p as _objectDestructuringEmpty, q as _typeof } from './style-inject.es-ebcb980f.js';
import React, { useState, useRef, useEffect } from 'react';
import _ from 'lodash';
import { IafPassSvc, IafSession, IafProj, IafUserGroup, IafScripts, IafDataSource, IafPermission, IafItemSvc, IafFileSvc } from '@dtplatform/platform-api';
import { G as GenericMatButton, S as ScriptHelper, l as leafNodeRenderer, m as branchNodeRenderer, h as getFilteredEntitiesBy, F as FileHelpers, z as parseQuery, f as ScriptCache } from './TreeRendererHelper-7d89f2f1.js';
import { n as SimpleTable, a2 as EntityActionsPanel, e as EnhancedFetchControl, a3 as EntitySelectionPanel, a4 as TreeSelectMode, E as EntityListView, t as getAllCurrentEntities, w as getFetchingCurrent, x as getFilteredEntities, ai as getAppliedFilters, O as OrDivider, u as useChecked, R as RoundCheckbox, c as TickCheckbox, s as selectStyles, aB as actualPage, aC as addUserConfig, aD as EmptyConfig, ay as addEntityComponents } from './EntityListView-43ddf04c.js';
import clsx from 'clsx';
import { IafScriptEngine } from '@dtplatform/iaf-script-engine';
import { IafLocalFile } from '@dtplatform/ui-utils';
import produce, { produce as produce$1 } from 'immer';
import Select from 'react-select';
import { object, string, func } from 'prop-types';
import moment from 'moment';
import { S as StackableDrawer } from './StackableDrawer-e9e633e1.js';
import { compose as compose$1 } from 'redux';
import { connect } from 'react-redux';
import { compose } from '@reduxjs/toolkit';
import { IfefIcon } from '@dtplatform/react-ifef';
import { G as GenericModal } from './GenericModal-a2a94ca2.js';
import { Container, Toolbar, Box } from '@mui/material';
import { styled } from '@mui/system';
import CheckBox from '@mui/icons-material/CheckBox';
import { R as RadioButtons, G as GenericButton } from './RadioButtons-8e63c696.js';
import { Route, Redirect } from 'react-router-dom';
import { S as SimpleTextThrobber } from './SimpleTextThrobber-687e4daa.js';
import { RadioButtonUnchecked, RadioButtonChecked } from '@mui/icons-material';
import { A as AppContext, w as withAppContext } from './appContext-07909014.js';
import { f as formatBytes } from './bytesunit-e53abe5f.js';
import { G as GenericPageContext } from './genericPageContext-de32d520.js';
import { E as EntityDataStack, a as withEntitySearch, c as withEntityAvailableGroups, g as EntityTableContainer, J as JSONEditor, d as withGenericPageErrorBoundary } from './GenericPageErrorBoundary-27ba825c.js';
import { Controlled } from 'react-codemirror2';
import 'codemirror/lib/codemirror.css';
import 'codemirror/addon/fold/foldgutter.css';
import 'codemirror/mode/javascript/javascript.js';
import 'codemirror/addon/edit/matchbrackets.js';
import 'codemirror/addon/edit/closebrackets.js';
import 'codemirror/addon/fold/foldcode.js';
import 'codemirror/addon/fold/foldgutter.js';
import 'codemirror/addon/fold/brace-fold.js';
import 'codemirror/addon/fold/comment-fold.js';
import 'codemirror/addon/comment/comment.js';
import { m as getDashboardComponent, P as PanelToggle, o as Star, p as comesFromComplexSelect, q as isReadyFor, r as isComplete, t as isPending, u as isInProgress, v as getBlob, W as WizardButtons, w as getFilesToUpload, x as getAssociatedEntities, y as getRejectedFiles, z as getColumnConfig, A as addFilesToUpload, B as cleanFiles, C as uploadFiles, D as loadAssociatedEntities, E as updateMultipleFileAttribute, F as fetchColumnConfig, l as store, G as addReducerSlice, H as addUser, I as addDashboardComponents } from './store-31878c8e.js';
import { mobiscroll } from '@dtplatform/iaf-lib';
import qs from 'qs';
import Dialog from '@mui/material/Dialog';
import mime from 'mime-types';
import 'codemirror/addon/hint/show-hint.js';
import 'codemirror/addon/hint/show-hint.css';
import json5 from 'json5';
import Switch from '@mui/material/Switch';
import { IafAuth } from '@dtplatform/platform-ui-components';

var DefaultStyleVars = {
	"--app-accent-color": "#C71784",
	"--head-bkg-color": "#333333",
	"--head-appname-color": "whitesmoke",
	"--head-menu-bkg-color": "#666666",
	"--head-menu-hover-color": "#999999",
	"--nav-bkg-color": "#333333",
	"--nav-icon-color": "white",
	"--nav-hover-color": "#999999",
	"--nav-activegrp-bkg-color": "#bfbfbf",
	"--fancytree-one-color": "#C71784",
	"--fancytree-one-channel-color": "#f3d5e4",
	"--fancytree-two-color": "#f26827",
	"--fancytree-two-channel-color": "#fde0d7",
	"--fancytree-three-color": "#00a693",
	"--fancytree-three-channel-color": "#cdebe8"
};

var css_248z = ".project-picker-modal button {\n  text-transform: uppercase;\n  border-radius: 15px;\n  padding: 5px;\n  width: 40%;\n  margin: 5px;\n  margin-top: 20px !important;\n  border: solid black 2px;\n}\n.project-picker-modal button.default-load {\n  color: white;\n  background-color: var(--app-accent-color);\n  border-color: var(--app-accent-color);\n}\n.project-picker-modal button.default-cancel {\n  color: #6d6e70;\n  background-color: white;\n  border-color: #6d6e70;\n}\n.project-picker-modal button.setup {\n  color: white;\n  width: 23% !important;\n  background-color: var(--app-accent-color);\n  border-color: var(--app-accent-color);\n}\n.project-picker-modal button.cancel {\n  width: 23% !important;\n  color: #6d6e70;\n  background-color: white;\n  border-color: #6d6e70;\n}\n.project-picker-modal button.load {\n  color: white;\n  width: 23% !important;\n  background-color: var(--app-accent-color);\n  border-color: var(--app-accent-color);\n}\n.project-picker-modal button.done {\n  color: white;\n  width: 23% !important;\n  background-color: var(--app-accent-color);\n  border-color: var(--app-accent-color);\n}\n.project-picker-modal h4 {\n  font-size: 14px;\n}\n.project-picker-modal .invite-table td,\n.project-picker-modal .invite-table th {\n  padding: 5px;\n}\n.project-picker-modal .invite-table td:nth-of-type(2) {\n  min-width: 250px;\n}\n.project-picker-modal .invite-table .invite-action {\n  display: block;\n  margin-left: 20px;\n  margin-bottom: 5px;\n  cursor: pointer;\n  color: var(--app-accent-color);\n}\n.project-picker-modal .invite-table .invite-action i {\n  padding-right: 0px;\n  width: 20px;\n}\n.project-picker-modal .custom-control.custom-switch {\n  z-index: unset;\n}\n.project-picker-modal .custom-control-input:checked ~ .custom-control-label::before {\n  color: #fff;\n  border-color: var(--app-accent-color);\n  background-color: var(--app-accent-color);\n}\n.project-picker-modal .custom-single-class .select__control:hover {\n  border-color: var(--app-accent-color);\n  box-shadow: 0 0 0 0px var(--app-accent-color);\n}\n.project-picker-modal .custom-single-class .select__option {\n  color: black;\n  background-color: white;\n}\n.project-picker-modal .custom-single-class .select__option--is-focused {\n  background-color: var(--app-accent-color) !important;\n  color: white;\n}\n.project-picker-modal .custom-single-class .select__control {\n  border-color: #b0b0b0;\n  box-shadow: 0 0 0 0px #b0b0b0;\n}\n.project-picker-modal .custom-single-class .select__indicator-separator {\n  display: none; /* Hide the separator between the indicator and the input */\n}\n\n.button-container {\n  display: flex;\n  justify-content: space-between;\n}\n\n@media screen and (max-width: 768px) {\n  .button-container {\n    flex-wrap: wrap;\n    justify-content: flex-start;\n  }\n}";
styleInject(css_248z);

var css_248z$1 = "@keyframes rotateIcon {\n  0% {\n    transform: rotate(0deg);\n  }\n  100% {\n    transform: rotate(360deg);\n  }\n}\n.spinningLoadingIcon {\n  position: absolute;\n  right: 5px;\n  bottom: 5px;\n  margin: 10px;\n  border: 5px solid #1c435d;\n  border-radius: 50%;\n  border-top: 5px solid #f3f3f3;\n  width: 30px;\n  height: 30px;\n  animation: rotateIcon 2s linear infinite;\n}\n\n.projectLoadingIcon {\n  right: unset;\n  bottom: unset;\n}";
styleInject(css_248z$1);

var PROJECT_ID_KEY = "ipaSelectedProjectId";
var ProjectPickerModal = /*#__PURE__*/function (_React$Component) {
  function ProjectPickerModal(props) {
    var _this;
    _classCallCheck(this, ProjectPickerModal);
    _this = _callSuper(this, ProjectPickerModal, [props]);
    _this.componentDidMount = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
      return _regenerator().w(function (_context) {
        while (1) switch (_context.n) {
          case 0:
            _this.checkUserAccess();
            _this.loadModal();
            _this.setCssVariables();
          case 1:
            return _context.a(2);
        }
      }, _callee);
    }));
    _this.componentDidUpdate = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(prevProps, prevState) {
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              if (_this.props.projects !== prevProps.projects) _this.loadModal();
            case 1:
              return _context2.a(2);
          }
        }, _callee2);
      }));
      return function (_x, _x2) {
        return _ref2.apply(this, arguments);
      };
    }();
    _this.checkUserAccess = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3() {
      var _this$props$reference;
      var createTestProject, _t;
      return _regenerator().w(function (_context3) {
        while (1) switch (_context3.p = _context3.n) {
          case 0:
            if (!((_this$props$reference = _this.props.referenceAppConfig) !== null && _this$props$reference !== void 0 && _this$props$reference.refApp)) {
              _context3.n = 4;
              break;
            }
            _context3.p = 1;
            _context3.n = 2;
            return IafPassSvc.createWorkspaces([]);
          case 2:
            createTestProject = _context3.v;
            if (createTestProject && (createTestProject === null || createTestProject === void 0 ? void 0 : createTestProject._total) == 0) {
              _this.setState({
                user: {
                  has_access: true
                }
              });
            }
            _context3.n = 4;
            break;
          case 3:
            _context3.p = 3;
            _t = _context3.v;
            console.error(_t);
          case 4:
            return _context3.a(2);
        }
      }, _callee3, null, [[1, 3]]);
    }));
    _this.setCssVariables = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4() {
      var referenceAppConfig, result, root, accentColor, fancytreeOneColor, fancytreeOneChannelColor;
      return _regenerator().w(function (_context4) {
        while (1) switch (_context4.n) {
          case 0:
            referenceAppConfig = _this.props.referenceAppConfig; // Check if referenceAppConfig is defined and refApp is true
            if (!(referenceAppConfig !== null && referenceAppConfig !== void 0 && referenceAppConfig.refApp)) {
              _context4.n = 2;
              break;
            }
            _context4.n = 1;
            return IafPassSvc.getConfigs();
          case 1:
            result = _context4.v;
            root = document.documentElement;
            console.log(result.themes.login);
            accentColor = result.themes.login === "mirrana" ? "#E04F29" : "#4bade8";
            fancytreeOneColor = result.themes.login === "mirrana" ? "#E04F29" : "#4bade8";
            fancytreeOneChannelColor = result.themes.login === "mirrana" ? "#e98469" : "#dbecee";
            root.style.setProperty("--app-accent-color", accentColor);
            root.style.setProperty("--fancytree-one-color", fancytreeOneColor);
            root.style.setProperty("--fancytree-one-channel-color", fancytreeOneChannelColor);
          case 2:
            return _context4.a(2);
        }
      }, _callee4);
    }));
    _this.getUserGroupOptions = function (projectid) {
      return _this.state.appUserGroups[projectid] ? _this.state.appUserGroups[projectid].map(function (ug) {
        return {
          'value': ug._id,
          'label': ug._name
        };
      }) : [];
    };
    _this.loadModal = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee5() {
      var getFirstMatchingConfig, projects, myProjects, myUserGroups, _loop, i, projectid, usergroupid, selectUserGroupOptions;
      return _regenerator().w(function (_context6) {
        while (1) switch (_context6.n) {
          case 0:
            getFirstMatchingConfig = function _getFirstMatchingConf(group, configs) {
              var match = null;
              for (var i = 0; i < group._userAttributes.userConfigs.length; i++) {
                var found = _.find(configs, {
                  _id: group._userAttributes.userConfigs[i]._id
                });
                if (found) {
                  match = found;
                  break;
                }
              }
              return match;
            };
            projects = _this.props.projects;
            _this.getInvites();
            if (!(projects && projects.length > 0)) {
              _context6.n = 5;
              break;
            }
            myProjects = [];
            myUserGroups = {}; //for each project get the user's userGroups
            _loop = /*#__PURE__*/_regenerator().m(function _loop() {
              var userGroups, userConfigs;
              return _regenerator().w(function (_context5) {
                while (1) switch (_context5.n) {
                  case 0:
                    _context5.n = 1;
                    return IafProj.getUserGroupsForCurrentUser(projects[i]);
                  case 1:
                    userGroups = _context5.v;
                    if (!userGroups) {
                      _context5.n = 2;
                      break;
                    }
                    userGroups = userGroups.filter(function (ug) {
                      return !!ug._userAttributes.userConfigs;
                    });
                    _context5.n = 3;
                    break;
                  case 2:
                    console.log('no userGroups');
                    console.log(projects[i]);
                    return _context5.a(2, 1);
                  case 3:
                    _context5.n = 4;
                    return IafProj.getUserConfigs(projects[i], {
                      _userType: _this.props.configUserType
                    });
                  case 4:
                    userConfigs = _context5.v;
                    //get userConfig for each remaining userGroup
                    userGroups.forEach(function (ug) {
                      return [ug.userConfig = getFirstMatchingConfig(ug, userConfigs)];
                    });

                    //find the userGroups in the project that have application configs
                    userGroups = userGroups.filter(function (ug) {
                      return ug.userConfig;
                    });

                    //if a project has no userGroups remove the project
                    if (userGroups && userGroups.length) {
                      myProjects.push(projects[i]);
                      myUserGroups[projects[i]._id] = userGroups;
                    }
                  case 5:
                    return _context5.a(2);
                }
              }, _loop);
            });
            i = 0;
          case 1:
            if (!(i < projects.length)) {
              _context6.n = 4;
              break;
            }
            return _context6.d(_regeneratorValues(_loop()), 2);
          case 2:
            if (!_context6.v) {
              _context6.n = 3;
              break;
            }
            return _context6.a(3, 3);
          case 3:
            i++;
            _context6.n = 1;
            break;
          case 4:
            console.log(myProjects, myUserGroups);

            //serve projects and usergroups from state
            _this.setState({
              projects: myProjects,
              appUserGroups: myUserGroups
            });

            //check selectedItems and see if project and usergroup apply and if so set them to current

            if (!_this.props.appContextProps.selectedItems.selectedProject || !myUserGroups[_this.props.appContextProps.selectedItems.selectedProject._id]) {
              IafSession.setSessionStorage('project', {
                _namespaces: _.get(projects, '0._namespaces')
              });
              //res = await this.checkUserConfigs(projects[0]);
              projectid = myProjects[0] ? myProjects[0]._id : null;
              //usergroupid = res.selectedUserGroupId;
              usergroupid = projectid ? myUserGroups[myProjects[0]._id][0]._id : null;
            } else {
              projectid = _this.props.appContextProps.selectedItems.selectedProject._id;
              if (_this.state.selectedUserGroupId && projectid == _this.state.selectedProjectId) {
                usergroupid = _this.state.selectedUserGroupId;
              } else if (_this.props.appContextProps.selectedItems.selectedUserGroupId) usergroupid = _this.props.appContextProps.selectedItems.selectedUserGroupId;else
                //usergroupid = res.selectedUserGroupId;
                usergroupid = myUserGroups[myProjects[0]._id][0]._id;
            }
            selectUserGroupOptions = _this.getUserGroupOptions(projectid);
            _this.setState({
              selectedProjectId: projectid,
              showLoadButton: true,
              projectUserGroups: myUserGroups[projectid],
              userGroupOptions: selectUserGroupOptions,
              userGroupValue: _.find(selectUserGroupOptions, {
                value: usergroupid
              }),
              selectedUserGroupId: usergroupid,
              loadingModal: false
            });
            _context6.n = 6;
            break;
          case 5:
            _this.setState({
              loadingModal: false
            });
          case 6:
            return _context6.a(2);
        }
      }, _callee5);
    }));
    _this.saveChoice = function (configData) {
      sessionStorage.ipadt_configData = JSON.stringify(configData);
    };
    _this.clearSavedChoice = function () {
      delete sessionStorage.ipadt_configData;
    };
    _this.getInvites = function () {
      IafPassSvc.getUserInvites().then(function (invites) {
        _this.setState({
          invites: invites
        });
      });
    };
    _this.loadConfig = /*#__PURE__*/function () {
      var _ref6 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee6(userConfig) {
        var _this$props, testConfig, onConfigLoad, defaultConfig, latestUserConfigVersion, _userData, routes, _t2;
        return _regenerator().w(function (_context7) {
          while (1) switch (_context7.p = _context7.n) {
            case 0:
              _this$props = _this.props, testConfig = _this$props.testConfig, onConfigLoad = _this$props.onConfigLoad, defaultConfig = _this$props.defaultConfig;
              _context7.p = 1;
              if (!userConfig) {
                _context7.n = 3;
                break;
              }
              latestUserConfigVersion = _.find(userConfig._versions, {
                _version: userConfig._tipVersion
              });
              _userData = JSON.parse(latestUserConfigVersion._userData);
              _userData._id = userConfig._id;
              _context7.n = 2;
              return testConfig(_userData);
            case 2:
              routes = _context7.v;
              if (_this.state.remember) {
                _this.saveChoice(_userData);
              } else {
                _this.clearSavedChoice();
              }
              onConfigLoad(_userData, routes);
              _context7.n = 4;
              break;
            case 3:
              onConfigLoad(defaultConfig, testConfig(defaultConfig));
            case 4:
              _context7.n = 6;
              break;
            case 5:
              _context7.p = 5;
              _t2 = _context7.v;
              console.log(_t2);
              onConfigLoad(defaultConfig, testConfig(defaultConfig));
            case 6:
              return _context7.a(2);
          }
        }, _callee6, null, [[1, 5]]);
      }));
      return function (_x3) {
        return _ref6.apply(this, arguments);
      };
    }();
    _this.loadProject = /*#__PURE__*/function () {
      var _ref7 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee7(project) {
        var userConfigs, _this$state, projectUserGroups, selectedUserGroupId, selectedUserGroup;
        return _regenerator().w(function (_context8) {
          while (1) switch (_context8.n) {
            case 0:
              userConfigs = [];
              _this$state = _this.state, projectUserGroups = _this$state.projectUserGroups, selectedUserGroupId = _this$state.selectedUserGroupId;
              selectedUserGroup = _.filter(projectUserGroups, function (u) {
                return u._id === selectedUserGroupId;
              })[0];
              if (!selectedUserGroup && projectUserGroups) {
                selectedUserGroup = projectUserGroups[0];
              }
              if (selectedUserGroup) {
                _context8.n = 2;
                break;
              }
              _context8.n = 1;
              return IafProj.getUserConfigs(project, {
                _userType: _this.props.configUserType
              });
            case 1:
              userConfigs = _context8.v;
              _context8.n = 3;
              break;
            case 2:
              userConfigs.push(selectedUserGroup.userConfig);
            case 3:
              if (!userConfigs) {
                _context8.n = 4;
                break;
              }
              if (userConfigs.length > 1) {
                console.warn('There are ' + userConfigs.length + ' user configs found');
              }
              return _context8.a(2, _this.loadConfig(userConfigs[0]));
            case 4:
              return _context8.a(2, _this.loadConfig());
            case 5:
              return _context8.a(2);
          }
        }, _callee7);
      }));
      return function (_x4) {
        return _ref7.apply(this, arguments);
      };
    }();
    _this.onRememberChange = function (event) {
      _this.setState({
        remember: event.target.checked
      });
    };
    _this.onProjectPicked = /*#__PURE__*/function () {
      var _ref8 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee8(selectedOption) {
        var projectId, projects, projectUserGroups, selectedUserGroupId, selectUserGroupOptions;
        return _regenerator().w(function (_context9) {
          while (1) switch (_context9.n) {
            case 0:
              projectId = selectedOption.value;
              _this.setState({
                showLoadButton: false,
                projectUserGroups: [],
                userGroupOptions: []
              });
              projects = _this.state.projects;
              projectUserGroups = _this.state.appUserGroups[projectId];
              selectedUserGroupId = _this.state.appUserGroups[projectId][0]._id;
              selectUserGroupOptions = _this.getUserGroupOptions(projectId);
              _this.setState({
                selectedProjectId: projectId,
                showLoadButton: true,
                projectUserGroups: projectUserGroups,
                userGroupOptions: selectUserGroupOptions,
                userGroupValue: selectUserGroupOptions[0],
                selectedUserGroupId: selectedUserGroupId
              });
            case 1:
              return _context9.a(2);
          }
        }, _callee8);
      }));
      return function (_x5) {
        return _ref8.apply(this, arguments);
      };
    }();
    _this.onUserGroupPicked = function (selectedOption) {
      var selectedUserGroupId = selectedOption.value;
      _this.setState({
        selectedUserGroupId: selectedUserGroupId,
        userGroupValue: selectedOption
      });
      console.log("selectedOption", selectedOption);
      console.log("selectedUserGroupId", selectedUserGroupId);
      window.localStorage.setItem("selectedUserGroup", selectedOption.label);
      window.localStorage.setItem("selectedUserGroupId", selectedUserGroupId);
    };
    _this.submitProjSelection = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee9() {
      var _this$props2, appContextProps, projects, _iterator, _step, project, _this$props$reference2, currProject, _t3;
      return _regenerator().w(function (_context0) {
        while (1) switch (_context0.p = _context0.n) {
          case 0:
            _this$props2 = _this.props, appContextProps = _this$props2.appContextProps, projects = _this$props2.projects;
            _iterator = _createForOfIteratorHelper(projects);
            _context0.p = 1;
            _iterator.s();
          case 2:
            if ((_step = _iterator.n()).done) {
              _context0.n = 7;
              break;
            }
            project = _step.value;
            if (!(project._id === _this.state.selectedProjectId)) {
              _context0.n = 6;
              break;
            }
            _context0.n = 3;
            return IafProj.switchProject(project._id);
          case 3:
            _context0.n = 4;
            return IafProj.getCurrent();
          case 4:
            currProject = _context0.v;
            _context0.n = 5;
            return _this.loadProject(project);
          case 5:
            sessionStorage.setItem(PROJECT_ID_KEY, project._id);
            appContextProps.actions.setSelectedItems({
              selectedProject: currProject,
              selectedUserGroupId: _this.state.selectedUserGroupId
            });
            window.location.hash = '/'; //Since we're outside the react router scope, we need to deal with the location object directly

            if ((_this$props$reference2 = _this.props.referenceAppConfig) !== null && _this$props$reference2 !== void 0 && _this$props$reference2.refApp) {
              window.history.replaceState({}, document.title, window.location.pathname + window.location.hash);
            }
            return _context0.a(2);
          case 6:
            _context0.n = 2;
            break;
          case 7:
            _context0.n = 9;
            break;
          case 8:
            _context0.p = 8;
            _t3 = _context0.v;
            _iterator.e(_t3);
          case 9:
            _context0.p = 9;
            _iterator.f();
            return _context0.f(9);
          case 10:
            return _context0.a(2);
        }
      }, _callee9, null, [[1, 8, 9, 10]]);
    }));
    _this.acceptInvite = function (invite) {
      var inviteStatus = _objectSpread2({}, _this.state.inviteStatus);
      inviteStatus[invite._id] = "Accepting...";
      _this.setState({
        inviteStatus: inviteStatus
      });
      IafUserGroup.addUserToGroupByInvite(invite._usergroup, invite).then(function (r) {
        _this.updateInviteStatus(invite, "Accepted");
        _this.props.onAcceptInvite();
      })["catch"](function (e) {
        return _this.inviteFailed(invite, e);
      });
    };
    _this.rejectInvite = function (invite) {
      var inviteStatus = _objectSpread2({}, _this.state.inviteStatus);
      inviteStatus[invite._id] = "Rejecting...";
      _this.setState({
        inviteStatus: inviteStatus
      });
      // console.log(invite)
      IafUserGroup.rejectInvite(invite._usergroup, invite._id).then(function (r) {
        return _this.updateInviteStatus(invite, "Rejected");
      })["catch"](function (e) {
        return _this.inviteFailed(e);
      });
    };
    _this.updateInviteStatus = function (invite, status) {
      var invites = _this.state.invites.filter(function (inv) {
        return inv._id != invite._id;
      });
      var inviteStatus = _objectSpread2({}, _this.state.inviteStatus);
      inviteStatus[invite._id] = status;
      _this.setState({
        invites: invites,
        inviteStatus: inviteStatus
      });
    };
    _this.inviteFailed = function (invite, e) {
      console.error(e);
      var inviteStatus = _objectSpread2({}, _this.state.inviteStatus);
      inviteStatus[invite._id] = "Failed: " + e.message;
      _this.setState({
        invites: invites,
        inviteStatus: inviteStatus
      });
    };
    _this.state = {
      loadingModal: true,
      projects: [],
      appUserGroups: [],
      selectedProjectId: null,
      userGroupOptions: [],
      selectedUserGroupId: null,
      remember: true,
      projectUserGroups: [],
      showLoadButton: false,
      inviteStatus: {}
    };
    _this.getUserGroupOptions = _this.getUserGroupOptions.bind(_this);
    return _this;
  }
  _inherits(ProjectPickerModal, _React$Component);
  return _createClass(ProjectPickerModal, [{
    key: "render",
    value: function render() {
      var _this$props$reference3,
        _this2 = this,
        _this$props$reference4,
        _this$props$reference5,
        _this$props$reference6,
        _this$props$reference7,
        _this$props$reference8,
        _this$state$user,
        _this$props$reference9,
        _this$state$user2,
        _this$props$reference0,
        _this$props$reference1;
      var _this$props3 = this.props,
        appContextProps = _this$props3.appContextProps,
        onCancel = _this$props3.onCancel;
      var _this$state2 = this.state,
        projects = _this$state2.projects,
        remember = _this$state2.remember,
        projectUserGroups = _this$state2.projectUserGroups,
        showLoadButton = _this$state2.showLoadButton,
        invites = _this$state2.invites;
      var loadBtn = showLoadButton ? /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", {
        className: "custom-control custom-switch",
        style: {
          marginTop: '15px',
          zIndex: '0'
        }
      }, /*#__PURE__*/React.createElement("input", {
        type: "checkbox",
        className: "custom-control-input",
        id: "remswitch",
        value: remember,
        checked: remember,
        onChange: this.onRememberChange.bind(this)
      }), /*#__PURE__*/React.createElement("label", {
        className: "custom-control-label",
        htmlFor: "remswitch"
      }, "Remember my choice")), /*#__PURE__*/React.createElement("div", {
        className: "button-container"
      }, ((_this$props$reference3 = this.props.referenceAppConfig) === null || _this$props$reference3 === void 0 ? void 0 : _this$props$reference3.refApp) && /*#__PURE__*/React.createElement("button", {
        onClick: function onClick() {
          return _this2.props.userLogout();
        },
        className: (_this$props$reference4 = this.props.referenceAppConfig) !== null && _this$props$reference4 !== void 0 && _this$props$reference4.refApp ? "cancel" : "default-cancel"
      }, "Logout"), /*#__PURE__*/React.createElement("button", {
        onClick: onCancel,
        className: (_this$props$reference5 = this.props.referenceAppConfig) !== null && _this$props$reference5 !== void 0 && _this$props$reference5.refApp ? "cancel" : "default-cancel"
      }, "Cancel"), /*#__PURE__*/React.createElement("button", {
        onClick: this.submitProjSelection,
        className: (_this$props$reference6 = this.props.referenceAppConfig) !== null && _this$props$reference6 !== void 0 && _this$props$reference6.refApp ? "load" : "default-load"
      }, "Load Project"), ((_this$props$reference7 = this.props.referenceAppConfig) === null || _this$props$reference7 === void 0 ? void 0 : _this$props$reference7.refApp) && /*#__PURE__*/React.createElement("button", {
        onClick: function onClick() {
          return _this2.props.referenceAppCreateProject();
        },
        className: "setup"
      }, "Create Project"))) : /*#__PURE__*/React.createElement("div", {
        className: "spinningLoadingIcon projectLoadingIcon"
      });
      //TODO handle user modal manual close -> load default config
      var selectProjectOptions = !projects || projects.length == 0 ? [{
        value: 'none',
        label: ''
      }] : projects.map(function (project) {
        return {
          'value': project._id,
          'label': project._name
        };
      });

      //We don't want to always set the selects to the first option.
      //We want to be able to display the last choices the user made in the dialog.
      //So we default to the first option, but if we find selectedItems in the appContext we use them
      //to open the dialog with settings they last chose
      var defaultProjectOption = selectProjectOptions[0];
      if (this.state.selectedProjectId) defaultProjectOption = _.find(selectProjectOptions, {
        value: this.state.selectedProjectId
      });
      var currentInvites = invites && invites.filter(function (inv) {
        return inv._status == "PENDING";
      });
      var expiredInvites = invites && invites.filter(function (inv) {
        return inv._status == "EXPIRED";
      });
      var buildInviteTable = function buildInviteTable(invites, expired) {
        return /*#__PURE__*/React.createElement(SimpleTable, {
          className: "invite-table",
          header: expired ? ["", "Expired Invites", "Role", ""] : ["", "Project", "Role", ""],
          rows: invites.map(function (inv) {
            var status = _this2.state.inviteStatus[inv._id];
            var statusOrButtons = status ? /*#__PURE__*/React.createElement("span", {
              className: "invite-state-" + status.toLowerCase()
            }, status) : /*#__PURE__*/React.createElement("div", null, expired ? "" : /*#__PURE__*/React.createElement("span", {
              className: "invite-action",
              onClick: function onClick(e) {
                return _this2.acceptInvite(inv);
              }
            }, /*#__PURE__*/React.createElement("i", {
              className: "fa fa-check"
            }), " Accept Invite"), /*#__PURE__*/React.createElement("span", {
              className: "invite-action",
              onClick: function onClick(e) {
                return _this2.rejectInvite(inv);
              }
            }, /*#__PURE__*/React.createElement("i", {
              className: "fa fa-times"
            }), " ", expired ? "Remove" : "Reject", " Invite"));
            return [/*#__PURE__*/React.createElement("span", null, "\u2022"), inv._params.name, inv._usergroup._name, statusOrButtons];
          })
        });
      };
      var title = /*#__PURE__*/React.createElement("span", null, "Project Selection");
      return /*#__PURE__*/React.createElement(GenericModal, {
        title: title,
        modalBody: /*#__PURE__*/React.createElement("div", {
          className: "project-picker-modal"
        }, !this.state.loadingModal && (!projects || projects.length === 0) && /*#__PURE__*/React.createElement("div", null, "You are not yet a member of any projects, please", (!currentInvites || currentInvites.length === 0) && /*#__PURE__*/React.createElement("span", null, " contact your project admin for an invite"), ((_this$props$reference8 = this.props.referenceAppConfig) === null || _this$props$reference8 === void 0 ? void 0 : _this$props$reference8.refApp) && ((_this$state$user = this.state.user) === null || _this$state$user === void 0 ? void 0 : _this$state$user.has_access) && /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("button", {
          onClick: function onClick() {
            return _this2.props.referenceAppCreateProject();
          },
          className: "setup"
        }, "Create Project"), /*#__PURE__*/React.createElement("button", {
          onClick: function onClick() {
            return _this2.props.userLogout();
          }
        }, "Logout")), currentInvites && currentInvites.length > 0 && /*#__PURE__*/React.createElement("span", null, " accept an invite")), this.state.loadingModal && /*#__PURE__*/React.createElement(SimpleTextThrobber, {
          throbberText: "Loading your project information"
        }), (_this$props$reference9 = this.props.referenceAppConfig) !== null && _this$props$reference9 !== void 0 && _this$props$reference9.refApp && !showLoadButton && !this.state.loadingModal && !((_this$state$user2 = this.state.user) !== null && _this$state$user2 !== void 0 && _this$state$user2.has_access) ? /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("span", {
          className: "text-danger"
        }, "You don't have permission to create a project in the Reference App. Please contact the Admin.")), /*#__PURE__*/React.createElement("button", {
          onClick: function onClick() {
            return _this2.props.userLogout();
          }
        }, "Logout")) : /*#__PURE__*/React.createElement(React.Fragment, null), /*#__PURE__*/React.createElement("div", null, currentInvites && currentInvites.length > 0 && /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("h4", null, "You have pending invitations:"), buildInviteTable(currentInvites, false)), expiredInvites && expiredInvites.length > 0 && /*#__PURE__*/React.createElement("div", null, buildInviteTable(expiredInvites, true))), !this.state.loadingModal && projects && projects.length > 0 && /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("h4", null, "Project"), /*#__PURE__*/React.createElement(Select, {
          name: "projectSelect",
          options: selectProjectOptions,
          defaultValue: defaultProjectOption,
          className: (_this$props$reference0 = this.props.referenceAppConfig) !== null && _this$props$reference0 !== void 0 && _this$props$reference0.refApp ? "custom-single-class" : "basic-single",
          classNamePrefix: "select",
          placeholder: 'Select Project...',
          onChange: this.onProjectPicked.bind(this),
          isDisabled: !showLoadButton,
          isSearchable: false,
          menuPosition: "fixed"
        }), projectUserGroups && projectUserGroups.length > 1 && /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("h4", null, "User Group"), /*#__PURE__*/React.createElement(Select, {
          name: "userGroupSelect",
          options: this.state.userGroupOptions,
          value: this.state.userGroupValue,
          className: (_this$props$reference1 = this.props.referenceAppConfig) !== null && _this$props$reference1 !== void 0 && _this$props$reference1.refApp ? "custom-single-class" : "basic-single",
          classNamePrefix: "select",
          placeholder: 'Select User Group...',
          onChange: this.onUserGroupPicked.bind(this),
          isSearchable: false,
          menuPosition: "fixed"
        })), loadBtn))
      });
    }
  }]);
}(React.Component);

var SetUpProject = /*#__PURE__*/function (_React$Component) {
  function SetUpProject(props) {
    var _this;
    _classCallCheck(this, SetUpProject);
    _this = _callSuper(this, SetUpProject, [props]);
    _this.handleInputChange = function (e) {
      var _e$target = e.target,
        id = _e$target.id,
        value = _e$target.value;
      _this.setState({
        project: _objectSpread2(_objectSpread2({}, _this.state.project), {}, _defineProperty({}, id, value))
      });
    };
    _this.handleToggleMultiModel = function () {
      _this.setState({
        multiModel: !_this.state.multiModel
      });
      _this.setMultiModel();
    };
    _this.setMultiModel = function () {
      _this.setState(function (prevState) {
        return {
          project: _objectSpread2(_objectSpread2({}, prevState.project), {}, {
            _userAttributes: _objectSpread2(_objectSpread2({}, prevState.project._userAttributes), {}, {
              multiModel: !prevState.project._userAttributes.multiModel
            })
          })
        };
      });
    };
    _this.handleClickOpen = function () {
      _this.setState({
        open: true
      });
    };
    _this.handleProjectSetUp = /*#__PURE__*/function () {
      var _ref = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3(e, restartApp) {
        var project, ctx, div, runOrchestrator, _runOrchestrator, _t2;
        return _regenerator().w(function (_context3) {
          while (1) switch (_context3.n) {
            case 0:
              _runOrchestrator = function _runOrchestrator3() {
                _runOrchestrator = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2() {
                  var orchRunCtx, orchestratorConfig, projOrchList, runSetupOrch, datasourceRunRequest, orchRun, orchReqForRes, startTime, map_orch_timer;
                  return _regenerator().w(function (_context2) {
                    while (1) switch (_context2.n) {
                      case 0:
                        //removing authToken from ctx for orchrun
                        orchRunCtx = Object.fromEntries(Object.entries(ctx).filter(function (_ref2) {
                          var _ref3 = _slicedToArray(_ref2, 1),
                            key = _ref3[0];
                          return key !== 'authToken';
                        }));
                        console.log('orchRunCtx: ', orchRunCtx);
                        _context2.n = 1;
                        return IafScriptEngine.addDatasource({
                          _name: "Setup Project",
                          _description: "Run all scripts needed for setup",
                          _namespaces: ctx._namespaces,
                          _userType: "setup_runner",
                          _params: {
                            tasks: [
                            // the ordered list of steps that are a part of the orchestrator
                            {
                              _sequenceno: 1,
                              _name: "Adding Project Datasources:",
                              _orchcomp: "default_script_target",
                              _actualparams: {
                                userType: "addDataSources",
                                _scriptName: "addDataSources" // the named script to run in the file above
                              }
                            }, {
                              _sequenceno: 2,
                              _name: "Uploading User Scripts:",
                              _orchcomp: "default_script_target",
                              _actualparams: {
                                userType: "uploadRunnableScripts",
                                _scriptName: "uploadScripts" // the named script to run in the file above
                              }
                            }, {
                              _sequenceno: 3,
                              _name: "Creating User Configurations:",
                              _orchcomp: "default_script_target",
                              _actualparams: {
                                userType: "configUpload",
                                _scriptName: "userConifgImports" // the named script to run in the file above
                              }
                            }, {
                              _sequenceno: 4,
                              _name: "Uploading Model File:",
                              _orchcomp: "default_script_target",
                              _actualparams: {
                                userType: "uploadBimpk",
                                _scriptName: "bimpkOperations" // the named script to run in the file above
                              }
                            }, {
                              _sequenceno: 5,
                              _name: "Importing Bimpk",
                              _orchcomp: "default_script_target",
                              _actualparams: {
                                userType: "iaf_import_model",
                                _scriptName: "importModels" // the named script to run in the file above
                              }
                            }, {
                              _sequenceno: 6,
                              _name: "Creating Collections:",
                              _orchcomp: "default_script_target",
                              _actualparams: {
                                userType: "createCollections",
                                _scriptName: "createCollections" // the named script to run in the file above
                              }
                            }, {
                              _sequenceno: 7,
                              _name: "Mapping Revit Collection:",
                              _orchcomp: "default_script_target",
                              _actualparams: {
                                userType: "iaf_map_elms_type",
                                _scriptName: "mapRevitTypeCollections" // the named script to run in the file above
                              }
                            }, {
                              _sequenceno: 8,
                              _name: "Creating Other Collections:",
                              _orchcomp: "default_script_target",
                              _actualparams: {
                                userType: "createOtherCollections",
                                _scriptName: "createOtherCollections" // the named script to run in the file above
                              }
                            }, {
                              _sequenceno: 9,
                              _name: "Importing File Attributes:",
                              _orchcomp: "default_script_target",
                              _actualparams: {
                                userType: "fileAttributesImport",
                                _scriptName: "fileAttributesImport" // the named script to run in the file above
                              }
                            }, {
                              _sequenceno: 10,
                              _name: "Importing OMAPI Configurations:",
                              _orchcomp: "default_script_target",
                              _actualparams: {
                                userType: "apiConfigImport",
                                _scriptName: "apiConfigImport" // the named script to run in the file above
                              }
                            }]
                          }
                        }, orchRunCtx);
                      case 1:
                        orchestratorConfig = _context2.v;
                        console.log(orchestratorConfig);

                        //Fetch created orchestrator
                        _context2.n = 2;
                        return IafDataSource.getOrchestrators({}, ctx);
                      case 2:
                        projOrchList = _context2.v;
                        console.log(projOrchList);
                        runSetupOrch = projOrchList._list.find(function (o) {
                          return o._userType === "setup_runner";
                        });
                        console.log(runSetupOrch);
                        datasourceRunRequest = {
                          orchestratorId: runSetupOrch.id,
                          _actualparams: [{
                            // an array of the parameters we want to pass to each step when the orchestrator runs
                            sequence_type_id: runSetupOrch.orchsteps[0]._compid,
                            // in this case we only have one step so its always at index 0
                            params: {
                              ctx: JSON.stringify(orchRunCtx),
                              project: project,
                              zipLink: endPointConfig.projectZipFileOrigin
                            }
                          }]
                        }; // run the orchestrator - this returns an orchestrator run item that indicates the orchestrator has been 'QUEUED'
                        _context2.n = 3;
                        return IafDataSource.runOrchestrator(runSetupOrch.id, datasourceRunRequest, orchRunCtx);
                      case 3:
                        orchRun = _context2.v;
                        console.log("orchRun", orchRun);

                        //Get Orchestrator Status
                        orchReqForRes = {
                          runid: orchRun.id
                        };
                        console.log("handleProjectSetUp === orchReqForRes", orchReqForRes);

                        //Check status afetr every 10 seconds
                        startTime = Date.now();
                        map_orch_timer = setInterval(/*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
                          var status, endTime, diffInSeconds, messageArray, sequencedOrchSteps, _t;
                          return _regenerator().w(function (_context) {
                            while (1) switch (_context.n) {
                              case 0:
                                _context.n = 1;
                                return IafScriptEngine.getDatasourceRunStatus(orchReqForRes, orchRunCtx);
                              case 1:
                                status = _context.v;
                                status = status.find(function (f) {
                                  return f._usertype == "setup_runner";
                                });
                                console.log("SetupProject Run Status", status);
                                _t = status._status;
                                _context.n = _t === "COMPLETED" ? 2 : _t === "RUNNING" ? 3 : _t === "ERROR" ? 4 : 5;
                                break;
                              case 2:
                                console.log("COMPLETED SetupProject", status);
                                clearInterval(map_orch_timer);
                                console.log("handleProjectSetUp === done");
                                div.style.display = "none";
                                document.getElementById("donebtn").style.display = "block";
                                return _context.a(3, 6);
                              case 3:
                                endTime = Date.now();
                                diffInSeconds = (endTime - startTime) / 1000;
                                console.log("Project setup running since ".concat((diffInSeconds / 60).toFixed(2), " minutes."));
                                messageArray = [];
                                sequencedOrchSteps = status.orchrunsteps.sort(function (a, b) {
                                  return a._sequenceno - b._sequenceno;
                                });
                                messageArray = sequencedOrchSteps.map(function (x) {
                                  return x._name + "   " + x._status;
                                });
                                div.style.display = "block";
                                div.innerHTML = "";
                                messageArray.forEach(function (x) {
                                  var _x$split = x.split("   "),
                                    _x$split2 = _slicedToArray(_x$split, 2),
                                    name = _x$split2[0],
                                    status = _x$split2[1];
                                  div.innerHTML += "<div style=\"display:flex; flex-direction:row; justify-content: space-between;\"><p style=\"font-size: 15px; margin:1px; padding-left:5px\">".concat(name, "</p><p style=\"font-size: 15px; margin:1px; padding-right:5px\">").concat(status, "</p></div>");
                                });
                                return _context.a(3, 6);
                              case 4:
                                clearInterval(map_orch_timer);
                                div.style.display = "block";
                                div.innerHTML = "Setup did not complete. An error occured during setup!";
                                div.style.color = "red";
                                document.getElementById("backbtn").style.display = "block";
                                return _context.a(3, 6);
                              case 5:
                                div.style.display = "block";
                                div.innerHTML = "Setup is in progress, please wait...";
                                return _context.a(3, 6);
                              case 6:
                                return _context.a(2);
                            }
                          }, _callee);
                        })), 10000);
                      case 4:
                        return _context2.a(2);
                    }
                  }, _callee2);
                }));
                return _runOrchestrator.apply(this, arguments);
              };
              runOrchestrator = function _runOrchestrator2() {
                return _runOrchestrator.apply(this, arguments);
              };
              _this.setState({
                editableTextInputs: false
              });
              console.log("called"); // console to know function is called
              e.preventDefault();
              //check multiple projects are allowed, if not delete previous project
              _t2 = !_this.props.allowMultipleProjects;
              if (!_t2) {
                _context3.n = 1;
                break;
              }
              _context3.n = 1;
              return _this.deletePreviousProject();
            case 1:
              _this.setState({
                click: true,
                open: false
              });
              _context3.n = 2;
              return IafProj.createProject(_this.state.project);
            case 2:
              project = _context3.v;
              //Create Project
              _this.setState({
                createdProject: project
              });
              console.log("project", project);
              ctx = {
                _namespaces: project._list[0]._namespaces
              };
              ctx.authToken = IafSession.getAuthToken();
              div = document.getElementById("msg"); //div selector
              _context3.n = 3;
              return IafProj.switchProject(project._list[0]._id);
            case 3:
              _context3.n = 4;
              return _this.createScripts(project, ctx);
            case 4:
              _context3.n = 5;
              return runOrchestrator();
            case 5:
              return _context3.a(2);
          }
        }, _callee3);
      }));
      return function (_x, _x2) {
        return _ref.apply(this, arguments);
      };
    }();
    console.log("endPointConfig", endPointConfig);
    console.log("props", props);
    _this.state = {
      createdProject: null,
      editableTextInputs: true,
      project: {
        _description: "",
        _name: "",
        _shortName: "",
        _userAttributes: {
          nextScriptEngine: true,
          multiModel: false,
          refAppProj: true
        },
        click: false
      },
      projects: [],
      ProjSetupModule: undefined,
      scripts: undefined,
      open: false,
      isDeleting: false,
      isDoneButtonClicked: false,
      isBackButtonClicked: false,
      multiModel: false
    };
    _this.ref = /*#__PURE__*/React.createRef();
    return _this;
  }
  _inherits(SetUpProject, _React$Component);
  return _createClass(SetUpProject, [{
    key: "deletePreviousProject",
    value: function () {
      var _deletePreviousProject = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4() {
        var projects, user, i, _projects$i$_userAttr, _t3;
        return _regenerator().w(function (_context4) {
          while (1) switch (_context4.p = _context4.n) {
            case 0:
              projects = this.props.projects;
              this.setState({
                isDeleting: true
              });
              _context4.n = 1;
              return IafPassSvc.getCurrentUser();
            case 1:
              user = _context4.v;
              _context4.p = 2;
              if (!(projects !== undefined)) {
                _context4.n = 7;
                break;
              }
              i = 0;
            case 3:
              if (!(i < projects.length)) {
                _context4.n = 7;
                break;
              }
              if (!(projects[i]._metadata._createdById === user._id && (_projects$i$_userAttr = projects[i]._userAttributes) !== null && _projects$i$_userAttr !== void 0 && _projects$i$_userAttr.refAppProj)) {
                _context4.n = 5;
                break;
              }
              console.log("Delete project:", projects[i]);
              _context4.n = 4;
              return IafProj["delete"](projects[i]);
            case 4:
              _context4.n = 6;
              break;
            case 5:
              console.log("Cannot delete invited project");
            case 6:
              i++;
              _context4.n = 3;
              break;
            case 7:
              _context4.n = 9;
              break;
            case 8:
              _context4.p = 8;
              _t3 = _context4.v;
              console.log("Some items being deleted in the old project do not exist.");
            case 9:
              this.setState({
                isDeleting: false
              });
            case 10:
              return _context4.a(2);
          }
        }, _callee4, this, [[2, 8]]);
      }));
      function deletePreviousProject() {
        return _deletePreviousProject.apply(this, arguments);
      }
      return deletePreviousProject;
    }()
  }, {
    key: "createScripts",
    value: function () {
      var _createScripts = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee5(projectList, ctx) {
        var project, scriptsDescriptors, myZipFile, zipFileObj, scriptFiles, scripts, scriptNames, i, scriptName, scriptContent, scriptItems, createScriptRes;
        return _regenerator().w(function (_context5) {
          while (1) switch (_context5.n) {
            case 0:
              project = projectList._list[0];
              scriptsDescriptors = [{
                _name: "Upload Scripts",
                _shortName: "uploadRunnableScripts",
                _description: "Upload all Scripts",
                _userType: "uploadRunnableScripts"
              }, {
                _name: "User Config Import",
                _shortName: "configUpload",
                _description: "Upload config files",
                _userType: "configUpload"
              }, {
                _name: "Upload bimpk file",
                _shortName: "uploadBimpk",
                _description: "Upload and extract bimpk files",
                _userType: "uploadBimpk"
              }, {
                _name: "Create Collections",
                _shortName: "createCollections",
                _description: "Create collections",
                _userType: "createCollections"
              }, {
                _name: "Create Other Collections",
                _shortName: "createOtherCollections",
                _description: "Create Other collections",
                _userType: "createOtherCollections"
              }, {
                _name: "Import File Attributes",
                _shortName: "fileAttributesImport",
                _description: "Import File Attributes",
                _userType: "fileAttributesImport"
              }, {
                _name: "Import Api Config",
                _shortName: "apiConfigImport",
                _description: "Import Api Config File",
                _userType: "apiConfigImport"
              }, {
                _name: "Add Project DataSources",
                _shortName: "addDataSources",
                _description: "Add Project DataSources",
                _userType: "addDataSources"
              }]; //Fetch Zip
              _context5.n = 1;
              return fetch("".concat(endPointConfig.setupZipFileOrigin)) //fetch zip file using link
              .then(function (response) {
                return response.blob();
              }).then(function (blob) {
                // Store the binary blob in a variable
                myZipFile = new Blob([blob], {
                  type: "application/zip"
                });
              })["catch"](function (error) {
                console.error(error);
              });
            case 1:
              zipFileObj = {
                //object of zip file to passed on _loadZipFile
                fileObj: myZipFile
              };
              _context5.n = 2;
              return IafLocalFile._loadZipFile(zipFileObj);
            case 2:
              scriptFiles = _context5.v;
              //load all files using scriptFiles
              console.log("scriptFiles", scriptFiles);
              scripts = [];
              scriptNames = ["uploadRunnableScripts", "configUpload", "uploadBimpk", "createCollections", "createOtherCollections", "fileAttributesImport", "apiConfigImport", "addDataSources"];
              i = 0;
            case 3:
              if (!(i < scriptNames.length)) {
                _context5.n = 6;
                break;
              }
              scriptName = scriptNames[i];
              _context5.n = 4;
              return scriptFiles.files["setupScripts/".concat(scriptName, ".js")].async("string");
            case 4:
              scriptContent = _context5.v;
              scripts.push({
                scriptName: scriptName,
                scriptContent: scriptContent
              });
            case 5:
              i++;
              _context5.n = 3;
              break;
            case 6:
              //* Adding more information like version and namesapce
              scriptItems = [];
              scripts.forEach(function (c) {
                var item = scriptsDescriptors.find(function (obj) {
                  return obj._shortName === c.scriptName;
                });
                if (item) {
                  //TODO: use javascript stringify, not JSON stringify
                  item._version = {
                    _userData: c.scriptContent
                  };
                  item._namespaces = project._namespaces;
                  scriptItems.push(item);
                }
              });
              console.log("Script items with information.", scriptItems);

              //* Creating script in project
              //TODO: create scripts
              _context5.n = 7;
              return IafScripts.create(scriptItems, ctx);
            case 7:
              createScriptRes = _context5.v;
              console.log("Scripts are Created", createScriptRes);
            case 8:
              return _context5.a(2);
          }
        }, _callee5);
      }));
      function createScripts(_x3, _x4) {
        return _createScripts.apply(this, arguments);
      }
      return createScripts;
    }()
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var title = /*#__PURE__*/React.createElement("span", null, "Setup Project");
      return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(GenericModal, {
        title: title,
        modalBody: /*#__PURE__*/React.createElement("div", {
          className: "project-picker-modal"
        }, !this.state.open && /*#__PURE__*/React.createElement("form", {
          style: {
            width: "100%"
          },
          onSubmit: !this.props.allowMultipleProjects ? this.handleClickOpen : this.handleProjectSetUp
        }, /*#__PURE__*/React.createElement("div", {
          style: {
            margin: "9px 0"
          }
        }, /*#__PURE__*/React.createElement("label", null, "Name"), /*#__PURE__*/React.createElement(mobiscroll.Input, {
          style: {
            width: "100%"
          },
          id: "_name",
          type: "text",
          placeholder: "Name",
          name: "_name",
          required: true,
          value: this.state.project._name,
          onChange: this.handleInputChange,
          disabled: !this.state.editableTextInputs
        })), /*#__PURE__*/React.createElement("div", {
          style: {
            margin: "9px 0"
          }
        }, /*#__PURE__*/React.createElement("label", null, "Short Name"), /*#__PURE__*/React.createElement(mobiscroll.Input, {
          style: {
            width: "100%"
          },
          id: "_shortName",
          type: "text",
          placeholder: "Short Name",
          name: "_shortName",
          pattern: "^.{1,22}$",
          title: "Enter a short name less than 22 characters",
          required: true,
          value: this.state.project._shortName,
          onChange: this.handleInputChange,
          disabled: !this.state.editableTextInputs
        })), /*#__PURE__*/React.createElement("div", {
          style: {
            margin: "9px 0"
          }
        }, /*#__PURE__*/React.createElement("label", null, "Description"), /*#__PURE__*/React.createElement(mobiscroll.Input, {
          style: {
            width: "100%"
          },
          id: "_description",
          type: "text",
          placeholder: "Name",
          name: "_description",
          required: true,
          value: this.state.project._description,
          onChange: this.handleInputChange,
          disabled: !this.state.editableTextInputs
        })), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", {
          style: {
            marginTop: '16px',
            zIndex: '0'
          }
        }, /*#__PURE__*/React.createElement("label", {
          style: {
            marginRight: '8px'
          }
        }, "Enable multiple model support"), /*#__PURE__*/React.createElement("input", {
          type: "checkbox",
          value: this.state.multiModel,
          checked: this.state.multiModel,
          onChange: this.handleToggleMultiModel,
          disabled: !this.state.editableTextInputs
        }))), /*#__PURE__*/React.createElement("div", {
          style: {
            display: "flex",
            justifyContent: "space-between",
            alignItems: "center",
            width: "100%"
          }
        }, this.state.click ? /*#__PURE__*/React.createElement("div", {
          style: {
            display: "flex",
            flexDirection: "column",
            alignItems: "center",
            margin: "auto",
            width: "100%"
          }
        }, /*#__PURE__*/React.createElement("div", {
          id: "msg",
          style: {
            display: "none",
            minWidth: "100%",
            marginTop: "10px",
            padding: "15px",
            overflowY: "auto",
            maxHeight: "95px",
            backgroundColor: "#EEEEEE"
          }
        }), /*#__PURE__*/React.createElement("button", {
          id: "donebtn",
          style: {
            display: "none",
            minWidth: "100px"
          },
          onClick: function onClick() {
            _this2.setState({
              isDoneButtonClicked: true
            });
            _this2.props.restartApp();
          },
          className: "done"
        }, "Done"), /*#__PURE__*/React.createElement("button", {
          id: "backbtn",
          style: {
            display: "none",
            minWidth: "100px"
          },
          onClick: function onClick() {
            _this2.setState({
              isBackButtonClicked: true
            });
            _this2.props.restartApp();
          },
          className: "restart"
        }, "Back")) : /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("button", {
          onClick: function onClick() {
            return _this2.props.restartApp();
          },
          className: "load"
        }, "Cancel"), /*#__PURE__*/React.createElement("button", {
          type: "submit",
          className: "load"
        }, "Set up")))), this.state.open && !this.state.isDeleting && !this.state.isDoneButtonClicked && !this.state.isBackButtonClicked && /*#__PURE__*/React.createElement("div", {
          style: {
            "float": "left"
          }
        }, "By Clicking on Agree button, the previously created projects by you would be deleted and this new project would be created.", /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("button", {
          onClick: function onClick() {
            return _this2.props.restartApp();
          },
          style: {
            "float": "left"
          }
        }, "Disagree"), /*#__PURE__*/React.createElement("button", {
          onClick: this.handleProjectSetUp,
          style: {
            "float": "left"
          },
          autoFocus: true
        }, "Agree"))))
      }));
    }
  }]);
}(React.Component);

var PopoverMenuView = function PopoverMenuView(_ref) {
  var actions = _ref.actions;
  return /*#__PURE__*/React.createElement("div", {
    className: "content"
  }, /*#__PURE__*/React.createElement("ul", {
    className: "asf-popover-menu"
  }, actions.map(function (item, index) {
    return /*#__PURE__*/React.createElement("li", _extends({
      className: "item-icon-right",
      key: index,
      onClick: item.onClick
    }, item), /*#__PURE__*/React.createElement("a", null, item.title), /*#__PURE__*/React.createElement(IfefIcon, {
      icon: "ios-arrow-right"
    }));
  })));
};

var css_248z$2 = ".generic-page-body {\n  background-color: #ffffff;\n  position: relative;\n  min-height: calc(100vh - 80px);\n}\n\n.vAlignCenter {\n  top: 50%;\n  left: 50%;\n}";
styleInject(css_248z$2);

var URL_LENGTH_WARNING = 80000;
var withGenericPage = function withGenericPage(PageComponent) {
  var optionalProps = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var GenericPage = /*#__PURE__*/function (_React$Component) {
    function GenericPage(props) {
      var _this;
      _classCallCheck(this, GenericPage);
      _this = _callSuper(this, GenericPage, [props]);
      _this.setQueryParams = function (partial) {
        return _this.setState({
          queryParams: _objectSpread2(_objectSpread2({}, _this.state.queryParams), partial)
        });
      };
      //provide pageComponents with a navigate function to place query criteria in the url to pass to other pages
      _this.onNavigateOut = function (userConfig, genericQueryParams, validator, history) {
        return function (destinationHandler, selectionInfo) {
          var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
          /*
           * handler: the name of a handler to navigate to
           *
           * selectionInfo:
           * {
           *    entityType: 'Asset',
           *    selectedEntities: [<array of entity ids>]
           * }
           *
           * Note: query, group and filter are handled by the GenericPage itself (this class).
           *       Call setQueryParams method from the child page.
           *       The queryParams can be overridden by providing queryParams in selectionInfo
           *
           */

          if (!destinationHandler || !Object.keys(userConfig.handlers).includes(destinationHandler)) {
            console.error('Attempting to navigate without a valid destination handler:', destinationHandler);
            return false;
          }
          if (!validator(selectionInfo)) {
            console.error('Attempting to navigate invalid query parameters!');
            return false;
          }
          var newPath;
          if (!selectionInfo && !genericQueryParams.query) {
            newPath = _this.props.userConfig.handlers[destinationHandler].path;
          } else {
            var query = Object.assign({}, genericQueryParams);

            //override the pages queryParams if the selectionInfo also provides queryParams
            if (selectionInfo.queryParams) {
              query = Object.assign(query, selectionInfo.queryParams);
            }
            if (selectionInfo) {
              query.entityType = selectionInfo.entityType;
            }

            //if query has an array which represents the total entities to be fetched (not highlighted) turn it into a string
            //if its not an array leave as is as then it represents settings for a fetch control
            if (query.query && query.query.value && !query.query.id && query.query.id !== 0) query.query.value = Array.isArray(query.query.value) ? query.query.value.join(',') : query.query.value;
            if (selectionInfo && selectionInfo.selectedEntities && selectionInfo.selectedEntities.length > 0) {
              query.selectedEntities = selectionInfo.selectedEntities.join(',');
              query.entityType = selectionInfo.entityType;
              query.script = selectionInfo.script;
            } else if (query.selectedEntities && Array.isArray(query.selectedEntities) && query.selectedEntities.length > 0) {
              query.selectedEntities = query.selectedEntities.join(',');
            }
            if (query.groups && query.groups.length) {
              query.groups = query.groups.join(',');
            }
            newPath = userConfig.handlers[destinationHandler].path + '?' + qs.stringify(query);
          }

          // console.log('url sizes: ', urlSizeUtf8Chrome, urlSizeUtf16Chrome, urlLengthEdge);
          if (newPath.length > URL_LENGTH_WARNING) console.warn('url length is very large and navigation may not work!');
          if (options.newTab === true) {
            var _window$open;
            (_window$open = window.open("".concat(endPointConfig.baseRoot, "/#").concat(newPath), '_blank')) === null || _window$open === void 0 || _window$open.focus();
          } else {
            history.push(newPath);
          }
        };
      };
      _this.toolbar = function () {
        return _this.state.handler.toolbar && /*#__PURE__*/React.createElement(Container, {
          maxWidth: "xl"
        }, /*#__PURE__*/React.createElement(Toolbar, {
          disableGutters: true
        }, /*#__PURE__*/React.createElement(Box, {
          sx: {
            flexGrow: 1
          }
        }, _this.state.handler.toolbar.breadcrumbButtons && _this.state.handler.toolbar.breadcrumbButtons.map(function (b) {
          return /*#__PURE__*/React.createElement(GenericMatButton, b.props, b.text);
        })), /*#__PURE__*/React.createElement(Box, {
          sx: {
            flexGrow: 0
          }
        }, _this.state.handler.toolbar.actionButtons && _this.state.handler.toolbar.actionButtons.map(function (b) {
          return /*#__PURE__*/React.createElement(GenericMatButton, b.props, b.text);
        }), _this.state.handler.toolbar.pagination && _this.state.handler.pagination.toolbar.hasPrevious && /*#__PURE__*/React.createElement(GenericMatButton, null, "Prev"), _this.state.handler.toolbar.pagination && _this.state.handler.pagination.toolbar.hasNext && /*#__PURE__*/React.createElement(GenericMatButton, null, "Next"))));
      };
      _this.body = function (genericPageContext) {
        return _this.state.isLoading ? /*#__PURE__*/React.createElement("div", {
          style: {
            padding: '40px'
          }
        }, /*#__PURE__*/React.createElement("div", {
          className: "spinningLoadingIcon projectLoadingIcon vAlignCenter"
        })) : /*#__PURE__*/React.createElement(React.Fragment, null, _this.toolbar(), /*#__PURE__*/React.createElement(PageComponent, _extends({}, optionalProps, _this.props, {
          onLoadComplete: _this.onLoadComplete,
          handler: _this.state.handler,
          onNavigate: genericPageContext.onNavigate,
          setQueryParams: _this.setQueryParams,
          queryParams: _this.state.queryParams
        })));
      };
      _this.isNestedDetailPage = function () {
        return optionalProps && optionalProps.detailPage && optionalProps.detailPage.nested;
      };
      _this.withPageLayout = function (body) {
        return /*#__PURE__*/React.createElement("div", {
          className: "page"
        }, /*#__PURE__*/React.createElement("div", {
          className: "generic-page-body"
        }, body));
      };
      _this.renderGenericPage = function (genericPageContext) {
        return _this.isNestedDetailPage() ? _this.body(genericPageContext) : _this.withPageLayout(_this.body(genericPageContext));
      };
      _this.state = {
        project: null,
        userConfig: null,
        isLoading: true,
        isPageLoading: true,
        queryParams: _this.parseQueryParams(props.location.search, _this.isSelectionInfoValid)
      };
      _this._loadPageData = _this._loadPageData.bind(_this);
      _this.handleAction = _this.handleAction.bind(_this);
      _this.onLoadComplete = _this.onLoadComplete.bind(_this);
      _this.onNavigated = _this.onNavigated.bind(_this);

      //console.log("GENERIC PAGE constructor props.userConfig",{...props.userConfig});
      return _this;
    }
    _inherits(GenericPage, _React$Component);
    return _createClass(GenericPage, [{
      key: "componentDidMount",
      value: function () {
        var _componentDidMount = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
          return _regenerator().w(function (_context) {
            while (1) switch (_context.n) {
              case 0:
                this.setState({
                  project: this.props.selectedItems.selectedProject,
                  userConfig: this.props.selectedItems.userConfig
                });
                _context.n = 1;
                return this._loadPageData();
              case 1:
                this.onNavigated();
              case 2:
                return _context.a(2);
            }
          }, _callee, this);
        }));
        function componentDidMount() {
          return _componentDidMount.apply(this, arguments);
        }
        return componentDidMount;
      }()
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps) {
        //if the search changes the component doesn't get re-mounted, but still we need to react to the change in navigation
        if (this.props.location.search !== prevProps.location.search) {
          this.onNavigated();
        }

        //patch: set project in case it has changed without this component being re-mounted
        if (this.state.project && this.state.project._id !== this.props.selectedItems.selectedProject._id) {
          this.setState({
            project: this.props.selectedItems.selectedProject,
            userConfig: this.props.selectedItems.userConfig
          });
        }

        //if user switches project while on the page reload page
        if (!this.state.isPageLoading && !!this.state.project && this.state.project._id !== this.props.selectedItems.selectedProject._id) this.props.history.push('/');

        //if user switches userCOnfig while on the page reload page
        if (!this.state.isPageLoading && !!this.state.userConfig && this.state.userConfig._id !== this.props.userConfig._id) this.props.history.push('/');
      }
    }, {
      key: "_loadPageData",
      value: function () {
        var _loadPageData2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3() {
          var _this2 = this;
          var handlers, handler, _t3;
          return _regenerator().w(function (_context3) {
            while (1) switch (_context3.p = _context3.n) {
              case 0:
                this.setState({
                  isLoading: true,
                  isPageLoading: true
                });
                handlers = this.props.userConfig.handlers; //console.log("GENERIC PAGE PROPS",this.props);
                handler = undefined;
                _context3.p = 1;
                _context3.n = 2;
                return produce(this.props.actions.getCurrentHandler(), /*#__PURE__*/function () {
                  var _ref = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(handler) {
                    var _handler$config;
                    var handlerHasConfig, hasDefaultConfig, expectsMultipleDataConfig, _handler$config3, entityType, handlerData, defaultData, data, hasActions, actions, scriptTypes, i, runScripts, _i, _t, _t2;
                    return _regenerator().w(function (_context2) {
                      while (1) switch (_context2.p = _context2.n) {
                        case 0:
                          //put selectBy info on handler if configured at the userConfig level and not the page level
                          //and if selectBy config is not provided on the handler already, this allows to override selectBys at a page level
                          if (handler.config && !handler.config.selectBy && handler.config.type && _this2.props.userConfig.entitySelectConfig) {
                            if (!Array.isArray(handler.config.type) && _this2.props.userConfig.entitySelectConfig[handler.config.type.singular]) {
                              //if the page is expecting only one selectBy config
                              handler.config = _objectSpread2(_objectSpread2({}, handler.config), {}, {
                                selectBy: _this2.props.userConfig.entitySelectConfig[handler.config.type.singular]
                              });
                            } else {
                              //if the page is expecting multiple selectByConfigs filter to the ones it expects
                              handler.config = _objectSpread2(_objectSpread2({}, handler.config), {}, {
                                selectBy: _.fromPairs(handler.config.type.filter(function (t) {
                                  return !!_this2.props.userConfig.entitySelectConfig[t.singular];
                                }).map(function (t) {
                                  return [t.singular, _this2.props.userConfig.entitySelectConfig[t.singular]];
                                }))
                              });
                            }
                          }
                          handlerHasConfig = !!(handler !== null && handler !== void 0 && handler.config);
                          hasDefaultConfig = _.isObject(_this2.props.userConfig.entityDataConfig);
                          expectsMultipleDataConfig = Array.isArray(handler === null || handler === void 0 || (_handler$config = handler.config) === null || _handler$config === void 0 ? void 0 : _handler$config.type);
                          if (hasDefaultConfig && handlerHasConfig) {
                            if (expectsMultipleDataConfig) {
                              handler.config = _objectSpread2(_objectSpread2({}, handler.config), {}, {
                                data: _.fromPairs(handler.config.type.filter(function (t) {
                                  return !!_this2.props.userConfig.entityDataConfig[t.singular];
                                }).map(function (t) {
                                  var _handler$config2;
                                  var handlerData = handler === null || handler === void 0 || (_handler$config2 = handler.config) === null || _handler$config2 === void 0 || (_handler$config2 = _handler$config2.data) === null || _handler$config2 === void 0 ? void 0 : _handler$config2[t.singular];
                                  var defaultData = _this2.props.userConfig.entityDataConfig[t.singular];
                                  var data = produce(defaultData || {}, function (data) {
                                    //merge handler config into default data, so treat as full override
                                    _.merge(data, handlerData || {});
                                  });
                                  return [t.singular, data];
                                }))
                              });
                            } else {
                              entityType = handler.config.type;
                              handlerData = handler === null || handler === void 0 || (_handler$config3 = handler.config) === null || _handler$config3 === void 0 ? void 0 : _handler$config3.data;
                              defaultData = entityType && _this2.props.userConfig.entityDataConfig[entityType.singular];
                              data = produce(defaultData || {}, function (data) {
                                //merge handler config into default data, so treat as full override
                                _.merge(data, handlerData || {});
                              });
                              handler.config = _objectSpread2(_objectSpread2({}, handler.config), {}, {
                                data: data
                              });
                            }
                          }
                          hasActions = !!handler.actionHandlers && !!handler.actionHandlers.length;
                          if (hasActions) {
                            actions = [];
                            handler.actionHandlers.forEach(function (action) {
                              actions.push({
                                title: handlers[action].actionTitle,
                                onClick: function onClick(e) {
                                  return _this2.handleAction(action);
                                }
                              });
                            });
                            _this2.context.ifefUpdatePopover(/*#__PURE__*/React.createElement(PopoverMenuView, {
                              actions: actions
                            }));
                          } else {
                            _this2.context.ifefUpdatePopover(null);
                          }

                          //load script from userConfig
                          scriptTypes = handler.scriptTypes ? handler.scriptTypes : null;
                          if (!(!!scriptTypes && scriptTypes.length > 0)) {
                            _context2.n = 7;
                            break;
                          }
                          i = 0;
                        case 1:
                          if (!(i < scriptTypes.length)) {
                            _context2.n = 7;
                            break;
                          }
                          _context2.p = 2;
                          _context2.n = 3;
                          return ScriptHelper.loadScript({
                            _userType: scriptTypes[i]
                          });
                        case 3:
                          _context2.n = 6;
                          break;
                        case 4:
                          _context2.p = 4;
                          _t = _context2.v;
                          if (!_this2.props.handlePageHandlerLoadError) {
                            _context2.n = 5;
                            break;
                          }
                          //if we have error handler, execute it (in case of mocking provider)
                          _this2.props.handlePageHandlerLoadError(_t);
                          _context2.n = 6;
                          break;
                        case 5:
                          //else throw error and break handler loading (note errors in lifecycle components will be swallowed)
                          console.log(_t);
                          throw _t;
                        case 6:
                          i++;
                          _context2.n = 1;
                          break;
                        case 7:
                          //load script from userConfig
                          runScripts = handler.onHandlerLoad ? handler.onHandlerLoad : null;
                          if (!(!!runScripts && runScripts.length > 0)) {
                            _context2.n = 14;
                            break;
                          }
                          _i = 0;
                        case 8:
                          if (!(_i < runScripts.length)) {
                            _context2.n = 14;
                            break;
                          }
                          _context2.p = 9;
                          _context2.n = 10;
                          return ScriptHelper.executeScript(runScripts[_i]);
                        case 10:
                          _context2.n = 13;
                          break;
                        case 11:
                          _context2.p = 11;
                          _t2 = _context2.v;
                          if (!_this2.props.actions.handlePageHandlerLoadError) {
                            _context2.n = 12;
                            break;
                          }
                          //if we have error handler, execute it (in case of mocking provider)
                          _this2.props.actions.handlePageHandlerLoadError(_t2);
                          _context2.n = 13;
                          break;
                        case 12:
                          //else throw error and break handler loading (note errors in lifecycle components will be swallowed)
                          console.error(_t2);
                          throw _t2;
                        case 13:
                          _i++;
                          _context2.n = 8;
                          break;
                        case 14:
                          return _context2.a(2);
                      }
                    }, _callee2, null, [[9, 11], [2, 4]]);
                  }));
                  return function (_x) {
                    return _ref.apply(this, arguments);
                  };
                }());
              case 2:
                handler = _context3.v;
                _context3.n = 4;
                break;
              case 3:
                _context3.p = 3;
                _t3 = _context3.v;
                console.error("Error generating handler");
                console.error(_t3);
              case 4:
                //console.log("HANDLER PREPARED",handler);
                this.setState({
                  isLoading: false,
                  handler: handler
                });
              case 5:
                return _context3.a(2);
            }
          }, _callee3, this, [[1, 3]]);
        }));
        function _loadPageData() {
          return _loadPageData2.apply(this, arguments);
        }
        return _loadPageData;
      }()
    }, {
      key: "handleAction",
      value: function handleAction(handler) {
        this.context.ifefShowPopover(false);
        var _this$props = this.props,
          match = _this$props.match,
          history = _this$props.history,
          userConfig = _this$props.userConfig;
        history.push("".concat(match.path).concat(userConfig.handlers[handler].path));
      }
    }, {
      key: "onLoadComplete",
      value: function onLoadComplete() {
        this.setState({
          isPageLoading: false
        });
      }
    }, {
      key: "isSelectionInfoValid",
      value: function isSelectionInfoValid(selectionInfo) {
        if (selectionInfo && !selectionInfo.entityType) {
          console.error('Attempting to pass query parameters with no entity type!');
          return false;
        } else return true;
      }
    }, {
      key: "parseQueryParams",
      value: function parseQueryParams(path, validator) {
        var queryParams = {};
        if (path) {
          var rawParams = path.split('?')[1];
          // using decoder to parse boolean and int https://github.com/ljharb/qs/issues/91#issuecomment-437926409
          // qs will also limit specifying indices in an array to a maximum index of 20. Any array members with an
          // index of greater than 20 will instead be converted to an object with the index as the key.
          // This is needed to handle cases when someone sent, for example, a[999999999] and it will take significant time to iterate over this huge array.
          // This limit can be overridden by passing an arrayLimit option: We are going to use an arraylimit of 100 to cover almost every case,
          // if we are still finding more bugs on this parse, we will need to implement another solution for these arrays

          queryParams = qs.parse(rawParams, {
            arrayLimit: 100,
            decoder: function decoder(str, _decoder, charset) {
              var strWithoutPlus = str.replace(/\+/g, ' ');
              if (charset === 'iso-8859-1') {
                // unescape never throws, no try...catch needed:
                return strWithoutPlus.replace(/%[0-9a-f]{2}/gi, unescape);
              }
              if (/^(\d+|\d*\.\d+)$/.test(str)) {
                return parseFloat(str);
              }
              var keywords = {
                "true": true,
                "false": false,
                "null": null,
                undefined: undefined
              };
              if (str in keywords) {
                return keywords[str];
              }

              // utf-8
              try {
                return decodeURIComponent(strWithoutPlus);
              } catch (e) {
                return strWithoutPlus;
              }
            }
          });

          //if the query contains no id and a value which is a string, turn the value into an array
          //in this case its a list of ids to fetch
          if (queryParams.query && !queryParams.query.id && queryParams.query.id !== 0 && queryParams.query.value) {
            if (typeof queryParams.query.value == "string") {
              queryParams.query.value = queryParams.query.value.split(',');
            }
          }
          if (queryParams.selectedEntities) {
            if (typeof queryParams.selectedEntities == "string") {
              queryParams.selectedEntities = queryParams.selectedEntities.split(',');
            }
          }
          if (!validator(queryParams)) {
            console.error('Navigation occurred with invalid query parameters!');
            queryParams = {};
          }
          if (queryParams.groups) queryParams.groups = queryParams.groups.split(',');
          if (queryParams.query && queryParams.query.type && queryParams.query.value) {
            if (queryParams.query.type === "<<TEXT_SEARCH>>") queryParams.query.value = queryParams.query.value.toString();
            delete queryParams.query.type;
          }
        }
        return queryParams;
      }
    }, {
      key: "onNavigated",
      value: function onNavigated() {
        var queryParams = this.parseQueryParams(this.props.location.search, this.isSelectionInfoValid);
        if (!_.isEqual(queryParams, this.state.queryParams)) {
          this.setState({
            queryParams: queryParams
          });
        } else {
          this.setState({
            queryParams: {}
          });
        }
      }
    }, {
      key: "render",
      value: function render() {
        var onNavigate = this.onNavigateOut(this.props.userConfig, this.state.queryParams, this.isSelectionInfoValid, this.props.history);

        //looks like handler is "calculated" only when component mounts and never changes
        var genericPageContext = {
          handler: this.state.handler,
          onNavigate: onNavigate
        };
        return /*#__PURE__*/React.createElement(GenericPageContext.Provider, {
          value: genericPageContext
        }, this.renderGenericPage(genericPageContext));
      }
    }]);
  }(React.Component);
  GenericPage.contextTypes = {
    ifefPlatform: object,
    ifefSnapper: object,
    ifefNavDirection: string,
    ifefShowPopover: func,
    ifefUpdatePopover: func,
    ifefUpdatePopup: func,
    ifefShowModal: func
  };
  var mapStateToProps = function mapStateToProps(state) {
    return {
      //please connect here only high level generic slices
    };
  };
  var mapDispatchToProps = {};
  return compose(connect(mapStateToProps, mapDispatchToProps))(GenericPage);
};

var css_248z$3 = ".entity-detail-panel {\n  display: grid;\n  grid-template-columns: 300px auto;\n  overflow-y: scroll;\n  max-height: 100%;\n}\n.entity-detail-panel .entity-detail-summary {\n  border-right: solid 1px lightgray;\n}\n.entity-detail-panel .entity-detail-summary h1 {\n  font-size: 28px;\n  color: var(--app-accent-color);\n  font-weight: bold;\n}\n.entity-detail-panel .entity-detail-summary .entity-data-groups-selector {\n  margin-top: 30px;\n}\n.entity-detail-panel .entity-detail-summary .entity-data-groups-selector div {\n  margin-bottom: 10px;\n  position: relative;\n}\n.entity-detail-panel .entity-detail-summary .entity-data-groups-selector label {\n  position: absolute;\n  top: -3px;\n  margin-left: 5px;\n  pointer-events: none;\n}\n.entity-detail-panel .entity-detail-summary .entity-data-groups-selector input {\n  -webkit-appearance: none;\n  -moz-appearance: none;\n  appearance: none;\n  width: 15px;\n  height: 15px;\n  border: 3px solid black;\n  cursor: pointer;\n  margin-right: 2px;\n  position: relative;\n}\n.entity-detail-panel .entity-detail-summary .entity-data-groups-selector input:after {\n  content: \" \";\n  position: absolute;\n  display: block;\n  cursor: pointer;\n  left: 0;\n  right: -200px;\n  top: 0;\n  bottom: 0;\n}\n.entity-detail-panel .entity-detail-summary .entity-data-groups-selector input:checked {\n  background-color: var(--app-accent-color);\n}\n.entity-detail-panel .entity-detail-summary {\n  /* unify icon font-size across different font systems*/\n}\n.entity-detail-panel .entity-detail-summary .action-button {\n  font-size: 1.5em;\n}\n.entity-detail-panel .entity-detail-summary .action-button i {\n  font-size: 1em !important;\n}\n.entity-detail-panel .entity-detail-data {\n  padding-left: 20px;\n}\n\n.entity-data-container {\n  margin-bottom: 30px;\n}\n.entity-data-container .entity-data-stack-title {\n  display: flex;\n  align-items: center;\n  color: var(--app-accent-color);\n  font-size: 24px;\n  font-weight: bold;\n}\n.entity-data-container .entity-data-stack-title .entity-data-toggle {\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  padding-left: 10px;\n  transform: rotateX(180deg);\n  transition: transform 1s;\n}\n.entity-data-container .entity-data-stack-title .entity-data-toggle-collapsed {\n  transform: rotateX(0deg);\n}\n.entity-data-container .entity-data-content {\n  overflow: hidden;\n  max-height: 500px;\n  opacity: 1;\n  transition: max-height, opacity 1s;\n}\n.entity-data-container .entity-data-content-collapsed {\n  max-height: 0;\n  opacity: 0;\n}";
styleInject(css_248z$3);

var EntityDetailPanel = /*#__PURE__*/function (_React$Component) {
  function EntityDetailPanel(props) {
    var _this;
    _classCallCheck(this, EntityDetailPanel);
    _this = _callSuper(this, EntityDetailPanel, [props]);
    _this.dataGroupSelected = function (name, selected) {
      // make a keyed name so we can retain display order
      var index = Object.keys(_this.props.config.data).findIndex(function (n) {
        return n == name;
      }) + 1;
      var keyedName = "".concat((index / 100).toFixed(2)).concat(name); // make it one based and divide by 100 so all keys are the same length
      //let selectedDataGroups = new Set([...this.state.selectedDataGroups]) removed as creating a new set everytime was causing a race condition
      var selectedDataGroups = _this.state.selectedDataGroups;
      if (selected) selectedDataGroups.add(keyedName);else selectedDataGroups["delete"](keyedName);
      _this.setState({
        selectedDataGroups: selectedDataGroups
      });
    };
    _this.state = {
      selectedDataGroups: new Set()
    };
    return _this;
  }
  _inherits(EntityDetailPanel, _React$Component);
  return _createClass(EntityDetailPanel, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;
      Object.keys(this.props.config.data).forEach(function (name) {
        if (_this2.props.config.data[name].selected) _this2.dataGroupSelected(name, true);
      });
    }
  }, {
    key: "render",
    value: function render() {
      var availableDataGroups = this.props.availableDataGroups[this.props.entityType];
      var dataGroups = _toConsumableArray(this.state.selectedDataGroups);
      // sort and then remove keys then make sure the type of extended ahas availableData
      // if a config had a typ eof data as selected, but the entity didn;t have that type of extended
      // the DataStack was showing data the GroupSelector wasn;t wasnt.

      dataGroups = dataGroups.sort().map(function (n) {
        return n.substring(4);
      }).filter(function (n) {
        return availableDataGroups && availableDataGroups[n];
      });
      return /*#__PURE__*/React.createElement("div", {
        className: "entity-detail-panel"
      }, /*#__PURE__*/React.createElement("div", {
        className: "entity-detail-summary"
      }, /*#__PURE__*/React.createElement("h1", null, _.get(this.props.entity, "Entity Name")), /*#__PURE__*/React.createElement(EntityActionsPanel, {
        actions: this.props.actions,
        entity: this.props.entity,
        type: this.props.config.type,
        context: this.props.context
      }), /*#__PURE__*/React.createElement(EntityDataGroupSelector, {
        config: this.props.config,
        dataGroups: availableDataGroups,
        loadingDataGroups: this.props.loadingDataGroups,
        selectedDataGroups: this.state.selectedDataGroups,
        onDataGroupSelect: this.dataGroupSelected
      }), /*#__PURE__*/React.createElement("div", {
        className: "entity-actions-panel",
        style: {
          "float": "right",
          paddingRight: "20px"
        }
      }, /*#__PURE__*/React.createElement("div", {
        className: "dbm-tooltip"
      }, /*#__PURE__*/React.createElement("i", {
        className: "fas fa-angle-left",
        onClick: this.props.onSummary
      }), /*#__PURE__*/React.createElement("span", {
        className: "dbm-tooltiptext"
      }, "Back to Summary")))), /*#__PURE__*/React.createElement("div", {
        className: "entity-detail-data"
      }, /*#__PURE__*/React.createElement(EntityDataStack, {
        config: this.props.config.data,
        entity: this.props.entity,
        dataGroups: dataGroups,
        collapsable: false,
        getData: this.props.getData
      })));
    }
  }]);
}(React.Component);
var EntityDataGroupSelector = function EntityDataGroupSelector(_ref) {
  var dataGroups = _ref.dataGroups,
    loadingDataGroups = _ref.loadingDataGroups,
    selectedDataGroups = _ref.selectedDataGroups,
    onDataGroupSelect = _ref.onDataGroupSelect,
    config = _ref.config;
  var availableGroups = dataGroups ? Object.entries(dataGroups).filter(function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
      k = _ref3[0],
      v = _ref3[1];
    return v === true;
  }).map(function (_ref4) {
    var _ref5 = _slicedToArray(_ref4, 2),
      k = _ref5[0],
      v = _ref5[1];
    return k;
  }) : [];
  availableGroups = availableGroups.map(function (k) {
    return {
      k: k,
      index: Object.keys(config.data).findIndex(function (n) {
        return n === k;
      })
    };
  });
  availableGroups.sort(function (a, b) {
    if (a.index > b.index) return 1;else if (b.index > a.index) return -1;else return 0;
  });
  var checkboxes = availableGroups.map(function (dgName) {
    return /*#__PURE__*/React.createElement("div", {
      key: "checkbox-" + dgName.k
    }, /*#__PURE__*/React.createElement("input", {
      type: "checkbox",
      checked: _toConsumableArray(selectedDataGroups).map(function (n) {
        return n.substring(4);
      }).includes(dgName.k),
      onChange: function onChange(e) {
        return onDataGroupSelect(dgName.k, e.target.checked);
      }
    }), /*#__PURE__*/React.createElement("label", null, dgName.k));
  });
  return /*#__PURE__*/React.createElement("div", null, loadingDataGroups && /*#__PURE__*/React.createElement(SimpleTextThrobber, {
    throbberText: "Loading data"
  }), /*#__PURE__*/React.createElement("div", {
    className: "entity-data-groups-selector"
  }, checkboxes));
};

var css_248z$4 = ".entities-view {\n  display: flex;\n  width: 100%;\n  height: 100%;\n}\n.entities-view .fetch-container {\n  padding: 20px 40px;\n  height: 100%;\n}\n.entities-view .tree-container {\n  padding: 20px 40px;\n}\n.entities-view .content {\n  display: flex;\n  overflow: scroll;\n  max-height: 100%;\n  width: 100%;\n}\n.entities-view .content > * {\n  padding: 30px 40px;\n  flex: 1;\n}\n.entities-view .content::-webkit-scrollbar {\n  width: 7px;\n}\n.entities-view .content::-webkit-scrollbar-track {\n  background: white;\n}\n.entities-view .content::-webkit-scrollbar-thumb {\n  background: #DCDCDC;\n  border-radius: 2rem;\n}\n.entities-view .content::-webkit-scrollbar-thumb:hover {\n  background: #B8B8B8;\n}\n\n.entities-selection-controls {\n  padding-left: 20px;\n  border-left: var(--app-accent-color) solid 10px;\n  border-radius: 15px;\n}\n.entities-selection-controls .entities-selection-controls-indent {\n  margin-left: 20px;\n}\n\n.entity-tree-panel {\n  min-height: 100%;\n}\n.entity-tree-panel label {\n  display: block;\n  font-weight: bold;\n}\n.entity-tree-panel .title {\n  margin: 10px;\n  text-align: left;\n  font-size: 14px;\n  font-weight: bold;\n  letter-spacing: 0;\n  color: #333333;\n  display: inline-block;\n}\n\n.entity-panel-summary span {\n  padding: 0 15px;\n}\n\n.entity-panel-detail {\n  display: grid;\n  padding-top: 5px;\n  background-color: white;\n  border-radius: 5px;\n  margin: 10px;\n  width: 99%;\n}\n.entity-panel-detail .simple-tabs-pages {\n  display: block;\n  padding: 10px;\n}\n.entity-panel-detail .simple-tabs-pages div:nth-child(3) {\n  margin-top: 0;\n}\n\n.entity-panel-properties-outer {\n  margin: 10px;\n}\n\n.entity-panel-properties {\n  border: solid black 1px;\n  border-radius: 5px;\n  padding: 10px;\n  margin-top: 20px;\n  min-width: 545px;\n  width: 30%;\n}\n\n.entity-panel-extended-data-outer {\n  min-width: 545px;\n}\n.entity-panel-extended-data-outer .simple-tabs-container {\n  width: 100%;\n}\n\n.select-entity-by {\n  margin-bottom: 10px;\n}\n.select-entity-by .simple-tabs-pages {\n  grid-template-columns: 10px auto 100px;\n}\n\n.entity-filter-and-group-by {\n  border: solid black 1px;\n  border-radius: 5px;\n  margin-bottom: 10px;\n  padding-top: 10px;\n  position: relative;\n  display: grid;\n  grid-template-columns: auto 100px;\n}\n.entity-filter-and-group-by .simple-tab-button {\n  position: absolute;\n  margin: -10px 0 0 10px;\n}\n.entity-filter-and-group-by .filter-and-group,\n.entity-filter-and-group-by .filter-and-group .filter,\n.entity-filter-and-group-by .filter-and-group .group {\n  display: inline-flex;\n  flex-wrap: wrap;\n  margin: 10px;\n}\n.entity-filter-and-group-by .apply-button {\n  margin-top: 20px;\n}\n\n.entity-panel-detail,\n.entity-panel-properties-outer,\n.entity-panel-extended-data-outer {\n  display: inline-flex;\n  flex-wrap: wrap;\n  margin: 10px;\n}\n\n.entity-data-stack h1 {\n  font-size: 20px !important;\n}\n.entity-data-stack table.simple-property-grid {\n  width: 100%;\n}\n.entity-data-stack .simple-property-grid {\n  user-select: text;\n}\n.entity-data-stack .simple-property-grid table {\n  width: 100%;\n}\n.entity-data-stack .simple-property-grid td {\n  border: none;\n  border-bottom: solid #eeeeee 1px;\n  padding: 10px 5px;\n}\n.entity-data-stack .simple-property-grid td:nth-child(1) {\n  font-style: normal;\n  background-color: #f2f2f2;\n  font-weight: 500;\n  width: 30%;\n}\n.entity-data-stack .simple-property-grid td:nth-child(2) {\n  font-weight: 300;\n}\n.entity-data-stack .simple-property-grid tr:last-child td {\n  border: none;\n}\n.entity-data-stack .simple-property-grid-clearheader tr:nth-child(1) td {\n  background-color: white;\n  font-weight: bold;\n}";
styleInject(css_248z$4);

var tableComponents = {
  'EntityListView': EntityListView,
  'EntityTableContainer': EntityTableContainer
};
var EntityView = /*#__PURE__*/function (_React$Component) {
  function EntityView() {
    var _this;
    _classCallCheck(this, EntityView);
    for (var _len = arguments.length, _args = new Array(_len), _key = 0; _key < _len; _key++) {
      _args[_key] = arguments[_key];
    }
    _this = _callSuper(this, EntityView, [].concat(_args));
    _this.state = {
      displayDetail: false
    };
    _this.openDetail = function (entity) {
      _this.setState({
        displayDetail: true
      });
      _this.props.entitiesSelected([entity]);
    };
    _this.openSummary = function () {
      _this.setState({
        displayDetail: false
      });
      _this.props.entitiesSelected([]);
    };
    _this.onTreeSelect = function (entities) {
      if (_this.state.displayDetail == true && entities.length > 1) {
        _this.setState({
          displayDetail: false
        });
      }
      _this.props.entitiesSelected(entities);
    };
    _this.tableEntities = function () {
      return _.isEmpty(_this.props.selectedEntities) ? _this.props.currentEntities : _this.props.selectedEntities;
    };
    _this.onGroupOrFilterChange = function (changes) {
      _this.setState({
        displayDetail: false
      });
      _this.props.onGroupOrFilterChange(changes);
    };
    _this.actionSuccess = function (actionType, newEntity, result) {
      if (actionType === 'delete') _this.openSummary();
      if (actionType === 'edit') {
        var updatedEntities = _this.props.allEntities.map(function (a) {
          return a._id === newEntity._id ? newEntity : a;
        });
        var filteredEntities = getFilteredEntitiesBy(updatedEntities, _this.props.appliedFilters);
        if (!_.isEmpty(filteredEntities) && _.isEmpty(filteredEntities.find(function (e) {
          return e._id === newEntity._id;
        }))) _this.openSummary();
      }
      _this.props.onEntityChange(actionType, newEntity, result);
    };
    _this._doFetch = function () {
      var scriptName = _this.props.handler.config.entityData[_this.props.entitySingular].script;
      _this.setState({
        displayDetail: false
      });
      _this.props.getFetcher(scriptName).apply(void 0, arguments);
    };
    return _this;
  }
  _inherits(EntityView, _React$Component);
  return _createClass(EntityView, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
        handler = _this$props.handler,
        entitySingular = _this$props.entitySingular;
      if (this.props.isPageLoading) return null;
      var TableComponent = tableComponents[_.get(handler, 'config.tableView.component.name')];
      var actions = {};
      var tableActions = {};
      if (this.props.handler.config.actions) {
        actions = Object.assign({}, this.props.handler.config.actions);
        actions.onSuccess = this.actionSuccess;
        actions.doEntityAction = this.props.doEntityAction;
        tableActions.onSuccess = this.actionSuccess;
        tableActions.doEntityAction = this.props.doEntityAction;
        var actionNames = Object.keys(actions);
        actionNames.forEach(function (action) {
          if (actions[action].showOnTable) tableActions[action] = actions[action];
        });
      }
      var pageContent;
      if (this.props.fetching) {
        pageContent = /*#__PURE__*/React.createElement("span", {
          className: "info-message"
        }, "Retrieving data");
      } else if (this.props.currentEntities.length > 0) {
        if (this.state.displayDetail == true) {
          pageContent = /*#__PURE__*/React.createElement(EntityDetailPanel, {
            context: this.context,
            onSummary: this.openSummary,
            entity: this.props.selectedEntities[0],
            config: this.props.handler.config,
            actions: actions,
            availableDataGroups: this.props.availableDataGroups,
            entityType: this.props.entitySingular,
            loadingDataGroups: this.props.loadingAvailableDataGroups,
            getData: this.props.getEntityExtendedData(this.props.handler.config.data)
          });
        } else {
          pageContent = /*#__PURE__*/React.createElement(TableComponent, {
            config: handler.config.tableView.component,
            onDetail: this.openDetail,
            entities: this.tableEntities(),
            actions: tableActions,
            context: this.context,
            entityPlural: this.props.entityPlural,
            entitySingular: this.props.entitySingular
          });
        }
      } else {
        pageContent = /*#__PURE__*/React.createElement("span", {
          className: "info-message"
        }, "No data");
      }

      // make sure query id is numeric
      var query = Object.assign({}, this.props.queryParams && this.props.queryParams.query ? this.props.queryParams.query : {});
      if (query.id && _.isNaN(parseInt(query.id))) {
        query.id = "" + handler.config.selectBy.findIndex(function (sb) {
          return query.id == sb.id;
        });
      }
      var nonGroupableProps = (this.props.handler.config.entitySelectionPanel ? this.props.handler.config.entitySelectionPanel.nonGroupableProperties : []) || [];
      var nonFilterableProps = (this.props.handler.config.entitySelectionPanel ? this.props.handler.config.entitySelectionPanel.nonFilterableProperties : []) || [];
      var defaultGroups = (this.props.handler.config.entitySelectionPanel ? this.props.handler.config.entitySelectionPanel.defaultGroups : []) || [];
      return /*#__PURE__*/React.createElement("div", {
        className: "entities-view"
      }, /*#__PURE__*/React.createElement(StackableDrawer, {
        level: 1,
        iconKey: 'fa-search'
      }, /*#__PURE__*/React.createElement("div", {
        className: "fetch-container"
      }, /*#__PURE__*/React.createElement(EnhancedFetchControl, {
        initialValue: query,
        selectors: handler.config.selectBy,
        doFetch: this._doFetch
      }))), /*#__PURE__*/React.createElement(StackableDrawer, {
        level: 2,
        iconKey: 'fa-sitemap'
      }, /*#__PURE__*/React.createElement("div", {
        className: "tree-container"
      }, /*#__PURE__*/React.createElement(EntitySelectionPanel, {
        selectedGroups: this.props.groups,
        selectedFilters: this.props.appliedFilters,
        selectedEntities: this.props.selectedEntities,
        fetching: this.props.fetching,
        entities: this.props.allEntities,
        onSelect: this.onTreeSelect,
        treeSelectMode: TreeSelectMode.NONE_MEANS_NONE,
        onGroupOrFilterChange: this.onGroupOrFilterChange,
        leafNodeRenderer: leafNodeRenderer,
        branchNodeRenderer: branchNodeRenderer,
        nonFilterableProperties: nonFilterableProps,
        nonGroupableProperties: nonGroupableProps,
        name: this.props.entitySingular + "_selection_panel",
        entitySingular: this.props.entitySingular,
        entityPlural: this.props.entityPlural,
        defaultGroups: defaultGroups
      }))), /*#__PURE__*/React.createElement("div", {
        className: "content"
      }, pageContent));
    }
  }]);
}(React.Component);
EntityView.contextTypes = {
  actions: object,
  ifefPlatform: object,
  ifefSnapper: object,
  ifefNavDirection: string,
  ifefShowPopover: func,
  ifefUpdatePopover: func,
  ifefUpdatePopup: func,
  ifefShowModal: func
};
var mapStateToProps = function mapStateToProps(state) {
  return {
    allEntities: getAllCurrentEntities(state),
    fetching: getFetchingCurrent(state),
    currentEntities: getFilteredEntities(state),
    appliedFilters: getAppliedFilters(state)
  };
};
var EntityView$1 = compose(withEntitySearch, withEntityAvailableGroups, connect(mapStateToProps))(EntityView);

var css_248z$5 = ".homepage h1 {\n  font-family: \"Inter\", sans-serif;\n  font-size: 200%;\n  font-weight: bold;\n  color: var(--app-accent-color);\n}\n.homepage h2 {\n  font-family: \"Inter\", sans-serif;\n  font-size: 150%;\n  font-weight: normal;\n  margin-bottom: 38px;\n}\n\n.dashboard {\n  padding: 20px;\n  height: calc(100vh - 80px);\n}\n\n.dashboard.db-grid {\n  display: grid;\n}\n\n.db-panel {\n  padding: 15px;\n}\n\n.dashboard-header {\n  margin-top: 20px;\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  border-bottom: lightgrey 1px solid;\n  padding-bottom: 10px;\n}\n.dashboard-header .title {\n  margin-left: 50px;\n  font-size: 28px;\n  font-weight: bold;\n  color: var(--app-accent-color);\n}\n.dashboard-header .nav-button {\n  margin-right: 5%;\n}\n.dashboard-header .nav-button .main-button {\n  font-size: 13px;\n  min-width: 150px;\n  height: 45px;\n  border-radius: 5px;\n  color: white;\n  background: var(--app-accent-color);\n  box-shadow: none;\n}\n\n.mobile-sample-dash h1 {\n  font-size: 20px !important;\n}\n.mobile-sample-dash img {\n  max-height: 100px !important;\n}";
styleInject(css_248z$5);

var DashboardView = /*#__PURE__*/function (_React$Component) {
  function DashboardView(props) {
    var _this;
    _classCallCheck(this, DashboardView);
    _this = _callSuper(this, DashboardView, [props]);
    _this.generatePanels = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2() {
      var config, panels, panelEntries;
      return _regenerator().w(function (_context2) {
        while (1) switch (_context2.n) {
          case 0:
            config = _this.props.handler.config;
            panels = [];
            if (!(config.layout === 'fullpage')) {
              _context2.n = 2;
              break;
            }
            _context2.n = 1;
            return _this.getComponent(config);
          case 1:
            panels = _context2.v;
            _context2.n = 4;
            break;
          case 2:
            if (!(config.layout === 'grid')) {
              _context2.n = 4;
              break;
            }
            panelEntries = Object.entries(config.panels);
            _context2.n = 3;
            return Promise.all(panelEntries.map(/*#__PURE__*/function () {
              var _ref3 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(_ref2) {
                var _ref4, name, panelConfig, component;
                return _regenerator().w(function (_context) {
                  while (1) switch (_context.n) {
                    case 0:
                      _ref4 = _slicedToArray(_ref2, 2), name = _ref4[0], panelConfig = _ref4[1];
                      _context.n = 1;
                      return _this.getComponent(panelConfig);
                    case 1:
                      component = _context.v;
                      return _context.a(2, _this.getPanel(name, panelConfig, component));
                  }
                }, _callee);
              }));
              return function (_x) {
                return _ref3.apply(this, arguments);
              };
            }()));
          case 3:
            panels = _context2.v;
          case 4:
            _this.setState({
              panels: panels
            });
          case 5:
            return _context2.a(2);
        }
      }, _callee2);
    }));
    _this.validateConfig = function () {
      var testFor = function testFor(c, x) {
        if (Array.isArray(x)) {
          var hasAny = false;
          for (var i = 0; i < x.length; i++) {
            if (!!c[x[i]]) {
              hasAny = true;
              break;
            }
          }
          if (!hasAny) throw 'Dashboard Config missing ' + x.join(' or ');
        } else if (!c[x]) throw "Dashboard Config missing ".concat(x);
      };
      var config = _this.props.handler.config;
      testFor(config, "layout");
      switch (config.layout) {
        case 'fullpage':
          testFor(config, ["component", "componentScript"]);
          break;
        case 'grid':
          testFor(config, "rows");
          testFor(config, "columns");
          testFor(config, "panels");
          Object.keys(config.panels).forEach(function (p) {
            testFor(config.panels[p], ["component", "componentScript"]);
          });
          break;
        default:
          throw "Dashboard Config unrecognized layout value";
      }
    };
    _this.getComponent = /*#__PURE__*/function () {
      var _ref5 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3(config) {
        var Component, componentInfo, name, script, reactiveOptions;
        return _regenerator().w(function (_context3) {
          while (1) switch (_context3.n) {
            case 0:
              Component = null;
              componentInfo = null; //Added logic to check if its a simple component or complex on the isString functions
              name = _.isString(config.component) ? config.component : config.component.name;
              script = _.isString(config.component) ? config.componentScript : config.script;
              if (!config.component) {
                _context3.n = 2;
                break;
              }
              _context3.n = 1;
              return _this.props.getDashboardComponent(name);
            case 1:
              Component = _context3.v;
            case 2:
              if (!script) {
                _context3.n = 5;
                break;
              }
              _context3.n = 3;
              return ScriptHelper.executeScript(script, {
                reactorInfo: _this.state.reactorInfo
              });
            case 3:
              componentInfo = _context3.v;
              if (!(componentInfo && componentInfo.component)) {
                _context3.n = 5;
                break;
              }
              _context3.n = 4;
              return _this.props.getDashboardComponent(componentInfo.component);
            case 4:
              Component = _context3.v;
            case 5:
              if (Component) {
                _context3.n = 6;
                break;
              }
              return _context3.a(2, /*#__PURE__*/React.createElement("div", {
                style: {
                  backgroundColor: "lightgray",
                  borderRadius: "10px",
                  border: "dashed black 5px",
                  margin: "5px",
                  padding: "10px",
                  fontWeight: "bold",
                  height: "98%",
                  fontSize: "150%"
                }
              }, "Unknown component: ", config.component));
            case 6:
              reactiveOptions = {
                onClick: config.reactor ? _this.onClick : null,
                reactorInfo: config.reactee ? _this.state.reactorInfo : null
              };
              if (_.isString(config.component)) {
                _context3.n = 7;
                break;
              }
              return _context3.a(2, /*#__PURE__*/React.createElement(Component, _extends({
                config: config.component,
                data: componentInfo
              }, reactiveOptions, {
                dashboard: _this
              })));
            case 7:
              return _context3.a(2, /*#__PURE__*/React.createElement(Component, _extends({}, config, reactiveOptions, componentInfo, {
                dashboard: _this
              })));
            case 8:
              return _context3.a(2);
          }
        }, _callee3);
      }));
      return function (_x2) {
        return _ref5.apply(this, arguments);
      };
    }();
    _this.doAction = function (action) {
      if (!action || action.type != "navigate") {
        console.error("This dashboard only knows how to navigate...");
        return;
      }
      _this.props.onNavigate(action.navigateTo, action.query);
    };
    _this.getPanel = function (key, config, component) {
      var layout = function layout(el) {
        if (!el) return;
        if (config.position) {
          el.style.gridColumn = "".concat(config.position.left, " / ").concat(config.position.right);
          el.style.gridRow = "".concat(config.position.top, " / ").concat(config.position.bottom);
        }
      };
      return /*#__PURE__*/React.createElement("div", {
        className: "db-panel",
        ref: layout,
        key: key
      }, component);
    };
    _this.onClick = function (reactorInfo) {
      var nextState = produce$1(_this.state.reactorInfo, function (draftState) {
        if (!reactorInfo || !Object.keys(reactorInfo).length) {
          var keys = Object.keys(draftState);
          keys.forEach(function (key) {
            delete draftState[key];
          });
        } else draftState = Object.assign(draftState, reactorInfo);
      });
      _this.setState({
        reactorInfo: nextState
      });
    };
    _this.state = {
      reactorInfo: {},
      isPageLoading: true,
      panels: [],
      preloadImageUrls: []
    };
    return _this;
  }
  _inherits(DashboardView, _React$Component);
  return _createClass(DashboardView, [{
    key: "componentDidMount",
    value: function () {
      var _componentDidMount = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4() {
        var images, urls, i, _t;
        return _regenerator().w(function (_context4) {
          while (1) switch (_context4.n) {
            case 0:
              this.setState({
                isPageLoading: false
              }, this.props.onLoadComplete);
              this.validateConfig();
              this.generatePanels();
              console.log('props', this.props);
              console.log('state', this.state);
              if (!this.props.handler.config.preloadImages) {
                _context4.n = 5;
                break;
              }
              images = this.props.handler.config.preloadImages;
              urls = [];
              i = 0;
            case 1:
              if (!(i < images.length)) {
                _context4.n = 4;
                break;
              }
              _t = urls;
              _context4.n = 2;
              return FileHelpers.getFileUrlForFilename(images[i]);
            case 2:
              _t.push.call(_t, _context4.v);
            case 3:
              i++;
              _context4.n = 1;
              break;
            case 4:
              this.setState({
                preloadImageUrls: urls
              });
            case 5:
              return _context4.a(2);
          }
        }, _callee4, this);
      }));
      function componentDidMount() {
        return _componentDidMount.apply(this, arguments);
      }
      return componentDidMount;
    }()
  }, {
    key: "componentDidUpdate",
    value: function () {
      var _componentDidUpdate = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee5(prevProps, prevState) {
        return _regenerator().w(function (_context5) {
          while (1) switch (_context5.n) {
            case 0:
              console.log(prevState, this.state);
              if (!_.isEqual(prevState.reactorInfo, this.state.reactorInfo)) {
                this.generatePanels();
              } else console.log('no update');
            case 1:
              return _context5.a(2);
          }
        }, _callee5, this);
      }));
      function componentDidUpdate(_x3, _x4) {
        return _componentDidUpdate.apply(this, arguments);
      }
      return componentDidUpdate;
    }()
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var config = this.props.handler.config;
      var cn = this.props.handler.config.className || "";
      switch (config.layout) {
        case 'fullpage':
          cn += " dashboard";
          break;
        case 'grid':
          cn += " dashboard db-grid";
          break;
      }
      var style = {};
      if (config.layout == "grid") {
        style.gridTemplateColumns = "repeat(".concat(config.columns, ", ").concat(100 / config.columns, "%)");
        style.gridTemplateRows = "repeat(".concat(config.rows, ", ").concat(100 / config.rows, "%)");
      }
      return /*#__PURE__*/React.createElement("div", null, !!this.state.preloadImageUrls.length && /*#__PURE__*/React.createElement("div", {
        id: "hiddenimages",
        style: {
          display: "none"
        }
      }, this.state.preloadImageUrls.map(function (imageurl) {
        return /*#__PURE__*/React.createElement("img", {
          src: imageurl,
          key: imageurl
        });
      })), config.headerInfo && /*#__PURE__*/React.createElement("div", {
        className: "dashboard-header"
      }, config.headerInfo.title && /*#__PURE__*/React.createElement("div", {
        className: "title"
      }, config.headerInfo.title), config.headerInfo.navButton && /*#__PURE__*/React.createElement("div", {
        className: "nav-button"
      }, /*#__PURE__*/React.createElement(GenericMatButton, {
        customClasses: "main-button",
        onClick: function onClick(e) {
          return _this2.doAction(config.headerInfo.navButton.action);
        }
      }, config.headerInfo.navButton.title))), /*#__PURE__*/React.createElement("div", {
        className: cn,
        style: style
      }, this.state.panels));
    }
  }]);
}(React.Component); //export default withAppContext(withGenericPage(DashboardView))
var mapStateToProps$1 = function mapStateToProps(state) {
  return {};
};
var mapDispatchToProps = {
  getDashboardComponent: getDashboardComponent
};
var DashboardView$1 = compose$1(connect(mapStateToProps$1, mapDispatchToProps))(DashboardView);

var WizardTimeline = function WizardTimeline(_ref) {
  var steps = _ref.steps,
    selectedStep = _ref.selectedStep;
  var isSelected = function isSelected(stepNumber) {
    return stepNumber <= selectedStep;
  };
  var isPrevious = function isPrevious(stepNumber) {
    return stepNumber < selectedStep;
  };
  var isFirst = function isFirst(stepNumber) {
    return stepNumber === 1;
  };
  var isLast = function isLast(stepNumber) {
    return stepNumber === steps.length;
  };
  return /*#__PURE__*/React.createElement("div", {
    className: "wizard-timeline-root"
  }, steps.map(function (stepText, i) {
    var stepNumber = i + 1;
    return /*#__PURE__*/React.createElement("div", {
      className: "step",
      key: stepNumber
    }, /*#__PURE__*/React.createElement("div", {
      className: "step-symbol"
    }, !isFirst(stepNumber) ? /*#__PURE__*/React.createElement("div", {
      className: clsx("step-cord", isSelected(stepNumber) && "selected")
    }) : null, /*#__PURE__*/React.createElement("div", {
      className: clsx("step-bubble", isSelected(stepNumber) && "selected", isPrevious(stepNumber) && "previous")
    }, stepNumber), !isLast(stepNumber) ? /*#__PURE__*/React.createElement("div", {
      className: clsx("step-cord", isSelected(stepNumber + 1) && "selected")
    }) : null), /*#__PURE__*/React.createElement("div", {
      className: clsx("step-legend", isFirst(stepNumber) && "first", isLast(stepNumber) && "last", isSelected(stepNumber) && "selected", isPrevious(stepNumber) && "previous")
    }, stepText));
  }));
};

var ChooseFiles = function ChooseFiles(_ref) {
  var onAddFiles = _ref.onAddFiles,
    display = _ref.display;
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    dragging = _useState2[0],
    isDragging = _useState2[1];
  var fileInput = useRef();
  var handleFileSelect = function handleFileSelect() {
    if (!_.isEmpty(fileInput.current.files)) onAddFiles(fileInput.current.files);
    fileInput.current.value = null;
  };
  var handleFileDrop = function handleFileDrop(event) {
    event.preventDefault();
    isDragging(false);
    onAddFiles(event.dataTransfer.files);
  };
  return /*#__PURE__*/React.createElement("div", {
    className: "dropzone-anchor",
    style: {
      opacity: display ? 1 : 0,
      visibility: display ? 'visible' : 'hidden'
    }
  }, /*#__PURE__*/React.createElement("div", {
    className: clsx("dropzone", dragging && "dragging"),
    onDrop: handleFileDrop,
    onDragEnter: function onDragEnter() {
      return isDragging(true);
    },
    onDragLeave: function onDragLeave() {
      return isDragging(false);
    },
    onDragOver: function onDragOver(e) {
      return e.preventDefault();
    }
  }, /*#__PURE__*/React.createElement("i", {
    className: "fas fa-cloud-upload-alt cloud-icon"
  }), /*#__PURE__*/React.createElement("div", {
    className: "dropzone-legend"
  }, "Drag and drop files here"), /*#__PURE__*/React.createElement(OrDivider, {
    width: "260px"
  }), /*#__PURE__*/React.createElement(GenericMatButton, {
    customClasses: "main-button",
    onClick: function onClick() {
      return fileInput.current.click();
    }
  }, "Browse"), /*#__PURE__*/React.createElement("input", {
    ref: fileInput,
    onChange: handleFileSelect,
    type: "file",
    hidden: true,
    multiple: true
  })));
};

var UploadFilesWizardSteps = function UploadFilesWizardSteps(_ref) {
  var steps = _ref.steps,
    selectedStep = _ref.selectedStep,
    addFiles = _ref.addFiles,
    startUpload = _ref.startUpload,
    associatedEntities = _ref.associatedEntities,
    rejectedFiles = _ref.rejectedFiles;
  var _useState = useState(selectedStep === 1),
    _useState2 = _slicedToArray(_useState, 2),
    panelOpen = _useState2[0],
    setPanelOpen = _useState2[1];
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    dialogOpen = _useState4[0],
    setDialogOpen = _useState4[1];

  //TODO if this gets more complex, make panelOpen calculable from actual state and selected step
  useEffect(function () {
    if (selectedStep === 1) setPanelOpen(true);
  }, [selectedStep]);
  var togglePanel = function togglePanel() {
    return setPanelOpen(function (open) {
      return !open;
    });
  };
  var closeDialog = function closeDialog() {
    return setDialogOpen(false);
  };
  var handleFilesAdded = function handleFilesAdded(newFiles) {
    addFiles(newFiles);
    setPanelOpen(false);
  };
  var handleUpload = function handleUpload() {
    closeDialog();
    startUpload();
  };
  var hasEntities = !_.isEmpty(associatedEntities);
  var assetList = /*#__PURE__*/React.createElement("ul", null, associatedEntities.map(function (entity) {
    return /*#__PURE__*/React.createElement("li", {
      key: entity._id,
      className: 'file-asset'
    }, entity['Entity Name']);
  }));
  var Buttons = steps[selectedStep - 1].buttons;
  return /*#__PURE__*/React.createElement("div", {
    className: "upload-files-wizard-root with-buttons"
  }, /*#__PURE__*/React.createElement("div", {
    className: clsx('wizard-panel', panelOpen && 'wizard-panel-expanded')
  }, /*#__PURE__*/React.createElement(WizardTimeline, {
    steps: steps.map(function (_ref2) {
      var name = _ref2.name;
      return name;
    }),
    selectedStep: selectedStep
  }), /*#__PURE__*/React.createElement(ChooseFiles, {
    onAddFiles: handleFilesAdded,
    display: panelOpen
  }), !panelOpen && /*#__PURE__*/React.createElement(PanelToggle, {
    disabled: selectedStep > 2,
    onClick: togglePanel
  })), /*#__PURE__*/React.createElement("div", {
    className: clsx('files-area', panelOpen && 'extra-margin')
  }, hasEntities && /*#__PURE__*/React.createElement("div", {
    className: "files-area-title"
  }, "Files will be associated with:", assetList), steps.map(function (_ref3) {
    var component = _ref3.component;
    return component;
  })[selectedStep - 1]), !_.isEmpty(rejectedFiles) && /*#__PURE__*/React.createElement("div", {
    className: 'rejected-files'
  }, "*The following files were rejected and will not be uploaded: ", rejectedFiles.map(function (f) {
    return f.name;
  }).join(' ,')), Buttons && /*#__PURE__*/React.createElement(Buttons, {
    optionsOverride: selectedStep === 2 && hasEntities ? {
      onPrimaryClick: function onPrimaryClick() {
        return setDialogOpen(true);
      }
    } : {}
  }), /*#__PURE__*/React.createElement(Dialog, {
    onClose: closeDialog,
    open: dialogOpen
  }, /*#__PURE__*/React.createElement("div", {
    className: 'dialog-content with-buttons'
  }, /*#__PURE__*/React.createElement("div", {
    className: 'dialog-title'
  }, "Confirm File Association"), /*#__PURE__*/React.createElement("div", {
    className: 'dialog-body'
  }, "Are you sure you want to upload these files with your selected metadata and associate them with the following:"), assetList, /*#__PURE__*/React.createElement("div", {
    className: 'dialog-actions'
  }, /*#__PURE__*/React.createElement(GenericMatButton, {
    customClasses: "main-button",
    onClick: handleUpload
  }, /*#__PURE__*/React.createElement("i", {
    className: "fas fa-upload"
  }), " Upload"), /*#__PURE__*/React.createElement(GenericMatButton, {
    customClasses: "cancel-button",
    onClick: closeDialog
  }, "Cancel")))));
};

var SeedAttributes = function SeedAttributes(_ref) {
  var onClick = _ref.onClick,
    display = _ref.display;
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    clicked = _useState2[0],
    setClicked = _useState2[1];
  var handleClick = /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(e) {
      return _regenerator().w(function (_context) {
        while (1) switch (_context.n) {
          case 0:
            e.preventDefault();
            _context.n = 1;
            return onClick();
          case 1:
            setClicked(true);
          case 2:
            return _context.a(2);
        }
      }, _callee);
    }));
    return function handleClick(_x) {
      return _ref2.apply(this, arguments);
    };
  }();
  return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("a", {
    href: "#",
    onClick: handleClick
  }, clicked && /*#__PURE__*/React.createElement("i", {
    className: "fas fa-check"
  }), "Select Files List with Attributes"));
};

var getValue = function getValue(value) {
  return (comesFromComplexSelect(value) ? _.values(value).map(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 1),
      actualValue = _ref2[0];
    return actualValue;
  }).filter(function (v) {
    return !!v;
  }).join(' - ') : value) || '-';
};
var FileTable = function FileTable(_ref3) {
  var inputFiles = _ref3.files,
    columns = _ref3.columns,
    onFileChange = _ref3.onFileChange,
    readonly = _ref3.readonly;
  var _useChecked = useChecked(inputFiles, function (file) {
      return file.name;
    }),
    allChecked = _useChecked.allChecked,
    handleCheck = _useChecked.handleCheck,
    handleAllCheck = _useChecked.handleAllCheck,
    files = _useChecked.items;
  var isReady = isReadyFor(columns);
  var getControl = function getControl(col, file) {
    return col.control ? col.control(file.fileAttributes[col.name], function (value) {
      return onFileChange(file.checked ? [].concat(_toConsumableArray(files.filter(function (f) {
        return f.checked;
      })), [file]) : [file], col.name, value);
    }, file) : 'loading...';
  };
  return /*#__PURE__*/React.createElement("div", {
    className: "file-table-container"
  }, /*#__PURE__*/React.createElement("table", {
    className: "file-table"
  }, /*#__PURE__*/React.createElement("thead", null, /*#__PURE__*/React.createElement("tr", {
    className: "file-table-header"
  }, /*#__PURE__*/React.createElement("th", null, /*#__PURE__*/React.createElement(RoundCheckbox, {
    checked: allChecked,
    onChange: handleAllCheck
  })), /*#__PURE__*/React.createElement("th", null, "Name"), /*#__PURE__*/React.createElement("th", null, /*#__PURE__*/React.createElement(TickCheckbox, {
    checked: inputFiles.every(isReady),
    onChange: function onChange() {}
  })), /*#__PURE__*/React.createElement("th", null, "V"), columns.map(function (col) {
    return /*#__PURE__*/React.createElement("th", {
      className: 'long',
      key: col.name
    }, col.displayAs, col.required && /*#__PURE__*/React.createElement(Star, null));
  }))), /*#__PURE__*/React.createElement("tbody", null, _.isEmpty(inputFiles) ? 'Loading files...' : files.map(function (file, i) {
    return /*#__PURE__*/React.createElement("tr", {
      key: i,
      className: "file-table-body"
    }, /*#__PURE__*/React.createElement("td", null, /*#__PURE__*/React.createElement(RoundCheckbox, {
      checked: _.get(files[i], 'checked', false),
      onChange: function onChange() {
        return handleCheck(files[i]);
      }
    })), /*#__PURE__*/React.createElement("td", null, file.name), /*#__PURE__*/React.createElement("td", null, /*#__PURE__*/React.createElement(TickCheckbox, {
      checked: isReady(file),
      onChange: function onChange() {}
    })), /*#__PURE__*/React.createElement("td", null, file.version), columns.map(function (col) {
      return /*#__PURE__*/React.createElement("td", {
        key: col.name
      }, readonly ? getValue(file.fileAttributes[col.name]) : getControl(col, file));
    }));
  }))));
};

var iconStyle = {
  fontSize: 18
};
var mainGreen = '#00A693';
var RoundFullCheckbox = function RoundFullCheckbox(_ref) {
  var props = _extends({}, (_objectDestructuringEmpty(_ref), _ref));
  return /*#__PURE__*/React.createElement(CheckBox, _extends({
    icon: /*#__PURE__*/React.createElement(RadioButtonUnchecked, {
      style: _objectSpread2(_objectSpread2({}, iconStyle), {}, {
        color: '#666666'
      })
    }),
    checkedIcon: /*#__PURE__*/React.createElement(RadioButtonChecked, {
      style: _objectSpread2(_objectSpread2({}, iconStyle), {}, {
        color: mainGreen
      })
    })
  }, props));
};
var FileUploadTable = function FileUploadTable(_ref2) {
  var inputFiles = _ref2.files;
  var getType = function getType(file) {
    var extension = mime.extension(getBlob(file).type);
    var splitFileName = getBlob(file).name.split('.');
    var inferredExtension = splitFileName[splitFileName.length - 1];
    return extension && extension.toUpperCase() || inferredExtension && inferredExtension.toUpperCase() || "UNKNOWN";
  };
  return /*#__PURE__*/React.createElement("div", {
    className: "file-table-container"
  }, /*#__PURE__*/React.createElement("table", {
    className: "file-table"
  }, /*#__PURE__*/React.createElement("thead", null, /*#__PURE__*/React.createElement("tr", {
    className: "file-table-header"
  }, /*#__PURE__*/React.createElement("th", null, /*#__PURE__*/React.createElement(RoundFullCheckbox, {
    disabled: true,
    checked: inputFiles.every(isComplete)
  })), /*#__PURE__*/React.createElement("th", null, "Name"), /*#__PURE__*/React.createElement("th", null, "File Type"), /*#__PURE__*/React.createElement("th", null, "Size"), /*#__PURE__*/React.createElement("th", null, "Status"))), /*#__PURE__*/React.createElement("tbody", null, inputFiles.map(function (file, i) {
    return /*#__PURE__*/React.createElement("tr", {
      key: i,
      className: "file-table-body",
      style: isPending(file) ? {
        color: '#B2B2B2'
      } : {}
    }, /*#__PURE__*/React.createElement("td", null, /*#__PURE__*/React.createElement(RoundFullCheckbox, {
      disabled: true,
      checked: isComplete(file)
    })), /*#__PURE__*/React.createElement("td", null, file.name), /*#__PURE__*/React.createElement("td", null, getType(file)), /*#__PURE__*/React.createElement("td", null, isInProgress(file) ? "".concat(formatBytes(file.bytesUploaded), " of ").concat(formatBytes(getBlob(file).size)) : formatBytes(getBlob(file).size)), /*#__PURE__*/React.createElement("td", {
      style: isComplete(file) ? {
        color: mainGreen
      } : {}
    }, file.status));
  }))));
};

var css_248z$6 = "@charset \"UTF-8\";\n.upload-files-wizard-root {\n  height: 100%;\n}\n.upload-files-wizard-root .file-table-container {\n  display: flex;\n  width: 100%;\n  overflow: scroll;\n  overflow-y: hidden;\n  padding: 1px;\n}\n.upload-files-wizard-root .file-table-container::-webkit-scrollbar {\n  width: 7px;\n  height: 7px;\n}\n.upload-files-wizard-root .file-table-container::-webkit-scrollbar-track {\n  background: white;\n}\n.upload-files-wizard-root .file-table-container::-webkit-scrollbar-thumb {\n  background: #DCDCDC;\n  border-radius: 2rem;\n}\n.upload-files-wizard-root .file-table-container::-webkit-scrollbar-thumb:hover {\n  background: #B8B8B8;\n}\n.upload-files-wizard-root .wizard-panel {\n  box-shadow: 0px 10px 20px rgba(0, 0, 0, 0.1019607843);\n  background: #ffffff;\n  display: flex;\n  position: relative;\n  flex-direction: column;\n  align-items: center;\n  height: 150px;\n  transition: height 1s;\n}\n.upload-files-wizard-root .wizard-panel-expanded {\n  height: 450px;\n}\n.upload-files-wizard-root .dropzone-anchor {\n  position: relative;\n  transition: opacity, visibility 1s;\n}\n.upload-files-wizard-root .dropzone {\n  transform: translateX(-50%);\n  position: absolute;\n  width: 600px;\n  height: 380px;\n  background: #FFFFFF;\n  box-shadow: 0px 10px 20px rgba(0, 0, 0, 0.1019607843);\n  border: 3px dashed #E6E6E6;\n  border-radius: 25px;\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n}\n.upload-files-wizard-root .dropzone.dragging {\n  border: 3px solid var(--app-accent-color);\n  background: #e0e0e0;\n}\n.upload-files-wizard-root .dropzone > * {\n  margin: 13px 0;\n}\n.upload-files-wizard-root .dropzone .cloud-icon {\n  font-size: 90px;\n  color: var(--app-accent-color);\n}\n.upload-files-wizard-root .dropzone .dropzone-legend {\n  font-size: 22px;\n  font-weight: 300;\n  letter-spacing: 0;\n  color: #666666;\n}\n.upload-files-wizard-root .files-area {\n  display: flex;\n  align-items: center;\n  margin: 40px 40px 0 40px;\n  flex-direction: column;\n}\n.upload-files-wizard-root .files-area.extra-margin {\n  margin-top: 100px;\n}\n.upload-files-wizard-root .file-table {\n  margin: 0 auto;\n  color: #666666;\n}\n.upload-files-wizard-root .file-table thead .file-table-header {\n  background: #F2F2F2 0% 0% no-repeat padding-box;\n}\n.upload-files-wizard-root .file-table thead .file-table-header > th {\n  padding: 15px 20px;\n  border: 1px solid #E6E6E6;\n}\n.upload-files-wizard-root .file-table thead .file-table-header > th.long {\n  min-width: 275px;\n}\n.upload-files-wizard-root .file-table tbody {\n  max-height: 400px;\n}\n.upload-files-wizard-root .file-table tbody .file-table-body > td {\n  padding: 15px 20px;\n  border-bottom: 1px solid #E6E6E6;\n}\n.upload-files-wizard-root .file-wizard-actions {\n  margin: 40px 40px 100px 40px;\n  display: flex;\n  justify-content: flex-end;\n}\n.upload-files-wizard-root .rejected-files {\n  margin: 20px 40px;\n  color: #666666;\n}\n\n.with-buttons .button-content > * {\n  margin: 0 5px;\n}\n.with-buttons .main-button {\n  font-size: 17px;\n  width: 170px;\n  height: 44px;\n  color: white;\n  background: var(--app-accent-color);\n  border-radius: 25px;\n  box-shadow: none;\n}\n.with-buttons .cancel-button {\n  font-size: 17px;\n  width: 170px;\n  height: 44px;\n  border-radius: 25px;\n  box-shadow: none;\n  color: #B2B2B2;\n  border: 2px solid;\n  background: white;\n  margin-left: 20px;\n}\n\n.dialog-content {\n  width: 500px;\n  margin: 20px;\n}\n.dialog-content .dialog-title {\n  font-size: 20px;\n  color: var(--app-accent-color);\n}\n.dialog-content .dialog-body {\n  color: #666666;\n  margin: 10px 0;\n  font-size: 13px;\n}\n.dialog-content .dialog-actions {\n  margin-top: 20px;\n  display: flex;\n  width: 100%;\n  justify-content: space-around;\n}\n\n.files-area-title {\n  color: var(--app-accent-color);\n  font-size: 17px;\n  font-weight: 500;\n  margin-bottom: 40px;\n}\n\nul li.file-asset::before {\n  content: \"•\";\n  color: var(--app-accent-color);\n  font-weight: bold;\n  display: inline-block;\n  width: 1em;\n  margin-left: -1em;\n}\n\n.file-asset {\n  font-size: 13px;\n  font-weight: bold;\n  letter-spacing: 0px;\n  color: #666666;\n  margin-left: 15px;\n}\n\n.wizard-timeline-root {\n  display: flex;\n  padding: 50px 0;\n}\n.wizard-timeline-root .step {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n}\n.wizard-timeline-root .step .step-symbol {\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n.wizard-timeline-root .step .step-symbol .step-bubble {\n  color: #666666;\n  border: 3px solid #666666;\n  width: 30px;\n  height: 30px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  border-radius: 15px;\n  font-size: 15px;\n}\n.wizard-timeline-root .step .step-symbol .step-bubble.selected {\n  color: var(--app-accent-color);\n  border: 3px solid var(--app-accent-color);\n}\n.wizard-timeline-root .step .step-symbol .step-bubble.previous {\n  background-color: var(--app-accent-color);\n}\n.wizard-timeline-root .step .step-symbol .step-cord {\n  width: calc(170px / 2);\n  background-color: #666666;\n  height: 3px;\n}\n.wizard-timeline-root .step .step-symbol .step-cord.selected {\n  background-color: var(--app-accent-color);\n}\n.wizard-timeline-root .step .step-legend {\n  max-width: 130px;\n  text-align: center;\n  display: flex;\n  margin-top: 5px;\n  justify-content: center;\n  color: #666666;\n}\n.wizard-timeline-root .step .step-legend.first {\n  transform: translateX(calc(-1 * 170px / 4));\n}\n.wizard-timeline-root .step .step-legend.last {\n  transform: translateX(calc(170px / 4));\n}\n.wizard-timeline-root .step .step-legend.selected {\n  color: var(--app-accent-color);\n}\n.wizard-timeline-root .step .step-legend.previous {\n  color: #E6E6E6;\n}\n\n.required-mark {\n  color: var(--app-accent-color);\n  font-weight: bold;\n}\n\n.panel-toggle {\n  cursor: pointer;\n  color: white;\n  bottom: 0;\n  position: absolute;\n  right: 25px;\n  transform: translateY(100%);\n  background-color: var(--app-accent-color);\n  width: 50px;\n  height: 50px;\n  border-radius: 0 0 23px 23px;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n}\n.panel-toggle > i {\n  font-size: 23px;\n  padding: 0;\n}\n.panel-toggle.disabled {\n  background-color: #B2B2B2;\n}\n\n.file-table-input {\n  padding: 4px 0;\n  border: none;\n  border-bottom: 1px solid #B2B2B2;\n}\n.file-table-input:focus {\n  border-bottom: 1px solid #666666;\n}";
styleInject(css_248z$6);

var UploadFilesWizard = function UploadFilesWizard(_ref) {
  var queryParams = _ref.queryParams,
    loadAssociatedEntities = _ref.loadAssociatedEntities,
    onLoadComplete = _ref.onLoadComplete,
    config = _ref.handler.config,
    cleanFiles = _ref.cleanFiles,
    files = _ref.files,
    rejectedFiles = _ref.rejectedFiles,
    addFilesToUpload = _ref.addFilesToUpload,
    selectedItems = _ref.selectedItems,
    updateMultipleFileAttribute = _ref.updateMultipleFileAttribute,
    uploadFiles = _ref.uploadFiles,
    associatedEntities = _ref.associatedEntities,
    columnConfig = _ref.columnConfig,
    fetchColumnConfig = _ref.fetchColumnConfig;
  var _useState = useState(1),
    _useState2 = _slicedToArray(_useState, 2),
    selectedStep = _useState2[0],
    setSelectedStep = _useState2[1];
  var _useState3 = useState(selectedItems.selectedProject.rootContainer),
    _useState4 = _slicedToArray(_useState3, 2),
    uploadContainer = _useState4[0],
    setUploadContainer = _useState4[1];
  useEffect(function () {
    function getUploadContainer() {
      return _getUploadContainer.apply(this, arguments);
    }
    function _getUploadContainer() {
      _getUploadContainer = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
        var newContainer;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              _context.n = 1;
              return ScriptHelper.executeScript(config.uploadContainer.script, {
                containerDesc: config.uploadContainer.containerDesc
              });
            case 1:
              newContainer = _context.v;
              console.log(newContainer);
              if (newContainer) setUploadContainer(newContainer);
            case 2:
              return _context.a(2);
          }
        }, _callee);
      }));
      return _getUploadContainer.apply(this, arguments);
    }
    onLoadComplete();
    cleanFiles();
    if (config.uploadContainer) getUploadContainer();
  }, []);
  useEffect(function () {
    fetchColumnConfig(config);
  }, [config]);
  useEffect(function () {
    loadAssociatedEntities(queryParams);
  }, [queryParams]);
  var addFiles = function addFiles(newFiles) {
    setSelectedStep(2);
    addFilesToUpload(_toConsumableArray(newFiles), uploadContainer, config.scripts.preprocessFiles);
  };
  var cancel = function cancel() {
    cleanFiles();
    setSelectedStep(1);
  };
  var startUpload = function startUpload() {
    setSelectedStep(3);
    uploadFiles(uploadContainer, config.scripts.processUploadFile, config.scripts.postprocessFiles);
  };
  var handleFileChange = config.readonly ? _.noop : function (files, field, newValue) {
    return updateMultipleFileAttribute(files.map(function (file) {
      return _defineProperty({
        name: file.name
      }, field, newValue);
    }));
  };
  var buildReport = function buildReport() {
    var headers = ['Name'].concat(_toConsumableArray(columnConfig.map(function (col) {
      return "".concat(col.displayAs).concat(col.required ? '*' : '');
    })));
    var rows = files.map(function (file) {
      return [file.name].concat(_toConsumableArray(columnConfig.map(function (col) {
        return getValue(file.fileAttributes[col.name]);
      })));
    });
    ScriptHelper.executeScript(config.scripts.downloadReport, {
      tableRows: [headers].concat(_toConsumableArray(rows))
    });
  };
  var seedAttributes = /*#__PURE__*/function () {
    var _ref3 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2() {
      return _regenerator().w(function (_context2) {
        while (1) switch (_context2.n) {
          case 0:
            return _context2.a(2, ScriptHelper.executeScript(config.scripts.seedAttributes));
        }
      }, _callee2);
    }));
    return function seedAttributes() {
      return _ref3.apply(this, arguments);
    };
  }();
  var steps = [{
    name: 'Add Files',
    component: config.scripts.seedAttributes ? /*#__PURE__*/React.createElement(SeedAttributes, {
      onClick: seedAttributes
    }) : /*#__PURE__*/React.createElement("div", null)
  }, {
    name: 'Enter Required Data',
    component: columnConfig ? /*#__PURE__*/React.createElement(FileTable, {
      columns: columnConfig,
      files: files,
      onFileChange: handleFileChange
    }) : 'Loading...',
    buttons: WizardButtons({
      primaryContent: /*#__PURE__*/React.createElement("span", {
        className: 'button-content'
      }, /*#__PURE__*/React.createElement("i", {
        className: "fas fa-upload"
      }), "Upload"),
      secondaryContent: 'Cancel',
      primaryDisabled: !files.every(isReadyFor(columnConfig)),
      onPrimaryClick: startUpload,
      onSecondaryClick: cancel
    })
  }, {
    name: 'Uploading',
    component: /*#__PURE__*/React.createElement(FileUploadTable, {
      files: files
    }),
    buttons: WizardButtons({
      primaryContent: files.every(isComplete) ? /*#__PURE__*/React.createElement("span", {
        className: 'button-content'
      }, "Review", /*#__PURE__*/React.createElement("i", {
        className: "fas fa-angle-right"
      })) : /*#__PURE__*/React.createElement("span", {
        className: 'button-content'
      }, /*#__PURE__*/React.createElement("i", {
        className: "fas fa-sync"
      }), "Uploading"),
      primaryDisabled: !files.every(isComplete),
      onPrimaryClick: function onPrimaryClick() {
        return setSelectedStep(4);
      },
      hideSecondary: true
    })
  }, {
    name: 'Review',
    component: columnConfig ? /*#__PURE__*/React.createElement(FileTable, {
      columns: columnConfig,
      files: files,
      onFileChange: handleFileChange,
      readonly: true
    }) : 'Loading...',
    buttons: WizardButtons({
      primaryContent: /*#__PURE__*/React.createElement("span", {
        className: 'button-content'
      }, "Return", /*#__PURE__*/React.createElement("i", {
        className: "fas fa-angle-right"
      })),
      onPrimaryClick: cancel,
      secondaryContent: 'Report',
      hideSecondary: !config.scripts.downloadReport,
      onSecondaryClick: buildReport
    })
  }];
  return /*#__PURE__*/React.createElement(UploadFilesWizardSteps, {
    steps: steps,
    selectedStep: selectedStep,
    associatedEntities: associatedEntities,
    addFiles: addFiles,
    cancel: cancel,
    startUpload: startUpload,
    rejectedFiles: rejectedFiles
  });
};
var mapStateToProps$2 = function mapStateToProps(state) {
  return {
    files: getFilesToUpload(state),
    associatedEntities: getAssociatedEntities(state),
    rejectedFiles: getRejectedFiles(state),
    columnConfig: getColumnConfig(state)
  };
};
var mapDispatchToProps$1 = {
  addFilesToUpload: addFilesToUpload,
  cleanFiles: cleanFiles,
  uploadFiles: uploadFiles,
  loadAssociatedEntities: loadAssociatedEntities,
  updateMultipleFileAttribute: updateMultipleFileAttribute,
  fetchColumnConfig: fetchColumnConfig
};
var UploadFilesWizard$1 = compose$1(connect(mapStateToProps$2, mapDispatchToProps$1))(UploadFilesWizard);

var css_248z$7 = ".cm-s-monokai-sublime {\n\tfont-size: 1em;\n\tline-height: 1.5em;\n\tfont-family: inconsolata, monospace;\n\tletter-spacing: 0.3px;\n\tword-spacing: 1px;\n\tbackground: #272822;\n\tcolor: #F8F8F2;\n}\n.cm-s-monokai-sublime .CodeMirror-lines {\n\tpadding: 8px 0;\n}\n.cm-s-monokai-sublime .CodeMirror-gutters {\n\tbox-shadow: 1px 0 2px 0 rgba(0, 0, 0, 0.5);\n\t-webkit-box-shadow: 1px 0 2px 0 rgba(0, 0, 0, 0.5);\n\tbackground-color: #272822;\n\tpadding-right: 10px;\n\tz-index: 3;\n\tborder: none;\n}\n.cm-s-monokai-sublime div.CodeMirror-cursor {\n\tborder-left: 3px solid #F8F8F2;\n}\n.cm-s-monokai-sublime .CodeMirror-activeline-background {\n\tbackground: #3E3D32;\n}\n.cm-s-monokai-sublime .CodeMirror-selected {\n\tbackground: #49483E;\n}\n.cm-s-monokai-sublime .cm-comment {\n\tcolor: #75715E;\n}\n.cm-s-monokai-sublime .cm-string {\n\tcolor: #E6DB74;\n}\n.cm-s-monokai-sublime .cm-number {\n\tcolor: #66D9EF;\n}\n.cm-s-monokai-sublime .cm-atom {\n\tcolor: #66D9EF;\n}\n.cm-s-monokai-sublime .cm-keyword {\n\tcolor: #F92672;\n}\n.cm-s-monokai-sublime .cm-variable {\n\tcolor: #A6E22E;\n}\n.cm-s-monokai-sublime .cm-def {\n\tfont-style: italic;\n\tcolor: #FD971F;\n}\n.cm-s-monokai-sublime .cm-variable-2 {\n\tcolor: #F92672;\n}\n.cm-s-monokai-sublime .cm-property {\n\tcolor: #66D9EF;\n}\n.cm-s-monokai-sublime .cm-operator {\n\tcolor: #F92672;\n}\n.cm-s-monokai-sublime .CodeMirror-linenumber {\n\tcolor: #75715E;\n}\n";
styleInject(css_248z$7);

var css_248z$8 = ".cm-scripter {\n    height: 800px;\n}\n\n.cm-scripter > .CodeMirror {\n    height: 800px;\n}\n\n.cm-inputer > .CodeMirror {\n    height: 300px;\n}\n\n.CodeMirror-breakpoint {\n    width: .8em;\n}";
styleInject(css_248z$8);

var getLocalScriptKey = function getLocalScriptKey(scriptname) {
  return "ipaScript_" + scriptname;
};
var ScriptRunnerView = /*#__PURE__*/function (_React$Component) {
  function ScriptRunnerView(props) {
    var _this;
    _classCallCheck(this, ScriptRunnerView);
    _this = _callSuper(this, ScriptRunnerView, [props]);
    _this.state = {
      isPageLoading: false,
      handler: null,
      scripts: [],
      selectedScript: '',
      isRunning: false,
      results: [],
      dots: '',
      showInput: false,
      scriptInput: "",
      inputError: false,
      showScript: true,
      showOutput: true,
      scriptJSON: "",
      scriptError: false,
      parsedScript: {},
      addVariable: "",
      variables: {},
      convertSetq: false,
      snippet: "",
      helpLinks: [],
      newScriptName: "",
      editor: null,
      hasBreakLine: false,
      operators: [],
      operatorSearchTerm: "",
      searchedOperators: null
    };
    _this._loadAsyncData = _this._loadAsyncData.bind(_this);
    _this.handleScriptSelect = _this.handleScriptSelect.bind(_this);
    _this.runScript = _this.runScript.bind(_this);
    _this.toggleDisplay = _this.toggleDisplay.bind(_this);
    _this.toggleCollapsed = _this.toggleCollapsed.bind(_this);
    _this.deleteResult = _this.deleteResult.bind(_this);
    _this.handleKeyDown = _this.handleKeyDown.bind(_this);
    _this.onInputChange = _this.onInputChange.bind(_this);
    _this.getScriptText = _this.getScriptText.bind(_this);
    _this.toggleInputs = _this.toggleInputs.bind(_this);
    _this.handleVariableName = _this.handleVariableName.bind(_this);
    _this.addScriptVar = _this.addScriptVar.bind(_this);
    _this.getScriptVars = _this.getScriptVars.bind(_this);
    _this.writeVars = _this.writeVars.bind(_this);
    _this.readVars = _this.readVars.bind(_this);
    _this.clearVars = _this.clearVars.bind(_this);
    _this.clearVarValue = _this.clearVarValue.bind(_this);
    _this.toggleConvertSetq = _this.toggleConvertSetq.bind(_this);
    _this.saveSnippet = _this.saveSnippet.bind(_this);
    _this.handleNewScriptName = _this.handleNewScriptName.bind(_this);
    _this.addNewScript = _this.addNewScript.bind(_this);
    _this.removeLocalScript = _this.removeLocalScript.bind(_this);
    _this.handleScriptGutterClick = _this.handleScriptGutterClick.bind(_this);
    _this.setEditor = _this.setEditor.bind(_this);
    _this.makeValidBreakMark = _this.makeValidBreakMark.bind(_this);
    _this.makeInvalidBreakMark = _this.makeInvalidBreakMark.bind(_this);
    _this.isValidBreakPoint = _this.isValidBreakPoint.bind(_this);
    _this.findBreakLine = _this.findBreakLine.bind(_this);
    _this.getOperatorHints = _this.getOperatorHints.bind(_this);
    _this.searchOperators = _this.searchOperators.bind(_this);
    _this.handleOpSearchTerm = _this.handleOpSearchTerm.bind(_this);
    _this.clearOpSearchTerm = _this.clearOpSearchTerm.bind(_this);
    _this.scriptInput = /*#__PURE__*/React.createRef();
    _this.scriptJSON = /*#__PURE__*/React.createRef();
    _this.snippetInput = /*#__PURE__*/React.createRef();
    return _this;
  }
  _inherits(ScriptRunnerView, _React$Component);
  return _createClass(ScriptRunnerView, [{
    key: "_loadAsyncData",
    value: function () {
      var _loadAsyncData2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
        var handler, scripts, allParsedScripts, i, scr, scriptVer, script, parsed, scriptNames, scriptsToAdd, operators, helpLinks;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              //Loads data necessary for displaying the page
              handler = this.props.handler;
              console.log('handler', handler);
              this.setState({
                handler: handler
              });
              scripts = ScriptHelper.getScriptVar('runnableScripts');
              if (!scripts) scripts = [];
              if (!(handler.config && handler.config.allowScriptInput && scripts && scripts.length > 0)) {
                _context.n = 5;
                break;
              }
              allParsedScripts = [];
              i = 0;
            case 1:
              if (!(i < handler.scriptTypes.length)) {
                _context.n = 4;
                break;
              }
              _context.n = 2;
              return IafScripts.getScripts({
                query: {
                  _userType: handler.scriptTypes[i]
                }
              });
            case 2:
              scr = _context.v;
              scriptVer = _.find(scr[0]._versions, {
                _version: scr[0]._tipVersion
              });
              script = scriptVer._userData;
              parsed = JSON.parse(script);
              allParsedScripts.push.apply(allParsedScripts, _toConsumableArray(parsed));
            case 3:
              i++;
              _context.n = 1;
              break;
            case 4:
              if (localStorage.ipaScriptRunnerLocalScripts && localStorage.ipaScriptRunnerLocalScripts.length) {
                scriptNames = localStorage.ipaScriptRunnerLocalScripts.split(",");
                scriptsToAdd = scriptNames.map(function (scrname) {
                  return {
                    name: scrname + ' (local)',
                    script: scrname,
                    local: true
                  };
                });
                scriptsToAdd.push.apply(scriptsToAdd, _toConsumableArray(scripts));
                scripts = scriptsToAdd;
              }
              operators = ScriptHelper.getScriptOperators();
              operators.sort();
              this.setState({
                parsedScript: allParsedScripts,
                scripts: scripts,
                selectedScript: scripts[0],
                operators: operators
              }, this.getScriptText);
              if (localStorage.ipaScriptRunnerConvertSetq) this.setState({
                convertSetq: true
              });
              this.readVars();
              if (localStorage.ipaScriptRunnerSnippet) this.setState({
                snippet: localStorage.ipaScriptRunnerSnippet
              });
              helpLinks = ScriptHelper.getScriptVar("scriptRunnerHelpLinks");
              if (helpLinks && helpLinks.length) this.setState({
                helpLinks: helpLinks
              });
              _context.n = 6;
              break;
            case 5:
              this.setState({
                scripts: scripts,
                selectedScript: scripts && scripts.length > 0 ? scripts[0] : null
              });
            case 6:
              return _context.a(2);
          }
        }, _callee, this);
      }));
      function _loadAsyncData() {
        return _loadAsyncData2.apply(this, arguments);
      }
      return _loadAsyncData;
    }() //FIND LATEST SCRIPT VERSION
  }, {
    key: "getScriptText",
    value: function getScriptText() {
      var _this2 = this;
      if (!this.state.selectedScript.local) {
        var defaultScript = false;
        this.state.parsedScript.forEach(function (def) {
          if (def.hasOwnProperty('$defscript')) {
            var namedScript = def.$defscript;
            if (namedScript.hasOwnProperty(_this2.state.selectedScript.script)) {
              defaultScript = JSON.stringify(namedScript[_this2.state.selectedScript.script], null, 3);
              _this2.setState({
                scriptJSON: defaultScript,
                scriptError: false
              });
              if (_this2.state.selectedScript.defaultInput) {
                _this2.setState({
                  scriptInput: JSON.stringify(_this2.state.selectedScript.defaultInput, null, 3)
                });
              } else _this2.setState({
                scriptInput: ""
              });
            }
          }
        });
        if (!defaultScript) this.setState({
          scriptJSON: "Script Not Found",
          scriptError: true
        });
      } else {
        var storKey = getLocalScriptKey(this.state.selectedScript.script);
        var scriptText = localStorage.getItem(storKey);
        if (!scriptText) scriptText = "Script Not Found";
        this.setState({
          scriptJSON: scriptText
        });
      }
    }
  }, {
    key: "handleVariableName",
    value: function handleVariableName(e) {
      this.setState({
        addVariable: e.target.value
      });
    }
  }, {
    key: "addScriptVar",
    value: function addScriptVar() {
      if (this.state.addVariable.trim().length) {
        var variables = _.cloneDeep(this.state.variables);
        var varName = this.state.addVariable;
        if (varName.charAt(0) === "$") varName = varName.slice(1);
        variables[varName] = {};
        this.setState({
          addVariable: "",
          variables: variables
        }, this.getScriptVars);
      }
    }
  }, {
    key: "getScriptVars",
    value: function () {
      var _getScriptVars = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3() {
        var _this3 = this;
        var allVars;
        return _regenerator().w(function (_context3) {
          while (1) switch (_context3.n) {
            case 0:
              allVars = Object.keys(this.state.variables);
              allVars.forEach(/*#__PURE__*/function () {
                var _ref = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(thisVar) {
                  var varValue, variables;
                  return _regenerator().w(function (_context2) {
                    while (1) switch (_context2.n) {
                      case 0:
                        _context2.n = 1;
                        return ScriptHelper.getScriptVar(thisVar);
                      case 1:
                        varValue = _context2.v;
                        variables = _.cloneDeep(_this3.state.variables);
                        variables[thisVar] = varValue;
                        _this3.setState({
                          variables: variables
                        }, _this3.writeVars);
                      case 2:
                        return _context2.a(2);
                    }
                  }, _callee2);
                }));
                return function (_x) {
                  return _ref.apply(this, arguments);
                };
              }());
            case 1:
              return _context3.a(2);
          }
        }, _callee3, this);
      }));
      function getScriptVars() {
        return _getScriptVars.apply(this, arguments);
      }
      return getScriptVars;
    }()
  }, {
    key: "writeVars",
    value: function writeVars() {
      var vars = Object.keys(this.state.variables);
      var strVars = vars.join(',');
      localStorage.setItem('ipaScriptRunnerVars', strVars);
    }
  }, {
    key: "readVars",
    value: function readVars() {
      if (localStorage.ipaScriptRunnerVars) {
        var vars = localStorage.ipaScriptRunnerVars.split(',');
        var newVars = {};
        vars.forEach(function (thisVar) {
          newVars[thisVar] = {};
        });
        this.setState({
          variables: newVars
        }, this.getScriptVars);
      }
    }
  }, {
    key: "clearVars",
    value: function clearVars(v) {
      if (v !== 'all') {
        var variables = _.cloneDeep(this.state.variables);
        delete variables[v];
        this.setState({
          variables: variables
        }, this.writeVars);
      } else this.setState({
        variables: {}
      }, this.writeVars);
    }
  }, {
    key: "clearVarValue",
    value: function clearVarValue(v) {
      ScriptHelper.setScriptVar(v, undefined);
      this.getScriptVars();
    }
  }, {
    key: "handleScriptSelect",
    value: function handleScriptSelect(option) {
      if (this.props.handler.config && this.props.handler.config.allowScriptInput) this.setState({
        selectedScript: option.value
      }, this.getScriptText);else this.setState({
        selectedScript: option.value
      });
    }
  }, {
    key: "runScript",
    value: function () {
      var _runScript = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4() {
        var _this4 = this;
        var results, dotInt, data, start, end, scriptInput, scriptInputObj, sourceJson, lineInfo, range, purifiedJSON, restringedDef, validated, evaldata, sName, elapsed, _t;
        return _regenerator().w(function (_context4) {
          while (1) switch (_context4.p = _context4.n) {
            case 0:
              results = this.state.results;
              this.setState({
                isRunning: true
              });
              dotInt = setInterval(function () {
                var newDots;
                if (_this4.state.dots.length === 15) newDots = '';else newDots = _this4.state.dots + ' . ';
                _this4.setState({
                  dots: newDots
                });
              }, 750);
              data = [];
              start = 0, end = 0; //if configured to display the script input and script always run the script from the ui
              if (!(this.props.handler.config && this.props.handler.config.allowScriptInput)) {
                _context4.n = 8;
                break;
              }
              scriptInput = this.state.scriptInput.trim();
              scriptInputObj = scriptInput && scriptInput.length > 0 ? json5.parse(scriptInput) : {};
              if (this.state.hasBreakLine) {
                lineInfo = this.findBreakLine(this.state.editor);
                if (!this.isValidBreakPoint(this.state.editor, lineInfo)) sourceJson = this.state.scriptJSON;else {
                  range = this.state.editor.getRange({
                    line: 0,
                    ch: 0
                  }, {
                    line: lineInfo.line,
                    ch: lineInfo.text.length
                  });
                  sourceJson = range + "]";
                }
              } else sourceJson = this.state.scriptJSON;
              _context4.p = 1;
              purifiedJSON = JSON.stringify(json5.parse(sourceJson));
              restringedDef = "[{$defscript: {'testScript':" + purifiedJSON + "}}]";
              if (this.state.convertSetq) restringedDef = restringedDef.replaceAll("$let", "$setq");
              validated = IafScripts.isValid(restringedDef);
              if (!validated) {
                _context4.n = 4;
                break;
              }
              _context4.n = 2;
              return ScriptHelper.evalExpressions(validated);
            case 2:
              evaldata = _context4.v;
              start = new Date();
              _context4.n = 3;
              return ScriptHelper.executeScript('testScript', scriptInputObj);
            case 3:
              data = _context4.v;
              end = new Date();
              this.getScriptVars();
              if (scriptInput && scriptInput.length > 0) data = {
                result: data,
                input: scriptInputObj
              };
              _context4.n = 5;
              break;
            case 4:
              data = {
                error: "Script is not in the correct format!"
              };
            case 5:
              _context4.n = 7;
              break;
            case 6:
              _context4.p = 6;
              _t = _context4.v;
              data = {
                error: "Script is not in the correct format!"
              };
            case 7:
              _context4.n = 10;
              break;
            case 8:
              start = new Date();
              _context4.n = 9;
              return ScriptHelper.executeScript(this.state.selectedScript.script);
            case 9:
              data = _context4.v;
              end = new Date();
            case 10:
              sName = this.state.selectedScript.name;
              elapsed = end.getTime() - start.getTime() + " ms";
              results.unshift({
                name: sName,
                data: data,
                stamp: end.toLocaleString(),
                elapsed: elapsed,
                disp: true,
                collapsed: false
              });
              clearInterval(dotInt);
              this.setState({
                dots: '',
                results: results,
                isRunning: false
              });
            case 11:
              return _context4.a(2);
          }
        }, _callee4, this, [[1, 6]]);
      }));
      function runScript() {
        return _runScript.apply(this, arguments);
      }
      return runScript;
    }()
  }, {
    key: "toggleDisplay",
    value: function toggleDisplay(e, index) {
      e.preventDefault();
      var results = this.state.results;
      results[index].disp = !results[index].disp;
      this.setState({
        results: results
      });
    }
  }, {
    key: "toggleCollapsed",
    value: function toggleCollapsed(e, index) {
      e.preventDefault();
      var results = this.state.results;
      results[index].collapsed = !results[index].collapsed;
      this.setState({
        results: results
      });
    }
  }, {
    key: "deleteResult",
    value: function deleteResult(e, index) {
      e.preventDefault();
      var results = this.state.results;
      if (!!index) results.splice(index, 1);else results = [];
      this.setState({
        results: results
      });
    }
  }, {
    key: "handleKeyDown",
    value: function handleKeyDown(event, ref, which) {
      if (event.keyCode === 9) {
        // tab was pressed
        event.preventDefault();
        var start = event.target.selectionStart,
          end = event.target.selectionEnd;
        var val;
        if (which === 'input') {
          val = this.state.scriptInput;
          this.setState({
            scriptInput: val.substring(0, start) + '\t' + val.substring(end)
          }, function () {
            ref.current.selectionStart = ref.current.selectionEnd = start + 1;
          });
        } else if (which === 'snippet') {
          val = this.state.snippet;
          this.setState({
            snippet: val.substring(0, start) + '\t' + val.substring(end)
          }, function () {
            ref.current.selectionStart = ref.current.selectionEnd = start + 1;
          });
        } else {
          val = this.state.scriptJSON;
          this.setState({
            scriptJSON: val.substring(0, start) + '\t' + val.substring(end)
          }, function () {
            ref.current.selectionStart = ref.current.selectionEnd = start + 1;
          });
        }
      }
    }
  }, {
    key: "onInputChange",
    value: function onInputChange(editor, data, value, which) {
      var inputError = false;
      if (this.props.handler.config && this.props.handler.config.allowScriptInput) {
        try {
          if (value.length) {
            json5.parse(value);
          }
        } catch (e) {
          inputError = true;
        }
      }
      if (which === 'input') this.setState({
        scriptInput: value,
        inputError: inputError
      });else {
        this.setState({
          scriptJSON: value,
          scriptError: inputError,
          editor: editor
        });
        if (this.state.selectedScript.local) {
          localStorage.setItem(getLocalScriptKey(this.state.selectedScript.script), value);
        }
      }
      if (this.state.hasBreakLine) {
        var lineInfo = this.findBreakLine(editor);
        if (!this.isValidBreakPoint(editor, lineInfo)) editor.setGutterMarker(lineInfo.line, "CodeMirror-breakpoint", this.makeInvalidBreakMark());else editor.setGutterMarker(lineInfo.line, "CodeMirror-breakpoint", this.makeValidBreakMark());
      }
    }
  }, {
    key: "toggleInputs",
    value: function toggleInputs(input) {
      if (input === 'input') this.setState({
        showInput: !this.state.showInput
      });else if (input === 'script') this.setState({
        showScript: !this.state.showScript
      });else this.setState({
        showOutput: !this.state.showOutput
      });
    }
  }, {
    key: "toggleConvertSetq",
    value: function toggleConvertSetq() {
      if (this.state.convertSetq) localStorage.removeItem('ipaScriptRunnerConvertSetq');else localStorage.setItem('ipaScriptRunnerConvertSetq', true);
      this.setState({
        convertSetq: !this.state.convertSetq
      });
    }
  }, {
    key: "saveSnippet",
    value: function saveSnippet(e) {
      this.setState({
        snippet: e.target.value
      });
      localStorage.setItem('ipaScriptRunnerSnippet', e.target.value);
    }
  }, {
    key: "handleNewScriptName",
    value: function handleNewScriptName(e) {
      this.setState({
        newScriptName: e.target.value
      });
    }
  }, {
    key: "addNewScript",
    value: function addNewScript() {
      var newName = this.state.newScriptName.trim().replaceAll(",", "").replaceAll(" ", "_");
      var newScript = {
        name: newName + " (local)",
        script: newName,
        local: true
      };
      var scripts = _.cloneDeep(this.state.scripts);
      scripts.unshift(newScript);
      var storKey = getLocalScriptKey(newName);
      localStorage.setItem(storKey, "[]");
      if (!localStorage.ipaScriptRunnerLocalScripts) localStorage.setItem("ipaScriptRunnerLocalScripts", newName);else localStorage.setItem("ipaScriptRunnerLocalScripts", localStorage.ipaScriptRunnerLocalScripts + "," + newName);
      this.setState({
        scripts: scripts,
        selectedScript: newScript
      }, this.getScriptText);
    }
  }, {
    key: "removeLocalScript",
    value: function removeLocalScript(e, scriptname) {
      e.preventDefault();
      var storKey = getLocalScriptKey(scriptname);
      localStorage.removeItem(storKey);
      var scriptNames = localStorage.ipaScriptRunnerLocalScripts.split(',');
      _.pull(scriptNames, scriptname);
      localStorage.setItem("ipaScriptRunnerLocalScripts", scriptNames.join(','));
      var scripts = _.cloneDeep(this.state.scripts);
      _.remove(scripts, function (n) {
        return n.script === scriptname;
      });
      if (this.state.selectedScript.script === scriptname) this.setState({
        scripts: scripts,
        selectedScript: scripts[0]
      });else this.setState({
        scripts: scripts
      });
    }
  }, {
    key: "makeValidBreakMark",
    value: function makeValidBreakMark() {
      var marker = document.createElement("div");
      marker.style.color = "#cc3333";
      marker.innerHTML = "●";
      return marker;
    }
  }, {
    key: "makeInvalidBreakMark",
    value: function makeInvalidBreakMark() {
      var marker = document.createElement("div");
      marker.style.color = "#3399ff";
      marker.innerHTML = "●";
      return marker;
    }
  }, {
    key: "isValidBreakPoint",
    value: function isValidBreakPoint(e, lineInfo) {
      try {
        var range = e.getRange({
          line: 0,
          ch: 0
        }, {
          line: lineInfo.line,
          ch: lineInfo.text.length
        });
        range = range + "]";
        json5.parse(range);
        return true;
      } catch (e) {
        return false;
      }
    }
  }, {
    key: "findBreakLine",
    value: function findBreakLine(editor) {
      var line = null;
      for (var i = 0; i < editor.doc.children[0].lines.length; i++) {
        line = editor.doc.children[0].lines[i];
        if (line.gutterMarkers && line.gutterMarkers.hasOwnProperty('CodeMirror-breakpoint')) break;
      }
      return editor.lineInfo(editor.getLineNumber(line));
    }
  }, {
    key: "handleScriptGutterClick",
    value: function handleScriptGutterClick(editor, lineNum, gutter, event) {
      if (gutter === 'CodeMirror-breakpoint') {
        var lineInfo = editor.lineInfo(lineNum);

        //check if turning off breakpoint
        //clicked a line already set as breakLine
        if (lineInfo.gutterMarkers && lineInfo.gutterMarkers.hasOwnProperty('CodeMirror-breakpoint')) {
          editor.clearGutter("CodeMirror-breakpoint");
          this.setState({
            hasBreakLine: false
          });
        } else {
          //else remove existing break if it exists and create new one
          if (this.isValidBreakPoint(editor, lineInfo)) {
            if (this.state.hasBreakLine) editor.clearGutter("CodeMirror-breakpoint");
            editor.setGutterMarker(lineInfo.line, "CodeMirror-breakpoint", this.makeValidBreakMark());
            this.setState({
              hasBreakLine: true
            });
          }
        }
      }
    }
  }, {
    key: "setEditor",
    value: function setEditor(editor) {
      this.setState({
        editor: editor
      });
    }
  }, {
    key: "getOperatorHints",
    value: function getOperatorHints(editor, option) {
      var _this5 = this;
      return new Promise(function (resolve) {
        var cursor = editor.getCursor(),
          line = editor.getLine(cursor.line);
        var start = cursor.ch,
          end = cursor.ch;
        while (start && /\w|\$/.test(line.charAt(start - 1))) --start;
        while (end < line.length && /\w/.test(line.charAt(end))) ++end;
        var word = line.slice(start, end).toLowerCase();
        var completions = _this5.state.operators.filter(function (o) {
          return o.toLowerCase().startsWith(word.toLowerCase());
        });
        var completion = {
          list: completions,
          from: {
            line: cursor.line,
            ch: start
          },
          to: {
            line: cursor.line,
            ch: end
          }
        };
        resolve(completion);
      });
    }
  }, {
    key: "handleOpSearchTerm",
    value: function handleOpSearchTerm(e) {
      this.setState({
        operatorSearchTerm: e.target.value
      });
    }
  }, {
    key: "searchOperators",
    value: function searchOperators() {
      var _this6 = this;
      var searchedOperators = this.state.operators.filter(function (o) {
        return o.toLowerCase().includes(_this6.state.operatorSearchTerm.toLowerCase());
      });
      this.setState({
        searchedOperators: searchedOperators
      });
    }
  }, {
    key: "clearOpSearchTerm",
    value: function clearOpSearchTerm() {
      this.setState({
        searchedOperators: null,
        operatorSearchTerm: ""
      });
    }
  }, {
    key: "componentDidMount",
    value: function () {
      var _componentDidMount = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee5() {
        return _regenerator().w(function (_context5) {
          while (1) switch (_context5.n) {
            case 0:
              //When the page mounts load the asyn data (script and other)
              //and then create the column info for the upload table
              this.setState({
                isPageLoading: true
              });
              _context5.n = 1;
              return this._loadAsyncData();
            case 1:
              this.setState({
                isPageLoading: false
              }, this.props.onLoadComplete);
              console.log('props', this.props);
              console.log('state', this.state);
            case 2:
              return _context5.a(2);
          }
        }, _callee5, this);
      }));
      function componentDidMount() {
        return _componentDidMount.apply(this, arguments);
      }
      return componentDidMount;
    }()
  }, {
    key: "render",
    value: function render() {
      var _this7 = this;
      return /*#__PURE__*/React.createElement("div", {
        style: {
          display: 'flex'
        }
      }, this.props.handler.config && this.props.handler.config.allowScriptInput && /*#__PURE__*/React.createElement(StackableDrawer, {
        level: 1,
        iconKey: "fas fa-cut",
        isDrawerOpen: false
      }, /*#__PURE__*/React.createElement("div", {
        style: {
          fontWeight: 'bold',
          marginTop: '20px',
          marginBottom: '20px',
          marginLeft: '60px'
        }
      }, "Snippets"), /*#__PURE__*/React.createElement("div", {
        className: "script-input",
        style: {
          marginLeft: '20px'
        }
      }, /*#__PURE__*/React.createElement("textarea", {
        id: "snippet",
        style: {
          width: '340px'
        },
        name: "snippets",
        rows: "100",
        placeholder: "Script Snippets",
        onChange: this.saveSnippet,
        onKeyDown: function onKeyDown(e) {
          return _this7.handleKeyDown(e, _this7.snippetInput, 'snippet');
        },
        value: this.state.snippet,
        ref: this.snippetInput
      }))), this.props.handler.config && this.props.handler.config.allowScriptInput && /*#__PURE__*/React.createElement(StackableDrawer, {
        level: 2,
        iconKey: "far fa-file-code",
        isDrawerOpen: false
      }, /*#__PURE__*/React.createElement("div", {
        style: {
          marginTop: '10px',
          marginLeft: '60px'
        }
      }, /*#__PURE__*/React.createElement("input", {
        type: "text",
        id: "newscripttoadd",
        value: this.state.newScriptName,
        onChange: this.handleNewScriptName,
        style: {
          width: "80%"
        }
      }), /*#__PURE__*/React.createElement(GenericMatButton, {
        disabled: this.state.isRunning,
        styles: {
          marginLeft: '110px',
          marginRight: '10px',
          marginTop: '5px'
        },
        onClick: this.addNewScript
      }, "Add Script")), /*#__PURE__*/React.createElement("hr", null), /*#__PURE__*/React.createElement("div", {
        style: {
          fontWeight: 'bold',
          marginTop: '20px',
          marginLeft: '60px'
        }
      }, "Local Scripts"), /*#__PURE__*/React.createElement("div", {
        style: {
          marginTop: '40px',
          marginLeft: '60px'
        }
      }, this.state.scripts.filter(function (scriptoption) {
        return scriptoption.local;
      }).map(function (scriptoption, index) {
        return /*#__PURE__*/React.createElement("div", {
          style: {
            marginBottom: '10px'
          },
          key: index
        }, /*#__PURE__*/React.createElement("a", {
          href: "#",
          style: {
            color: 'red',
            fontSize: '24px',
            display: 'inlineBlock',
            marginRight: '10px',
            marginTop: "5px"
          },
          onClick: function onClick(e) {
            return _this7.removeLocalScript(e, scriptoption.script);
          }
        }, /*#__PURE__*/React.createElement("i", {
          title: "Delete Local Script",
          className: "icon ion-android-cancel"
        })), " ", scriptoption.script);
      }))), this.props.handler.config && this.props.handler.config.allowScriptInput && /*#__PURE__*/React.createElement(StackableDrawer, {
        level: 3,
        iconKey: "fas fa-eye",
        isDrawerOpen: false
      }, /*#__PURE__*/React.createElement("div", {
        style: {
          marginTop: '10px',
          marginLeft: '60px'
        }
      }, /*#__PURE__*/React.createElement("div", {
        style: {
          display: 'inline-flex',
          alignItems: 'center'
        }
      }, /*#__PURE__*/React.createElement("input", {
        type: "text",
        id: "varnametoadd",
        value: this.state.addVariable,
        onChange: this.handleVariableName
      }), /*#__PURE__*/React.createElement(GenericMatButton, {
        disabled: this.state.isRunning,
        styles: {
          marginLeft: '10px',
          marginRight: '10px'
        },
        onClick: this.addScriptVar
      }, /*#__PURE__*/React.createElement("i", {
        className: "fas fa-eye"
      }), " Watch")), /*#__PURE__*/React.createElement("div", {
        style: {
          marginTop: '10px'
        }
      }, /*#__PURE__*/React.createElement("input", {
        type: "checkbox",
        id: "setq",
        value: this.state.convertSetq,
        checked: this.state.convertSetq,
        onChange: this.toggleConvertSetq
      }), /*#__PURE__*/React.createElement("label", {
        style: {
          marginLeft: '5px'
        }
      }, "Convert all $let to $setq when executing")), /*#__PURE__*/React.createElement("hr", null), /*#__PURE__*/React.createElement("div", {
        style: {
          fontWeight: 'bold',
          marginTop: '20px',
          marginLeft: '60px',
          marginBottom: '10px'
        }
      }, "Watched Variables"), /*#__PURE__*/React.createElement("div", {
        style: {
          cursor: 'pointer'
        },
        onClick: function onClick() {
          return _this7.clearVars('all');
        }
      }, /*#__PURE__*/React.createElement("span", {
        style: {
          fontSize: '18px'
        }
      }, /*#__PURE__*/React.createElement("i", {
        title: "Unwatch All",
        className: "fas fa-eye-slash"
      })), /*#__PURE__*/React.createElement("span", null, "Unwatch All")), /*#__PURE__*/React.createElement("hr", null), Object.keys(this.state.variables).map(function (v) {
        return /*#__PURE__*/React.createElement("div", {
          key: v,
          style: {
            marginBottom: '10px'
          }
        }, /*#__PURE__*/React.createElement("div", {
          style: {
            display: 'inline-flex'
          }
        }, /*#__PURE__*/React.createElement("div", {
          style: {
            fontSize: '18px',
            cursor: 'pointer',
            marginRight: '10px'
          },
          onClick: function onClick() {
            return _this7.clearVars(v);
          }
        }, /*#__PURE__*/React.createElement("i", {
          title: "Unwatch",
          className: "fas fa-eye-slash"
        })), /*#__PURE__*/React.createElement("div", {
          style: {
            fontSize: '18px',
            cursor: 'pointer',
            marginRight: '10px'
          },
          onClick: function onClick() {
            return _this7.clearVarValue(v);
          }
        }, /*#__PURE__*/React.createElement("i", {
          title: "Clear Value",
          className: "fas fa-times-circle"
        })), /*#__PURE__*/React.createElement("span", {
          style: {
            fontWeight: 'bold'
          }
        }, v)));
      }))), this.props.handler.config && this.props.handler.config.allowScriptInput && this.state.helpLinks.length > 0 && /*#__PURE__*/React.createElement(StackableDrawer, {
        level: 4,
        iconKey: "fas fa-dollar-sign",
        isDrawerOpen: false
      }, /*#__PURE__*/React.createElement("div", {
        style: {
          marginTop: '10px',
          marginLeft: '60px'
        }
      }, /*#__PURE__*/React.createElement("div", {
        style: {
          display: 'inline-flex',
          alignItems: 'center'
        }
      }, /*#__PURE__*/React.createElement("input", {
        type: "text",
        id: "opsearchterm",
        value: this.state.operatorSearchTerm,
        onChange: this.handleOpSearchTerm
      }), /*#__PURE__*/React.createElement("div", {
        style: {
          fontSize: '18px',
          cursor: 'pointer',
          marginLeft: '5px'
        },
        onClick: this.clearOpSearchTerm
      }, /*#__PURE__*/React.createElement("i", {
        title: "Clear Search",
        className: "fas fa-times-circle"
      })), /*#__PURE__*/React.createElement(GenericMatButton, {
        disabled: this.state.isRunning,
        styles: {
          marginLeft: '10px',
          marginRight: '10px'
        },
        onClick: this.searchOperators
      }, "Search"))), /*#__PURE__*/React.createElement("hr", null), /*#__PURE__*/React.createElement("div", {
        style: {
          fontWeight: 'bold',
          marginTop: '20px',
          marginLeft: '60px'
        }
      }, "Operators"), /*#__PURE__*/React.createElement("div", {
        style: {
          marginTop: '20px',
          marginLeft: '60px'
        }
      }, !this.state.searchedOperators ? this.state.operators.map(function (op, index) {
        return /*#__PURE__*/React.createElement("div", {
          style: {
            marginBottom: '10px'
          },
          key: index
        }, op);
      }) : this.state.searchedOperators.map(function (op, index) {
        return /*#__PURE__*/React.createElement("div", {
          style: {
            marginBottom: '10px'
          },
          key: index
        }, op);
      }))), this.props.handler.config && this.props.handler.config.allowScriptInput && this.state.helpLinks.length > 0 && /*#__PURE__*/React.createElement(StackableDrawer, {
        level: 5,
        iconKey: "fas fa-question",
        isDrawerOpen: false
      }, /*#__PURE__*/React.createElement("div", {
        style: {
          fontWeight: 'bold',
          marginTop: '20px',
          marginLeft: '60px'
        }
      }, "Help Topics"), /*#__PURE__*/React.createElement("div", {
        style: {
          marginTop: '40px',
          marginLeft: '60px'
        }
      }, this.state.helpLinks.map(function (link, index) {
        return /*#__PURE__*/React.createElement("div", {
          style: {
            marginBottom: '10px'
          },
          key: index
        }, /*#__PURE__*/React.createElement("a", {
          href: link.url,
          target: "_blank"
        }, link.name));
      }))), /*#__PURE__*/React.createElement("div", {
        style: {
          width: '100%'
        }
      }, /*#__PURE__*/React.createElement("div", {
        style: {
          padding: '40px',
          marginTop: '20px'
        }
      }, /*#__PURE__*/React.createElement("div", {
        style: {
          marginLeft: '15%',
          marginRight: '15%'
        }
      }, /*#__PURE__*/React.createElement("div", {
        style: {
          display: 'flex',
          alignItems: 'center'
        }
      }, /*#__PURE__*/React.createElement(Select, {
        key: 'scripts',
        value: {
          label: this.state.selectedScript ? this.state.selectedScript.name : "",
          value: this.state.selectedScript ? this.state.selectedScript : "",
          key: this.state.selectedScript ? this.state.selectedScript.name : ""
        },
        onChange: this.handleScriptSelect,
        disabled: this.state.isRunning || !this.state.selectedScript,
        options: this.state.scripts.map(function (scr) {
          return {
            key: scr.name,
            value: scr,
            label: scr.name
          };
        }),
        styles: {
          container: function container(provided) {
            return _objectSpread2(_objectSpread2({}, provided), {}, {
              zIndex: 1000,
              width: '40%',
              display: 'inline-block',
              marginLeft: '10%',
              marginRight: '15px',
              fontSize: '16px'
            });
          }
        }
      }), !this.state.isRunning && /*#__PURE__*/React.createElement(GenericMatButton, {
        onClick: this.runScript,
        disabled: this.state.scriptError,
        customClasses: "attention"
      }, "Run"), this.state.isRunning && /*#__PURE__*/React.createElement("span", {
        style: {
          fontSize: '16px'
        }
      }, "Running ", this.state.dots), this.props.handler.config && this.props.handler.config.allowScriptInput && /*#__PURE__*/React.createElement(GenericMatButton, {
        onClick: function onClick() {
          return _this7.toggleInputs('input');
        },
        disabled: this.state.isRunning,
        styles: {
          marginLeft: '20px',
          marginRight: '10px'
        }
      }, this.state.showInput ? 'Hide Input' : 'Show Input'), this.props.handler.config && this.props.handler.config.allowScriptInput && /*#__PURE__*/React.createElement(GenericMatButton, {
        onClick: function onClick() {
          return _this7.toggleInputs('script');
        },
        disabled: this.state.isRunning,
        styles: {
          marginLeft: '10px',
          marginRight: '10px'
        }
      }, this.state.showScript ? 'Hide Script' : 'Show Script'), this.props.handler.config && this.props.handler.config.allowScriptInput && /*#__PURE__*/React.createElement(GenericMatButton, {
        onClick: function onClick() {
          return _this7.toggleInputs('output');
        },
        disabled: this.state.isRunning,
        styles: {
          marginLeft: '10px'
        }
      }, this.state.showOutput ? 'Hide Output' : 'Show Output')), this.props.handler.config && this.props.handler.config.allowScriptInput && /*#__PURE__*/React.createElement("div", {
        style: {
          marginTop: '20px'
        }
      }, /*#__PURE__*/React.createElement("div", {
        style: {
          height: 'fit-content'
        }
      }, this.state.showInput && /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", {
        className: "script-input",
        style: {
          marginTop: '20px',
          width: '100%'
        }
      }, /*#__PURE__*/React.createElement(Controlled, {
        value: this.state.scriptInput,
        options: {
          mode: 'javascript',
          theme: 'monokai-sublime',
          lineNumbers: true,
          matchBrackets: true,
          autoCloseBrackets: true,
          foldGutter: true,
          gutters: ['CodeMirror-linenumbers', 'CodeMirror-foldgutter']
        },
        className: "cm-inputer",
        onBeforeChange: function onBeforeChange(editor, data, value) {
          return _this7.onInputChange(editor, data, value, 'input');
        }
      })), this.state.inputError && /*#__PURE__*/React.createElement("div", {
        style: {
          color: 'red'
        }
      }, "Input is not in JSON format")), this.state.showScript && /*#__PURE__*/React.createElement("div", null, this.state.scriptError && /*#__PURE__*/React.createElement("div", {
        style: {
          color: 'red'
        }
      }, "Script is not in correct format"), /*#__PURE__*/React.createElement("div", {
        className: "script-script",
        style: {
          marginTop: '20px',
          width: '100%'
        }
      }, /*#__PURE__*/React.createElement(Controlled, {
        value: this.state.scriptJSON,
        options: {
          mode: 'javascript',
          theme: 'monokai-sublime',
          lineNumbers: true,
          matchBrackets: true,
          autoCloseBrackets: true,
          foldGutter: true,
          extraKeys: {
            'Ctrl-/': function Ctrl_(editor) {
              editor.execCommand('toggleComment');
            },
            "Ctrl-Space": "autocomplete"
          },
          hintOptions: {
            hint: this.getOperatorHints
          },
          gutters: ['CodeMirror-linenumbers', 'CodeMirror-foldgutter', 'CodeMirror-breakpoint']
        },
        className: "cm-scripter",
        onBeforeChange: function onBeforeChange(editor, data, value) {
          return _this7.onInputChange(editor, data, value, 'script');
        },
        onGutterClick: this.handleScriptGutterClick,
        editorDidMount: this.setEditor
      })), this.state.scriptError && /*#__PURE__*/React.createElement("div", {
        style: {
          color: 'red'
        }
      }, "Script is not in correct format")))), this.state.showOutput && this.state.results.map(function (res, index) {
        return /*#__PURE__*/React.createElement("div", {
          key: index
        }, /*#__PURE__*/React.createElement("hr", null), /*#__PURE__*/React.createElement("div", {
          className: "mbsc-row mbsc-align-items-center",
          style: {
            marginBottom: '15px'
          }
        }, /*#__PURE__*/React.createElement("div", {
          className: "mbsc-col-md-6 mbsc-col-12"
        }, _this7.state.results.length > 0 && /*#__PURE__*/React.createElement("div", {
          style: {
            textAlign: 'right',
            color: 'red'
          }
        }, "Delete All Results", /*#__PURE__*/React.createElement("a", {
          href: "#",
          style: {
            color: 'red',
            fontSize: '24px',
            display: 'inlineBlock',
            marginLeft: '10px'
          },
          onClick: function onClick(e) {
            return _this7.deleteResult(e);
          }
        }, /*#__PURE__*/React.createElement("i", {
          title: "Delete All",
          className: "icon ion-android-cancel"
        }))))), /*#__PURE__*/React.createElement("div", {
          className: "mbsc-row mbsc-align-items-center"
        }, /*#__PURE__*/React.createElement("div", {
          className: "mbsc-col-md-6 mbsc-col-6",
          style: {
            textAlign: 'left'
          }
        }, /*#__PURE__*/React.createElement("h4", {
          style: {
            display: 'inline'
          }
        }, res.name), !res.collapsed && /*#__PURE__*/React.createElement("a", {
          href: "#",
          style: {
            display: 'inline',
            marginLeft: '10px'
          },
          onClick: function onClick(e) {
            return _this7.toggleDisplay(e, index);
          }
        }, res.disp ? 'Raw' : 'Pretty')), /*#__PURE__*/React.createElement("div", {
          className: "mbsc-col-md-6 mbsc-col-6",
          style: {
            textAlign: 'right'
          }
        }, /*#__PURE__*/React.createElement("a", {
          href: "#",
          style: {
            textAlign: 'right',
            display: 'inlineBlock',
            marginRight: '10px'
          },
          onClick: function onClick(e) {
            return _this7.toggleCollapsed(e, index);
          }
        }, res.collapsed ? 'Show' : 'Hide'), /*#__PURE__*/React.createElement("a", {
          href: "#",
          style: {
            color: 'red',
            fontSize: '18px',
            textAlign: 'right',
            display: 'inlineBlock',
            marginRight: '10px'
          },
          onClick: function onClick(e) {
            return _this7.deleteResult(e, index);
          }
        }, /*#__PURE__*/React.createElement("i", {
          title: "Delete",
          className: "icon ion-android-cancel"
        }))), /*#__PURE__*/React.createElement("div", {
          className: "mbsc-col-md-12 mbsc-col-12",
          style: {
            textAlign: 'left',
            marginBottom: '10px'
          }
        }, /*#__PURE__*/React.createElement("span", {
          style: {
            paddingLeft: '15px',
            fontStyle: "italic"
          }
        }, res.stamp), /*#__PURE__*/React.createElement("span", {
          style: {
            paddingLeft: '15px',
            fontWeight: "bold"
          }
        }, "(", res.elapsed, ")"))), !res.collapsed && /*#__PURE__*/React.createElement("div", {
          style: {
            marginTop: '10px',
            userSelect: 'text'
          }
        }, !res.disp && /*#__PURE__*/React.createElement("pre", {
          contentEditable: "true",
          suppressContentEditableWarning: true
        }, JSON.stringify(res.data, null, 3))));
      })))));
    }
  }]);
}(React.Component);

//Paths to various platform supplied pages

var PLATFORM_PATHS = {
  DOWNLOADS: endPointConfig.pluginBaseUrl + 'index.json',
  PLUGIN_BASE: endPointConfig.pluginBaseUrl,
  USER_ACCOUNT: endPointConfig.passportServiceOrigin + '/passportsvc/api/accounts'
};
var getPlatformPath = function getPlatformPath(pathname, addPath) {
  if (!pathname) return null;else return PLATFORM_PATHS[pathname] + (addPath ? addPath : "");
};

var DownloadsView = /*#__PURE__*/function (_React$Component) {
  function DownloadsView(props) {
    var _this;
    _classCallCheck(this, DownloadsView);
    _this = _callSuper(this, DownloadsView, [props]);
    _this.state = {
      isPageLoading: true,
      manifests: [],
      error: null
    };
    _this._loadAsyncData = _this._loadAsyncData.bind(_this);
    _this.toggleDetails = _this.toggleDetails.bind(_this);
    return _this;
  }
  _inherits(DownloadsView, _React$Component);
  return _createClass(DownloadsView, [{
    key: "_loadAsyncData",
    value: function () {
      var _loadAsyncData2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2() {
        var _this2 = this;
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              fetch(getPlatformPath('DOWNLOADS')).then(/*#__PURE__*/function () {
                var _ref = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(resp) {
                  var downs, manifests, i, mani, v, ver, _resp;
                  return _regenerator().w(function (_context) {
                    while (1) switch (_context.n) {
                      case 0:
                        _context.n = 1;
                        return resp.json();
                      case 1:
                        downs = _context.v;
                        manifests = [];
                        downs.manifests.forEach(function (mani) {
                          if (_this2.props.handler.systems.includes(mani.system)) manifests.push(mani);
                        });
                        i = 0;
                      case 2:
                        if (!(i < manifests.length)) {
                          _context.n = 9;
                          break;
                        }
                        mani = manifests[i];
                        v = 0;
                      case 3:
                        if (!(v < mani.versions.length)) {
                          _context.n = 7;
                          break;
                        }
                        ver = mani.versions[v];
                        ver.showDetails = false;
                        _context.n = 4;
                        return fetch(getPlatformPath('PLUGIN_BASE', ver.manifest))["catch"](function (err) {
                          console.log(err);
                        });
                      case 4:
                        _resp = _context.v;
                        _context.n = 5;
                        return _resp.json();
                      case 5:
                        ver.details = _context.v;
                      case 6:
                        v++;
                        _context.n = 3;
                        break;
                      case 7:
                      case 8:
                        i++;
                        _context.n = 2;
                        break;
                      case 9:
                        _this2.setState({
                          manifests: manifests
                        });
                      case 10:
                        return _context.a(2);
                    }
                  }, _callee);
                }));
                return function (_x) {
                  return _ref.apply(this, arguments);
                };
              }())["catch"](function (err) {
                console.log('-->', err);
                _this2.setState({
                  isPageLoading: false,
                  error: err.toString()
                });
              });
            case 1:
              return _context2.a(2);
          }
        }, _callee2);
      }));
      function _loadAsyncData() {
        return _loadAsyncData2.apply(this, arguments);
      }
      return _loadAsyncData;
    }()
  }, {
    key: "toggleDetails",
    value: function toggleDetails(manifest, version) {
      var manifests = this.state.manifests;
      for (var i = 0; i < manifests.length; i++) {
        if (manifests[i].system === manifest.system) {
          var mani = manifests[i];
          for (var v = 0; v < mani.versions.length; v++) {
            var ver = mani.versions[v];
            if (ver.version === version.version) {
              ver.showDetails = !ver.showDetails;
              break;
            }
          }
          break;
        }
      }
      this.setState({
        manifests: manifests
      });
    }
  }, {
    key: "componentDidMount",
    value: function () {
      var _componentDidMount = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3() {
        return _regenerator().w(function (_context3) {
          while (1) switch (_context3.n) {
            case 0:
              //When the page mounts load the asyn data (script and other)
              //and then create the column info for the upload table
              this.setState({
                isPageLoading: true
              });
              _context3.n = 1;
              return this._loadAsyncData();
            case 1:
              this.setState({
                isPageLoading: false
              }, this.props.onLoadComplete);
              console.log('props', this.props);
              console.log('state', this.state);
            case 2:
              return _context3.a(2);
          }
        }, _callee3, this);
      }));
      function componentDidMount() {
        return _componentDidMount.apply(this, arguments);
      }
      return componentDidMount;
    }()
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;
      var headerStyles = {
        fontWeight: 'bold',
        padding: '8px'
      };
      var cellStyles = {
        padding: '8px'
      };
      return /*#__PURE__*/React.createElement("div", null, !this.state.isPageLoading && !!this.state.error && /*#__PURE__*/React.createElement("div", null, this.state.error), !this.state.isPageLoading && !this.state.error ? /*#__PURE__*/React.createElement("div", {
        style: {
          padding: '40px'
        }
      }, /*#__PURE__*/React.createElement("div", {
        style: {
          marginLeft: '20%',
          marginRight: '20%'
        }
      }, this.state.manifests.map(function (mani) {
        return /*#__PURE__*/React.createElement("div", {
          key: mani.system
        }, /*#__PURE__*/React.createElement("h3", null, mani.system), /*#__PURE__*/React.createElement("div", {
          style: {
            marginLeft: '20px',
            marginTop: '20px'
          }
        }, mani.versions.map(function (ver) {
          return /*#__PURE__*/React.createElement("div", {
            key: ver.manifest,
            style: {
              verticalAlign: 'center'
            }
          }, /*#__PURE__*/React.createElement("h4", {
            style: {
              display: 'inline',
              marginRight: '20px'
            }
          }, ver.details.resources.en.name), /*#__PURE__*/React.createElement("i", {
            title: "Info",
            style: {
              cursor: 'pointer',
              fontSize: '24px',
              display: 'inline',
              color: '#387ef5',
              marginRight: '20px'
            },
            className: "ion-ios-information-outline",
            onClick: function onClick(e) {
              return _this3.toggleDetails(mani, ver);
            }
          }), /*#__PURE__*/React.createElement("a", {
            href: getPlatformPath('PLUGIN_BASE', ver.details.filename)
          }, /*#__PURE__*/React.createElement("i", {
            title: "Download",
            style: {
              cursor: 'pointer',
              fontSize: '24px',
              display: 'inline',
              color: '#387ef5'
            },
            className: "icon ion-ios-cloud-download"
          })), ver.showDetails && /*#__PURE__*/React.createElement("div", {
            style: {
              marginLeft: '20px',
              marginTop: '10px'
            }
          }, /*#__PURE__*/React.createElement("table", null, /*#__PURE__*/React.createElement("tbody", null, /*#__PURE__*/React.createElement("tr", null, /*#__PURE__*/React.createElement("th", {
            style: headerStyles
          }, "Filename"), /*#__PURE__*/React.createElement("td", {
            style: cellStyles
          }, ver.details.filename.split('/')[1])), /*#__PURE__*/React.createElement("tr", null, /*#__PURE__*/React.createElement("th", {
            style: headerStyles
          }, "File Size"), /*#__PURE__*/React.createElement("td", {
            style: cellStyles
          }, Math.round(ver.details.filesize / 1000000 * 100) / 100 + ' MB')), /*#__PURE__*/React.createElement("tr", null, /*#__PURE__*/React.createElement("th", {
            style: headerStyles
          }, "Language"), /*#__PURE__*/React.createElement("td", {
            style: cellStyles
          }, ver.details.resources.en.displaylanguage)), /*#__PURE__*/React.createElement("tr", null, /*#__PURE__*/React.createElement("th", {
            style: headerStyles
          }, "Supported Operating Systems"), /*#__PURE__*/React.createElement("td", {
            style: cellStyles
          }, ver.details.resources.en.ossupport)), /*#__PURE__*/React.createElement("tr", null, /*#__PURE__*/React.createElement("th", {
            style: headerStyles
          }, "Updated"), /*#__PURE__*/React.createElement("td", {
            style: cellStyles
          }, moment(parseInt(ver.details.posteddate)).format('dddd, MMMM Do YYYY'))), /*#__PURE__*/React.createElement("tr", null, /*#__PURE__*/React.createElement("th", {
            style: headerStyles
          }, "Version"), /*#__PURE__*/React.createElement("td", {
            style: cellStyles
          }, ver.details.version))))), /*#__PURE__*/React.createElement("hr", null));
        })));
      }))) : null);
    }
  }]);
}(React.Component);

var css_248z$9 = ".user-group-view {\n  display: flex;\n  width: 100%;\n  height: calc(100vh - 80px);\n}\n.user-group-view .bold {\n  font-weight: bold;\n}\n.user-group-view hr {\n  margin-bottom: 0px;\n}\n.user-group-view .user-group-list-item {\n  list-style-type: none;\n  border: 1px solid lightgray;\n  border-radius: 10px;\n  margin: 10px;\n  padding: 5px 5px 5px 20px;\n  box-shadow: 2px 2px lightgrey;\n}\n.user-group-view .user-group-list-item .user-full-name.current-user {\n  color: var(--app-accent-color);\n  font-weight: bold;\n}\n.user-group-view .user-group-list-item .user-email {\n  padding-left: 10px;\n  font-size: 0.75rem;\n  font-style: italic;\n  width: 100%;\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n}\n.user-group-view .user-group-list-item:hover {\n  background-color: #f2f2f2;\n}\n.user-group-view .user-group-list-item.selectable {\n  cursor: pointer;\n}\n.user-group-view .user-group-list-item.active {\n  list-style-type: none;\n  border-left: 10px solid var(--app-accent-color);\n  border-top: 1px solid lightgray;\n  border-right: 1px solid lightgray;\n  border-radius: 10px;\n  padding-left: 10px;\n}\n.user-group-view .user-group-list-item.invite {\n  display: flex;\n  flex-direction: column;\n}\n.user-group-view .user-group-list-item.invite .card-row1 .invite-user-info {\n  width: 30%;\n}\n.user-group-view .card-row1 {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n}\n.user-group-view .invite-info {\n  margin-left: 50px;\n}\n.user-group-view .card-actions {\n  align-self: center;\n  color: var(--app-accent-color);\n}\n.user-group-view .card-actions i {\n  cursor: pointer;\n}\n.user-group-view .card-row2 {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-around;\n  border-top: solid 2px #f2f2f2;\n  padding: 10px;\n  margin-top: 10px;\n}\n.user-group-view .card-row2 .confirm-text {\n  font-weight: bold;\n}\n.user-group-view .card-row2 i {\n  padding-right: 0px;\n}\n.user-group-view .card-row2 a {\n  color: var(--app-accent-color);\n}\n.user-group-view .card-row2:hover {\n  background-color: white;\n  border-radius: 10px;\n  border: 1px solid var(--app-accent-color);\n}\n.user-group-view .disabled-group-list-item {\n  list-style-type: none;\n  border: 1px solid lightgray;\n  border-radius: 10px;\n  margin: 10px;\n  padding: 5px 5px 5px 20px;\n  background-color: #f2f2f2;\n}\n.user-group-view .throbber {\n  padding-left: 15px;\n}\n.user-group-view .switchable-list-view {\n  display: flex;\n  flex-direction: column;\n  padding: 80px 20px;\n}\n.user-group-view .switchable-list-view .list-header {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  align-items: center;\n}\n.user-group-view .usergroup-mode-view {\n  display: flex;\n  flex-direction: column;\n  width: 100%;\n  height: calc(100vh - 80px);\n}\n.user-group-view .usergroup-mode-view .row1 .usergroup-info {\n  display: flex;\n  align-items: flex-end;\n  justify-content: space-between;\n}\n.user-group-view .usergroup-mode-view .row1 .usergroup-name {\n  display: flex;\n  align-items: flex-end;\n  padding-left: 50px;\n  padding-top: 20px;\n}\n.user-group-view .usergroup-mode-view .row1 .usergroup-name h1 {\n  margin-bottom: 0px;\n}\n.user-group-view .usergroup-mode-view .row1 .usergroup-name .ug-btn {\n  color: var(--app-accent-color);\n  margin-left: 10px;\n}\n.user-group-view .usergroup-mode-view .row1 .usergroup-name .ug-btn a {\n  color: var(--app-accent-color);\n}\n.user-group-view .usergroup-mode-view .row1 .usergroup-name .disabled-ug-btn {\n  color: lightgray;\n}\n.user-group-view .usergroup-mode-view .row1 .usergroup-name.editable h1 {\n  flex-basis: 50%;\n}\n.user-group-view .usergroup-mode-view .row1 .usergroup-name.editable .usergroup-name-input {\n  background-color: #f2f2f2;\n  border-top: none;\n  border-right: none;\n  border-bottom: 2px solid var(--app-accent-color);\n  border-left: none;\n  width: 100%;\n}\n.user-group-view .usergroup-mode-view .row1 .usergroup-name-error {\n  color: var(--app-accent-color);\n  padding-left: 50px;\n  font-weight: bold;\n}\n.user-group-view .usergroup-mode-view .row2 {\n  display: flex;\n  flex-direction: row;\n  height: 100%;\n  padding-left: 50px;\n  width: 100%;\n  overflow-y: auto;\n}\n.user-group-view .usergroup-mode-view .row2::-webkit-scrollbar {\n  width: 7px;\n  height: 7px;\n}\n.user-group-view .usergroup-mode-view .row2::-webkit-scrollbar-track {\n  background: white;\n}\n.user-group-view .usergroup-mode-view .row2::-webkit-scrollbar-thumb {\n  background: #DCDCDC;\n  border-radius: 2rem;\n}\n.user-group-view .usergroup-mode-view .row2::-webkit-scrollbar-thumb:hover {\n  background: #B8B8B8;\n}\n.user-group-view .usergroup-mode-view .row2 .usergroup-members {\n  width: 50%;\n  border-right: 1px solid lightgray;\n  padding: 10px 10px 0px 10px;\n  overflow-y: auto;\n}\n.user-group-view .usergroup-mode-view .row2 .usergroup-members h3 {\n  color: var(--app-accent-color);\n  padding-left: 15px;\n}\n.user-group-view .usergroup-mode-view .row2 .usergroup-invites {\n  width: 50%;\n  padding: 10px 10px 0px 10px;\n  overflow-y: auto;\n}\n.user-group-view .usergroup-mode-view .row2 .usergroup-invites h3 {\n  color: var(--app-accent-color);\n  padding-left: 15px;\n}\n.user-group-view .usergroup-mode-view .row2 .usergroup-invites .indent-header {\n  margin-left: 15px;\n}\n.user-group-view .usergroup-mode-view .row2.table {\n  margin-bottom: 30px;\n}\n.user-group-view .user-mode-view {\n  width: 100%;\n  height: calc(100vh - 80px);\n}\n.user-group-view .user-mode-view .row1 .user-name-title {\n  padding-left: 50px;\n  padding-top: 20px;\n}\n.user-group-view .user-mode-view .row1 .user-name-title h1 {\n  margin-bottom: 0px;\n}\n.user-group-view .user-mode-view .row2 {\n  display: flex;\n  flex-direction: row;\n  height: 100%;\n  padding-left: 50px;\n  overflow-y: auto;\n}\n.user-group-view .user-mode-view .row2 .member-usergroups {\n  width: 50%;\n  height: 100%;\n  border-right: 1px solid lightgray;\n  padding: 10px 10px 0px 10px;\n  overflow-y: auto;\n}\n.user-group-view .user-mode-view .row2 .member-usergroups h3 {\n  color: var(--app-accent-color);\n  padding-left: 15px;\n}\n.user-group-view .user-mode-view .row2 .member-invites {\n  width: 50%;\n  height: 100%;\n  padding: 10px 10px 0px 10px;\n  overflow-y: auto;\n}\n.user-group-view .user-mode-view .row2 .member-invites h3 {\n  color: var(--app-accent-color);\n  padding-left: 15px;\n}\n.user-group-view .user-mode-view .row2 .member-invites .indent-header {\n  margin-left: 15px;\n}";
styleInject(css_248z$9);

var GroupCard = function GroupCard(_ref) {
  var group = _ref.group,
    user = _ref.user,
    _ref$disabled = _ref.disabled,
    disabled = _ref$disabled === void 0 ? false : _ref$disabled,
    _ref$selectable = _ref.selectable,
    selectable = _ref$selectable === void 0 ? false : _ref$selectable,
    _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
    onClick = _ref.onClick,
    _ref$showActions = _ref.showActions,
    showActions = _ref$showActions === void 0 ? false : _ref$showActions,
    canRemoveUser = _ref.canRemoveUser,
    onRemoveUser = _ref.onRemoveUser;
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isDeleting = _useState2[0],
    setIsDeleting = _useState2[1];
  var _useState3 = useState(''),
    _useState4 = _slicedToArray(_useState3, 2),
    actionText = _useState4[0],
    setActionText = _useState4[1];
  var _useState5 = useState(false),
    _useState6 = _slicedToArray(_useState5, 2),
    allowRemove = _useState6[0],
    setAllowRemove = _useState6[1];
  var _useState7 = useState(false),
    _useState8 = _slicedToArray(_useState7, 2),
    removing = _useState8[0],
    setRemoving = _useState8[1];
  var confirmRemove = /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(e) {
      var canRemove;
      return _regenerator().w(function (_context) {
        while (1) switch (_context.n) {
          case 0:
            if (e) e.preventDefault();
            setAllowRemove(false);
            setIsDeleting(true);
            _context.n = 1;
            return canRemoveUser(null, group);
          case 1:
            canRemove = _context.v;
            setActionText(canRemove.message);
            if (canRemove.allow) {
              setAllowRemove(true);
            }
          case 2:
            return _context.a(2);
        }
      }, _callee);
    }));
    return function confirmRemove(_x) {
      return _ref2.apply(this, arguments);
    };
  }();
  var cancelRemove = function cancelRemove(e) {
    if (e) e.preventDefault();
    setIsDeleting(false);
  };
  var removeConfirmed = function removeConfirmed(e) {
    if (e) e.preventDefault();
    setRemoving(true);
    setActionText('Removing User');
    onRemoveUser(null, group);
  };
  if (selectable) return /*#__PURE__*/React.createElement("li", {
    onClick: onClick,
    className: clsx('user-group-list-item selectable', isSelected && 'active')
  }, group._name);else return /*#__PURE__*/React.createElement("li", {
    className: clsx(!disabled && 'user-group-list-item', disabled && 'disabled-group-list-item')
  }, /*#__PURE__*/React.createElement("div", {
    className: "card-row1"
  }, /*#__PURE__*/React.createElement("div", null, group._name), showActions && /*#__PURE__*/React.createElement("div", {
    className: "card-actions"
  }, !isDeleting && /*#__PURE__*/React.createElement("i", {
    className: "fas fa-trash",
    onClick: confirmRemove
  }))), isDeleting && /*#__PURE__*/React.createElement("div", {
    className: "card-row2"
  }, !removing && /*#__PURE__*/React.createElement("div", {
    className: "confirm-text"
  }, actionText), !removing && allowRemove && /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("a", {
    href: "#",
    onClick: removeConfirmed
  }, /*#__PURE__*/React.createElement("i", {
    className: "fas fa-check"
  }), " Remove User")), !removing && /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("a", {
    href: "#",
    onClick: cancelRemove
  }, /*#__PURE__*/React.createElement("i", {
    className: "fas fa-times"
  }), " Cancel")), removing && /*#__PURE__*/React.createElement(SimpleTextThrobber, {
    throbberText: actionText
  })));
};

var UserCard = function UserCard(_ref) {
  var user = _ref.user,
    _ref$isCurrentUser = _ref.isCurrentUser,
    isCurrentUser = _ref$isCurrentUser === void 0 ? false : _ref$isCurrentUser,
    _ref$selectable = _ref.selectable,
    selectable = _ref$selectable === void 0 ? false : _ref$selectable,
    _ref$isSelected = _ref.isSelected,
    isSelected = _ref$isSelected === void 0 ? false : _ref$isSelected,
    _ref$showActions = _ref.showActions,
    showActions = _ref$showActions === void 0 ? false : _ref$showActions,
    onClick = _ref.onClick,
    canRemoveUser = _ref.canRemoveUser,
    onRemoveUser = _ref.onRemoveUser,
    _ref$removeUserText = _ref.removeUserText,
    removeUserText = _ref$removeUserText === void 0 ? "Remove User" : _ref$removeUserText,
    _ref$cancelText = _ref.cancelText,
    cancelText = _ref$cancelText === void 0 ? "Cancel" : _ref$cancelText;
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isDeleting = _useState2[0],
    setIsDeleting = _useState2[1];
  var _useState3 = useState(''),
    _useState4 = _slicedToArray(_useState3, 2),
    actionText = _useState4[0],
    setActionText = _useState4[1];
  var _useState5 = useState(false),
    _useState6 = _slicedToArray(_useState5, 2),
    allowRemove = _useState6[0],
    setAllowRemove = _useState6[1];
  var confirmRemove = /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(e) {
      var canRemove;
      return _regenerator().w(function (_context) {
        while (1) switch (_context.n) {
          case 0:
            if (e) e.preventDefault();
            setAllowRemove(false);
            setIsDeleting(true);
            _context.n = 1;
            return canRemoveUser(user);
          case 1:
            canRemove = _context.v;
            setActionText(canRemove.message);
            if (canRemove.allow) {
              setAllowRemove(true);
            }
          case 2:
            return _context.a(2);
        }
      }, _callee);
    }));
    return function confirmRemove(_x) {
      return _ref2.apply(this, arguments);
    };
  }();
  var cancelRemove = function cancelRemove(e) {
    if (e) e.preventDefault();
    setIsDeleting(false);
  };
  var removeConfirmed = function removeConfirmed(e) {
    if (e) e.preventDefault();
    onRemoveUser(user);
  };
  if (selectable) return /*#__PURE__*/React.createElement("li", {
    onClick: onClick,
    className: clsx('user-group-list-item selectable', isSelected && 'active')
  }, user._lastname && /*#__PURE__*/React.createElement("div", {
    className: clsx('user-full-name', isCurrentUser && 'current-user')
  }, user._lastname + ", " + user._firstname), /*#__PURE__*/React.createElement("div", {
    className: "user-email"
  }, user._email));else return /*#__PURE__*/React.createElement("li", {
    className: "user-group-list-item"
  }, /*#__PURE__*/React.createElement("div", {
    className: "card-row1"
  }, /*#__PURE__*/React.createElement("div", {
    style: {
      width: '90%'
    }
  }, user._lastname && /*#__PURE__*/React.createElement("div", {
    className: clsx('user-full-name', isCurrentUser && 'current-user')
  }, user._lastname + ", " + user._firstname), /*#__PURE__*/React.createElement("div", {
    className: "user-email"
  }, user._email)), showActions && /*#__PURE__*/React.createElement("div", {
    className: "card-actions"
  }, !isDeleting && /*#__PURE__*/React.createElement("i", {
    className: "fas fa-trash",
    onClick: confirmRemove
  }))), isDeleting && /*#__PURE__*/React.createElement("div", {
    className: "card-row2"
  }, /*#__PURE__*/React.createElement("div", {
    className: "confirm-text"
  }, actionText), allowRemove && /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("a", {
    href: "#",
    onClick: removeConfirmed
  }, /*#__PURE__*/React.createElement("i", {
    className: "fas fa-check"
  }), " ", removeUserText)), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("a", {
    href: "#",
    onClick: cancelRemove
  }, /*#__PURE__*/React.createElement("i", {
    className: "fas fa-times"
  }), " ", cancelText))));
};

var InviteCard = function InviteCard(_ref) {
  var invite = _ref.invite,
    _ref$isCurrentUser = _ref.isCurrentUser,
    isCurrentUser = _ref$isCurrentUser === void 0 ? false : _ref$isCurrentUser,
    _ref$existingUser = _ref.existingUser,
    existingUser = _ref$existingUser === void 0 ? false : _ref$existingUser,
    _ref$showActions = _ref.showActions,
    showActions = _ref$showActions === void 0 ? false : _ref$showActions,
    onCancelInvite = _ref.onCancelInvite,
    onResendInvite = _ref.onResendInvite,
    onAcceptInvite = _ref.onAcceptInvite;
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isDoingAction = _useState2[0],
    setIsDoingAction = _useState2[1];
  var _useState3 = useState(null),
    _useState4 = _slicedToArray(_useState3, 2),
    action = _useState4[0],
    setAction = _useState4[1];
  var _useState5 = useState(''),
    _useState6 = _slicedToArray(_useState5, 2),
    actionText = _useState6[0],
    setActionText = _useState6[1];
  var _useState7 = useState(''),
    _useState8 = _slicedToArray(_useState7, 2),
    actionAcceptText = _useState8[0],
    setActionAcceptText = _useState8[1];
  var getFormattedDate = function getFormattedDate(ts) {
    var expires = moment(ts);
    return expires.format('MMM D, YYYY');
  };
  var confirmAction = function confirmAction(selectedAction) {
    setAction(selectedAction);
    if (selectedAction === 'CANCEL') {
      setActionText('Confirm Invite Delete');
      setActionAcceptText(' Remove Invite');
    } else if (selectedAction === 'RESEND') {
      setActionText('Confirm Resend Invite');
      setActionAcceptText(' Resend Invite');
    } else if (selectedAction === 'ACCEPT') {
      setActionText('Confirm Invite Accept');
      setActionAcceptText(' Accept Invite');
    }
    setIsDoingAction(true);
  };
  var cancelAction = function cancelAction(e) {
    if (e) e.preventDefault();
    setAction(null);
    setActionText('');
    setActionAcceptText('');
    setIsDoingAction(false);
  };
  var actionConfirmed = function actionConfirmed(e) {
    if (e) e.preventDefault();
    if (action === 'CANCEL') {
      if (onCancelInvite) onCancelInvite(invite);
    } else if (action === 'RESEND') {
      if (onResendInvite) onResendInvite(invite);
    } else if (action === 'ACCEPT') {
      if (onAcceptInvite) onAcceptInvite(invite);
    }
  };
  var expiresDate = getFormattedDate(invite._expireTime);
  var expired = invite._status === 'EXPIRED';
  return /*#__PURE__*/React.createElement("li", {
    className: "user-group-list-item invite"
  }, /*#__PURE__*/React.createElement("div", {
    className: "card-row1"
  }, /*#__PURE__*/React.createElement("div", {
    className: "invite-user-info"
  }, existingUser && /*#__PURE__*/React.createElement("div", {
    className: clsx('user-full-name', isCurrentUser && 'current-user')
  }, existingUser._lastname + ', ' + existingUser._firstname), /*#__PURE__*/React.createElement("div", {
    className: "user-email"
  }, invite._email)), /*#__PURE__*/React.createElement("div", {
    className: "invite-info"
  }, /*#__PURE__*/React.createElement("div", {
    className: clsx('invite-expires', expired && 'expired')
  }, /*#__PURE__*/React.createElement("span", {
    className: "bold"
  }, "Expires:"), " ", expiresDate), /*#__PURE__*/React.createElement("div", {
    className: "invite-usergroup"
  }, /*#__PURE__*/React.createElement("span", {
    className: "bold"
  }, "UserGroup:"), " ", invite._usergroup._name)), showActions && !isDoingAction && /*#__PURE__*/React.createElement("div", {
    className: "card-actions"
  }, isCurrentUser && !expired && /*#__PURE__*/React.createElement("i", {
    className: "fas fa-check",
    onClick: function onClick() {
      return confirmAction('ACCEPT');
    }
  }), /*#__PURE__*/React.createElement("i", {
    className: "fas fa-redo-alt",
    onClick: function onClick() {
      return confirmAction('RESEND');
    }
  }), /*#__PURE__*/React.createElement("i", {
    className: "fas fa-trash",
    onClick: function onClick() {
      return confirmAction('CANCEL');
    }
  }))), isDoingAction && /*#__PURE__*/React.createElement("div", {
    className: "card-row2"
  }, /*#__PURE__*/React.createElement("div", {
    className: "confirm-text"
  }, actionText), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("a", {
    href: "#",
    onClick: actionConfirmed
  }, /*#__PURE__*/React.createElement("i", {
    className: "fas fa-check"
  }), actionAcceptText)), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("a", {
    href: "#",
    onClick: cancelAction
  }, /*#__PURE__*/React.createElement("i", {
    className: "fas fa-times"
  }), " Cancel"))));
};

var css_248z$a = ".invite-form {\n  padding: 50px;\n  display: flex;\n  flex-direction: column;\n}\n.invite-form .invite-form-content {\n  opacity: 0;\n  pointer-events: none;\n  display: flex;\n  flex-direction: column;\n}\n.invite-form .invite-form-content.fade {\n  transition: opacity 0.5s;\n}\n.invite-form .invite-form-content.shown {\n  opacity: 1;\n  pointer-events: all;\n}\n.invite-form .invite-form-content .invite-form-title {\n  align-self: center;\n  justify-self: center;\n}\n.invite-form .invite-form-content .invite-form-title h3 {\n  color: var(--app-accent-color);\n}\n.invite-form .invite-form-content .invite-groups-select {\n  margin-bottom: 20px;\n}\n.invite-form .invite-form-content .invite-groups-select .select-usergroups-label {\n  font-weight: bold;\n  margin-bottom: 5px;\n}\n.invite-form .invite-form-content .email-entry {\n  display: flex;\n  flex-direction: column;\n  margin-bottom: 10px;\n}\n.invite-form .invite-form-content .email-entry .email-label {\n  font-weight: bold;\n  margin-bottom: 5px;\n}\n.invite-form .invite-form-content .email-entry input {\n  border-top: none;\n  border-right: none;\n  border-bottom: 2px solid var(--app-accent-color);\n  border-left: none;\n  background-color: #f2f2f2;\n  height: 40px;\n}\n.invite-form .invite-form-content .email-entry .email-error-msg {\n  color: var(--app-accent-color);\n  font-weight: bold;\n  font-style: italic;\n}\n.invite-form .invited-user-list .send-to-label {\n  font-style: italic;\n  padding-left: 10px;\n}\n.invite-form .invited-user-list .no-emails-msg {\n  padding-left: 10px;\n  color: #9C9C9C;\n}\n.invite-form .align-right {\n  align-self: flex-end;\n  display: flex;\n}\n.invite-form .simple-button {\n  width: fit-content;\n  margin-top: 5px;\n  margin-left: 10px;\n  padding: 5px;\n  border: 1px solid var(--app-accent-color);\n  border-radius: 10px;\n  color: var(--app-accent-color);\n  font-weight: bold;\n  cursor: pointer;\n}\n.invite-form .simple-button:hover {\n  background-color: #f2f2f2;\n}\n.invite-form .simple-button-disabled {\n  width: fit-content;\n  margin-top: 5px;\n  margin-left: 10px;\n  padding: 5px;\n  border: 1px solid #9C9C9C;\n  border-radius: 10px;\n  color: #9C9C9C;\n  font-weight: bold;\n  cursor: auto;\n}\n.invite-form .invite-form-overlay {\n  width: 100%;\n  height: 100%;\n  background: white;\n  display: flex;\n  justify-content: center;\n  align-items: flex-start;\n  opacity: 0;\n  pointer-events: none;\n}\n.invite-form .invite-form-overlay.fade {\n  transition: opacity 0.5s;\n}\n.invite-form .invite-form-overlay.shown {\n  opacity: 1;\n  pointer-events: all;\n}\n.invite-form .invite-form-overlay .overlay-content {\n  padding-top: 30%;\n}\n.invite-form .invite-form-overlay .overlay-content .overlay-msg-content {\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n}";
styleInject(css_248z$a);

var SimpleButton = function SimpleButton(_ref) {
  var children = _ref.children,
    _ref$disabled = _ref.disabled,
    disabled = _ref$disabled === void 0 ? false : _ref$disabled,
    onClick = _ref.onClick;
  if (!disabled) return /*#__PURE__*/React.createElement("div", {
    className: "simple-button",
    onClick: onClick
  }, children);else return /*#__PURE__*/React.createElement("div", {
    className: "simple-button-disabled"
  }, children);
};
var InviteForm = function InviteForm(_ref2) {
  var appName = _ref2.appName,
    appUrl = _ref2.appUrl,
    currentUser = _ref2.currentUser,
    users = _ref2.users,
    userGroups = _ref2.userGroups,
    project = _ref2.project,
    onInvitesSent = _ref2.onInvitesSent;
  var _useState = useState(''),
    _useState2 = _slicedToArray(_useState, 2),
    currentEmail = _useState2[0],
    setCurrentEmail = _useState2[1]; //current email being entered in input field
  var _useState3 = useState([]),
    _useState4 = _slicedToArray(_useState3, 2),
    allEmails = _useState4[0],
    setAllEmails = _useState4[1]; //the list of all emails which could also be a User
  var _useState5 = useState(null),
    _useState6 = _slicedToArray(_useState5, 2),
    emailError = _useState6[0],
    setEmailError = _useState6[1]; //a error string for a bad email address
  var _useState7 = useState([]),
    _useState8 = _slicedToArray(_useState7, 2),
    selectedUserGroups = _useState8[0],
    setSelectedUserGroups = _useState8[1]; //the usergroups selected to send invites to
  var _useState9 = useState(false),
    _useState0 = _slicedToArray(_useState9, 2),
    sendingInvites = _useState0[0],
    setSendingInvites = _useState0[1]; //if invites are currently being sent
  var _useState1 = useState(false),
    _useState10 = _slicedToArray(_useState1, 2),
    renderOverlay = _useState10[0],
    setRenderOverlay = _useState10[1]; //whether to render to the form overlay
  var _useState11 = useState(false),
    _useState12 = _slicedToArray(_useState11, 2),
    showOverlay = _useState12[0],
    setShowOverlay = _useState12[1]; //whether to show the form overlay
  var _useState13 = useState(true),
    _useState14 = _slicedToArray(_useState13, 2),
    renderForm = _useState14[0],
    setRenderForm = _useState14[1]; //whether to render the form
  var _useState15 = useState(true),
    _useState16 = _slicedToArray(_useState15, 2),
    showForm = _useState16[0],
    setShowForm = _useState16[1]; //whether to show the form
  var _useState17 = useState(''),
    _useState18 = _slicedToArray(_useState17, 2),
    overlayMsg = _useState18[0],
    setOverlayMsg = _useState18[1]; //the message to display on the overlay
  var _useState19 = useState(false),
    _useState20 = _slicedToArray(_useState19, 2),
    inviteErrorMode = _useState20[0],
    setInviteErrorMode = _useState20[1]; //if errors were encountered sending invites

  //all these useEffects are for controlling the fade in and out and rendering
  //of the form and the overlay
  useEffect(function () {
    if (renderOverlay) setShowForm(false);
  }, [renderOverlay]);
  useEffect(function () {
    if (!showForm) {
      setTimeout(function () {
        setRenderForm(false);
        setShowOverlay(true);
      }, 500);
    }
  }, [showForm]);
  useEffect(function () {
    if (renderForm) setShowForm(true);
  }, [renderForm]);
  useEffect(function () {
    if (!showOverlay) {
      setTimeout(function () {
        setRenderOverlay(false);
        setRenderForm(true);
      }, 500);
    }
  }, [showOverlay]);
  var displayOverlay = function displayOverlay() {
    setRenderOverlay(true);
  };
  var hideOverlay = function hideOverlay() {
    setShowOverlay(false);
  };
  var handleEmailChange = function handleEmailChange(event) {
    setCurrentEmail(event.target.value.toLowerCase());
  };
  var emailIsValid = function emailIsValid(email) {
    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    return re.test(currentEmail);
  };
  var keyUp = function keyUp(e) {
    if (e.key === 'Enter') addEmail();
  };
  var addEmail = function addEmail() {
    setEmailError(null);
    if (emailIsValid()) {
      //check if email already in list
      var existingEmail = _.find(allEmails, {
        _email: currentEmail
      });

      //check if existing user
      var existingUser = _.find(users, {
        _email: currentEmail
      });
      if (!existingEmail) {
        //add to list
        if (existingUser) setAllEmails([existingUser].concat(_toConsumableArray(allEmails)));else setAllEmails([{
          _email: currentEmail
        }].concat(_toConsumableArray(allEmails)));
      }
      setCurrentEmail("");
    } else {
      setEmailError('Invalid email address!');
    }
  };
  var asUserGroupOptions = function asUserGroupOptions() {
    return userGroups.map(function (ug) {
      return {
        label: ug._name,
        value: ug._id,
        ug: ug
      };
    });
  };
  var handleUserGroupSelection = function handleUserGroupSelection(changes) {
    if (changes) setSelectedUserGroups(changes);else setSelectedUserGroups([]);
  };
  var sendInvites = /*#__PURE__*/function () {
    var _ref3 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
      var params, inviteData, allResults, inviteError, i, results, overlayMsg;
      return _regenerator().w(function (_context) {
        while (1) switch (_context.n) {
          case 0:
            displayOverlay();
            setSendingInvites(true);
            setInviteErrorMode(false);
            params = {
              base_url: endPointConfig.baseRoot,
              invite_link: appUrl + (appUrl.endsWith('/') ? '' : '/'),
              type: 'Project',
              name: project._name,
              inviter_name: currentUser._firstname + " " + currentUser._lastname,
              body_header: appName,
              body_content: currentUser._firstname + " " + currentUser._lastname + ' has invited you to join the Project ' + project._name + '.',
              subject: 'Invitation to join ' + appName + ' Project: ' + project._name
            };
            inviteData = allEmails.map(function (e) {
              return {
                _email: e._email,
                _params: params
              };
            });
            allResults = [];
            inviteError = null; //have to do this syncronously as the backend throws a 500 error if we
            //multiple usergroups and multiple invites at the same time
            i = 0;
          case 1:
            if (!(i < selectedUserGroups.length)) {
              _context.n = 4;
              break;
            }
            _context.n = 2;
            return IafUserGroup.inviteUsersToGroup(selectedUserGroups[i].ug, inviteData)["catch"](function (err) {
              console.error('error sending invites: ', err);
              inviteError = "Error Sending Invites";
              setInviteErrorMode(true);
            });
          case 2:
            results = _context.v;
            allResults.push(results);
          case 3:
            i++;
            _context.n = 1;
            break;
          case 4:
            if (inviteError) overlayMsg = inviteError;else overlayMsg = 'Sent ' + selectedUserGroups.length + ' invite' + (selectedUserGroups.length > 1 ? 's' : '') + ' to ' + inviteData.length + ' user' + (inviteData.length > 1 ? 's' : '');
            setOverlayMsg(overlayMsg);
            setSendingInvites(false);
            onInvitesSent();
          case 5:
            return _context.a(2);
        }
      }, _callee);
    }));
    return function sendInvites() {
      return _ref3.apply(this, arguments);
    };
  }();
  var resetForm = function resetForm() {
    setSelectedUserGroups([]);
    setCurrentEmail("");
    setAllEmails([]);
    setEmailError(null);
    setInviteErrorMode(false);
  };
  var closeOverlay = function closeOverlay(e) {
    if (e) e.preventDefault();
    if (!inviteErrorMode) resetForm();
    hideOverlay();
  };
  var allowRemoveInvite = function allowRemoveInvite() {
    return {
      allow: true,
      message: "Remove Email?"
    };
  };
  var removeInviteEmail = function removeInviteEmail(removeThis) {
    var someEmails = allEmails.filter(function (e) {
      return e._email !== removeThis._email;
    });
    setAllEmails(someEmails);
  };
  return /*#__PURE__*/React.createElement("div", {
    className: "invite-form"
  }, renderForm && /*#__PURE__*/React.createElement("div", {
    className: clsx('invite-form-content fade', showForm && 'shown')
  }, /*#__PURE__*/React.createElement("div", {
    className: "invite-form-title"
  }, /*#__PURE__*/React.createElement("h3", null, "Send Invites")), /*#__PURE__*/React.createElement("div", {
    className: "invite-groups-select"
  }, /*#__PURE__*/React.createElement("div", {
    className: "select-usergroups-label"
  }, "Select UserGroups"), /*#__PURE__*/React.createElement(Select, {
    styles: {
      control: selectStyles
    },
    options: asUserGroupOptions(),
    onChange: handleUserGroupSelection,
    value: selectedUserGroups,
    isMulti: true,
    closeMenuOnSelect: false,
    isClearable: true,
    placeholder: 'Select UserGroups',
    menuPlacement: "auto",
    menuPosition: "fixed"
  })), /*#__PURE__*/React.createElement("div", {
    className: "email-entry"
  }, /*#__PURE__*/React.createElement("div", {
    className: "email-label"
  }, "Email"), /*#__PURE__*/React.createElement("input", {
    type: "text",
    value: currentEmail,
    onChange: handleEmailChange,
    disabled: sendingInvites,
    onKeyUp: keyUp,
    size: "50",
    maxLength: "50"
  }), emailError && /*#__PURE__*/React.createElement("div", {
    className: "email-error-msg"
  }, emailError), /*#__PURE__*/React.createElement("div", {
    className: "align-right"
  }, /*#__PURE__*/React.createElement(SimpleButton, {
    disabled: sendingInvites,
    onClick: addEmail
  }, "Add Email"))), /*#__PURE__*/React.createElement("div", {
    className: "invited-user-list"
  }, /*#__PURE__*/React.createElement("span", {
    className: "send-to-label"
  }, "Send to"), allEmails.length > 0 && /*#__PURE__*/React.createElement("ul", null, allEmails.map(function (e) {
    return /*#__PURE__*/React.createElement(UserCard, {
      key: e._email,
      user: e,
      showActions: true,
      canRemoveUser: allowRemoveInvite,
      removeUserText: "",
      cancelText: "",
      onRemoveUser: function onRemoveUser() {
        return removeInviteEmail(e);
      }
    });
  })), allEmails.length === 0 && /*#__PURE__*/React.createElement("div", {
    className: "no-emails-msg"
  }, "No emails added")), /*#__PURE__*/React.createElement("div", {
    className: "align-right"
  }, /*#__PURE__*/React.createElement(SimpleButton, {
    disabled: allEmails.length === 0 && selectedUserGroups.length === 0 || sendingInvites,
    onClick: resetForm
  }, "Clear"), /*#__PURE__*/React.createElement(SimpleButton, {
    disabled: allEmails.length === 0 || selectedUserGroups.length === 0 || sendingInvites,
    onClick: sendInvites
  }, "Send Invites"))), renderOverlay && /*#__PURE__*/React.createElement("div", {
    className: clsx('invite-form-overlay fade', showOverlay && 'shown')
  }, /*#__PURE__*/React.createElement("div", {
    className: "overlay-content"
  }, sendingInvites && /*#__PURE__*/React.createElement(SimpleTextThrobber, {
    throbberText: "Sending Invites"
  }), !sendingInvites && /*#__PURE__*/React.createElement("div", {
    className: "overlay-msg-content"
  }, /*#__PURE__*/React.createElement("div", null, overlayMsg), /*#__PURE__*/React.createElement(SimpleButton, {
    onClick: closeOverlay
  }, "Close")))));
};

var css_248z$b = ".permissions-table {\n  margin-top: 20px;\n  margin-left: 20px;\n  width: 80%;\n}\n.permissions-table .ug-perm-table-ctrls {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  padding-bottom: 10px;\n  border-bottom: solid 1px lightgray;\n}\n.permissions-table .ug-perm-table-ctrls .service-name {\n  margin-bottom: 0px;\n  color: var(--app-accent-color);\n}\n.permissions-table .ug-perm-table-ctrls .ug-perm-filter {\n  display: flex;\n  align-items: center;\n  min-width: 300px;\n  z-index: 1000;\n}\n.permissions-table .ug-perm-table {\n  width: 100%;\n  margin-bottom: 15px;\n}\n.permissions-table .ug-perm-table th {\n  font-weight: bold;\n  padding: 2px;\n  text-align: center;\n  border-right: 1px solid gray;\n  border-top: unset;\n  position: sticky;\n  top: 0;\n  z-index: 1;\n  background: white;\n}\n.permissions-table .ug-perm-table tr.odd-row {\n  background-color: lightgray;\n}\n.permissions-table .ug-perm-table .ug-perm-table-row .ug-perm-table-row-itemdesc {\n  padding-left: 10px;\n  font-size: smaller;\n  font-style: italic;\n}\n.permissions-table .ug-perm-table td {\n  padding: 5px 15px 5px 5px;\n  border-right: 1px solid gray;\n  min-width: 60px;\n}\n.permissions-table .ug-perm-table td i {\n  padding: 0px;\n  color: gray;\n}\n.permissions-table .ug-perm-table td.perm-cell {\n  text-align: center;\n  vertical-align: middle;\n}";
styleInject(css_248z$b);

var StyledAccentSwitch = styled(Switch)(function (_ref) {
  var theme = _ref.theme;
  return {
    switchBase: {
      color: 'var(--app-accent-color) !important',
      "&$checked": {
        color: 'var(--app-accent-color) !important'
      },
      "&$checked + $track": {
        backgroundColor: 'var(--app-accent-color) !important'
      }
    },
    checked: {},
    track: {}
  };
});
var AccentSwitch = function AccentSwitch(props) {
  return /*#__PURE__*/React.createElement(StyledAccentSwitch, props);
};
var UserGroupPermissionTable = function UserGroupPermissionTable(_ref2) {
  var usergroup = _ref2.usergroup,
    allowManagePermissions = _ref2.allowManagePermissions,
    itemFetchScript = _ref2.itemFetchScript;
  //top level state
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    accessAll = _useState2[0],
    setAccessAll = _useState2[1];
  var _useState3 = useState([]),
    _useState4 = _slicedToArray(_useState3, 2),
    actions = _useState4[0],
    setActions = _useState4[1];

  //itemservice state
  var _useState5 = useState([]),
    _useState6 = _slicedToArray(_useState5, 2),
    allUserItems = _useState6[0],
    setAllUserItems = _useState6[1];
  var _useState7 = useState([]),
    _useState8 = _slicedToArray(_useState7, 2),
    usergroupItemPerms = _useState8[0],
    setUserGroupItemPerms = _useState8[1];
  var _useState9 = useState([]),
    _useState0 = _slicedToArray(_useState9, 2),
    itemTableData = _useState0[0],
    setItemTableData = _useState0[1];
  var _useState1 = useState([]),
    _useState10 = _slicedToArray(_useState1, 2),
    itemFilterOptions = _useState10[0],
    setItemFilterOptions = _useState10[1];
  var _useState11 = useState({
      value: "All",
      label: "All"
    }),
    _useState12 = _slicedToArray(_useState11, 2),
    itemFilterValue = _useState12[0],
    setItemFilterValue = _useState12[1];
  var _useState13 = useState([]),
    _useState14 = _slicedToArray(_useState13, 2),
    itemFilteredTableData = _useState14[0],
    setItemFilteredTableData = _useState14[1];
  var _useState15 = useState(true),
    _useState16 = _slicedToArray(_useState15, 2),
    loadingItemPerms = _useState16[0],
    setLoadingItemPerms = _useState16[1];

  //fileservice state
  var _useState17 = useState([]),
    _useState18 = _slicedToArray(_useState17, 2),
    filePerms = _useState18[0],
    setFilePerms = _useState18[1];
  var _useState19 = useState([]),
    _useState20 = _slicedToArray(_useState19, 2),
    fileTableData = _useState20[0],
    setFileTableData = _useState20[1];
  var _useState21 = useState(true),
    _useState22 = _slicedToArray(_useState21, 2),
    loadingFilePerms = _useState22[0],
    setLoadingFilePerms = _useState22[1];
  useEffect(function () {
    function getActionsAndItems() {
      return _getActionsAndItems.apply(this, arguments);
    }
    function _getActionsAndItems() {
      _getActionsAndItems = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
        var actions, itemList, userItems;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              actions = Object.values(IafPermission.PermConst.Action).sort();
              actions = actions.filter(function (a) {
                return a !== '*';
              });
              setActions(actions);
              if (!itemFetchScript) {
                _context.n = 2;
                break;
              }
              _context.n = 1;
              return ScriptHelper.executeScript(itemFetchScript);
            case 1:
              itemList = _context.v;
              _context.n = 4;
              break;
            case 2:
              _context.n = 3;
              return IafItemSvc.getNamedUserItems();
            case 3:
              itemList = _context.v;
            case 4:
              userItems = itemList._list ? itemList._list : itemList;
              userItems.sort(function (a, b) {
                if (a._itemClass.localeCompare(b._itemClass) > 0) return 1;
                if (a._itemClass.localeCompare(b._itemClass) < 0) return -1;
                if (a._name.localeCompare(b._name) > 0) return 1;
                if (a._name.localeCompare(b._name) < 0) return -1;
                return 0;
              });
              setAllUserItems(userItems);
            case 5:
              return _context.a(2);
          }
        }, _callee);
      }));
      return _getActionsAndItems.apply(this, arguments);
    }
    getActionsAndItems();
  }, []);
  useEffect(function () {
    function getUserGroupPermissions() {
      return _getUserGroupPermissions.apply(this, arguments);
    }
    function _getUserGroupPermissions() {
      _getUserGroupPermissions = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2() {
        var query, filequery;
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              query = {
                _namespace: usergroup._userAttributes.project_workspace._namespaces,
                "_user._id": usergroup._id,
                "_user._type": IafPermission.PermConst.UserType.UserGroup,
                "_resourceDesc._irn": IafPermission.NamedUserItemIrnAll
              };
              IafItemSvc.getPermissions(query).then(function (res) {
                setUserGroupItemPerms(res._list);
              });
              filequery = {
                _namespace: usergroup._userAttributes.project_workspace._namespaces,
                "_user._id": usergroup._id,
                "_user._type": IafPermission.PermConst.UserType.UserGroup,
                "_resourceDesc._irn": IafPermission.FileIrnAll
              };
              IafFileSvc.getPermissions(filequery).then(function (fres) {
                setFilePerms(fres._list);
              });
            case 1:
              return _context2.a(2);
          }
        }, _callee2);
      }));
      return _getUserGroupPermissions.apply(this, arguments);
    }
    resetPerms();
    getUserGroupPermissions();
  }, [usergroup]);
  useEffect(function () {
    getItemFilterOptions();
  }, [allUserItems]);
  useEffect(function () {
    getUserItemsWithPermissions();
  }, [usergroupItemPerms, allUserItems, accessAll]);
  useEffect(function () {
    getFilesWithPermissions();
  }, [filePerms, accessAll]);
  var resetPerms = function resetPerms() {
    setLoadingItemPerms(true);
    setLoadingFilePerms(true);
    setAccessAll(false);
    setUserGroupItemPerms([]);
    setFilePerms([]);
    setItemTableData([]);
    setItemFilteredTableData([]);
    setFileTableData([]);
  };
  var getItemFilterOptions = function getItemFilterOptions() {
    var newFilterValues = _.uniq(allUserItems.map(function (u) {
      return u._itemClass;
    }));
    var newFilterOptions = [{
      value: "All",
      label: "All"
    }];
    newFilterValues.forEach(function (o) {
      newFilterOptions.push({
        value: o,
        label: o
      });
    });
    setItemFilterOptions(newFilterOptions);
  };
  var createRowForTable = function createRowForTable(item, permissions, all) {
    var allAction = false;
    if (!all && permissions.includes(IafPermission.PermConst.Action.All)) allAction = true;
    var collWithPerms = {
      item: item
    };
    Object.values(IafPermission.PermConst.Action).forEach(function (a) {
      collWithPerms[a] = all || allAction || permissions.includes(a);
    });
    return collWithPerms;
  };
  var hasAllAccess = function hasAllAccess(where) {
    var hasAccessAll = accessAll || !!_.find(where, {
      _resourceDesc: {
        _irn: IafPermission.AllAccessIrn
      }
    });
    if (hasAccessAll !== accessAll) setAccessAll(hasAccessAll);
    return hasAccessAll;
  };
  var getUserItemsWithPermissions = function getUserItemsWithPermissions() {
    function getPermsForItem(item) {
      var topLevelNamedUserItemPerms = usergroupItemPerms.filter(function (p) {
        return p._resourceDesc._irn === 'itemsvc:nameduseritem:*' && !p._resourceDesc._criteria;
      });
      var itemClassItemPerms = usergroupItemPerms.filter(function (p) {
        return p._resourceDesc._criteria && p._resourceDesc._criteria._itemClass === item._itemClass;
      });
      var userTypeItemPerms = usergroupItemPerms.filter(function (p) {
        return p._resourceDesc._criteria && p._resourceDesc._criteria._userType === item._userType;
      });
      var topLevelActions = _.flatten(topLevelNamedUserItemPerms.map(function (p) {
        return p._actions;
      }));
      var itemClassActions = _.flatten(itemClassItemPerms.map(function (p) {
        return p._actions;
      }));
      var userTypeActions = _.flatten(userTypeItemPerms.map(function (p) {
        return p._actions;
      }));
      var combinedPerms = [].concat(_toConsumableArray(topLevelActions), _toConsumableArray(itemClassActions), _toConsumableArray(userTypeActions));
      combinedPerms.sort();
      var uniquePerms = _.uniq(combinedPerms, true);
      return uniquePerms;
    }
    var hasAllPermissions = hasAllAccess(usergroupItemPerms);
    var tableRows = allUserItems.map(function (item) {
      if (hasAllPermissions) return createRowForTable(item, null, true);else {
        var itemPermissions = getPermsForItem(item);
        return createRowForTable(item, itemPermissions, false);
      }
    });
    setItemTableData(tableRows);
    setItemFilteredTableData(tableRows);
    setLoadingItemPerms(false);
  };
  var onFilterChange = function onFilterChange(f) {
    if (f.value === 'All') setItemFilteredTableData(itemTableData);else {
      var filteredRows = itemTableData.filter(function (r) {
        return r.item._itemClass === f.value;
      });
      setItemFilteredTableData(filteredRows);
    }
    setItemFilterValue(f);
  };
  var getFilesWithPermissions = function getFilesWithPermissions() {
    var hasAllPermissions = hasAllAccess(filePerms);
    var item = {
      _name: "All Files",
      _descriptions: "All files in file service"
    };
    var permissionsObj = _.find(filePerms, {
      _resourceDesc: {
        _irn: IafPermission.FileIrnAll
      }
    });
    var permissions = permissionsObj ? permissionsObj._actions : [];
    var fileTableRows = createRowForTable(item, permissions, hasAllPermissions);
    setFileTableData([fileTableRows]);
    setLoadingFilePerms(false);
  };
  return /*#__PURE__*/React.createElement("div", {
    className: "permissions-table"
  }, /*#__PURE__*/React.createElement("div", {
    className: "access-switch"
  }, /*#__PURE__*/React.createElement(AccentSwitch, {
    checked: accessAll,
    disabled: true
  }), " Access All"), /*#__PURE__*/React.createElement("div", {
    className: "ug-perm-table-ctrls"
  }, /*#__PURE__*/React.createElement("h3", {
    className: "service-name"
  }, "File Service")), loadingFilePerms && /*#__PURE__*/React.createElement(SimpleTextThrobber, {
    throbberText: "Loading File Permissions"
  }), !loadingFilePerms && /*#__PURE__*/React.createElement("table", {
    className: "ug-perm-table"
  }, /*#__PURE__*/React.createElement("thead", null, /*#__PURE__*/React.createElement("tr", {
    className: "ug-perm-table-header"
  }, /*#__PURE__*/React.createElement("th", null), actions.map(function (a) {
    return /*#__PURE__*/React.createElement("th", {
      key: 'file-head-' + a
    }, a);
  }))), /*#__PURE__*/React.createElement("tbody", null, fileTableData.map(function (row, index) {
    return /*#__PURE__*/React.createElement("tr", {
      key: index,
      className: clsx('ug-perm-table-row', index % 2 !== 0 && 'odd-row')
    }, /*#__PURE__*/React.createElement("td", null, /*#__PURE__*/React.createElement("div", {
      className: "ug-perm-table-row-itemname"
    }, row.item._name), /*#__PURE__*/React.createElement("div", {
      className: "ug-perm-table-row-itemdesc"
    }, row.item._description)), actions.map(function (a) {
      return /*#__PURE__*/React.createElement("td", {
        key: row.name + a,
        className: "perm-cell"
      }, !accessAll && allowManagePermissions && /*#__PURE__*/React.createElement(RoundCheckbox, {
        checked: row[a]
      }), (accessAll || !allowManagePermissions) && /*#__PURE__*/React.createElement("i", {
        className: clsx(row[a] && 'fas fa-check-circle', !row[a] && 'far fa-circle')
      }));
    }));
  }))), /*#__PURE__*/React.createElement("div", {
    className: "ug-perm-table-ctrls"
  }, /*#__PURE__*/React.createElement("h3", {
    className: "service-name"
  }, "Item Service"), /*#__PURE__*/React.createElement("div", {
    className: "ug-perm-filter"
  }, "Filter by:", /*#__PURE__*/React.createElement("div", {
    style: {
      minWidth: '300px'
    }
  }, /*#__PURE__*/React.createElement(Select, {
    options: itemFilterOptions,
    value: itemFilterValue,
    onChange: onFilterChange
  })))), loadingItemPerms && /*#__PURE__*/React.createElement(SimpleTextThrobber, {
    throbberText: "Loading Item Permissions"
  }), !loadingItemPerms && /*#__PURE__*/React.createElement("table", {
    className: "ug-perm-table"
  }, /*#__PURE__*/React.createElement("thead", null, /*#__PURE__*/React.createElement("tr", {
    className: "ug-perm-table-header"
  }, /*#__PURE__*/React.createElement("th", null, "Name"), /*#__PURE__*/React.createElement("th", null, "Class"), actions.map(function (a) {
    return /*#__PURE__*/React.createElement("th", {
      key: 'head-' + a
    }, a);
  }))), /*#__PURE__*/React.createElement("tbody", null, itemFilteredTableData.map(function (row, index) {
    return /*#__PURE__*/React.createElement("tr", {
      key: index,
      className: clsx('ug-perm-table-row', index % 2 !== 0 && 'odd-row')
    }, /*#__PURE__*/React.createElement("td", null, /*#__PURE__*/React.createElement("div", {
      className: "ug-perm-table-row-itemname"
    }, row.item._name), /*#__PURE__*/React.createElement("div", {
      className: "ug-perm-table-row-itemdesc"
    }, row.item._description)), /*#__PURE__*/React.createElement("td", null, row.item._itemClass), actions.map(function (a) {
      return /*#__PURE__*/React.createElement("td", {
        key: row.name + a,
        className: "perm-cell"
      }, !accessAll && allowManagePermissions && /*#__PURE__*/React.createElement(RoundCheckbox, {
        checked: row[a]
      }), (accessAll || !allowManagePermissions) && /*#__PURE__*/React.createElement("i", {
        className: clsx(row[a] && 'fas fa-check-circle', !row[a] && 'far fa-circle')
      }));
    }));
  }))));
};

var UserGroupView = /*#__PURE__*/function (_React$Component) {
  function UserGroupView(props) {
    var _this;
    _classCallCheck(this, UserGroupView);
    _this = _callSuper(this, UserGroupView, [props]);
    _this.state = {
      pageModes: ['UserGroups', 'Users'],
      pageMode: 'UserGroups',
      userGroupModes: ['Users/Invites', 'Permissions'],
      userGroupMode: 'Users/Invites',
      allUserGroupNamesUpper: [],
      //list of uppercase usergroup names for easy comparisons
      invalidUserGroups: [],
      //userGroups on the project the user can't interact with
      userGroups: [],
      //userGroups on the project the user can interact with
      selectedUserGroup: null,
      //the currently selected UserGroup
      editingUserGroup: false,
      //if the user is editng the UserGroup
      userGroupNameEdit: "",
      //the editable UserGroup name
      savingUserGroup: false,
      //if we are saving the UserGroup to the platform
      userGroupNameEditError: null,
      //any error with the UserGroup name
      usersInSelectedGroup: [],
      //user who are in the currently selected UserGroup
      loadingInvites: true,
      //whether we are loading invites for usergroup or user
      invitesInSelectedGroup: [],
      //pending invites in a group
      expiredInvitesInSelectedGroup: [],
      //expired invites in a group
      users: [],
      //list of all users in the project
      selectedUser: null,
      //the currently selected user
      userGroupsForSelectedUser: [],
      //the valid usergroups to which the selected user belongs
      invitesForSelectedUser: [],
      //invites for the seleted user
      expiredInvitesForSelectedUser: [] //expired invites for the selected user
    };
    _this._loadAsyncData = _this._loadAsyncData.bind(_this);
    _this.onModeChange = _this.onModeChange.bind(_this);
    _this.onUserGroupModeChange = _this.onUserGroupModeChange.bind(_this);
    _this.getAllUserGroups = _this.getAllUserGroups.bind(_this);
    _this.setSelectedUserGroup = _this.setSelectedUserGroup.bind(_this);
    _this.toggleUserGroupEditable = _this.toggleUserGroupEditable.bind(_this);
    _this.onUserGroupNameChange = _this.onUserGroupNameChange.bind(_this);
    _this.updateUserGroup = _this.updateUserGroup.bind(_this);
    _this.sortGroupsBasedOnConfig = _this.sortGroupsBasedOnConfig.bind(_this);
    _this.loadUserGroupData = _this.loadUserGroupData.bind(_this);
    _this.getAllUsers = _this.getAllUsers.bind(_this);
    _this.setSelectedUser = _this.setSelectedUser.bind(_this);
    _this.loadUserData = _this.loadUserData.bind(_this);
    _this.updateCurrentView = _this.updateCurrentView.bind(_this);
    _this.onCancelInvite = _this.onCancelInvite.bind(_this);
    _this.onResendInvite = _this.onResendInvite.bind(_this);
    _this.onAcceptInvite = _this.onAcceptInvite.bind(_this);
    _this.canRemoveUser = _this.canRemoveUser.bind(_this);
    _this.removeUser = _this.removeUser.bind(_this);
    return _this;
  }
  _inherits(UserGroupView, _React$Component);
  return _createClass(UserGroupView, [{
    key: "componentDidMount",
    value: function () {
      var _componentDidMount = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              if (this.props.handler.config.defaultView && this.props.handler.config.defaultView.toUpperCase() === 'USERS') this.setState({
                pageMode: 'Users'
              }, this._loadAsyncData);else this.setState({
                pageMode: 'UserGroups'
              }, this._loadAsyncData);
              this.props.onLoadComplete();
              console.log('props', this.props);
              console.log('state', this.state);
            case 1:
              return _context.a(2);
          }
        }, _callee, this);
      }));
      function componentDidMount() {
        return _componentDidMount.apply(this, arguments);
      }
      return componentDidMount;
    }()
  }, {
    key: "_loadAsyncData",
    value: function () {
      var _loadAsyncData2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2() {
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              _context2.n = 1;
              return this.getAllUserGroups();
            case 1:
              this.getAllUsers();
            case 2:
              return _context2.a(2);
          }
        }, _callee2, this);
      }));
      function _loadAsyncData() {
        return _loadAsyncData2.apply(this, arguments);
      }
      return _loadAsyncData;
    }()
  }, {
    key: "onModeChange",
    value: function onModeChange(e) {
      this.setState({
        pageMode: e.target.value,
        editingUserGroup: false
      });
      if (e.target.value === 'UserGroups') this.loadUserGroupData();
    }
  }, {
    key: "onUserGroupModeChange",
    value: function onUserGroupModeChange(e) {
      this.setState({
        userGroupMode: e.target.value
      }, this.loadUserGroupData);
    }
  }, {
    key: "sortGroupsBasedOnConfig",
    value: function sortGroupsBasedOnConfig(groups, configs) {
      //determines whether a group has a config matching one in configs
      function hasMatchingConfig(group, configs) {
        var match = false;
        for (var i = 0; i < configs.length; i++) {
          if (_.find(group._userAttributes.userConfigs, {
            _id: configs[i]._id
          })) {
            match = true;
            break;
          }
        }
        return match;
      }
      groups.sort(function (a, b) {
        return a._name.localeCompare(b._name);
      });

      //further filter down to just the userGroups with a userConfig for this application
      var groupsWithAppUserConfig = groups.filter(function (g) {
        return hasMatchingConfig(g, configs);
      });

      //get the list of userGroups in the project with out config for this app
      var invalidGroups = groups.filter(function (g) {
        return !g._userAttributes.userConfigs || !hasMatchingConfig(g, configs);
      });
      return {
        validGroups: groupsWithAppUserConfig,
        invalidGroups: invalidGroups
      };
    }
  }, {
    key: "getAllUserGroups",
    value: function () {
      var _getAllUserGroups = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4(selectedUserGroup) {
        var _this2 = this;
        return _regenerator().w(function (_context4) {
          while (1) switch (_context4.n) {
            case 0:
              return _context4.a(2, new Promise(function (resolve, reject) {
                return [IafProj.getUserGroups(_this2.props.selectedItems.selectedProject).then(/*#__PURE__*/function () {
                  var _ref = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3(groups) {
                    return _regenerator().w(function (_context3) {
                      while (1) switch (_context3.n) {
                        case 0:
                          //get all user configs int he project for this application (ie. _userType)
                          IafProj.getUserConfigs(_this2.props.selectedItems.selectedProject, {
                            query: {
                              _userType: _this2.props.selectedItems.ipaConfig.configUserType
                            }
                          }).then(function (userConfigs) {
                            //get valid and invalid groups
                            var sortedUserGroups = _this2.sortGroupsBasedOnConfig(groups, userConfigs);
                            var allUserGroupNamesUpper = groups.map(function (g) {
                              return g._name.toUpperCase();
                            });
                            var applySelectedUserGroup = selectedUserGroup ? selectedUserGroup : sortedUserGroups.validGroups[0];
                            _this2.setState({
                              allUserGroupNamesUpper: allUserGroupNamesUpper,
                              invalidUserGroups: sortedUserGroups.invalidGroups,
                              userGroups: sortedUserGroups.validGroups
                            }, _this2.setSelectedUserGroup(applySelectedUserGroup));
                            resolve(applySelectedUserGroup);
                          });
                        case 1:
                          return _context3.a(2);
                      }
                    }, _callee3);
                  }));
                  return function (_x2) {
                    return _ref.apply(this, arguments);
                  };
                }())];
              }));
          }
        }, _callee4);
      }));
      function getAllUserGroups(_x) {
        return _getAllUserGroups.apply(this, arguments);
      }
      return getAllUserGroups;
    }()
  }, {
    key: "setSelectedUserGroup",
    value: function setSelectedUserGroup(ug) {
      this.setState({
        selectedUserGroup: ug,
        usersInSelectedGroup: [],
        invitesInSelectedGroup: [],
        expiredInvitesInSelectedGroup: []
      }, this.loadUserGroupData);
    }
  }, {
    key: "loadUserGroupData",
    value: function loadUserGroupData() {
      var _this3 = this;
      console.log(this.state.userGroupMode, this.state.selectedUserGroup);
      if (this.state.userGroupMode === 'Users/Invites') {
        this.setState({
          loadingInvites: true,
          usersInSelectedGroup: [],
          invitesInSelectedGroup: [],
          expiredInvitesInSelectedGroup: []
        });
        IafUserGroup.getUsers(this.state.selectedUserGroup, null, {
          _offset: 0,
          _pageSize: 200
        }).then(function (users) {
          users.sort(function (a, b) {
            return a._lastname.localeCompare(b._lastname);
          });
          _this3.setState({
            usersInSelectedGroup: users
          });
        });
        IafUserGroup.getInvites(this.state.selectedUserGroup).then(function (invites) {
          var pendingInvites = invites._list.filter(function (i) {
            return i._status === 'PENDING';
          });
          var expiredInvites = invites._list.filter(function (i) {
            return i._status === 'EXPIRED';
          });
          _this3.setState({
            invitesInSelectedGroup: pendingInvites,
            expiredInvitesInSelectedGroup: expiredInvites,
            loadingInvites: false
          });
        });
      }
    }
  }, {
    key: "toggleUserGroupEditable",
    value: function toggleUserGroupEditable(e) {
      if (e) e.preventDefault();
      this.setState({
        userGroupNameEdit: this.state.selectedUserGroup._name,
        editingUserGroup: !this.state.editingUserGroup,
        userGroupNameEditError: null
      });
    }
  }, {
    key: "onUserGroupNameChange",
    value: function onUserGroupNameChange(e) {
      this.setState({
        userGroupNameEditError: null
      });
      if (e.target.value) {
        if (e.target.value.length < 50) {
          this.setState({
            userGroupNameEdit: e.target.value
          });
          if (!e.target.value.length) this.setState({
            userGroupNameEditError: "UserGroup name is not allowed to be blank!"
          });
        } else if (e.target.value.length > 50) {
          var truncName = e.target.value.slice(0, 50);
          this.setState({
            userGroupNameEdit: truncName
          });
        }
      } else {
        this.setState({
          userGroupNameEdit: ""
        });
        this.setState({
          userGroupNameEditError: "UserGroup name is not allowed to be blank!"
        });
      }
    }

    //currently we only update the usergroup's name
  }, {
    key: "updateUserGroup",
    value: function updateUserGroup(e) {
      var _this4 = this;
      e.preventDefault();
      if (!this.state.allUserGroupNamesUpper.includes(this.state.userGroupNameEdit.toUpperCase())) {
        this.setState({
          savingUserGroup: true
        });
        var updatedGroup = Object.assign({}, this.state.selectedUserGroup, {
          _name: this.state.userGroupNameEdit
        });
        IafUserGroup.update(updatedGroup).then(function (resGroup) {
          _this4.toggleUserGroupEditable();
          _this4.setState({
            savingUserGroup: false,
            userGroups: [],
            invalidGroups: [],
            selectedUserGroup: null
          });
          _this4.getAllUserGroups(resGroup);
        })["catch"](function (err) {
          console.error('error saving usergroup change', err);
          _this4.setState({
            userGroupNameEditError: err.message
          });
        });
      } else {
        this.setState({
          userGroupNameEditError: "Duplicate UserGroup name! Please choose a different name."
        });
      }
    }
  }, {
    key: "getAllUsers",
    value: function getAllUsers() {
      var _this5 = this;
      IafProj.getUsers(this.props.selectedItems.selectedProject).then(function (allUsers) {
        allUsers.sort(function (a, b) {
          return a._lastname.localeCompare(b._lastname);
        });
        _this5.setState({
          users: allUsers,
          selectedUser: allUsers[0]
        }, _this5.loadUserData);
      });
    }
  }, {
    key: "setSelectedUser",
    value: function setSelectedUser(ug) {
      this.setState({
        selectedUser: ug,
        userGroupsForSelectedUser: [],
        invitesForSelectedUser: []
      }, this.loadUserData);
    }
  }, {
    key: "loadUserData",
    value: function () {
      var _loadUserData = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee5() {
        var _this6 = this;
        var ugresults, invresults, validInvites, expiredInvites;
        return _regenerator().w(function (_context5) {
          while (1) switch (_context5.n) {
            case 0:
              this.setState({
                loadingInvites: true,
                userGroupsForSelectedUser: [],
                invitesForSelectedUser: [],
                expiredInvitesForSelectedUser: []
              });
              _context5.n = 1;
              return Promise.all(this.state.userGroups.map(function (ug) {
                return IafUserGroup.getUsers(ug, null, {
                  _offset: 0,
                  _pageSize: 200
                }).then(function (users) {
                  if (_.find(users, {
                    _id: _this6.state.selectedUser._id
                  })) return ug;else return null;
                });
              }));
            case 1:
              ugresults = _context5.v;
              ugresults = ugresults.filter(function (u) {
                return u;
              });
              this.setState({
                userGroupsForSelectedUser: ugresults
              });
              if (!(this.props.user._id === this.state.selectedUser._id)) {
                _context5.n = 3;
                break;
              }
              _context5.n = 2;
              return IafPassSvc.getUserInvites();
            case 2:
              invresults = _context5.v;
              _context5.n = 5;
              break;
            case 3:
              _context5.n = 4;
              return Promise.all(this.state.userGroups.map(function (ug) {
                return IafUserGroup.getInvites(ug).then(function (invs) {
                  return _.filter(invs._list, {
                    _email: _this6.state.selectedUser._email
                  });
                });
              }));
            case 4:
              invresults = _context5.v;
            case 5:
              invresults = _.flatten(invresults);
              invresults = invresults.filter(function (i) {
                return i;
              });
              validInvites = invresults.filter(function (i) {
                return i._status === "PENDING";
              });
              expiredInvites = invresults.filter(function (i) {
                return i._status === "EXPIRED";
              });
              this.setState({
                invitesForSelectedUser: validInvites,
                expiredInvitesForSelectedUser: expiredInvites,
                loadingInvites: false
              });
            case 6:
              return _context5.a(2);
          }
        }, _callee5, this);
      }));
      function loadUserData() {
        return _loadUserData.apply(this, arguments);
      }
      return loadUserData;
    }()
  }, {
    key: "onCancelInvite",
    value: function () {
      var _onCancelInvite = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee6(invite) {
        var result;
        return _regenerator().w(function (_context6) {
          while (1) switch (_context6.n) {
            case 0:
              _context6.n = 1;
              return IafUserGroup.cancelInvite(invite._usergroup, invite._id);
            case 1:
              result = _context6.v;
              this.updateCurrentView();
            case 2:
              return _context6.a(2);
          }
        }, _callee6, this);
      }));
      function onCancelInvite(_x3) {
        return _onCancelInvite.apply(this, arguments);
      }
      return onCancelInvite;
    }()
  }, {
    key: "onResendInvite",
    value: function () {
      var _onResendInvite = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee7(invite) {
        var cancelResult, inviteData, inviteResult;
        return _regenerator().w(function (_context7) {
          while (1) switch (_context7.n) {
            case 0:
              _context7.n = 1;
              return IafUserGroup.cancelInvite(invite._usergroup, invite._id);
            case 1:
              cancelResult = _context7.v;
              inviteData = [{
                _email: invite._email,
                _params: invite._params
              }]; //send a new invite
              _context7.n = 2;
              return IafUserGroup.inviteUsersToGroup(invite._usergroup, inviteData);
            case 2:
              inviteResult = _context7.v;
              this.updateCurrentView();
            case 3:
              return _context7.a(2);
          }
        }, _callee7, this);
      }));
      function onResendInvite(_x4) {
        return _onResendInvite.apply(this, arguments);
      }
      return onResendInvite;
    }()
  }, {
    key: "onAcceptInvite",
    value: function () {
      var _onAcceptInvite = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee8(invite) {
        var _this7 = this;
        return _regenerator().w(function (_context8) {
          while (1) switch (_context8.n) {
            case 0:
              IafUserGroup.addUserToGroupByInvite(invite._usergroup, invite).then(function (r) {
                _this7._loadAsyncData();
              })["catch"](function (e) {
                return console.error('error accepting invite: ', e);
              });
            case 1:
              return _context8.a(2);
          }
        }, _callee8);
      }));
      function onAcceptInvite(_x5) {
        return _onAcceptInvite.apply(this, arguments);
      }
      return onAcceptInvite;
    }()
  }, {
    key: "canRemoveUser",
    value: function () {
      var _canRemoveUser = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee9() {
        var user,
          group,
          users,
          _args9 = arguments;
        return _regenerator().w(function (_context9) {
          while (1) switch (_context9.n) {
            case 0:
              user = _args9.length > 0 && _args9[0] !== undefined ? _args9[0] : false;
              group = _args9.length > 1 && _args9[1] !== undefined ? _args9[1] : false;
              if (!user) {
                _context9.n = 5;
                break;
              }
              if (!(this.state.selectedUserGroup._id === this.props.selectedItems.selectedUserGroupId && user._id === this.props.user._id)) {
                _context9.n = 1;
                break;
              }
              return _context9.a(2, {
                allow: false,
                message: "You can't remove your user from the current UserGroup"
              });
            case 1:
              if (!(this.state.usersInSelectedGroup.length === 1)) {
                _context9.n = 2;
                break;
              }
              return _context9.a(2, {
                allow: false,
                message: "You can't remove the last User from a UserGroup"
              });
            case 2:
              if (!(user._id === this.props.user._id)) {
                _context9.n = 3;
                break;
              }
              return _context9.a(2, {
                allow: true,
                message: 'Are you sure you want to remove yourself from this UserGroup?'
              });
            case 3:
              return _context9.a(2, {
                allow: true,
                message: 'Confirm Remove User from Group'
              });
            case 4:
              _context9.n = 10;
              break;
            case 5:
              if (!group) {
                _context9.n = 10;
                break;
              }
              if (!(group._id === this.props.selectedItems.selectedUserGroupId && this.state.selectedUser._id === this.props.user._id)) {
                _context9.n = 6;
                break;
              }
              return _context9.a(2, {
                allow: false,
                message: "You can't remove your user from the current UserGroup"
              });
            case 6:
              _context9.n = 7;
              return IafUserGroup.getUsers(group, null, {
                _offset: 0,
                _pageSize: 200
              });
            case 7:
              users = _context9.v;
              if (!(users.length === 1)) {
                _context9.n = 8;
                break;
              }
              return _context9.a(2, {
                allow: false,
                message: "You can't remove the last User from a UserGroup"
              });
            case 8:
              if (!(this.state.selectedUser._id === this.props.user._id)) {
                _context9.n = 9;
                break;
              }
              return _context9.a(2, {
                allow: true,
                message: 'Are you sure you want to remove yourself from this UserGroup?'
              });
            case 9:
              return _context9.a(2, {
                allow: true,
                message: 'Confirm Remove User from Group'
              });
            case 10:
              return _context9.a(2);
          }
        }, _callee9, this);
      }));
      function canRemoveUser() {
        return _canRemoveUser.apply(this, arguments);
      }
      return canRemoveUser;
    }()
  }, {
    key: "removeUser",
    value: function () {
      var _removeUser = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee0() {
        var _this8 = this;
        var user,
          group,
          removeUser,
          fromGroup,
          canRemove,
          _args0 = arguments;
        return _regenerator().w(function (_context0) {
          while (1) switch (_context0.n) {
            case 0:
              user = _args0.length > 0 && _args0[0] !== undefined ? _args0[0] : false;
              group = _args0.length > 1 && _args0[1] !== undefined ? _args0[1] : false;
              if (user) {
                removeUser = user;
                fromGroup = this.state.selectedUserGroup;
              } else {
                removeUser = this.state.selectedUser;
                fromGroup = group;
              }
              if (!(this.state.pageMode === 'UserGroups')) {
                _context0.n = 2;
                break;
              }
              _context0.n = 1;
              return this.canRemoveUser(removeUser);
            case 1:
              canRemove = _context0.v;
              _context0.n = 4;
              break;
            case 2:
              _context0.n = 3;
              return this.canRemoveUser(null, fromGroup);
            case 3:
              canRemove = _context0.v;
            case 4:
              if (canRemove) {
                IafUserGroup.deleteUserFromGroup(fromGroup, removeUser).then(function (result) {
                  //if in usermode and we are removing the last usergroup for user
                  //reload everything as the user will need to disappear from the user list
                  if (_this8.state.pageMode === 'Users' && _this8.state.userGroupsForSelectedUser.length === 1) _this8._loadAsyncData();else _this8.updateCurrentView();
                });
              }
            case 5:
              return _context0.a(2);
          }
        }, _callee0, this);
      }));
      function removeUser() {
        return _removeUser.apply(this, arguments);
      }
      return removeUser;
    }()
  }, {
    key: "updateCurrentView",
    value: function updateCurrentView() {
      if (this.state.pageMode === 'UserGroups') this.loadUserGroupData();else this.loadUserData();
    }
  }, {
    key: "render",
    value: function render() {
      var _this9 = this,
        _this$props$handler$c;
      return /*#__PURE__*/React.createElement("div", {
        className: "user-group-view"
      }, this.props.handler.config.allowUserGroupInvite && /*#__PURE__*/React.createElement(StackableDrawer, {
        level: 1,
        iconKey: "fas fa-user-plus",
        isDrawerOpen: false
      }, /*#__PURE__*/React.createElement(InviteForm, {
        appName: this.props.selectedItems.ipaConfig.appName,
        appUrl: this.props.handler.config.appUrl,
        currentUser: this.props.user,
        users: this.state.users,
        userGroups: this.state.userGroups,
        project: this.props.selectedItems.selectedProject,
        onInvitesSent: this.updateCurrentView
      })), /*#__PURE__*/React.createElement(StackableDrawer, {
        level: this.props.handler.config.allowUserGroupInvite ? 2 : 1,
        iconKey: "fas fa-users",
        isDrawerOpen: true
      }, /*#__PURE__*/React.createElement("div", {
        className: "switchable-list-view"
      }, /*#__PURE__*/React.createElement("div", {
        className: "list-header"
      }, /*#__PURE__*/React.createElement("div", {
        className: "radio-btns"
      }, /*#__PURE__*/React.createElement(RadioButtons, {
        options: this.state.pageModes,
        value: this.state.pageMode,
        onChange: this.onModeChange,
        labelPlacement: "end"
      }))), /*#__PURE__*/React.createElement("hr", null), this.state.pageMode === 'UserGroups' && /*#__PURE__*/React.createElement("div", null, !this.state.selectedUserGroup && /*#__PURE__*/React.createElement(SimpleTextThrobber, {
        throbberText: "Loading UserGroups"
      }), /*#__PURE__*/React.createElement("ul", {
        className: "user-group-list"
      }, this.state.userGroups.map(function (u) {
        return /*#__PURE__*/React.createElement(GroupCard, {
          key: u._id,
          group: u,
          selectable: true,
          isSelected: u._id === _this9.state.selectedUserGroup._id,
          onClick: function onClick(e) {
            return _this9.setSelectedUserGroup(u);
          }
        });
      })), this.state.invalidUserGroups.length > 0 && /*#__PURE__*/React.createElement("div", {
        className: "other-groups"
      }, /*#__PURE__*/React.createElement("span", null, "Other Groups"), /*#__PURE__*/React.createElement("ul", {
        className: "other-group-list"
      }, this.state.invalidUserGroups.map(function (u) {
        return /*#__PURE__*/React.createElement(GroupCard, {
          key: u._id,
          group: u,
          disabled: true
        });
      })))), this.state.pageMode === 'Users' && /*#__PURE__*/React.createElement("div", null, !this.state.selectedUser && /*#__PURE__*/React.createElement(SimpleTextThrobber, {
        throbberText: "Loading Users"
      }), /*#__PURE__*/React.createElement("ul", {
        className: "user-group-list"
      }, this.state.users.map(function (u) {
        return /*#__PURE__*/React.createElement(UserCard, {
          key: u._id,
          user: u,
          isCurrentUser: u._id === _this9.props.user._id,
          selectable: true,
          isSelected: u._id === _this9.state.selectedUser._id,
          onClick: function onClick(e) {
            return _this9.setSelectedUser(u);
          }
        });
      }))))), this.state.pageMode === 'UserGroups' && /*#__PURE__*/React.createElement("div", {
        className: "usergroup-mode-view"
      }, /*#__PURE__*/React.createElement("div", {
        className: "row1"
      }, !this.state.editingUserGroup && /*#__PURE__*/React.createElement("div", {
        className: "usergroup-info"
      }, /*#__PURE__*/React.createElement("div", {
        className: "usergroup-name"
      }, /*#__PURE__*/React.createElement("h1", null, this.state.selectedUserGroup ? this.state.selectedUserGroup._name : ""), this.props.handler.config.allowUserGroupEdit && this.state.selectedUserGroup && /*#__PURE__*/React.createElement("span", {
        className: "ug-btn"
      }, /*#__PURE__*/React.createElement("a", {
        href: "#",
        onClick: this.toggleUserGroupEditable
      }, "edit"))), this.props.handler.config.allowViewPermissions && /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(RadioButtons, {
        options: this.state.userGroupModes,
        value: this.state.userGroupMode,
        onChange: this.onUserGroupModeChange,
        labelPlacement: "end"
      }))), this.state.editingUserGroup && /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", {
        className: "usergroup-name editable"
      }, /*#__PURE__*/React.createElement("h1", null, /*#__PURE__*/React.createElement("input", {
        className: "usergroup-name-input",
        type: "text",
        disabled: this.state.savingUserGroup,
        value: this.state.userGroupNameEdit,
        onChange: this.onUserGroupNameChange
      })), /*#__PURE__*/React.createElement("span", {
        className: "ug-btn"
      }, !this.state.savingUserGroup && !this.state.userGroupNameEditError && /*#__PURE__*/React.createElement("a", {
        href: "#",
        onClick: this.updateUserGroup
      }, "save"), (this.state.savingUserGroup || this.state.userGroupNameEditError) && /*#__PURE__*/React.createElement("span", {
        className: "disabled-ug-btn"
      }, "save")), /*#__PURE__*/React.createElement("span", {
        className: "ug-btn"
      }, !this.state.savingUserGroup && /*#__PURE__*/React.createElement("a", {
        href: "#",
        onClick: this.toggleUserGroupEditable
      }, "cancel"), this.state.savingUserGroup && /*#__PURE__*/React.createElement("span", {
        className: "disabled-ug-btn"
      }, "cancel"))), this.state.userGroupNameEditError && /*#__PURE__*/React.createElement("div", {
        className: "usergroup-name-error"
      }, this.state.userGroupNameEditError))), /*#__PURE__*/React.createElement("hr", null), this.state.userGroupMode === "Users/Invites" && /*#__PURE__*/React.createElement("div", {
        className: "row2"
      }, /*#__PURE__*/React.createElement("div", {
        className: "usergroup-members"
      }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("h3", null, "Members")), this.state.usersInSelectedGroup.length === 0 && /*#__PURE__*/React.createElement("div", {
        className: "throbber"
      }, /*#__PURE__*/React.createElement(SimpleTextThrobber, {
        throbberText: "Loading UserGroup Members"
      })), /*#__PURE__*/React.createElement("ul", {
        className: "group-users-list"
      }, this.state.usersInSelectedGroup.map(function (u) {
        return /*#__PURE__*/React.createElement(UserCard, {
          key: u._id,
          user: u,
          isCurrentUser: u._id === _this9.props.user._id,
          showActions: _this9.props.handler.config.allowManageUsers,
          canRemoveUser: _this9.canRemoveUser,
          onRemoveUser: _this9.removeUser
        });
      }))), /*#__PURE__*/React.createElement("div", {
        className: "usergroup-invites"
      }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("h3", null, "Invites")), this.state.loadingInvites && /*#__PURE__*/React.createElement("div", {
        className: "throbber"
      }, /*#__PURE__*/React.createElement(SimpleTextThrobber, {
        throbberText: "Loading UserGroup Invites"
      })), !this.state.loadingInvites && this.state.invitesInSelectedGroup.length === 0 && /*#__PURE__*/React.createElement("span", {
        className: "indent-header"
      }, "No pending invites"), /*#__PURE__*/React.createElement("ul", null, this.state.invitesInSelectedGroup.map(function (i) {
        return /*#__PURE__*/React.createElement(InviteCard, {
          key: i._id,
          invite: i,
          isCurrentUser: i._email === _this9.props.user._email,
          existingUser: _.find(_this9.state.users, {
            _email: i._email
          }),
          showActions: _this9.props.handler.config.allowManageInvites,
          onCancelInvite: _this9.onCancelInvite,
          onResendInvite: _this9.onResendInvite,
          onAcceptInvite: _this9.onAcceptInvite
        });
      })), this.state.expiredInvitesInSelectedGroup.length > 0 && /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("span", {
        className: "indent-header"
      }, "Expired Invites"), /*#__PURE__*/React.createElement("ul", null, this.state.expiredInvitesInSelectedGroup.map(function (i) {
        return /*#__PURE__*/React.createElement(InviteCard, {
          key: i._id,
          invite: i,
          isCurrentUser: i._email === _this9.props.user._email,
          existingUser: _.find(_this9.state.users, {
            _email: i._email
          }),
          showActions: _this9.props.handler.config.allowManageInvites,
          onCancelInvite: _this9.onCancelInvite,
          onResendInvite: _this9.onResendInvite,
          onAcceptInvite: _this9.onAcceptInvite
        });
      }))))), this.state.userGroupMode === 'Permissions' && /*#__PURE__*/React.createElement("div", {
        className: "row2 table"
      }, /*#__PURE__*/React.createElement(UserGroupPermissionTable, {
        usergroup: this.state.selectedUserGroup,
        allowManagePermissions: this.props.handler.config.allowManagePermissions,
        itemFetchScript: (_this$props$handler$c = this.props.handler.config.scripts) === null || _this$props$handler$c === void 0 ? void 0 : _this$props$handler$c.itemFetchScript
      }))), this.state.pageMode === 'Users' && /*#__PURE__*/React.createElement("div", {
        className: "user-mode-view"
      }, /*#__PURE__*/React.createElement("div", {
        className: "row1"
      }, /*#__PURE__*/React.createElement("div", {
        className: "user-name-title"
      }, /*#__PURE__*/React.createElement("h1", null, this.state.selectedUser ? this.state.selectedUser._lastname + ", " + this.state.selectedUser._firstname : ""))), /*#__PURE__*/React.createElement("hr", null), /*#__PURE__*/React.createElement("div", {
        className: "row2"
      }, /*#__PURE__*/React.createElement("div", {
        className: "member-usergroups"
      }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("h3", null, "UserGroups")), this.state.userGroupsForSelectedUser.length === 0 && /*#__PURE__*/React.createElement("div", {
        className: "throbber"
      }, /*#__PURE__*/React.createElement(SimpleTextThrobber, {
        throbberText: "Loading UserGroups"
      })), /*#__PURE__*/React.createElement("ul", {
        className: "member-usergroup-list"
      }, this.state.userGroupsForSelectedUser.map(function (u) {
        return /*#__PURE__*/React.createElement(GroupCard, {
          key: u._id,
          group: u,
          showActions: _this9.props.handler.config.allowManageUsers,
          canRemoveUser: _this9.canRemoveUser,
          onRemoveUser: _this9.removeUser
        });
      }))), /*#__PURE__*/React.createElement("div", {
        className: "member-invites"
      }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("h3", null, "Invites")), this.state.loadingInvites && /*#__PURE__*/React.createElement("div", {
        className: "throbber"
      }, /*#__PURE__*/React.createElement(SimpleTextThrobber, {
        throbberText: "Loading User Invites"
      })), !this.state.loadingInvites && this.state.invitesForSelectedUser.length === 0 && /*#__PURE__*/React.createElement("span", {
        className: "indent-header"
      }, "No pending invites"), /*#__PURE__*/React.createElement("ul", null, this.state.invitesForSelectedUser.map(function (i) {
        return /*#__PURE__*/React.createElement(InviteCard, {
          key: i._id,
          invite: i,
          isCurrentUser: i._email === _this9.props.user._email,
          existingUser: _.find(_this9.state.users, {
            _email: i._email
          }),
          showActions: _this9.props.handler.config.allowManageInvites,
          onCancelInvite: _this9.onCancelInvite,
          onResendInvite: _this9.onResendInvite,
          onAcceptInvite: _this9.onAcceptInvite
        });
      })), this.state.expiredInvitesForSelectedUser.length > 0 && /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("span", {
        className: "indent-header"
      }, "Expired Invites"), /*#__PURE__*/React.createElement("ul", null, this.state.expiredInvitesForSelectedUser.map(function (i) {
        return /*#__PURE__*/React.createElement(InviteCard, {
          key: i._id,
          invite: i,
          isCurrentUser: i._email === _this9.props.user._email,
          existingUser: _.find(_this9.state.users, {
            _email: i._email
          }),
          showActions: _this9.props.handler.config.allowManageInvites,
          onCancelInvite: _this9.onCancelInvite,
          onResendInvite: _this9.onResendInvite,
          onAcceptInvite: _this9.onAcceptInvite
        });
      })))))));
    }
  }]);
}(React.Component);

var css_248z$c = ".datasource-history-table th {\n  padding: 5px;\n  color: var(--app-accent-color);\n  border-bottom: 1px solid black;\n}\n.datasource-history-table td {\n  padding: 5px;\n}\n.datasource-history-table .error {\n  color: var(--app-accent-color);\n}";
styleInject(css_248z$c);

var DatasourceHistoryTable = function DatasourceHistoryTable(_ref) {
  var runs = _ref.runs;
  var getFormattedDate = function getFormattedDate(stamp) {
    var rundate = moment(parseInt(stamp));
    return rundate.format('MMM D YYYY kk:mm:ss');
  };
  var sortRuns = function sortRuns() {
    if (runs) return _toConsumableArray(runs).sort(function (a, b) {
      return parseInt(b._createdat) - parseInt(a._createdat);
    });else return null;
  };
  return /*#__PURE__*/React.createElement("table", {
    className: "datasource-history-table"
  }, /*#__PURE__*/React.createElement("thead", null, /*#__PURE__*/React.createElement("tr", null, /*#__PURE__*/React.createElement("th", null, "Run at"), /*#__PURE__*/React.createElement("th", null, "Status"))), /*#__PURE__*/React.createElement("tbody", null, sortRuns().map(function (run) {
    return /*#__PURE__*/React.createElement("tr", {
      key: run.id,
      className: clsx(run._status === "ERROR" && 'error')
    }, /*#__PURE__*/React.createElement("td", {
      className: "stamp"
    }, getFormattedDate(run._createdat)), /*#__PURE__*/React.createElement("td", {
      className: "status"
    }, run._status));
  })));
};

var css_248z$d = ".datasource-schedule-table th {\n  padding: 10px;\n  text-align: center;\n}\n.datasource-schedule-table .first-row th {\n  border-bottom: 1px solid black;\n}\n.datasource-schedule-table td {\n  padding: 10px;\n  text-align: center;\n}\n.datasource-schedule-table .datasource-schedule-input {\n  background-color: #f2f2f2;\n  border-top: none;\n  border-right: none;\n  border-bottom: 2px solid var(--app-accent-color);\n  border-left: none;\n  width: 100%;\n  text-align: center;\n}\n.datasource-schedule-table .buttons a {\n  margin-right: 10px;\n}";
styleInject(css_248z$d);

var DatasourceScheduleTable = function DatasourceScheduleTable(_ref) {
  var orchestrator = _ref.orchestrator,
    _ref$readonly = _ref.readonly,
    readonly = _ref$readonly === void 0 ? true : _ref$readonly,
    updateOrchestratorSchedule = _ref.updateOrchestratorSchedule;
  var _useState = useState(0),
    _useState2 = _slicedToArray(_useState, 2),
    hours = _useState2[0],
    setHours = _useState2[1];
  var _useState3 = useState(0),
    _useState4 = _slicedToArray(_useState3, 2),
    minutes = _useState4[0],
    setMinutes = _useState4[1];
  var _useState5 = useState(0),
    _useState6 = _slicedToArray(_useState5, 2),
    seconds = _useState6[0],
    setSeconds = _useState6[1];
  var _useState7 = useState(false),
    _useState8 = _slicedToArray(_useState7, 2),
    editing = _useState8[0],
    setEditing = _useState8[1];
  var _useState9 = useState(false),
    _useState0 = _slicedToArray(_useState9, 2),
    isSaving = _useState0[0],
    setIsSaving = _useState0[1];
  useEffect(function () {
    setScheduleFromOrchestrator();
  }, []);
  var setScheduleFromOrchestrator = function setScheduleFromOrchestrator() {
    var splitInt = orchestrator._orchschedule.runinterval.split(' ');
    for (var i = 0; i < splitInt.length; i++) {
      if (splitInt[i] === '*') splitInt[i] = 0;
    }
    setHours(parseInt(splitInt[0]));
    setMinutes(parseInt(splitInt[1]));
    setSeconds(parseInt(splitInt[2]));
  };
  var editSchedule = function editSchedule(e) {
    if (e) e.preventDefault();
    if (!readonly) setEditing(true);
  };
  var cancelEditSchedule = function cancelEditSchedule(e) {
    if (e) e.preventDefault();
    setEditing(false);
    setScheduleFromOrchestrator();
  };
  var getInput = function getInput(value, updateValue) {
    return /*#__PURE__*/React.createElement("input", {
      className: "datasource-schedule-input",
      type: "number",
      disabled: isSaving,
      value: value,
      onChange: function onChange(e) {
        return updateValue(e.target.value);
      }
    });
  };
  var onSave = function onSave(e) {
    if (e) e.preventDefault();
    setIsSaving(true);
    setEditing(false);
    var newIntervalString = (hours === 0 ? "*" : hours) + " " + (minutes === 0 ? "*" : minutes) + " " + (seconds === 0 ? "*" : seconds);
    updateOrchestratorSchedule(orchestrator, newIntervalString).then(function () {
      setIsSaving(false);
    });
  };
  return /*#__PURE__*/React.createElement("table", {
    className: "datasource-schedule-table"
  }, /*#__PURE__*/React.createElement("thead", null, /*#__PURE__*/React.createElement("tr", {
    className: "first-row"
  }, /*#__PURE__*/React.createElement("th", {
    colSpan: "3"
  }, "Run Every:"), /*#__PURE__*/React.createElement("th", null)), /*#__PURE__*/React.createElement("tr", null, /*#__PURE__*/React.createElement("th", null, "Hours"), /*#__PURE__*/React.createElement("th", null, "Minutes"), /*#__PURE__*/React.createElement("th", null, "Seconds"), /*#__PURE__*/React.createElement("th", null))), /*#__PURE__*/React.createElement("tbody", null, /*#__PURE__*/React.createElement("tr", null, /*#__PURE__*/React.createElement("td", null, !editing && /*#__PURE__*/React.createElement("span", null, hours), editing && getInput(hours, setHours)), /*#__PURE__*/React.createElement("td", null, !editing && /*#__PURE__*/React.createElement("span", null, minutes), editing && getInput(minutes, setMinutes)), /*#__PURE__*/React.createElement("td", null, !editing && /*#__PURE__*/React.createElement("span", null, seconds), editing && getInput(seconds, setSeconds)), /*#__PURE__*/React.createElement("td", {
    className: "buttons"
  }, !editing && !readonly && !isSaving && /*#__PURE__*/React.createElement("a", {
    href: "#",
    onClick: editSchedule
  }, "edit"), editing && /*#__PURE__*/React.createElement("a", {
    href: "#",
    onClick: cancelEditSchedule
  }, "cancel"), editing && /*#__PURE__*/React.createElement("a", {
    href: "#",
    onClick: onSave
  }, "save"), isSaving && /*#__PURE__*/React.createElement(SimpleTextThrobber, {
    throbberText: "Saving schedule"
  })))));
};

var css_248z$e = ".datasource-list-item {\n  list-style-type: none;\n  border: 1px solid lightgray;\n  border-radius: 10px;\n  margin: 10px;\n  padding: 5px 5px 5px 20px;\n  box-shadow: 2px 2px lightgrey;\n  display: flex;\n  flex-direction: column;\n}\n.datasource-list-item .error {\n  color: var(--app-accent-color);\n}\n.datasource-list-item .card-row1 {\n  display: flex;\n  flex-direction: row;\n}\n.datasource-list-item .card-row1 .datasource-name {\n  flex-basis: 40%;\n}\n.datasource-list-item .card-row1 .datasource-name .datasource-name {\n  color: var(--app-accent-color);\n}\n.datasource-list-item .card-row1 .datasource-name .datasource-desc {\n  padding-left: 10px;\n  font-size: 0.75rem;\n  font-style: italic;\n}\n.datasource-list-item .card-row1 .datasource-info {\n  flex-basis: 40%;\n  padding-left: 10px;\n}\n.datasource-list-item .card-row1 .datasource-info .info-point {\n  display: flex;\n  align-items: center;\n}\n.datasource-list-item .card-row1 .datasource-info .info-value {\n  margin-left: 2px;\n}\n.datasource-list-item .card-row2 {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-around;\n  border-top: solid 2px #f2f2f2;\n  padding: 10px;\n  margin-top: 10px;\n  max-height: 150px;\n  overflow-y: auto;\n}\n.datasource-list-item .card-row2 .confirm-text {\n  font-weight: bold;\n}\n.datasource-list-item .card-row2 i {\n  padding-right: 5px;\n}\n.datasource-list-item .card-row2 a {\n  display: inline-flex;\n  align-items: center;\n  color: var(--app-accent-color);\n}\n.datasource-list-item .card-row2:hover {\n  background-color: white;\n  border-radius: 10px;\n  border: 1px solid var(--app-accent-color);\n}\n\n.datasource-list-item:hover {\n  background-color: #f2f2f2;\n}\n\n.datasource-card-options {\n  align-self: center;\n  color: var(--app-accent-color);\n  margin-left: 5px;\n}\n.datasource-card-options i {\n  cursor: pointer;\n}";
styleInject(css_248z$e);

var DatasourceCard = function DatasourceCard(_ref) {
  var orchestrator = _ref.orchestrator,
    _ref$readonly = _ref.readonly,
    readonly = _ref$readonly === void 0 ? true : _ref$readonly,
    runs = _ref.runs,
    onDidUpdate = _ref.onDidUpdate,
    removeOrchestrator = _ref.removeOrchestrator;
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isDoingAction = _useState2[0],
    setIsDoingAction = _useState2[1];
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    showRowTwo = _useState4[0],
    setShowRowTwo = _useState4[1];
  var _useState5 = useState(false),
    _useState6 = _slicedToArray(_useState5, 2),
    showHistory = _useState6[0],
    setShowHistory = _useState6[1];
  var _useState7 = useState(false),
    _useState8 = _slicedToArray(_useState7, 2),
    showSchedule = _useState8[0],
    setShowSchedule = _useState8[1];
  var _useState9 = useState(false),
    _useState0 = _slicedToArray(_useState9, 2),
    showDelete = _useState0[0],
    setShowDelete = _useState0[1];
  var getFormattedDate = function getFormattedDate(stamp) {
    var rundate = moment(parseInt(stamp));
    return rundate.format('MMM D YYYY kk:mm:ss');
  };
  var toggleHistory = function toggleHistory() {
    if (showSchedule) setShowSchedule(false);
    if (showDelete) showDelete(false);
    if (showHistory) setShowRowTwo(false);else setShowRowTwo(true);
    setShowHistory(!showHistory);
  };
  var toggleSchedule = function toggleSchedule() {
    if (showHistory) setShowHistory(false);
    if (showDelete) setShowDelete(false);
    if (showSchedule) setShowRowTwo(false);else setShowRowTwo(true);
    setShowSchedule(!showSchedule);
  };
  var toggleDelete = function toggleDelete(e) {
    if (e) e.preventDefault();
    if (showSchedule) setShowSchedule(false);
    if (showHistory) setShowHistory(false);
    if (showDelete) setShowRowTwo(false);else setShowRowTwo(true);
    setShowDelete(!showDelete);
  };
  var sortRuns = function sortRuns() {
    if (runs) return _toConsumableArray(runs).sort(function (a, b) {
      return parseInt(b._createdat) - parseInt(a._createdat);
    });else return null;
  };
  var getLatestRun = function getLatestRun() {
    if (runs) {
      var sortedRuns = sortRuns();
      return sortedRuns.shift();
    } else return null;
  };
  var getLatestRunStatus = function getLatestRunStatus() {
    if (runs) {
      var last = getLatestRun();
      if (last._status === 'RUNNING' || last._status === 'QUEUED') return /*#__PURE__*/React.createElement(SimpleTextThrobber, {
        throbberText: last._status
      });else return last._status;
    } else return 'NOT RUN';
  };
  var updateSchedule = function updateSchedule(orchestrator, newInterval) {
    return new Promise(function (resolve, reject) {
      setIsDoingAction(true);
      IafDataSource.updateOrchestratorSchedule(orchestrator._orchschedule._id, {
        runinterval: newInterval
      }).then(function (res) {
        onDidUpdate();
        resolve(res);
      })["catch"](function (err) {
        console.error(err);
      })["finally"](function () {
        setIsDoingAction(false);
      });
    });
  };
  var deleteOrchestrator = function deleteOrchestrator(e) {
    e.preventDefault();
    removeOrchestrator(orchestrator);
  };
  return /*#__PURE__*/React.createElement("li", {
    className: "datasource-list-item"
  }, /*#__PURE__*/React.createElement("div", {
    className: "card-row1"
  }, /*#__PURE__*/React.createElement("div", {
    className: "datasource-name"
  }, /*#__PURE__*/React.createElement("div", {
    className: "datasource-name"
  }, orchestrator._name), /*#__PURE__*/React.createElement("div", {
    className: "datasource-desc"
  }, orchestrator._description)), /*#__PURE__*/React.createElement("div", {
    className: "datasource-info"
  }, /*#__PURE__*/React.createElement("div", {
    className: "info-point"
  }, /*#__PURE__*/React.createElement("span", {
    style: {
      fontWeight: 'bold'
    }
  }, "Type: "), /*#__PURE__*/React.createElement("span", {
    className: "info-value"
  }, orchestrator._class)), orchestrator._class === "SCHEDULED" && /*#__PURE__*/React.createElement("div", {
    className: "info-point"
  }, /*#__PURE__*/React.createElement("span", {
    style: {
      fontWeight: 'bold'
    }
  }, "Next Run: "), /*#__PURE__*/React.createElement("span", {
    className: "info-value"
  }, getFormattedDate(orchestrator._orchschedule.next_scheduled_time))), /*#__PURE__*/React.createElement("div", {
    className: "info-point"
  }, /*#__PURE__*/React.createElement("span", {
    style: {
      fontWeight: 'bold'
    }
  }, "User Type: "), /*#__PURE__*/React.createElement("span", {
    className: "info-value"
  }, orchestrator._userType)), /*#__PURE__*/React.createElement("div", {
    className: "info-point"
  }, /*#__PURE__*/React.createElement("span", {
    style: {
      fontWeight: 'bold'
    }
  }, "Last Status: "), /*#__PURE__*/React.createElement("span", {
    className: clsx('info-value', getLatestRunStatus() === 'ERROR' && 'error')
  }, getLatestRunStatus()))), !isDoingAction && /*#__PURE__*/React.createElement("div", {
    className: "datasource-card-options"
  }, runs && /*#__PURE__*/React.createElement("i", {
    className: "fas fa-history",
    onClick: toggleHistory
  }), orchestrator._class === "SCHEDULED" && /*#__PURE__*/React.createElement("i", {
    className: "far fa-calendar-alt",
    onClick: toggleSchedule
  }), !readonly && removeOrchestrator && /*#__PURE__*/React.createElement("i", {
    className: "fas fa-trash",
    onClick: toggleDelete
  }))), showRowTwo && /*#__PURE__*/React.createElement("div", {
    className: "card-row2"
  }, showHistory && /*#__PURE__*/React.createElement(DatasourceHistoryTable, {
    runs: runs
  }), showSchedule && /*#__PURE__*/React.createElement(DatasourceScheduleTable, {
    orchestrator: orchestrator,
    readonly: readonly,
    updateOrchestratorSchedule: updateSchedule
  }), showDelete && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("div", {
    className: "confirm-text"
  }, "Confirm Remove Datasource"), /*#__PURE__*/React.createElement("a", {
    href: "#",
    onClick: deleteOrchestrator
  }, /*#__PURE__*/React.createElement("i", {
    className: "fas fa-check"
  }), "Remove Datasource"), /*#__PURE__*/React.createElement("a", {
    href: "#",
    onClick: toggleSchedule
  }, /*#__PURE__*/React.createElement("i", {
    className: "fas fa-times"
  }), "Cancel"))));
};

var css_248z$f = ".datasources-view {\n  padding-left: 50px;\n  padding-top: 25px;\n}\n.datasources-view .datasources-header {\n  width: 100%;\n}\n.datasources-view .datasources-header h1 {\n  color: var(--app-accent-color);\n}\n.datasources-view .datasources-list {\n  width: 50%;\n}";
styleInject(css_248z$f);

var DatasourcesView = /*#__PURE__*/function (_React$Component) {
  function DatasourcesView(props) {
    var _this;
    _classCallCheck(this, DatasourcesView);
    _this = _callSuper(this, DatasourcesView, [props]);
    _this.state = {
      orchestrators: [],
      runs: {},
      runInterval: null
    };
    _this._loadAsyncData = _this._loadAsyncData.bind(_this);
    _this.getOrchestrators = _this.getOrchestrators.bind(_this);
    _this.getRuns = _this.getRuns.bind(_this);
    _this.removeOrchestrator = _this.removeOrchestrator.bind(_this);
    return _this;
  }
  _inherits(DatasourcesView, _React$Component);
  return _createClass(DatasourcesView, [{
    key: "componentDidMount",
    value: function () {
      var _componentDidMount = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              this._loadAsyncData();
              console.log('props', this.props);
              console.log('state', this.state);
            case 1:
              return _context.a(2);
          }
        }, _callee, this);
      }));
      function componentDidMount() {
        return _componentDidMount.apply(this, arguments);
      }
      return componentDidMount;
    }()
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      //See below about polling
      // clearInterval(this.state.runInterval)
      // this.setState({runInterval: null})
    }
  }, {
    key: "_loadAsyncData",
    value: function () {
      var _loadAsyncData2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2() {
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              _context2.n = 1;
              return this.getOrchestrators();
            case 1:
              this.getRuns();

              /*
                * This polling was causing a problem as the total number of orch runs gets large
                * will re-examine once the API provides us a way to mroe efficiently query orch runs
              let interval = setInterval(this.getRuns, 5000)
              this.setState({runInterval: interval})
              */
            case 2:
              return _context2.a(2);
          }
        }, _callee2, this);
      }));
      function _loadAsyncData() {
        return _loadAsyncData2.apply(this, arguments);
      }
      return _loadAsyncData;
    }()
  }, {
    key: "getOrchestrators",
    value: function () {
      var _getOrchestrators = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3() {
        var _this2 = this;
        return _regenerator().w(function (_context3) {
          while (1) switch (_context3.n) {
            case 0:
              return _context3.a(2, IafDataSource.getOrchestrators().then(function (orchs) {
                var allOrchs = orchs._list;
                allOrchs.sort(function (a, b) {
                  return a._name.localeCompare(b._name);
                });
                _this2.setState({
                  orchestrators: allOrchs
                });
                _this2.props.onLoadComplete();
              }));
          }
        }, _callee3);
      }));
      function getOrchestrators() {
        return _getOrchestrators.apply(this, arguments);
      }
      return getOrchestrators;
    }()
  }, {
    key: "getRuns",
    value: function () {
      var _getRuns = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4() {
        var _this3 = this;
        return _regenerator().w(function (_context4) {
          while (1) switch (_context4.n) {
            case 0:
              IafDataSource.getOrchestratorRuns().then(function (runs) {
                var groupedRuns = {};
                runs.forEach(function (run) {
                  if (!groupedRuns[run._orchid]) {
                    groupedRuns[run._orchid] = [];
                  }
                  groupedRuns[run._orchid].push(run);
                });
                _this3.setState({
                  runs: groupedRuns
                });
              });
            case 1:
              return _context4.a(2);
          }
        }, _callee4);
      }));
      function getRuns() {
        return _getRuns.apply(this, arguments);
      }
      return getRuns;
    }()
  }, {
    key: "removeOrchestrator",
    value: function removeOrchestrator(orchestrator) {
      var _this4 = this;
      IafDataSource.deleteOrchestrator(orchestrator.id).then(function (result) {
        _this4._loadAsyncData();
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this5 = this;
      return /*#__PURE__*/React.createElement("div", {
        className: "datasources-view"
      }, /*#__PURE__*/React.createElement("div", {
        className: "datasources-header"
      }, /*#__PURE__*/React.createElement("h1", null, "Datasources"), /*#__PURE__*/React.createElement("hr", null)), /*#__PURE__*/React.createElement("div", {
        className: "datasources-list"
      }, this.state.orchestrators.map(function (o) {
        return /*#__PURE__*/React.createElement(DatasourceCard, {
          key: o.id,
          orchestrator: o,
          runs: _this5.state.runs[o.id],
          readonly: !_this5.props.handler.config.allowManageDatasources,
          onDidUpdate: _this5.getOrchestrators,
          removeOrchestrator: _this5.props.handler.config.allowDeleteDatasources ? _this5.removeOrchestrator : false
        });
      })));
    }
  }]);
}(React.Component);

var css_248z$g = ".card-error-msg {\n  color: darkred;\n  border-radius: 5px;\n  font-size: large;\n  text-align: center;\n  border: solid 1px darkred;\n  padding: 3px;\n  background-color: lightpink;\n}";
styleInject(css_248z$g);

var OMAPICardError = function OMAPICardError(_ref) {
  var error = _ref.error;
  return /*#__PURE__*/React.createElement("div", null, error && /*#__PURE__*/React.createElement("div", {
    className: "card-error-msg"
  }, error));
};

var css_248z$h = ".omapi-card {\n  list-style-type: none;\n  border: 1px solid lightgray;\n  border-radius: 10px;\n  margin: 10px;\n  padding: 5px 5px 5px 20px;\n  box-shadow: 2px 2px lightgrey;\n}\n.omapi-card .card-row1 {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  font-size: large;\n  padding: 2px;\n  color: var(--app-accent-color);\n}\n.omapi-card .card-row1 .partial-path {\n  cursor: pointer;\n}\n.omapi-card .card-row1 .partial-path .method {\n  font-weight: bold;\n}\n.omapi-card .card-row1 .full-path-wrapper {\n  min-width: 0;\n  overflow: hidden;\n  white-space: nowrap;\n  text-overflow: ellipsis;\n}\n.omapi-card .card-row1 .full-path-wrapper .full-path {\n  margin-left: 20px;\n  -webkit-user-select: all;\n  -moz-user-select: all;\n  -ms-user-select: all;\n  user-select: all;\n}\n.omapi-card .card-row2 {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n  align-items: center;\n  border-top: solid 2px #f2f2f2;\n  padding: 10px;\n  margin-top: 10px;\n  background-color: #f2f2f2;\n  border-radius: 10px;\n}\n.omapi-card .card-row3 {\n  display: flex;\n  flex-direction: row;\n  justify-content: flex-start;\n  padding: 10px;\n  margin-top: 10px;\n}\n.omapi-card .card-row3 .path-config-items {\n  display: flex;\n  flex-direction: row;\n  flex-wrap: wrap;\n  width: 100%;\n  justify-content: space-evenly;\n  margin-top: -10px;\n}\n.omapi-card .card-row3 .path-config-items .even-row-space {\n  display: flex;\n  flex-direction: row;\n  justify-content: space-evenly;\n  width: 100%;\n}\n.omapi-card .card-row3 .path-config-items .config-card-full {\n  width: 100%;\n}\n.omapi-card .card-row3 .path-config-items .config-card-half {\n  width: 48%;\n}\n.omapi-card .card-row3 .path-config-items .config-card {\n  border: 1px solid lightgray;\n  border-radius: 10px;\n  padding: 10px;\n  display: flex;\n  flex-direction: column;\n  margin-top: 10px;\n  margin-right: 10px;\n  padding: 10px;\n}\n.omapi-card .card-row3 .path-config-items .config-card .config-card-title {\n  align-self: center;\n  font-weight: bold;\n  margin-bottom: 10px;\n}\n.omapi-card .card-row3 .path-config-items .config-card .config-card-val {\n  display: flex;\n  padding: 5px;\n}\n.omapi-card .card-row3 .path-config-items .config-card .config-card-val .val-name {\n  font-weight: bold;\n  min-width: 25%;\n  text-align: center;\n}\n.omapi-card .card-row3 .path-config-items .config-card .config-card-val .val-container {\n  width: 50%;\n}\n.omapi-card .card-row3 .path-config-items .config-card .config-card-val .val-value {\n  margin-bottom: 3px;\n  border-width: 0px 0px 3px 0px;\n  border-color: var(--app-accent-color);\n  width: 100%;\n}\n.omapi-card .card-row3 .path-config-items .config-card .config-card-val .config-card-desc {\n  font-style: italic;\n}\n.omapi-card .card-row3 .path-config-items .config-card .config-body {\n  height: 100%;\n}\n.omapi-card .card-row3 .path-config-items .config-card .config-body .resp {\n  font-weight: bold;\n  text-align: end;\n  font-size: large;\n  padding-right: 10px;\n}\n.omapi-card .card-row3 .path-config-items .config-card .config-body .resp-ok {\n  color: green;\n}\n.omapi-card .card-row3 .path-config-items .config-card .config-body .resp-error {\n  color: red;\n}\n.omapi-card .card-row3 .path-config-items .config-card .config-body .fetching {\n  align-items: center;\n}";
styleInject(css_248z$h);

var OMAPICard = function OMAPICard(_ref) {
  var _path$docs;
  var path = _ref.path,
    rootUrl = _ref.rootUrl,
    token = _ref.token;
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    expanded = _useState2[0],
    setExpanded = _useState2[1];
  var _useState3 = useState(null),
    _useState4 = _slicedToArray(_useState3, 2),
    pathVars = _useState4[0],
    setPathVars = _useState4[1];
  var _useState5 = useState(null),
    _useState6 = _slicedToArray(_useState5, 2),
    pathVarError = _useState6[0],
    setPathVarError = _useState6[1];
  var _useState7 = useState(null),
    _useState8 = _slicedToArray(_useState7, 2),
    queryParams = _useState8[0],
    setQueryParams = _useState8[1];
  var _useState9 = useState(null),
    _useState0 = _slicedToArray(_useState9, 2),
    requestBody = _useState0[0],
    setRequestBody = _useState0[1];
  var _useState1 = useState(null),
    _useState10 = _slicedToArray(_useState1, 2),
    requestBodyError = _useState10[0],
    setRequestBodyError = _useState10[1];
  var _useState11 = useState(true),
    _useState12 = _slicedToArray(_useState11, 2),
    responseOK = _useState12[0],
    setResponseOK = _useState12[1];
  var _useState13 = useState(null),
    _useState14 = _slicedToArray(_useState13, 2),
    responseStatus = _useState14[0],
    setResponseStatus = _useState14[1];
  var _useState15 = useState(""),
    _useState16 = _slicedToArray(_useState15, 2),
    responseBody = _useState16[0],
    setResponseBody = _useState16[1];
  var _useState17 = useState(false),
    _useState18 = _slicedToArray(_useState17, 2),
    fetching = _useState18[0],
    setFetching = _useState18[1];
  useEffect(function () {
    if (path.docs && path.docs['Path Variables'] && path.docs['Path Variables Example']) setPathVars(path.docs['Path Variables Example']);else if (path.docs && path !== null && path !== void 0 && path.docs['Path Variables']) setPathVars(makeEmptyExamples(path.docs['Path Variables']));
    if (path.docs && path.docs['Request Query Params'] && path.docs['Request Query Params Example']) setQueryParams(path.docs['Request Query Params Example']);else if (path.docs && path !== null && path !== void 0 && path.docs['Request Query Params']) setQueryParams(makeEmptyExamples(path.docs['Request Query Params']));
    if (path.docs && path.docs['Request Body Example']) setRequestBody(JSON.stringify(path.docs['Request Body Example'], null, 3));
    if (path.docs && path.docs['Response Body Example']) setResponseBody(JSON.stringify(path.docs['Response Body Example'], null, 3));
  }, []);
  var toggle = function toggle() {
    setExpanded(!expanded);
    console.log(path);
  };
  var expand = function expand() {
    if (!expanded) setExpanded(true);
  };
  var updateState = function updateState(stateToUpdate, prop, value, updateFunc) {
    var updatedState = _objectSpread2({}, stateToUpdate);
    updatedState[prop] = value;
    updateFunc(updatedState);
  };
  var onReqBodyChange = function onReqBodyChange(editor, data, value) {
    console.log(editor, data, value);
    setRequestBody(value);
  };
  var makeEmptyExamples = function makeEmptyExamples(def) {
    console.log(def);
    Object.keys(def).forEach(function (d) {
    });
  };
  var getInputType = function getInputType(state, prop) {
    if (state.hasOwnProperty(prop) && typeof state[prop] === 'number') return 'number';else return 'text';
  };
  var _flattenObject = function flattenObject(body, parent, result) {
    if (!result) result = {};
    if (!parent) parent = null;
    var level_keys = Object.keys(body);
    level_keys.forEach(function (k) {
      if (_typeof(body[k]) === 'object' & body !== null) {
        _flattenObject(body[k], k, result);
      } else {
        if (!parent) result[k] = body[k];else result[parent + '.' + k] = body[k];
      }
    });
    return result;
  };
  var tryMe = function tryMe() {
    expand();
    doFetch();
  };
  var isValidJson = function isValidJson(testString) {
    try {
      JSON.parse(testString);
      return true;
    } catch (e) {
      return false;
    }
  };
  var doFetch = /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
      var errored, url, params, options, resp;
      return _regenerator().w(function (_context) {
        while (1) switch (_context.n) {
          case 0:
            setFetching(true);
            setPathVarError(null);
            setRequestBodyError(null);
            setResponseBody("");
            setResponseStatus(null);
            setResponseOK(true);
            errored = false;
            url = rootUrl + path.path;
            if (pathVars) {
              console.log(pathVars);
              Object.keys(pathVars).forEach(function (vn) {
                if (pathVars[vn] && (pathVars[vn] === 0 || pathVars[vn].length)) url = url.replace(vn, encodeURIComponent(pathVars[vn]));else {
                  setPathVarError('ERROR: All Path Variables must have a value!');
                  errored = true;
                }
              });
            }
            if (queryParams) {
              params = "";
              Object.keys(queryParams).forEach(function (qp) {
                if (queryParams[qp] && (queryParams[qp] === 0 || queryParams[qp].length)) params += qp + '=' + encodeURIComponent(queryParams[qp]);
              });
              if (params.length) url += '?' + params;
            }
            options = {
              method: path.method,
              mode: 'cors',
              headers: {
                Authorization: 'Bearer ' + token,
                'Access-Control-Allow-Origin': '*',
                'Content-Type': 'application/json',
                Accept: '*/*'
              }
            };
            if (requestBody !== null && requestBody !== void 0 && requestBody.length) {
              if (isValidJson(requestBody)) {
                options.body = requestBody;
              } else {
                setRequestBodyError("ERROR: Request Body is not valid JSON!");
                errored = true;
              }
            }
            if (errored) {
              _context.n = 2;
              break;
            }
            _context.n = 1;
            return fetch(url, options)["catch"](function (err) {
              console.error();
              setResponseBody({
                "ERROR": "Error sending request to Twinit!"
              });
            });
          case 1:
            resp = _context.v;
            console.log(resp);
            setResponseStatus(resp.status + " " + resp.statusText);
            setResponseOK(resp.ok);
            resp.json().then(function (jsonResp) {
              var respString = JSON.stringify(jsonResp, null, 3);
              setResponseBody(respString);
            })["catch"](function (err) {
              setResponseBody({
                "ERROR": "Error parsing response JSON!"
              });
            })["finally"](function () {
              setFetching(false);
            });
            _context.n = 3;
            break;
          case 2:
            setFetching(false);
          case 3:
            return _context.a(2);
        }
      }, _callee);
    }));
    return function doFetch() {
      return _ref2.apply(this, arguments);
    };
  }();
  var tryMeStyles = {
    padding: '0px',
    fontSize: 'unset'
  };
  return /*#__PURE__*/React.createElement("li", {
    className: "omapi-card"
  }, /*#__PURE__*/React.createElement("div", {
    className: "card-row1"
  }, /*#__PURE__*/React.createElement("div", {
    onClick: toggle,
    className: "partial-path"
  }, expanded && /*#__PURE__*/React.createElement("i", {
    className: "fas fa-caret-down"
  }), !expanded && /*#__PURE__*/React.createElement("i", {
    className: "fas fa-caret-right"
  }), /*#__PURE__*/React.createElement("span", {
    className: "method"
  }, path.method), /*#__PURE__*/React.createElement("span", {
    className: "path"
  }, path.path)), /*#__PURE__*/React.createElement("div", {
    className: "full-path-wrapper"
  }, /*#__PURE__*/React.createElement("span", {
    className: "full-path"
  }, rootUrl + path.path))), /*#__PURE__*/React.createElement("div", {
    className: "card-row2"
  }, /*#__PURE__*/React.createElement("div", null, (_path$docs = path.docs) !== null && _path$docs !== void 0 && _path$docs.Summary ? path.docs.Summary : ''), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(GenericButton, {
    text: "Try Me",
    styles: tryMeStyles,
    onClick: tryMe
  }))), expanded && /*#__PURE__*/React.createElement("div", {
    className: "card-row3"
  }, /*#__PURE__*/React.createElement("div", {
    className: "path-config-items"
  }, /*#__PURE__*/React.createElement("div", {
    className: "even-row-space"
  }, pathVars && /*#__PURE__*/React.createElement("div", {
    className: clsx({
      'config-card': true,
      'config-card-full': !queryParams,
      'config-card-half': queryParams
    })
  }, /*#__PURE__*/React.createElement("div", {
    className: "config-card-title"
  }, "Path Variables"), /*#__PURE__*/React.createElement("hr", null), /*#__PURE__*/React.createElement(OMAPICardError, {
    error: pathVarError
  }), /*#__PURE__*/React.createElement("div", null, Object.keys(pathVars).map(function (k) {
    return /*#__PURE__*/React.createElement("div", {
      key: k
    }, /*#__PURE__*/React.createElement("div", {
      className: "config-card-val"
    }, /*#__PURE__*/React.createElement("div", {
      className: "val-name"
    }, k), /*#__PURE__*/React.createElement("div", {
      className: "val-container"
    }, /*#__PURE__*/React.createElement("input", {
      className: "val-value",
      type: getInputType(pathVars, k),
      defaultValue: pathVars.hasOwnProperty(k) ? pathVars[k] : '',
      onInput: function onInput(e) {
        return updateState(pathVars, k, e.target.value, setPathVars);
      }
    }), /*#__PURE__*/React.createElement("div", {
      className: "config-card-desc"
    }, _.get(path.docs['Path Variables'], k)))));
  }))), queryParams && /*#__PURE__*/React.createElement("div", {
    className: clsx({
      'config-card': true,
      'config-card-full': !pathVars,
      'config-card-half': pathVars
    })
  }, /*#__PURE__*/React.createElement("div", {
    className: "config-card-title"
  }, "Query Parameters"), /*#__PURE__*/React.createElement("hr", null), /*#__PURE__*/React.createElement("div", null, Object.keys(queryParams).map(function (k) {
    return /*#__PURE__*/React.createElement("div", {
      key: k
    }, /*#__PURE__*/React.createElement("div", {
      className: "config-card-val"
    }, /*#__PURE__*/React.createElement("div", {
      className: "val-name"
    }, k + ' ='), /*#__PURE__*/React.createElement("div", {
      className: "val-container"
    }, /*#__PURE__*/React.createElement("input", {
      className: "val-value",
      type: getInputType(queryParams, k),
      defaultValue: queryParams.hasOwnProperty(k) ? queryParams[k] : '',
      onInput: function onInput(e) {
        return updateState(queryParams, k, e.target.value, setQueryParams);
      }
    }), /*#__PURE__*/React.createElement("div", {
      className: "config-card-desc"
    }, _.get(path.docs['Request Query Params'], k)))));
  })))), /*#__PURE__*/React.createElement("div", {
    className: "even-row-space"
  }, path.docs && path.docs['Request Body'] && /*#__PURE__*/React.createElement("div", {
    className: clsx({
      'config-card': true,
      'config-card-half': true
    })
  }, /*#__PURE__*/React.createElement("div", {
    className: "config-card-title"
  }, "Request Body"), /*#__PURE__*/React.createElement(OMAPICardError, {
    error: requestBodyError
  }), /*#__PURE__*/React.createElement("hr", null), /*#__PURE__*/React.createElement("div", null, Object.keys(_flattenObject(path.docs['Request Body'])).map(function (k) {
    return /*#__PURE__*/React.createElement("div", {
      key: k
    }, /*#__PURE__*/React.createElement("div", {
      className: "config-card-val"
    }, /*#__PURE__*/React.createElement("div", {
      className: "val-name"
    }, k), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", {
      className: "config-card-desc"
    }, _.get(path.docs['Request Body'], k)))));
  })), /*#__PURE__*/React.createElement("hr", null), /*#__PURE__*/React.createElement("div", {
    className: "config-body"
  }, /*#__PURE__*/React.createElement(JSONEditor, {
    jsonValue: requestBody,
    readonly: false,
    onChange: onReqBodyChange
  }))), /*#__PURE__*/React.createElement("div", {
    className: clsx({
      'config-card': true,
      'config-card-full': !requestBody,
      'config-card-half': requestBody
    })
  }, /*#__PURE__*/React.createElement("div", {
    className: "config-card-title"
  }, "Response Body"), /*#__PURE__*/React.createElement("hr", null), path.docs && path.docs['Response Body'] && /*#__PURE__*/React.createElement("div", null, Object.keys(_flattenObject(path.docs['Response Body'])).map(function (k) {
    return /*#__PURE__*/React.createElement("div", {
      key: k
    }, /*#__PURE__*/React.createElement("div", {
      className: "config-card-val"
    }, /*#__PURE__*/React.createElement("div", {
      className: "val-name"
    }, k), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", {
      className: "config-card-desc"
    }, _.get(path.docs['Response Body'], k)))));
  })), /*#__PURE__*/React.createElement("hr", null), /*#__PURE__*/React.createElement("div", {
    className: "config-body"
  }, fetching && /*#__PURE__*/React.createElement("div", {
    className: "resp resp-ok fetching"
  }, /*#__PURE__*/React.createElement("i", {
    className: "fas fa-spinner fa-spin"
  }), " fetching..."), responseStatus && /*#__PURE__*/React.createElement("div", {
    className: clsx({
      'resp': true,
      'resp-ok': responseOK,
      'resp-error': !responseOK
    })
  }, "Status: ", responseStatus), /*#__PURE__*/React.createElement(JSONEditor, {
    jsonValue: responseBody
  })))))));
};

var css_248z$i = ".omapi-page {\n  padding: 20px 50px 20px 50px;\n}\n.omapi-page .page-header {\n  padding-bottom: 10px;\n}\n.omapi-page .page-header h1 {\n  color: var(--app-accent-color);\n}\n.omapi-page .error-msg {\n  font-size: large;\n  color: red;\n}\n.omapi-page .path-header {\n  cursor: pointer;\n}\n.omapi-page .path-header h2 {\n  display: inline-flex;\n  margin-left: 10px;\n  min-width: 15%;\n}\n.omapi-page .path-header .missing-options {\n  color: red;\n  display: inline-flex;\n  align-items: center;\n}\n.omapi-page .root-info .root-label {\n  font-weight: bold;\n  font-size: larger;\n}\n.omapi-page .root-info .root-url {\n  margin-left: 10px;\n  font-size: larger;\n  -webkit-user-select: all;\n  -moz-user-select: all;\n  -ms-user-select: all;\n  user-select: all;\n}";
styleInject(css_248z$i);

var OMAPIView = function OMAPIView(_ref) {
  var onLoadComplete = _ref.onLoadComplete,
    selectedItems = _ref.selectedItems,
    token = _ref.token;
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    ready = _useState2[0],
    setReady = _useState2[1];
  var _useState3 = useState(null),
    _useState4 = _slicedToArray(_useState3, 2),
    apiConfig = _useState4[0],
    setApiConfig = _useState4[1];
  var _useState5 = useState(''),
    _useState6 = _slicedToArray(_useState5, 2),
    rootUrl = _useState6[0],
    setRootUrl = _useState6[1];
  var _useState7 = useState(null),
    _useState8 = _slicedToArray(_useState7, 2),
    error = _useState8[0],
    setError = _useState8[1];
  var _useState9 = useState(null),
    _useState0 = _slicedToArray(_useState9, 2),
    expanded = _useState0[0],
    setExpanded = _useState0[1];
  useEffect(function () {
    function fetchApiConfig() {
      return _fetchApiConfig.apply(this, arguments);
    }
    function _fetchApiConfig() {
      _fetchApiConfig = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
        var configs, _apiConfig, resources, _expanded;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              _context.n = 1;
              return IafItemSvc.getAllNamedUserItems({
                query: {
                  _userType: "api_config"
                }
              });
            case 1:
              configs = _context.v;
              if (!configs || !configs.length) {
                setError("Project Configuration Error: No Object Model API config found!");
              } else if (configs.length > 2) {
                setError("Project Configuration Error: More than one Object Model API config found!");
              } else {
                try {
                  _apiConfig = JSON.parse(configs[0]._versions[0]._userData);
                  if (!_apiConfig) {
                    setError("Object Model API Configuration Error: Error parsing Object Model API config!");
                  } else {
                    setApiConfig(_apiConfig[0]);
                    resources = Object.keys(_apiConfig[0].endpoints);
                    _expanded = {};
                    resources.forEach(function (r) {
                      return _expanded[r] = false;
                    });
                    setExpanded(_expanded);
                  }
                } catch (err) {
                  setError("Object Model API Configuration Error: Error parsing Object Model API config!");
                }
              }
              setReady(true);
              onLoadComplete(true);
            case 2:
              return _context.a(2);
          }
        }, _callee);
      }));
      return _fetchApiConfig.apply(this, arguments);
    }
    setRootUrl(endPointConfig.itemServiceOrigin + '/omapi/' + selectedItems.selectedProject._namespaces[0]);
    fetchApiConfig();
  }, []);
  var toggleExpand = function toggleExpand(resource) {
    var currentExpand = Object.assign({}, expanded);
    currentExpand[resource] = !expanded[resource];
    setExpanded(currentExpand);
  };
  var hasOptionsMethod = function hasOptionsMethod(resource) {
    var optionsPath = apiConfig.endpoints[resource].paths.filter(function (p) {
      return p.method === 'OPTIONS';
    });
    return optionsPath && optionsPath.length === 1;
  };
  return /*#__PURE__*/React.createElement("div", null, ready && /*#__PURE__*/React.createElement("div", {
    className: "omapi-page"
  }, /*#__PURE__*/React.createElement("div", {
    className: "page-header"
  }, /*#__PURE__*/React.createElement("h1", null, "Object Model API Documentation")), error && /*#__PURE__*/React.createElement("div", {
    className: "error-msg"
  }, /*#__PURE__*/React.createElement("i", {
    "class": "fas fa-exclamation-circle"
  }), error), /*#__PURE__*/React.createElement("hr", null), /*#__PURE__*/React.createElement("div", {
    className: "root-info"
  }, /*#__PURE__*/React.createElement("i", {
    className: "fas fa-map-marker-alt fa-2x"
  }), /*#__PURE__*/React.createElement("span", {
    className: "root-label"
  }, "Root url:"), /*#__PURE__*/React.createElement("span", {
    className: "root-url"
  }, rootUrl)), /*#__PURE__*/React.createElement("div", null, apiConfig && apiConfig.endpoints && Object.keys(apiConfig.endpoints).map(function (e) {
    return /*#__PURE__*/React.createElement("div", {
      key: e
    }, /*#__PURE__*/React.createElement("hr", null), /*#__PURE__*/React.createElement("div", {
      className: "path-header",
      onClick: function onClick() {
        return toggleExpand(e);
      }
    }, expanded[e] && /*#__PURE__*/React.createElement("i", {
      className: "fas fa-caret-down fa-2x"
    }), !expanded[e] && /*#__PURE__*/React.createElement("i", {
      className: "fas fa-caret-right fa-2x"
    }), /*#__PURE__*/React.createElement("h2", null, e), !hasOptionsMethod(e) && /*#__PURE__*/React.createElement("span", {
      className: "missing-options"
    }, /*#__PURE__*/React.createElement("i", {
      "class": "fas fa-exclamation-circle fa-2x"
    }), " Resource is missing OPTIONS path!")), expanded[e] && /*#__PURE__*/React.createElement("ul", null, apiConfig.endpoints[e].paths.filter(function (p) {
      return p.method !== 'OPTIONS';
    }).sort().map(function (p) {
      return /*#__PURE__*/React.createElement(OMAPICard, {
        key: p.path + '-' + p.method,
        path: p,
        rootUrl: rootUrl,
        token: token
      });
    })));
  }))));
};

//import {withRouter} from "react-router-dom";

var EmptyComponent = function EmptyComponent(props) {
  useEffect(function () {
    props.isLoading && props.onLoadComplete && props.onLoadComplete();
  });
  console.log("EmptyComponent", props);
  return /*#__PURE__*/React.createElement(React.Fragment, null);
};

var InternalPages = {
  'entities/EntityView': EntityView$1,
  'dashboards/DashboardView': DashboardView$1,
  'files/UploadFilesWizard': UploadFilesWizard$1,
  'solutionMgmt/ScriptRunnerView': ScriptRunnerView,
  'DownloadsView': DownloadsView,
  'users/UserGroupView': UserGroupView,
  'datasources/DatasourcesView': DatasourcesView,
  'omapi/OMAPIView': OMAPIView,
  'mock/EmptyComponent': EmptyComponent
};

var useAuth = IafAuth.useAuth;
var withAuthHoc = function withAuthHoc(WrapperComponent) {
  return function (props) {
    var _useAuth = useAuth(),
      authService = _useAuth.authService,
      authTokens = _useAuth.authTokens;
    return /*#__PURE__*/React.createElement(WrapperComponent, _extends({}, props, {
      authService: authService,
      authTokens: authTokens
    }));
  };
};

var AppProvider = /*#__PURE__*/function (_React$Component) {
  function AppProvider(props) {
    var _endPointConfig, _this$props$ipaConfig;
    var _this;
    _classCallCheck(this, AppProvider);
    _this = _callSuper(this, AppProvider, [props]);
    _this.getPageArray = function () {
      return window.location.href.split('?')[0].split('/');
    };
    IafSession.setConfig(endPointConfig);

    //this is a workaround for a platform issue
    //platform needs the url to have a forward slash prior to the ? for query params
    //so if the baseroot does nto already have one we add it here
    var authRoot = endPointConfig ? endPointConfig.baseRoot : _this.props.ipaConfig.endPointConfig.baseRoot;
    if (authRoot.slice(-1) !== '/') authRoot = authRoot + '/';
    var appId = (_endPointConfig = endPointConfig) !== null && _endPointConfig !== void 0 && _endPointConfig.applicationId ? endPointConfig.applicationId : (_this$props$ipaConfig = _this.props.ipaConfig) === null || _this$props$ipaConfig === void 0 ? void 0 : _this$props$ipaConfig.applicationId;
    if (!appId) console.error('Application ID missing from endPointConfig or ipaConfig');
    _this.authUrl = IafSession.getAuthUrl(authRoot, appId);
    _this.isSigningOut = false;
    _this.defaultBottomPanelHeight = 350;
    _this.state = {
      isshowProjectPickerModal: false,
      userConfig: _this.props.initialConfig || EmptyConfig,
      user: undefined,
      token: undefined,
      isAuthorized: false,
      isLoading: true,
      isFetchingUser: false,
      loadingText: 'Loading..',
      showBottomPanel: false,
      viewerResizeCanvas: false,
      bottomPanelHeight: _this.defaultBottomPanelHeight,
      defaultBottomPanelHeight: _this.defaultBottomPanelHeight,
      maxBottomPanelHeight: window.innerHeight - 80,
      router: {
        pageList: [],
        pageRoutes: [],
        pageGroups: []
      },
      selectedItems: localStorage.ipadt_selectedItems ? JSON.parse(localStorage.ipadt_selectedItems) : {},
      actions: {
        reloadConfig: _this.initialize.bind(_this, false),
        restartApp: _this.initialize.bind(_this),
        setSelectedItems: _this.setSelectedItems.bind(_this),
        userLogout: _this.userLogout.bind(_this),
        closeBottomPanel: _this.closeBottomPanel.bind(_this),
        showBottomPanel: _this.showBottomPanel.bind(_this),
        toggleBottomPanel: _this.toggleBottomPanel.bind(_this),
        openBottomPanelMax: _this.openBottomPanelMax.bind(_this),
        getCurrentHandler: _this.getCurrentHandler.bind(_this),
        showModal: _this.showIpaModal.bind(_this),
        handlePageHandlerLoadError: _this.handlePageHandlerLoadError.bind(_this)
      }
    };
    _this.handleRequestError = _this.handleRequestError.bind(_this);
    _this.testConfig = _this.testConfig.bind(_this);
    _this.onConfigLoad = _this.onConfigLoad.bind(_this);
    _this.sisenseLogout = _this.sisenseLogout.bind(_this);
    return _this;
  }
  _inherits(AppProvider, _React$Component);
  return _createClass(AppProvider, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      IafSession.setErrorCallback(this.handleRequestError);
      this.initialize();
    }
  }, {
    key: "handleClick",
    value: function handleClick() {
      this.setState(function (prev) {
        return _objectSpread2(_objectSpread2({}, prev), {}, {
          isshowProjectPickerModal: true
        });
      });
    }
  }, {
    key: "sisenseLogout",
    value: function () {
      var _sisenseLogout = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
        var sisUrl, sisenselogout_url;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              sisUrl = sessionStorage.getItem('sisenseBaseUrl');
              if (sisUrl) {
                sisenselogout_url = sisUrl + "/api/auth/logout";
                fetch(sisenselogout_url, {
                  method: 'GET',
                  mode: 'cors',
                  cache: 'no-cache',
                  redirect: 'manual',
                  credentials: 'include'
                })["catch"](function (err) {
                  console.error("ERROR LOGGING OUT OF SISENSE: " + sisenselogout_url);
                  console.error(err);
                });
                delete sessionStorage.sisenseBaseUrl;
              }
            case 1:
              return _context.a(2);
          }
        }, _callee);
      }));
      function sisenseLogout() {
        return _sisenseLogout.apply(this, arguments);
      }
      return sisenseLogout;
    }()
  }, {
    key: "userLogout",
    value: function () {
      var _userLogout = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2() {
        var selectedItems, appId, _t;
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.p = _context2.n) {
            case 0:
              console.log('logging out user');
              _context2.p = 1;
              console.log('logging out user session');
              _context2.n = 2;
              return IafSession.logout();
            case 2:
              _context2.n = 4;
              break;
            case 3:
              _context2.p = 3;
              _t = _context2.v;
            case 4:
              console.log('sisense logout');
              this.sisenseLogout();
              console.log('localStorage before: ', localStorage);
              selectedItems = JSON.parse(localStorage.ipadt_selectedItems);
              appId = selectedItems.ipaConfig.applicationId;
              console.log('appId: ', appId);
              // delete cached config
              delete sessionStorage.ipadt_configData;
              delete localStorage.ipadt_selectedItems;
              delete localStorage.auth;
              delete localStorage[appId];
              console.log('localStorage after: ', localStorage);
              window.location = this.authUrl;
            case 5:
              return _context2.a(2);
          }
        }, _callee2, this, [[1, 3]]);
      }));
      function userLogout() {
        return _userLogout.apply(this, arguments);
      }
      return userLogout;
    }()
  }, {
    key: "closeBottomPanel",
    value: function closeBottomPanel() {
      var _this2 = this;
      var modelPopupContainerStyle = document.querySelector('div.asf-modal.threeDModelPopup').style;
      var opacityValue = 1;
      var intervalObj = setInterval(function () {
        if (opacityValue != 0) {
          opacityValue = (opacityValue - 0.1).toFixed(2);
          modelPopupContainerStyle.opacity = opacityValue;
        } else {
          clearInterval(intervalObj);
        }
      }, 50);
      setTimeout(function () {
        _this2.setState({
          show3DModelPopUp: false
        });
        modelPopupContainerStyle.opacity = 1;
      }, 600);
    }
  }, {
    key: "showBottomPanel",
    value: function showBottomPanel() {
      this.context.ifefSnapper.open('bottom');
      document.getElementById('BottomPanel').style.display = 'block';
    }
  }, {
    key: "openBottomPanelMax",
    value: function openBottomPanelMax() {
      this.context.ifefSnapper.open('bottom');
      var viewer = document.getElementById('BottomPanel');
      viewer.style.display = 'block';
      viewer.style.height = window.innerHeight - 80;
      this.setState({
        viewerResizeCanvas: true
      });
      var toolbar = document.getElementsByClassName('model-viewer-toolbar');
      toolbar[0].style.display = 'none';
    }
  }, {
    key: "toggleBottomPanel",
    value: function toggleBottomPanel() {
      // the following should probably be in ifefSnaper.toggle?
      var body = document.querySelector('body');
      var wasOpen = body.classList.contains('snapjs-bottom');
      // end

      document.getElementById('BottomPanel').style.display = wasOpen ? 'none' : 'block';
      document.getElementById('BottomPanel').style.height = this.defaultBottomPanelHeight;
      this.context.ifefSnapper.toggle('bottom');

      // the following should probably be in ifefSnaper.toggle?
      if (wasOpen) {
        body.classList.remove('snapjs-bottom');
        this.setState({
          viewerResizeCanvas: false
        });
      }

      // end

      //make sure we always shwo the toolbar in case open3DModelPopupMax above hide it
      var toolbar = document.getElementsByClassName('model-viewer-toolbar');
      toolbar[0].style.display = 'block';
    }
  }, {
    key: "setSelectedItems",
    value: function setSelectedItems(newItems) {
      var selectedItems = this.state.selectedItems;
      //save items to session
      var newSelecteds = Object.assign(selectedItems, newItems);
      localStorage.ipadt_selectedItems = JSON.stringify(newSelecteds);
      this.setState({
        selectedItems: newSelecteds
      });
    }
  }, {
    key: "getCurrentHandler",
    value: function getCurrentHandler() {
      var config = this.state.userConfig;
      var _pageArray = this.getPageArray();
      //location will be:  pathPrefix ? (pathPrefix + handler.path) : (handler.path || '/' + handlerName)
      //where handlerName comes from page.handler - but it will not be used it handler.path is specified
      var page = _pageArray.pop();
      if (page === "") page = _pageArray.pop();
      var pageNames = config.pages ? Object.keys(config.pages) : Object.keys(config.groupedPages);
      var pagesConfig = config.pages || config.groupedPages;
      var pagesHavePositions = pagesConfig[pageNames[0]].position;
      if (page.endsWith('#') && config.homepage && config.homepage.handler) {
        return config.handlers[config.homepage.handler];
      } else if (page.endsWith('#')) {
        if (!pagesHavePositions) return config.handlers[actualPage(config, pageNames[0]).handler];else {
          var lowestPos = pagesConfig[pageNames[0]].position;
          var lowestHandler = actualPage(config, pageNames[0]).handler;
          pageNames.forEach(function (pn) {
            if (pagesConfig[pn].position < lowestPos) {
              lowestPos = pagesConfig[pn].position;
              lowestHandler = actualPage(config, pn).handler;
            }
          });
          return config.handlers[lowestHandler];
        }
      }

      /*
       * Removed this code because I wasn't sure why try to go through the pages first to get the handler
       * instead of just goign straight to the handlers like we do below. Plus I think this commented code
       * relies on the name of the handler matchign the path of the handler, which is nto always guaranteed
       * to be true - scott mollon 12/4/2020
       * DOMI SEPT 2022 - keep this code and activate as it is useful for MemoryRouter and other routers that do not produce HashRouter hrefs
       */
      //look for handler in page list
      // const pageGroup = config.groupedPages ? Object.entries(config.groupedPages).find(p => p[1].pages.some(e => e[page] !== undefined)) : undefined;
      // if (config.pages && config.pages[page] || pageGroup){
      //   handler = config.pages ? config.handlers[config.pages[page].handler] : config.handlers[pageGroup.pages[page].handler] ;
      // }

      //if the handler is not found in the page list
      //look for it in the list of handlers
      //this might be necessary for pages that appear in action handlers
      //but not the page list
      {
        var requestPathAsArray = this.getPageArray();
        var lastButOnePathElement = requestPathAsArray[requestPathAsArray.length - 2]; //For detail components where the last element is the pathParam
        var allHandlers = Object.values(config.handlers);
        return allHandlers.find(function (h) {
          return h.path === "/".concat(page) || h.path === "/".concat(lastButOnePathElement);
        });
      }
    }
  }, {
    key: "handlePageHandlerLoadError",
    value: function handlePageHandlerLoadError(error) {
      throw error;
    }

    // Updated handleRequestError with a condition if authType is pkce then using refresh token generate a new access token
  }, {
    key: "handleRequestError",
    value: function () {
      var _handleRequestError = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3(error) {
        var requiredAuthenticationErrorMessage, tokens, refreshToken, updatedToken, user;
        return _regenerator().w(function (_context3) {
          while (1) switch (_context3.n) {
            case 0:
              console.error(error);
              requiredAuthenticationErrorMessage = "401: Full authentication is required to access this resource";
              if (!(_.get(error, 'errorResult.status') === 401)) {
                _context3.n = 6;
                break;
              }
              if (this.isSigningOut) {
                _context3.n = 6;
                break;
              }
              this.isSigningOut = true;
              if (!(endPointConfig.authType === 'implicit')) {
                _context3.n = 1;
                break;
              }
              //If authType is implicit it user will logout
              this.state.actions.userLogout();
              _context3.n = 6;
              break;
            case 1:
              if (!(endPointConfig.authType === 'pkce')) {
                _context3.n = 6;
                break;
              }
              if (!(error.message == requiredAuthenticationErrorMessage)) {
                _context3.n = 2;
                break;
              }
              this.state.actions.userLogout();
              return _context3.a(2);
            case 2:
              _context3.n = 3;
              return this.props.authService.getAuthTokens();
            case 3:
              tokens = _context3.v;
              refreshToken = tokens && Object.keys(tokens).length > 0 ? tokens.refresh_token : '';
              if (!refreshToken) {
                _context3.n = 6;
                break;
              }
              _context3.n = 4;
              return this.props.authService.fetchToken(refreshToken, true);
            case 4:
              updatedToken = _context3.v;
              //Fetch new token using refresh token
              console.log("updatedToken", updatedToken);
              if (!updatedToken) {
                _context3.n = 6;
                break;
              }
              _context3.n = 5;
              return IafSession.setAuthToken(updatedToken.access_token, undefined);
            case 5:
              user = _context3.v;
              //Updated token in session storage
              this.setState({
                token: updatedToken.access_token
              }); //Set updated token 
            case 6:
              return _context3.a(2);
          }
        }, _callee3, this);
      }));
      function handleRequestError(_x) {
        return _handleRequestError.apply(this, arguments);
      }
      return handleRequestError;
    }()
  }, {
    key: "initialize",
    value: function () {
      var _initialize = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4() {
        var _this3 = this;
        var loadConfigFromCache,
          showProjectPicker,
          self,
          sessionManage,
          token,
          user,
          inviteId,
          parsed,
          temp_token,
          authTokens,
          _temp_token,
          _this$props,
          scriptPlugins,
          _iterator,
          _step,
          sliceFile,
          sliceModule,
          slice,
          newReducer,
          dashComponents,
          _iterator2,
          _step2,
          dashCompFile,
          dashCompModule,
          dashComp,
          entityActionComponents,
          _iterator3,
          _step3,
          actionCompFile,
          actCompModule,
          actComp,
          entityDataComponents,
          _iterator4,
          _step4,
          dataCompFile,
          dataComp,
          dataCompFactory,
          jsonData,
          callback,
          projects,
          userInStorage,
          _iterator5,
          _step5,
          styleSheet,
          customCss,
          _args4 = arguments,
          _t2,
          _t3,
          _t4,
          _t5,
          _t6,
          _t7,
          _t8,
          _t9,
          _t0,
          _t1,
          _t10,
          _t11;
        return _regenerator().w(function (_context4) {
          while (1) switch (_context4.p = _context4.n) {
            case 0:
              loadConfigFromCache = _args4.length > 0 && _args4[0] !== undefined ? _args4[0] : true;
              showProjectPicker = _args4.length > 1 && _args4[1] !== undefined ? _args4[1] : true;
              self = this;
              sessionManage = sessionStorage.manage;
              sessionManage = this.props.authService.getAuthTokens(); //Storing token in session
              if (sessionManage && Object.keys(sessionManage).length === 0) {
                sessionManage = undefined;
              }
              if (!this.props.authService.isPending()) {
                _context4.n = 1;
                break;
              }
              return _context4.a(2);
            case 1:
              store.dispatch({
                type: "PROJECT_SWITCHED"
              });
              //console.log(store.getState())

              //check for invites. If so - redirect to signup
              if (!window.location.search) {
                _context4.n = 3;
                break;
              }
              parsed = parseQuery(window.location.search);
              if (!parsed.hasOwnProperty('inviteId')) {
                _context4.n = 2;
                break;
              }
              inviteId = parsed.inviteId;
              _context4.n = 3;
              break;
            case 2:
              if (!parsed.hasOwnProperty('code')) {
                _context4.n = 3;
                break;
              }
              _context4.n = 3;
              return this.props.authService.initialize();
            case 3:
              if (!window.location.hash) {
                _context4.n = 76;
                break;
              }
              temp_token = IafSession.extractToken(window.location.hash);
              if (!temp_token) {
                _context4.n = 7;
                break;
              }
              _context4.p = 4;
              this.setState({
                isFetchingUser: true
              });
              console.log("before setSessionData 1, calling /users/me");
              _context4.n = 5;
              return IafSession.setSessionData(temp_token);
            case 5:
              user = _context4.v;
              console.log("after setSessionData 1", user);
              if (user !== undefined) {
                token = temp_token;
              }
            case 6:
              _context4.p = 6;
              this.setState({
                isFetchingUser: false
              });
              return _context4.f(6);
            case 7:
              authTokens = this.props.authService.getAuthTokens();
              if (authTokens && Object.keys(authTokens).length > 0) {
                sessionManage = _objectSpread2({}, authTokens);
              }

              // if we don't have a token yet and we have something in the session then
              // check that the token in the session is valid
              if (!(token === undefined && sessionManage && sessionManage !== undefined)) {
                _context4.n = 12;
                break;
              }
              _temp_token = sessionManage.access_token;
              console.log("before setSessionData 2, calling /users/me, temp_token", _temp_token);
              _context4.p = 8;
              this.setState({
                isFetchingUser: true
              });
              _context4.n = 9;
              return IafSession.setSessionData(_temp_token);
            case 9:
              user = _context4.v;
              console.log("after setSessionData 2, calling /users/me, user", user);
              if (user !== undefined) {
                token = _temp_token;
              }
              _context4.n = 11;
              break;
            case 10:
              _context4.p = 10;
              _t2 = _context4.v;
              token = _temp_token;
              console.log("Session token expired");
            case 11:
              _context4.p = 11;
              this.setState({
                isFetchingUser: false
              });
              return _context4.f(11);
            case 12:
              if (!(!token && !this.props.enableAxiosInterceptor)) {
                _context4.n = 13;
                break;
              }
              //go to login page
              this.props.authService.authorize(inviteId);
              _context4.n = 76;
              break;
            case 13:
              if (this.props.ipaConfig) self.setSelectedItems({
                ipaConfig: this.props.ipaConfig
              });

              /* load script plugins */

              /*
                We load all the exported functions from each file listed in ipaConfig.scriptPlugins.
                   Each script plugin file must be located in ./app/ipaCore/scriptPlugins
              */
              scriptPlugins = (_this$props = this.props) === null || _this$props === void 0 || (_this$props = _this$props.ipaConfig) === null || _this$props === void 0 ? void 0 : _this$props.scriptPlugins; // if (scriptPlugins) {
              //   scriptPlugins.forEach((filename) => {
              //     try {
              //       let funcs = require('../../../../app/ipaCore/scriptPlugins/' + filename)
              //       for (let fnName in funcs) {
              //         addScriptFunction(funcs[fnName])
              //       }
              //     } catch(e) {
              //       console.error(e)
              //       console.error('Script plugin not able to be loaded: ' + filename)
              //     }
              //   })
              // }
              /* load redux extended slices provided by the app */
              /*
               * Here we load the redux reducers (slices) provided by the local application
               * This is an additive, but replace, function. Meaning if the local application
               * adds a reducer with the same name as a framework reducer it will override the
               * framework reducer.
               *
               * We may want to protect against that?
               *
               * Reducer (slice) files must be located in ./app/ipaCore/redux
               */
              if (!(this.props.ipaConfig && this.props.ipaConfig.redux && this.props.ipaConfig.redux.slices && this.props.ipaConfig.redux.slices.length)) {
                _context4.n = 24;
                break;
              }
              _iterator = _createForOfIteratorHelper(this.props.ipaConfig.redux.slices);
              _context4.p = 14;
              _iterator.s();
            case 15:
              if ((_step = _iterator.n()).done) {
                _context4.n = 20;
                break;
              }
              sliceFile = _step.value;
              _context4.p = 16;
              _context4.n = 17;
              return import("../../../../app/ipaCore/redux/".concat(sliceFile.file));
            case 17:
              sliceModule = _context4.v;
              slice = sliceModule["default"];
              newReducer = addReducerSlice({
                name: sliceFile.name,
                slice: slice
              });
              store.replaceReducer(newReducer);
              _context4.n = 19;
              break;
            case 18:
              _context4.p = 18;
              _t3 = _context4.v;
              console.error(_t3);
              console.error('Slice not able to be loaded: ' + sliceFile.name);
            case 19:
              _context4.n = 15;
              break;
            case 20:
              _context4.n = 22;
              break;
            case 21:
              _context4.p = 21;
              _t4 = _context4.v;
              _iterator.e(_t4);
            case 22:
              _context4.p = 22;
              _iterator.f();
              return _context4.f(22);
            case 23:
              _context4.n = 25;
              break;
            case 24:
              console.warn("No ipa-core redux configuration found");
            case 25:
              if (!(this.props.ipaConfig && this.props.ipaConfig.components)) {
                _context4.n = 59;
                break;
              }
              if (!(this.props.ipaConfig.components.dashboard && this.props.ipaConfig.components.dashboard.length)) {
                _context4.n = 36;
                break;
              }
              dashComponents = [];
              _iterator2 = _createForOfIteratorHelper(this.props.ipaConfig.components.dashboard);
              _context4.p = 26;
              _iterator2.s();
            case 27:
              if ((_step2 = _iterator2.n()).done) {
                _context4.n = 32;
                break;
              }
              dashCompFile = _step2.value;
              _context4.p = 28;
              _context4.n = 29;
              return import("../../../../app/ipaCore/components/".concat(dashCompFile.file));
            case 29:
              dashCompModule = _context4.v;
              dashComp = dashCompModule["default"];
              dashComponents.push({
                name: dashCompFile.name,
                component: dashComp
              });
              _context4.n = 31;
              break;
            case 30:
              _context4.p = 30;
              _t5 = _context4.v;
              console.error(_t5);
              console.error('Dashboard component not able to be loaded: ' + dashCompFile.name);
            case 31:
              _context4.n = 27;
              break;
            case 32:
              _context4.n = 34;
              break;
            case 33:
              _context4.p = 33;
              _t6 = _context4.v;
              _iterator2.e(_t6);
            case 34:
              _context4.p = 34;
              _iterator2.f();
              return _context4.f(34);
            case 35:
              if (dashComponents.length) store.dispatch(addDashboardComponents(dashComponents));
            case 36:
              if (!(this.props.ipaConfig.components.entityAction && this.props.ipaConfig.components.entityAction.length)) {
                _context4.n = 47;
                break;
              }
              entityActionComponents = [];
              _iterator3 = _createForOfIteratorHelper(this.props.ipaConfig.component.entityAction);
              _context4.p = 37;
              _iterator3.s();
            case 38:
              if ((_step3 = _iterator3.n()).done) {
                _context4.n = 43;
                break;
              }
              actionCompFile = _step3.value;
              _context4.p = 39;
              _context4.n = 40;
              return import("../../../../app/ipaCore/components/".concat(actionCompFile.file));
            case 40:
              actCompModule = _context4.v;
              actComp = actCompModule["".concat(actionCompFile.name, "Factory")];
              entityActionComponents.push({
                name: actionCompFile.name,
                component: actComp
              });
              _context4.n = 42;
              break;
            case 41:
              _context4.p = 41;
              _t7 = _context4.v;
              console.error(_t7);
              console.error('Entity Action component not able to be loaded: ' + actionCompFile.name);
            case 42:
              _context4.n = 38;
              break;
            case 43:
              _context4.n = 45;
              break;
            case 44:
              _context4.p = 44;
              _t8 = _context4.v;
              _iterator3.e(_t8);
            case 45:
              _context4.p = 45;
              _iterator3.f();
              return _context4.f(45);
            case 46:
              if (entityActionComponents.length) store.dispatch(addEntityComponents('action', entityActionComponents));
            case 47:
              if (!(this.props.ipaConfig.components.entityData && this.props.ipaConfig.components.entityData.length)) {
                _context4.n = 58;
                break;
              }
              entityDataComponents = [];
              _iterator4 = _createForOfIteratorHelper(this.props.ipaConfig.components.entityData);
              _context4.p = 48;
              _iterator4.s();
            case 49:
              if ((_step4 = _iterator4.n()).done) {
                _context4.n = 54;
                break;
              }
              dataCompFile = _step4.value;
              _context4.p = 50;
              _context4.n = 51;
              return import("../../../../app/ipaCore/components/".concat(dataCompFile.file));
            case 51:
              dataComp = _context4.v;
              dataCompFactory = dataComp[dataCompFile.name + 'Factory'];
              entityDataComponents.push({
                name: dataCompFile.name,
                component: dataCompFactory
              });
              _context4.n = 53;
              break;
            case 52:
              _context4.p = 52;
              _t9 = _context4.v;
              console.error(_t9);
              console.error('Entity Action component not able to be loaded: ' + dataCompFile.name);
            case 53:
              _context4.n = 49;
              break;
            case 54:
              _context4.n = 56;
              break;
            case 55:
              _context4.p = 55;
              _t0 = _context4.v;
              _iterator4.e(_t0);
            case 56:
              _context4.p = 56;
              _iterator4.f();
              return _context4.f(56);
            case 57:
              if (entityDataComponents.length) store.dispatch(addEntityComponents('data', entityDataComponents));
            case 58:
              _context4.n = 60;
              break;
            case 59:
              console.warn("No ipa-core component configuration found");
            case 60:
              if (!(loadConfigFromCache && sessionStorage.ipadt_configData)) {
                _context4.n = 61;
                break;
              }
              jsonData = JSON.parse(sessionStorage.ipadt_configData);
              this.onConfigLoad(jsonData, this.testConfig(jsonData), token, user);
              _context4.n = 66;
              break;
            case 61:
              if (!this.state.isFetchingUser) {
                _context4.n = 62;
                break;
              }
              return _context4.a(2);
            case 62:
              callback = function callback(config, routes) {
                return _this3.onConfigLoad(config, routes, token, user);
              };
              _context4.p = 63;
              _context4.n = 64;
              return IafProj.getProjects({
                _pageSize: 1000
              });
            case 64:
              projects = _context4.v;
              userInStorage = sessionStorage.getItem('sessionUser');
              console.log('AppProvider: init: after feching projects: ', projects, 'showProjectPicker: ', showProjectPicker, userInStorage);
              if (showProjectPicker && (userInStorage && userInStorage !== 'undefined' || token)) {
                self.context.ifefShowModal(/*#__PURE__*/React.createElement(ProjectPickerModal, {
                  configUserType: this.props.ipaConfig.configUserType,
                  referenceAppConfig: this.props.ipaConfig.referenceAppConfig,
                  appContextProps: this.state,
                  defaultConfig: EmptyConfig,
                  onAcceptInvite: this.state.actions.restartApp,
                  projects: projects,
                  testConfig: self.testConfig,
                  userLogout: this.state.actions.userLogout,
                  onConfigLoad: callback,
                  onCancel: function onCancel() {
                    return self.context.ifefShowModal(false);
                  },
                  referenceAppCreateProject: function referenceAppCreateProject() {
                    return self.context.ifefShowModal(/*#__PURE__*/React.createElement(SetUpProject, {
                      allowMultipleProjects: _this3.props.ipaConfig.referenceAppConfig.allowMultipleProjects,
                      restartApp: _this3.state.actions.restartApp,
                      projects: projects,
                      onCancel: function onCancel() {
                        _this3.setState(function (prev) {
                          return _objectSpread2(_objectSpread2({}, prev), {}, {
                            isshowProjectPickerModal: true
                          });
                        });
                      }
                    }));
                  }
                }));
              }
              _context4.n = 66;
              break;
            case 65:
              _context4.p = 65;
              _t1 = _context4.v;
              console.log(_t1);
              callback(EmptyConfig, self.testConfig(EmptyConfig));
            case 66:
              if (!(this.props.ipaConfig && Array.isArray(_.get(this.props.ipaConfig, 'css')))) {
                _context4.n = 76;
                break;
              }
              _iterator5 = _createForOfIteratorHelper(this.props.ipaConfig.css);
              _context4.p = 67;
              _iterator5.s();
            case 68:
              if ((_step5 = _iterator5.n()).done) {
                _context4.n = 73;
                break;
              }
              styleSheet = _step5.value;
              _context4.p = 69;
              _context4.n = 70;
              return import("../../../../app/ipaCore/css/".concat(styleSheet));
            case 70:
              customCss = _context4.v;
              _context4.n = 72;
              break;
            case 71:
              _context4.p = 71;
              _t10 = _context4.v;
            case 72:
              _context4.n = 68;
              break;
            case 73:
              _context4.n = 75;
              break;
            case 74:
              _context4.p = 74;
              _t11 = _context4.v;
              _iterator5.e(_t11);
            case 75:
              _context4.p = 75;
              _iterator5.f();
              return _context4.f(75);
            case 76:
              return _context4.a(2);
          }
        }, _callee4, this, [[69, 71], [67, 74, 75, 76], [63, 65], [50, 52], [48, 55, 56, 57], [39, 41], [37, 44, 45, 46], [28, 30], [26, 33, 34, 35], [16, 18], [14, 21, 22, 23], [8, 10, 11, 12], [4,, 6, 7]]);
      }));
      function initialize() {
        return _initialize.apply(this, arguments);
      }
      return initialize;
    }()
  }, {
    key: "testConfig",
    value: function () {
      var _testConfig = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee5(config) {
        return _regenerator().w(function (_context5) {
          while (1) switch (_context5.n) {
            case 0:
              _context5.n = 1;
              return calculateRoutes(config, this.props.ipaConfig);
            case 1:
              return _context5.a(2, _context5.v);
          }
        }, _callee5, this);
      }));
      function testConfig(_x2) {
        return _testConfig.apply(this, arguments);
      }
      return testConfig;
    }()
  }, {
    key: "showIpaModal",
    value: function showIpaModal(modalContent) {
      var self = this;
      self.context.ifefShowModal(modalContent);
    }
  }, {
    key: "onConfigLoad",
    value: function () {
      var _onConfigLoad = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee6(config, routes, token, user) {
        var hasSisenseConnectors, selectedProj, _config$settings, sisenseUrl, allOrchestrators, sisenseSSOOrch, orchId, params, orchResult, encodedToken, sisensejwt_url, loadThese, i, execThese, _i, rootStyles, r;
        return _regenerator().w(function (_context6) {
          while (1) switch (_context6.n) {
            case 0:
              hasSisenseConnectors = function _hasSisenseConnectors(config) {
                if (config.connectors) {
                  var sisenseConnector = _.find(config.connectors, {
                    name: "SisenseIframe"
                  }) || _.find(config.connectors, {
                    name: "SisenseConnect"
                  });
                  if (sisenseConnector) {
                    var sisUrl = sisenseConnector.config.url;
                    var lastChar = sisUrl.slice(-1);
                    if (lastChar === '/' || lastChar === '\\') sisUrl = sisUrl.slice(0, -1);
                    sessionStorage.setItem('sisenseBaseUrl', sisUrl);
                    return sisUrl;
                  } else return false;
                } else return false;
              };
              //console.log(config, routes)
              //console.log("APP PROVIDER WILL SET USER CONFIG",{...config});

              //clear routes immediately so that the UI removes the last project's routes
              this.setState({
                token: token,
                user: user,
                router: {
                  pageList: [],
                  pageRoutes: [],
                  pageGroups: []
                }
              });

              //ONE ROUTES ARE CLEARED, UPDATE CONFIG!
              this.setUserConfig(config);

              //DOMI: now we can safetly prepare new routes once userConfig is updated on state and in REDUX
              _context6.n = 1;
              return routes;
            case 1:
              routes = _context6.v;
              this.sisenseLogout();

              //Clear all script state in cache and in script engine
              ScriptCache.clearCache();
              // if(!ScriptHelper.isProjectNextGenJs()) {
              //   ScriptHelper.releaseExpressionExecCtx()
              //   ScriptHelper.initExpressionExecCtx()
              // } else {
              //   IafScriptEngine.clearVars()
              // }
              IafScriptEngine.clearVars();
              this.context.ifefShowModal(false);
              selectedProj = IafProj.getCurrent();
              if (!selectedProj) {
                _context6.n = 12;
                break;
              }
              /*
              * If Sisense Connectors are configured then we need to sign in to Sisense
              * This must be doen before any sisense content is needed
              */
              sisenseUrl = hasSisenseConnectors(config);
              if (!sisenseUrl) {
                _context6.n = 5;
                break;
              }
              _context6.n = 2;
              return IafDataSource.getOrchestrators();
            case 2:
              allOrchestrators = _context6.v;
              sisenseSSOOrch = _.find(allOrchestrators._list, {
                _userType: 'Sisense_SSO_JWT_Generator'
              });
              if (sisenseSSOOrch) {
                _context6.n = 3;
                break;
              }
              console.error('Sisense is configured in the project but the Sisense SSO Orchestrator is not present');
              _context6.n = 5;
              break;
            case 3:
              orchId = sisenseSSOOrch.id;
              params = {
                orchestratorId: orchId,
                _actualparams: [{
                  sequence_type_id: _.get(sisenseSSOOrch, "orchsteps.0._compid"),
                  params: {
                    userGroupId: this.state.selectedItems.selectedUserGroupId,
                    projectNamespace: this.state.selectedItems.selectedProject._namespaces[0]
                  }
                }]
              };
              _context6.n = 4;
              return IafDataSource.runOrchestrator(orchId, params);
            case 4:
              orchResult = _context6.v;
              encodedToken = _.get(orchResult, '_result.jwt');
              sisensejwt_url = sisenseUrl + "/jwt?jwt=" + encodedToken;
              fetch(sisensejwt_url, {
                method: 'GET',
                mode: 'cors',
                cache: 'no-cache',
                redirect: 'manual',
                credentials: 'include'
              })["catch"](function (err) {
                console.error("ERROR SIGNING IN TO SISENSE: " + sisensejwt_url);
                console.error(err);
              });
            case 5:
              if (!(!!config.onConfigLoad && !!config.onConfigLoad.load && config.onConfigLoad.load.length > 0)) {
                _context6.n = 8;
                break;
              }
              //load each script
              loadThese = config.onConfigLoad.load;
              i = 0;
            case 6:
              if (!(i < loadThese.length)) {
                _context6.n = 8;
                break;
              }
              _context6.n = 7;
              return ScriptHelper.loadScript({
                _userType: loadThese[i]
              });
            case 7:
              i++;
              _context6.n = 6;
              break;
            case 8:
              if (!(!!config.onConfigLoad && !!config.onConfigLoad.exec && config.onConfigLoad.exec.length > 0)) {
                _context6.n = 11;
                break;
              }
              //load each script
              execThese = config.onConfigLoad.exec;
              _i = 0;
            case 9:
              if (!(_i < execThese.length)) {
                _context6.n = 11;
                break;
              }
              _context6.n = 10;
              return ScriptHelper.executeScript(execThese[_i]);
            case 10:
              _i++;
              _context6.n = 9;
              break;
            case 11:
              //need to enable the router after we load all the scripts in the config
              //to make sure all pages have data loaded into the script engine beforehand
              if (routes) this.setState({
                router: {
                  pageList: routes.pageList,
                  pageRoutes: routes.pageRoutes,
                  pageGroups: routes.pageGroups
                }
              });
              this.setState({
                isLoading: false
              });

              // Eval the "autoeval" script for any bootstrap setup of app.
              if (config.scripts && config.scripts.autoeval) {
                if (!ScriptHelper.isProjectNextGenJs()) ScriptHelper.evalExpressions(config.scripts.autoeval);
              }
              rootStyles = ((_config$settings = config.settings) === null || _config$settings === void 0 ? void 0 : _config$settings.styles) || this.props.ipaConfig.styleVars || DefaultStyleVars; //Load all custom styles from userConfig
              if (rootStyles) {
                r = document.querySelector(':root');
                Object.entries(rootStyles).map(function (_ref) {
                  var _ref2 = _slicedToArray(_ref, 2),
                    key = _ref2[0],
                    value = _ref2[1];
                  r.style.setProperty(key, value);
                });
              }
              _context6.n = 13;
              break;
            case 12:
              //This is state where the user has an account but no accepted invites
              if (routes) this.setState({
                router: {
                  pageList: routes.pageList,
                  pageRoutes: routes.pageRoutes,
                  pageGroups: routes.pageGroups
                }
              });
              this.setState({
                isLoading: false
              });
            case 13:
              store.dispatch(addUser(user));
              if (this.props.onConfigLoad) this.props.onConfigLoad(store, config, this.state);
            case 14:
              return _context6.a(2);
          }
        }, _callee6, this);
      }));
      function onConfigLoad(_x3, _x4, _x5, _x6) {
        return _onConfigLoad.apply(this, arguments);
      }
      return onConfigLoad;
    }()
  }, {
    key: "setUserConfig",
    value: function setUserConfig(config) {
      store.dispatch(addUserConfig(config));
      this.setState({
        userConfig: config
      });
    }
  }, {
    key: "navigateToHomepage",
    value: function navigateToHomepage() {
      window.location.hash = '/'; //Since we're outside the react router scope, we need to deal with the location object directly
    }
  }, {
    key: "render",
    value: function render() {
      //console.log("APP PROVIDER RE-RENDERS");
      var context = _objectSpread2({}, this.state);
      return /*#__PURE__*/React.createElement(AppContext.Provider, {
        value: context
      }, this.props.children);
    }
  }]);
}(React.Component); // export const addScriptFunction = (fn) => {
//   let fnName = "$" + fn.name
//   let fnWrapper = {}
//   fnWrapper[fnName] = {
//     operate: (a,b,c) => fn(expression.operate(a,b,c))
//   }
//   console.log(`Added Script Operator: ${fnName} => ${fn.name}`)
//   expression.use(fnWrapper)
// }
function calculateRoutes(_x7, _x8) {
  return _calculateRoutes.apply(this, arguments);
}
function _calculateRoutes() {
  _calculateRoutes = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee9(config, ipaConfig) {
    var pList, pRoutes, pGroups, asIpaPage, getPageComponent, _getPageComponent, addRoute, _addRoute, buildRoute, addGroup, pages, pagesConfig, usingGroupedConfig, _iterator6, _step6, key, _iterator7, _step7, page, handler, _page, _handler, homePageHandler, HomePage, _t13, _t14;
    return _regenerator().w(function (_context9) {
      while (1) switch (_context9.p = _context9.n) {
        case 0:
          addGroup = function _addGroup(groupName, icon) {
            var group = {
              groupName: groupName,
              icon: icon || '',
              items: []
            };
            pGroups.push(group);
          };
          buildRoute = function _buildRoute(masterItem, masterComponent, detailItem, detailComponent) {
            return /*#__PURE__*/React.createElement(Route, {
              path: masterItem.path,
              key: masterItem.path,
              component: masterComponent,
              exact: masterItem.exact
            }, detailItem && detailComponent ? /*#__PURE__*/React.createElement(Route, {
              path: detailItem.path,
              key: detailItem.nestedPath,
              component: detailComponent,
              exact: detailItem.exact
            }) : null);
          };
          _addRoute = function _addRoute3() {
            _addRoute = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee8(handlerName, handler, addPage, pathPrefix, pageGroup) {
              var handlerPath, item, detailItem, detailComponent, detailComponentPath, component;
              return _regenerator().w(function (_context8) {
                while (1) switch (_context8.n) {
                  case 0:
                    if (handler.pageComponent) {
                      _context8.n = 1;
                      break;
                    }
                    console.error("This version of AppProvider only supports handlers with a pageComponent");
                    console.log("Skipping", handler);
                    return _context8.a(2);
                  case 1:
                    handlerPath = handler.path || '/' + handlerName;
                    item = {
                      path: pathPrefix ? pathPrefix + handlerPath : handlerPath,
                      title: handler.title || 'no title',
                      icon: handler.icon || '',
                      name: handlerName,
                      exact: true
                    };
                    detailItem = undefined;
                    detailComponent = undefined;
                    if (handler.detailPage) {
                      detailComponentPath = "".concat(item.path, "/").concat(handler.detailPage.pathParam);
                      detailItem = {
                        path: detailComponentPath,
                        nested: handler.detailPage.nested,
                        nestedPath: handler.detailPage.pathParam,
                        title: handler.detailPage.title || item.title,
                        icon: handler.detailPage || item.icon,
                        name: handlerName,
                        exact: item.exact
                      };
                      //if our route is nested, parent cannot be exact
                      if (handler.detailPage.nested) {
                        item.exact = false;
                      }
                    }
                    _context8.n = 2;
                    return getPageComponent(handler.pageComponent, {
                      masterPage: item,
                      detailPage: detailItem
                    });
                  case 2:
                    component = _context8.v;
                    if (component) {
                      _context8.n = 3;
                      break;
                    }
                    return _context8.a(2);
                  case 3:
                    if (!handler.detailPage) {
                      _context8.n = 5;
                      break;
                    }
                    _context8.n = 4;
                    return getPageComponent(handler.detailPage.component, {
                      masterPage: item
                    });
                  case 4:
                    detailComponent = _context8.v;
                    if (detailComponent) {
                      detailItem.nestedRoute = buildRoute(detailItem, detailComponent);
                    }
                  case 5:
                    if (handler.detailPage && handler.detailPage.nested) {
                      //nested routes will only work with react-roure v6 and <Outlet/>, this is why we render only master at the moment
                      //pRoutes.push(buildRoute(item,component,detailItem,detailComponent));
                      pRoutes.push(buildRoute(item, component));
                    } else if (handler.detailPage) {
                      pRoutes.push(buildRoute(item, component));
                      detailComponent && pRoutes.push(buildRoute(detailItem, detailComponent)); //we will use this route in master component
                    } else {
                      pRoutes.push(buildRoute(item, component));
                    }
                    if (addPage) {
                      pList.push(item);
                      if (pageGroup) {
                        pGroups.find(function (g) {
                          return g.groupName == pageGroup;
                        }).items.push(item);
                      }
                    }
                  case 6:
                    return _context8.a(2);
                }
              }, _callee8);
            }));
            return _addRoute.apply(this, arguments);
          };
          addRoute = function _addRoute2(_x1, _x10, _x11, _x12, _x13) {
            return _addRoute.apply(this, arguments);
          };
          _getPageComponent = function _getPageComponent3() {
            _getPageComponent = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee7(pageComponent, pageComponentProps) {
              var component, componentModule, _t12;
              return _regenerator().w(function (_context7) {
                while (1) switch (_context7.p = _context7.n) {
                  case 0:
                    _context7.p = 0;
                    _context7.n = 1;
                    return import("../../../../app/ipaCore/pageComponents/".concat(pageComponent, ".jsx"));
                  case 1:
                    componentModule = _context7.v;
                    component = componentModule["default"];
                    component = asIpaPage(component, pageComponentProps);
                    console.log(pageComponent + ' loaded from application');
                    _context7.n = 3;
                    break;
                  case 2:
                    _context7.p = 2;
                    _t12 = _context7.v;
                    component = InternalPages[pageComponent] ? InternalPages[pageComponent] : null;
                    if (component) {
                      component = asIpaPage(component, pageComponentProps);
                      console.log(pageComponent + ' loaded from framework');
                    } else {
                      console.error(_t12);
                      console.error("can't find page component: ", pageComponent);
                      console.log("Skipping", pageComponent);
                      component = null;
                    }
                  case 3:
                    return _context7.a(2, component);
                }
              }, _callee7, null, [[0, 2]]);
            }));
            return _getPageComponent.apply(this, arguments);
          };
          getPageComponent = function _getPageComponent2(_x9, _x0) {
            return _getPageComponent.apply(this, arguments);
          };
          asIpaPage = function _asIpaPage(rawPageComponent, optionalProps) {
            return withAppContext(withGenericPageErrorBoundary(withGenericPage(rawPageComponent, optionalProps)));
          };
          pList = [];
          pRoutes = [];
          pGroups = [];
          /*
           * Loads a pageComponent for the app. It will first try to load the pageComponent
           * from the local application. If the pageComponent is not found there it will
           * try to load the pageComponent from the framework. This allows the local
           * application to override a framework page component if it so chooses.
           *
           * If the pageComponent is not found an error is sent to the console and
           * the page is skipped.
           *
           * pageComponents must be in the ./app/ipaCore/pageComponents folder
           */
          pages = config.pages ? Object.keys(config.pages) : Object.keys(config.groupedPages);
          pagesConfig = config.pages || config.groupedPages;
          usingGroupedConfig = !!config.groupedPages;
          if (!(pages.length == 0)) {
            _context9.n = 1;
            break;
          }
          console.error("No pages to display = no routes to add");
          return _context9.a(2);
        case 1:
          // Sort the pages as specified in config, or alphabetically
          if (pagesConfig[pages[0]].position) {
            pages.sort(function (a, b) {
              return pagesConfig[a].position > pagesConfig[b].position ? 1 : -1;
            });
          } else {
            pages.sort();
          }

          // Add the component for each page (dynamically requires the JSX)
          _iterator6 = _createForOfIteratorHelper(pages);
          _context9.p = 2;
          _iterator6.s();
        case 3:
          if ((_step6 = _iterator6.n()).done) {
            _context9.n = 13;
            break;
          }
          key = _step6.value;
          if (!usingGroupedConfig) {
            _context9.n = 11;
            break;
          }
          addGroup(key, pagesConfig[key].icon);
          _iterator7 = _createForOfIteratorHelper(pagesConfig[key].pages);
          _context9.p = 4;
          _iterator7.s();
        case 5:
          if ((_step7 = _iterator7.n()).done) {
            _context9.n = 7;
            break;
          }
          page = _step7.value;
          if (!page.handler) {
            _context9.n = 6;
            break;
          }
          handler = config.handlers[page.handler];
          _context9.n = 6;
          return addRoute(page.handler, handler, true, undefined, key);
        case 6:
          _context9.n = 5;
          break;
        case 7:
          _context9.n = 9;
          break;
        case 8:
          _context9.p = 8;
          _t13 = _context9.v;
          _iterator7.e(_t13);
        case 9:
          _context9.p = 9;
          _iterator7.f();
          return _context9.f(9);
        case 10:
          _context9.n = 12;
          break;
        case 11:
          _page = config.pages[key];
          if (!_page.handler) {
            _context9.n = 12;
            break;
          }
          _handler = config.handlers[_page.handler];
          _context9.n = 12;
          return addRoute(_page.handler, _handler, true);
        case 12:
          _context9.n = 3;
          break;
        case 13:
          _context9.n = 15;
          break;
        case 14:
          _context9.p = 14;
          _t14 = _context9.v;
          _iterator6.e(_t14);
        case 15:
          _context9.p = 15;
          _iterator6.f();
          return _context9.f(15);
        case 16:
          if (config.homepage) {
            homePageHandler = config.handlers[config.homepage.handler];
          } else {
            console.warn("no homepage specified, defaulting to first page");
            homePageHandler = config.handlers[actualPage(config, pages[0]).handler];
          }
          _context9.n = 17;
          return getPageComponent(homePageHandler.pageComponent);
        case 17:
          HomePage = _context9.v;
          if (!HomePage) console.error("can't find page component, no homepage", homePageHandler.pageComponent);else {
            pRoutes.unshift(/*#__PURE__*/React.createElement(Route, {
              path: "/",
              key: "/",
              exact: true,
              component: HomePage
            }));
            pRoutes.push(/*#__PURE__*/React.createElement(Redirect, {
              to: '/',
              key: 'redirect_to_root'
            }));
          }
          return _context9.a(2, {
            pageList: pList,
            pageRoutes: pRoutes,
            pageGroups: pGroups
          });
      }
    }, _callee9, null, [[4, 8, 9, 10], [2, 14, 15, 16]]);
  }));
  return _calculateRoutes.apply(this, arguments);
}
AppProvider.contextTypes = {
  ifefSnapper: object,
  ifefShowModal: func
};
var AppProvider$1 = withAuthHoc(AppProvider);

export { AppProvider$1 as A, getPlatformPath as g };
