import { s as styleInject, _ as _asyncToGenerator, a as _regenerator, d as _slicedToArray, k as _objectWithoutProperties, l as _extends, g as _objectSpread2, b as _toArray, c as _arrayLikeToArray, e as _inherits, f as _createClass, m as _wrapNativeSuper, h as _classCallCheck, i as _callSuper, n as _defineProperty, j as _toConsumableArray, o as _createForOfIteratorHelper, p as _objectDestructuringEmpty, q as _typeof } from './style-inject.es-ebcb980f.js';
import React$1, { useState, useEffect, useCallback, useReducer, useRef, Fragment, useMemo } from 'react';
import _$1 from 'lodash';
import { g as getRandomString, i as isValidUrl, F as FileHelpers, G as GenericMatButton, T as TreeNodeStatus, w as withoutPropagation, _ as _propagateNodeStatusDown, p as propagateNodeStatusUp, c as curriedFlip, d as defaultBranchRenderer, a as defaultLeafRenderer, S as ScriptHelper, A as AdvSearchQueryBuilder, b as FilterControl, e as asSelectOptions, f as ScriptCache, u as usePrevious, h as getFilteredEntitiesBy, j as _nestedGroup, s as setIncludesBy, k as getEntityFromModel, l as leafNodeRenderer, m as branchNodeRenderer } from './TreeRendererHelper-7d89f2f1.js';
import clsx from 'clsx';
import CircularProgress from '@mui/material/CircularProgress';
import produce$1, { produce } from 'immer';
import Select$1 from 'react-select';
import DatePicker from 'react-date-picker';
import DateTimePicker from 'react-datetime-picker';
import CreatableSelect from 'react-select/creatable';
import { object, string, bool, shape, any, func, array, element } from 'prop-types';
import { ResponsivePie } from '@nivo/pie';
import { ResponsiveBar } from '@nivo/bar';
import { ResponsiveLine } from '@nivo/line';
import { compose } from 'redux';
import { connect, useStore } from 'react-redux';
import { createSlice, createSelector } from '@reduxjs/toolkit';
import { G as GenericModal } from './GenericModal-a2a94ca2.js';
import { TextareaAutosize, FormControlLabel, Tooltip } from '@mui/material';
import Checkbox from '@mui/material/Checkbox';
import CheckIcon from '@mui/material/SvgIcon';
import { styled } from '@mui/system';
import CheckBox from '@mui/icons-material/CheckBox';
import CheckBoxOutlineBlank from '@mui/icons-material/CheckBoxOutlineBlank';
import IndeterminateCheckBoxRounded from '@mui/icons-material/IndeterminateCheckBoxRounded';
import CheckedCircle from '@mui/icons-material/CheckCircle';
import UncheckedCircle from '@mui/icons-material/RadioButtonUnchecked';
import LinkTwoToneIcon from '@mui/icons-material/LinkTwoTone';
import LinkOff from '@mui/icons-material/LinkOff';
import ExpandLessIcon from '@mui/icons-material/ExpandLess';
import ExpandMoreIcon from '@mui/icons-material/ExpandMore';

var css_248z = ".simple-table-group-name:before {\n  display: inline-block;\n  content: \"\";\n  width: 5%;\n  margin: 4px;\n  border-top: 1px solid #B2B2B2;\n}\n\n.simple-table-group-name {\n  margin-top: 10px;\n  font-style: italic;\n  font-weight: bold;\n  color: #666666;\n}\n\n.simple-table-group-name:after {\n  display: inline-block;\n  content: \"\";\n  width: 5%;\n  margin: 4px;\n  border-top: 1px solid #B2B2B2;\n}\n\n.simple-doc-table th {\n  padding-left: 5px;\n}\n.simple-doc-table td {\n  padding: 5px;\n}\n\n.simple-property-grid {\n  user-select: text;\n}\n.simple-property-grid td {\n  border: solid lightgray 1px;\n  padding: 3px 5px;\n}\n.simple-property-grid td:nth-child(1) {\n  background-color: lightgray;\n  font-style: italic;\n}\n\n.simple-property-grid-header tbody > tr:first-child > td {\n  background-color: lightgray;\n  font-weight: bold;\n}\n\n.simple-property-grid-footer tbody > tr:last-child {\n  border-top: solid black 2px;\n}\n.simple-property-grid-footer tbody > tr:last-child td {\n  border: none;\n  background-color: white;\n}";
styleInject(css_248z);

var SimpleTable = function SimpleTable(_ref) {
  var header = _ref.header,
    rows = _ref.rows,
    objects = _ref.objects,
    columns = _ref.columns,
    className = _ref.className;
  var keyBase = getRandomString("st_") + "_";
  var i = 0;
  var key = function key() {
    return keyBase + "_" + i++;
  };
  if (!rows && Array.isArray(objects) && columns) {
    var tinfo = objectsToHeaderAndRows(objects, columns);
    header = tinfo.header;
    rows = tinfo.rows;
  }
  if (!rows && !Array.isArray(objects) && columns) {
    rows = objectToRows(objects, columns);
  }
  if (!Array.isArray(rows)) {
    console.warn("SimpleTable can't render", rows);
    return /*#__PURE__*/React$1.createElement("div", {
      style: {
        color: "red"
      }
    }, "SimpleTable was passed data that it cannot render:", /*#__PURE__*/React$1.createElement("pre", null, JSON.stringify(rows, null, 2)));
  }
  return /*#__PURE__*/React$1.createElement("table", {
    className: className
  }, header && /*#__PURE__*/React$1.createElement("thead", null, /*#__PURE__*/React$1.createElement("tr", null, header.map(function (c) {
    return /*#__PURE__*/React$1.createElement("th", {
      key: key()
    }, c);
  }))), rows && _$1.isArray(rows) && /*#__PURE__*/React$1.createElement("tbody", null, rows.map(function (r) {
    return /*#__PURE__*/React$1.createElement("tr", {
      key: key()
    }, _$1.isArray(r) ? r.map(function (c) {
      return /*#__PURE__*/React$1.createElement("td", {
        key: key()
      }, isValidUrl(c) ? /*#__PURE__*/React$1.createElement("a", {
        href: c,
        target: "_blank"
      }, c) : c);
    }) : /*#__PURE__*/React$1.createElement("td", null, "Wrong data shape"));
  })));
};
var _downloadDocument = /*#__PURE__*/function () {
  var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(e, fid) {
    return _regenerator().w(function (_context) {
      while (1) switch (_context.n) {
        case 0:
          e.preventDefault();
          FileHelpers.downloadDocuments([fid]);
        case 1:
          return _context.a(2);
      }
    }, _callee);
  }));
  return function _downloadDocument(_x, _x2) {
    return _ref2.apply(this, arguments);
  };
}();
var objectToRows = function objectToRows(object, columns) {
  var rows = [];
  columns.forEach(function (col) {
    var row = [];
    row.push(col.name);
    row.push(_$1.get(object, col.accessor));
    rows.push(row);
  });
  return rows;
};
var objectsToHeaderAndRows = function objectsToHeaderAndRows(objects, columns) {
  var header = [];
  var rows = [];
  var first = true;
  objects.forEach(function (o) {
    var row = [];
    columns.forEach(function (c) {
      if (first && c.name) header.push(c.name);
      var value = _$1.get(o, c.accessor);
      if (c.download) {
        row.push(/*#__PURE__*/React$1.createElement("a", {
          href: "#",
          key: o._id,
          className: "download",
          onClick: function onClick(e) {
            return _downloadDocument(e, o);
          }
        }, value));
      } else {
        row.push(value);
      }
    });
    rows.push(row);
    first = false;
  });
  return {
    header: header,
    rows: rows
  };
};

var css_248z$1 = ".simple-tabbed-table .simple-tabbed-table__tabs {\n  display: flex;\n}\n.simple-tabbed-table .simple-tabbed-table__tabs .simple-tabbed-table__tab {\n  width: 150px;\n  box-shadow: inset 8px 0px 10px -9px #b2b2b2;\n  height: 45px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  background: rgb(239, 239, 239);\n  cursor: pointer;\n}\n.simple-tabbed-table .simple-tabbed-table__tabs .simple-tabbed-table__tab:first-child {\n  border-top-left-radius: 10px;\n  box-shadow: none;\n}\n.simple-tabbed-table .simple-tabbed-table__tabs .simple-tabbed-table__tab:last-child {\n  border-top-right-radius: 10px;\n}\n.simple-tabbed-table .simple-tabbed-table__tabs .simple-tabbed-table__tab.--selected {\n  background-color: var(--app-accent-color);\n  color: white;\n}\n.simple-tabbed-table .simple-tabbed-table__table {\n  width: 100%;\n}\n.simple-tabbed-table .simple-tabbed-table__table tr td:first-child {\n  width: 150px;\n}";
styleInject(css_248z$1);

var SimpleTabbedTable = function SimpleTabbedTable(props) {
  var _useState = useState(_$1.keys(props.tabs)[0]),
    _useState2 = _slicedToArray(_useState, 2),
    selectedTab = _useState2[0],
    setSelectedTab = _useState2[1];
  useEffect(function () {
    setSelectedTab(_$1.keys(props.tabs)[0]);
  }, [props.tabs]);
  var data = _$1.get(props, "tabs[".concat(selectedTab, "]"), []).map(function (key) {
    var _props$data;
    return [key, (_props$data = props.data) === null || _props$data === void 0 || (_props$data = _props$data[key]) === null || _props$data === void 0 ? void 0 : _props$data.val];
  });
  return /*#__PURE__*/React$1.createElement("div", {
    className: "simple-tabbed-table ".concat(props.className)
  }, /*#__PURE__*/React$1.createElement("div", {
    className: "simple-tabbed-table__tabs"
  }, _$1.keys(props.tabs).map(function (tab) {
    return /*#__PURE__*/React$1.createElement("div", {
      className: clsx('simple-tabbed-table__tab', tab === selectedTab && '--selected'),
      key: tab,
      onClick: function onClick() {
        return setSelectedTab(tab);
      }
    }, tab);
  })), /*#__PURE__*/React$1.createElement(SimpleTable, {
    className: "simple-property-grid simple-tabbed-table__table",
    rows: data
  }));
};

var css_248z$2 = ".or-divider {\n  display: flex;\n  align-items: center;\n  justify-content: space-between;\n  font-size: 18px;\n  font-weight: bold;\n  color: #B2B2B2;\n  margin-bottom: 30px;\n}\n.or-divider .line {\n  height: 2px;\n  width: 40%;\n  background-color: #B2B2B2;\n}";
styleInject(css_248z$2);

var OrDivider = function OrDivider(_ref) {
  var _ref$width = _ref.width,
    width = _ref$width === void 0 ? '100%' : _ref$width;
  return /*#__PURE__*/React$1.createElement("div", {
    className: 'or-divider',
    style: {
      width: width
    }
  }, /*#__PURE__*/React$1.createElement("span", {
    className: 'line'
  }), /*#__PURE__*/React$1.createElement("span", {
    className: 'text'
  }, "OR"), /*#__PURE__*/React$1.createElement("span", {
    className: 'line'
  }));
};

var css_248z$3 = ".enhanced-fetch-control {\n  display: flex;\n  flex-direction: column;\n}";
styleInject(css_248z$3);

var css_248z$4 = ".fetch-button {\n  width: 134px;\n  height: 40px;\n  border-radius: 15px;\n  font-size: 17px;\n}";
styleInject(css_248z$4);

var _excluded = ["customClasses"];
var FetchButton = function FetchButton(_ref) {
  var customClasses = _ref.customClasses,
    props = _objectWithoutProperties(_ref, _excluded);
  return /*#__PURE__*/React$1.createElement(GenericMatButton, _extends({}, props, {
    customClasses: 'fetch-button ' + (customClasses || '')
  }));
};

var css_248z$5 = ".fetching-legend {\n  display: flex;\n  align-items: center;\n}\n.fetching-legend > *:first-child {\n  margin: 10px;\n}\n.fetching-legend .MuiCircularProgress-colorPrimary {\n  color: var(--app-accent-color);\n}";
styleInject(css_248z$5);

var FetchingLegend = function FetchingLegend(_ref) {
  var _ref$legend = _ref.legend,
    legend = _ref$legend === void 0 ? 'Fetching data...' : _ref$legend;
  return /*#__PURE__*/React$1.createElement("div", {
    className: "fetching-legend"
  }, /*#__PURE__*/React$1.createElement("span", null, legend), /*#__PURE__*/React$1.createElement(CircularProgress, {
    color: "primary",
    size: 25
  }));
};

var css_248z$6 = ".text-search {\n  display: flex;\n  flex-direction: column;\n  margin-bottom: 30px;\n}\n.text-search .title {\n  margin: 10px;\n  text-align: left;\n  font-size: 14px;\n  font-weight: bold;\n  letter-spacing: 0;\n  color: #333333;\n}\n.text-search .text-fetch-button {\n  margin-top: 20px;\n  display: flex;\n  flex-wrap: wrap;\n}\n.text-search .search-term {\n  display: flex;\n  margin-bottom: 15px;\n}\n.text-search .search-term input {\n  width: 90%;\n  border: 2px solid #E6E6E6;\n  border-right: none;\n  border-top-left-radius: 5px;\n  border-bottom-left-radius: 5px;\n  padding: 10px 16px;\n}\n.text-search .search-term .clear {\n  cursor: pointer;\n  display: flex;\n  align-items: center;\n  color: #B2B2B2;\n  border: 2px solid #E6E6E6;\n  border-left: none;\n  border-top-right-radius: 5px;\n  border-bottom-right-radius: 5px;\n  min-width: 5px;\n}\n.text-search ::placeholder {\n  color: #B2B2B2;\n}\n\n.advanced-search > span {\n  position: relative;\n}\n.advanced-search > span > label {\n  position: absolute;\n  left: 20px;\n  top: 1px;\n  font-size: 0.9em;\n  font-style: italic;\n}\n.advanced-search input[type=checkbox] {\n  margin-top: 5px;\n}\n.advanced-search .GenericMatButton {\n  margin-top: 20px;\n}\n\n.fetching-legend {\n  display: flex;\n  align-items: center;\n}\n.fetching-legend > *:first-child {\n  margin: 10px;\n}\n\n.MuiCircularProgress-colorPrimary {\n  color: var(--app-accent-color);\n}";
styleInject(css_248z$6);

var TextSearch = function TextSearch(_ref) {
  var currentValue = _ref.currentValue,
    onChange = _ref.onChange,
    touched = _ref.touched,
    onFetch = _ref.onFetch,
    display = _ref.display,
    additionalOptions = _ref.additionalOptions,
    isFetching = _ref.isFetching;
  var handleChange = useCallback(function (_ref2) {
    var value = _ref2.target.value;
    onChange(value);
  }, [onChange]);
  return /*#__PURE__*/React$1.createElement("div", {
    className: "text-search"
  }, /*#__PURE__*/React$1.createElement("span", {
    className: "title"
  }, display), /*#__PURE__*/React$1.createElement("div", {
    className: "search-term"
  }, /*#__PURE__*/React$1.createElement("input", {
    value: currentValue || '',
    onChange: handleChange,
    placeholder: "Enter text to search for..."
  }), /*#__PURE__*/React$1.createElement("div", {
    className: "clear"
  }, !!currentValue && /*#__PURE__*/React$1.createElement("i", {
    onClick: function onClick() {
      return onChange('');
    },
    title: 'Clear',
    className: "fas fa-times"
  }))), additionalOptions, /*#__PURE__*/React$1.createElement("div", {
    className: "text-fetch-button"
  }, /*#__PURE__*/React$1.createElement(FetchButton, {
    disabled: !currentValue,
    onClick: onFetch,
    customClasses: touched && currentValue && 'attention'
  }, "Search"), isFetching && /*#__PURE__*/React$1.createElement(FetchingLegend, null)));
};

var NODE_SEPARATOR = "_";
var NODE_PROPERTY_SEPARATOR = "-";
var parseNode = function parseNode(node) {
  return _objectSpread2(_objectSpread2({}, node), {}, {
    expanded: JSON.parse(node.expanded),
    isLeaf: JSON.parse(node.isLeaf),
    level: JSON.parse(node.level)
  });
};

/**
 * @typedef {Object} NodeInfo
 * @property {string} displayName The node's name displayed to the user.
 * @property {number} level The node's level. Must be an positive integer. 
 * @property {number} position The node's position relative to other nodes in its level. Must be a positive integer.
 */

var NotANodeInfo = /*#__PURE__*/function (_Error) {
  function NotANodeInfo(property, errorType) {
    _classCallCheck(this, NotANodeInfo);
    return _callSuper(this, NotANodeInfo, ["The value provided is not a NodeInfo object: the property \"".concat(property, "\" should be ").concat(errorType)]);
  }
  _inherits(NotANodeInfo, _Error);
  return _createClass(NotANodeInfo);
}(/*#__PURE__*/_wrapNativeSuper(Error));

/**
 * @param {object} obj The object to check.
 * @throws {NotANodeInfo} if the object provided is not a NodeInfo.  
 */
var isNodeInfo = function isNodeInfo(obj) {
  if (!_$1.isPlainObject(obj) || obj === null) throw new NotANodeInfo("obj", "an object");
  if (!_$1.isString(obj.displayName)) throw new NotANodeInfo("displayName", "a string");
  if (obj.displayName.includes(NODE_SEPARATOR)) throw new NotANodeInfo("displayName (".concat(obj.displayName, ")"), "a string free of '".concat(NODE_SEPARATOR, "'"));
  if (!_$1.isInteger(obj.level) || obj.level < 0) throw new NotANodeInfo("level", "a positive integer");
  if (!_$1.isInteger(obj.position) || obj.position < 0) throw new NotANodeInfo("position", "a positive integer");
};

/**
 * @param {NodeInfo} nodeInfo All the necessary information to get the base name of the node.
 * @returns {string} The base name for the node under the following format level-position-displayName
 * @throws {NotANodeInfo} if nodeInfo is not a proper NodeInfo. 
 */
var stringifyNode = function stringifyNode(nodeInfo) {
  isNodeInfo(nodeInfo);
  return "".concat(nodeInfo.level).concat(NODE_PROPERTY_SEPARATOR).concat(nodeInfo.position).concat(NODE_PROPERTY_SEPARATOR).concat(nodeInfo.displayName);
};

/**
 * 
 * @param {string} name The base name of the node you want to parse following this format : level-position-displayName
 * @returns {NodeInfo} All the information contained in the base name of a node, or undefined if name is undefined
 * @throws {NotANodeInfo} if the name provided does not yield a proper NodeInfo.
 */
var parseNodeName = function parseNodeName(name) {
  if (name === undefined) return undefined;
  var _name$split = name.split(NODE_PROPERTY_SEPARATOR),
    _name$split2 = _toArray(_name$split),
    level = _name$split2[0],
    position = _name$split2[1],
    displayNameParts = _arrayLikeToArray(_name$split2).slice(2);
  level = _$1.parseInt(level);
  position = _$1.parseInt(position);
  var displayName = displayNameParts.join(NODE_PROPERTY_SEPARATOR);
  var nodeInfo = {
    level: level,
    position: position,
    displayName: displayName
  };
  isNodeInfo(nodeInfo);
  return nodeInfo;
};

/**
 * 
 * @param {string} parentNodeBaseName The base name of the parent node.
 * @param {NodeInfo} childNodeInfo All the necessary information to get the base name of the child node.
 * @returns {string} The complete name for the child node under the following format parentNodeBaseName_nodeBaseName. If parentNodeInfo is undefined, it only stringifies the child node.
 */
var stringifyNodeWithParent = function stringifyNodeWithParent(parentBaseName, childNodeInfo) {
  if (parentBaseName === undefined) {
    return stringifyNode(childNodeInfo);
  }
  return "".concat(parentBaseName).concat(NODE_SEPARATOR).concat(stringifyNode(childNodeInfo));
};
var InvalidNodeName = /*#__PURE__*/function (_Error2) {
  function InvalidNodeName(string) {
    _classCallCheck(this, InvalidNodeName);
    return _callSuper(this, InvalidNodeName, ["It looks like there is a '".concat(NODE_SEPARATOR, "' in the following node's name: ").concat(string, ". It's a reserved character and cannot be used in the node's display name")]);
  }
  _inherits(InvalidNodeName, _Error2);
  return _createClass(InvalidNodeName);
}(/*#__PURE__*/_wrapNativeSuper(Error));

/**
* 
* @param {string} name The complete name of the node you want to parse following this format : parentNodeBaseName_nodeBaseName
* @returns {{parentNodeInfo: NodeInfo, childNodeInfo: NodeInfo}} All the information contained in the base name of the parent node and all the information contained in the base name of the child node. If the string input does not contain a _, we assume the string is the child node's base name and parse it accordingly, parentNodeIfno will then be undefined.
* @throws {InvalidNodeName} if the strings contain more than one NODE_SEPERATOR, it means the display name from one of the nodes contained an NODE_SPERATOR, which is a reserved character.
*/
var parseNodeNameWithParent = function parseNodeNameWithParent(name) {
  var arr = name.split(NODE_SEPARATOR);
  if (arr.length === 1) {
    return {
      childNodeInfo: parseNodeName(arr[0])
    };
  } else if (arr.length === 2) {
    return {
      parentNodeInfo: parseNodeName(arr[0]),
      childNodeInfo: parseNodeName(arr[1])
    };
  } else {
    throw new InvalidNodeName(name);
  }
};

var css_248z$7 = ".fancy-tree {\n  --invisible-ink: rgba(0, 0, 0, 0);\n  --line-height: 2em;\n  --stroke-width: 0.15em;\n  --tree-padding-left: 2em;\n  --bullet-size: 1em;\n  --bullet-top: 0.3em;\n  --bullet-left: -0.6em;\n  --connector-height: 0.6em;\n  --connector-left: -0.15em;\n  --connector-top-before: 0;\n  --connector-top-after: 1.5em;\n  --channel-width: 1.85em;\n  --channel-left: -1em;\n  --channel-margin-top: 1em;\n  --channel-height-hack: 29px;\n  --channel-connector-border-radius: 0 0 0 3em;\n  --channel-connector-width: 2.7em;\n  --channel-connector-height: 2.5em;\n  --channel-connector-top: 1.5em;\n  --channel-connector-left: -0.15em;\n}\n.fancy-tree ul {\n  --stroke-color: var(--fancytree-one-color);\n  --channel-color: var(--fancytree-one-channel-color);\n}\n.fancy-tree ul ul {\n  padding-left: var(--tree-padding-left);\n  --stroke-color: var(--fancytree-two-color);\n  --channel-color: var(--fancytree-two-channel-color);\n}\n.fancy-tree ul ul ul {\n  --stroke-color: var(--fancytree-three-color);\n  --channel-color: var(--fancytree-three-channel-color);\n}\n.fancy-tree ul ul ul ul {\n  --stroke-color: var(--fancytree-one-color);\n  --channel-color: var(--fancytree-one-channel-color);\n}\n.fancy-tree ul ul ul ul ul {\n  --stroke-color: var(--fancytree-two-color);\n  --channel-color: var(--fancytree-two-channel-color);\n}\n.fancy-tree ul ul ul ul ul ul {\n  --stroke-color: var(--fancytree-three-color);\n  --channel-color: var(--fancytree-three-channel-color);\n}\n.fancy-tree ul {\n  list-style: none;\n  display: none;\n}\n.fancy-tree > ul,\n.fancy-tree li.expanded > ul {\n  display: block;\n}\n.fancy-tree li {\n  position: relative;\n  line-height: var(--line-height);\n  margin-left: 1em;\n}\n.fancy-tree li > a > span {\n  margin-left: 1em;\n  color: black;\n}\n.fancy-tree li > a > span > div {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n.fancy-tree li > a > span > div:hover {\n  white-space: normal;\n}\n.fancy-tree {\n  /* Channel */\n}\n.fancy-tree li:before {\n  content: \".\";\n  color: var(--invisible-ink);\n  position: absolute;\n  width: var(--channel-width);\n  background-color: var(--channel-color);\n  left: var(--channel-left);\n  height: var(--channel-height-hack);\n}\n.fancy-tree li:first-child:before,\n.fancy-tree li.expanded + li:before {\n  border-top-left-radius: 50%;\n  border-top-right-radius: 50%;\n}\n.fancy-tree li ul li:first-child {\n  margin-top: var(--channel-margin-top);\n}\n.fancy-tree li:last-child:before,\n.fancy-tree li.expanded:before {\n  border-bottom-left-radius: 50%;\n  border-bottom-right-radius: 50%;\n}\n.fancy-tree {\n  /* Channel Connector */\n}\n.fancy-tree li.expanded:after {\n  content: \".\";\n  color: var(--invisible-ink);\n  position: absolute;\n  border-left: solid var(--stroke-color) var(--stroke-width);\n  border-bottom: solid var(--stroke-color) var(--stroke-width);\n  border-radius: var(--channel-connector-border-radius);\n  width: var(--channel-connector-width);\n  height: var(--channel-connector-height);\n  top: var(--channel-connector-top);\n  left: var(--channel-connector-left);\n}\n.fancy-tree {\n  /* Bullet */\n}\n.fancy-tree li > a > span:before {\n  content: \"\";\n  position: absolute;\n  width: var(--bullet-size);\n  height: var(--bullet-size);\n  left: var(--bullet-left);\n  top: var(--bullet-top);\n  border: solid var(--stroke-color) var(--stroke-width);\n  border-radius: 50%;\n  background-color: white;\n}\n.fancy-tree li.leaf > a > span:before {\n  border-radius: 0;\n  width: calc(var(--bullet-size) - 0.2em);\n  height: calc(var(--bullet-size) - 0.2em);\n  left: calc(var(--bullet-left) + 0.1em);\n  top: calc(var(--bullet-top) + 0.2em);\n}\n.fancy-tree li.selected > a > span:before {\n  background-color: var(--stroke-color);\n}\n.fancy-tree li.branch.partial > a > span:before, .fancy-tree li.expanded.partial > a > span:before {\n  background-color: var(--channel-color);\n}\n.fancy-tree li.leaf > a > span:after {\n  height: calc(var(--connector-height) + 0.1em);\n}\n.fancy-tree li:last-child > a:after,\n.fancy-tree li:first-child > a:before,\n.fancy-tree li.expanded > a:after {\n  display: none;\n}\n.fancy-tree li.leaf.selected > a > span:before {\n  background-color: var(--stroke-color);\n}\n.fancy-tree {\n  /* Bullet Connector */\n}\n.fancy-tree li {\n  border-left: solid var(--stroke-color) var(--stroke-width);\n}\n.fancy-tree li:last-child {\n  border-left: solid var(--invisible-ink) var(--stroke-width);\n}\n.fancy-tree a:before {\n  content: \"\";\n  position: absolute;\n  height: var(--connector-height);\n  top: var(--connector-top-before);\n  left: var(--connector-left);\n  border-left: solid var(--stroke-color) var(--stroke-width);\n}\n.fancy-tree a:after {\n  content: \"\";\n  position: absolute;\n  height: 100%;\n  top: var(--connector-top-after);\n  left: var(--connector-left);\n  border-left: solid var(--stroke-color) var(--stroke-width);\n}\n.fancy-tree {\n  /* Content */\n}\n.fancy-tree li > a > span {\n  margin-left: 1.5em;\n  display: block;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  font-size: 16px;\n}\n.fancy-tree span.count {\n  margin-left: 0.5em;\n  color: var(--stroke-color);\n  font-weight: bold;\n}\n.fancy-tree .tooltip-wrapper {\n  position: absolute;\n  margin-left: 0.3em;\n  display: inline-block;\n  padding-top: 0.5em;\n}\n.fancy-tree .tooltip-wrapper .dbm-tooltip .dbm-tooltiptext {\n  width: 200px;\n  margin-left: -150px;\n  white-space: normal;\n}\n.fancy-tree .fancy-tree__count {\n  display: flex;\n  align-items: end;\n  justify-content: start;\n  padding-bottom: 10px;\n}\n.fancy-tree .fancy-tree__count span:not(:first-child) {\n  padding-inline-start: 1em; /*length relative to font-size*/\n}\n.fancy-tree .fancy-tree__count--action {\n  color: var(--app-accent-color);\n  cursor: pointer;\n  text-decoration: underline;\n}";
styleInject(css_248z$7);

var ReactiveTreeControl = function ReactiveTreeControl(_ref) {
  var nodeIndex = _ref.nodeIndex,
    onNodeIndexChange = _ref.onNodeIndexChange,
    _ref$renderBranchNode = _ref.renderBranchNode,
    renderBranchNode = _ref$renderBranchNode === void 0 ? defaultBranchRenderer : _ref$renderBranchNode,
    _ref$renderLeafNode = _ref.renderLeafNode,
    renderLeafNode = _ref$renderLeafNode === void 0 ? defaultLeafRenderer : _ref$renderLeafNode;
  var getNodeClasses = function getNodeClasses(node) {
    var baseClasses = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    return clsx(baseClasses, _$1.get(node, 'selectedStatus', TreeNodeStatus.OFF) === TreeNodeStatus.ON && "selected", _$1.get(node, 'selectedStatus', TreeNodeStatus.OFF) === TreeNodeStatus.PARTIAL && "partial", _$1.get(node, 'expanded', false) && "expanded", _$1.get(node, 'hidden', false) && "hidden");
  };
  var expandBranch = function expandBranch(node) {
    return onNodeIndexChange(produce(nodeIndex, function (nodeIndex) {
      nodeIndex[node.id].expanded = !nodeIndex[node.id].expanded;
    }));
  };
  var toggleNode = function toggleNode(property) {
    return function (node) {
      return onNodeIndexChange(produce(nodeIndex, function (nodeIndex) {
        var wasOn = nodeIndex[node.id][property] === TreeNodeStatus.ON;
        _propagateNodeStatusDown(property)(nodeIndex, node.id, wasOn ? TreeNodeStatus.OFF : TreeNodeStatus.ON);
        propagateNodeStatusUp(property)(nodeIndex, node.id);
      }));
    };
  };
  var getNodeChildren = function getNodeChildren(node) {
    return node.children.map(function (childId) {
      return nodeIndex[childId];
    });
  };
  var getChildrenCount = function getChildrenCount(node) {
    return _$1.values(nodeIndex).filter(function (n) {
      return n.isLeaf && n.parents.includes(node.id);
    }).length;
  };
  var renderBranch = function renderBranch(node) {
    return /*#__PURE__*/React$1.createElement("li", {
      className: getNodeClasses(node, 'branch'),
      onClick: withoutPropagation(function () {
        return toggleNode('selectedStatus')(node);
      }),
      key: node.id
    }, /*#__PURE__*/React$1.createElement("a", null, /*#__PURE__*/React$1.createElement("span", null, /*#__PURE__*/React$1.createElement("i", {
      className: "fa fa-angle-down branch-expander",
      onClick: withoutPropagation(function () {
        return expandBranch(node);
      })
    }), renderBranchNode(node, getChildrenCount(node), curriedFlip(toggleNode)(node)))), /*#__PURE__*/React$1.createElement("ul", {
      key: node.id + "_children"
    }, renderNodes(getNodeChildren(node))));
  };
  var renderLeaf = function renderLeaf(node) {
    return /*#__PURE__*/React$1.createElement("li", {
      className: getNodeClasses(node, 'leaf'),
      key: node.id,
      onClick: withoutPropagation(function () {
        return toggleNode('selectedStatus')(node);
      })
    }, /*#__PURE__*/React$1.createElement("a", null, /*#__PURE__*/React$1.createElement("span", null, renderLeafNode(node, curriedFlip(toggleNode)(node)))));
  };
  var renderNodes = function renderNodes(treeNodes) {
    return treeNodes.map(function (node) {
      if (!node) {
        return /*#__PURE__*/React$1.createElement("p", null, "No node to render");
      }
      return node.isLeaf ? renderLeaf(node) : renderBranch(node);
    });
  };
  return /*#__PURE__*/React$1.createElement("div", {
    className: "fancy-tree"
  }, !_$1.isEmpty(nodeIndex) ? /*#__PURE__*/React$1.createElement("ul", null, renderNodes(_$1.values(nodeIndex).filter(function (node) {
    return node.level === 0;
  }))) : null);
};

var css_248z$8 = ".tree-search .title {\n  margin: 10px;\n  text-align: left;\n  font-size: 14px;\n  font-weight: bold;\n  letter-spacing: 0;\n  color: #333333;\n}\n.tree-search p.tree-search__loading {\n  padding: 0 10px;\n}";
styleInject(css_248z$8);

var treeControlLeafNodeRenderer = function treeControlLeafNodeRenderer(group) {
  return /*#__PURE__*/React$1.createElement("div", null, parseNodeNameWithParent(group.name).childNodeInfo.displayName, !!group.count && /*#__PURE__*/React$1.createElement("span", {
    className: "count",
    style: {
      fontSize: "0.8em"
    }
  }, group.count));
};
var treeControlBranchNodeRenderer = function treeControlBranchNodeRenderer(group) {
  var childCount = group.count;
  return /*#__PURE__*/React$1.createElement("span", null, parseNodeNameWithParent(group.name).childNodeInfo.displayName, !!childCount && /*#__PURE__*/React$1.createElement("span", {
    className: "count",
    style: {
      fontSize: "0.8em"
    }
  }, childCount));
};
var treeSearchReducer = function treeSearchReducer(state, action) {
  switch (action.type) {
    case 'reloading':
      return _objectSpread2(_objectSpread2({}, state), {}, {
        reloading: true
      });
    case 'reloaded':
      return _objectSpread2(_objectSpread2({}, state), {}, {
        reloading: false,
        nodeIndex: action.nodeIndex
      });
    case 'update_node':
      var nodeToUpdate = state.nodeIndex.find(action.id);
      if (nodeToUpdate === undefined) return state;
      return _objectSpread2(_objectSpread2({}, state), {}, {
        nodeIndex: _objectSpread2(_objectSpread2({}, state.nodeIndex), {}, _defineProperty({}, action.id, _objectSpread2(_objectSpread2({}, nodeToUpdate), action.node)))
      });
    default:
      return _objectSpread2(_objectSpread2({}, state), {}, {
        reloading: false,
        nodeIndex: action.nodeIndex ? action.nodeIndex : state.nodeIndex
      });
  }
};
var initialTreeState = {
  reloading: false,
  nodeIndex: {}
};
var TreeSearch = function TreeSearch(_ref) {
  var _ref$currentValue = _ref.currentValue,
    currentValue = _ref$currentValue === void 0 ? {} : _ref$currentValue,
    currentState = _ref.currentState,
    onFetch = _ref.onFetch,
    treeLevels = _ref.treeLevels,
    display = _ref.display,
    reloadToken = _ref.reloadToken,
    _ref$fetchAfterTreeLo = _ref.fetchAfterTreeLoad,
    fetchAfterTreeLoad = _ref$fetchAfterTreeLo === void 0 ? false : _ref$fetchAfterTreeLo;
  var _useReducer = useReducer(treeSearchReducer, initialTreeState),
    _useReducer2 = _slicedToArray(_useReducer, 2),
    treeState = _useReducer2[0],
    dispatch = _useReducer2[1];

  //we will keep track of those dependencies, to determine if it's first render in an effect
  var reloadTokenLatest = useRef(reloadToken);
  var treeLevelsLatest = useRef(treeLevels);
  useEffect(function () {
    dispatch({
      type: 'reloading'
    });
    //if it's initial render, we must know of the fact, as the tree might render from memory instead of doing a fetch
    //use case: switching between entity tabs
    var initialRefresh = reloadTokenLatest.current == reloadToken && treeLevelsLatest.current == treeLevels;
    var preLoadedTree = currentState && !_$1.isEmpty(currentState) ? _objectSpread2({}, currentState) : _objectSpread2({}, treeState.nodeIndex);
    if (initialRefresh && !_$1.isEmpty(preLoadedTree)) {
      dispatch({
        type: 'reloaded',
        nodeIndex: preLoadedTree
      });
    }
    fetchTree();
  }, [treeLevels, reloadToken]);
  useEffect(function () {
    if (_$1.isEmpty(currentValue)) {
      resetNodeIndex();
    }
  }, [currentValue]);
  function resetNodeIndex() {
    var nodeIndex = _objectSpread2({}, treeState.nodeIndex);
    _$1.values(nodeIndex).forEach(function (node) {
      nodeIndex[node.id] = _objectSpread2(_objectSpread2({}, node), {}, {
        selectedStatus: TreeNodeStatus.OFF
      });
    });
    dispatch({
      nodeIndex: nodeIndex
    });
  }
  function getTree() {
    return _getTree.apply(this, arguments);
  }
  function _getTree() {
    _getTree = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3() {
      var level, parentNames, parents, levelNodes, newNodeIndex, _iterator, _step, nodeKey, _t;
      return _regenerator().w(function (_context3) {
        while (1) switch (_context3.p = _context3.n) {
          case 0:
            level = 0;
            parentNames = undefined;
            parents = undefined;
            _context3.n = 1;
            return getLevelNodes(level, parentNames);
          case 1:
            levelNodes = _context3.v;
            _context3.n = 2;
            return buildNodeIndex(levelNodes, level, parents, parentNames, currentValue);
          case 2:
            newNodeIndex = _context3.v;
            //Load expanded nodes' children
            _iterator = _createForOfIteratorHelper(_$1.keys(newNodeIndex));
            _context3.p = 3;
            _iterator.s();
          case 4:
            if ((_step = _iterator.n()).done) {
              _context3.n = 7;
              break;
            }
            nodeKey = _step.value;
            _context3.n = 5;
            return loadChildrenDeep(nodeKey, newNodeIndex, currentValue);
          case 5:
            newNodeIndex = _context3.v;
          case 6:
            _context3.n = 4;
            break;
          case 7:
            _context3.n = 9;
            break;
          case 8:
            _context3.p = 8;
            _t = _context3.v;
            _iterator.e(_t);
          case 9:
            _context3.p = 9;
            _iterator.f();
            return _context3.f(9);
          case 10:
            return _context3.a(2, newNodeIndex);
        }
      }, _callee3, null, [[3, 8, 9, 10]]);
    }));
    return _getTree.apply(this, arguments);
  }
  function refreshTree() {
    return _refreshTree.apply(this, arguments);
  }
  function _refreshTree() {
    _refreshTree = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4() {
      var newNodeIndex;
      return _regenerator().w(function (_context4) {
        while (1) switch (_context4.n) {
          case 0:
            _context4.n = 1;
            return getTree();
          case 1:
            newNodeIndex = _context4.v;
            return _context4.a(2, newNodeIndex);
        }
      }, _callee4);
    }));
    return _refreshTree.apply(this, arguments);
  }
  function fetchTree() {
    return _fetchTree.apply(this, arguments);
  }
  function _fetchTree() {
    _fetchTree = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee5() {
      return _regenerator().w(function (_context5) {
        while (1) switch (_context5.n) {
          case 0:
            reloadTokenLatest.current = reloadToken;
            treeLevelsLatest.current = treeLevels;
            try {
              refreshTree().then(function (nodeIndex) {
                dispatch({
                  type: 'reloaded',
                  nodeIndex: nodeIndex
                });
                //if currentValue is empty, means nothing is selected on the tree == don't do FETCH, as it will overwrite redux state done by other components
                //deselecting is handled by a different call to 'onFetch' inside handleNodeIndexChange()
                //if the tree is part of the withEntitySearch component (==redux entity store) initial fetch is handled by onLoadComplete()
                //if the tree is not part of the withEntitySearch, please use 'fetchAfterTreeLoad' flag to activate initial fetch
                if (fetchAfterTreeLoad) {
                  onFetch(undefined, currentValue, nodeIndex);
                }
              });
            } catch (e) {
              dispatch({
                type: 'reloaded'
              });
            }
          case 1:
            return _context5.a(2);
        }
      }, _callee5);
    }));
    return _fetchTree.apply(this, arguments);
  }
  var getPreviousValues = function getPreviousValues(parentNames) {
    var keys = treeLevels.map(function (tl) {
      return tl.property;
    });
    var values = parentNames.map(function (name) {
      var _parseNodeNameWithPar;
      return (_parseNodeNameWithPar = parseNodeNameWithParent(name)) === null || _parseNodeNameWithPar === void 0 || (_parseNodeNameWithPar = _parseNodeNameWithPar.childNodeInfo) === null || _parseNodeNameWithPar === void 0 ? void 0 : _parseNodeNameWithPar.displayName;
    });
    return _$1.zipObject(keys, values);
  };
  var isLast = function isLast(level) {
    return level === treeLevels.length - 1;
  };
  function fetchChildren(_x, _x2, _x3) {
    return _fetchChildren.apply(this, arguments);
  }
  function _fetchChildren() {
    _fetchChildren = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee6(nodeLevel, node, nodeParentNames) {
      var isLeaf;
      return _regenerator().w(function (_context6) {
        while (1) switch (_context6.n) {
          case 0:
            isLeaf = isLast(nodeLevel);
            if (!isLeaf) {
              _context6.n = 1;
              break;
            }
            return _context6.a(2, []);
          case 1:
            _context6.n = 2;
            return getLevelNodes(nodeLevel + 1, [].concat(_toConsumableArray(nodeParentNames), [node.name]));
          case 2:
            return _context6.a(2, _context6.v);
        }
      }, _callee6);
    }));
    return _fetchChildren.apply(this, arguments);
  }
  function getChildrenNames(_x4, _x5, _x6) {
    return _getChildrenNames.apply(this, arguments);
  }
  function _getChildrenNames() {
    _getChildrenNames = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee7(nodeLevel, node, nodeParentNames) {
      return _regenerator().w(function (_context7) {
        while (1) switch (_context7.n) {
          case 0:
            _context7.n = 1;
            return fetchChildren(nodeLevel, node, nodeParentNames);
          case 1:
            return _context7.a(2, _context7.v.map(function (child) {
              return child.name;
            }));
        }
      }, _callee7);
    }));
    return _getChildrenNames.apply(this, arguments);
  }
  var buildNodeIndex = /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(levelNodes, level) {
      var parents,
        parentNames,
        currentValue,
        newNodeIndexPromises,
        newNodeIndex,
        newNodeIndexArray,
        _args2 = arguments;
      return _regenerator().w(function (_context2) {
        while (1) switch (_context2.n) {
          case 0:
            parents = _args2.length > 2 && _args2[2] !== undefined ? _args2[2] : [];
            parentNames = _args2.length > 3 && _args2[3] !== undefined ? _args2[3] : [];
            currentValue = _args2.length > 4 ? _args2[4] : undefined;
            newNodeIndexPromises = levelNodes.map(/*#__PURE__*/function () {
              var _ref3 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(node) {
                var nodeFromProps, id, name, count, isLeaf, childrenNames, children, defaultSelectedStatus, expanded, selectedStatus;
                return _regenerator().w(function (_context) {
                  while (1) switch (_context.n) {
                    case 0:
                      nodeFromProps = _$1.values(currentValue).find(function (n) {
                        if (!n.id) {
                          //current value might come from a query which might be without an id
                          return n.name == node.name;
                        }
                        return n.id === node.id;
                      });
                      id = node.id;
                      name = node.name;
                      count = node.childCount;
                      isLeaf = isLast(level);
                      _context.n = 1;
                      return getChildrenNames(level, node, parentNames);
                    case 1:
                      childrenNames = _context.v;
                      children = _toConsumableArray(childrenNames);
                      defaultSelectedStatus = _$1.get(treeState.nodeIndex, "".concat(_$1.last(parents), ".selectedStatus")) === TreeNodeStatus.ON ? TreeNodeStatus.ON : TreeNodeStatus.OFF;
                      expanded = (nodeFromProps === null || nodeFromProps === void 0 ? void 0 : nodeFromProps.expanded) || false;
                      selectedStatus = (nodeFromProps === null || nodeFromProps === void 0 ? void 0 : nodeFromProps.selectedStatus) || defaultSelectedStatus;
                      return _context.a(2, {
                        id: id,
                        name: name,
                        count: count,
                        level: level,
                        parents: parents,
                        parentNames: parentNames,
                        children: children,
                        childrenNames: childrenNames,
                        isLeaf: isLeaf,
                        expanded: expanded,
                        selectedStatus: selectedStatus
                      });
                  }
                }, _callee);
              }));
              return function (_x9) {
                return _ref3.apply(this, arguments);
              };
            }());
            newNodeIndex = {};
            _context2.n = 1;
            return Promise.all(newNodeIndexPromises);
          case 1:
            newNodeIndexArray = _context2.v;
            newNodeIndexArray.forEach(function (newNode) {
              return newNodeIndex[newNode.id] = newNode;
            });
            return _context2.a(2, newNodeIndex);
        }
      }, _callee2);
    }));
    return function buildNodeIndex(_x7, _x8) {
      return _ref2.apply(this, arguments);
    };
  }();
  function getLevelNodes(_x0) {
    return _getLevelNodes.apply(this, arguments);
  }
  function _getLevelNodes() {
    _getLevelNodes = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee8(level) {
      var parentNames,
        input,
        rawNodes,
        rawNodesCopy,
        parentBaseName,
        levelNodes,
        _args8 = arguments;
      return _regenerator().w(function (_context8) {
        while (1) switch (_context8.n) {
          case 0:
            parentNames = _args8.length > 1 && _args8[1] !== undefined ? _args8[1] : [];
            input = getPreviousValues(parentNames);
            _context8.n = 1;
            return ScriptHelper.executeScript(treeLevels[level].script, parentNames ? {
              input: input
            } : undefined);
          case 1:
            rawNodes = _context8.v;
            rawNodesCopy = rawNodes.filter(function (node) {
              return node.name !== '';
            });
            /**
             *  This assumes a tree no deeper than two levels. Ultimately, we need to get persistent ids from the platform for each node, 
             *  or to improve the stringifying/parsing functions.
             */
            parentBaseName = level !== 0 ? parentNames[parentNames.length - 1] : undefined; // const parentInfo = {displayName: input.Level, level:}
            levelNodes = rawNodesCopy.map(function (node, position) {
              var displayName = node.name || node;
              var nameKey = stringifyNodeWithParent(parentBaseName, {
                displayName: displayName,
                level: level,
                position: position
              });

              // // create unique (but repeatable on each re-render) id for the node
              // // to also allow it to work with query navigation
              // let idSuffixPart = (countNodesByKey.get(nameKey) || 0) + 1;
              // let id = `${nameKey}-${idSuffixPart}`;
              // countNodesByKey.set(nameKey,idSuffixPart);

              // we cannot use random ids on each render due to navigation issues
              // we need to wait for a persistent ids
              //let id = uid();

              if (node.name) {
                return _objectSpread2(_objectSpread2({}, node), {}, {
                  id: nameKey,
                  name: nameKey
                });
              } else {
                return {
                  id: nameKey,
                  name: nameKey,
                  childCount: 0
                };
              }
            });
            return _context8.a(2, levelNodes);
        }
      }, _callee8);
    }));
    return _getLevelNodes.apply(this, arguments);
  }
  function loadChildren(_x1, _x10, _x11) {
    return _loadChildren.apply(this, arguments);
  }
  function _loadChildren() {
    _loadChildren = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee9(nodeKey, nodeIndex, currentValue) {
      var nodeIndicesToAdd, node, newNodeIndex;
      return _regenerator().w(function (_context9) {
        while (1) switch (_context9.n) {
          case 0:
            _context9.n = 1;
            return getChildren(nodeKey, nodeIndex, currentValue);
          case 1:
            nodeIndicesToAdd = _context9.v;
            node = _objectSpread2(_objectSpread2({}, nodeIndex[nodeKey]), {}, {
              children: _$1.keys(nodeIndicesToAdd)
            });
            newNodeIndex = _objectSpread2(_objectSpread2(_objectSpread2({}, nodeIndex), nodeIndicesToAdd), {}, _defineProperty({}, nodeKey, node));
            return _context9.a(2, newNodeIndex);
        }
      }, _callee9);
    }));
    return _loadChildren.apply(this, arguments);
  }
  function getChildren(_x12, _x13, _x14) {
    return _getChildren.apply(this, arguments);
  }
  function _getChildren() {
    _getChildren = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee0(nodeKey, nodeIndex, currentValue) {
      var expandingNode, level, parentNames, parents, levelNodes, nodeIndicesToAdd;
      return _regenerator().w(function (_context0) {
        while (1) switch (_context0.n) {
          case 0:
            expandingNode = nodeIndex[nodeKey];
            level = expandingNode.level + 1;
            parentNames = [].concat(_toConsumableArray(expandingNode.parentNames), [expandingNode.name]);
            parents = [].concat(_toConsumableArray(expandingNode.parents), [expandingNode.id]);
            _context0.n = 1;
            return getLevelNodes(level, parentNames);
          case 1:
            levelNodes = _context0.v;
            _context0.n = 2;
            return buildNodeIndex(levelNodes, level, parents, parentNames, currentValue);
          case 2:
            nodeIndicesToAdd = _context0.v;
            return _context0.a(2, nodeIndicesToAdd);
        }
      }, _callee0);
    }));
    return _getChildren.apply(this, arguments);
  }
  function getChildrenAndParent(_x15, _x16, _x17) {
    return _getChildrenAndParent.apply(this, arguments);
  } //Loads all deeply nested children of node if they need to be displayed
  function _getChildrenAndParent() {
    _getChildrenAndParent = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee1(nodeKey, nodeIndex, currentValue) {
      var nodeIndicesToAdd, node;
      return _regenerator().w(function (_context1) {
        while (1) switch (_context1.n) {
          case 0:
            _context1.n = 1;
            return getChildren(nodeKey, nodeIndex, currentValue);
          case 1:
            nodeIndicesToAdd = _context1.v;
            node = _objectSpread2(_objectSpread2({}, nodeIndex[nodeKey]), {}, {
              children: _$1.keys(nodeIndicesToAdd)
            });
            return _context1.a(2, _objectSpread2(_objectSpread2({}, nodeIndicesToAdd), {}, _defineProperty({}, nodeKey, node)));
        }
      }, _callee1);
    }));
    return _getChildrenAndParent.apply(this, arguments);
  }
  function loadChildrenDeep(_x18, _x19, _x20) {
    return _loadChildrenDeep.apply(this, arguments);
  }
  function _loadChildrenDeep() {
    _loadChildrenDeep = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee10(nodeKey, nodeIndex, currentValue) {
      var node, newNodeIndex, updatedNode, _iterator2, _step2, child, _t2;
      return _regenerator().w(function (_context10) {
        while (1) switch (_context10.p = _context10.n) {
          case 0:
            node = nodeIndex[nodeKey];
            if (!(!node || _$1.isEmpty(node.children) || node.isLeaf || !node.expanded)) {
              _context10.n = 1;
              break;
            }
            return _context10.a(2, nodeIndex);
          case 1:
            _context10.n = 2;
            return loadChildren(nodeKey, nodeIndex, currentValue);
          case 2:
            newNodeIndex = _context10.v;
            updatedNode = nodeIndex[nodeKey];
            _iterator2 = _createForOfIteratorHelper(updatedNode.children);
            _context10.p = 3;
            _iterator2.s();
          case 4:
            if ((_step2 = _iterator2.n()).done) {
              _context10.n = 7;
              break;
            }
            child = _step2.value;
            _context10.n = 5;
            return loadChildrenDeep(child.name, newNodeIndex, currentValue);
          case 5:
            newNodeIndex = _context10.v;
          case 6:
            _context10.n = 4;
            break;
          case 7:
            _context10.n = 9;
            break;
          case 8:
            _context10.p = 8;
            _t2 = _context10.v;
            _iterator2.e(_t2);
          case 9:
            _context10.p = 9;
            _iterator2.f();
            return _context10.f(9);
          case 10:
            return _context10.a(2, newNodeIndex);
          case 11:
            return _context10.a(2);
        }
      }, _callee10, null, [[3, 8, 9, 10]]);
    }));
    return _loadChildrenDeep.apply(this, arguments);
  }
  function getFilteringNodes(aNodeIndex) {
    return _$1.pickBy(aNodeIndex, function (node) {
      return [TreeNodeStatus.ON].includes(node.selectedStatus);
    });
  }
  function handleNodeIndexChange(_x21) {
    return _handleNodeIndexChange.apply(this, arguments);
  }
  function _handleNodeIndexChange() {
    _handleNodeIndexChange = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee11(nodeIndex) {
      var childrenLoaded, childrenPromises, childrenToAdd, newNodeIndex, selectedNodes, selectedNodesWithNameAsKey, _t3, _t4, _t5, _t6;
      return _regenerator().w(function (_context11) {
        while (1) switch (_context11.n) {
          case 0:
            childrenLoaded = function childrenLoaded(childrenIds, nodeIndex) {
              return childrenIds.every(function (childrenId) {
                return _$1.keys(nodeIndex).includes(childrenId);
              });
            };
            childrenPromises = _$1.values(nodeIndex).map(function (node) {
              var childrenNotLoaded = !childrenLoaded(node.children, nodeIndex);
              if (node.expanded && childrenNotLoaded) {
                return getChildrenAndParent(node.id, nodeIndex, currentValue);
              } else {
                return Promise.resolve({});
              }
            });
            childrenToAdd = {};
            _t3 = _$1.merge;
            _t4 = _$1;
            _t5 = [childrenToAdd];
            _t6 = _toConsumableArray;
            _context11.n = 1;
            return Promise.all(childrenPromises);
          case 1:
            _t3.apply.call(_t3, _t4, _t5.concat.call(_t5, _t6(_context11.v)));
            newNodeIndex = _objectSpread2(_objectSpread2({}, nodeIndex), childrenToAdd);
            selectedNodes = getFilteringNodes(newNodeIndex);
            selectedNodes = !_$1.isEmpty(selectedNodes) ? selectedNodes : null;
            if (!_$1.isEqual(currentValue, selectedNodes)) {
              selectedNodesWithNameAsKey = {};
              _$1.values(selectedNodes).forEach(function (node) {
                return selectedNodesWithNameAsKey[node.name] = node;
              });
              //TODO: skipFetch if node not selected
              onFetch(undefined, selectedNodesWithNameAsKey, newNodeIndex);
            }
            dispatch({
              nodeIndex: newNodeIndex
            });
          case 2:
            return _context11.a(2);
        }
      }, _callee11);
    }));
    return _handleNodeIndexChange.apply(this, arguments);
  }
  return /*#__PURE__*/React$1.createElement("div", {
    className: "tree-search"
  }, display && /*#__PURE__*/React$1.createElement("label", {
    className: "title"
  }, display), !treeState.reloading && !_$1.isEmpty(treeState.nodeIndex) ? /*#__PURE__*/React$1.createElement(ReactiveTreeControl, {
    className: "entity-tree",
    renderLeafNode: treeControlLeafNodeRenderer,
    renderBranchNode: treeControlBranchNodeRenderer,
    nodeIndex: treeState.nodeIndex,
    onNodeIndexChange: handleNodeIndexChange
  }) : /*#__PURE__*/React$1.createElement("p", {
    className: "tree-search__loading"
  }, "Loading tree..."));
};

var FILTER2OP = {
  "equals": AdvSearchQueryBuilder.Operators.equals,
  "does not equal": AdvSearchQueryBuilder.Operators.notEquals,
  "starts with": AdvSearchQueryBuilder.Operators.startsWith,
  "ends with": AdvSearchQueryBuilder.Operators.endsWith,
  "contains": AdvSearchQueryBuilder.Operators.contains,
  "does not start with": AdvSearchQueryBuilder.Operators.doesNotStartsWith,
  "does not end with": AdvSearchQueryBuilder.Operators.doesNotEndsWith,
  "does not contain": AdvSearchQueryBuilder.Operators.doesNotContains,
  "less than": AdvSearchQueryBuilder.Operators.lessThan,
  "less than or equal to": AdvSearchQueryBuilder.Operators.lessThanEquals,
  "greater than": AdvSearchQueryBuilder.Operators.greaterThan,
  "greater than or equal to": AdvSearchQueryBuilder.Operators.greaterThanEquals,
  "between": AdvSearchQueryBuilder.Operators.inRange,
  "outside of": AdvSearchQueryBuilder.Operators.outOfRange
  // "in": ,
  // "is not in": ,
};
var isTextOperator = function isTextOperator(fop) {
  return fop == "equals" || fop == "does not equal" || fop == "starts with" || fop == "ends with" || fop == "contains" || fop == "does not start with" || fop == "does not end with" || fop == "does not contain";
};
var isRangeOperator = function isRangeOperator(fop) {
  return fop == "between" || fop == "outside of";
};
var queryFromFilter = function queryFromFilter(enhancedFilter) {
  // "enhanced" because it contains includeAll and ignoreCase as well as the filters
  var searchTerms = Object.entries(enhancedFilter.filters).map(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
      property = _ref2[0],
      filter = _ref2[1];
    var prop = "properties." + property + ".val";
    if (filter.type == "date" || filter.type == "datetime") prop = "properties." + property + ".epoch";
    var val = filter.value;
    if (filter.type == "number" && !isRangeOperator(filter.op)) val = parseFloat(val);
    var searchTerm = {
      property: prop,
      op: FILTER2OP[filter.op],
      value: val,
      type: filter.type
    };
    if (enhancedFilter.ignoreCase && isTextOperator(filter.op)) searchTerm.options = "i";
    return searchTerm;
  });
  var searchOp = enhancedFilter.includeAll ? "$and" : "$or";
  return AdvSearchQueryBuilder.build(searchTerms, searchOp);
};

var FILTER_SELECT_STYLES = {
  control: function control(styles) {
    return _objectSpread2(_objectSpread2({}, styles), {}, {
      width: '100%',
      margin: '10px 0'
    });
  },
  container: function container(styles) {
    return _objectSpread2(_objectSpread2({}, styles), {}, {
      display: 'block',
      width: '100%'
    });
  }
};
var AdvancedSearch = function AdvancedSearch(props) {
  var currentValue = props.currentValue,
    onChange = props.onChange,
    touched = props.touched,
    onFetch = props.onFetch,
    display = props.display;
  var _useState = useState(currentValue ? currentValue.fitlers : {}),
    _useState2 = _slicedToArray(_useState, 2),
    filters = _useState2[0],
    setFilters = _useState2[1];
  var _useState3 = useState(currentValue ? currentValue.includeAll : true),
    _useState4 = _slicedToArray(_useState3, 2),
    includeAll = _useState4[0],
    setIncludeAll = _useState4[1];
  var _useState5 = useState(currentValue ? currentValue.ignoreCase : true),
    _useState6 = _slicedToArray(_useState5, 2),
    ignoreCase = _useState6[0],
    setIgnoreCase = _useState6[1];
  var onChangeFilters = function onChangeFilters(newFilters) {
    setFilters(newFilters);
    onChange({
      filters: newFilters,
      includeAll: includeAll,
      ignoreCase: ignoreCase
    });
  };
  var onChangeAll = function onChangeAll(_ref) {
    var checked = _ref.target.checked;
    setIncludeAll(checked);
    onChange({
      filters: filters,
      includeAll: checked,
      ignoreCase: ignoreCase
    });
  };
  var onChangeCase = function onChangeCase(_ref2) {
    var checked = _ref2.target.checked;
    setIgnoreCase(checked);
    onChange({
      filters: filters,
      includeAll: includeAll,
      ignoreCase: checked
    });
  };
  var disabled = !currentValue || !currentValue.filters || Object.keys(currentValue.filters).length == 0;
  return /*#__PURE__*/React$1.createElement("div", {
    className: "advanced-search text-search"
  }, /*#__PURE__*/React$1.createElement("span", {
    className: "title"
  }, display), /*#__PURE__*/React$1.createElement(FilterControl, {
    className: "entities-filter",
    styles: FILTER_SELECT_STYLES,
    onChange: onChangeFilters,
    filters: filters,
    placeholder: "Choose search terms",
    availableOperators: Object.keys(FILTER2OP),
    availableFilters: props.searchable
  }), /*#__PURE__*/React$1.createElement("span", null, /*#__PURE__*/React$1.createElement("input", {
    type: "checkbox",
    onChange: onChangeCase,
    checked: ignoreCase
  }), /*#__PURE__*/React$1.createElement("label", null, "Ignore Case")), /*#__PURE__*/React$1.createElement("span", null, /*#__PURE__*/React$1.createElement("input", {
    type: "checkbox",
    onChange: onChangeAll,
    checked: includeAll
  }), /*#__PURE__*/React$1.createElement("label", null, "Must include all search terms")), /*#__PURE__*/React$1.createElement(FetchButton, {
    disabled: disabled,
    onClick: onFetch,
    customClasses: touched && !disabled && 'attention'
  }, "Search"));
};

var selectStyles = function selectStyles(provided, _ref) {
  var isFocused = _ref.isFocused,
    isDisabled = _ref.isDisabled;
  return {
    backgroundColor: isDisabled ? "hsl(0, 0%, 95%)" : "hsl(0, 0%, 100%)",
    border: "2px solid ".concat(isFocused && !isDisabled ? 'var(--app-accent-color)' : '#E6E6E6'),
    borderRadius: '5px',
    display: 'flex'
  };
};

var css_248z$9 = ".ipa-select .select-element {\n  width: 90%;\n  margin-bottom: 25px;\n}";
styleInject(css_248z$9);

var css_248z$a = ".control-label {\n  margin: 10px;\n  font-weight: bold;\n}\n\n.control-label.required:after {\n  content: \" * \";\n  color: var(--app-accent-color);\n}";
styleInject(css_248z$a);

var ControlLabel = function ControlLabel(props) {
  return /*#__PURE__*/React$1.createElement("label", {
    style: props.style,
    className: "control-label ".concat(props.className, " ").concat(props.required ? 'required' : '')
  }, props.text);
};
ControlLabel.propTypes = {
  style: object,
  text: string,
  className: string,
  required: bool
};

var Select = function Select(props) {
  var optionStyle = function optionStyle(styles, _ref) {
    var data = _ref.data;
    return _objectSpread2(_objectSpread2({}, styles), {}, {
      color: data.highlight ? 'var(--app-accent-color)' : styles.color
    });
  };
  var selectProps = {
    styles: _objectSpread2({
      control: selectStyles,
      option: optionStyle
    }, props.styles),
    id: props.id,
    isMulti: props.isMulti,
    value: props.value,
    onChange: props.onChange,
    options: props.options,
    classNamePrefix: 'ipa-select',
    className: 'select-element',
    closeMenuOnSelect: props.closeMenuOnSelect,
    isClearable: props.isClearable,
    placeholder: props.placeholder || props.label && "Select a ".concat(props.label),
    isDisabled: props.isDisabled,
    menuPlacement: props.menuPlacement,
    menuPosition: props.menuPosition
  };
  var SelectComponent = null;
  if (props.creatable && CreatableSelect) {
    //ReactSelect seems to be changing where we can get the component between CreatableSelect and CreatableSelect.default
    //This was probably a one time mistake from ReactSelect but I use this just in case.
    SelectComponent = CreatableSelect["default"] || CreatableSelect;
  } else {
    SelectComponent = Select$1;
  }
  return /*#__PURE__*/React$1.createElement("div", {
    className: "ipa-select"
  }, props.labelProps && /*#__PURE__*/React$1.createElement(ControlLabel, _extends({}, props.labelProps, {
    required: props.required
  })), /*#__PURE__*/React$1.createElement(SelectComponent, selectProps));
};
var highlightOptions = function highlightOptions(keysToHighlight, options) {
  return options.map(function (option) {
    return _objectSpread2(_objectSpread2({}, option), {}, {
      highlight: _$1.defaultTo(keysToHighlight, []).includes(option.key.trim())
    });
  });
};
Select.propTypes = {
  labelProps: shape(_objectSpread2({}, ControlLabel.propTypes)),
  creatable: bool,
  isMulti: bool,
  value: any,
  onChange: func,
  options: array,
  closeMenuOnSelect: func,
  isClearable: bool,
  placeholder: string,
  label: string,
  isDisabled: bool,
  menuPlacement: string,
  menuPosition: string,
  styles: object
};

var loadPlainInitialValueWithScriptedSelectFormat = function loadPlainInitialValueWithScriptedSelectFormat(onChange, plainInitialValue, selectIds) {
  if (plainInitialValue && !_$1.isPlainObject(plainInitialValue)) {
    onChange(_$1.fromPairs(_$1.keys(selectIds).map(function (selectId, i) {
      var correspondingInitialValue = Array.isArray(plainInitialValue) ? plainInitialValue[i] : plainInitialValue;
      return [selectId, [correspondingInitialValue]];
    })));
  }
};

var css_248z$b = ".scripted-selects-control {\n  display: flex;\n  flex-direction: column;\n  margin-bottom: 35px;\n}\n.scripted-selects-control .select-element {\n  width: 90%;\n  margin-bottom: 25px;\n}\n.scripted-selects-control.horizontal {\n  flex-direction: row;\n}\n.scripted-selects-control.compact {\n  margin-bottom: 0;\n}\n.scripted-selects-control.compact .select-element {\n  margin-bottom: 0;\n}\n.scripted-selects-control .select-title {\n  margin: 0 0 10px 10px;\n  text-align: left;\n  font-size: 14px;\n  font-weight: bold;\n  letter-spacing: 0;\n  color: #333333;\n}\n.scripted-selects-control .control-title {\n  margin: 0 0 10px 10px;\n  text-align: left;\n  font-size: 14px;\n  font-weight: bold;\n  letter-spacing: 0;\n  color: #333333;\n  font-size: 16px;\n  margin: 0 0 10px 0;\n}";
styleInject(css_248z$b);

var ScriptedSelects = function ScriptedSelects(_ref) {
  var currentValue = _ref.currentValue,
    onChange = _ref.onChange,
    touched = _ref.touched,
    noFetch = _ref.noFetch,
    compact = _ref.compact,
    horizontal = _ref.horizontal,
    selectOverrideStyles = _ref.selectOverrideStyles,
    onFetch = _ref.onFetch,
    multi = _ref.multi,
    placeholder = _ref.placeholder,
    highlightedOptions = _ref.highlightedOptions,
    isClearable = _ref.isClearable,
    script = _ref.script,
    disabled = _ref.disabled;
  var _useState = useState({}),
    _useState2 = _slicedToArray(_useState, 2),
    selects = _useState2[0],
    setSelects = _useState2[1];
  useEffect(function () {
    var value = currentValue || {};
    var fetchOptions = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
        var selectOptions;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              setSelects({});
              _context.n = 1;
              return ScriptCache.runScript(script);
            case 1:
              selectOptions = _context.v;
              setSelects(_$1.mapValues(selectOptions, function (options) {
                return options === null || options === void 0 ? void 0 : options.sort(function (a, b) {
                  return a.localeCompare(b);
                });
              }));
              loadPlainInitialValueWithScriptedSelectFormat(onChange, value, selectOptions);
            case 2:
              return _context.a(2);
          }
        }, _callee);
      }));
      return function fetchOptions() {
        return _ref2.apply(this, arguments);
      };
    }();
    fetchOptions();
  }, [script, currentValue]);
  var handleChange = function handleChange(selectId, selected) {
    var value = currentValue || {};
    var selectedValues;
    if (!selected || Array.isArray(selected) && !selected.length) {
      var newValue = _objectSpread2(_objectSpread2({}, value), {}, _defineProperty({}, selectId, []));
      onChange(newValue);
    } else {
      selectedValues = selected ? (multi ? selected : [selected]).map(function (opt) {
        return opt.value;
      }) : [];
      onChange(_objectSpread2(_objectSpread2({}, value), {}, _defineProperty({}, selectId, selectedValues)));
    }
  };
  return _$1.isEmpty(selects) ? 'Loading controls...\n' : /*#__PURE__*/React$1.createElement("div", {
    className: clsx("scripted-selects-control", compact && 'compact', horizontal && 'horizontal')
  }, _$1.values(_$1.mapValues(selects, function (options, selectId) {
    var selectValue = _$1.compact((currentValue || {})[selectId]);
    var selectOptions = _$1.compact(asSelectOptions(options));
    selectOptions = highlightOptions(highlightedOptions, selectOptions);
    return /*#__PURE__*/React$1.createElement(Fragment, {
      key: selectId
    }, /*#__PURE__*/React$1.createElement(Select, {
      labelProps: compact ? undefined : {
        text: selectId
      },
      isMulti: multi,
      value: asSelectOptions(selectValue),
      onChange: function onChange(selected) {
        return handleChange(selectId, selected);
      },
      options: selectOptions,
      closeMenuOnSelect: !multi,
      styles: selectOverrideStyles,
      isClearable: isClearable,
      placeholder: placeholder,
      isDisabled: _$1.isEmpty(options) || disabled,
      menuPlacement: "auto",
      menuPosition: "fixed"
    }));
  })), !noFetch && /*#__PURE__*/React$1.createElement(FetchButton, {
    disabled: disabled,
    onClick: onFetch,
    customClasses: touched && !disabled && 'attention'
  }, "Fetch"));
};

var useWithLinkedSelectChange = function useWithLinkedSelectChange(selects, setSelects, currentValue, getSelectedValue, onChange, fetchOptions) {
  var getSubsequentSelects = function getSubsequentSelects(select) {
    return _$1.values(selects).slice(select.index + 1).reduce(function (acc, select) {
      return _objectSpread2(_objectSpread2({}, acc), {}, _defineProperty({}, select.display, select));
    }, {});
  };
  var clearSelectsOptions = function clearSelectsOptions(selectsToBeCleared) {
    var clearedSelects = _$1.mapValues(selectsToBeCleared, function (select) {
      return _objectSpread2(_objectSpread2({}, select), {}, {
        options: []
      });
    });
    setSelects(function (selects) {
      return _objectSpread2(_objectSpread2({}, selects), clearedSelects);
    });
  };
  var handleChange = function handleChange(selectId, selectedOption, select) {
    var selectedValues = selectedOption ? (select.multi ? selectedOption : [selectedOption]).map(function (opt) {
      return getSelectedValue(opt);
    }) : [''];
    var newValue = _objectSpread2(_objectSpread2({}, currentValue), {}, _defineProperty({}, selectId, selectedValues));
    var subsequentSelects = getSubsequentSelects(select);
    onChange(_objectSpread2(_objectSpread2({}, newValue), _$1.mapValues(subsequentSelects, function () {
      return [''];
    })));
    clearSelectsOptions(subsequentSelects);
    if (selectedOption) {
      fetchOptions(select, newValue);
    }
  };
  return [handleChange];
};

var flattenIfNotMulti = function flattenIfNotMulti(selectValues, selects) {
  //This is necessary bc script helper does not handle single-option select values as a list
  return _$1.mapValues(selectValues, function (selectedOptions, selectId) {
    return selects[selectId].multi ? selectedOptions : selectedOptions[0];
  });
};
var ScriptedLinkedSelects = function ScriptedLinkedSelects(_ref) {
  var currentValue = _ref.currentValue,
    onChange = _ref.onChange,
    disabled = _ref.disabled,
    touched = _ref.touched,
    noFetch = _ref.noFetch,
    onFetch = _ref.onFetch,
    selectsConfig = _ref.selects,
    compact = _ref.compact,
    horizontal = _ref.horizontal,
    selectOverrideStyles = _ref.selectOverrideStyles,
    highlightedOptions = _ref.highlightedOptions,
    placeholders = _ref.placeholders,
    _ref$isClearable = _ref.isClearable;
  var _useState = useState(selectsConfig.reduce(function (acc, select, i) {
      return _objectSpread2(_objectSpread2({}, acc), {}, _defineProperty({}, select.display, _objectSpread2(_objectSpread2({}, select), {}, {
        index: i,
        options: []
      })));
    }, {})),
    _useState2 = _slicedToArray(_useState, 2),
    selects = _useState2[0],
    setSelects = _useState2[1];
  var value = currentValue || {};
  useEffect(function () {
    updateFetchOptions();
  }, [currentValue]);
  var getSelectedValue = function getSelectedValue(option) {
    return option.value;
  };
  var updateFetchOptions = /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
      var newSelects, selectKeys, previousSelectValues, i, _currentValue$selectK;
      return _regenerator().w(function (_context) {
        while (1) switch (_context.n) {
          case 0:
            _context.n = 1;
            return fetchOptions(selects);
          case 1:
            newSelects = _context.v;
            if (!currentValue) {
              _context.n = 6;
              break;
            }
            selectKeys = Object.keys(selects);
            previousSelectValues = {};
            i = 1;
          case 2:
            if (!(i < selectKeys.length)) {
              _context.n = 6;
              break;
            }
            if (!((currentValue === null || currentValue === void 0 || (_currentValue$selectK = currentValue[selectKeys === null || selectKeys === void 0 ? void 0 : selectKeys[i - 1]]) === null || _currentValue$selectK === void 0 ? void 0 : _currentValue$selectK.length) > 0)) {
              _context.n = 4;
              break;
            }
            previousSelectValues[selectKeys[i - 1]] = currentValue[selectKeys[i - 1]];
            _context.n = 3;
            return fetchOptions(newSelects, selects[selectKeys[i - 1]], previousSelectValues);
          case 3:
            newSelects = _context.v;
            _context.n = 5;
            break;
          case 4:
            return _context.a(3, 6);
          case 5:
            i++;
            _context.n = 2;
            break;
          case 6:
            return _context.a(2);
        }
      }, _callee);
    }));
    return function updateFetchOptions() {
      return _ref2.apply(this, arguments);
    };
  }();
  var fetchOptions = /*#__PURE__*/function () {
    var _ref3 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(selects, currentSelect, previousSelectsValues) {
      var nextSelect, newSelects, selectOptions;
      return _regenerator().w(function (_context2) {
        while (1) switch (_context2.n) {
          case 0:
            nextSelect = _$1.values(selects)[currentSelect ? currentSelect.index + 1 : 0];
            if (!nextSelect) {
              _context2.n = 2;
              break;
            }
            _context2.n = 1;
            return ScriptCache.runScript(nextSelect.script, previousSelectsValues ? {
              input: flattenIfNotMulti(previousSelectsValues, selects)
            } : undefined);
          case 1:
            selectOptions = _context2.v;
            selectOptions = selectOptions || [];
            newSelects = _objectSpread2(_objectSpread2({}, selects), {}, _defineProperty({}, nextSelect.display, _objectSpread2(_objectSpread2({}, nextSelect), {}, {
              options: selectOptions.sort(function (a, b) {
                return a.localeCompare(b);
              })
            })));
            setSelects(newSelects);
          case 2:
            loadPlainInitialValueWithScriptedSelectFormat(onChange, currentValue, selects);
            return _context2.a(2, newSelects);
        }
      }, _callee2);
    }));
    return function fetchOptions(_x, _x2, _x3) {
      return _ref3.apply(this, arguments);
    };
  }();
  var _useWithLinkedSelectC = useWithLinkedSelectChange(selects, setSelects, value, getSelectedValue, onChange, fetchOptions),
    _useWithLinkedSelectC2 = _slicedToArray(_useWithLinkedSelectC, 1),
    onLinkedSelectChange = _useWithLinkedSelectC2[0];
  var fetchDisabled = !value || _$1.isEmpty(_$1.values(value).flatMap(_$1.identity));
  return /*#__PURE__*/React$1.createElement("div", {
    className: clsx("scripted-selects-control", compact && 'compact', horizontal && 'horizontal')
  }, _$1.values(_$1.mapValues(selects, function (select, selectId) {
    var selectValue = _$1.compact(value[selectId]);
    var selectOptions = _$1.compact(asSelectOptions(select.options));
    if (highlightedOptions !== null && highlightedOptions !== void 0 && highlightedOptions[selectId]) {
      selectOptions = highlightOptions(highlightedOptions[selectId], selectOptions);
    }
    var placeholder = placeholders === null || placeholders === void 0 ? void 0 : placeholders[selectId];
    return /*#__PURE__*/React$1.createElement(Fragment, {
      key: selectId
    }, /*#__PURE__*/React$1.createElement(Select, {
      labelProps: compact ? undefined : {
        text: selectId
      },
      isMulti: select.multi,
      styles: selectOverrideStyles,
      value: asSelectOptions(selectValue),
      onChange: function onChange(selected) {
        return onLinkedSelectChange(selectId, selected, select);
      },
      options: selectOptions,
      placeholder: placeholder,
      closeMenuOnSelect: !select.multi,
      isClearable: true,
      required: select.required,
      isDisabled: _$1.isEmpty(select.options) || disabled,
      menuPlacement: "auto",
      menuPosition: "fixed"
    }));
  })), !noFetch && /*#__PURE__*/React$1.createElement(FetchButton, {
    disabled: fetchDisabled,
    onClick: onFetch,
    customClasses: touched && !fetchDisabled && 'attention'
  }, "Fetch"));
};

var CreatableScriptedSelects = function CreatableScriptedSelects(_ref) {
  var currentValue = _ref.currentValue,
    onChange = _ref.onChange,
    multi = _ref.multi,
    script = _ref.script,
    disabled = _ref.disabled,
    filterInfo = _ref.filterInfo,
    compact = _ref.compact,
    horizontal = _ref.horizontal,
    selectOverrideStyles = _ref.selectOverrideStyles,
    highlightedOptions = _ref.highlightedOptions,
    placeholder = _ref.placeholder,
    _ref$isClearable = _ref.isClearable,
    isClearable = _ref$isClearable === void 0 ? true : _ref$isClearable,
    reloadTrigger = _ref.reloadTrigger;
  var _useState = useState({}),
    _useState2 = _slicedToArray(_useState, 2),
    selects = _useState2[0],
    setSelects = _useState2[1];
  var _useRef = useRef(_$1.debounce(ScriptCache.runScript, 1000, {
      leading: true,
      trailing: true
    })),
    debouncedScriptExecutor = _useRef.current;
  var prevFilterInfo = usePrevious(filterInfo);
  var value = currentValue || {};
  var fetchOptions = /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(filterInfo) {
      var selectOptions, _t;
      return _regenerator().w(function (_context) {
        while (1) switch (_context.n) {
          case 0:
            if (!filterInfo) {
              _context.n = 2;
              break;
            }
            _context.n = 1;
            return debouncedScriptExecutor(script, {
              filterInfo: filterInfo
            });
          case 1:
            _t = _context.v;
            _context.n = 4;
            break;
          case 2:
            _context.n = 3;
            return ScriptCache.runScript(script);
          case 3:
            _t = _context.v;
          case 4:
            selectOptions = _t;
            setSelects(_$1.mapValues(selectOptions, function (options) {
              return options === null || options === void 0 ? void 0 : options.sort(function (a, b) {
                return a.localeCompare(b);
              });
            }));
            loadPlainInitialValueWithScriptedSelectFormat(onChange, value, selectOptions);
          case 5:
            return _context.a(2);
        }
      }, _callee);
    }));
    return function fetchOptions(_x) {
      return _ref2.apply(this, arguments);
    };
  }();
  useEffect(function () {
    fetchOptions();
  }, []);
  useEffect(function () {
    fetchOptions();
  }, [reloadTrigger]);
  useEffect(function () {
    if (filterInfo && !_$1.isEqual(filterInfo, prevFilterInfo)) fetchOptions(filterInfo);
  }, [filterInfo]);
  var handleChange = function handleChange(selectId, selected) {
    //FIXME remove duplication - Maybe create a hook?
    var selectedValues;
    if (!selected || Array.isArray(selected) && !selected.length) {
      var newValue = _objectSpread2(_objectSpread2({}, value), {}, _defineProperty({}, selectId, []));
      onChange(newValue);
    } else {
      //check if a new value has been added and add it to the options
      if (selected.__isNew__) {
        var tempSelects = _$1.cloneDeep(selects);
        tempSelects[selectId].push(selected.value);
        tempSelects[selectId].sort(function (a, b) {
          return a.localeCompare(b);
        });
        setSelects(tempSelects);
      }
      selectedValues = selected ? (multi ? selected : [selected]).map(function (opt) {
        return opt.value;
      }) : [];
      onChange(_objectSpread2(_objectSpread2({}, value), {}, _defineProperty({}, selectId, selectedValues)));
    }
  };
  return _$1.isEmpty(selects) ? 'Loading controls...\n' : /*#__PURE__*/React$1.createElement("div", {
    className: clsx("scripted-selects-control", compact && 'compact', horizontal && 'horizontal')
  }, _$1.values(_$1.mapValues(selects, function (options, selectId) {
    var selectValue = _$1.compact(value[selectId]);
    var selectOptions = _$1.compact(asSelectOptions(options));
    selectOptions = highlightOptions(highlightedOptions, selectOptions);
    return /*#__PURE__*/React$1.createElement(Fragment, {
      key: selectId
    }, /*#__PURE__*/React$1.createElement(Select, {
      labelProps: compact ? undefined : {
        text: selectId
      },
      isMulti: multi,
      value: asSelectOptions(selectValue),
      onChange: function onChange(selected) {
        return handleChange(selectId, selected);
      },
      options: selectOptions,
      closeMenuOnSelect: !multi,
      styles: selectOverrideStyles,
      isClearable: isClearable,
      placeholder: placeholder,
      isDisabled: disabled,
      menuPlacement: "auto",
      creatable: true,
      menuPosition: "fixed"
    }));
  })));
};

var controlsMap = {
  '<<TEXT_SEARCH>>': TextSearch,
  '<<TREE_SEARCH>>': TreeSearch,
  '<<ADVANCED_SEARCH>>': AdvancedSearch,
  '<<SCRIPTED_SELECTS>>': ScriptedSelects,
  '<<SCRIPTED_LINKED_SELECTS>>': ScriptedLinkedSelects,
  '<<CREATABLE_SCRIPTED_SELECTS>>': CreatableScriptedSelects,
  '<<HIERARCHY>>': function HIERARCHY() {
    return /*#__PURE__*/React.createElement("div", {
      style: {
        margin: 10
      }
    }, "Deprecated hierarchy control. Please use Scripted Linked Selects instead");
  } //TODO Remove when fully deprecated
};
var getScriptedSelectQuery = function getScriptedSelectQuery(selector, value) {
  //TODO make this code cleaner
  var op = !!selector.op ? selector.op : "$and";
  var props = Object.keys(value);
  var hasMultiProps = props.length > 1;
  var query = {};
  if (hasMultiProps) {
    query[op] = props.map(function (prop) {
      //check if the selectBy config provides the propName to query
      var selectConfig = _$1.find(selector.selects, {
        display: prop
      });
      var propName = selectConfig && selectConfig.propName ? selectConfig.propName : 'properties.' + prop + '.val';
      var qOption = {};
      if (value[prop].length > 0) {
        qOption[propName] = {
          $in: value[prop]
        };
      }
      return qOption;
    });
  } else {
    //check if the selectBy config provides the propName to query
    var selectConfig = _$1.find(selector.selects, {
      display: props[0]
    });
    var propName = selectConfig && selectConfig.propName ? selectConfig.propName : 'properties.' + props[0] + '.val';
    query[propName] = {
      $in: value[props[0]]
    };
  }
  return query;
};

//Other
var asOptional = function asOptional(object, path) {
  return _$1.isEmpty(_$1.get(object, path)) ? [] : [object];
};
var getTreeSelectQuery = function getTreeSelectQuery(selector, filteringNodes) {
  var _getQueryNodesFor = function getQueryNodesFor(nodeNames) {
    return {
      "$or": _$1.values(_$1.pick(filteringNodes, nodeNames)).map(function (node) {
        return !node.isLeaf ? {
          "$and": [_defineProperty({}, "properties.".concat(selector.treeLevels[node.level].property, ".val"), parseNodeNameWithParent(node.name).childNodeInfo.displayName)].concat(_toConsumableArray(asOptional(_getQueryNodesFor(node.children), "$or")))
        } : _defineProperty({}, "properties.".concat(selector.treeLevels[node.level].property, ".val"), parseNodeNameWithParent(node.name).childNodeInfo.displayName);
      })
    };
  };
  var isNotEmpty = !_$1.isEmpty(filteringNodes);
  var parsedNodes = _$1.mapValues(filteringNodes, parseNode);
  var parsedNodesKeys = _$1.keys(parsedNodes);
  var query = _getQueryNodesFor(parsedNodesKeys);
  return isNotEmpty && query;
};

//It makes sense that the responsibility of knowing how to build a query be *inside* each query control. Probably they
// could actually build the query before calling 'onFetch'. However, such a refactor would be bigger so for now, we're
// just encapsulating controls and their related behavior in this Provider.
var queryBuilders = {
  "<<TEXT_SEARCH>>": function TEXT_SEARCH(value, selector) {
    return {
      $text: {
        $search: value
      }
    };
  },
  "<<ADVANCED_SEARCH>>": function ADVANCED_SEARCH(value, selector) {
    return queryFromFilter(value);
  },
  "<<SCRIPTED_LINKED_SELECTS>>": function SCRIPTED_LINKED_SELECTS(value, selector) {
    return getScriptedSelectQuery(selector, value);
  },
  "<<TREE_SEARCH>>": function TREE_SEARCH(value, selector) {
    return getTreeSelectQuery(selector, value);
  },
  "<<SCRIPTED_SELECTS>>": function SCRIPTED_SELECTS(value, selector) {
    return getScriptedSelectQuery(selector, value);
  },
  "<<ID_SEARCH>>": function ID_SEARCH(value, selector) {
    return {
      _id: {
        $in: value
      }
    };
  }
};
var ControlProvider = {
  getControlComponent: function getControlComponent(selector) {
    return controlsMap[selector === null || selector === void 0 ? void 0 : selector.query];
  },
  getQuery: function getQuery(value, selector) {
    var queryBuilder = queryBuilders[selector.query];
    if (!queryBuilder) console.error("unknown selector query type:", selector.query);
    return queryBuilder(value, selector);
  }
};

var EnhancedFetchControl = /*#__PURE__*/function (_React$Component) {
  function EnhancedFetchControl(props) {
    var _this;
    _classCallCheck(this, EnhancedFetchControl);
    _this = _callSuper(this, EnhancedFetchControl, [props]);
    _this.getSelectors = function () {
      return _this.state.selectorIds.map(function (id) {
        return _this.state.selectorsMap[id];
      });
    };
    _this.setSelectorsMap = function (updatedSelectorsMap) {
      _this.setState({
        selectorsMap: updatedSelectorsMap
      });
    };
    _this.resetSelectorsMap = function (selectors, initialValue) {
      return selectors.reduce(function (accum, selector, i) {
        return _objectSpread2(_objectSpread2({}, accum), {}, _defineProperty({}, i, _objectSpread2(_objectSpread2({}, selector), {}, {
          id: i,
          currentValue: initialValue && (initialValue.id == i || initialValue.id == selector.id) ? initialValue.value : null,
          touched: false
        })));
      }, {});
    };
    _this.keyup = function (e) {
      if (e.key == "Enter" && _this.state.currentSelectorId != -1 && _this.state.selectorsMap[_this.state.currentSelectorId].touched) _this.handleFetch(_this.state.currentSelectorId);
    };
    //value is optional, it can be used to provide a value not yet available in the state.
    _this.handleFetch = function (selectorId, value, state) {
      //The disable props can prevent fetching. 
      // It is especially useful to prevent spontaneous fetching from TreeSearch after it reloads itself. 
      if (_this.props.disable) return;
      var selector = _this.state.selectorsMap[selectorId];
      var newValue = value || selector.currentValue;
      if (_$1.isEmpty(newValue)) {
        newValue = null;
      }
      var newState = state || selector.currentState;
      var newSelector = _objectSpread2(_objectSpread2({}, selector), {}, {
        currentValue: newValue,
        currentState: newState,
        touched: false
      });
      var newSelectors = _objectSpread2(_objectSpread2({}, _this.resetSelectorsMap(_this.props.selectors)), {}, _defineProperty({}, selector.id, newSelector));
      _this.setSelectorsMap(newSelectors);
      _this.props.doFetch(newSelector, newValue);
    };
    _this.renderControl = function (selector, position) {
      var Control = ControlProvider.getControlComponent(selector);
      var handleChange = function handleChange(newValue) {
        _this.setState({
          currentSelectorId: selector.id
        });
        _this.setSelectorsMap(_objectSpread2(_objectSpread2({}, _this.state.selectorsMap), {}, _defineProperty({}, selector.id, _objectSpread2(_objectSpread2({}, selector), {}, {
          currentValue: newValue,
          touched: true
        }))));
      };
      if (!Control) return /*#__PURE__*/React$1.createElement("div", null, "Unknown control");
      return /*#__PURE__*/React$1.createElement("div", {
        key: selector.id,
        onKeyUp: _this.keyup
      }, position !== 0 && /*#__PURE__*/React$1.createElement(OrDivider, null), /*#__PURE__*/React$1.createElement(Control, _extends({}, selector, {
        onChange: handleChange,
        onFetch: function onFetch(event, value, state) {
          return _this.handleFetch(selector.id, value, state);
        },
        currentValue: selector.currentValue,
        currentState: selector.currentState,
        disable: _this.props.disable //Its not useful yet but might be for some Controls in the future.
        ,
        reloadToken: _this.props.reloadToken
      })));
    };
    _this.state = _this.getInitialState();
    return _this;
  }
  _inherits(EnhancedFetchControl, _React$Component);
  return _createClass(EnhancedFetchControl, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      var selectorsChanged = !_$1.isEqual(_$1.sortBy(prevProps.selectors), _$1.sortBy(this.props.selectors));
      if (selectorsChanged) {
        this.setState(this.getInitialState());
      }
      var shouldClearSelectorsValues = !_$1.isEqual(prevProps.shouldClearToken, this.props.shouldClearToken);
      if (shouldClearSelectorsValues) {
        this.setState(this.getInitialState());
      }
    }
  }, {
    key: "getInitialState",
    value: function getInitialState() {
      return {
        currentSelectorId: -1,
        selectorsMap: this.resetSelectorsMap(this.props.selectors, this.props.initialValue),
        selectorIds: this.props.selectors.map(function (_, i) {
          return i;
        })
      };
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/React$1.createElement("div", {
        className: "enhanced-fetch-control"
      }, this.getSelectors().map(this.renderControl));
    }
  }]);
}(React$1.Component);

var GroupControl = function GroupControl(_ref) {
  var selected = _ref.selected,
    styles = _ref.styles,
    groups = _ref.groups,
    onChange = _ref.onChange;
  var _useState = useState(selected || []),
    _useState2 = _slicedToArray(_useState, 2),
    value = _useState2[0],
    setValue = _useState2[1];
  useEffect(function () {
    setValue(selected || []);
  }, [selected]);
  var _onChange = function _onChange(selections) {
    if (selections) {
      onChange(selections.map(function (o) {
        return o.value;
      }));
      setValue(selections.map(function (o) {
        return o.value;
      }));
    } else {
      onChange([]);
      setValue([]);
    }
  };
  return /*#__PURE__*/React$1.createElement(Select$1, {
    onChange: _onChange,
    styles: styles,
    placeholder: "Select group",
    options: groups.map(function (g) {
      return {
        label: g,
        value: g
      };
    }),
    value: selected ? selected.map(function (s) {
      return {
        value: s,
        label: s
      };
    }) : value.map(function (s) {
      return {
        value: s,
        label: s
      };
    }),
    isMulti: true,
    isClearable: true,
    isSearchable: true
  });
};
var GroupControl$1 = /*#__PURE__*/React$1.memo(GroupControl);

var LAST_SELECTED_GROUP_KEY = "lastSelectedGroup";
var PROJECT_ID_KEY = 'ipaSelectedProjectId';
var GROUP_SELECT_STYLES = {
  control: function control(styles) {
    return _objectSpread2(_objectSpread2({}, styles), {}, {
      width: '90%',
      margin: '10px 0'
    });
  },
  container: function container(styles) {
    return _objectSpread2(_objectSpread2({}, styles), {}, {
      display: 'block',
      width: '90%'
    });
  }
};
var FILTER_SELECT_STYLES$1 = {
  control: function control(styles) {
    return _objectSpread2(_objectSpread2({}, styles), {}, {
      width: '100%',
      margin: '10px 0'
    });
  },
  container: function container(styles) {
    return _objectSpread2(_objectSpread2({}, styles), {}, {
      display: 'block',
      width: '100%',
      marginBottom: '0px'
    });
  }
};
var TreeSelectMode = {
  NONE_MEANS_ALL: "noneMeansAll",
  NONE_MEANS_NONE: "noneMeansNone"
};
var EntitySelectionPanel = /*#__PURE__*/function (_React$Component) {
  function EntitySelectionPanel(props) {
    var _this;
    _classCallCheck(this, EntitySelectionPanel);
    _this = _callSuper(this, EntitySelectionPanel, [props]);
    _this.filtersChanged = function (filters) {
      _this.props.onGroupOrFilterChange({
        filters: filters
      });
    };
    _this.groupsChanged = function (groups) {
      _this.props.onGroupOrFilterChange({
        groups: groups
      });
    };
    _this.onSelectLeaves = function (leaves) {
      var selection = [];
      if (leaves.length == 0 && _this.props.treeSelectMode === TreeSelectMode.NONE_MEANS_ALL) {
        selection = getFilteredEntitiesBy(_this.props.entities, getSelectedFilters(_this.props));
      } else {
        leaves.forEach(function (el) {
          selection.push(_this.props.entities.find(function (e) {
            return e._id == el.dataset.nodeId;
          }));
        });
      }
      _this.onSelectEntities(selection);
    };
    _this.onSelectEntities = function (entities) {
      if (_this.props.onSelect) {
        _this.props.onSelect(entities);
      }
    };
    _this.onSelectIds = function (entityIds) {
      if (_this.props.onSelect) {
        _this.props.onSelect(_this.props.entities.filter(function (e) {
          return entityIds.includes(e._id);
        }));
      }
    };
    _this.onSelectAll = function () {
      _this.onSelectEntities(getFilteredEntitiesBy(_this.props.entities, getSelectedFilters(_this.props)));
    };
    _this.getAvailableGroupValues = function () {
      var nonGroupableProperties = _this.props.nonGroupableProperties || [];
      return _this.state.uniquePropNames.filter(function (p) {
        return !nonGroupableProperties.includes(p);
      });
    };
    _this.getSelectedIds = _$1.memoize(function (_selectedEntities) {
      return _$1.map(_selectedEntities, function (e) {
        return e._id;
      });
    });
    _this.state = {
      entities: [],
      tree: {},
      numFilteredEntities: _this.props.entities.length,
      numEntities: _this.props.entities.length
      //removed props-to-state copy of filters and groups 
      // we now compute them as derived props (getSelectedGroups and getSelectedFilters)
    };
    return _this;
  }
  _inherits(EntitySelectionPanel, _React$Component);
  return _createClass(EntitySelectionPanel, [{
    key: "getLastSelectedGroupsFromSessionStorage",
    value: function getLastSelectedGroupsFromSessionStorage(entitySingular) {
      var stringifiedGroups = sessionStorage.getItem(LAST_SELECTED_GROUP_KEY + entitySingular + sessionStorage.getItem(PROJECT_ID_KEY));
      var groups;
      if (stringifiedGroups === '') {
        groups = [];
      } else if (stringifiedGroups !== null) {
        groups = stringifiedGroups.split(',');
      } else {
        groups = getInitialGroups(this.props);
      }
      return groups;
    }

    //we check for groups state in sessionStorage and initialize the state with it
  }, {
    key: "loadGroups",
    value: function loadGroups() {
      var groups = this.getLastSelectedGroupsFromSessionStorage(this.props.entitySingular);
      var initialGroups = [];
      if (groups) {
        //we found saved groups state
        initialGroups = _toConsumableArray(groups); //notify parent component
      } else {
        initialGroups = getInitialGroups(this.props);
      }
      this.groupsChanged(initialGroups);
    }
  }, {
    key: "saveGroups",
    value: function saveGroups(props) {
      var groupsToSave = props.selectedGroups;
      var projectId = sessionStorage.getItem(PROJECT_ID_KEY);
      sessionStorage.setItem(LAST_SELECTED_GROUP_KEY + props.entitySingular + projectId, groupsToSave);
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.loadGroups();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.saveGroups(this.props);
    }

    // Since EntitySelectionPanel does not unmount when changing from Assets to Spaces in the NewNavigator, 
    // we also save the previous groups if the entity type changes, and load the new groups
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.entitySingular !== this.props.entitySingular) {
        this.saveGroups(prevProps);
        this.loadGroups(this.props);
      }
    }

    //FIXME Remove this props-to-state copy
  }, {
    key: "render",
    value: function render() {
      if (this.props.fetching || !this.props.entities || this.props.entities.length == 0) {
        return /*#__PURE__*/React$1.createElement("div", {
          className: "entity-tree-panel"
        }, /*#__PURE__*/React$1.createElement("div", {
          className: "centered"
        }, this.props.fetching ? "Retrieving data" : "No data"));
      }
      var countMessage = this.state.numFilteredEntities == this.state.numEntities ? /*#__PURE__*/React$1.createElement("span", null, this.state.numEntities, " ", this.state.numEntities == 1 ? this.props.entitySingular : this.props.entityPlural) : /*#__PURE__*/React$1.createElement("span", null, /*#__PURE__*/React$1.createElement("b", null, this.state.numFilteredEntities), " of ", this.state.numEntities, " Fetched ", this.state.numEntities == 1 ? this.props.entitySingular : this.props.entityPlural);
      var allSelected = this.state.numFilteredEntities === this.props.selectedEntities.length;
      var selectedFilters = getSelectedFilters(this.props);
      return /*#__PURE__*/React$1.createElement("div", {
        className: "entity-tree-panel"
      }, /*#__PURE__*/React$1.createElement("label", {
        className: "title"
      }, "Group By"), /*#__PURE__*/React$1.createElement(GroupControl$1, {
        className: "entity-group",
        entitySingular: this.props.entitySingular,
        styles: GROUP_SELECT_STYLES,
        groups: this.getAvailableGroupValues(),
        selected: this.props.selectedGroups,
        onChange: this.groupsChanged
      }), /*#__PURE__*/React$1.createElement("label", {
        className: "title"
      }, "Filter By"), /*#__PURE__*/React$1.createElement(FilterControl, {
        className: "entities-filter entities-filter--with-count",
        entitySingular: this.props.entitySingular,
        styles: FILTER_SELECT_STYLES$1,
        filters: selectedFilters,
        availableFilters: this.state.availableFilters,
        onChange: this.filtersChanged
      }), /*#__PURE__*/React$1.createElement("div", {
        className: "entity-count"
      }, /*#__PURE__*/React$1.createElement("span", null, countMessage)), /*#__PURE__*/React$1.createElement(FancyTreeControl, {
        className: "entity-tree",
        name: this.props.name + "_tree",
        selectedGroups: this.props.selectedGroups,
        renderLeafNode: this.props.leafNodeRenderer,
        renderBranchNode: this.props.branchNodeRenderer,
        onSelect: this.onSelectLeaves,
        onSelectAll: this.onSelectAll,
        onSelectNone: this.onSelectIds,
        onSelectIds: this.onSelectIds,
        selectedIds: this.getSelectedIds(this.props.selectedEntities),
        allSelected: allSelected,
        treeSelectMode: this.props.treeSelectMode,
        tree: this.state.tree
      }));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(props, state) {
      var derivedState = _objectSpread2({}, state);
      derivedState.uniquePropNames = getUniquePropNames(props.entities);
      derivedState.availableFilters = getAvailableFilterValues(props.entities, derivedState.uniquePropNames, props.nonFilterableProperties);
      var _makeTree = makeTree(props),
        tree = _makeTree.tree,
        numFilteredEntities = _makeTree.numFilteredEntities;
      derivedState.tree = tree;
      derivedState.numFilteredEntities = numFilteredEntities;
      derivedState.entities = props.entities;
      derivedState.numEntities = props.entities.length;
      return derivedState;
    }
  }]);
}(React$1.Component);
var getUniquePropNames = function getUniquePropNames(entities) {
  var uniquePropNames = new Set();
  entities.forEach(function (a) {
    return Object.keys(a.properties || {}).reduce(function (s, e) {
      return s.add(e);
    }, uniquePropNames);
  });
  var result = _toConsumableArray(uniquePropNames);
  result.sort();
  return result;
};
var getAvailableFilterValues = function getAvailableFilterValues(entities, uniquePropNames, nonFilterableProps) {
  var nonFilterableProperties = nonFilterableProps || [];
  var availableFilters = {};
  uniquePropNames.filter(function (p) {
    return !nonFilterableProperties.includes(p);
  }).forEach(function (p) {
    var uniquePropValues = new Set();
    entities.forEach(function (a) {
      if (a.properties) {
        if (a.properties[p]) {
          uniquePropValues.add(a.properties[p].val ? a.properties[p].val : "_empty_");
          availableFilters[p] = {
            type: a.properties[p].type
          };
        }
      }
    });
    availableFilters[p].values = _toConsumableArray(uniquePropValues);
  });
  availableFilters["Entity Name"] = {
    values: entities.map(function (e) {
      return e['Entity Name'];
    }),
    type: "text"
  };
  return availableFilters;
};
var getInitialGroups = function getInitialGroups(props) {
  var groups = [];
  if (!_$1.isEmpty(props.selectedGroups)) {
    groups = _toConsumableArray(props.selectedGroups);
  } else if (props.defaultGroups) {
    groups = _toConsumableArray(props.defaultGroups);
  }
  return groups;
};
var getSelectedFilters = function getSelectedFilters(props) {
  var filters = {};
  if (!_$1.isEmpty(props.selectedFilters)) {
    filters = props.selectedFilters;
  } else if (props.defaultFilters) {
    filters = props.defaultFilters;
  }
  return filters;
};
var makeTree = function makeTree(props, state) {
  var filteredEntities = getFilteredEntitiesBy(props.entities, getSelectedFilters(props));
  var numFilteredEntities = filteredEntities.length;
  var tree = {};
  var groups = props.selectedGroups;
  if (groups && groups.length) tree = _nestedGroup(filteredEntities, groups, function (a, p) {
    return a.properties[p] ? a.properties[p].val : null;
  });else tree = filteredEntities;
  return {
    tree: tree,
    numFilteredEntities: numFilteredEntities
  };
};

var fancyTreeControlSelectAllReducer = function fancyTreeControlSelectAllReducer(state, action) {
  switch (action.type) {
    case 'select_all':
      return _objectSpread2(_objectSpread2({}, state), {}, {
        selectAllActivated: true,
        previouslySelectedIds: action.previouslySelectedIds || []
      });
    default:
      return _objectSpread2(_objectSpread2({}, state), {}, {
        selectAllActivated: false,
        previouslySelectedIds: action.previouslySelectedIds || []
      });
  }
};
var initialSelectAllState = {
  selectAllActivated: false,
  previouslySelectedIds: []
};

/**
 * @Deprecated, use {@link ./ReactiveTreeControl} instead
 */
//FIXME 1)This component shouldn't be mutating dom nodes manually. It is dangerous (in a React app) and hard to reason about
var FancyTreeControl = function FancyTreeControl(_ref) {
  var name = _ref.name,
    tree = _ref.tree,
    renderBranchNode = _ref.renderBranchNode,
    renderLeafNode = _ref.renderLeafNode,
    onSelect = _ref.onSelect,
    _ref$selectedIds = _ref.selectedIds,
    selectedIds = _ref$selectedIds === void 0 ? [] : _ref$selectedIds,
    onSelectAll = _ref.onSelectAll,
    onSelectNone = _ref.onSelectNone,
    onSelectIds = _ref.onSelectIds,
    _ref$singleSelect = _ref.singleSelect,
    allSelected = _ref.allSelected,
    treeSelectMode = _ref.treeSelectMode,
    onGroupSelect = _ref.onGroupSelect,
    selectedGroups = _ref.selectedGroups,
    _ref$onExpand = _ref.onExpand,
    onExpand = _ref$onExpand === void 0 ? _$1.noop : _ref$onExpand,
    _ref$selectedNodeName = _ref.selectedNodeNames,
    selectedNodeNames = _ref$selectedNodeName === void 0 ? [] : _ref$selectedNodeName,
    _ref$expandedNodeName = _ref.expandedNodeNames,
    expandedNodeNames = _ref$expandedNodeName === void 0 ? [] : _ref$expandedNodeName,
    _ref$partialNodeNames = _ref.partialNodeNames,
    partialNodeNames = _ref$partialNodeNames === void 0 ? [] : _ref$partialNodeNames;
  var _useReducer = useReducer(fancyTreeControlSelectAllReducer, initialSelectAllState),
    _useReducer2 = _slicedToArray(_useReducer, 2),
    selectAllState = _useReducer2[0],
    dispatch = _useReducer2[1];
  var treeDOMRef = useRef();
  var onSelectAllAction = useCallback(function () {
    dispatch({
      type: 'select_all',
      previouslySelectedIds: selectedIds
    }); //set selectAllState before onSelectAll
    if (onSelectAll) {
      onSelectAll();
    }
  }, [onSelectAll, selectedIds]);
  var onUndoSelectAllAction = useCallback(function () {
    if (onSelectIds) {
      onSelectIds(selectAllState.previouslySelectedIds);
    }
    dispatch({
      type: 'undo'
    }); //clear selectAllState after onSelect
  }, [onSelectIds, selectAllState]);
  var onSelectNoneAction = useCallback(function () {
    if (onSelectNone) {
      onSelectNone([]);
    }
  }, [onSelectNone]);
  useEffect(function () {
    // If all items are selected, ensure the tree displays accordingly. This effect should no longer be necessary nor correct once FIXME number 1) is addressed
    var treeDOM = treeDOMRef.current;
    if (allSelected) {
      if (treeSelectMode === TreeSelectMode.NONE_MEANS_ALL) {
        //And all means none so we deselect everything
        var selectedNodes = treeDOM.querySelectorAll("li.selected");
        Array.from(selectedNodes).forEach(function (s) {
          return s.classList.remove("selected");
        });
      } else if (treeSelectMode === TreeSelectMode.NONE_MEANS_NONE) {
        //And all means all so we select everything
        var deselectedNodes = treeDOM.querySelectorAll("li:not(.selected)");
        Array.from(deselectedNodes).forEach(function (s) {
          return s.classList.add("selected");
        });
      }
    }
  }, [allSelected, treeSelectMode]);
  useEffect(function () {
    // If there are no selected items, ensure the tree displays accordingly. This effect should no longer be necessary nor correct once FIXME number 1) is addressed
    var treeDOM = treeDOMRef.current;
    if (_$1.isEmpty(selectedIds) && _$1.isEmpty(selectedNodeNames)) {
      var _allSelected = treeDOM.querySelectorAll("li.selected");
      Array.from(_allSelected).forEach(function (s) {
        return s.classList.remove("selected");
      });
    }
  }, [selectedIds]);
  useEffect(function () {
    establishTreeBranchClasses();
  }, [selectedIds, selectedGroups]);
  if (!tree) return null;
  //let treeDOM

  var expandBranch = function expandBranch(e, nodeName, nodeValue) {
    var el = e.target;
    e.stopPropagation();
    while (el.tagName != "LI") el = el.parentElement;
    el.classList.toggle("expanded"), onExpand(nodeName, nodeValue);
  };
  var establishTreeBranchClasses = function establishTreeBranchClasses() {
    var treeDOM = treeDOMRef.current;
    var allBranches = treeDOM.querySelectorAll("li.branch");
    Array.from(allBranches).forEach(function (br) {
      var branchLeaves = br.querySelectorAll("li.leaf");
      var branchSelectedLeaves = br.querySelectorAll("li.leaf.selected");
      if (branchSelectedLeaves.length == 0) {
        br.classList.remove("selected");
        br.classList.remove("partial");
      } else if (branchLeaves.length == branchSelectedLeaves.length) {
        br.classList.remove("partial");
        br.classList.add("selected");
      } else if (branchLeaves.length > branchSelectedLeaves.length) {
        br.classList.remove("selected");
        br.classList.add("partial");
      }
    });
  };
  var selectNode = function selectNode(e, nodeName, nodeValue) {
    var treeDOM = treeDOMRef.current;
    var el = e.target;
    if (el.classList.contains("branch-expander")) {
      return;
    }
    while (el.tagName != "LI") {
      el = el.parentElement;
    }
    e.stopPropagation();

    //before toggle, gather previously selected
    var previouslySelectedIds = _toConsumableArray(treeDOM.querySelectorAll("li.leaf.selected")).map(function (li) {
      return li.dataset.nodeId;
    });
    el.classList.toggle("selected");
    if (el.classList.contains("branch")) {
      var branchLeaves = Array.from(el.querySelectorAll("li"));
      if (el.classList.contains("selected")) branchLeaves.forEach(function (ell) {
        return ell.classList.add("selected");
      });else branchLeaves.forEach(function (ell) {
        return ell.classList.remove("selected");
      });
    }
    establishTreeBranchClasses();
    if (onSelect) {
      var _allSelected2 = treeDOM.querySelectorAll("li.leaf.selected");
      onSelect(_toConsumableArray(_allSelected2), nodeName, nodeValue, _$1.isArray(nodeValue), el.classList.contains("selected"));
      dispatch({
        type: 'nodeSelected',
        previouslySelectedIds: previouslySelectedIds
      });
    }
  };
  var _getNodes = function getNodes(nodes, depth) {
    if (!nodes) return;
    var children;
    if (Array.isArray(nodes)) {
      children = nodes.map(function (n) {
        var cn = "leaf";
        if ((/*tree.length != selectedIds.length &&*/selectedIds.includes(n._id)) || selectedNodeNames.includes(n.name)) cn += " selected";
        if (expandedNodeNames.includes(n.name)) cn += " expanded";
        if (partialNodeNames.includes(n.name)) cn += " partial";
        return /*#__PURE__*/React$1.createElement("li", {
          onClick: function onClick(e) {
            return selectNode(e, n.name, n);
          },
          key: n._id || n.name,
          "data-node-id": n._id,
          className: cn
        }, /*#__PURE__*/React$1.createElement("a", null, /*#__PURE__*/React$1.createElement("span", null, renderLeafNode(n))));
      });
    } else {
      children = [];
      Object.entries(nodes).forEach(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
          nodeName = _ref3[0],
          nodeValue = _ref3[1];
        children.push(/*#__PURE__*/React$1.createElement("li", {
          className: clsx('branch', selectedNodeNames.includes(nodeName) && "selected", expandedNodeNames.includes(nodeName) && "expanded", partialNodeNames.includes(nodeName) && "partial"),
          onClick: function onClick(e) {
            return selectNode(e, nodeName, nodeValue);
          },
          key: nodeName,
          "data-branch-name": nodeName
        }, /*#__PURE__*/React$1.createElement("a", null, /*#__PURE__*/React$1.createElement("span", null, /*#__PURE__*/React$1.createElement("i", {
          className: "fa fa-angle-down branch-expander",
          onClick: function onClick(e) {
            return expandBranch(e, nodeName, nodeValue);
          }
        }), renderBranchNode ? renderBranchNode(nodeName, nodeValue) : nodeName)), /*#__PURE__*/React$1.createElement("ul", {
          key: nodeName + "_children"
        }, _getNodes(nodeValue))));
      });
    }
    return children;
  };
  return /*#__PURE__*/React$1.createElement("div", {
    className: "fancy-tree",
    ref: treeDOMRef /*ref={el=>treeDOM=el}*/
  }, onSelectAll ? /*#__PURE__*/React$1.createElement("div", {
    className: "fancy-tree__count"
  }, /*#__PURE__*/React$1.createElement("span", null, "Refined: ".concat(selectedIds.length)), !allSelected ? /*#__PURE__*/React$1.createElement("span", {
    className: "fancy-tree__count--action",
    onClick: onSelectAllAction
  }, "Select All") : onSelectNoneAction ? /*#__PURE__*/React$1.createElement("span", {
    className: "fancy-tree__count--action",
    onClick: onSelectNoneAction
  }, "Deselect All") : undefined, selectAllState.selectAllActivated && selectAllState.previouslySelectedIds.length > 0 ? /*#__PURE__*/React$1.createElement("span", {
    className: "fancy-tree__count--action",
    onClick: onUndoSelectAllAction
  }, "Undo") : undefined) : undefined, /*#__PURE__*/React$1.createElement("ul", null, _getNodes(tree)));
};

var getColoredAxis = function getColoredAxis(color) {
  return {
    // making the background transparent
    background: "rgba(255, 255, 255, 0)",
    axis: {
      ticks: {
        line: {
          stroke: color
        },
        text: {
          fill: color
        }
      },
      legend: {
        text: {
          fill: color
        }
      }
    }
  };
};
var TwoAxisLineChart = function TwoAxisLineChart(_ref) {
  var data = _ref.data,
    line1 = _ref.line1,
    line2 = _ref.line2;
  console.log(data, line1, line2);
  var _useState = useState({}),
    _useState2 = _slicedToArray(_useState, 2),
    graphContainerStyle = _useState2[0],
    setGraphContainerStyle = _useState2[1];
  useEffect(function () {
    /* 
     * this is dumb but we have to do it this way as far as I can tell
     * if we simply apply these styles on graphContainer from the start the charts
     * do not correctly overlay each other. One chart will always be slightly
     * wider than the other. However if we let the two charts render, then update
     * the styles when the data prop udpates, the two charts line up nicely
    */

    setGraphContainerStyle({
      position: 'absolute',
      width: '100%'
    });
  }, [data]);
  var SecondGraph = function SecondGraph() {
    var line1DataForTooltip = data.line1.filter(function (d) {
      return d.id === line1.displayInTooltip;
    });
    var line2DataForTooltip = data.line2.filter(function (d) {
      return d.id === line2.displayInTooltip;
    });
    return /*#__PURE__*/React$1.createElement(ResponsiveLine, _extends({}, line2, {
      data: data.line2,
      margin: {
        top: 50,
        right: 50,
        bottom: 50,
        left: 50
      },
      axisRight: {
        legend: line2.axisLabel,
        legendPosition: line2.axisLabelPosition,
        legendOffset: 40
      },
      axisLeft: null,
      axisTop: null,
      enableGridY: false,
      axisBottom: null,
      theme: getColoredAxis(line2.colors[0])
      /* Add this for tooltip */,
      useMesh: true,
      enableSlices: "x",
      sliceTooltip: function sliceTooltip(_ref2) {
        var slice = _ref2.slice;
        var slicePoints = slice.points.filter(function (sp) {
          return sp.serieId === line1.displayInTooltip || sp.serieId === line2.displayInTooltip;
        });
        return /*#__PURE__*/React$1.createElement("div", {
          style: {
            background: "white",
            padding: "9px 12px",
            border: "1px solid #ccc"
          }
        }, /*#__PURE__*/React$1.createElement("div", null, "\"", slicePoints[0].data.x, "\""), slicePoints.map(function (point) {
          return /*#__PURE__*/React$1.createElement("div", {
            key: point.id
          }, /*#__PURE__*/React$1.createElement("div", {
            style: {
              color: line1.colors[0],
              padding: "3px 0"
            }
          }, /*#__PURE__*/React$1.createElement("strong", null, line1DataForTooltip[0].id), " [", line1DataForTooltip[0].data[point.index].y, "]"), /*#__PURE__*/React$1.createElement("div", {
            style: {
              color: line2.colors[0],
              padding: "3px 0"
            }
          }, /*#__PURE__*/React$1.createElement("strong", null, line2DataForTooltip[0].id), " [", line2DataForTooltip[0].data[point.index].y, "]"));
        }));
      }
    }));
  };
  return /*#__PURE__*/React$1.createElement("div", {
    className: "wrapper"
  }, /*#__PURE__*/React$1.createElement("div", {
    className: "graphContainer",
    style: graphContainerStyle
  }, /*#__PURE__*/React$1.createElement(ResponsiveLine, _extends({}, line1, {
    data: data.line1,
    layers: ["grid", "markers", "axes", "lines", "legends"],
    axisLeft: {
      legend: line1.axisLabel,
      legendPosition: line1.axisLabelPosition,
      legendOffset: -40
    },
    yScale: {
      type: line1.yScale.type,
      min: line1.yScale.min,
      max: line1.yScale.max
    },
    theme: getColoredAxis(line1.colors[0]),
    margin: {
      top: 50,
      right: 50,
      bottom: 50,
      left: 50
    }
  }))), /*#__PURE__*/React$1.createElement("div", {
    className: "secondGraph"
  }, /*#__PURE__*/React$1.createElement(SecondGraph, null)));
};

var getPercent = function getPercent(datum, data) {
  var total = data.reduce(function (tot, d) {
    return tot += d.value;
  }, 0);
  return Math.round(100 * (datum.value / total));
};
var addTitle = function addTitle(title) {
  return /*#__PURE__*/React$1.createElement("h1", {
    key: getRandomString("ice-title-"),
    style: {
      position: "absolute",
      width: "100%",
      textAlign: "center"
    }
  }, title);
};
var addCenterLabel = function addCenterLabel(config, data) {
  var datum = data.find(function (d) {
    return d.id == config.id;
  });
  var label = config.label;
  var value = datum ? getPercent(datum, data) + "%" : "N/A";
  return /*#__PURE__*/React$1.createElement("div", {
    key: getRandomString("ice-center-label-"),
    style: {
      position: "absolute",
      width: "100%",
      height: "100%"
    }
  }, /*#__PURE__*/React$1.createElement("div", {
    style: _objectSpread2({
      position: "absolute",
      textAlign: config.textAlign || "center",
      height: "40%",
      width: "100%",
      top: "36%"
    }, config.extraStyle || {})
  }, /*#__PURE__*/React$1.createElement("div", {
    style: _objectSpread2({
      fontSize: config.valueFontSize || "50px",
      lineHeight: 1
    }, config.extraValueStyle || {})
  }, value), /*#__PURE__*/React$1.createElement("div", {
    style: _objectSpread2({
      fontSize: config.labelFontSize || "16px"
    }, config.extraLabelStyle || {})
  }, label)));
};
var EXTENSIONS = {
  iceTitle: addTitle,
  iceCenterItem: addCenterLabel
};
var getChartExtensions = function getChartExtensions(chartConfig, data) {
  var exConfigKeys = Object.keys(chartConfig).filter(function (k) {
    return k.startsWith("ice");
  });
  var extensions = exConfigKeys.map(function (x) {
    return EXTENSIONS[x](chartConfig[x], data);
  });
  return extensions;
};

var standard = function standard(dataIn) {
  return _$1.entries(dataIn).map(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
      k = _ref2[0],
      v = _ref2[1];
    return {
      id: k,
      label: k,
      value: v
    };
  });
};
var line = function line(dataIn) {
  return _$1.entries(dataIn).map(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 2),
      k = _ref4[0],
      v = _ref4[1];
    return {
      id: k,
      data: _$1.entries(v).map(function (_ref5) {
        var _ref6 = _slicedToArray(_ref5, 2),
          x = _ref6[0],
          y = _ref6[1];
        return {
          x: x,
          y: y
        };
      })
    };
  });
};
var CHART_GLOBALS = {
  margin: {
    top: 40,
    right: 40,
    bottom: 40,
    left: 40
  },
  colors: ["#C71784", "#00A693", "#FF99F1", "#58f5e3", "#83004B"]
};
var CHARTS = {
  "Donut": {
    component: ResponsivePie,
    defaultConfig: {
      innerRadius: 0.75
    },
    translate: standard
  },
  "Bar": {
    component: ResponsiveBar,
    translate: standard
  },
  "Line": {
    component: ResponsiveLine,
    translate: line
  },
  "TwoAxisLine": {
    component: TwoAxisLineChart
  }
};
var ScriptedChart = function ScriptedChart(_ref7) {
  var script = _ref7.script,
    scriptArgs = _ref7.scriptArgs,
    chart = _ref7.chart,
    chartConfig = _ref7.chartConfig,
    onClick = _ref7.onClick,
    scriptedData = _ref7.scriptedData,
    style = _ref7.style;
  if (!script && !scriptedData || !chart) return /*#__PURE__*/React$1.createElement("div", null, "Select data and chart type...");
  var _useState = useState("fetching"),
    _useState2 = _slicedToArray(_useState, 2),
    chartData = _useState2[0],
    setChartData = _useState2[1];
  useEffect(function () {
    var loadData = /*#__PURE__*/function () {
      var _ref8 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
        var _t, _t2;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              setChartData("fetching");
              _t = setChartData;
              _t2 = scriptedData;
              if (_t2) {
                _context.n = 2;
                break;
              }
              _context.n = 1;
              return ScriptHelper.executeScript(script, scriptArgs);
            case 1:
              _t2 = _context.v;
            case 2:
              _t(_t2);
            case 3:
              return _context.a(2);
          }
        }, _callee);
      }));
      return function loadData() {
        return _ref8.apply(this, arguments);
      };
    }();
    loadData();
  }, [script, chart]);
  var component = /*#__PURE__*/React$1.createElement("div", null, "Loading");
  var extensions = null;
  if (chartData != "fetching") {
    var ci = CHARTS[chart];
    var Chart = ci.component;

    //the chart data script can return just data, or can return data and other chart settings
    //if other chart data is returned then we get the data from chartData.data
    //and we pass along everything but the data to the chart component as otherData
    //if chartData.data is provided we do not translate the data so it needs to be in the correct form
    var data = !(chartData !== null && chartData !== void 0 && chartData.data) && ci.translate ? ci.translate(chartData) : chartData !== null && chartData !== void 0 && chartData.data ? chartData.data : chartData;
    var otherData = chartData !== null && chartData !== void 0 && chartData.data ? _$1.omit(chartData, ['data']) : {};
    component = /*#__PURE__*/React$1.createElement(Chart, _extends({
      data: data
    }, otherData, {
      style: {
        border: "dashed gray 1px"
      }
    }, CHART_GLOBALS, ci.defaultConfig, chartConfig));
    extensions = getChartExtensions(chartConfig, data);
  }
  return /*#__PURE__*/React$1.createElement("div", {
    className: "scripted-chart",
    style: _objectSpread2({
      position: "relative"
    }, style)
  }, extensions, component);
};
var ScriptedChartFactory = {
  create: function create(_ref9) {
    var config = _ref9.config,
      data = _ref9.data;
    return /*#__PURE__*/React$1.createElement(ScriptedChart, _extends({}, config, {
      scriptedData: data
    }));
  }
};

var css_248z$c = "/**\n * ****************************************************************************\n *\n * INVICARA INC CONFIDENTIAL __________________\n *\n * Copyright (C) [2012] - [2018] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA\n * PVT LTD All Rights Reserved.\n *\n * NOTICE: All information contained herein is, and remains the property of\n * Invicara Inc and its suppliers, if any. The intellectual and technical\n * concepts contained herein are proprietary to Invicara Inc and its suppliers\n * and may be covered by U.S. and Foreign Patents, patents in process, and are\n * protected by trade secret or copyright law. Dissemination of this information\n * or reproduction of this material is strictly forbidden unless prior written\n * permission is obtained from Invicara Inc.\n */\n.mbsc-form {\n  padding: 0 10% !important;\n}\n\n.mbsc-form,\n.mbsc-form-group-title,\n.mbsc-divider {\n  background: white !important;\n  border-bottom: none !important;\n}\n\n.mbsc-form-group-title {\n  font-size: 1.5rem !important;\n  padding: 1% 0 !important;\n}\n\n.mbsc-input {\n  display: block !important;\n}\n\n.mbsc-input input,\n.mbsc-textarea textarea {\n  border-radius: 0.5rem !important;\n  padding: 0.875rem 0.75rem !important;\n  background-color: #eee !important;\n  border: 0 solid #ced4da !important;\n}\n\n.mbsc-ios.mbsc-ltr .mbsc-input .mbsc-label {\n  padding-left: 0 !important;\n}\n\n.mbsc-control-w:before,\n.mbsc-control-w:after {\n  border-top: none !important;\n  content: \"\" !important;\n}\n\n.mbsc-ios .mbsc-collapsible .mbsc-form-group-title .mbsc-collapsible-icon {\n  margin-top: -0.5em;\n}";
styleInject(css_248z$c);

var css_248z$d = ".entity-modal-body .scripted-selects-control {\n  width: 100%;\n  margin-bottom: 0px;\n  margin-top: 10px;\n}\n.entity-modal-body .scripted-selects-control .select-title {\n  font-size: 16px !important;\n}\n.entity-modal-body .scripted-selects-control .select-title.required:after {\n  content: \" * \";\n  color: var(--app-accent-color);\n}\n.entity-modal-body .scripted-selects-control .select-element {\n  width: 100% !important;\n  margin-bottom: 10px;\n}\n.entity-modal-body .required .select-title:after {\n  content: \" * \";\n  color: var(--app-accent-color);\n}\n.entity-modal-body .required label:after {\n  content: \" * \";\n  color: var(--app-accent-color);\n}\n.entity-modal-body .entity-property-control-row {\n  display: flex;\n  margin: auto;\n}\n.entity-modal-body .entity-property-control-row .react-date-picker .react-date-picker__wrapper {\n  border: none;\n}\n.entity-modal-body .entity-property-control-row .react-datetime-picker .react-datetime-picker__wrapper {\n  border: none;\n}\n.entity-modal-body .entity-property-control-row .react-time-picker .react-time-picker__wrapper {\n  border: none;\n}\n.entity-modal-body .group-name {\n  display: flex;\n  margin-top: 10px;\n  font-style: italic;\n  font-weight: bold;\n  color: #666666;\n}\n.entity-modal-body .group-name:before, .entity-modal-body .group-name:after {\n  display: flex;\n  content: \"\";\n  flex-grow: 1;\n  margin: 8px;\n  border-bottom: 1px solid #B2B2B2;\n}\n.entity-modal-body .custom-control-input:checked ~ .custom-control-label::before {\n  color: #fff;\n  border-color: var(--app-accent-color);\n  background-color: var(--app-accent-color);\n}\n\n.property-uom {\n  text-align: center;\n  margin: auto;\n  padding-left: 10px;\n}\n\n.entity-modal-error-container {\n  display: flex;\n  min-height: 200px;\n  flex-direction: column;\n  align-items: center;\n  justify-content: flex-end;\n  gap: 12px;\n}\n\n.entity-modal-error {\n  color: red;\n  font-weight: bold;\n  font-size: 1.5em;\n  margin: 10px 5px;\n  text-align: right;\n}";
styleInject(css_248z$d);

var css_248z$e = ".base-text-input {\n  display: flex;\n  flex-direction: column;\n}\n.base-text-input input:focus {\n  border: 2px solid var(--app-accent-color) !important;\n  box-shadow: unset;\n}";
styleInject(css_248z$e);

var BaseTextInput = function BaseTextInput(props) {
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isFocused = _useState2[0],
    setIsFocused = _useState2[1];
  var handleFocus = function handleFocus() {
    var _props$inputProps$onF, _props$inputProps;
    setIsFocused(true);
    (_props$inputProps$onF = (_props$inputProps = props.inputProps).onFocusChange) === null || _props$inputProps$onF === void 0 || _props$inputProps$onF.call(_props$inputProps, true);
  };
  var handleBlur = function handleBlur() {
    var _props$inputProps$onF2, _props$inputProps2;
    setIsFocused(false);
    (_props$inputProps$onF2 = (_props$inputProps2 = props.inputProps).onFocusChange) === null || _props$inputProps$onF2 === void 0 || _props$inputProps$onF2.call(_props$inputProps2, false);
  };
  var baseClassName = 'base-text-input';
  var classNameModifiers = isFocused ? "".concat(baseClassName, "--is-focused") : '';
  var inputProps = {
    value: props.inputProps.value,
    type: props.inputProps.type,
    onChange: props.inputProps.onChange,
    placeholder: props.inputProps.placeholder,
    disabled: props.inputProps.disabled,
    onFocus: handleFocus,
    onBlur: handleBlur,
    className: "form-control ".concat(props.inputProps.className),
    style: props.style
  };
  return /*#__PURE__*/React$1.createElement("div", {
    className: "".concat(baseClassName, " ").concat(props.className, " ").concat(classNameModifiers)
  }, props.labelProps && /*#__PURE__*/React$1.createElement(ControlLabel, props.labelProps), props.component ? /*#__PURE__*/React$1.createElement(props.component, inputProps) : /*#__PURE__*/React$1.createElement("input", inputProps), props.children);
};
BaseTextInput.propTypes = {
  className: string,
  labelProps: shape(_objectSpread2({}, ControlLabel.propTypes)),
  inputProps: shape({
    type: string,
    value: any,
    onChange: func,
    placeholder: string,
    disabled: bool,
    className: string,
    style: object,
    onFocusChange: func,
    onBlur: func
  }).isRequired,
  component: element
};

var css_248z$f = ".control-text-overlay .control-text-overlay__text {\n  color: var(--app-accent-color);\n  pointer-events: none;\n  margin: 0;\n}\n\n.control-text-overlay--wrapping {\n  position: relative;\n  width: 100%;\n}\n.control-text-overlay--wrapping .control-text-overlay__text {\n  position: absolute;\n  transform: translate(12px, -50%);\n  bottom: 0;\n}";
styleInject(css_248z$f);

var ControlTextOverlay = function ControlTextOverlay(props) {
  return /*#__PURE__*/React$1.createElement("div", {
    style: props.style,
    className: "control-text-overlay ".concat(props.className || "", " ").concat(props.children && 'control-text-overlay--wrapping')
  }, props.children, !props.hide && /*#__PURE__*/React$1.createElement("p", {
    style: props.textStyle,
    className: "control-text-overlay__text ".concat(props.textClassName || '')
  }, props.text));
};

var css_248z$g = ".entity-modal-text-input {\n  position: relative;\n}\n.entity-modal-text-input input {\n  background-color: transparent;\n}\n\n.entity-modal-text-input--multiple-values input {\n  color: transparent;\n}\n.entity-modal-text-input--multiple-values input :focus {\n  color: initial;\n}";
styleInject(css_248z$g);

var EntityModalTextInput = function EntityModalTextInput(props) {
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    isFocused = _useState2[0],
    setIsFocused = _useState2[1];
  var multipleValuesCSSModifier = props.hasMultipleValues ? 'entity-modal-text-input--multiple-values' : '';
  return /*#__PURE__*/React$1.createElement(React$1.Fragment, null, /*#__PURE__*/React$1.createElement(ControlTextOverlay, {
    className: "entity-modal-text-input__overlay",
    text: "Multiple values",
    hide: !props.hasMultipleValues || isFocused
  }, /*#__PURE__*/React$1.createElement(BaseTextInput, {
    className: "entity-modal-text-input ".concat(multipleValuesCSSModifier),
    inputProps: _objectSpread2(_objectSpread2({}, props.inputProps), {}, {
      onFocusChange: function onFocusChange(isFocused) {
        var _props$inputProps$onF, _props$inputProps;
        (_props$inputProps$onF = (_props$inputProps = props.inputProps).onFocusChange) === null || _props$inputProps$onF === void 0 || _props$inputProps$onF.call(_props$inputProps, isFocused);
        setIsFocused(isFocused);
      }
    }),
    labelProps: _objectSpread2(_objectSpread2({}, props.labelProps), {}, {
      className: "entity-modal-text-input__label ".concat(props.labelProps.className)
    }),
    component: props.component
  })));
};
EntityModalTextInput.propTypes = _objectSpread2(_objectSpread2({}, BaseTextInput.propTypes), {}, {
  hasMultipleValues: bool
});

var css_248z$h = ".collapsible-text-input .collapsible-text-input__show-hide {\n  align-self: end;\n  margin-right: 4px;\n  transform: translateY(calc(-100% - 4px));\n}";
styleInject(css_248z$h);

var CollapsibleTextInput = function CollapsibleTextInput(props) {
  var _props$inputProps, _props$inputProps2, _props$labelProps, _props$labelProps2;
  var _useState = useState(true),
    _useState2 = _slicedToArray(_useState, 2),
    isCollapsed = _useState2[0],
    setIsCollapsed = _useState2[1];
  var toggleCollapse = function toggleCollapse() {
    return setIsCollapsed(!isCollapsed);
  };
  return /*#__PURE__*/React$1.createElement(BaseTextInput, {
    className: "collapsible-text-input",
    inputProps: _objectSpread2(_objectSpread2({}, props.inputProps), {}, {
      value: isCollapsed && ((_props$inputProps = props.inputProps) === null || _props$inputProps === void 0 ? void 0 : _props$inputProps.collapsedText) || ((_props$inputProps2 = props.inputProps) === null || _props$inputProps2 === void 0 ? void 0 : _props$inputProps2.value),
      onFocusChange: function onFocusChange(isFocused) {
        var _props$inputProps$onF, _props$inputProps3;
        (_props$inputProps$onF = (_props$inputProps3 = props.inputProps).onFocusChange) === null || _props$inputProps$onF === void 0 || _props$inputProps$onF.call(_props$inputProps3, isFocused);
        setIsFocused(isFocused);
      }
    }),
    labelProps: _objectSpread2(_objectSpread2({}, props.labelProps), {}, {
      text: (_props$labelProps = props.labelProps) === null || _props$labelProps === void 0 ? void 0 : _props$labelProps.text,
      className: "collapsible-text-input__label ".concat((_props$labelProps2 = props.labelProps) === null || _props$labelProps2 === void 0 ? void 0 : _props$labelProps2.className)
    }),
    component: !isCollapsed ? function (props) {
      return /*#__PURE__*/React$1.createElement(TextareaAutosize, _extends({}, props, {
        style: {
          paddingBottom: '2em'
        }
      }));
    } : undefined
  }, /*#__PURE__*/React$1.createElement(GenericMatButton, {
    size: "small",
    customClasses: "attention",
    className: "collapsible-text-input__show-hide",
    onClick: toggleCollapse
  }, isCollapsed ? "Show all" : "Hide all"));
};
CollapsibleTextInput.propTypes = _objectSpread2(_objectSpread2({}, BaseTextInput.propTypes), {}, {
  labelProps: _objectSpread2(_objectSpread2({}, BaseTextInput.propTypes.labelProps), {}, {
    collapsedText: string
  })
});

var iconStyle = {
  fontSize: 18
};
var TickCheckbox = function TickCheckbox(_ref) {
  var props = _extends({}, (_objectDestructuringEmpty(_ref), _ref));
  return /*#__PURE__*/React$1.createElement(Checkbox, _extends({
    icon: /*#__PURE__*/React$1.createElement(CheckIcon, {
      style: _objectSpread2(_objectSpread2({}, iconStyle), {}, {
        color: '#666666'
      })
    }),
    checkedIcon: /*#__PURE__*/React$1.createElement(CheckIcon, {
      style: _objectSpread2(_objectSpread2({}, iconStyle), {}, {
        color: 'var(--app-accent-color)'
      })
    })
  }, props));
};
var RoundCheckbox = function RoundCheckbox(_ref2) {
  var props = _extends({}, (_objectDestructuringEmpty(_ref2), _ref2));
  return /*#__PURE__*/React$1.createElement(Checkbox, _extends({
    icon: /*#__PURE__*/React$1.createElement(UncheckedCircle, {
      style: _objectSpread2(_objectSpread2({}, iconStyle), {}, {
        color: '#666666'
      })
    }),
    checkedIcon: /*#__PURE__*/React$1.createElement(CheckedCircle, {
      style: _objectSpread2(_objectSpread2({}, iconStyle), {}, {
        color: 'var(--app-accent-color)'
      })
    })
  }, props));
};
var StyledCheckBox = styled(Checkbox)(function (_ref3) {
  var theme = _ref3.theme;
  return {
    root: {
      color: "#B8B8B8",
      '&$checked': {
        color: 'var(--app-accent-color)'
      }
    },
    indeterminate: {
      color: 'var(--app-accent-color)'
    },
    checked: {}
  };
});
var PinkCheckbox = function PinkCheckbox(props) {
  return /*#__PURE__*/React$1.createElement(StyledCheckBox, _extends({
    icon: /*#__PURE__*/React$1.createElement(CheckBoxOutlineBlank, null),
    indeterminateIcon: /*#__PURE__*/React$1.createElement(IndeterminateCheckBoxRounded, null),
    checkedIcon: /*#__PURE__*/React$1.createElement(CheckBox, null)
  }, props));
};
var StyledSquareCheckBox = styled(Checkbox)(function (_ref4) {
  var theme = _ref4.theme;
  return {
    icon: {
      width: 18,
      height: 18,
      margin: 3,
      border: "2px solid rgb(87,87,87)",
      backgroundColor: "#f5f8fa"
    },
    checkedIcon: {
      display: "flex",
      justifyContent: "center",
      alignItems: "center",
      width: 18,
      height: 18,
      margin: 3,
      border: "2px solid var(--app-accent-color)",
      backgroundColor: "#f5f8fa"
    },
    innerCheckedIcon: {
      width: 8,
      height: 8,
      backgroundColor: "var(--app-accent-color)"
    }
  };
});
var SquareInSquareCheckbox = function SquareInSquareCheckbox(props) {
  /*#__PURE__*/React$1.createElement(StyledSquareCheckBox, _extends({
    icon: /*#__PURE__*/React$1.createElement("span", {
      className: props.classes.icon
    }),
    checkedIcon: /*#__PURE__*/React$1.createElement("span", {
      className: props.classes.checkedIcon
    }, /*#__PURE__*/React$1.createElement("div", {
      className: props.classes.innerCheckedIcon
    }))
  }, produce$1(props, function (props) {
    delete props.classes.icon;
    delete props.classes.checkedIcon;
    delete props.classes.innerCheckedIcon;
  })));
};
var useChecked = function useChecked(inputItems, checkCallback, allCheckCallback) {
  var _useState = useState([]),
    _useState2 = _slicedToArray(_useState, 2),
    items = _useState2[0],
    setItems = _useState2[1];
  //const previousItems = usePrevious(inputItems);

  useEffect(function () {
    setItems(function (previousItems) {
      function previousInstance(instance) {
        //find previous entity(._id) or file (.name)
        return previousItems.find(function (item) {
          return item._id && item._id == instance._id || item.name && item.name == instance.name;
        });
      }
      var newItems = inputItems.map(function (instance) {
        var previous = previousInstance(instance);
        return _objectSpread2(_objectSpread2({}, instance), {}, {
          checked: previous ? previous.checked : false
        });
      });
      return newItems;
    });
  }, [inputItems]);
  var handleCheck = function handleCheck(checkedInstance) {
    checkCallback === null || checkCallback === void 0 || checkCallback(checkedInstance, !checkedInstance.checked);
    setItems(function (instances) {
      return instances.map(function (instance) {
        return instance === checkedInstance ? _objectSpread2(_objectSpread2({}, checkedInstance), {}, {
          checked: !checkedInstance.checked
        }) : instance;
      });
    });
  };
  var allChecked = items.every(function (i) {
    return i.checked;
  });
  var handleAllCheck = function handleAllCheck() {
    allCheckCallback === null || allCheckCallback === void 0 || allCheckCallback(!allChecked);
    setItems(function (instances) {
      return instances.map(function (instance) {
        return _objectSpread2(_objectSpread2({}, instance), {}, {
          checked: !allChecked
        });
      });
    });
  };
  var resetChecked = function resetChecked(newInstances) {
    setItems(function (oldInstances) {
      return (newInstances || oldInstances).map(function (instance) {
        return _objectSpread2(_objectSpread2({}, instance), {}, {
          checked: false
        });
      });
    });
  };
  return {
    allChecked: allChecked,
    handleCheck: handleCheck,
    handleAllCheck: handleAllCheck,
    items: items,
    resetChecked: resetChecked
  };
};

var initialState = {
  component: undefined,
  props: undefined,
  open: false
};
var slice = createSlice({
  name: 'modal',
  initialState: initialState,
  reducers: {
    setModal: function setModal(state, _ref) {
      var _ref$payload = _ref.payload,
        component = _ref$payload.component,
        props = _ref$payload.props,
        open = _ref$payload.open;
      state.component = component;
      state.props = props;
      if (_.isBoolean(open)) {
        state.open = open;
      }
    },
    setOpen: function setOpen(state, _ref2) {
      var payload = _ref2.payload;
      state.open = payload;
    },
    destroy: function destroy(state) {
      state.component = initialState.component;
      state.props = initialState.props;
      state.open = initialState.open;
    }
  }
});
var modal = slice.reducer;
var actions = slice.actions;

var EntityModal = /*#__PURE__*/function (_React$Component) {
  function EntityModal(props) {
    var _this;
    _classCallCheck(this, EntityModal);
    _this = _callSuper(this, EntityModal, [props]);
    _this.INITIAL_STATE = {
      intialNewEntity: null,
      newEntity: null,
      working: false,
      typeMapKeys: [],
      typeMap: {},
      error: null,
      formError: null,
      modalOpen: false,
      shouldLoadForm: true,
      config: {}
    };
    _this.resetState = function () {
      _this.setState(_this.INITIAL_STATE);
    };
    _this.initiateModal = function () {
      var overridingState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
      if (_this.props.action.name === 'Edit' && !_this.checkEntityIsValid()) {
        throw new Error("ENTITY_NOT_VALID");
      }
      _this.setState(_objectSpread2(_objectSpread2({}, _this.INITIAL_STATE), {}, {
        modalOpen: true
      }, overridingState));
      var intialNewEntity = _this.getControlValues();
      _this.setState({
        intialNewEntity: intialNewEntity
      });
    };
    _this.shouldDisableAllControls = _$1.memoize(function () {
      var _this$state, _this$props$action;
      return ((_this$state = _this.state) === null || _this$state === void 0 ? void 0 : _this$state.working) || !!((_this$props$action = _this.props.action) !== null && _this$props$action !== void 0 && (_this$props$action = _this$props$action.component) !== null && _this$props$action !== void 0 && _this$props$action.disableAll);
    }, function () {
      var _this$state2, _this$props$action2;
      return "".concat(((_this$state2 = _this.state) === null || _this$state2 === void 0 ? void 0 : _this$state2.working) == true, "_").concat(((_this$props$action2 = _this.props.action) === null || _this$props$action2 === void 0 || (_this$props$action2 = _this$props$action2.component) === null || _this$props$action2 === void 0 ? void 0 : _this$props$action2.disableAll) == true);
    });
    _this.normalizeEntityProperties = function (entity) {
      var normalizedEntity = {};
      _$1.defaultsDeep(normalizedEntity, entity);
      Object.keys(normalizedEntity.properties).forEach(function (pk) {
        if (!normalizedEntity.properties[pk].val) {
          normalizedEntity.properties[pk] = _objectSpread2(_objectSpread2({}, normalizedEntity.properties[pk]), {}, {
            val: ''
          });
        }
      });
      return normalizedEntity;
    };
    _this.getBulkEntityProperties = function (entities) {
      if (_this.props.action.name !== "Create" && entities.length === 0) {
        throw new Error('No entity to edit');
      }
      var bulkEntityProperties = _objectSpread2({}, _this.normalizeEntityProperties(entities[0]).properties);
      if (entities.length > 1) {
        Object.entries(bulkEntityProperties).forEach(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
            key = _ref2[0],
            value = _ref2[1];
          var entitiesValues = entities.map(function (entity) {
            return _this.normalizeEntityProperties(entity).properties[key].val;
          });
          var keepBulkProperty = entitiesValues.every(function (val) {
            return val === value.val;
          });
          if (keepBulkProperty) {
            bulkEntityProperties[key] = _objectSpread2(_objectSpread2({}, bulkEntityProperties[key]), {}, {
              hasMultipleValues: false
            });
          } else {
            bulkEntityProperties[key] = _objectSpread2(_objectSpread2({}, bulkEntityProperties[key]), {}, {
              val: entitiesValues,
              hasMultipleValues: true
            });
          }
        });
      }
      return bulkEntityProperties;
    };
    _this.isBulkEdit = function () {
      return _$1.isArray(_this.props.entity) && _this.props.entity.length > 1;
    };
    _this.getBulkEntity = function (entities) {
      return {
        'Entity Name': entities.map(function (entity) {
          return entity['Entity Name'] || entity['Name'];
        }),
        properties: _this.getBulkEntityProperties(entities)
      };
    };
    _this.checkEntitiesHaveSameProperties = function (entities) {
      var propertyKeys = [];
      var i = 0;
      var differenceFound = false;
      while (i < entities.length && !differenceFound) {
        var entity = entities[i];
        if (i === 0) {
          propertyKeys = Object.keys(entity.properties);
        } else {
          differenceFound = !_$1.isEqual(_$1.sortBy(propertyKeys), _$1.sortBy(Object.keys(entity.properties)));
        }
        i++;
      }
      return !differenceFound;
    };
    _this.canEditEntityProperty = function (entity, propertyKey) {
      var _this$props$action3, _this$props$action4, _entity$properties$pr;
      var isHidden = _$1.defaultTo((_this$props$action3 = _this.props.action) === null || _this$props$action3 === void 0 || (_this$props$action3 = _this$props$action3.component) === null || _this$props$action3 === void 0 ? void 0 : _this$props$action3.hidden, []).find(function (prop) {
        return prop === propertyKey;
      });
      if (isHidden) {
        return true;
      }
      var propertyUiType = (_this$props$action4 = _this.props.action) === null || _this$props$action4 === void 0 || (_this$props$action4 = _this$props$action4.component) === null || _this$props$action4 === void 0 || (_this$props$action4 = _this$props$action4.propertyUiTypes) === null || _this$props$action4 === void 0 ? void 0 : _this$props$action4[propertyKey];
      if (propertyUiType) {
        var Control = ControlProvider.getControlComponent(propertyUiType);
        if (Control) return true;
      }
      var propType = entity === null || entity === void 0 || (_entity$properties$pr = entity.properties[propertyKey]) === null || _entity$properties$pr === void 0 ? void 0 : _entity$properties$pr.type;
      if (!propType) {
        console.warn("Property ", propertyKey, " from entity ", entity === null || entity === void 0 ? void 0 : entity['EntityName'], " is missing a type or a propertyUiTypes in the user config");
      }
      return !!propType;
    };
    _this.isEntityMissingProperties = function (entity) {
      var _this$props$action5, _this$props$action$co;
      var propertyUiTypes = (_this$props$action5 = _this.props.action) === null || _this$props$action5 === void 0 || (_this$props$action5 = _this$props$action5.component) === null || _this$props$action5 === void 0 ? void 0 : _this$props$action5.propertyUiTypes;
      propertyUiTypes = _$1.isObject(propertyUiTypes) ? propertyUiTypes : {};
      var propertyUiTypesProperties = Object.keys(propertyUiTypes);
      var groupedProperties = _$1.flatten(_$1.values(_this.props.action.component.groups));
      var hiddenProps = ((_this$props$action$co = _this.props.action.component) === null || _this$props$action$co === void 0 ? void 0 : _this$props$action$co.hidden) || [];
      var neededProperties = _$1.difference([].concat(_toConsumableArray(groupedProperties), propertyUiTypesProperties), hiddenProps);
      var propertyKeys = Object.keys(entity.properties);
      var missingProperties = _$1.difference(neededProperties, propertyKeys);
      var isMissingProperties = missingProperties.length > 0;
      if (isMissingProperties) {
        var entityName = entity === null || entity === void 0 ? void 0 : entity["Entity Name"];
        console.warn("Entity ", entityName, " is missing the following properties : ", missingProperties);
      }
      return isMissingProperties;
    };
    _this.canEditEntityProperties = function (entity) {
      var entityIsMissingProperties = _this.isEntityMissingProperties(entity);
      var canEditAllEntityProperties = Object.keys(entity.properties).every(function (key) {
        return _this.canEditEntityProperty(entity, key);
      });
      return !entityIsMissingProperties && canEditAllEntityProperties;
    };
    _this.checkEntityIsValid = function () {
      var entities = [];
      if (_$1.isArray(_this.props.entity)) {
        entities = _toConsumableArray(_this.props.entity);
      } else {
        entities = [_this.props.entity];
      }
      if (!_this.checkEntitiesHaveSameProperties(entities)) {
        console.warn("Entities do not have the same properties");
        return false;
      }
      return entities.every(_this.canEditEntityProperties);
    };
    _this.getControlValues = function () {
      var entity;
      var newEntity;
      if (_$1.isArray(_this.props.entity)) {
        entity = !!_this.props.entity ? _this.props.entity : [];
        try {
          newEntity = _this.getBulkEntity(entity);
        } catch (err) {
          if ((err === null || err === void 0 ? void 0 : err.message) === 'No entity to edit') {
            _this.setState({
              shouldLoadForm: false,
              error: /*#__PURE__*/React$1.createElement("div", {
                className: "entity-modal-error-container"
              }, /*#__PURE__*/React$1.createElement("div", null, "No entity selected"), /*#__PURE__*/React$1.createElement(GenericMatButton, {
                onClick: _this.onCancel,
                disabled: _this.state.working,
                styles: {
                  marginRight: '15px'
                }
              }, "Go back"))
            });
          } else {
            _this.setState({
              error: /*#__PURE__*/React$1.createElement(React$1.Fragment, null, /*#__PURE__*/React$1.createElement("div", {
                className: "entity-modal-error"
              }, "An unexpected error happened, please try again later."), /*#__PURE__*/React$1.createElement(GenericMatButton, {
                onClick: _this.onCancel,
                disabled: _this.state.working,
                styles: {
                  marginRight: '15px'
                }
              }, "Go back"))
            });
          }
        }
      } else {
        entity = !!_this.props.entity ? _this.props.entity : {};
        newEntity = _this.normalizeEntityProperties(entity);
      }
      _this.setState({
        newEntity: newEntity
      });
      return newEntity;
    };
    _this.onChangeMulti = function (attObj) {
      var atts = Object.keys(attObj);
      var newMultiUpdatedEntity = atts.reduce(function (partiallyUpdatedEntity, att) {
        return _this.getNewUpdatedEntity(partiallyUpdatedEntity, att, partiallyUpdatedEntity.properties[att], attObj[att]);
      }, _this.state.newEntity);
      _this.setState({
        newEntity: newMultiUpdatedEntity
      });
    };
    _this.onChange = function (att, propInfo, value) {
      var newEntity = _this.getNewUpdatedEntity(_this.state.newEntity, att, propInfo, value);
      _this.setState({
        newEntity: newEntity
      });
    };
    _this.close = function () {
      _this.props.destroyModal();
    };
    _this.onCancel = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
      return _regenerator().w(function (_context) {
        while (1) switch (_context.n) {
          case 0:
            if (_this.props.action.onCancel) _this.props.action.onCancel();
            _this.close();
          case 1:
            return _context.a(2);
        }
      }, _callee);
    }));
    _this.hasAllRequiredProperties = function (entity) {
      var pass = true;
      if (!entity['Entity Name']) pass = false;else {
        if (_this.props.action.component.requiredProperties) {
          var propNames = Object.keys(entity.properties);
          for (var i = 0; i < propNames.length; i++) {
            var prop = entity.properties[propNames[i]];
            if (_this.propIsRequired(prop.dName) && !prop.val) {
              pass = false;
              break;
            }
          }
        }
      }
      return pass;
    };
    _this.mergeEntityWithActionResult = function (actionName, entity, createResult) {
      if (actionName !== 'Create') return entity;
      return _objectSpread2(_objectSpread2({}, entity), createResult);
    };
    _this.prepareEntityForAction = function (entity) {
      var newEntity = _$1.cloneDeep(entity);
      if (_$1.isArray(newEntity['Entity Name'])) {
        newEntity['Entity Name'] = newEntity['Entity Name'].map(function (name) {
          return name.trim();
        });
      } else {
        newEntity['Entity Name'] = newEntity['Entity Name'].trim();
      }
      Object.keys(newEntity.properties).forEach(function (prop) {
        var propertyCanBeTrimmed = newEntity.properties[prop].val && newEntity.properties[prop].type === 'text';
        newEntity.properties[prop].val = propertyCanBeTrimmed ? newEntity.properties[prop].val.trim() : newEntity.properties[prop].val;
      });
      if (!_this.hasAllRequiredProperties(newEntity)) {
        throw new Error('MISSING_REQUIRED_PROPERTIES');
      } else {
        return newEntity;
      }
    };
    _this.doEntityAction = /*#__PURE__*/function () {
      var _ref4 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(newEntity, oldEntity) {
        var result, mergedEntity, _this$props$action$on, _this$props$action6;
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              _context2.n = 1;
              return _this.props.action.doEntityAction(_this.props.action.name, {
                "new": newEntity,
                original: oldEntity
              });
            case 1:
              result = _context2.v;
              _this.setState({
                working: false
              });
              if (!(!result && !_$1.isObjectLike(result))) {
                _context2.n = 2;
                break;
              }
              throw new Error("Scripting error: no result object yielded");
            case 2:
              if (!result.success) {
                _context2.n = 3;
                break;
              }
              mergedEntity = _this.mergeEntityWithActionResult(_this.props.action.name, newEntity, result.result);
              return _context2.a(2, result);
            case 3:
              (_this$props$action$on = (_this$props$action6 = _this.props.action).onError) === null || _this$props$action$on === void 0 || _this$props$action$on.call(_this$props$action6, _this.props.action.type, result, newEntity);
              throw new Error(result === null || result === void 0 ? void 0 : result.message);
            case 4:
              return _context2.a(2);
          }
        }, _callee2);
      }));
      return function (_x, _x2) {
        return _ref4.apply(this, arguments);
      };
    }();
    _this.filterObjectProperties = function (initialObject, filterCallback) {
      return Object.entries(initialObject).filter(filterCallback).reduce(function (obj, _ref5) {
        var _ref6 = _slicedToArray(_ref5, 1),
          key = _ref6[0];
        obj[key] = initialObject[key];
        return obj;
      }, {});
    };
    _this.prepareEntityAndDoAction = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3() {
      var onlyOnChangedEntity,
        _this$props$action$on2,
        _this$props$action7,
        preparedEntities,
        oldEntities,
        entityActionPromises,
        results,
        _this$props$action$on3,
        _this$props$action8,
        preparedEntity,
        result,
        _args3 = arguments;
      return _regenerator().w(function (_context3) {
        while (1) switch (_context3.n) {
          case 0:
            onlyOnChangedEntity = _args3.length > 0 && _args3[0] !== undefined ? _args3[0] : false;
            if (!_this.props.action.doEntityAction) {
              _context3.n = 5;
              break;
            }
            if (!_$1.isArray(_this.props.entity)) {
              _context3.n = 2;
              break;
            }
            preparedEntities = [];
            oldEntities = [];
            _this.props.entity.forEach(function (entity) {
              var newProperties = _this.filterObjectProperties(_this.state.newEntity.properties, function (_ref8) {
                var _ref9 = _slicedToArray(_ref8, 2),
                  propertyKey = _ref9[0],
                  propertyValue = _ref9[1];
                return propertyValue.hasMultipleValues === false;
              });
              var countNewProperties = Object.keys(newProperties).length;
              if (onlyOnChangedEntity === false || countNewProperties > 0) {
                var newEntity = _objectSpread2(_objectSpread2({}, entity), {}, {
                  properties: _objectSpread2(_objectSpread2({}, entity.properties), newProperties)
                });
                preparedEntities.push(_this.prepareEntityForAction(newEntity));
                oldEntities.push(entity);
              }
            });
            entityActionPromises = preparedEntities.map(function (preparedEntity, i) {
              return _this.doEntityAction(preparedEntity, oldEntities[i]);
            });
            _context3.n = 1;
            return Promise.all(entityActionPromises);
          case 1:
            results = _context3.v;
            (_this$props$action$on2 = (_this$props$action7 = _this.props.action).onSuccess) === null || _this$props$action$on2 === void 0 || _this$props$action$on2.call(_this$props$action7, _this.props.action.type, preparedEntities, results[0]);
            _context3.n = 4;
            break;
          case 2:
            preparedEntity = _this.prepareEntityForAction(_this.state.newEntity);
            _context3.n = 3;
            return _this.doEntityAction(preparedEntity, _this.props.entity);
          case 3:
            result = _context3.v;
            (_this$props$action$on3 = (_this$props$action8 = _this.props.action).onSuccess) === null || _this$props$action$on3 === void 0 || _this$props$action$on3.call(_this$props$action8, _this.props.action.type, preparedEntity, result);
          case 4:
            _this.close();
            _this.resetState();
          case 5:
            return _context3.a(2);
        }
      }, _callee3);
    }));
    _this.startEdit = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4() {
      var formErrorMessage, formError, _t, _t2;
      return _regenerator().w(function (_context4) {
        while (1) switch (_context4.p = _context4.n) {
          case 0:
            if (!_$1.isEqual(_this.state.intialNewEntity, _this.state.newEntity)) {
              _context4.n = 1;
              break;
            }
            _this.close();
            return _context4.a(2);
          case 1:
            _context4.p = 1;
            _context4.n = 2;
            return _this.prepareEntityAndDoAction(true);
          case 2:
            _context4.n = 7;
            break;
          case 3:
            _context4.p = 3;
            _t = _context4.v;
            formErrorMessage = 'Unexpected error while preparing the entities for saving, please try again later';
            _t2 = _t === null || _t === void 0 ? void 0 : _t.message;
            _context4.n = _t2 === "MISSING_REQUIRED_PROPERTIES" ? 4 : 5;
            break;
          case 4:
            formErrorMessage = 'Required properties are missing values!';
            return _context4.a(3, 6);
          case 5:
            formErrorMessage = _t.message;
            return _context4.a(3, 6);
          case 6:
            formError = /*#__PURE__*/React$1.createElement("div", {
              className: "entity-modal-error"
            }, formErrorMessage);
            _this.setState({
              formError: formError
            });
          case 7:
            return _context4.a(2);
        }
      }, _callee4, null, [[1, 3]]);
    }));
    _this.startCreate = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee5() {
      var formErrorMessage, formError, _t3, _t4;
      return _regenerator().w(function (_context5) {
        while (1) switch (_context5.p = _context5.n) {
          case 0:
            _context5.p = 0;
            _context5.n = 1;
            return _this.prepareEntityAndDoAction(true);
          case 1:
            _context5.n = 6;
            break;
          case 2:
            _context5.p = 2;
            _t3 = _context5.v;
            formErrorMessage = 'Unexpected error while preparing the entities for saving, please try again later';
            _t4 = _t3 === null || _t3 === void 0 ? void 0 : _t3.message;
            _context5.n = _t4 === "MISSING_REQUIRED_PROPERTIES" ? 3 : 4;
            break;
          case 3:
            formErrorMessage = 'Required properties are missing values!';
            return _context5.a(3, 5);
          case 4:
            formErrorMessage = _t3.message;
            return _context5.a(3, 5);
          case 5:
            formError = /*#__PURE__*/React$1.createElement("div", {
              className: "entity-modal-error"
            }, formErrorMessage);
            _this.setState({
              formError: formError
            });
          case 6:
            return _context5.a(2);
        }
      }, _callee5, null, [[0, 2]]);
    }));
    _this.startDelete = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee6() {
      var formErrorMessage, formError, _t5, _t6;
      return _regenerator().w(function (_context6) {
        while (1) switch (_context6.p = _context6.n) {
          case 0:
            _context6.p = 0;
            _context6.n = 1;
            return _this.prepareEntityAndDoAction();
          case 1:
            _context6.n = 6;
            break;
          case 2:
            _context6.p = 2;
            _t5 = _context6.v;
            formErrorMessage = 'Unexpected error while preparing the entities for deletion, please try again later';
            _t6 = _t5 === null || _t5 === void 0 ? void 0 : _t5.message;
            _context6.n = _t6 === "MISSING_REQUIRED_PROPERTIES" ? 3 : 4;
            break;
          case 3:
            formErrorMessage = 'Required properties are missing values!';
            return _context6.a(3, 5);
          case 4:
            formErrorMessage = _t5.message;
            return _context6.a(3, 5);
          case 5:
            formError = /*#__PURE__*/React$1.createElement("div", {
              className: "entity-modal-error"
            }, formErrorMessage);
            _this.setState({
              formError: formError
            });
          case 6:
            return _context6.a(2);
        }
      }, _callee6, null, [[0, 2]]);
    }));
    _this.onConfirm = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee7() {
      var _t7;
      return _regenerator().w(function (_context7) {
        while (1) switch (_context7.n) {
          case 0:
            _this.setState({
              working: true,
              error: null,
              formError: null
            });
            _t7 = _this.props.action.name;
            _context7.n = _t7 === "Edit" ? 1 : _t7 === "Create" ? 3 : _t7 === "Delete" ? 5 : 7;
            break;
          case 1:
            _context7.n = 2;
            return _this.startEdit();
          case 2:
            return _context7.a(3, 8);
          case 3:
            _context7.n = 4;
            return _this.startCreate();
          case 4:
            return _context7.a(3, 8);
          case 5:
            _context7.n = 6;
            return _this.startDelete();
          case 6:
            return _context7.a(3, 8);
          case 7:
            console.warn("Unexpected action name : ", _this.props.action.name);
            return _context7.a(3, 8);
          case 8:
            _this.setState({
              working: false
            });
          case 9:
            return _context7.a(2);
        }
      }, _callee7);
    }));
    _this.dashPropDName = function (propDName) {
      if (!_$1.isString(propDName)) return propDName;
      return propDName.split(' ').join('-');
    };
    _this.propIsRequired = function (prop) {
      var componentCfg = _this.props.action.component;
      var hasReqProps = !!componentCfg.requiredProperties;
      return hasReqProps && componentCfg.requiredProperties.includes(prop);
    };
    _this.canEditProperty = function (entity, propertyKey) {
      var _entity$properties$pr2, _this$props$action9;
      var propType = entity === null || entity === void 0 || (_entity$properties$pr2 = entity.properties[propertyKey]) === null || _entity$properties$pr2 === void 0 ? void 0 : _entity$properties$pr2.type;
      if (!propType) {
        return false;
      }
      var propertyUiType = (_this$props$action9 = _this.props.action) === null || _this$props$action9 === void 0 || (_this$props$action9 = _this$props$action9.component) === null || _this$props$action9 === void 0 || (_this$props$action9 = _this$props$action9.propertyUiTypes) === null || _this$props$action9 === void 0 ? void 0 : _this$props$action9[propertyKey];
      if (propertyUiType) {
        var Control = ControlProvider.getControlComponent(propertyUiType);
        return !!Control;
      }
      return true;
    };
    _this.getControl = function (prop) {
      var _this$props, _this$props2;
      var newEntity = _this.state.newEntity;
      var propInfo = _this.state.newEntity.properties[prop];
      var propType = propInfo && propInfo.type ? propInfo.type : 'missing';
      var disableControl = _this.shouldDisableAllControls() || ((_this$props = _this.props) === null || _this$props === void 0 || (_this$props = _this$props.action) === null || _this$props === void 0 || (_this$props = _this$props.component) === null || _this$props === void 0 || (_this$props = _this$props.disabled) === null || _this$props === void 0 ? void 0 : _this$props.includes(prop)) || _this.isBulkEdit() && ((_this$props2 = _this.props) === null || _this$props2 === void 0 || (_this$props2 = _this$props2.action) === null || _this$props2 === void 0 || (_this$props2 = _this$props2.component) === null || _this$props2 === void 0 || (_this$props2 = _this$props2.disabledInMulti) === null || _this$props2 === void 0 ? void 0 : _this$props2.includes(prop));
      switch (propType) {
        case 'number':
        case 'tags':
        case 'text':
          var _this$props$action0;
          if ((_this$props$action0 = _this.props.action) !== null && _this$props$action0 !== void 0 && (_this$props$action0 = _this$props$action0.component) !== null && _this$props$action0 !== void 0 && (_this$props$action0 = _this$props$action0.propertyUiTypes) !== null && _this$props$action0 !== void 0 && _this$props$action0[prop]) {
            var Control = ControlProvider.getControlComponent(_this.props.action.component.propertyUiTypes[prop]);
            if (!Control) return /*#__PURE__*/React$1.createElement("div", {
              key: prop
            }, "Configured propertyUiType Component for ", prop, " Doesn't Exist");else {
              var currentValue = {};
              currentValue[prop] = Array.isArray(propInfo.val) ? propInfo.val : [propInfo.val];
              return /*#__PURE__*/React$1.createElement("div", {
                key: propInfo.dName + '_div',
                className: clsx(_this.dashPropDName(propInfo.dName) + '-div', _this.propIsRequired(prop) && 'required')
              }, /*#__PURE__*/React$1.createElement("div", {
                className: "entity-property-control-row"
              }, /*#__PURE__*/React$1.createElement(Control, _extends({}, _this.props.action.component.propertyUiTypes[prop], {
                currentValue: propInfo.hasMultipleValues ? undefined : currentValue,
                onChange: function onChange(e) {
                  return _this.onChange(prop, propInfo, e[prop]);
                },
                noFetch: true,
                highlightedOptions: propInfo.hasMultipleValues ? propInfo.val : [],
                placeholder: propInfo.hasMultipleValues && /*#__PURE__*/React$1.createElement(ControlTextOverlay, {
                  text: "Multiple values"
                }),
                id: prop,
                filterInfo: _this.props.action.component.propertyUiTypes[prop].queryFilter ? newEntity : null,
                disabled: disableControl
              })), !!_this.state.newEntity.properties[prop].uom && /*#__PURE__*/React$1.createElement("span", {
                className: "property-uom"
              }, _this.state.newEntity.properties[prop].uom)));
            }
          } else {
            return /*#__PURE__*/React$1.createElement("div", {
              key: propInfo.dName + '_div',
              className: clsx(_this.dashPropDName(propInfo.dName) + '-div', _this.propIsRequired(prop) && 'required')
            }, /*#__PURE__*/React$1.createElement(EntityModalTextInput, {
              className: "entity-property-control-row",
              key: prop,
              labelProps: {
                text: prop
              },
              inputProps: {
                type: propInfo.type,
                value: propInfo.hasMultipleValues ? undefined : propInfo.val,
                onChange: function onChange(e) {
                  return _this.onChange(prop, propInfo, e.target.value);
                },
                disabled: disableControl
              },
              hasMultipleValues: propInfo.hasMultipleValues
            }), !!_this.state.newEntity.properties[prop].uom && /*#__PURE__*/React$1.createElement("span", {
              className: "property-uom"
            }, _this.state.newEntity.properties[prop].uom));
          }
        case 'date':
          var displayDate = !!_this.state.newEntity.properties[prop].epoch ? new Date(_this.state.newEntity.properties[prop].epoch) : null;
          return /*#__PURE__*/React$1.createElement("div", {
            key: propInfo.dName + '_div',
            className: clsx(_this.dashPropDName(propInfo.dName) + '-div', _this.propIsRequired(prop) && 'required')
          }, /*#__PURE__*/React$1.createElement("label", {
            style: {
              margin: '10px',
              fontWeight: 'bold'
            }
          }, prop), /*#__PURE__*/React$1.createElement("div", {
            className: "entity-property-control-row"
          }, /*#__PURE__*/React$1.createElement(ControlTextOverlay, {
            text: "Multiple values",
            textStyle: {
              backgroundColor: 'white'
            },
            hide: !propInfo.hasMultipleValues
          }, /*#__PURE__*/React$1.createElement(DatePicker, {
            key: prop,
            onChange: function onChange(e) {
              return _this.onChange(prop, propInfo, e);
            },
            value: displayDate,
            className: "form-control",
            calendarIcon: null,
            disabled: disableControl
          }))));
        case 'datetime':
          var _displayDate = !!_this.state.newEntity.properties[prop].epoch ? new Date(_this.state.newEntity.properties[prop].epoch) : null;
          return /*#__PURE__*/React$1.createElement("div", {
            key: propInfo.dName + '_div',
            className: clsx(_this.dashPropDName(propInfo.dName) + '-div', _this.propIsRequired(prop) && 'required')
          }, /*#__PURE__*/React$1.createElement("label", {
            style: {
              margin: '10px',
              fontWeight: 'bold'
            }
          }, prop), /*#__PURE__*/React$1.createElement("div", {
            className: "entity-property-control-row"
          }, /*#__PURE__*/React$1.createElement(DateTimePicker, {
            key: prop,
            onChange: function onChange(e) {
              return _this.onChange(prop, propInfo, e);
            },
            value: _displayDate,
            className: "form-control",
            calendarIcon: null,
            disableClock: true,
            disabled: disableControl
          })));
        case 'boolean':
          // let value = this.state.newEntity.properties[prop].val
          //   ? this.state.newEntity.properties[prop].val
          //   : false

          var value = propInfo.val;
          var multipleValues = _$1.isArray(value) && value.length > 1;
          var checked = multipleValues ? checked : !!value;
          var shouldDisplayValueAsLabel = ![true, false, undefined, null].includes(value);
          var label = shouldDisplayValueAsLabel ? value.toString() : "";
          label = multipleValues ? "Multiple values" : label;
          return /*#__PURE__*/React$1.createElement("div", {
            key: propInfo.dName + '_div',
            className: clsx(_this.dashPropDName(propInfo.dName) + '-div', _this.propIsRequired(prop) && 'required')
          }, /*#__PURE__*/React$1.createElement("label", {
            style: {
              margin: '10px',
              fontWeight: 'bold'
            }
          }, prop), /*#__PURE__*/React$1.createElement("div", {
            className: "entity-property-control-row"
          }, /*#__PURE__*/React$1.createElement(FormControlLabel, {
            control: /*#__PURE__*/React$1.createElement(PinkCheckbox, {
              checked: checked,
              id: propInfo.dName,
              indeterminate: multipleValues,
              onChange: function onChange(e) {
                return _this.onChange(prop, propInfo, e.target.checked);
              }
            }),
            label: label
          })));
        case 'missing':
          return /*#__PURE__*/React$1.createElement("div", {
            key: prop + '_div',
            className: clsx(_this.dashPropDName(prop) + '-div')
          }, /*#__PURE__*/React$1.createElement("label", {
            style: {
              margin: '10px',
              fontWeight: 'bold'
            }
          }, prop), /*#__PURE__*/React$1.createElement("div", {
            className: "entity-property-control-row"
          }, /*#__PURE__*/React$1.createElement("div", {
            style: {
              color: 'red'
            }
          }, prop + ' is missing a valid property type configuration')));
        default:
          return null;
      }
    };
    _this.getScriptedHierarchyInputs = function () {
      var _this$props$action1, _this$props$action10;
      var selects = _this.props.action.component.hierarchySelects.selects;
      selects = selects.map(function (s) {
        var newS = _objectSpread2({}, s);
        if (_this.propIsRequired(s.display)) newS.required = true;
        return newS;
      });
      var currentValue = {};
      var selectKeys = selects.map(function (select) {
        return select.display;
      });
      var highlightedOptions = {};
      var placeholders = {};
      selectKeys.forEach(function (propertyKey) {
        var property = _this.state.newEntity.properties[propertyKey];
        var value = property.hasMultipleValues ? undefined : [property.val];
        placeholders[propertyKey] = property.hasMultipleValues && /*#__PURE__*/React$1.createElement(ControlTextOverlay, {
          text: "Multiple values"
        });
        highlightedOptions[propertyKey] = property.hasMultipleValues ? property.val : undefined;
        currentValue[propertyKey] = value;
      });
      var isAlwaysDisabled = _$1.isArray((_this$props$action1 = _this.props.action) === null || _this$props$action1 === void 0 || (_this$props$action1 = _this$props$action1.component) === null || _this$props$action1 === void 0 ? void 0 : _this$props$action1.disabled) && selectKeys.some(function (prop) {
        return _this.props.action.component.disabled.includes(prop);
      });
      var isDisabledInBulkEdit = _this.isBulkEdit() && _$1.isArray((_this$props$action10 = _this.props.action) === null || _this$props$action10 === void 0 || (_this$props$action10 = _this$props$action10.component) === null || _this$props$action10 === void 0 ? void 0 : _this$props$action10.disabledInMulti) && selectKeys.some(function (prop) {
        return _this.props.action.component.disabledInMulti.includes(prop);
      });
      var disabled = _this.shouldDisableAllControls() || isAlwaysDisabled || isDisabledInBulkEdit;
      return /*#__PURE__*/React$1.createElement("div", null, /*#__PURE__*/React$1.createElement("hr", null), /*#__PURE__*/React$1.createElement(ScriptedLinkedSelects, {
        currentValue: currentValue,
        onChange: _this.onChangeMulti,
        noFetch: true,
        highlightedOptions: highlightedOptions,
        placeholders: placeholders,
        disabled: disabled,
        selects: selects
      }));
    };
    _this.state = _this.INITIAL_STATE;
    return _this;
  }
  _inherits(EntityModal, _React$Component);
  return _createClass(EntityModal, [{
    key: "componentDidMount",
    value: function () {
      var _componentDidMount = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee8() {
        return _regenerator().w(function (_context8) {
          while (1) switch (_context8.n) {
            case 0:
              try {
                this.initiateModal();
              } catch (err) {
                if ((err === null || err === void 0 ? void 0 : err.message) === 'ENTITY_NOT_VALID') {
                  this.setState({
                    shouldLoadForm: false,
                    error: /*#__PURE__*/React$1.createElement("div", {
                      className: "entity-modal-error-container"
                    }, /*#__PURE__*/React$1.createElement("div", null, "Cannot edit, selected entities have different properties, or they are missing properties. You should check you project's configuration"), /*#__PURE__*/React$1.createElement(GenericMatButton, {
                      onClick: this.onCancel,
                      disabled: this.state.working,
                      styles: {
                        marginRight: '15px'
                      }
                    }, "Go back"))
                  });
                }
              }
            case 1:
              return _context8.a(2);
          }
        }, _callee8, this);
      }));
      function componentDidMount() {
        return _componentDidMount.apply(this, arguments);
      }
      return componentDidMount;
    }()
  }, {
    key: "getNewUpdatedEntity",
    value: function getNewUpdatedEntity(originalEntity, att, propInfo, value) {
      return produce$1(originalEntity, function (newEntity) {
        var _newEntity$properties;
        if (Array.isArray(value) && propInfo.type !== 'tags') value = value[0];
        if (propInfo && propInfo.type === 'tags' && value === undefined) value = [];
        if (newEntity !== null && newEntity !== void 0 && (_newEntity$properties = newEntity.properties) !== null && _newEntity$properties !== void 0 && _newEntity$properties[att]) {
          newEntity.properties[att].hasMultipleValues = false;
        }
        if (att === 'name') {
          newEntity['Entity Name'] = value;
        } else if (propInfo.type === 'date' || propInfo.type === 'datetime') {
          var epoch = !!value ? value.getTime() : null;
          var localeString = !!value ? new Date(value).toLocaleDateString() : "";
          newEntity.properties[att].epoch = epoch;
          newEntity.properties[att].val = localeString;
        } else {
          newEntity.properties[att].val = value;
        }
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var body = null;
      var entityType = 'Entity';
      if (this.props.type && this.props.type.singular) entityType = this.props.type.singular;
      if (this.state.newEntity) {
        var _this$props$action$co2, _this$props$action$co3;
        var groups = this.getGroups();
        var name = this.state.newEntity['Entity Name'];
        var multipleValues = _$1.isArray(name) && name.length > 1;
        var valuesCount = multipleValues && name.length;
        name = multipleValues ? name.join('; ') : name;
        var shouldDisableControl = this.shouldDisableAllControls() || multipleValues || ((_this$props$action$co2 = this.props.action.component.disabled) === null || _this$props$action$co2 === void 0 ? void 0 : _this$props$action$co2.includes('Entity Name')) || this.isBulkEdit() && ((_this$props$action$co3 = this.props.action.component.disabledInMulti) === null || _this$props$action$co3 === void 0 ? void 0 : _this$props$action$co3.includes('Entity Name'));
        var InputComponent = multipleValues ? CollapsibleTextInput : EntityModalTextInput;
        body = /*#__PURE__*/React$1.createElement("div", {
          className: "entity-modal-body"
        }, /*#__PURE__*/React$1.createElement("div", {
          key: 'namediv',
          className: "required"
        }, /*#__PURE__*/React$1.createElement(InputComponent, {
          labelProps: {
            text: "".concat(entityType, " Name")
          },
          inputProps: {
            collapsedText: multipleValues ? "Multiple ".concat(this.props.type.plural, " (").concat(valuesCount, ")") : name,
            key: 'entityname',
            type: "text",
            onChange: function onChange(e) {
              _this2.onChange('name', null, e.target.value);
            },
            value: name,
            disabled: shouldDisableControl
          }
        })), /*#__PURE__*/React$1.createElement("div", {
          id: "hierarchy-selects"
        }, this.props.action.component.hierarchySelects && this.getScriptedHierarchyInputs()), !this.props.action.component.showGroupNames && /*#__PURE__*/React$1.createElement("hr", null), /*#__PURE__*/React$1.createElement("div", null, _$1.keys(groups).filter(function (groupName) {
          return groups[groupName].length > 0;
        }).map(function (groupName) {
          return /*#__PURE__*/React$1.createElement("div", {
            key: groupName
          }, _this2.props.action.component.showGroupNames && /*#__PURE__*/React$1.createElement("div", {
            className: 'group-name'
          }, groupName), groups[groupName].filter(function (prop) {
            return !(_this2.props.action.component.hidden || []).includes(prop);
          }).map(function (prop) {
            return _this2.getControl(prop);
          }));
        })));
      }
      var modalBody = /*#__PURE__*/React$1.createElement("div", {
        className: "mbsc-grid"
      }, this.state.error || /*#__PURE__*/React$1.createElement(React$1.Fragment, null, body, /*#__PURE__*/React$1.createElement("hr", null), this.state.formError, /*#__PURE__*/React$1.createElement("div", {
        style: {
          width: '100%',
          display: 'inline-flex',
          justifyContent: 'flex-end',
          marginTop: '20px'
        }
      }, /*#__PURE__*/React$1.createElement(GenericMatButton, {
        onClick: this.onCancel,
        disabled: this.state.working,
        styles: {
          marginRight: '15px'
        }
      }, "Cancel"), /*#__PURE__*/React$1.createElement(GenericMatButton, {
        onClick: this.onConfirm,
        disabled: this.state.working,
        customClasses: "attention"
      }, this.props.action.component.okButtonText ? this.props.action.component.okButtonText : 'OK'))));
      var title = this.props.action.title || this.props.action.name + ' ' + entityType;
      var titleEl = /*#__PURE__*/React$1.createElement("span", null, title);
      return /*#__PURE__*/React$1.createElement(GenericModal, {
        title: titleEl,
        customClasses: 'ipa-modal ipa-modal-no-x-close',
        modalBody: modalBody
      });
    }
  }, {
    key: "getGroups",
    value: function getGroups() {
      var _this$props$action$co4;
      var hiddenProps = ((_this$props$action$co4 = this.props.action.component) === null || _this$props$action$co4 === void 0 ? void 0 : _this$props$action$co4.hidden) || [];
      var allProps = _$1.difference(_$1.keys(this.state.newEntity.properties), hiddenProps);
      var groupedProps = _$1.difference(_$1.flatten(_$1.values(this.props.action.component.groups)), hiddenProps);
      var otherProps = _$1.difference(allProps, groupedProps);
      var groups = _objectSpread2({}, this.props.action.component.groups);
      if (otherProps) {
        groups["Other"] = otherProps;
      }
      return groups;
    }
  }]);
}(React$1.Component);
var mapStateToProps = function mapStateToProps(state) {
  return {
    modal: state.modal
  };
};
var mapDispatchToProps = {
  destroyModal: actions.destroy
};
EntityModal.contextTypes = {
  ifefPlatform: object,
  ifefSnapper: object,
  ifefNavDirection: string,
  ifefShowPopover: func,
  ifefUpdatePopover: func,
  ifefUpdatePopup: func,
  ifefShowModal: func,
  ifefModalOpen: bool
};
var ConnectedEntityModal = connect(mapStateToProps, mapDispatchToProps)(EntityModal);
var EntityModalFactory = {
  create: function create(_ref12) {
    var type = _ref12.type,
      action = _ref12.action,
      entity = _ref12.entity,
      context = _ref12.context,
      reduxStore = _ref12.reduxStore;
    reduxStore.dispatch(actions.setModal({
      component: ConnectedEntityModal,
      props: {
        action: action,
        entity: entity,
        type: type
      },
      open: true
    }));
  }
};

var css_248z$i = ".entity-collection-modal-body .scripted-selects-control {\n  width: 100%;\n  margin-bottom: 0px;\n}\n.entity-collection-modal-body .scripted-selects-control .select-element {\n  width: 100%;\n}\n.entity-collection-modal-body .selected-collections {\n  min-height: 100px;\n  width: 100%;\n  margin-left: 10px;\n}\n.entity-collection-modal-body .selected-collections .selected-collections-title {\n  font-size: 14px;\n  font-weight: bold;\n  letter-spacing: 0;\n  color: #333333;\n}\n.entity-collection-modal-body .selected-collections .selected-collections-display {\n  display: flex;\n  flex-direction: column;\n  margin-top: 10px;\n}\n.entity-collection-modal-body .selected-collections .selected-collections-display .selected-collections-display-row {\n  margin-bottom: 5px;\n}\n.entity-collection-modal-body .selected-collections .selected-collections-display .selected-collections-display-row .selected-collection-name-combo {\n  color: var(--app-accent-color);\n  font-weight: bold;\n}\n.entity-collection-modal-body .selected-collections .selected-collections-display .selected-collections-display-row .clear-selected-collection {\n  color: #B2B2B2;\n  margin-left: 15px;\n  cursor: pointer;\n}";
styleInject(css_248z$i);

var EntityCollectionModal = /*#__PURE__*/function (_React$Component) {
  function EntityCollectionModal(props) {
    var _this;
    _classCallCheck(this, EntityCollectionModal);
    _this = _callSuper(this, EntityCollectionModal, [props]);
    _this.getSelectedVal = function (valContainer) {
      var keys = valContainer ? Object.keys(valContainer) : [];
      if (keys.length) {
        var typeKey = keys[0];
        return valContainer[typeKey][0];
      } else return null;
    };
    _this.getFilterInfo = function () {
      var value = _this.getSelectedVal(_this.state.selectedType);
      if (value) return {
        query: {
          'properties.Type.val': value
        }
      };else return {
        query: null
      };
    };
    _this.isValidCollection = function (collection) {
      return !!collection.type && !collection.type !== "" && !!collection.name && !collection.name !== "";
    };
    _this.onChange = /*#__PURE__*/function () {
      var _ref = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(att, value) {
        var newCollToAdd, tempColls;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              if (att === 'type') {
                if (_this.getSelectedVal(value)) _this.setState({
                  selectedType: value
                });else _this.setState({
                  selectedType: null
                });
              } else {
                newCollToAdd = {
                  type: _this.getSelectedVal(_this.state.selectedType).trim(),
                  name: _this.getSelectedVal(value).trim()
                }; //check it is valid and not already added
                if (_this.isValidCollection(newCollToAdd) && !_$1.find(_this.state.selectedCollections, newCollToAdd)) {
                  tempColls = _toConsumableArray(_this.state.selectedCollections);
                  tempColls.unshift(newCollToAdd);
                  _this.setState({
                    selectedCollections: tempColls
                  });
                }
              }
            case 1:
              return _context.a(2);
          }
        }, _callee);
      }));
      return function (_x, _x2) {
        return _ref.apply(this, arguments);
      };
    }();
    _this.removeCollection = function (coll) {
      _this.setState({
        selectedCollections: _$1.without(_this.state.selectedCollections, coll)
      });
    };
    _this.onCancel = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2() {
      return _regenerator().w(function (_context2) {
        while (1) switch (_context2.n) {
          case 0:
            if (_this.props.action.onCancel) _this.props.action.onCancel();
            _this.context.ifefShowModal(false);
          case 1:
            return _context2.a(2);
        }
      }, _callee2);
    }));
    _this.onSave = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3() {
      var entityAndCollInfo, result, error;
      return _regenerator().w(function (_context3) {
        while (1) switch (_context3.n) {
          case 0:
            _this.setState({
              working: true,
              error: null
            });
            if (!(_this.props.action.doEntityAction && !!_this.state.selectedCollections.length)) {
              _context3.n = 2;
              break;
            }
            entityAndCollInfo = {
              collections: _this.state.selectedCollections,
              entities: Array.isArray(_this.props.entity) ? _this.props.entity : [_this.props.entity]
            };
            _context3.n = 1;
            return _this.props.action.doEntityAction(_this.props.action.name, entityAndCollInfo);
          case 1:
            result = _context3.v;
            if (result !== null && result !== void 0 && result.success) {
              _this.context.ifefShowModal(false);
              if (!!_this.props.action.onSuccess) _this.props.action.onSuccess(_this.props.action.type, result.entity ? result.entity : _this.props.entity, result);
            } else {
              console.error(result.message);
              error = /*#__PURE__*/React$1.createElement("div", {
                className: "entity-modal-error"
              }, result.message);
              _this.setState({
                working: false,
                error: error
              });
              if (!!_this.props.action.onError) _this.props.action.onError(_this.props.action.type, result, _this.props.entity);
            }
          case 2:
            _this.setState({
              working: false,
              error: null
            });
          case 3:
            return _context3.a(2);
        }
      }, _callee3);
    }));
    _this.state = {
      working: false,
      error: null,
      showBody: true,
      modalOpen: false,
      selectedType: null,
      selectedCollections: [],
      reloadTrigger: true
    };
    return _this;
  }
  _inherits(EntityCollectionModal, _React$Component);
  return _createClass(EntityCollectionModal, [{
    key: "componentDidMount",
    value: function () {
      var _componentDidMount = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4() {
        return _regenerator().w(function (_context4) {
          while (1) switch (_context4.n) {
            case 0:
              if (!this.props.action.script || !this.props.action.component.scripts || !this.props.action.component.scripts.getCollectionTypes || !this.props.action.component.scripts.getCollectionNames) {
                console.error('Collection Modal is missing required configured scripts!');
              }
            case 1:
              return _context4.a(2);
          }
        }, _callee4, this);
      }));
      function componentDidMount() {
        return _componentDidMount.apply(this, arguments);
      }
      return componentDidMount;
    }()
  }, {
    key: "componentDidUpdate",
    value: function () {
      var _componentDidUpdate = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee5(prevProps, prevState) {
        var isSingleEntity, isArrayOfEntites;
        return _regenerator().w(function (_context5) {
          while (1) switch (_context5.n) {
            case 0:
              if (this.state.modalOpen !== this.context.ifefModalOpen) {
                this.setState({
                  modalOpen: this.context.ifefModalOpen
                });
                if (this.context.ifefModalOpen) {
                  this.setState({
                    showBody: false
                  });
                  isSingleEntity = this.props.entity && _typeof(this.props.entity) === 'object' && !Array.isArray(this.props.entity);
                  isArrayOfEntites = Array.isArray(this.props.entity) && !!this.props.entity.length;
                  if (isSingleEntity || isArrayOfEntites) this.setState({
                    error: null,
                    selectedType: null,
                    selectedCollections: [],
                    showBody: true,
                    reloadTrigger: !this.state.reloadTrigger
                  });
                }
              }
            case 1:
              return _context5.a(2);
          }
        }, _callee5, this);
      }));
      function componentDidUpdate(_x3, _x4) {
        return _componentDidUpdate.apply(this, arguments);
      }
      return componentDidUpdate;
    }()
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var title = /*#__PURE__*/React$1.createElement("span", null, /*#__PURE__*/React$1.createElement("i", {
        style: {
          fontSize: '1.5em'
        },
        className: "icofont-cubes"
      }), " Add to Collection");
      var body = this.state.showBody ? /*#__PURE__*/React$1.createElement("div", {
        className: "entity-collection-modal-body"
      }, /*#__PURE__*/React$1.createElement(CreatableScriptedSelects, {
        currentValue: this.state.selectedType,
        script: this.props.action.component.scripts.getCollectionTypes,
        reloadTrigger: this.state.reloadTrigger,
        onChange: function onChange(val) {
          return _this2.onChange('type', val);
        },
        multi: false,
        disabled: this.state.working
      }), /*#__PURE__*/React$1.createElement(CreatableScriptedSelects, {
        script: this.props.action.component.scripts.getCollectionNames,
        filterInfo: this.getFilterInfo(),
        onChange: function onChange(val) {
          return _this2.onChange('name', val);
        },
        multi: false,
        disabled: this.state.working || !this.state.selectedType
      }), /*#__PURE__*/React$1.createElement("div", {
        className: "selected-collections"
      }, /*#__PURE__*/React$1.createElement("span", {
        className: "selected-collections-title"
      }, "Adding to:"), /*#__PURE__*/React$1.createElement("div", {
        className: "selected-collections-display"
      }, this.state.selectedCollections.map(function (coll) {
        return /*#__PURE__*/React$1.createElement("div", {
          className: "selected-collections-display-row",
          key: coll.type + ":" + coll.name
        }, /*#__PURE__*/React$1.createElement("span", {
          className: "selected-collection-name-combo"
        }, coll.type + ": " + coll.name), /*#__PURE__*/React$1.createElement("span", {
          className: "clear-selected-collection",
          onClick: function onClick() {
            return _this2.removeCollection(coll);
          }
        }, /*#__PURE__*/React$1.createElement("i", {
          className: "fas fa-times"
        })));
      })))) : /*#__PURE__*/React$1.createElement("div", null, "Nothing selected to add to Collections. Please close the dialog and select some items to add to Collections.");
      var modalBody = /*#__PURE__*/React$1.createElement("div", {
        className: "mbsc-grid"
      }, body, /*#__PURE__*/React$1.createElement("hr", null), this.state.error, /*#__PURE__*/React$1.createElement("div", {
        style: {
          width: '100%',
          display: 'inline-flex',
          justifyContent: 'flex-end',
          marginTop: '20px'
        }
      }, /*#__PURE__*/React$1.createElement(GenericMatButton, {
        onClick: this.onCancel,
        disabled: this.state.working,
        styles: {
          marginRight: '15px'
        }
      }, "Cancel"), /*#__PURE__*/React$1.createElement(GenericMatButton, {
        onClick: this.onSave,
        customClasses: "attention",
        disabled: this.state.working || !this.state.selectedCollections.length
      }, this.props.action.component.okButtonText ? this.props.action.component.okButtonText : 'OK')));
      return /*#__PURE__*/React$1.createElement(GenericModal, {
        title: title,
        customClasses: 'ipa-modal ipa-modal-no-x-close ipa-modal-small',
        modalBody: modalBody
      });
    }
  }]);
}(React$1.Component);
EntityCollectionModal.contextTypes = {
  ifefPlatform: object,
  ifefSnapper: object,
  ifefNavDirection: string,
  ifefShowPopover: func,
  ifefUpdatePopover: func,
  ifefUpdatePopup: func,
  ifefShowModal: func,
  ifefModalOpen: bool
};
var EntityCollectionModalFactory = {
  create: function create(_ref4) {
    var type = _ref4.type,
      action = _ref4.action,
      entity = _ref4.entity,
      context = _ref4.context;
    var modal = /*#__PURE__*/React$1.createElement(EntityCollectionModal, {
      action: action,
      entity: entity,
      type: type
    });
    context.ifefShowModal(modal);
    return modal;
  }
};

var css_248z$j = ".entity-relations-modal-body .selected-relations-display-row {\n  margin-bottom: 5px;\n}\n.entity-relations-modal-body .selected-relations-display-row .selected-relations-name-combo {\n  color: var(--app-accent-color);\n  font-weight: bold;\n}\n.entity-relations-modal-body .selected-relations-display-row .remove-from-collection {\n  color: #B2B2B2;\n  margin-right: 15px;\n  cursor: pointer;\n}\n\n.relations-modal {\n  top: 10%;\n  height: 80%;\n  left: 10%;\n  width: 85%;\n  border-radius: 5px;\n}\n.relations-modal .padding {\n  padding: 0;\n}\n.relations-modal .has-header {\n  top: 60px;\n}\n.relations-modal .bar.bar-dark {\n  background-color: transparent;\n  background-image: none;\n  height: 60px;\n}\n.relations-modal .bar.bar-dark .title {\n  height: 100%;\n  display: flex;\n  color: var(--app-accent-color);\n  font-weight: 600;\n  align-items: center;\n  padding-left: 10px;\n}\n.relations-modal .relations-modal-body {\n  height: 100%;\n  display: flex;\n  flex-direction: column;\n}\n.relations-modal .overlay {\n  width: 100%;\n  height: 100%;\n  background: white;\n  position: absolute;\n  z-index: 100;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  opacity: 0;\n  pointer-events: none;\n}\n.relations-modal .overlay.fade {\n  transition: opacity 2s;\n}\n.relations-modal .overlay.shown {\n  opacity: 1;\n  pointer-events: all;\n}\n.relations-modal .panels {\n  flex-grow: 1;\n  display: flex;\n  height: calc(100% - 60px);\n}\n.relations-modal .panels .panel {\n  flex: 1;\n  border: 1px solid #E6E6E6;\n  border-right: none;\n  height: 100%;\n  overflow-x: hidden;\n  overflow-y: auto;\n  position: relative;\n}\n.relations-modal .panels .panel:first-child {\n  border-left: none;\n}\n.relations-modal .panel-title {\n  color: var(--app-accent-color);\n  font-weight: 500;\n  font-size: 17px;\n  height: 60px;\n  padding: 20px;\n}\n.relations-modal .inner-panel {\n  padding: 20px;\n  height: calc(100% - 70px - 60px);\n  margin-top: 70px;\n  overflow: auto;\n}\n.relations-modal .entity-select {\n  padding: 0 20px;\n  position: absolute;\n  height: 70px;\n  width: 100%;\n  border-bottom: 1px solid #E6E6E6;\n  top: 60px;\n}\n.relations-modal .buttons {\n  flex-basis: 60px;\n  min-height: 60px;\n  display: flex;\n  align-items: center;\n  justify-content: flex-end;\n}\n.relations-modal .buttons > * {\n  margin-right: 15px;\n}\n.relations-modal .buttons .main-button {\n  font-size: 17px;\n  min-width: 130px;\n  height: 35px;\n  color: white;\n  background: var(--app-accent-color);\n  border-radius: 25px;\n  box-shadow: none;\n}\n.relations-modal .buttons .cancel-button {\n  font-size: 17px;\n  min-width: 130px;\n  height: 35px;\n  border-radius: 25px;\n  box-shadow: none;\n  color: #B2B2B2;\n  border: 2px solid;\n  background: white;\n  margin-left: 20px;\n}\n.relations-modal .simple-select-element {\n  width: 90%;\n  margin: 10px 0 10px 0;\n}\n.relations-modal .simple-select-title {\n  font-weight: bold;\n}\n.relations-modal .tree-container {\n  overflow: scroll;\n  height: calc(100% - 60px);\n  padding: 20px 20px 45px 20px;\n}\n.relations-modal .add-button-container {\n  display: flex;\n  position: absolute;\n  bottom: 10px;\n  right: 10px;\n  background: white;\n  border-radius: 18px;\n}\n.relations-modal .add-button {\n  font-size: 17px;\n  width: 130px;\n  height: 35px;\n  color: white;\n  background: var(--app-accent-color);\n  border-radius: 25px;\n  box-shadow: none;\n}\n\n.panel.relations-modal-summary {\n  padding: 0 0 20px 20px;\n}\n.panel.relations-modal-summary .parent-entity {\n  display: flex;\n  flex-direction: column;\n}\n.panel.relations-modal-summary .entity-name {\n  display: flex;\n  align-items: center;\n  background-color: #E6E6E6;\n  color: #666666;\n  height: 30px;\n  font-size: 0.95em;\n  justify-content: space-between;\n}\n.panel.relations-modal-summary .entity-name .toggle {\n  cursor: pointer;\n  margin-right: 10px;\n}\n.panel.relations-modal-summary .entity-children {\n  flex: 1;\n  max-height: 145px;\n  margin-bottom: 20px;\n  overflow: scroll;\n  transition: flex, max-height 1s;\n  background: #f7f7f7;\n  border-bottom-left-radius: 10px;\n  border-bottom-right-radius: 10px;\n  display: flex;\n  flex-direction: column;\n}\n.panel.relations-modal-summary .entity-children::-webkit-scrollbar {\n  width: 7px;\n}\n.panel.relations-modal-summary .entity-children::-webkit-scrollbar-track {\n  background: white;\n}\n.panel.relations-modal-summary .entity-children::-webkit-scrollbar-thumb {\n  background: #DCDCDC;\n  border-radius: 2rem;\n}\n.panel.relations-modal-summary .entity-children::-webkit-scrollbar-thumb:hover {\n  background: #B8B8B8;\n}\n.panel.relations-modal-summary .entity-children.collapsed {\n  flex: 0;\n  max-height: 0px;\n}\n.panel.relations-modal-summary .no-children {\n  font-size: 12px;\n  margin: 5px;\n}\n.panel.relations-modal-summary .child-container {\n  display: flex;\n  justify-content: space-between;\n  align-items: center;\n  order: 1;\n}\n.panel.relations-modal-summary .child-text {\n  color: var(--app-accent-color);\n  font-weight: 500;\n  font-size: 0.85em;\n  margin: 6px 10px;\n}\n.panel.relations-modal-summary .child-text > span {\n  margin-left: 10px;\n}\n.panel.relations-modal-summary .delete-button {\n  border-radius: 5px;\n  color: white;\n  background-color: var(--app-accent-color);\n  padding: 3px 6px;\n  width: 23px;\n  margin-right: 10px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  cursor: pointer;\n  height: 23px;\n}\n.panel.relations-modal-summary .delete-button .fa-times {\n  padding-right: 0;\n}\n.panel.relations-modal-summary .delete-button .fa-undo {\n  font-size: 13px;\n  padding-right: 0;\n}\n.panel.relations-modal-summary .link-icon {\n  font-size: 18px;\n  color: var(--app-accent-color);\n}\n.panel.relations-modal-summary .new {\n  order: 0;\n}\n.panel.relations-modal-summary .new .delete-button {\n  background-color: #00A693;\n}\n.panel.relations-modal-summary .new .child-text {\n  color: #00A693;\n}\n.panel.relations-modal-summary .new .link-icon {\n  color: #00A693;\n}\n.panel.relations-modal-summary .removed .child-text {\n  text-decoration: line-through;\n}";
styleInject(css_248z$j);

var EntityRelationsModal = /*#__PURE__*/function (_React$Component) {
  function EntityRelationsModal(props) {
    var _this;
    _classCallCheck(this, EntityRelationsModal);
    _this = _callSuper(this, EntityRelationsModal, [props]);
    _this.asSelectOption = function (option) {
      return {
        value: option,
        label: option,
        key: option
      };
    };
    _this.asSelectOptions = function (options) {
      return options.map(_this.asSelectOption);
    };
    _this.onTypeChange = function (option) {
      _this.setState({
        currentType: option,
        error: null
      }, _this.getEntitiesForCollection);
    };
    _this.getEntitiesForCollection = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
      var scriptPayload;
      return _regenerator().w(function (_context) {
        while (1) switch (_context.n) {
          case 0:
            _this.setState({
              error: null
            });
            scriptPayload = {
              entityType: _this.state.currentType.value,
              collection: _this.props.entity
            };
            ScriptHelper.executeScript(_this.props.action.component.scripts.getRelatedEntities, scriptPayload).then(function (entities) {
              _this.setState({
                working: false,
                currentRelatedEntities: entities
              });
            });
          case 1:
            return _context.a(2);
        }
      }, _callee);
    }));
    _this.removeRelation = function (relatedEntity) {
      ScriptHelper.executeScript(_this.props.action.script, {
        removeEntities: [relatedEntity],
        removeFrom: [_this.props.entity],
        entityType: _this.state.currentType.value
      }).then(function (result) {
        if (result !== null && result !== void 0 && result.success) {
          _this.getEntitiesForCollection();
        } else {
          _this.setState({
            error: "An error occured removing relations!"
          });
        }
      });
    };
    _this.onCancel = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2() {
      return _regenerator().w(function (_context2) {
        while (1) switch (_context2.n) {
          case 0:
            if (_this.props.action.onSuccess) _this.props.action.onSuccess(_this.props.action.type, _this.props.entity, _this.props.entity);
            _this.context.ifefShowModal(false);
          case 1:
            return _context2.a(2);
        }
      }, _callee2);
    }));
    _this.state = {
      working: false,
      error: null,
      modalOpen: false,
      currentType: null,
      currentRelatedEntities: []
    };
    return _this;
  }
  _inherits(EntityRelationsModal, _React$Component);
  return _createClass(EntityRelationsModal, [{
    key: "componentDidMount",
    value: function () {
      var _componentDidMount = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3() {
        return _regenerator().w(function (_context3) {
          while (1) switch (_context3.n) {
            case 0:
              if (!this.props.action.component.types.length) console.error("EntityRelationsModal configuration missing entities types!");
              if (!this.props.action.script || !this.props.action.component.scripts || !this.props.action.component.scripts.getRelatedEntities) console.error("EntityRelationsModal configuration missing scripts!");
            case 1:
              return _context3.a(2);
          }
        }, _callee3, this);
      }));
      function componentDidMount() {
        return _componentDidMount.apply(this, arguments);
      }
      return componentDidMount;
    }()
  }, {
    key: "componentDidUpdate",
    value: function () {
      var _componentDidUpdate = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4(prevProps, prevState) {
        return _regenerator().w(function (_context4) {
          while (1) switch (_context4.n) {
            case 0:
              if (this.state.modalOpen !== this.context.ifefModalOpen) {
                this.setState({
                  modalOpen: this.context.ifefModalOpen
                });
                if (this.context.ifefModalOpen) {
                  this.setState({
                    working: true,
                    currentType: this.asSelectOption(this.props.action.component.types[0]),
                    currentRelatedEntities: [],
                    error: null
                  }, this.getEntitiesForCollection);
                }
              }
            case 1:
              return _context4.a(2);
          }
        }, _callee4, this);
      }));
      function componentDidUpdate(_x, _x2) {
        return _componentDidUpdate.apply(this, arguments);
      }
      return componentDidUpdate;
    }()
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var title = /*#__PURE__*/React$1.createElement("span", null, /*#__PURE__*/React$1.createElement("i", {
        style: {
          fontSize: '1.5em'
        },
        className: "icofont-link"
      }), " ", this.props.action.component.title ? this.props.action.component.title : "Manage Relations");
      var body = /*#__PURE__*/React$1.createElement("div", {
        className: "entity-relations-modal-body"
      }, /*#__PURE__*/React$1.createElement(Select$1, {
        options: this.asSelectOptions(this.props.action.component.types),
        value: this.state.currentType,
        isDisabled: this.state.working || this.props.action.component.types.length === 1,
        onChange: this.onTypeChange
      }), /*#__PURE__*/React$1.createElement("hr", null), /*#__PURE__*/React$1.createElement("div", {
        className: "relations"
      }, !this.state.currentRelatedEntities.length && /*#__PURE__*/React$1.createElement("div", null, "No data"), !!this.state.currentRelatedEntities.length && this.state.currentRelatedEntities.map(function (re) {
        return /*#__PURE__*/React$1.createElement("div", {
          key: re._id,
          className: "selected-relations-display-row"
        }, /*#__PURE__*/React$1.createElement("span", {
          className: "remove-from-collection",
          onClick: function onClick() {
            return _this2.removeRelation(re);
          }
        }, /*#__PURE__*/React$1.createElement("i", {
          className: "fas fa-times"
        })), /*#__PURE__*/React$1.createElement("span", {
          className: "selected-relations-name-combo"
        }, re['Entity Name']));
      })));
      var modalBody = /*#__PURE__*/React$1.createElement("div", {
        className: "mbsc-grid"
      }, body, /*#__PURE__*/React$1.createElement("hr", null), this.state.error, /*#__PURE__*/React$1.createElement("div", {
        style: {
          width: '100%',
          display: 'inline-flex',
          justifyContent: 'flex-end',
          marginTop: '20px'
        }
      }, /*#__PURE__*/React$1.createElement(GenericMatButton, {
        onClick: this.onCancel,
        disabled: this.state.working,
        styles: {
          marginRight: '15px'
        }
      }, "Close")));
      return /*#__PURE__*/React$1.createElement(GenericModal, {
        title: title,
        customClasses: 'ipa-modal ipa-modal-no-x-close ipa-modal-small',
        modalBody: modalBody
      });
    }
  }]);
}(React$1.Component);
EntityRelationsModal.contextTypes = {
  ifefPlatform: object,
  ifefSnapper: object,
  ifefNavDirection: string,
  ifefShowPopover: func,
  ifefUpdatePopover: func,
  ifefUpdatePopup: func,
  ifefShowModal: func,
  ifefModalOpen: bool
};
var EntityRelationsModalFactory = {
  create: function create(_ref3) {
    var type = _ref3.type,
      action = _ref3.action,
      entity = _ref3.entity,
      context = _ref3.context;
    var modal = /*#__PURE__*/React$1.createElement(EntityRelationsModal, {
      action: action,
      entity: entity,
      type: type
    });
    context.ifefShowModal(modal);
    return modal;
  }
};

var _excluded$1 = ["_id"];
var initialState$1 = {
  //TODO if operations on these entities get too slow, use direct access instead of an array
  /**
   * note: currentEntityType is current handler config, must have minimum the following properties:
   * {script, entityFromModelScript, spaceMode, selectors, data, singular, plural}
   */
  currentEntityType: null,
  fetchingCurrent: 0,
  appliedFilters: {},
  appliedGroups: [],
  selectingEntities: false,
  viewerSyncOn: false,
  allCurrent: [],
  selectedIds: [],
  isolatedIds: []
};
var currentFetchPromise = new Promise(function (res) {
  return res([]);
});
var mapIds = function mapIds(entities) {
  return entities.map(function (_ref) {
    var _id = _ref._id;
    return _id;
  });
};
var entitiesSliceFactory = function entitiesSliceFactory() {
  var identifier = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  var sliceName = "entities".concat(identifier);
  var slice = createSlice({
    name: sliceName,
    initialState: initialState$1,
    reducers: {
      setEntities: function setEntities(state, _ref2) {
        var _ref2$payload = _ref2.payload,
          entities = _ref2$payload.entities,
          _ref2$payload$shouldI = _ref2$payload.shouldIsolate,
          shouldIsolate = _ref2$payload$shouldI === void 0 ? true : _ref2$payload$shouldI;
        state.allCurrent = entities;
        //Whenever we fetch entities we want to isolate them unless specified otherwise.
        //Maybe this will change over time as requirements get more specific
        state.isolatedIds = shouldIsolate ? mapIds(entities) : [];
      },
      setIsolatedEntities: function setIsolatedEntities(state, _ref3) {
        var entities = _ref3.payload;
        state.isolatedIds = mapIds(entities);
      },
      setSelectedEntities: function setSelectedEntities(state, _ref4) {
        var entities = _ref4.payload;
        state.selectedIds = mapIds(entities);
      },
      applyFiltering: function applyFiltering(state, _ref5) {
        var filters = _ref5.payload;
        state.appliedFilters = filters;
      },
      resetFiltering: function resetFiltering(state) {
        state.appliedFilters = initialState$1.appliedFilters;
      },
      applyGrouping: function applyGrouping(state, _ref6) {
        var groups = _ref6.payload;
        state.appliedGroups = groups;
      },
      resetGrouping: function resetGrouping(state) {
        state.appliedGroups = initialState$1.appliedGroups;
      },
      resetForFilteringAndGrouping: function resetForFilteringAndGrouping(state, _ref7) {
        var _ref7$payload = _ref7.payload,
          groups = _ref7$payload.groups,
          filters = _ref7$payload.filters;
        state.appliedFilters = filters ? filters : state.appliedFilters;
        state.appliedGroups = groups ? groups : state.appliedGroups;
        state.selectedIds = _$1.isEmpty(state.selectedIds) ? state.selectedIds : [];
      },
      setFetching: function setFetching(state, _ref8) {
        var fetching = _ref8.payload;
        if (fetching) {
          state.fetchingCurrent++;
        } else {
          state.fetchingCurrent--;
        }
      },
      setSelecting: function setSelecting(state, _ref9) {
        var selecting = _ref9.payload;
        state.selectingEntities = selecting;
      },
      setCurrentEntityType: function setCurrentEntityType(state, _ref0) {
        var type = _ref0.payload;
        state.currentEntityType = type;
      },
      setViewerSyncOn: function setViewerSyncOn(state) {
        state.viewerSyncOn = true;
      },
      resetEntities: function resetEntities() {
        return initialState$1;
      },
      deleteEntity: function deleteEntity(state, _ref1) {
        var entity = _ref1.payload;
        state.allCurrent.splice(state.allCurrent.findIndex(function (e) {
          return e._id === entity._id;
        }), 1);
      },
      addEntity: function addEntity(state, _ref10) {
        var entity = _ref10.payload;
        state.allCurrent.push(entity);
      },
      updateEntity: function updateEntity(state, _ref11) {
        var _ref11$payload = _ref11.payload,
          _id = _ref11$payload._id,
          updates = _objectWithoutProperties(_ref11$payload, _excluded$1);
        var toUpdate = state.allCurrent.find(function (e) {
          return e._id === _id;
        });
        _$1.assign(toUpdate, updates, {
          lastUpdate: Date.now()
        });
      },
      sortByName: function sortByName(state) {
        state.allCurrent.sort(function (a, b) {
          return a["Entity Name"].localeCompare(b["Entity Name"]);
        });
      },
      clearEntities: function clearEntities(state) {
        state.allCurrent = [];
        state.appliedFilters = {};
        state.appliedGroups = [];
        state.selectedIds = [];
        state.isolatedIds = [];
      },
      clearForNewEntityType: function clearForNewEntityType(state, _ref12) {
        var type = _ref12.payload;
        state.allCurrent = [];
        state.appliedFilters = {};
        state.appliedGroups = [];
        state.selectedIds = [];
        state.isolatedIds = [];
        state.currentEntityType = type;
      },
      loadSnapshot: function loadSnapshot(state, _ref13) {
        var snapshot = _ref13.payload;
        state.allCurrent = snapshot.allCurrent;
        state.appliedFilters = snapshot.appliedFilters;
        state.appliedGroups = snapshot.appliedGroups;
        state.selectedIds = snapshot.selectedIds;
        state.isolatedIds = snapshot.isolatedIds;
        state.currentEntityType = snapshot.currentEntityType;
        state.fetchingCurrent = snapshot.fetchingCurrent;
        state.selectingEntities = snapshot.selectingEntities;
        state.viewerSyncOn = snapshot.viewerSyncOn; //TODO: ?? this could be a global value?
      }
    }
  });
  var actions = slice.actions,
    reducer = slice.reducer;
  var actionCreators = actions;

  //Action creators
  var setEntities = actionCreators.setEntities,
    setFetching = actionCreators.setFetching,
    resetEntities = actionCreators.resetEntities,
    setViewerSyncOn = actionCreators.setViewerSyncOn,
    setIsolatedEntities = actionCreators.setIsolatedEntities,
    setSelectedEntities = actionCreators.setSelectedEntities,
    setCurrentEntityType = actionCreators.setCurrentEntityType,
    setSelecting = actionCreators.setSelecting,
    applyFiltering = actionCreators.applyFiltering,
    resetFiltering = actionCreators.resetFiltering,
    applyGrouping = actionCreators.applyGrouping,
    resetGrouping = actionCreators.resetGrouping,
    resetForFilteringAndGrouping = actionCreators.resetForFilteringAndGrouping,
    addEntity = actionCreators.addEntity,
    deleteEntity = actionCreators.deleteEntity,
    updateEntity = actionCreators.updateEntity,
    clearEntities = actionCreators.clearEntities,
    loadSnapshot = actionCreators.loadSnapshot,
    clearForNewEntityType = actionCreators.clearForNewEntityType;

  //Private selectors
  var getEntitiesSlice = function getEntitiesSlice(store) {
    return store[sliceName];
  };
  var getSnapshot = createSelector(getEntitiesSlice, function (entitiesSlice) {
    return entitiesSlice || {};
  });
  var getIsolatedEntitiesIds = createSelector(getEntitiesSlice, function (entitiesSlice) {
    return entitiesSlice.isolatedIds || [];
  });
  var getSelectedEntitiesIds = createSelector(getEntitiesSlice, function (entitiesSlice) {
    return entitiesSlice.selectedIds || [];
  });
  var fromIDs = function fromIDs(entities, ids) {
    return entities.filter(function (e) {
      return _$1.includes(ids, e._id);
    });
  };

  //Public Selectors
  var getAllCurrentEntities = createSelector(getEntitiesSlice, function (entitiesSlice) {
    return entitiesSlice.allCurrent;
  });
  var getAppliedFilters = createSelector(getEntitiesSlice, function (entitiesSlice) {
    return entitiesSlice.appliedFilters;
  });
  var getAppliedGroups = createSelector(getEntitiesSlice, function (entitiesSlice) {
    return entitiesSlice.appliedGroups;
  });
  var getFilteredEntities = createSelector([getAllCurrentEntities, getAppliedFilters], function (currentEntities, appliedFilters) {
    return _$1.isEmpty(getAppliedFilters) ? currentEntities : getFilteredEntitiesBy(currentEntities, appliedFilters);
  });
  var getIsolatedEntities = createSelector([getFilteredEntities, getIsolatedEntitiesIds], fromIDs);
  var getSelectedEntities = createSelector([getFilteredEntities, getSelectedEntitiesIds], fromIDs);
  var getFetchingCurrent = createSelector(getEntitiesSlice, function (entitiesSlice) {
    return !!entitiesSlice.fetchingCurrent;
  });
  var isViewerSyncOn = createSelector(getEntitiesSlice, function (entitiesSlice) {
    return entitiesSlice.viewerSyncOn;
  });
  var isSelectingEntities = createSelector(getEntitiesSlice, function (entitiesSlice) {
    return entitiesSlice.selectingEntities;
  });
  var getCurrentEntityType = createSelector(getEntitiesSlice, function (entitiesSlice) {
    return entitiesSlice.currentEntityType;
  });
  var selectors = {
    getAllCurrentEntities: getAllCurrentEntities,
    getAppliedFilters: getAppliedFilters,
    getAppliedGroups: getAppliedGroups,
    getFilteredEntities: getFilteredEntities,
    getIsolatedEntities: getIsolatedEntities,
    getSelectedEntities: getSelectedEntities,
    getFetchingCurrent: getFetchingCurrent,
    isViewerSyncOn: isViewerSyncOn,
    isSelectingEntities: isSelectingEntities,
    getCurrentEntityType: getCurrentEntityType,
    getSnapshot: getSnapshot
  };

  //Thunks
  var selectEntitiesFromModels = function selectEntitiesFromModels(modelEntities) {
    return /*#__PURE__*/function () {
      var _ref14 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(dispatch, getState) {
        var _getCurrentEntityType, entityFromModelScript, entitiesToSelect, filteredToSelect, _t;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.p = _context.n) {
            case 0:
              _context.p = 0;
              if (modelEntities.length === 1) dispatch(setSelecting(true));
              _getCurrentEntityType = getCurrentEntityType(getState()), entityFromModelScript = _getCurrentEntityType.entityFromModelScript;
              _context.n = 1;
              return Promise.all(modelEntities.map(function (modelEntity) {
                var foundEntity = getAllCurrentEntities(getState()).find(function (e) {
                  return modelEntity.id === e.modelViewerIds[0];
                });
                return !_$1.isEmpty(foundEntity) ? new Promise(function (resolve) {
                  return resolve(foundEntity);
                }) : getEntityFromModel(entityFromModelScript, modelEntity);
              }));
            case 1:
              entitiesToSelect = _context.v;
              filteredToSelect = entitiesToSelect.filter(function (e) {
                return e;
              });
              if (!setIncludesBy(getAllCurrentEntities(getState()), filteredToSelect, function (e) {
                var _e$modelData;
                return (e === null || e === void 0 || (_e$modelData = e.modelData) === null || _e$modelData === void 0 ? void 0 : _e$modelData.id) || (e === null || e === void 0 ? void 0 : e._id);
              })) {
                dispatch(setEntities({
                  entities: filteredToSelect,
                  shouldIsolate: false
                }));
              }
              dispatch(setSelectedEntities(filteredToSelect));
              dispatch(setSelecting(false));
              _context.n = 3;
              break;
            case 2:
              _context.p = 2;
              _t = _context.v;
              console.error("There was an error selecting the model entity:", _t);
            case 3:
              return _context.a(2);
          }
        }, _callee, null, [[0, 2]]);
      }));
      return function (_x, _x2) {
        return _ref14.apply(this, arguments);
      };
    }();
  };
  var changeEntity = function changeEntity(changeType, entity) {
    return /*#__PURE__*/function () {
      var _ref15 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(dispatch, getState) {
        var defaultChangeHandler, entityChanges;
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              defaultChangeHandler = function defaultChangeHandler() {
                return console.warn('Tried to edt entity with an unknown change type');
              }; //TODO Revisit if not doing anything is ok or we should be throwing an error.
              entityChanges = {
                create: function create(entity) {
                  return dispatch(addEntity(entity));
                },
                edit: function edit(entity) {
                  return dispatch(updateEntity(entity));
                },
                "delete": function _delete(entity) {
                  return dispatch(deleteEntity(entity));
                },
                relate: function relate(entity) {
                  return dispatch(updateEntity(entity));
                }
              };
              (entityChanges[changeType] || defaultChangeHandler)(entity);
            case 1:
              return _context2.a(2);
          }
        }, _callee2);
      }));
      return function (_x3, _x4) {
        return _ref15.apply(this, arguments);
      };
    }();
  };
  var fetchEntities = function fetchEntities(script, selector, value, runScriptOptions) {
    return /*#__PURE__*/function () {
      var _ref16 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3(dispatch, getState) {
        var query, interceptFetchError, getNextFetchPromise, entities, sorted;
        return _regenerator().w(function (_context3) {
          while (1) switch (_context3.n) {
            case 0:
              query = ControlProvider.getQuery(value, selector);
              dispatch(setFetching(true));
              interceptFetchError = function interceptFetchError(errorResult) {
                console.error("Fetch failed", errorResult);
              };
              getNextFetchPromise = function getNextFetchPromise() {
                return query ? ScriptCache.runScript(selector.altScript ? selector.altScript : script, {
                  entityInfo: selector.altScript ? value : query
                }, runScriptOptions) : new Promise(function (res) {
                  return res([]);
                });
              };
              currentFetchPromise = currentFetchPromise.then(function () {
                return getNextFetchPromise();
              },
              //ABOVE might return rejected promise, and chaining another .then is not possible without error handler resetting the promise status
              function (errorResult) {
                interceptFetchError(errorResult);
                return getNextFetchPromise();
              });
              _context3.n = 1;
              return currentFetchPromise;
            case 1:
              entities = _context3.v;
              sorted = _$1.sortBy(entities, function (a) {
                return a["Entity Name"];
              });
              dispatch(setEntities({
                entities: sorted
              }));
              dispatch(setSelectedEntities([]));
              // We do this to wait for the next tick thus allowing react to render the loading page-in between.
              // Otherwise when retrieving cached data it might happen so quickly that the loading page does not render and
              // the user has a few milliseconds while the page with updated data renders to execute a navigate action with stale data.
              // The real fix for this would be addressing the slow-render of the page, not a priority now.
              setTimeout(function () {
                return dispatch(setFetching(false));
              }, 0);
            case 2:
              return _context3.a(2);
          }
        }, _callee3);
      }));
      return function (_x5, _x6) {
        return _ref16.apply(this, arguments);
      };
    }();
  };
  var thunks = {
    selectEntitiesFromModels: selectEntitiesFromModels,
    changeEntity: changeEntity,
    fetchEntities: fetchEntities
  };
  return {
    reducer: reducer,
    actionCreators: actionCreators,
    selectors: selectors,
    thunks: thunks
  };
};

var _entitiesSliceFactory = entitiesSliceFactory('General'),
  reducer = _entitiesSliceFactory.reducer,
  actionCreators = _entitiesSliceFactory.actionCreators,
  selectors = _entitiesSliceFactory.selectors,
  thunks = _entitiesSliceFactory.thunks;

//Public selectors
var getAllCurrentEntities = selectors.getAllCurrentEntities;
var getAppliedFilters = selectors.getAppliedFilters;
var getAppliedGroups = selectors.getAppliedGroups;
var getFilteredEntities = selectors.getFilteredEntities;
var getIsolatedEntities = selectors.getIsolatedEntities;
var getSelectedEntities = selectors.getSelectedEntities;
var getFetchingCurrent = selectors.getFetchingCurrent;
var isViewerSyncOn = selectors.isViewerSyncOn;
var isSelectingEntities = selectors.isSelectingEntities;
var getCurrentEntityType = selectors.getCurrentEntityType;
var getSnapshot = selectors.getSnapshot;

//Action creators
var setEntities = actionCreators.setEntities,
  setFetching = actionCreators.setFetching,
  resetEntities = actionCreators.resetEntities,
  setViewerSyncOn = actionCreators.setViewerSyncOn,
  setIsolatedEntities = actionCreators.setIsolatedEntities,
  setSelectedEntities = actionCreators.setSelectedEntities,
  setCurrentEntityType = actionCreators.setCurrentEntityType,
  setSelecting = actionCreators.setSelecting,
  applyFiltering = actionCreators.applyFiltering,
  resetFiltering = actionCreators.resetFiltering,
  applyGrouping = actionCreators.applyGrouping,
  resetGrouping = actionCreators.resetGrouping,
  resetForFilteringAndGrouping = actionCreators.resetForFilteringAndGrouping,
  addEntity = actionCreators.addEntity,
  deleteEntity = actionCreators.deleteEntity,
  updateEntity = actionCreators.updateEntity,
  clearEntities = actionCreators.clearEntities,
  loadSnapshot = actionCreators.loadSnapshot,
  clearForNewEntityType = actionCreators.clearForNewEntityType;
var selectEntitiesFromModels = thunks.selectEntitiesFromModels;
var changeEntity = thunks.changeEntity;
var fetchEntities = thunks.fetchEntities;

var initialState$2 = {
  //Using direct access instead of an array for better performance
  entitiesById: {},
  entityIds: [],
  relatedById: {},
  relations: [],
  fetching: false,
  entitiesChanged: false
};
var sameRelation = function sameRelation(relation, other) {
  return relation.childId === other.childId && relation.parentId === other.parentId;
};
var getRelation = function getRelation(related, state, entityId) {
  return related.isChild ? state.relations.find(function (r) {
    return sameRelation(r, {
      parentId: entityId,
      childId: related._id
    });
  }) : state.relations.find(function (r) {
    return sameRelation(r, {
      parentId: related._id,
      childId: entityId
    });
  });
};
var entityRelationsSlice = createSlice({
  name: 'entityRelations',
  initialState: initialState$2,
  reducers: {
    setParentEntities: function setParentEntities(state, _ref) {
      var entities = _ref.payload;
      state.entitiesChanged = false;
      state.entitiesById = entities.reduce(function (byIds, entity) {
        return _objectSpread2(_objectSpread2({}, byIds), {}, _defineProperty({}, entity._id, entity));
      }, {});
      state.entityIds = entities.map(function (_ref2) {
        var _id = _ref2._id;
        return _id;
      });
    },
    setRelatedEntities: function setRelatedEntities(state, _ref3) {
      var entities = _ref3.payload;
      state.relatedById = entities.reduce(function (byIds, entity) {
        return _objectSpread2(_objectSpread2({}, byIds), {}, _defineProperty({}, entity._id, entity));
      }, {});
    },
    setRelations: function setRelations(state, _ref4) {
      var relations = _ref4.payload;
      state.relations = relations;
    },
    setFetching: function setFetching(state, _ref5) {
      var payload = _ref5.payload;
      state.fetching = payload;
    },
    addRelated: function addRelated(state, _ref6) {
      var _ref6$payload = _ref6.payload,
        relatedType = _ref6$payload.relatedType,
        related = _ref6$payload.related,
        entityIds = _ref6$payload.entityIds;
      state.entitiesChanged = true;
      related.forEach(function (r) {
        return state.relatedById[r._id] = r;
      });
      entityIds.forEach(function (entityId) {
        related.forEach(function (r) {
          var newRelation = relatedType.isChild ? {
            parentId: entityId,
            childId: r._id,
            "new": true
          } : {
            parentId: r._id,
            childId: entityId,
            "new": true
          };
          if (!state.relations.some(function (r) {
            return sameRelation(r, newRelation);
          })) state.relations.push(newRelation);
        });
      });
    },
    removeRelated: function removeRelated(state, _ref7) {
      var _ref7$payload = _ref7.payload,
        related = _ref7$payload.related,
        entityId = _ref7$payload.entityId;
      state.entitiesChanged = true;
      var relation = getRelation(related, state, entityId);
      if (relation["new"]) {
        _$1.remove(state.relations, function (r) {
          return sameRelation(r, relation);
        });
      } else {
        relation.removed = true;
      }
    },
    recoverRelated: function recoverRelated(state, _ref8) {
      var _ref8$payload = _ref8.payload,
        related = _ref8$payload.related,
        entityId = _ref8$payload.entityId;
      state.entitiesChanged = true;
      var relation = getRelation(related, state, entityId);
      relation.removed = false;
    }
  }
});
var actions$1 = entityRelationsSlice.actions,
  reducer$1 = entityRelationsSlice.reducer;

//Private selectors
var getEntityRelationsSlice = function getEntityRelationsSlice(store) {
  return store.entityRelations;
};
var getEntityRelations = createSelector(getEntityRelationsSlice, function (relationSlice) {
  return relationSlice.relations;
});
var getAllEntities = createSelector(getEntityRelationsSlice, function (relationSlice) {
  return _objectSpread2(_objectSpread2({}, relationSlice.entitiesById), relationSlice.relatedById);
});

//Public selectors
var getParentEntities = createSelector(getEntityRelationsSlice, function (relationSlice) {
  return relationSlice.entityIds.map(function (id) {
    return _objectSpread2(_objectSpread2({}, relationSlice.entitiesById[id]), {}, {
      related: relationSlice.relations.filter(function (_ref9) {
        var parentId = _ref9.parentId,
          childId = _ref9.childId;
        return parentId === id || childId === id;
      }).map(function (_ref0) {
        var parentId = _ref0.parentId,
          childId = _ref0.childId,
          isNew = _ref0["new"],
          removed = _ref0.removed;
        return _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, relationSlice.relatedById[parentId === id ? childId : parentId]), parentId === id && {
          isChild: true
        }), childId === id && {
          isParent: true
        }), {}, {
          "new": isNew,
          removed: removed
        });
      })
    });
  });
});
var getFetchingRelatedEntities = createSelector(getEntityRelationsSlice, function (relationSlice) {
  return relationSlice.fetching;
});
var getEntitiesChanged = createSelector(getEntityRelationsSlice, function (relationSlice) {
  return relationSlice.entitiesChanged;
});

//Action creators
var setParentEntities = actions$1.setParentEntities,
  setFetching$1 = actions$1.setFetching,
  addRelated = actions$1.addRelated,
  removeRelated = actions$1.removeRelated,
  recoverRelated = actions$1.recoverRelated,
  setRelatedEntities = actions$1.setRelatedEntities,
  setRelations = actions$1.setRelations;
function getRelated(entity, relatedTypes) {
  var namesByType = ScriptHelper.getScriptVar("iaf_entityNamePropMap");
  var children = _$1.pick(entity, relatedTypes.map(function (ct) {
    return ct.singular;
  }));
  return _$1.values(_$1.mapValues(children, function (childrenByType, type) {
    return childrenByType._list.map(function (child) {
      return _objectSpread2(_objectSpread2({}, child), {}, {
        entityType: type,
        entityName: _$1.get(child, namesByType[type])
      });
    });
  })).flat();
}

//Thunks
var retrieveRelated = function retrieveRelated(originalParentEntities, getScript, relatedTypes) {
  return /*#__PURE__*/function () {
    var _ref1 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(dispatch, getState) {
      var parentEntities, rawEntitiesWithRelated, related, relations;
      return _regenerator().w(function (_context) {
        while (1) switch (_context.n) {
          case 0:
            dispatch(setFetching$1(true));
            parentEntities = originalParentEntities.map(function (e) {
              return {
                entityName: e["Entity Name"],
                entityType: getCurrentEntityType(getState()).singular,
                _id: e._id
              };
            });
            _context.n = 1;
            return ScriptHelper.executeScript(getScript, {
              parentEntities: parentEntities,
              childrenTypes: relatedTypes
            });
          case 1:
            rawEntitiesWithRelated = _context.v;
            related = _$1.defaultTo(rawEntitiesWithRelated, []).flatMap(function (entity) {
              return getRelated(entity, relatedTypes);
            });
            relations = _$1.defaultTo(rawEntitiesWithRelated, []).flatMap(function (entity) {
              return getRelated(entity, relatedTypes).map(function (relatedEntity) {
                return relatedTypes.find(function (rt) {
                  return rt.singular === relatedEntity.entityType;
                }).isChild ? {
                  parentId: entity._id,
                  childId: relatedEntity._id
                } : {
                  parentId: relatedEntity._id,
                  childId: entity._id
                };
              });
            });
            dispatch(setParentEntities(parentEntities));
            dispatch(setRelatedEntities(related));
            dispatch(setRelations(relations));
            dispatch(setFetching$1(false));
          case 2:
            return _context.a(2);
        }
      }, _callee);
    }));
    return function (_x, _x2) {
      return _ref1.apply(this, arguments);
    };
  }();
};
var getFilteredParentsWithChildren = function getFilteredParentsWithChildren(getState, predicate) {
  return _$1.values(_$1.mapValues(_$1.groupBy(getEntityRelations(getState()).filter(predicate), function (r) {
    return r.parentId;
  }), function (relations, parentId) {
    return _objectSpread2(_objectSpread2({}, getAllEntities(getState())[parentId]), {}, {
      childrenMap: _$1.groupBy(relations.map(function (r) {
        return getAllEntities(getState())[r.childId];
      }), function (c) {
        return c.entityType;
      })
    });
  }));
};
var applyRelationChanges = function applyRelationChanges(script, relatedTypes) {
  return /*#__PURE__*/function () {
    var _ref10 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(dispatch, getState) {
      var parentEntitiesWithNewChildren, parentEntitiesWithDeletedChildren, parentTypes;
      return _regenerator().w(function (_context2) {
        while (1) switch (_context2.n) {
          case 0:
            parentEntitiesWithNewChildren = getFilteredParentsWithChildren(getState, function (relation) {
              return relation["new"];
            });
            parentEntitiesWithDeletedChildren = getFilteredParentsWithChildren(getState, function (relation) {
              return relation.removed;
            });
            parentTypes = _$1.uniq([].concat(_toConsumableArray(parentEntitiesWithDeletedChildren), _toConsumableArray(parentEntitiesWithNewChildren)).map(function (pe) {
              return pe.entityType;
            }));
            _context2.n = 1;
            return Promise.all([].concat(_toConsumableArray(relatedTypes), [getCurrentEntityType(getState()).singular]).map(function (childrenType) {
              return parentTypes.map(function (parentType) {
                var params = {
                  parentEntityType: parentType,
                  //TODO Analyze some alternative to better group these complex lists and avoid so much filtering
                  parentEntitiesWithNewChildren: parentEntitiesWithNewChildren.filter(function (p) {
                    return p.entityType === parentType && !_$1.isEmpty(p.childrenMap[childrenType]);
                  }),
                  parentEntitiesWithDeletedChildren: parentEntitiesWithDeletedChildren.filter(function (p) {
                    return p.entityType === parentType && !_$1.isEmpty(p.childrenMap[childrenType]);
                  }),
                  childrenEntityType: childrenType
                };
                console.log("applyRelationChanges script", script);
                console.log("applyRelationChanges params", params);
                return ScriptHelper.executeScript(script, params);
              });
            }));
          case 1:
            return _context2.a(2);
        }
      }, _callee2);
    }));
    return function (_x3, _x4) {
      return _ref10.apply(this, arguments);
    };
  }();
};

/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2018] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

var EmptyConfig = {
  scripts: {},
  handlers: {},
  pages: {},
  settings: {},
  groupedPages: {}
};
var actualPage = function actualPage(config, path) {
  return config.pages ? config.pages[path] : config.groupedPages[path].pages[0];
};

var initialState$3 = EmptyConfig;
var userConfigSlice = createSlice({
  name: 'userConfig',
  initialState: initialState$3,
  reducers: {
    setUserConfig: function setUserConfig(state, _ref) {
      var config = _ref.payload;
      return config;
    }
  }
});
var actions$2 = userConfigSlice.actions,
  reducer$2 = userConfigSlice.reducer;

//Private selectors
var getUserConfigSlice = function getUserConfigSlice(store) {
  return store.userConfig;
};

//Public selectors

var getEntitySelectConfig = createSelector(getUserConfigSlice, function (config) {
  return Object.entries(config.handlers).filter(function (e) {
    return e[1].config && e[1].config.entityData && Object.entries(e[1].config.entityData).length === 1;
  }).map(function (e) {
    return {
      entityName: Object.keys(e[1].config.entityData)[0],
      entityPluralName: e[1].config.type.plural,
      script: e[1].config.entityData[Object.keys(e[1].config.entityData)[0]].script,
      selectors: config.entitySelectConfig[Object.keys(e[1].config.entityData)[0]]
    };
  });
});

//Action creators
var setUserConfig = actions$2.setUserConfig;
var addUserConfig = function addUserConfig(config) {
  return function (dispatch, getState) {
    dispatch(setUserConfig(config));
  };
};

var _entitiesSliceFactory$1 = entitiesSliceFactory('PluggableSearch'),
  reducer$3 = _entitiesSliceFactory$1.reducer,
  actionCreators$1 = _entitiesSliceFactory$1.actionCreators,
  selectors$1 = _entitiesSliceFactory$1.selectors,
  thunks$1 = _entitiesSliceFactory$1.thunks;

//Public selectors
var getAllCurrentSearchedEntities = selectors$1.getAllCurrentEntities;
var getSelectedSearchedEntities = selectors$1.getSelectedEntities;
var getSearchingCurrent = selectors$1.getFetchingCurrent;
var getCurrentSearchEntityType = selectors$1.getCurrentEntityType;
var getAppliedSearchFilters = selectors$1.getAppliedFilters;

//Action creators
var resetSearchedEntities = actionCreators$1.resetEntities;
var clearSearchedEntities = actionCreators$1.clearEntities;
var applySearchFiltering = actionCreators$1.applyFiltering;
var resetSearchFiltering = actionCreators$1.resetFiltering;
var setSelectedSearchedEntities = actionCreators$1.setSelectedEntities;

//Thunks
var searchEntities = thunks$1.fetchEntities;

/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2019] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */
var SimpleSelect = function SimpleSelect(_ref) {
  var title = _ref.title,
    options = _ref.options,
    handleChange = _ref.handleChange,
    placeholder = _ref.placeholder,
    className = _ref.className,
    value = _ref.value,
    _ref$clearable = _ref.clearable,
    clearable = _ref$clearable === void 0 ? true : _ref$clearable,
    disabled = _ref.disabled;
  return /*#__PURE__*/React$1.createElement("div", {
    className: className
  }, title && /*#__PURE__*/React$1.createElement("span", {
    className: "simple-select-title"
  }, title), /*#__PURE__*/React$1.createElement(Select$1, {
    value: value && {
      label: value,
      value: value
    },
    isMulti: false,
    onChange: function onChange(selected) {
      return handleChange(selected && selected.value);
    },
    options: options.map(function (s) {
      return {
        label: s,
        value: s
      };
    }),
    className: "simple-select-element",
    closeMenuOnSelect: true,
    placeholder: placeholder,
    isClearable: clearable,
    isDisabled: disabled
  }));
};

var SummaryPanel = function SummaryPanel(_ref) {
  var baseEntities = _ref.parentEntities,
    fetching = _ref.fetching,
    handleCheck = _ref.handleCheck,
    checkedEntities = _ref.checkedEntities,
    entityTypeOptions = _ref.entityTypeOptions,
    removeRelated = _ref.removeRelated,
    recoverRelated = _ref.recoverRelated;
  var _useState = useState([]),
    _useState2 = _slicedToArray(_useState, 2),
    collapsed = _useState2[0],
    setCollapsed = _useState2[1];
  var _useState3 = useState(),
    _useState4 = _slicedToArray(_useState3, 2),
    selectedEntityType = _useState4[0],
    setSelectedEntityType = _useState4[1];
  useEffect(function () {
    return setCollapsed(function (collapsed) {
      return baseEntities.map(function (e, i) {
        return collapsed[i] || false;
      });
    });
  }, [baseEntities]);
  var toggle = function toggle(i) {
    return setCollapsed(produce(function (collapsed) {
      collapsed[i] = !collapsed[i];
    }));
  };
  var getFilteredRelated = function getFilteredRelated(entity) {
    return selectedEntityType ? entity.related.filter(function (r) {
      return r.entityType === selectedEntityType;
    }) : entity.related;
  };
  return /*#__PURE__*/React$1.createElement("div", {
    className: 'panel relations-modal-summary'
  }, /*#__PURE__*/React$1.createElement("div", {
    className: 'panel-title'
  }, "Summary"), fetching ? /*#__PURE__*/React$1.createElement(FetchingLegend, {
    legend: 'Fetching relations...'
  }) : /*#__PURE__*/React$1.createElement("div", null, /*#__PURE__*/React$1.createElement(SimpleSelect, {
    className: 'entity-select',
    placeholder: 'Filter related by type',
    options: entityTypeOptions,
    handleChange: function handleChange(selected) {
      return setSelectedEntityType(selected);
    },
    value: selectedEntityType
  }), /*#__PURE__*/React$1.createElement("div", {
    className: 'inner-panel'
  }, baseEntities.map(function (entity, i) {
    return /*#__PURE__*/React$1.createElement("div", {
      className: 'parent-entity',
      key: entity._id
    }, /*#__PURE__*/React$1.createElement("div", {
      className: 'entity-name'
    }, /*#__PURE__*/React$1.createElement(PinkCheckbox, {
      checked: _$1.get(checkedEntities[i], 'checked', false),
      onChange: function onChange() {
        return handleCheck(checkedEntities[i]);
      }
    }), entity.entityName, /*#__PURE__*/React$1.createElement("div", {
      className: 'toggle'
    }, collapsed[i] ? /*#__PURE__*/React$1.createElement(ExpandMoreIcon, {
      onClick: function onClick() {
        return toggle(i);
      }
    }) : /*#__PURE__*/React$1.createElement(ExpandLessIcon, {
      onClick: function onClick() {
        return toggle(i);
      }
    }))), /*#__PURE__*/React$1.createElement("div", {
      className: clsx('entity-children', collapsed[i] && 'collapsed')
    }, _$1.isEmpty(getFilteredRelated(entity)) ? /*#__PURE__*/React$1.createElement("div", {
      className: 'no-children'
    }, "No children found") : getFilteredRelated(entity).map(function (r) {
      return /*#__PURE__*/React$1.createElement("div", {
        key: r._id,
        className: clsx('child-container', r["new"] && 'new', r.removed && 'removed')
      }, /*#__PURE__*/React$1.createElement("div", {
        className: 'child-text'
      }, r.removed ? /*#__PURE__*/React$1.createElement(LinkOff, {
        className: 'link-icon'
      }) : /*#__PURE__*/React$1.createElement(LinkTwoToneIcon, {
        className: 'link-icon'
      }), /*#__PURE__*/React$1.createElement("span", null, "".concat(r.entityName, " (").concat(r.entityType, ")"))), !r.removed ? /*#__PURE__*/React$1.createElement("div", {
        className: "delete-button",
        onClick: function onClick() {
          return removeRelated({
            related: r,
            entityId: entity._id
          });
        }
      }, /*#__PURE__*/React$1.createElement("i", {
        className: 'fa fa-times',
        "aria-hidden": "true"
      })) : /*#__PURE__*/React$1.createElement("div", {
        className: "delete-button",
        onClick: function onClick() {
          return recoverRelated({
            related: r,
            entityId: entity._id
          });
        }
      }, /*#__PURE__*/React$1.createElement("i", {
        className: 'fa fa-undo',
        "aria-hidden": "true"
      })));
    })));
  }))));
};

var SearchPanel = function SearchPanel(_ref) {
  var onEntityTypeChange = _ref.onEntityTypeChange,
    selectedEntityType = _ref.selectedEntityType,
    entityTypeOptions = _ref.entityTypeOptions,
    _ref$entityTypeSelect = _ref.entityTypeSelectors,
    entityTypeSelectors = _ref$entityTypeSelect === void 0 ? [] : _ref$entityTypeSelect,
    doFetch = _ref.doFetch;
  return /*#__PURE__*/React$1.createElement(React$1.Fragment, null, /*#__PURE__*/React$1.createElement("div", {
    className: 'panel-title'
  }, "Search"), /*#__PURE__*/React$1.createElement(SimpleSelect, {
    className: 'entity-select',
    placeholder: "Select an Entity Type to relate to",
    options: entityTypeOptions,
    handleChange: onEntityTypeChange,
    value: selectedEntityType
  }), selectedEntityType && /*#__PURE__*/React$1.createElement("div", {
    className: 'inner-panel'
  }, /*#__PURE__*/React$1.createElement(EnhancedFetchControl, {
    selectors: entityTypeSelectors,
    doFetch: doFetch
  })));
};

var RelatePanel = function RelatePanel(_ref) {
  var selectedEntityType = _ref.selectedEntityType,
    selectedEntities = _ref.selectedEntities,
    checkedEntities = _ref.checkedEntities,
    appliedFilters = _ref.appliedFilters,
    fetching = _ref.fetching,
    entityPlural = _ref.entityPlural,
    searchedEntities = _ref.searchedEntities,
    parentEntities = _ref.parentEntities,
    relate = _ref.relate,
    applySearchFiltering = _ref.applySearchFiltering,
    setSelectedSearchedEntities = _ref.setSelectedSearchedEntities;
  var RELATIONS_WARNING_MESSAGE = "This entity is related to: ";
  var getWarningMessage = function getWarningMessage(shouldDisplayWarning, entity) {
    return shouldDisplayWarning ? RELATIONS_WARNING_MESSAGE + parentEntities.filter(function (p) {
      return p.related.some(function (r) {
        return r._id === entity._id;
      });
    }).map(function (x) {
      return x.entityName;
    }).join() : "";
  };
  var getEntitiesWithRelationsWarnings = function getEntitiesWithRelationsWarnings() {
    return searchedEntities.map(function (e) {
      return _objectSpread2(_objectSpread2({}, e), {}, {
        EntityWarningMessage: getWarningMessage(parentEntities.some(function (p) {
          return p.related.some(function (r) {
            return r._id === e._id;
          });
        }), e)
      });
    });
  };
  return /*#__PURE__*/React$1.createElement(React$1.Fragment, null, /*#__PURE__*/React$1.createElement("div", {
    className: 'panel-title'
  }, "Relate"), /*#__PURE__*/React$1.createElement("div", {
    className: "tree-container"
  }, selectedEntityType && /*#__PURE__*/React$1.createElement(EntitySelectionPanel, {
    selectedGroups: undefined,
    selectedFilters: appliedFilters,
    selectedEntities: selectedEntities,
    fetching: fetching,
    entities: getEntitiesWithRelationsWarnings(),
    onSelect: function onSelect(entities) {
      return setSelectedSearchedEntities(entities);
    },
    treeSelectMode: TreeSelectMode.NONE_MEANS_NONE,
    onGroupOrFilterChange: function onGroupOrFilterChange(changes) {
      return applySearchFiltering(changes.filters);
    },
    leafNodeRenderer: leafNodeRenderer,
    branchNodeRenderer: branchNodeRenderer,
    name: selectedEntityType + "_selection_panel",
    entitySingular: selectedEntityType,
    entityPlural: entityPlural
  })), /*#__PURE__*/React$1.createElement("div", {
    className: 'add-button-container'
  }, /*#__PURE__*/React$1.createElement(GenericMatButton, {
    disabled: checkedEntities.every(function (e) {
      return !e.checked;
    }) || _.isEmpty(selectedEntities),
    customClasses: "add-button",
    onClick: function onClick() {
      return relate(selectedEntities);
    }
  }, "Add")));
};

var css_248z$k = ".overlay {\n  width: 100%;\n  height: 100%;\n  background: white;\n  position: absolute;\n  z-index: 100;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  opacity: 0;\n  pointer-events: none;\n}\n.overlay.fade {\n  transition: opacity 2s;\n}\n.overlay.shown {\n  opacity: 1;\n  pointer-events: all;\n}";
styleInject(css_248z$k);

var Overlay = function Overlay(_ref) {
  var children = _ref.children,
    _ref$config = _ref.config,
    show = _ref$config.show,
    duration = _ref$config.duration,
    onFadeOut = _ref$config.onFadeOut,
    content = _ref$config.content,
    noFade = _ref$config.noFade;
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    durationElapsed = _useState2[0],
    setDurationElapsed = _useState2[1];
  useEffect(function () {
    setDurationElapsed(false);
    if (duration) {
      setTimeout(function () {
        setDurationElapsed(true);
        onFadeOut();
      }, duration);
    }
  }, [show, duration, onFadeOut]);
  return /*#__PURE__*/React$1.createElement("div", {
    className: clsx('overlay', !noFade && 'fade', show && !durationElapsed && 'shown')
  }, content || children);
};

var RawRelationsModal = function RawRelationsModal(_ref) {
  var originalParentEntities = _ref.entity,
    action = _ref.action,
    parentEntities = _ref.parentEntities,
    retrieveRelated = _ref.retrieveRelated,
    close = _ref.close,
    entitySelectConfig = _ref.entitySelectConfig,
    fetchingRelated = _ref.fetchingRelated,
    searchEntities = _ref.searchEntities,
    searchedEntities = _ref.searchedEntities,
    fetching = _ref.fetching,
    appliedFilters = _ref.appliedFilters,
    selectedEntities = _ref.selectedEntities,
    resetSearchedEntities = _ref.resetSearchedEntities,
    addRelated = _ref.addRelated,
    applyRelationChanges = _ref.applyRelationChanges,
    removeRelated = _ref.removeRelated,
    entitiesChanged = _ref.entitiesChanged,
    applySearchFiltering = _ref.applySearchFiltering,
    setSelectedSearchedEntities = _ref.setSelectedSearchedEntities,
    recoverRelated = _ref.recoverRelated;
  var _useState = useState(''),
    _useState2 = _slicedToArray(_useState, 2),
    selectedEntityType = _useState2[0],
    setSelectedEntityType = _useState2[1];
  var _useChecked = useChecked(parentEntities),
    handleCheck = _useChecked.handleCheck,
    checkedEntities = _useChecked.items,
    resetChecked = _useChecked.resetChecked;
  var _useState3 = useState({
      show: false
    }),
    _useState4 = _slicedToArray(_useState3, 2),
    overlay = _useState4[0],
    setOverlay = _useState4[1];
  useEffect(function () {
    //Since the modal gets reused and is not disposed of, we need to reset everything
    var originalEntitiesArray = Array.isArray(originalParentEntities) ? originalParentEntities : [originalParentEntities];
    setSelectedEntityType('');
    setOverlay({
      show: false
    });
    resetSearchedEntities();
    resetChecked(originalEntitiesArray);
    if (_$1.isEmpty(originalParentEntities)) {
      setOverlay({
        show: true,
        duration: 3000,
        noFade: true,
        onFadeOut: close,
        content: /*#__PURE__*/React$1.createElement("div", null, "No entities selected")
      });
      return;
    }
    retrieveRelated(originalEntitiesArray, action.getScript, action.relatedTypes);
  }, [retrieveRelated, originalParentEntities, action.getScript]);
  var doFetch = function doFetch() {
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    searchEntities.apply(void 0, [entitySelectConfig.find(function (e) {
      return e.entityName === selectedEntityType;
    }).script].concat(args));
  };
  var handleSearchedEntityTypeChange = function handleSearchedEntityTypeChange(selected) {
    setSelectedEntityType(selected);
    resetSearchedEntities();
  };
  var relate = function relate(relatedEntities) {
    var entityIds = getCheckedEntities().filter(function (e) {
      return e.checked;
    }).map(function (p) {
      return p._id;
    });
    var relatedType = action.relatedTypes.find(function (rt) {
      return rt.singular === selectedEntityType;
    });
    var related = relatedEntities.map(function (c) {
      return {
        _id: c._id,
        entityName: c['Entity Name'],
        entityType: selectedEntityType
      };
    });
    addRelated({
      entityIds: entityIds,
      relatedType: relatedType,
      related: related
    });
  };
  var applyChanges = /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
      return _regenerator().w(function (_context) {
        while (1) switch (_context.n) {
          case 0:
            setOverlay({
              show: true,
              content: /*#__PURE__*/React$1.createElement("div", null, "Updating relations...")
            });
            _context.n = 1;
            return applyRelationChanges(action.updateScript, action.relatedTypes.map(function (rt) {
              return rt.singular;
            }));
          case 1:
            setOverlay({
              show: true,
              duration: 2000,
              onFadeOut: close,
              content: /*#__PURE__*/React$1.createElement("div", null, "Relations successfully updated!")
            });

            //if the original entities were not an array, we were acting on a single entity
            //if so we need to update the entity by calling the actions success method to get
            //the entity to update in the UI
            setTimeout(function () {
              if (!Array.isArray(originalParentEntities)) action.onSuccess(action.type, originalParentEntities);
            }, 0); //For some reason if we do this synchronously, it messes up with the script. TODO: Find the root cause and remove the setTimeout
          case 2:
            return _context.a(2);
        }
      }, _callee);
    }));
    return function applyChanges() {
      return _ref2.apply(this, arguments);
    };
  }();
  var cancel = function cancel() {
    if (!entitiesChanged) {
      close();
    } else {
      var content = /*#__PURE__*/React$1.createElement("div", null, /*#__PURE__*/React$1.createElement("div", null, "There are unsaved changes. Are you sure you want to leave?"), /*#__PURE__*/React$1.createElement("div", {
        className: 'buttons'
      }, /*#__PURE__*/React$1.createElement(GenericMatButton, {
        customClasses: "cancel-button",
        onClick: close
      }, "Close anyway"), /*#__PURE__*/React$1.createElement(GenericMatButton, {
        customClasses: "main-button",
        onClick: function onClick() {
          return setOverlay({
            show: false
          });
        }
      }, "Keep editing")));
      setOverlay({
        show: true,
        onFadeOut: close,
        content: content
      });
    }
  };
  var getFromSelectedEntitySelectConfig = function getFromSelectedEntitySelectConfig(path) {
    return _$1.get(entitySelectConfig.find(function (e) {
      return e.entityName === selectedEntityType;
    }), path);
  };
  var getCheckedEntities = function getCheckedEntities() {
    return parentEntities.map(function (p) {
      return _objectSpread2(_objectSpread2({}, p), {}, {
        checked: _$1.get(checkedEntities.find(function (c) {
          return c._id === p._id;
        }), 'checked', false)
      });
    });
  };
  var handleCheckById = function handleCheckById(_ref3) {
    var _id = _ref3._id;
    return handleCheck(checkedEntities.find(function (c) {
      return c._id === _id;
    }));
  };
  return /*#__PURE__*/React$1.createElement(GenericModal, {
    title: 'Relate entities',
    customClasses: 'relations-modal',
    noPadding: true,
    noBackground: true,
    modalBody: /*#__PURE__*/React$1.createElement("div", {
      className: 'relations-modal-body'
    }, /*#__PURE__*/React$1.createElement(Overlay, {
      config: overlay
    }), /*#__PURE__*/React$1.createElement("div", {
      className: 'panels'
    }, /*#__PURE__*/React$1.createElement(SummaryPanel, {
      parentEntities: parentEntities,
      checkedEntities: getCheckedEntities(),
      fetching: fetchingRelated,
      handleCheck: handleCheckById,
      entityTypeOptions: action.relatedTypes.map(function (rt) {
        return rt.singular;
      }),
      removeRelated: removeRelated,
      recoverRelated: recoverRelated
    }), /*#__PURE__*/React$1.createElement("div", {
      className: 'panel no-padding'
    }, /*#__PURE__*/React$1.createElement(SearchPanel, {
      onEntityTypeChange: handleSearchedEntityTypeChange,
      selectedEntityType: selectedEntityType,
      entityTypeOptions: entitySelectConfig.filter(function (e) {
        return action.relatedTypes.map(function (rt) {
          return rt.singular;
        }).includes(e.entityName);
      }).map(function (e) {
        return e.entityName;
      }),
      entityTypeSelectors: getFromSelectedEntitySelectConfig('selectors'),
      doFetch: doFetch
    })), /*#__PURE__*/React$1.createElement("div", {
      className: 'panel no-padding'
    }, /*#__PURE__*/React$1.createElement(RelatePanel, {
      selectedEntityType: selectedEntityType,
      selectedEntities: selectedEntities,
      entityPlural: getFromSelectedEntitySelectConfig('entityPluralName'),
      appliedFilters: appliedFilters,
      fetching: fetching,
      searchedEntities: searchedEntities,
      parentEntities: parentEntities,
      checkedEntities: getCheckedEntities(),
      relate: relate,
      applySearchFiltering: applySearchFiltering,
      setSelectedSearchedEntities: setSelectedSearchedEntities
    }))), /*#__PURE__*/React$1.createElement("div", {
      className: 'buttons'
    }, /*#__PURE__*/React$1.createElement(GenericMatButton, {
      customClasses: "cancel-button",
      onClick: cancel
    }, "Cancel"), /*#__PURE__*/React$1.createElement(GenericMatButton, {
      disabled: !entitiesChanged,
      customClasses: "main-button",
      onClick: applyChanges
    }, "Apply")))
  });
};
var mapStateToProps$1 = function mapStateToProps(state) {
  return {
    parentEntities: getParentEntities(state),
    entitySelectConfig: getEntitySelectConfig(state),
    searchedEntities: getAllCurrentSearchedEntities(state),
    fetching: getSearchingCurrent(state),
    appliedFilters: getAppliedSearchFilters(state),
    selectedEntities: getSelectedSearchedEntities(state),
    fetchingRelated: getFetchingRelatedEntities(state),
    entitiesChanged: getEntitiesChanged(state)
  };
};
var mapDispatchToProps$1 = {
  retrieveRelated: retrieveRelated,
  searchEntities: searchEntities,
  setSelectedSearchedEntities: setSelectedSearchedEntities,
  applySearchFiltering: applySearchFiltering,
  resetSearchedEntities: resetSearchedEntities,
  addRelated: addRelated,
  applyRelationChanges: applyRelationChanges,
  removeRelated: removeRelated,
  recoverRelated: recoverRelated
};
var RelationsModal = compose(connect(mapStateToProps$1, mapDispatchToProps$1))(RawRelationsModal);
var RelationsModalFactory = {
  create: function create(_ref4) {
    var type = _ref4.type,
      action = _ref4.action,
      entity = _ref4.entity,
      context = _ref4.context;
    var modal = /*#__PURE__*/React$1.createElement(RelationsModal, {
      action: action,
      entity: entity,
      type: type,
      close: function close() {
        return context.ifefShowModal(false);
      },
      context: context
    });
    context.ifefShowModal(modal);
    return modal;
  }
};

var css_248z$l = ".configured-image-component {\n  width: 100%;\n  height: 100%;\n}\n.configured-image-component .configured-image-container {\n  width: 100%;\n  height: 100%;\n  border-radius: 25px;\n  background-size: cover;\n  background-repeat: no-repeat;\n  text-align: center;\n}\n.configured-image-component .clickable {\n  cursor: pointer;\n}";
styleInject(css_248z$l);

var Image = function Image(_ref) {
  var script = _ref.script,
    url = _ref.url,
    filename = _ref.filename,
    styles = _ref.styles,
    navigateTo = _ref.navigateTo,
    query = _ref.query,
    dashboard = _ref.dashboard;
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    imageUrl = _useState2[0],
    setImageUrl = _useState2[1];
  useEffect(function () {
    var fetchData = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
        var result;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              if (!url) {
                _context.n = 1;
                break;
              }
              setImageUrl(url);
              _context.n = 4;
              break;
            case 1:
              if (!filename) {
                _context.n = 2;
                break;
              }
              FileHelpers.getFileUrlForFilename(filename).then(function (url) {
                setImageUrl(url);
              });
              _context.n = 4;
              break;
            case 2:
              _context.n = 3;
              return ScriptHelper.executeScript(script);
            case 3:
              result = _context.v;
              if (result.fileId) FileHelpers.getFileUrl(result.fileId).then(function (url) {
                return setImageUrl(url);
              });
            case 4:
              return _context.a(2);
          }
        }, _callee);
      }));
      return function fetchData() {
        return _ref2.apply(this, arguments);
      };
    }();
    fetchData();
  }, [script, url, filename]);
  var handleClick = function handleClick() {
    if (navigateTo && dashboard) {
      var action = {
        type: 'navigate',
        navigateTo: navigateTo,
        query: query
      };
      dashboard.doAction(action);
    }
  };
  var component = /*#__PURE__*/React$1.createElement("div", null, "Loading");
  if (imageUrl) {
    styles = styles ? styles : {
      maxWidth: "100%",
      maxHeight: "100%"
    };
    component = /*#__PURE__*/React$1.createElement("div", {
      className: clsx("configured-image-container", navigateTo && dashboard && 'clickable'),
      onClick: handleClick
    }, /*#__PURE__*/React$1.createElement("img", {
      src: imageUrl,
      style: styles
    }));
  }
  return /*#__PURE__*/React$1.createElement("div", {
    style: {
      padding: '15px',
      width: '100%',
      height: '100%'
    }
  }, /*#__PURE__*/React$1.createElement("div", {
    className: "configured-image-component"
  }, component));
};
var ImageFactory = {
  create: function create(_ref3) {
    var config = _ref3.config,
      data = _ref3.data;
    return /*#__PURE__*/React$1.createElement(Image, _extends({}, config, data));
  }
};

var SimpleTableFactory = {
  create: function create(_ref) {
    var config = _ref.config,
      data = _ref.data;
    if (config.columns) return /*#__PURE__*/React$1.createElement(SimpleTable, {
      className: config.className,
      objects: data,
      columns: config.columns
    });else return /*#__PURE__*/React$1.createElement(SimpleTable, {
      className: config.className,
      rows: data
    });
  }
};
var SimpleTabbedTableFactory = {
  create: function create(_ref2) {
    var _config$components;
    var config = _ref2.config,
      data = _ref2.data;
    var flattenedGroupedAndHiddenProps = [];
    if (config.groups) {
      Object.values(config.groups).forEach(function (props) {
        return flattenedGroupedAndHiddenProps.push.apply(flattenedGroupedAndHiddenProps, _toConsumableArray(props));
      });
    }
    if (config !== null && config !== void 0 && (_config$components = config.components) !== null && _config$components !== void 0 && _config$components.hidden) {
      flattenedGroupedAndHiddenProps.push.apply(flattenedGroupedAndHiddenProps, _toConsumableArray(config.components.hidden));
    }
    var allProps = Object.keys(data);
    var otherProps = allProps.filter(function (prop) {
      return !flattenedGroupedAndHiddenProps.includes(prop);
    });
    var tabs = _objectSpread2({}, config.groups);
    if (otherProps.length > 0) {
      tabs["Other"] = otherProps;
    }
    return /*#__PURE__*/React$1.createElement(SimpleTabbedTable, {
      className: config.className,
      data: data,
      tabs: tabs
    });
  }
};
var SimpleTableGroupFactory = {
  create: function create(_ref3) {
    var config = _ref3.config,
      data = _ref3.data;
    // to do - pass in a getRow func as part of config?
    var _getRow = function _getRow(obj) {
      if (obj && obj.dName) return [obj.dName, typeof obj.val != 'undefined' ? obj.val + (obj.uom ? " " + obj.uom : "") : ""];else return ["Configured property does not exist", ""];
    };
    var groupedData = {};
    var assigned = new Set();
    Object.keys(config.groups).forEach(function (g) {
      var rows = [];
      config.groups[g].filter(function (attr) {
        return !(config.hidden || []).includes(attr);
      }).forEach(function (attr) {
        rows.push(_getRow(data[attr]));
        assigned.add(attr);
      });
      groupedData[g] = rows;
    });
    var remaining = [];
    Object.keys(data).sort().forEach(function (attr) {
      if (!assigned.has(attr)) {
        remaining.push(_getRow(data[attr]));
      }
    });
    groupedData["Other"] = remaining;
    var components = Object.keys(config.groups).map(function (g) {
      return /*#__PURE__*/React$1.createElement("div", {
        key: "table-for-group-" + g,
        className: "simple-table-group"
      }, /*#__PURE__*/React$1.createElement("div", {
        className: config.groupClassName
      }, g), /*#__PURE__*/React$1.createElement(SimpleTable, {
        className: config.tableClassName,
        rows: groupedData[g]
      }));
    });

    //only add Other group if there are other entries
    if (groupedData["Other"].length) components.push(/*#__PURE__*/React$1.createElement("div", {
      key: "table-for-group-other",
      className: "simple-table-group"
    }, /*#__PURE__*/React$1.createElement("div", {
      className: config.groupClassName
    }, "Other"), /*#__PURE__*/React$1.createElement(SimpleTable, {
      className: config.tableClassName,
      rows: groupedData["Other"]
    })));
    return /*#__PURE__*/React$1.createElement("div", {
      className: "simple-grouped-table " + config.className
    }, components);
  }
};

var ENTITY_ACTION_COMPONENTS = {
  "EntityModal": EntityModalFactory,
  "RelationsModal": RelationsModalFactory,
  "EntityCollectionModal": EntityCollectionModalFactory,
  "EntityRelationsModal": EntityRelationsModalFactory
};
var ENTITY_DATA_COMPONENTS = {
  "SimpleTable": SimpleTableFactory,
  "SimpleTableGroup": SimpleTableGroupFactory,
  "SimpleTabbedTable": SimpleTabbedTableFactory,
  "Image": ImageFactory,
  "ScriptedChart": ScriptedChartFactory
};
var applicatonActionComponents = {};
var addApplicationActionComponent = function addApplicationActionComponent(component) {
  return applicatonActionComponents[component.name] = component.component;
};
var applicatonDataComponents = {};
var addApplicationDataComponent = function addApplicationDataComponent(component) {
  return applicatonDataComponents[component.name] = component.component;
};
var initialState$4 = {
  frameworkActionComponents: Object.keys(ENTITY_ACTION_COMPONENTS),
  applicationActionComponents: [],
  frameworkDataComponents: Object.keys(ENTITY_DATA_COMPONENTS),
  applicationDataComponents: []
};
var entityUI = createSlice({
  name: 'entityUI',
  initialState: initialState$4,
  reducers: {
    setApplicationActionComponents: function setApplicationActionComponents(state, _ref) {
      var entityActionComponents = _ref.payload;
      state.applicationActionComponents = entityActionComponents;
    },
    setApplicationDataComponents: function setApplicationDataComponents(state, _ref2) {
      var entityDataComponents = _ref2.payload;
      state.applicationDataComponents = entityDataComponents;
    }
  }
});
var actions$3 = entityUI.actions,
  reducer$4 = entityUI.reducer;

//Action creators
var setApplicationActionComponents = actions$3.setApplicationActionComponents,
  setApplicationDataComponents = actions$3.setApplicationDataComponents;

//Thunks
var addEntityComponents = function addEntityComponents(componentType, components) {
  return function (dispatch, getState) {
    if (componentType === 'action') {
      components.forEach(function (comp) {
        addApplicationActionComponent(comp);
      });
      var newActionComponents = Object.keys(applicatonActionComponents);
      dispatch(setApplicationActionComponents(newActionComponents));
    } else if (componentType === 'data') {
      components.forEach(function (comp) {
        addApplicationDataComponent(comp);
      });
      var entityDataComponents = Object.keys(applicatonDataComponents);
      dispatch(setApplicationDataComponents(entityDataComponents));
    } else {
      console.error("Incorrect Entity Component UI type");
    }
  };
};
var getEntityActionComponent = function getEntityActionComponent(componentName) {
  return function (dispatch, getState) {
    var component = null;
    component = applicatonActionComponents[componentName];
    if (!component) component = ENTITY_ACTION_COMPONENTS[componentName];
    return component;
  };
};
var getEntityDataComponent = function getEntityDataComponent(componentName) {
  return function (dispatch, getState) {
    var component = null;
    component = applicatonDataComponents[componentName];
    if (!component) component = ENTITY_DATA_COMPONENTS[componentName];
    return component;
  };
};

var css_248z$m = ".entity-actions-panel {\n  display: flex;\n  align-items: center;\n  flex-wrap: wrap;\n}";
styleInject(css_248z$m);

var css_248z$n = ".action-button {\n  width: 40px;\n  height: 40px;\n  text-align: center;\n  background-color: var(--app-accent-color);\n  color: white;\n  border-radius: 10px;\n  font-size: 20px;\n  margin: 3px;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  cursor: pointer;\n}\n.action-button i {\n  padding: 0;\n}\n.action-button .inv-icon-nav {\n  background-position: 0;\n}\n.action-button .inv-icon-svg {\n  width: 42px;\n  height: 42px;\n  display: inline-block;\n  background-repeat: no-repeat;\n  background-position: 0;\n}\n.action-button.inv-icon__masked {\n  width: 20px;\n  height: 20px;\n}\n.action-button {\n  /*this is to style font icons, not svg*/\n}\n.action-button:not(.inv-icon-svg).inv-icon__masked {\n  width: 20px;\n  height: 20px;\n  font-size: inherit;\n  margin: 0;\n  padding: 3px;\n  background-color: white;\n  color: var(--app-accent-color);\n}";
styleInject(css_248z$n);

function ActionButton(props) {
  return /*#__PURE__*/React$1.createElement("span", {
    className: "action-button"
  }, /*#__PURE__*/React$1.createElement(Tooltip, {
    title: props.title
  }, /*#__PURE__*/React$1.createElement("i", {
    className: props.icon,
    onClick: props.onClick
  })));
}

var EntityActionsPanel = function EntityActionsPanel(_ref) {
  var actions = _ref.actions,
    entity = _ref.entity,
    type = _ref.type,
    context = _ref.context,
    getEntityActionComponent = _ref.getEntityActionComponent,
    iconRenderer = _ref.iconRenderer;
  var icons = [];
  var reduxStore = useStore();
  var runPreEntityActionScript = /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(payload) {
      var _type$singular;
      var action, entity, type, result;
      return _regenerator().w(function (_context) {
        while (1) switch (_context.n) {
          case 0:
            action = payload.action, entity = payload.entity, type = payload.type;
            if (action.preActionScript) {
              _context.n = 1;
              break;
            }
            return _context.a(2, entity);
          case 1:
            _context.n = 2;
            return ScriptHelper.executeScript(action.preActionScript, {
              entity: entity,
              entityType: action.entitySchema ? action.entitySchema : type === null || type === void 0 || (_type$singular = type.singular) === null || _type$singular === void 0 ? void 0 : _type$singular.toLowerCase()
            });
          case 2:
            result = _context.v;
            return _context.a(2, result !== null && result !== void 0 ? result : entity);
        }
      }, _callee);
    }));
    return function runPreEntityActionScript(_x) {
      return _ref2.apply(this, arguments);
    };
  }();
  var renderIcons = function renderIcons(icons) {
    return iconRenderer ? iconRenderer(icons) : /*#__PURE__*/React$1.createElement("div", {
      className: "entity-actions-panel"
    }, icons);
  };
  var doAction = /*#__PURE__*/function () {
    var _ref3 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(actionName) {
      var action, result, factory, _newEntity, _newEntity2, origEntity, _result;
      return _regenerator().w(function (_context2) {
        while (1) switch (_context2.n) {
          case 0:
            action = _$1.cloneDeep(actions[actionName]); // populate the specific action with info needed by the action component
            action.name = actionName;
            action.onClick = actions.onClick;
            action.doEntityAction = actions.doEntityAction;
            action.onSuccess = actions.onSuccess;
            action.onError = actions.onError;
            action.onCancel = actions.onCancel;
            if (!action.standalone) {
              _context2.n = 2;
              break;
            }
            _context2.n = 1;
            return action.onClick(entity);
          case 1:
            result = _context2.v;
            if (result.success) {
              if (action.onSuccess) {
                action.onSuccess(action.type, newEntity, result);
              }
            } else {
              if (action.onError) action.onError(action.type, entity, result);
            }
            _context2.n = 8;
            break;
          case 2:
            if (!action.component) {
              _context2.n = 5;
              break;
            }
            // if there's a component then create it and let it handle the execution
            factory = getEntityActionComponent(action.component.name);
            if (factory) {
              _context2.n = 3;
              break;
            }
            console.error("No factory for " + action.component.name);
            return _context2.a(2, null);
          case 3:
            _newEntity = Array.isArray(entity) ? _toConsumableArray(entity) : _objectSpread2({}, entity);
            _context2.n = 4;
            return runPreEntityActionScript({
              action: action,
              entity: _newEntity,
              type: type
            });
          case 4:
            _newEntity = _context2.v;
            // the factory create method can use the app context to display the component
            // e.g. context.ifefShowModal(modal)
            factory.create({
              action: action,
              entity: _newEntity,
              type: type,
              context: context,
              reduxStore: reduxStore
            });
            _context2.n = 8;
            break;
          case 5:
            // if there's no component execute the action directly
            _newEntity2 = action.showOnTable && Array.isArray(entity) ? _toConsumableArray(entity) : Object.assign({}, entity);
            _context2.n = 6;
            return runPreEntityActionScript({
              action: action,
              entity: _newEntity2,
              type: type
            });
          case 6:
            _newEntity2 = _context2.v;
            origEntity = action.showOnTable && !Array.isArray(entity) ? [_objectSpread2({}, entity)] : entity;
            _context2.n = 7;
            return action.doEntityAction(action.name, {
              "new": _newEntity2,
              original: origEntity
            }, type);
          case 7:
            _result = _context2.v;
            if (_result !== null && _result !== void 0 && _result.success) {
              if (action.onSuccess) {
                action.onSuccess(action.type, _newEntity2, _result);
              }
            } else {
              if (action.onError) action.onError(action.type, entity, _result);
            }
          case 8:
            return _context2.a(2);
        }
      }, _callee2);
    }));
    return function doAction(_x2) {
      return _ref3.apply(this, arguments);
    };
  }();
  if (actions) {
    Object.keys(actions).forEach(function (actionName) {
      var action = actions[actionName];
      if (action.allow) icons.push(/*#__PURE__*/React$1.createElement(ActionButton, {
        key: "icon-" + actionName,
        icon: action.icon,
        title: action.title || actionName,
        onClick: function onClick(e) {
          return doAction(actionName);
        }
      }));
    });
  }
  return renderIcons(icons);
};

//export default EntityActionsPanel
var mapStateToProps$2 = function mapStateToProps(state) {
  return {};
};
var mapDispatchToProps$2 = {
  getEntityActionComponent: getEntityActionComponent
};
var EntityActionsPanel$1 = compose(connect(mapStateToProps$2, mapDispatchToProps$2))(EntityActionsPanel);

var css_248z$o = ".entity-list-view-root .entity-list-view-count {\n  margin: 10px 0;\n}\n.entity-list-view-root {\n  /* unify icon font-size across different font systems*/\n}\n.entity-list-view-root .action-button {\n  font-size: 1.5em;\n}\n.entity-list-view-root .action-button i {\n  font-size: 1em !important;\n}\n.entity-list-view-root table.entity-table {\n  border-spacing: 0;\n  border-collapse: separate; /*important for sticky column bordering*/\n}\n.entity-list-view-root table.entity-table tr {\n  position: relative; /*required to calculate offset*/\n}\n.entity-list-view-root .actions-panel {\n  display: flex;\n  justify-content: flex-end;\n}\n.entity-list-view-root .entity-list-view-count {\n  margin: 10px 0;\n}\n.entity-list-view-root div.header-row {\n  /* only div - these styles should NOT apply to table elements thead, th or th */\n  height: 50px;\n  display: flex;\n}\n.entity-list-view-root .header-row {\n  background-color: #F2F2F2;\n  border-bottom: 3px solid #eaeaea;\n  user-select: text;\n}\n.entity-list-view-root .header-row div.header-column {\n  /* only div - these styles should NOT apply to table elements thead, th or th */\n  height: 100%;\n  align-items: center;\n  display: flex;\n  flex: 1;\n}\n.entity-list-view-root .header-row div.header-column.checkbox {\n  display: flex;\n  justify-content: center;\n}\n.entity-list-view-root .header-row .header-column:not(.checkbox) {\n  padding: 10px;\n  color: #666666;\n  font-weight: 500;\n  letter-spacing: 1;\n  border-left: 1px solid #eaeaea;\n  border-right: 1px solid #eaeaea;\n  cursor: pointer;\n}\n.entity-list-view-root .header-row .header-column:not(.checkbox) i {\n  margin-left: 20px;\n}\n.entity-list-view-root .header-row .header-column:not(.checkbox) .MuiTableSortLabel-root {\n  display: flex; /*this is to force sorting arrow to the right*/\n}\n.entity-list-view-root .header-row .header-column.checkbox {\n  max-width: 48px;\n  justify-content: center;\n}\n.entity-list-view-root .header-row .header-column.sticky {\n  position: sticky;\n  left: 0;\n  background-color: #F2F2F2;\n  z-index: 1;\n}\n.entity-list-view-root .header-row .header-column.sticky.first {\n  border-right: 1px solid #ddd;\n}\n.entity-list-view-root .header-row .header-column.sticky-end {\n  right: 0px;\n  border-left: 1px solid #ddd;\n}\n.entity-list-view-root .header-row :first-child {\n  border-left: none;\n}\n.entity-list-view-root .header-row :last-child {\n  border-right: none;\n}\n.entity-list-view-root div.content-row {\n  /* only div - these styles should NOT apply to table elements thead, th or th */\n  display: flex;\n}\n.entity-list-view-root .content-row {\n  border-bottom: 3px solid #eaeaea;\n  user-select: text;\n}\n.entity-list-view-root .content-row div.content-column {\n  height: 100%;\n  align-items: center;\n  display: flex;\n  flex: 1;\n}\n.entity-list-view-root .content-row .content-column {\n  background-color: white;\n}\n.entity-list-view-root .content-row .content-column:not(.checkbox) {\n  padding: 10px;\n  color: #666666;\n  letter-spacing: 1;\n  word-break: break-word;\n}\n.entity-list-view-root .content-row .content-column:not(.checkbox).first {\n  color: var(--app-accent-color);\n  cursor: pointer;\n  font-weight: 500;\n  min-width: 150px;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n.entity-list-view-root .content-row .content-column.checkbox {\n  max-width: 48px;\n  justify-content: center;\n}\n.entity-list-view-root .content-row .content-column.sticky {\n  position: sticky;\n  left: 0;\n  background-color: white;\n  z-index: 1;\n}\n.entity-list-view-root .content-row .content-column.sticky.first {\n  border-right: 1px solid #ddd;\n}\n.entity-list-view-root .content-row .content-column.sticky-end {\n  right: 0px;\n  left: auto;\n  border-left: 1px solid #ddd;\n}\n.entity-list-view-root .content-row .content-column.entity-actions-cell {\n  padding: 0px !important;\n}\n.entity-list-view-root .content-row .content-column.entity-actions-cell .entity-actions-panel {\n  flex-wrap: nowrap;\n}";
styleInject(css_248z$o);

var ASCENDING_ORDER = 'asc';
var DESCENDING_ORDER = 'desc';
var ENTITY_LIST_SORT_PREFERENCE = 'entityListSortPreference';
function useSortEntities(entitySingular, onSortChange) {
  var initialSort = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {
    property: 'Entity Name',
    valueAccessor: 'Entity Name',
    order: ASCENDING_ORDER
  };
  var key = ENTITY_LIST_SORT_PREFERENCE + entitySingular;
  var sessionPreference = sessionStorage.getItem(key);
  var sortPreference = sessionPreference ? JSON.parse(sessionPreference) : initialSort;
  var _useState = useState(sortPreference),
    _useState2 = _slicedToArray(_useState, 2),
    currentSort = _useState2[0],
    setSort = _useState2[1];
  var sortEntitiesBy = function sortEntitiesBy(colAccessor) {
    var order = currentSort.property == colAccessor ? currentSort.order == ASCENDING_ORDER ? DESCENDING_ORDER : ASCENDING_ORDER : ASCENDING_ORDER;
    //TODO: we might need a better condition than to check if the column accessor has a . in it. This condition will hold for all properties however.
    var sortValue = {
      valueAccessor: !colAccessor.includes('.') || colAccessor.includes('.val') ? colAccessor : colAccessor + '.val',
      property: colAccessor,
      order: order
    };
    setSort(sortValue);
    sessionStorage.setItem(key, JSON.stringify(sortValue));
  };
  useEffect(function () {
    onSortChange && onSortChange(currentSort);
  }, [currentSort]);
  return {
    sortEntitiesBy: sortEntitiesBy,
    currentSort: currentSort
  };
}
function convertOffsetToPage(offset, pageSize) {
  var pageOneBased = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var page = (offset + pageSize) / pageSize;
  return Math.floor(page) - (pageOneBased ? 0 : 1);
}
var paginateEntitiesReducer = function paginateEntitiesReducer(state, action) {
  switch (action.type) {
    case 'paginate':
      var page = action.page,
        rowsPerPage = action.rowsPerPage,
        count = action.count;
      return _objectSpread2(_objectSpread2({}, state), {}, {
        page: page,
        rowsPerPage: rowsPerPage,
        count: count
      });
    default:
      return _objectSpread2({}, state);
  }
};

/**
 *
 * @param initialPagination
 * @param onPageChange
 * @param onRowsPerPageChange
 * @returns {{count, paginateTableBy: paginateTableBy, page, rowsPerPage}}
 */
function usePaginateEntities(initialPagination, onPageChange, onRowsPerPageChange) {
  var _initialPagination$of = initialPagination.offset,
    initialOffset = _initialPagination$of === void 0 ? 0 : _initialPagination$of,
    _initialPagination$pa = initialPagination.pageSize,
    initialPageSize = _initialPagination$pa === void 0 ? 200 : _initialPagination$pa,
    _initialPagination$to = initialPagination.total,
    initialTotal = _initialPagination$to === void 0 ? 0 : _initialPagination$to;
  var initialPage = convertOffsetToPage(initialOffset, initialPageSize) * initialPageSize;
  var _useReducer = useReducer(paginateEntitiesReducer, {
      page: initialPage,
      rowsPerPage: initialPageSize,
      count: initialTotal
    }),
    _useReducer2 = _slicedToArray(_useReducer, 2),
    pagination = _useReducer2[0],
    dispatch = _useReducer2[1];
  var paginateTableBy = function paginateTableBy(_ref) {
    var offset = _ref.offset,
      pageSize = _ref.pageSize,
      total = _ref.total;
    var page = pagination.page,
      rowsPerPage = pagination.rowsPerPage,
      count = pagination.count;
    if (!isNaN(pageSize)) {
      rowsPerPage = pageSize;
    }
    if (!isNaN(total)) {
      count = total;
    }
    if (!isNaN(offset)) {
      page = convertOffsetToPage(offset, rowsPerPage);
    }
    dispatch({
      type: 'paginate',
      page: page,
      rowsPerPage: rowsPerPage,
      count: count
    });
  };
  useEffect(function () {
    onPageChange && onPageChange(pagination.page);
  }, [pagination.page]);
  useEffect(function () {
    onRowsPerPageChange && onRowsPerPageChange(pagination.rowsPerPage);
  }, [pagination.rowsPerPage]);
  var page = pagination.page,
    rowsPerPage = pagination.rowsPerPage,
    count = pagination.count;
  return {
    paginateTableBy: paginateTableBy,
    page: page,
    rowsPerPage: rowsPerPage,
    count: count
  };
}

var EntityListView = function EntityListView(_ref) {
  var config = _ref.config,
    entities = _ref.entities,
    onDetail = _ref.onDetail,
    actions = _ref.actions,
    context = _ref.context,
    onChange = _ref.onChange,
    onSortChange = _ref.onSortChange,
    selectedEntities = _ref.selectedEntities,
    _ref$entityPlural = _ref.entityPlural,
    entityPlural = _ref$entityPlural === void 0 ? 'Entities' : _ref$entityPlural,
    _ref$entitySingular = _ref.entitySingular,
    entitySingular = _ref$entitySingular === void 0 ? 'Entity' : _ref$entitySingular;
  var checkableEntities = useMemo(function () {
    return entities.map(function (entity) {
      var checked = !_$1.isEmpty(selectedEntities) && selectedEntities.findIndex(function (selectedEntity) {
        return entity._id === selectedEntity._id;
      }) !== -1;
      return _objectSpread2(_objectSpread2({}, entity), {}, {
        checked: checked
      });
    });
  }, [entities, selectedEntities]);
  var checkCallback = useCallback(function (entity) {
    var newEntities = checkableEntities.map(function (e) {
      return e._id === entity._id ? _objectSpread2(_objectSpread2({}, e), {}, {
        checked: !entity.checked
      }) : e;
    });
    onChange === null || onChange === void 0 || onChange(newEntities);
  }, [entities, selectedEntities]);
  var isAllChecked = checkableEntities.every(function (e) {
    return e.checked;
  });
  var allCheckCallback = useCallback(function () {
    var newEntities = entities.map(function (e) {
      return _objectSpread2(_objectSpread2({}, e), {}, {
        checked: !isAllChecked
      });
    });
    onChange === null || onChange === void 0 || onChange(newEntities);
  }, [entities, selectedEntities]);

  //If the selectedEntities props is used, we assume a controlled behaviour, uncontrolled otherwise
  var allChecked, handleCheck, handleAllCheck, entityInstances;
  if (selectedEntities) {
    allChecked = isAllChecked;
    handleCheck = checkCallback;
    handleAllCheck = allCheckCallback;
    entityInstances = checkableEntities;
  } else {
    var checkedObject = useChecked(entities, checkCallback, allCheckCallback);
    allChecked = checkedObject.allChecked;
    handleCheck = checkedObject.handleCheck;
    handleAllCheck = checkedObject.handleAllCheck;
    entityInstances = checkedObject.items;
  }
  var _useSortEntities = useSortEntities(entitySingular, onSortChange),
    sortEntitiesBy = _useSortEntities.sortEntitiesBy,
    currentSort = _useSortEntities.currentSort;
  var handleColumnClick = useCallback(function (col) {
    return function () {
      return sortEntitiesBy(col.accessor);
    };
  }, [sortEntitiesBy]);
  var buildHeader = useCallback(function (col) {
    return /*#__PURE__*/React$1.createElement("div", {
      key: col.name,
      onClick: handleColumnClick(col),
      className: "header-column"
    }, col.name, " ", col.accessor == currentSort.property && /*#__PURE__*/React$1.createElement("i", {
      className: currentSort.order == 'asc' ? "fas fa-angle-double-up" : "fas fa-angle-double-down"
    }));
  }, [sortEntitiesBy, currentSort]);
  var buildCell = useCallback(function (instance) {
    return function (col, i) {
      var value = _$1.get(instance, col.accessor);
      var dispValue = value && typeof value === 'string' ? value : value ? value.val : null;
      dispValue = isValidUrl(dispValue) ? /*#__PURE__*/React$1.createElement("a", {
        href: dispValue,
        target: "_blank"
      }, dispValue) : dispValue;
      var first = i === 0;
      return /*#__PURE__*/React$1.createElement("div", _extends({
        key: i,
        className: clsx({
          'content-column': true,
          ' first': first
        })
      }, first && {
        onClick: function onClick() {
          return onDetail(instance);
        }
      }), dispValue);
    };
  }, [onDetail]);
  var entityType = useMemo(function () {
    return {
      singular: entitySingular,
      plural: entityPlural
    };
  }, [entitySingular, entityPlural]);
  return /*#__PURE__*/React$1.createElement("div", {
    className: "entity-list-view-root entity-table ".concat((config === null || config === void 0 ? void 0 : config.className) || "")
  }, actions && /*#__PURE__*/React$1.createElement("div", {
    className: "actions-panel"
  }, /*#__PURE__*/React$1.createElement(EntityActionsPanel$1, {
    actions: actions,
    entity: entityInstances.filter(function (inst) {
      return inst.checked;
    }),
    type: entityType,
    context: context
  })), /*#__PURE__*/React$1.createElement("div", {
    className: "entity-list-view-count"
  }, "Showing ".concat(entities.length, " ").concat(entities.length > 1 ? entityPlural : entitySingular)), /*#__PURE__*/React$1.createElement("div", {
    className: "header-row"
  }, (config === null || config === void 0 ? void 0 : config.multiselect) && /*#__PURE__*/React$1.createElement("div", {
    className: "header-column checkbox"
  }, /*#__PURE__*/React$1.createElement(RoundCheckbox, {
    checked: allChecked,
    onChange: handleAllCheck
  })), config === null || config === void 0 ? void 0 : config.columns.map(function (col) {
    return buildHeader(col);
  })), _$1.orderBy(entityInstances, currentSort.valueAccessor, currentSort.order).map(function (instance) {
    var handleChange = function handleChange() {
      return handleCheck(instance);
    };
    return /*#__PURE__*/React$1.createElement("div", {
      key: instance._id,
      className: "content-row"
    }, (config === null || config === void 0 ? void 0 : config.multiselect) && /*#__PURE__*/React$1.createElement("div", {
      className: "content-column checkbox"
    }, /*#__PURE__*/React$1.createElement(RoundCheckbox, {
      checked: instance.checked,
      onChange: handleChange
    })), config === null || config === void 0 ? void 0 : config.columns.map(buildCell(instance)));
  }));
};

export { getEntityDataComponent as $, AdvancedSearch as A, BaseTextInput as B, ControlProvider as C, getAppliedGroups as D, EntityListView as E, FancyTreeControl as F, GroupControl$1 as G, setEntities as H, Image as I, setFetching as J, resetEntities as K, setSelectedEntities as L, setCurrentEntityType as M, setSelecting as N, OrDivider as O, PinkCheckbox as P, applyFiltering as Q, RoundCheckbox as R, ScriptedChart as S, TextSearch as T, applyGrouping as U, resetFiltering as V, changeEntity as W, fetchEntities as X, clearForNewEntityType as Y, loadSnapshot as Z, resetForFilteringAndGrouping as _, useWithLinkedSelectChange as a, useSortEntities as a0, usePaginateEntities as a1, EntityActionsPanel$1 as a2, EntitySelectionPanel as a3, TreeSelectMode as a4, ASCENDING_ORDER as a5, DESCENDING_ORDER as a6, ENTITY_LIST_SORT_PREFERENCE as a7, reducer as a8, reducer$3 as a9, getEntityActionComponent as aA, actualPage as aB, addUserConfig as aC, EmptyConfig as aD, reducer$1 as aa, reducer$4 as ab, reducer$2 as ac, modal as ad, getIsolatedEntities as ae, isViewerSyncOn as af, selectEntitiesFromModels as ag, clearEntities as ah, getAppliedFilters as ai, isSelectingEntities as aj, setIsolatedEntities as ak, setViewerSyncOn as al, getAllCurrentSearchedEntities as am, getSelectedSearchedEntities as an, getSearchingCurrent as ao, getCurrentSearchEntityType as ap, getAppliedSearchFilters as aq, resetSearchedEntities as ar, clearSearchedEntities as as, applySearchFiltering as at, setSelectedSearchedEntities as au, searchEntities as av, setUserConfig as aw, getEntitySelectConfig as ax, addEntityComponents as ay, actions as az, SquareInSquareCheckbox as b, TickCheckbox as c, CreatableScriptedSelects as d, EnhancedFetchControl as e, ScriptedLinkedSelects as f, ScriptedSelects as g, FetchButton as h, FetchingLegend as i, Overlay as j, ReactiveTreeControl as k, loadPlainInitialValueWithScriptedSelectFormat as l, SimpleSelect as m, SimpleTable as n, SimpleTabbedTable as o, TreeSearch as p, ControlTextOverlay as q, CollapsibleTextInput as r, selectStyles as s, getAllCurrentEntities as t, useChecked as u, getSelectedEntities as v, getFetchingCurrent as w, getFilteredEntities as x, getSnapshot as y, getCurrentEntityType as z };
