import { e as _inherits, f as _createClass, h as _classCallCheck, i as _callSuper, g as _objectSpread2, n as _defineProperty, d as _slicedToArray, _ as _asyncToGenerator, a as _regenerator, k as _objectWithoutProperties, l as _extends, j as _toConsumableArray, s as styleInject } from './style-inject.es-ebcb980f.js';
import React, { useState, useRef, useEffect, useMemo, useCallback } from 'react';
import _ from 'lodash';
import { f as ScriptCache, S as ScriptHelper, F as FileHelpers, I as makePromiseIgnorable, i as isValidUrl } from './TreeRendererHelper-7d89f2f1.js';
import { t as getAllCurrentEntities, v as getSelectedEntities, w as getFetchingCurrent, x as getFilteredEntities, y as getSnapshot, z as getCurrentEntityType, D as getAppliedGroups, H as setEntities, J as setFetching, K as resetEntities, L as setSelectedEntities, M as setCurrentEntityType, N as setSelecting, Q as applyFiltering, U as applyGrouping, V as resetFiltering, W as changeEntity, X as fetchEntities, Y as clearForNewEntityType, Z as loadSnapshot, _ as resetForFilteringAndGrouping, $ as getEntityDataComponent, R as RoundCheckbox, u as useChecked, a0 as useSortEntities, a1 as usePaginateEntities, a2 as EntityActionsPanel } from './EntityListView-43ddf04c.js';
import clsx from 'clsx';
import produce from 'immer';
import PropTypes__default from 'prop-types';
import { compose } from 'redux';
import { connect } from 'react-redux';
import { TableCell, TableSortLabel, Box, TableHead, TableRow, Toolbar, Typography, TableContainer, Table, TableBody, TablePagination } from '@mui/material';
import { S as SimpleTextThrobber } from './SimpleTextThrobber-687e4daa.js';
import { w as withAppContext } from './appContext-07909014.js';
import { G as GenericPageContext } from './genericPageContext-de32d520.js';
import { Controlled } from 'react-codemirror2';
import 'codemirror/lib/codemirror.css';
import 'codemirror/addon/fold/foldgutter.css';
import 'codemirror/mode/javascript/javascript.js';
import 'codemirror/addon/edit/matchbrackets.js';
import 'codemirror/addon/edit/closebrackets.js';
import 'codemirror/addon/fold/foldcode.js';
import 'codemirror/addon/fold/foldgutter.js';
import 'codemirror/addon/fold/brace-fold.js';
import 'codemirror/addon/fold/comment-fold.js';
import 'codemirror/addon/comment/comment.js';

var withEntityConfig = function withEntityConfig(WrappedComponent) {
  var EntityConfigHOC = /*#__PURE__*/function (_React$Component) {
    function EntityConfigHOC(props) {
      var _this;
      _classCallCheck(this, EntityConfigHOC);
      _this = _callSuper(this, EntityConfigHOC, [props]);
      //Checks if this handler/page supports multiple entity types (like assets and spaces)
      _this._allowsMultipleEntityTypes = _.memoize(function (currentConfig) {
        return Array.isArray(currentConfig.type);
      });
      _this._getAllowedEntityTypes = _.memoize(function (currentConfig) {
        var _currentConfig$type;
        var allowsMultipleEntityTypes = _this._allowsMultipleEntityTypes(currentConfig);
        if (allowsMultipleEntityTypes) {
          return currentConfig.type.map(function (entityType) {
            return entityType.singular;
          });
        }

        //In some instances, the entityType is an object in a type property
        if ((_currentConfig$type = currentConfig.type) !== null && _currentConfig$type !== void 0 && _currentConfig$type.singular) {
          var _currentConfig$type2;
          return [(_currentConfig$type2 = currentConfig.type) === null || _currentConfig$type2 === void 0 ? void 0 : _currentConfig$type2.singular];
        }

        //Otherwise we assume the entityType is in directly in the config as the singular property.
        return [currentConfig.singular];
      });
      //keeping this method name to avoid too much refactoring :)
      _this.getPerEntityConfig = _.memoize(function (currentConfig) {
        return function () {
          return _this._getPerEntityConfig(currentConfig);
        };
      });
      _this._getPerEntityConfig = _.memoize(function (currentConfig) {
        //console.log("IN ENTITY CONFIG PREP",currentConfig);
        if (_this._allowsMultipleEntityTypes(currentConfig)) {
          var _currentConfig$entity = currentConfig.entityData,
            entityData = _currentConfig$entity === void 0 ? {} : _currentConfig$entity,
            _currentConfig$entity2 = currentConfig.entitySelectionPanel,
            entitySelectionPanel = _currentConfig$entity2 === void 0 ? {} : _currentConfig$entity2,
            type = currentConfig.type,
            _currentConfig$select = currentConfig.selectBy,
            selectBy = _currentConfig$select === void 0 ? {} : _currentConfig$select,
            data = currentConfig.data,
            tableView = currentConfig.tableView,
            actions = currentConfig.actions,
            _currentConfig$panels = currentConfig.panels,
            panels = _currentConfig$panels === void 0 ? {} : _currentConfig$panels;
          var consolidatedConfig = _.mergeWith(_objectSpread2({}, entityData), _objectSpread2({}, selectBy), function (entityData, selectors, key) {
            console.log("IN ENTITY CONFIG MERGE");
            return _objectSpread2(_objectSpread2({}, currentConfig), {}, {
              script: entityData.script,
              entityFromModelScript: entityData.getEntityFromModel,
              spaceMode: entityData.spaceMode,
              selectors: selectors,
              entitySelectionPanel: entitySelectionPanel === null || entitySelectionPanel === void 0 ? void 0 : entitySelectionPanel[key],
              data: data === null || data === void 0 ? void 0 : data[key],
              tableView: tableView === null || tableView === void 0 ? void 0 : tableView[key],
              actions: actions === null || actions === void 0 ? void 0 : actions[key],
              panels: panels === null || panels === void 0 ? void 0 : panels[key]
            });
          });
          var result = _.mapValues(consolidatedConfig, function (entityConfig, entityName) {
            return _objectSpread2(_objectSpread2({}, entityConfig), currentConfig.type.find(function (t) {
              return t.singular === entityName;
            }));
          });
          //console.log("IN ENTITY CONFIG PREP result",result);
          return result;
        } else {
          var _result = produce(currentConfig, function (currentConfig) {
            var _currentConfig$entity3 = currentConfig.entityData,
              entityData = _currentConfig$entity3 === void 0 ? {} : _currentConfig$entity3,
              _currentConfig$entity4 = currentConfig.entitySelectionPanel,
              entitySelectionPanel = _currentConfig$entity4 === void 0 ? {} : _currentConfig$entity4,
              type = currentConfig.type,
              _currentConfig$select2 = currentConfig.selectBy,
              selectBy = _currentConfig$select2 === void 0 ? {} : _currentConfig$select2,
              data = currentConfig.data,
              tableView = currentConfig.tableView,
              actions = currentConfig.actions,
              _currentConfig$panels2 = currentConfig.panels,
              panels = _currentConfig$panels2 === void 0 ? {} : _currentConfig$panels2;
            return _defineProperty({}, type.singular, _objectSpread2(_objectSpread2({}, currentConfig), {}, {
              script: entityData[type.singular].script,
              entityFromModelScript: entityData[type.singular].getEntityFromModel,
              spaceMode: entityData[type.singular].spaceMode,
              selectors: (selectBy === null || selectBy === void 0 ? void 0 : selectBy[type.singular]) || [],
              entitySelectionPanel: entitySelectionPanel === null || entitySelectionPanel === void 0 ? void 0 : entitySelectionPanel[type.singular],
              data: data,
              actions: actions,
              tableView: tableView,
              panels: panels,
              singular: type.singular,
              plural: type.plural
            }));
          });
          //console.log("IN ENTITY CONFIG PREP result2",result);
          return _result;
        }
      });
      _this.getEntityExtendedDataFetcher = function (extendedDataConfig) {
        if (!extendedDataConfig) {
          //console.error("Unconfigured extended data");
          return function () {
            return undefined;
          };
        }
        return /*#__PURE__*/function () {
          var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(dataType, entityInfo) {
            var scriptName, scriptExpiration, result;
            return _regenerator().w(function (_context) {
              while (1) switch (_context.n) {
                case 0:
                  scriptName = extendedDataConfig[dataType].script;
                  scriptExpiration = extendedDataConfig[dataType].scriptExpiration;
                  _context.n = 1;
                  return ScriptCache.runScript(scriptName, {
                    entityInfo: entityInfo
                  }, {
                    scriptExpiration: scriptExpiration
                  });
                case 1:
                  result = _context.v;
                  return _context.a(2, result);
              }
            }, _callee);
          }));
          return function (_x, _x2) {
            return _ref2.apply(this, arguments);
          };
        }();
      };
      //kept for the compatibility
      _this.getExtendedDataConfig = _.memoize(function (currentConfig) {
        return function () {
          return _this._getExtendedDataConfig(currentConfig);
        };
      });
      _this._getExtendedDataConfig = _.memoize(function (currentConfig) {
        var extendedData = {};
        //check for extended data on entities
        if (currentConfig.data) {
          var dataTypes = Object.keys(currentConfig.data);
          if (!!dataTypes.length) {
            //gets an object of all the extended datatypes
            var consolidatedExtendedData = _.values(currentConfig.data).reduce(function (acc, current) {
              return _objectSpread2(_objectSpread2({}, acc), current);
            });
            extendedData = currentConfig.type ? consolidatedExtendedData : currentConfig.data;
          }
        }
        return extendedData;
      });
      _this.initAvailableDataGroups = function (currentConfig) {
        var availableDataGroups = {};
        Object.entries(_this._getPerEntityConfig(currentConfig)).forEach(function (_ref3) {
          var _ref4 = _slicedToArray(_ref3, 2),
            entityType = _ref4[0],
            config = _ref4[1];
          if (config.data) {
            Object.entries(config.data).forEach(function (_ref5) {
              var _ref6 = _slicedToArray(_ref5, 2),
                dataGroupName = _ref6[0],
                dataGroup = _ref6[1];
              if (dataGroup.isProperties) {
                availableDataGroups[entityType] = availableDataGroups[entityType] || {};
                availableDataGroups[entityType][dataGroupName] = true;
              }
            });
          }
        });
        return availableDataGroups;
      };
      _this.findAvailableDataGroups = function (currentConfig) {
        return function (entity, propertiesOnly, entitySingular, onDataGroup, onFinishLoading) {
          if (!propertiesOnly) {
            // Second pass through run the scripts for each extended data and see if they have data

            var scriptPromises = [];
            Object.entries(currentConfig).forEach(function (_ref7) {
              var _ref8 = _slicedToArray(_ref7, 2),
                entityType = _ref8[0],
                config = _ref8[1];
              if (entitySingular && entitySingular != entityType) {
                return;
              }
              Object.entries(config.data).forEach(function (_ref9) {
                var _ref0 = _slicedToArray(_ref9, 2),
                  dataGroupName = _ref0[0],
                  dataGroup = _ref0[1];
                if (dataGroup.script && entity) {
                  scriptPromises.push(_this.getDataGroupFetcher(entityType, entity, dataGroup, dataGroupName, onDataGroup));
                }
              });
            });
            Promise.all(scriptPromises)["finally"](function () {
              onFinishLoading && onFinishLoading();
            });
          } else {
            onFinishLoading && onFinishLoading();
          }
        };
      };
      _this.getDataGroupFetcher = function (entityType, entity, dataGroup, dataGroupName, onDataGroupLoaded) {
        return ScriptCache.runScript(dataGroup.script, {
          entityInfo: entity
        }, {
          scriptExpiration: dataGroup.scriptExpiration
        }).then(function (extendedData) {
          var isAvailable;
          if (!extendedData) isAvailable = false;else if (Array.isArray(extendedData) && extendedData.length > 0) isAvailable = true;else if (Object.keys(extendedData).length > 0) isAvailable = true;else isAvailable = false;
          onDataGroupLoaded(entityType, dataGroupName, isAvailable);
        })["catch"](function (error) {
          onDataGroupLoaded(entityType, dataGroupName, false);
        });
      };
      _this.getWrappedComponent = function (handler) {
        var config = handler.config;
        var wrappedProps = _objectSpread2(_objectSpread2(_objectSpread2({}, _this.props), _this.state), {}, {
          initialAvailableDataGroups: _this.initAvailableDataGroups(config),
          perEntityConfig: _this._getPerEntityConfig(config),
          //TODO: why extendedDataConfig merges keys from all entities? surely this one day will overwrite something right?
          extendedDataConfig: _this._getExtendedDataConfig(config),
          allowsMultipleEntityTypes: _this._getAllowedEntityTypes(config),
          allowedEntityTypes: _this._getAllowedEntityTypes(config),
          findAvailableDataGroups: _this.findAvailableDataGroups(_this._getPerEntityConfig(config)),
          getEntityExtendedDataFetcher: _this.getEntityExtendedDataFetcher,
          //the below prop is kept to be compliant with old code, please use "perEntityConfig" instead
          getPerEntityConfig: _this.getPerEntityConfig(config)
        });
        return /*#__PURE__*/React.createElement(WrappedComponent, wrappedProps);
      };
      return _this;
    }
    _inherits(EntityConfigHOC, _React$Component);
    return _createClass(EntityConfigHOC, [{
      key: "render",
      value: function render() {
        var _this2 = this;
        return /*#__PURE__*/React.createElement(GenericPageContext.Consumer, null, function (genericPageContext) {
          return _this2.getWrappedComponent(genericPageContext.handler);
        });
      }
    }]);
  }(React.Component);
  return withAppContext(EntityConfigHOC);
};

var _excluded = ["singular", "plural"],
  _excluded2 = ["singular", "plural"];
var storeCacheMap = {};
var lastEntityTypeCacheMap = {};
var withEntityStore = function withEntityStore(WrappedComponent) {
  var EntityStoreHOC = /*#__PURE__*/function (_React$Component) {
    function EntityStoreHOC(props) {
      var _props$handler;
      var _this;
      _classCallCheck(this, EntityStoreHOC);
      _this = _callSuper(this, EntityStoreHOC, [props]);
      _this.initStoreValues = function (initialEntityType) {
        // it updates the store couple of times separately, no need for a new reducer here yet
        // as it's run from the constructor and child components are not connected yet
        var queryParams = _this.props.queryParams;
        if (initialEntityType) {
          var isCurrentEntityType = queryParams && queryParams.entityType === initialEntityType.singular;
          if (isCurrentEntityType && queryParams.filters) {
            _this.props.applyFiltering(queryParams.filters);
          }
          if (isCurrentEntityType && queryParams.groups) {
            _this.props.applyGrouping(queryParams.groups);
          }
          _this.props.setCurrentEntityType(initialEntityType);
        }
      };
      _this.deriveInitialEntityType = function (queryParams) {
        var _cacheForHandler$last, _this$props$currentEn;
        if (queryParams) {
          var currentEntityConfig = _this.props.perEntityConfig[queryParams.entityType];
          // if we have a query and it's for an available entity type at this page and the query was originated at
          // a page dealing with the same entity type it is meant to retrieve, then we can run the passed in query,
          // fetching the entities using the selectors
          if (queryParams.query && _.includes(_this.props.allowedEntityTypes, queryParams.entityType) && (!queryParams.senderEntityType || queryParams.entityType === queryParams.senderEntityType)) {
            // note: id might be an index into the array or a textual id from the user config....
            return _this.props.perEntityConfig[queryParams.entityType];
          }
          // else if we have selected entities for an available entity type at this page but they come from a page
          // dealing with another type of entities, that means we can't use the query from the source page so we
          // run a query to select those ids directly and keep the original sender ...
        }
        //if we don't have query, or it should not influence entity type:
        //a. if we have last used entity in this handler - and it's allowed - we will use it
        var lastEntity = lastEntityTypeCacheMap[_this.handerPath];
        var cacheForHandler = storeCacheMap[_this.handerPath] || {};
        var lastEntityType = (_cacheForHandler$last = cacheForHandler[lastEntity]) === null || _cacheForHandler$last === void 0 ? void 0 : _cacheForHandler$last.currentEntityType;
        if (lastEntityType && _.includes(_this.props.allowedEntityTypes, lastEntityType.singular)) {
          return lastEntityType;
        }
        //b. if we have entity in store for this handler - and it's allowed - we will use it
        if (_this.props.currentEntityType && _.includes(_this.props.allowedEntityTypes, (_this$props$currentEn = _this.props.currentEntityType) === null || _this$props$currentEn === void 0 ? void 0 : _this$props$currentEn.singular)) {
          return _this.props.currentEntityType;
        }
        // else we assume we are going to use first entity from the handler config
        return _.values(_this.props.perEntityConfig)[0];
      };
      _this.updateEntityType = function (args) {
        var singular = args.singular,
          plural = args.plural,
          rest = _objectWithoutProperties(args, _excluded);
        var currentEntity = _this.props.currentEntityType;
        if (currentEntity.singular !== singular || currentEntity.plural !== plural) {
          var newEntityConfig = _.includes(_this.props.allowedEntityTypes, singular) ? _.values(_this.props.perEntityConfig)[singular] : {};
          var newEntityType = _objectSpread2(_objectSpread2({}, args), newEntityConfig);
          _this.saveStore();
          _this.switchStore(newEntityType);
        }
      };
      _this.switchStore = function (_ref) {
        var _storeCacheMap$_this$;
        var singular = _ref.singular,
          plural = _ref.plural,
          rest = _objectWithoutProperties(_ref, _excluded2);
        //if we change entities check if we have previously saved store
        if (storeCacheMap !== null && storeCacheMap !== void 0 && (_storeCacheMap$_this$ = storeCacheMap[_this.handerPath]) !== null && _storeCacheMap$_this$ !== void 0 && _storeCacheMap$_this$[singular]) {
          _this.props.loadSnapshot(storeCacheMap[_this.handerPath][singular]);
        } else {
          //if we haven't previously saved store for new entity, use current store, make sure we clear current store
          _this.props.clearForNewEntityType(_objectSpread2({
            singular: singular,
            plural: plural
          }, rest));
        }
        //update last used entity
        lastEntityTypeCacheMap[_this.handerPath] = singular;
      };
      _this.saveStore = function () {
        if (!_this.props.currentEntityType) {
          console.error("tried to save store for wrong entity type: ".concat(_this.props.currentEntityType));
          return;
        }
        //const storeCacheMap = {...storeCacheMap, [this.props.currentEntityType.singular] : this.props.storeSnapshot};
        //this.setState({storeCacheMap : storeCacheMap});
        var cacheForHandler = storeCacheMap[_this.handerPath] || {};
        cacheForHandler[_this.props.currentEntityType.singular] = _this.props.storeSnapshot;
        storeCacheMap[_this.handerPath] = cacheForHandler;
        //update last used entity
        lastEntityTypeCacheMap[_this.handerPath] = _this.props.currentEntityType.singular;
      };
      _this.getWrappedComponent = function (wrappedProps) {
        return /*#__PURE__*/React.createElement(WrappedComponent, _extends({
          updateEntityType: _this.updateEntityType,
          entitySingular: _this.props.currentEntityType.singular,
          entityPlural: _this.props.currentEntityType.plural
        }, wrappedProps));
      };
      _this.handerPath = (props === null || props === void 0 || (_props$handler = props.handler) === null || _props$handler === void 0 ? void 0 : _props$handler.path) || '_default_';
      return _this;
    }
    _inherits(EntityStoreHOC, _React$Component);
    return _createClass(EntityStoreHOC, [{
      key: "UNSAFE_componentWillMount",
      value: function UNSAFE_componentWillMount() {
        this.alignEntityStoreToHandlerEntity();
      }
    }, {
      key: "componentWillMount",
      value: function componentWillMount() {
        this.alignEntityStoreToHandlerEntity();
      }
    }, {
      key: "alignEntityStoreToHandlerEntity",
      value: function alignEntityStoreToHandlerEntity() {
        var initialEntityType = this.deriveInitialEntityType(this.props.queryParams);
        if (this.props.currentEntityType) {
          //store is already populated, check if we need to change entity
          var queryParams = this.props.queryParams;
          var storeSwitchRequired = queryParams && queryParams.entityType !== this.props.currentEntityType.singular || initialEntityType.entityType !== this.props.currentEntityType.singular;
          if (storeSwitchRequired) {
            //change store (yes for all components using this HOC)
            this.switchStore(initialEntityType);
          }
          return;
        }
        // hello, we have connected to an empty redux store
        // entity type must be set on state to make up for the empty store
        //re-render the component with entity type
        this.initStoreValues(initialEntityType);
      }
    }, {
      key: "componentWillUnmount",
      value: function componentWillUnmount() {
        this.saveStore();
        //TODO Once filters are moved to store, refactor the queryParam logic so that it can identify when URL applied
        // filters and entity match the current ones in the store and this cleaning (and the later refetching) of the entities
        // can be removed for being unnecessary and only done when needed
        //this.props.resetEntities();
      }
    }, {
      key: "render",
      value: function render() {
        var _this$props;
        var wrappedProps = _objectSpread2({}, this.props);
        var derivedEntityType = this.deriveInitialEntityType(this.props.queryParams);
        var storeHasCorrectEntity = (this === null || this === void 0 || (_this$props = this.props) === null || _this$props === void 0 || (_this$props = _this$props.currentEntityType) === null || _this$props === void 0 ? void 0 : _this$props.singular) == (derivedEntityType === null || derivedEntityType === void 0 ? void 0 : derivedEntityType.singular);
        //const storeHasAllowedEntity = _.includes(this.props.allowedEntityTypes, this?.props?.currentEntityType?.singular)
        return storeHasCorrectEntity ? this.getWrappedComponent(wrappedProps) : null;
      }
    }]);
  }(React.Component);
  var mapStateToProps = function mapStateToProps(state) {
    return {
      entities: getAllCurrentEntities(state),
      selectedEntities: getSelectedEntities(state),
      fetching: getFetchingCurrent(state),
      filteredEntities: getFilteredEntities(state),
      storeSnapshot: getSnapshot(state),
      currentEntityType: getCurrentEntityType(state),
      //groups where previously here in the state, carrying the name over
      groups: getAppliedGroups(state)
    };
  };
  var mapDispatchToProps = {
    setEntities: setEntities,
    setFetching: setFetching,
    resetEntities: resetEntities,
    setSelectedEntities: setSelectedEntities,
    setCurrentEntityType: setCurrentEntityType,
    setSelecting: setSelecting,
    applyFiltering: applyFiltering,
    applyGrouping: applyGrouping,
    resetFiltering: resetFiltering,
    changeEntity: changeEntity,
    fetchEntities: fetchEntities,
    clearForNewEntityType: clearForNewEntityType,
    loadSnapshot: loadSnapshot,
    resetForFilteringAndGrouping: resetForFilteringAndGrouping
  };
  return connect(mapStateToProps, mapDispatchToProps)(withEntityConfig(EntityStoreHOC));
};

//TODO Most of this logic (probably all) should be gradually moved to thunks and the reducer in the entities store
var withEntitySearch = function withEntitySearch(WrappedComponent) {
  var EntitySearchHOC = /*#__PURE__*/function (_React$Component) {
    function EntitySearchHOC(_props) {
      var _this;
      _classCallCheck(this, EntitySearchHOC);
      _this = _callSuper(this, EntitySearchHOC, [_props]);
      //don't use GenericPage setQueryParams directly, it will mix partial queries from different entities
      _this.setQueryParams = function (queryParamsPartial, callback) {
        var entityType = queryParamsPartial.entityType || _this.props.entitySingular;
        var current = _this.state.queryParamsPerEntityType[entityType] || {};
        var merged = _objectSpread2(_objectSpread2({}, current), queryParamsPartial);
        var queryParamsPerEntityType = _objectSpread2(_objectSpread2({}, _this.state.queryParamsPerEntityType), {}, _defineProperty({}, entityType, merged));
        _this.setState({
          queryParamsPerEntityType: queryParamsPerEntityType
        }, callback || _.noop);
        //no need to send that up to state, as selectionInfo.queryParams will have all the info
        //this.props.setQueryParams(queryParamsPartial);
      };
      _this.onLoadComplete = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              if (_this.props.onLoadComplete) _this.props.onLoadComplete();
              //redux store should already be set with appropriate entity types
              _context.n = 1;
              return _this.initialFetchFromQuery();
            case 1:
              return _context.a(2);
          }
        }, _callee);
      }));
      _this.initQueryParamsValues = function (props, initialEntitySingular) {
        var queries = {};
        _this.props.allowedEntityTypes.forEach(function (et) {
          queries[et] = {};
        });
        var queryParams = props.queryParams;
        if (queryParams && (queryParams.entityType || initialEntitySingular)) {
          queries[queryParams.entityType || initialEntitySingular] = queryParams;
        }
        return queries;
      };
      _this.initialFetchFromQuery = /*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2() {
        var queryParams, queryEntityConfig, selector, fetcher, _fetcher;
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              queryParams = _this.props.queryParams;
              if (queryParams !== undefined) {
                queryEntityConfig = _this.props.perEntityConfig[queryParams.entityType]; // if we have a query and it's for an available entity type at this page and the query was originated at
                // a page dealing with the same entity type it is meant to retrieve, then we can run the passed in query,
                // fetching the entities using the selectors
                if (queryParams.query && _.includes(_this.props.allowedEntityTypes, queryParams.entityType) && (!queryParams.senderEntityType || queryParams.entityType === queryParams.senderEntityType)
                //this check is important not to mess with store
                && queryParams.entityType === _this.props.entitySingular) {
                  // note: id might be an index into the array or a textual id from the user config....
                  selector = queryEntityConfig.selectors[queryParams.query.id];
                  if (!selector) selector = queryEntityConfig.selectors.find(function (s) {
                    return s.id === queryParams.query.id;
                  });
                  //if the queryParams have a query, but no id and value, assume thats its a list of ids to fetch
                  //this may not always be true?
                  if (!selector && queryParams.query && !queryParams.id && queryParams.query.value && Array.isArray(queryParams.query.value)) {
                    selector = {
                      query: "<<ID_SEARCH>>"
                    };
                  }
                  if (selector) {
                    fetcher = _this.getFetcher(queryEntityConfig.script);
                    fetcher(selector, queryParams.query.value, true, _this.onInitialFetchComplete);
                  } else {
                    console.warn("Unable to find selectBy with id of", queryParams.query.id);
                  }
                }
                // else if we have selected entities for an available entity type at this page but they come from a page
                // dealing with another type of entities, that means we can't use the query from the source page so we
                // run a query to select those ids directly and keep the original sender ...
                else if (_.includes(_this.props.allowedEntityTypes, queryParams.entityType) && (!queryParams.senderEntityType || queryParams.entityType !== queryParams.senderEntityType) && queryParams.selectedEntities
                //this check is important not to mess with store
                && queryParams.entityType === _this.props.entitySingular) {
                  _fetcher = _this.getFetcher(queryEntityConfig.script, queryParams.senderEntityType);
                  _fetcher({
                    query: "<<ID_SEARCH>>"
                  }, queryParams.selectedEntities, true);
                }
                // otherwise warn the developer if something strange happened... (possibly a user configuraiton issue?)
                //TODO add a config validator on load
                else if (queryParams.entityType && !_.includes(_this.props.allowedEntityTypes, queryParams.entityType)) {
                  console.warn("Incompatible entity type provided in query params got:", queryParams.entityType, "but expected one of ", _this.props.allowedEntityTypes);
                } else {
                  !_.isEmpty(queryParams) && console.warn("Ignoring query:", queryParams, "for entity: ", _this.props.entitySingular);
                }
              }
            case 1:
              return _context2.a(2);
          }
        }, _callee2);
      }));
      _this.onInitialFetchComplete = function () {
        //we assume that last query run is the one this callback is for, so we get groups and filters from here
        var queryParams = _this.state.queryParamsPerEntityType[_this.props.entitySingular];
        //If there were filters, be sure to apply them after entity selection
        if (queryParams.filters) {
          _this.props.applyFiltering(queryParams.filters);
        }
        if (queryParams.groups) {
          _this.props.applyGrouping(queryParams.groups);
        }
        // set selectedEntities from a list of queryParam entity ids
        if (queryParams.selectedEntities) {
          _this.props.setSelecting(queryParams.selectedEntities.length === 1);
          var selectedEntities = [];
          queryParams.selectedEntities.forEach(function (id) {
            return selectedEntities.push(_this.props.entities.find(function (e) {
              return e._id == id;
            }));
          });
          if (selectedEntities.length > 0) _this.props.setSelectedEntities(selectedEntities);
          _this.props.setSelecting(false);
        }
      };
      _this.onEntityChange = function (changeType, entity, result) {
        if (Array.isArray(entity)) {
          entity.forEach(function (ent) {
            _this.props.changeEntity(changeType, ent, result);
          });
        } else {
          _this.props.changeEntity(changeType, entity, result);
        }
      };
      _this.doEntityAction = /*#__PURE__*/function () {
        var _ref3 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3(action, entityInfo, type) {
          var entityConfig, actions, selectionInfo, navConfig, selectedEntities, result, selectedIds, entityType, emptyQueryParams, scriptName, _result;
          return _regenerator().w(function (_context3) {
            while (1) switch (_context3.n) {
              case 0:
                //current active entity
                entityConfig = _this.props.perEntityConfig[_this.props.entitySingular];
                actions = entityConfig.actions;
                if (Object.keys(actions).includes(action)) {
                  _context3.n = 1;
                  break;
                }
                console.error("Unconfigured action: '" + action + "' : No action taken!");
                return _context3.a(2, undefined);
              case 1:
                if (!(actions[action].type === 'navigate')) {
                  _context3.n = 5;
                  break;
                }
                selectionInfo = {};
                navConfig = actions[action];
                if (!navConfig.script) {
                  _context3.n = 3;
                  break;
                }
                // if there's a pre-processing script then execute it

                // first try checked table items (entityInfo.original contains the checked table items)
                if (_.isArray(entityInfo.original) && entityInfo.original.length > 0) selectedEntities = entityInfo.original;
                // then try selected tree items
                else if (_this.props.selectedEntities && _this.props.selectedEntities.length > 0) selectedEntities = _this.props.selectedEntities;
                // if nothing selected then pass the filtered entities in the tree (which could be all if no filters)
                else selectedEntities = _this.props.filteredEntities;
                _context3.n = 2;
                return ScriptHelper.executeScript(navConfig.script, {
                  entityInfo: {
                    selectedEntities: selectedEntities
                  }
                });
              case 2:
                result = _context3.v;
                selectedIds = [];
                if (_.isArray(result.selectedEntities)) selectedIds = result.selectedEntities.map(function (e) {
                  return e._id;
                });else if (_.isObject(result.selectedEntities)) selectedIds = [result.selectedEntities._id];
                entityType = navConfig.scriptResultType ? navConfig.scriptResultType : _this.props.entitySingular;
                emptyQueryParams = {
                  query: null,
                  groups: null,
                  filters: null,
                  senderEntityType: _this.props.entitySingular,
                  entityType: type || _this.props.entitySingular
                };
                /* domi: commenting this out - not needed - we can do that below without triggering async state update
                this.setQueryParams(emptyQueryParams);
                */
                //overwrite GenericPage current queryParams by sending empty ones
                selectionInfo = {
                  entityType: entityType,
                  selectedEntities: selectedIds,
                  queryParams: emptyQueryParams
                };
                _context3.n = 4;
                break;
              case 3:
                /* domi: commenting this out -
                1. we can do that below without triggering async state update
                2. also this might be wrong now as type can be now an array
                this.setQueryParams({
                   entityType: this.getCurrentConfig().type.singular,
                   senderEntityType: this.getCurrentConfig().type.singular
                })
                */
                selectionInfo['senderEntityType'] = _this.props.entitySingular;
                selectionInfo['queryParams'] = _objectSpread2(_objectSpread2({}, _this.state.queryParamsPerEntityType[_this.props.entitySingular]), {}, {
                  selector: undefined
                });
                selectionInfo['entityType'] = (typeof type === 'string' ? type : type === null || type === void 0 ? void 0 : type.singular) || _this.props.entitySingular;
                selectionInfo['script'] = entityConfig.script;
                // entityInfo.original contains the checked table items...
                if (_.isArray(entityInfo.original) && entityInfo.original.length > 0) selectionInfo['selectedEntities'] = entityInfo.original.map(function (e) {
                  return e._id;
                });
                // selectedEntities are the entities selected in the tree...
                else if (_this.props.selectedEntities && _this.props.selectedEntities.length > 0) selectionInfo['selectedEntities'] = _this.props.selectedEntities.map(function (ent) {
                  return ent._id;
                });
              case 4:
                _this.props.onNavigate(navConfig.navigateTo, selectionInfo);
                return _context3.a(2, {
                  success: true
                });
              case 5:
                if (!(actions[action].type === 'fileDownload')) {
                  _context3.n = 6;
                  break;
                }
                FileHelpers.downloadDocuments(Array.isArray(entityInfo.original) ? entityInfo.original : [entityInfo.original]);
                return _context3.a(2, {
                  success: true
                });
              case 6:
                scriptName = actions[action].script;
                _context3.n = 7;
                return ScriptHelper.executeScript(scriptName, {
                  entityInfo: entityInfo
                });
              case 7:
                _result = _context3.v;
                return _context3.a(2, _result);
              case 8:
                return _context3.a(2);
            }
          }, _callee3);
        }));
        return function (_x, _x2, _x3) {
          return _ref3.apply(this, arguments);
        };
      }();
      //TODO turn this into a reasonable thunk and move to redux layer
      _this.getFetcher = function (script, originalSender, runScriptOptions) {
        return /*#__PURE__*/function () {
          var _ref4 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4(selector, value, initialPageLoad, onInitialFetchComplete) {
            var reason, fetchedQuery;
            return _regenerator().w(function (_context4) {
              while (1) switch (_context4.n) {
                case 0:
                  if (!(selector.query.entityType && selector.query.entityType !== _this.props.entitySingular)) {
                    _context4.n = 1;
                    break;
                  }
                  reason = "fetching ".concat(selector.query.entityType, " type not allowed, expecting ").concat(_this.props.entitySingular);
                  console.error(reason);
                  return _context4.a(2, Promise.reject());
                case 1:
                  _context4.n = 2;
                  return _this.props.fetchEntities(script, selector, value, runScriptOptions);
                case 2:
                  //in case of initial query triggered by this page, this callback will still use old query
                  if (onInitialFetchComplete) onInitialFetchComplete();
                  fetchedQuery = {
                    query: {
                      type: selector.query,
                      id: selector.id,
                      value: value
                    },
                    senderEntityType: originalSender || _this.props.entitySingular,
                    entityType: _this.props.entitySingular,
                    selector: selector
                  };
                  _this.setQueryParams(fetchedQuery);
                case 3:
                  return _context4.a(2);
              }
            }, _callee4);
          }));
          return function (_x4, _x5, _x6, _x7) {
            return _ref4.apply(this, arguments);
          };
        }();
      };
      _this.onGroupOrFilterChange = function (changes) {
        _this.setQueryParams(changes);
        _this.props.resetForFilteringAndGrouping({
          filters: changes.filters,
          groups: changes.groups
        });
      };
      var _queryParamsPerEntityType = _this.initQueryParamsValues(_props, _props.currentEntityType.singular);
      _this.state = {
        isPageLoading: true,
        //groups: _.get(this, 'props.queryParams.groups'),
        //when entity changes, we will switch between "queries", kind of
        queryParamsPerEntityType: _queryParamsPerEntityType
      };
      return _this;
    }
    _inherits(EntitySearchHOC, _React$Component);
    return _createClass(EntitySearchHOC, [{
      key: "componentDidMount",
      value: function () {
        var _componentDidMount = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee5() {
          return _regenerator().w(function (_context5) {
            while (1) switch (_context5.n) {
              case 0:
                //run on load complete every time isPageLoading updates
                this.setState({
                  isPageLoading: false
                }, this.onLoadComplete);
              case 1:
                return _context5.a(2);
            }
          }, _callee5, this);
        }));
        function componentDidMount() {
          return _componentDidMount.apply(this, arguments);
        }
        return componentDidMount;
      }()
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps, prevState, snapshot) {}
    }, {
      key: "render",
      value: function render() {
        var wrappedProps = _objectSpread2(_objectSpread2(_objectSpread2({}, this.props), this.state), {}, {
          extendedData: this.props.extendedDataConfig,
          queryParams: this.state.queryParamsPerEntityType[this.props.entitySingular],
          setQueryParams: this.setQueryParams
        });
        return /*#__PURE__*/React.createElement(WrappedComponent, _extends({
          onEntityChange: this.onEntityChange,
          doEntityAction: this.doEntityAction,
          getEntityExtendedData: this.props.getEntityExtendedDataFetcher,
          entitiesSelected: this.props.setSelectedEntities,
          getFetcher: this.getFetcher,
          updateEntityType: this.updateEntityType,
          onGroupOrFilterChange: this.onGroupOrFilterChange
        }, wrappedProps));
      }
    }]);
  }(React.Component);
  return withEntityStore(EntitySearchHOC);
};

//TODO Most of this logic (probably all) should be gradually moved to thunks and the reducer in the entities store
var withEntityAvailableGroups = function withEntityAvailableGroups(WrappedComponent) {
  var EntityGroupsHOC = /*#__PURE__*/function (_React$Component) {
    function EntityGroupsHOC(props) {
      var _this;
      _classCallCheck(this, EntityGroupsHOC);
      _this = _callSuper(this, EntityGroupsHOC, [props]);
      _this.onDataGroupAvailable = function (entityType, dataGroupName, val) {
        var availableDataGroups = Object.assign({}, _this.state.availableDataGroups);
        availableDataGroups[entityType] = availableDataGroups[entityType] || {};
        availableDataGroups[entityType][dataGroupName] = val;
        _this.setState({
          availableDataGroups: availableDataGroups
        });
      };
      _this.onDataGroupsLoaded = function () {
        _this.setState({
          loadingAvailableDataGroups: false
        });
      };
      _this.setAvailableDataGroups = function (entity, propertiesOnly) {
        //reset all available groups
        _this.setState({
          availableDataGroups: _.cloneDeep(_this.props.initialAvailableDataGroups),
          loadingAvailableDataGroups: true
        });
        if (entity) {
          _this.props.findAvailableDataGroups(entity, propertiesOnly, entity ? _this.props.currentEntityType.singular : undefined, _this.onDataGroupAvailable, _this.onDataGroupsLoaded);
        }
      };
      _this.state = {
        availableDataGroups: _.cloneDeep(_this.props.initialAvailableDataGroups)
      };
      return _this;
    }
    _inherits(EntityGroupsHOC, _React$Component);
    return _createClass(EntityGroupsHOC, [{
      key: "componentDidMount",
      value: function () {
        var _componentDidMount = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
          return _regenerator().w(function (_context) {
            while (1) switch (_context.n) {
              case 0:
                this.selectedEntitiesEffect();
              case 1:
                return _context.a(2);
            }
          }, _callee, this);
        }));
        function componentDidMount() {
          return _componentDidMount.apply(this, arguments);
        }
        return componentDidMount;
      }()
    }, {
      key: "componentDidUpdate",
      value: function componentDidUpdate(prevProps, prevState, snapshot) {
        if (prevProps.selectedEntities !== this.props.selectedEntities) {
          this.selectedEntitiesEffect();
        }
      }
    }, {
      key: "selectedEntitiesEffect",
      value: function selectedEntitiesEffect() {
        if (this.props.selectedEntities) {
          this.setAvailableDataGroups(this.props.selectedEntities[0], false);
        }
      }
    }, {
      key: "render",
      value: function render() {
        var wrappedProps = _objectSpread2(_objectSpread2({}, this.props), this.state);
        return /*#__PURE__*/React.createElement(WrappedComponent, _extends({}, wrappedProps, {
          setAvailableDataGroups: this.setAvailableDataGroups
        }));
      }
    }]);
  }(React.Component);
  return EntityGroupsHOC;
};

var EntityDataGroupContainer = function EntityDataGroupContainer(props) {
  var _props$config;
  var getArrayWithoutHiddenData = function getArrayWithoutHiddenData(config) {
    var hidden = config.component.hidden || [];
    var indexesToHide = hidden.map(function (e) {
      return _.findIndex(props.data[0], function (o) {
        return o == e;
      });
    });
    return props.data.map(function (e) {
      return Array.isArray(e) ? e.filter(function (o, index) {
        return !indexesToHide.includes(index);
      }) : e;
    });
  };
  var getObjectWithoutHiddenData = function getObjectWithoutHiddenData(config) {
    return _.omit.apply(_, [props.data].concat(_toConsumableArray(config.component.hidden || [])));
  };
  var getEntityData = function getEntityData(config) {
    return config.component.hidden ? Array.isArray(props.data) ? getArrayWithoutHiddenData(config) : getObjectWithoutHiddenData(config) : props.data;
  };
  if (props.fetching) return /*#__PURE__*/React.createElement(SimpleTextThrobber, {
    throbberText: "Retrieving data"
  });else if (props.data == null || Array.isArray(props.data) && props.data.length == 0) return /*#__PURE__*/React.createElement("div", null, "No data");
  var factory = props.getEntityDataComponent((_props$config = props.config) === null || _props$config === void 0 || (_props$config = _props$config.component) === null || _props$config === void 0 ? void 0 : _props$config.name);
  if (!factory) {
    var _props$config2;
    console.error('No factory for ' + ((_props$config2 = props.config) === null || _props$config2 === void 0 || (_props$config2 = _props$config2.component) === null || _props$config2 === void 0 ? void 0 : _props$config2.name));
    return null;
  }
  var component = factory.create({
    config: props.config.component,
    data: getEntityData(props.config)
  });
  return /*#__PURE__*/React.createElement(React.Fragment, null, component);
};
var mapStateToProps = function mapStateToProps(state) {
  return {};
};
var mapDispatchToProps = {
  getEntityDataComponent: getEntityDataComponent
};
var EntityDataGroupContainer$1 = compose(connect(mapStateToProps, mapDispatchToProps))(EntityDataGroupContainer);

var EntityDataGroupContainer$2 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    'default': EntityDataGroupContainer$1
});

var useEntityData = function useEntityData(collapsable, collapsed, entity, config, getData, dataGroupName) {
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    fetching = _useState2[0],
    setFetching = _useState2[1];
  var _useState3 = useState(null),
    _useState4 = _slicedToArray(_useState3, 2),
    error = _useState4[0],
    setError = _useState4[1];
  var _useState5 = useState(null),
    _useState6 = _slicedToArray(_useState5, 2),
    data = _useState6[0],
    setData = _useState6[1];
  var _useState7 = useState(false),
    _useState8 = _slicedToArray(_useState7, 2),
    reloadToken = _useState8[0],
    setReloadToken = _useState8[1];
  var _useState9 = useState(),
    _useState0 = _slicedToArray(_useState9, 2),
    ignorable = _useState0[0],
    setIgnorable = _useState0[1];
  var myIntervals = useRef([]);
  var isDataVisible = !collapsable || !collapsed;
  var getContainerData = /*#__PURE__*/function () {
    var _ref = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(collapsable, entity, config, getData, dataGroupName) {
      var _isDataVisible, _data, _ignorable, _t;
      return _regenerator().w(function (_context) {
        while (1) switch (_context.p = _context.n) {
          case 0:
            reset();
            _context.p = 1;
            setFetching(true);
            if (entity) {
              _context.n = 2;
              break;
            }
            throw new Error("No entity data");
          case 2:
            _isDataVisible = !collapsable || !collapsed;
            _data = [];
            if (!(config !== null && config !== void 0 && config.isProperties)) {
              _context.n = 3;
              break;
            }
            _data = entity === null || entity === void 0 ? void 0 : entity.properties;
            _context.n = 5;
            break;
          case 3:
            if (!(_isDataVisible && dataGroupName)) {
              _context.n = 5;
              break;
            }
            setFetching(true);
            //makePromiseIgnorable is necessary to avoid data from a previous promise of another dataGroup to resolve and input it's data into the wrong component
            _ignorable = makePromiseIgnorable(getData(dataGroupName, entity));
            setIgnorable(_ignorable); //necessary to be able to ignore the promise if another has been thrown.
            _context.n = 4;
            return _ignorable.promise;
          case 4:
            _data = _context.v;
          case 5:
            setData(_data);
            setError(undefined);
            setFetching(false);
            _context.n = 7;
            break;
          case 6:
            _context.p = 6;
            _t = _context.v;
            if (!(_t !== null && _t !== void 0 && _t.isIgnored)) {
              console.error(_t);
              setError(_t);
              setFetching(false);
            }
          case 7:
            return _context.a(2);
        }
      }, _callee, null, [[1, 6]]);
    }));
    return function getContainerData(_x, _x2, _x3, _x4, _x5) {
      return _ref.apply(this, arguments);
    };
  }();
  var initiateFirstFetching = function initiateFirstFetching() {
    if (isDataVisible) {
      //We load the data only if it is visible
      getContainerData(collapsable, entity, config, getData, dataGroupName);
    }
  };
  var startFetchingLoop = function startFetchingLoop() {
    var interval = undefined;
    if (config !== null && config !== void 0 && config.refreshInterval && isDataVisible) {
      if (config.refreshInterval < config.scriptExpiration) {
        console.warn('Refresh Interval is less than Script Expiration which will cause cached data to be used instead fetching new data!');
      }
      interval = setInterval(function () {
        getContainerData(collapsable, entity, config, getData, dataGroupName);
      }, config.refreshInterval * 60000);
      myIntervals.current.push(interval);
    }
    return interval;
  };
  useEffect(function () {
    initiateFirstFetching();
    var loop = startFetchingLoop();
    return function () {
      if (loop) clearInterval(loop);
    };
  }, [entity, dataGroupName, reloadToken, collapsed]);
  var reload = function reload() {
    setReloadToken(!reloadToken);
  };
  var reset = function reset() {
    myIntervals.current.forEach(function (interval) {
      return clearInterval(interval);
    });
    setFetching(false);
    setData(null);
    setError(null);
    if (ignorable) {
      ignorable.ignore();
      setIgnorable(undefined);
    }
    //setReloadToken(false)
  };
  return {
    data: data,
    fetching: fetching,
    error: error,
    reset: reset,
    reload: reload
  };
};
var EntityDataContainer = function EntityDataContainer(props) {
  var _useState1 = useState(props.config.hasOwnProperty('isProperties') ? !props.config.isProperties : true),
    _useState10 = _slicedToArray(_useState1, 2),
    collapsed = _useState10[0],
    setCollapsed = _useState10[1];
  var _useEntityData = useEntityData(props.collapsable, collapsed, props.entity, props.config, props.getData, props.dataGroupName),
    data = _useEntityData.data,
    fetching = _useEntityData.fetching,
    reset = _useEntityData.reset,
    reload = _useEntityData.reload;
  var toggleCollapsed = /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2() {
      return _regenerator().w(function (_context2) {
        while (1) switch (_context2.n) {
          case 0:
            if (collapsed) {
              reload();
            } else {
              reset();
            }
            setCollapsed(!collapsed);
          case 1:
            return _context2.a(2);
        }
      }, _callee2);
    }));
    return function toggleCollapsed() {
      return _ref2.apply(this, arguments);
    };
  }();
  return /*#__PURE__*/React.createElement("div", {
    className: "entity-data-container"
  }, /*#__PURE__*/React.createElement("h1", {
    className: "entity-data-stack-title"
  }, props.dataGroupName, props.collapsable && /*#__PURE__*/React.createElement("div", {
    className: clsx({
      'entity-data-toggle': true,
      'entity-data-toggle-collapsed': collapsed
    })
  }, /*#__PURE__*/React.createElement("i", {
    onClick: toggleCollapsed,
    className: "fa fa-angle-down"
  }))), (!props.collapsable || props.collapsable && !collapsed) && /*#__PURE__*/React.createElement("div", {
    className: clsx({
      'entity-data-content': false,
      'entity-data-content-collapsed': false
    })
  }, /*#__PURE__*/React.createElement(EntityDataGroupContainer$1, {
    config: props.config,
    fetching: fetching,
    data: data
  })));
};

var EntityDataContainer$1 = /*#__PURE__*/Object.freeze({
    __proto__: null,
    useEntityData: useEntityData,
    'default': EntityDataContainer
});

var EntityDataStack = function EntityDataStack(_ref) {
  var config = _ref.config,
    entity = _ref.entity,
    dataGroups = _ref.dataGroups,
    collapsable = _ref.collapsable,
    getData = _ref.getData;
  var stack = dataGroups.map(function (dgName) {
    return /*#__PURE__*/React.createElement(EntityDataContainer, {
      key: "container-for-" + dgName,
      dataGroupName: dgName,
      config: config[dgName],
      entity: entity,
      collapsable: collapsable,
      getData: getData
    });
  });
  return /*#__PURE__*/React.createElement("div", {
    className: "entity-data-stack"
  }, stack);
};

var css_248z = "table.entity-table {\n  border-spacing: 0;\n  border-collapse: separate; /*important for sticky column bordering*/\n}\ntable.entity-table tr {\n  position: relative; /*required to calculate offset*/\n}\n\n.actions-panel {\n  display: flex;\n  justify-content: flex-end;\n}\n\n.entity-list-view-count {\n  margin: 10px 0;\n}\n\ndiv.header-row {\n  /* only div - these styles should NOT apply to table elements thead, th or th */\n  height: 50px;\n  display: flex;\n}\n\n.header-row {\n  background-color: #F2F2F2;\n  border-bottom: 3px solid #eaeaea;\n  user-select: text;\n}\n.header-row div.header-column {\n  /* only div - these styles should NOT apply to table elements thead, th or th */\n  height: 100%;\n  align-items: center;\n  display: flex;\n  flex: 1;\n}\n.header-row div.header-column.checkbox {\n  display: flex;\n  justify-content: center;\n}\n.header-row .header-column:not(.checkbox) {\n  padding: 10px;\n  color: #666666;\n  font-weight: 500;\n  letter-spacing: 1;\n  border-left: 1px solid #eaeaea;\n  border-right: 1px solid #eaeaea;\n  cursor: pointer;\n}\n.header-row .header-column:not(.checkbox) i {\n  margin-left: 20px;\n}\n.header-row .header-column:not(.checkbox) .MuiTableSortLabel-root {\n  display: flex; /*this is to force sorting arrow to the right*/\n}\n.header-row .header-column.checkbox {\n  max-width: 48px;\n  justify-content: center;\n}\n.header-row .header-column.sticky {\n  position: sticky;\n  left: 0;\n  background-color: #F2F2F2;\n  z-index: 1;\n}\n.header-row .header-column.sticky.first {\n  border-right: 1px solid #ddd;\n}\n.header-row .header-column.sticky-end {\n  right: 0px;\n  border-left: 1px solid #ddd;\n}\n.header-row :first-child {\n  border-left: none;\n}\n.header-row :last-child {\n  border-right: none;\n}\n\ndiv.content-row {\n  /* only div - these styles should NOT apply to table elements thead, th or th */\n  display: flex;\n}\n\n.content-row {\n  border-bottom: 3px solid #eaeaea;\n  user-select: text;\n}\n.content-row div.content-column {\n  height: 100%;\n  align-items: center;\n  display: flex;\n  flex: 1;\n}\n.content-row .content-column {\n  background-color: white;\n}\n.content-row .content-column:not(.checkbox) {\n  padding: 10px;\n  color: #666666;\n  letter-spacing: 1;\n  word-break: break-word;\n}\n.content-row .content-column:not(.checkbox).first {\n  color: var(--app-accent-color);\n  cursor: pointer;\n  font-weight: 500;\n  min-width: 150px;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n.content-row .content-column.checkbox {\n  max-width: 48px;\n  justify-content: center;\n}\n.content-row .content-column.sticky {\n  position: sticky;\n  left: 0;\n  background-color: white;\n  z-index: 1;\n}\n.content-row .content-column.sticky.first {\n  border-right: 1px solid #ddd;\n}\n.content-row .content-column.sticky-end {\n  right: 0px;\n  left: auto;\n  border-left: 1px solid #ddd;\n}\n.content-row .content-column.entity-actions-cell {\n  padding: 0px !important;\n}\n.content-row .content-column.entity-actions-cell .entity-actions-panel {\n  flex-wrap: nowrap;\n}";
styleInject(css_248z);

var EntityTableHead = function EntityTableHead(_ref) {
  var allChecked = _ref.allChecked,
    handleAllCheck = _ref.handleAllCheck,
    columns = _ref.columns,
    multiselect = _ref.multiselect,
    lastColumnSticky = _ref.lastColumnSticky,
    currentSort = _ref.currentSort,
    sortEntitiesBy = _ref.sortEntitiesBy;
  var handleColumnClick = function handleColumnClick(col) {
    return _.noop();
  };
  var toggleSort = function toggleSort(col) {
    return function () {
      return sortEntitiesBy(col.accessor);
    };
  };
  var cells = useMemo(function () {
    return columns.map(function (col, i) {
      var first = i === 0;
      var lastColumn = i === columns.length - 1;
      return /*#__PURE__*/React.createElement(TableCell, _defineProperty(_defineProperty(_defineProperty({
        key: col.name,
        onClick: handleColumnClick,
        className: "header-column"
      }, "className", clsx({
        'header-column': true,
        ' first': first,
        ' sticky': first,
        ' sticky sticky-end': lastColumn && lastColumnSticky
      })), "padding", 'none'), "sortDirection", col.accessor == currentSort.property ? currentSort.order : false), col.accessor && /*#__PURE__*/React.createElement(TableSortLabel, {
        active: col.accessor == currentSort.property,
        direction: col.accessor == currentSort.property ? currentSort.order : 'asc',
        onClick: toggleSort(col),
        sx: {
          display: 'flex'
        }
      }, /*#__PURE__*/React.createElement(Box, {
        component: "div",
        sx: {
          flexGrow: 1
        }
      }, col.name)));
    });
  }, [lastColumnSticky, sortEntitiesBy, currentSort]);
  return /*#__PURE__*/React.createElement(TableHead, {
    className: "header-row"
  }, /*#__PURE__*/React.createElement(TableRow, null, multiselect && /*#__PURE__*/React.createElement(TableCell, {
    padding: "checkbox",
    className: "header-column checkbox sticky"
  }, /*#__PURE__*/React.createElement(RoundCheckbox, {
    checked: allChecked,
    onChange: handleAllCheck
  })), cells));
};

var EntityTableToolbar = function EntityTableToolbar(props) {
  var numSelected = props.numSelected,
    entityPlural = props.entityPlural,
    entitySingular = props.entitySingular;
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Toolbar, {
    disableGutters: true,
    variant: "dense"
  }, numSelected > 0 ? /*#__PURE__*/React.createElement(Typography, {
    variant: "overline",
    display: "block",
    gutterBottom: true
  }, "Showing ".concat(numSelected, " ").concat(numSelected > 1 ? entityPlural : entitySingular)) : null));
};
EntityTableToolbar.propTypes = {
  numSelected: PropTypes__default.number.isRequired,
  entityPlural: PropTypes__default.string.isRequired,
  entitySingular: PropTypes__default.string.isRequired
};
var EntityTableActionsCell = function EntityTableActionsCell(props) {
  var actions = props.actions,
    entity = props.entity,
    entityType = props.entityType,
    context = props.context;
  var rowCellActions = useMemo(function () {
    return Object.entries(actions).filter(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
        key = _ref2[0],
        a = _ref2[1];
      return a.showOnRowCell;
    }).reduce(function (acc, _ref3, i) {
      var _ref4 = _slicedToArray(_ref3, 2),
        key = _ref4[0],
        val = _ref4[1];
      acc[key] = val;
      return acc;
    }, {});
  }, [actions]);
  return /*#__PURE__*/React.createElement(EntityActionsPanel, {
    actions: rowCellActions,
    entity: entity,
    type: entityType,
    context: context
  });
};
var EntityTableContainer = function EntityTableContainer(_ref1) {
  var config = _ref1.config,
    actions = _ref1.actions,
    rowActions = _ref1.rowActions,
    context = _ref1.context,
    entities = _ref1.entities,
    selectedEntities = _ref1.selectedEntities,
    _ref1$entityPlural = _ref1.entityPlural,
    entityPlural = _ref1$entityPlural === void 0 ? 'Entities' : _ref1$entityPlural,
    _ref1$entitySingular = _ref1.entitySingular,
    entitySingular = _ref1$entitySingular === void 0 ? 'Entity' : _ref1$entitySingular,
    initialSort = _ref1.initialSort,
    onDetail = _ref1.onDetail,
    onChange = _ref1.onChange,
    onSortChange = _ref1.onSortChange,
    onPageChange = _ref1.onPageChange,
    onRowsPerPageChange = _ref1.onRowsPerPageChange;
  var tableRef = useRef();
  var checkableEntities = useMemo(function () {
    return entities.map(function (entity) {
      var checked = !_.isEmpty(selectedEntities) && selectedEntities.findIndex(function (selectedEntity) {
        return entity._id === selectedEntity._id;
      }) !== -1;
      return _objectSpread2(_objectSpread2({}, entity), {}, {
        checked: checked
      });
    });
  }, [entities, selectedEntities]);
  var checkCallback = useCallback(function (entity) {
    var newEntities = checkableEntities.map(function (e) {
      return e._id === entity._id ? _objectSpread2(_objectSpread2({}, e), {}, {
        checked: !entity.checked
      }) : e;
    });
    onChange === null || onChange === void 0 || onChange(newEntities);
  }, [entities, selectedEntities]);
  var isAllChecked = checkableEntities.every(function (e) {
    return e.checked;
  });
  var allCheckCallback = useCallback(function () {
    var newEntities = entities.map(function (e) {
      return _objectSpread2(_objectSpread2({}, e), {}, {
        checked: !isAllChecked
      });
    });
    onChange === null || onChange === void 0 || onChange(newEntities);
  }, [entities, selectedEntities]);

  //If the selectedEntities props is used, we assume a controlled behaviour, uncontrolled otherwise
  var allChecked, handleCheck, handleAllCheck, entityInstances;
  if (selectedEntities) {
    allChecked = isAllChecked;
    handleCheck = checkCallback;
    handleAllCheck = allCheckCallback;
    entityInstances = checkableEntities;
  } else {
    var checkedObject = useChecked(entities, checkCallback, allCheckCallback);
    allChecked = checkedObject.allChecked;
    handleCheck = checkedObject.handleCheck;
    handleAllCheck = checkedObject.handleAllCheck;
    entityInstances = checkedObject.items;
  }
  var _useSortEntities = useSortEntities(entitySingular, onSortChange, initialSort),
    sortEntitiesBy = _useSortEntities.sortEntitiesBy,
    currentSort = _useSortEntities.currentSort;
  var entityType = useMemo(function () {
    return {
      singular: entitySingular,
      plural: entityPlural
    };
  }, [entitySingular, entityPlural]);
  var columns = useMemo(function () {
    return produce(config.columns, function (columns) {
      var rowCellActions = Object.entries(actions).filter(function (_ref10) {
        var _ref11 = _slicedToArray(_ref10, 2),
          key = _ref11[0],
          a = _ref11[1];
        return a.showOnRowCell;
      });
      if (rowCellActions.length > 0) {
        columns.push({
          "name": "_row_actions",
          //"accessor" : "",
          "type": "actions"
        });
      }
    });
  }, [config.columns, actions]);
  var rowCellActions = useMemo(function () {
    var rowActionsMap = Object.entries(actions).filter(function (_ref12) {
      var _ref13 = _slicedToArray(_ref12, 2),
        key = _ref13[0],
        a = _ref13[1];
      return a.showOnRowCell;
    }).reduce(function (map, arrayOfKeyValue) {
      return _objectSpread2(_objectSpread2({}, map), {}, _defineProperty({}, arrayOfKeyValue[0], _objectSpread2({}, arrayOfKeyValue[1])));
    }, {});
    return produce(rowActionsMap, function (map) {
      Object.entries(map).forEach(function (_ref14) {
        var _ref15 = _slicedToArray(_ref14, 2),
          key = _ref15[0],
          a = _ref15[1];
        a.icon = a.icon + ' inv-icon__masked';
      });
    });
  }, [actions]);
  var buildTableCell = useCallback(function (instance) {
    return function (col, i) {
      var value = _.get(instance, col.accessor);
      var dispValue = value && typeof value === 'string' ? value : value ? value.val : null;
      dispValue = isValidUrl(dispValue) ? /*#__PURE__*/React.createElement("a", {
        href: dispValue,
        target: "_blank"
      }, dispValue) : dispValue;
      var first = i === 0;
      var lastColumn = i === columns.length - 1;
      return /*#__PURE__*/React.createElement(TableCell, _extends({
        className: clsx({
          'content-column': true,
          'entity-actions-cell': col.type == "actions",
          ' first': first,
          ' sticky': first,
          ' sticky sticky-end': lastColumn && config.lastColumnSticky
        })
      }, first && {
        onClick: function onClick() {
          return onDetail === null || onDetail === void 0 ? void 0 : onDetail(instance);
        }
      }, {
        component: "td",
        id: i,
        scope: "row",
        padding: "none",
        key: i + 1
      }), /*#__PURE__*/React.createElement("div", {
        className: "text-nowrap text-truncate"
      }, col.type == "actions" ? /*#__PURE__*/React.createElement(EntityTableActionsCell, {
        actions: rowCellActions,
        entity: [instance],
        entityType: entityType,
        context: context
      }) : /*#__PURE__*/React.createElement("span", null, dispValue)));
    };
  }, [onDetail, entityType, context, actions]);
  var initialPagination = {
    offset: 0,
    pageSize: config.numRows || 200,
    total: entities.length
  };
  var _usePaginateEntities = usePaginateEntities(initialPagination, onPageChange, onRowsPerPageChange),
    paginateTableBy = _usePaginateEntities.paginateTableBy,
    page = _usePaginateEntities.page,
    rowsPerPage = _usePaginateEntities.rowsPerPage,
    count = _usePaginateEntities.count;
  var generateStickyColumnRecalculationFn = function generateStickyColumnRecalculationFn(wait) {
    var _sumPreviousSiblingsWidth = function sumPreviousSiblingsWidth(elem) {
      var sum = elem.getBoundingClientRect().width;
      if (elem.previousElementSibling) {
        sum += _sumPreviousSiblingsWidth(elem.previousElementSibling);
      }
      return sum;
    };
    var calculateStickyColumnPositions = function calculateStickyColumnPositions() {
      if (!tableRef.current) {
        return;
      }
      console.log("recalculating left positions");
      var selectedNodes = tableRef.current.querySelectorAll("thead tr th.sticky:not(.sticky-end), tbody tr td.sticky:not(.sticky-end)");
      Array.from(selectedNodes).forEach(function (s) {
        var left = 0;
        if (s.previousElementSibling) {
          left = _sumPreviousSiblingsWidth(s.previousElementSibling);
        }
        s.style.left = left + "px";
      });
    };
    return _.debounce(calculateStickyColumnPositions, wait || 100);
  };
  useEffect(function () {
    //apply left style to sticky columns on CELLS RENDER (including pagination and sorting updates)
    //update sticky positions instantly
    var updateStickyCells = generateStickyColumnRecalculationFn(0);
    updateStickyCells();
    return function () {
      updateStickyCells.cancel();
    };
  }, [page, rowsPerPage, count, currentSort]);
  useEffect(function () {
    //apply left style to sticky columns on RESIZE EVENT
    //on resize use longer debounce
    var onEachResize = generateStickyColumnRecalculationFn(1000);
    window.addEventListener('resize', onEachResize);
    return function () {
      window.removeEventListener('resize', onEachResize);
      onEachResize.cancel();
    };
  }, []);
  var handleChangePage = function handleChangePage(event, newPage) {
    paginateTableBy({
      offset: newPage * rowsPerPage
    });
  };
  var handleChangeRowsPerPage = function handleChangeRowsPerPage(event) {
    paginateTableBy({
      pageSize: parseInt(event.target.value, 10)
    });
  };
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    dense = _useState2[0],
    setDense = _useState2[1];
  //const handleChangeDense = (event) => {
  //setDense(event.target.checked);
  //};

  // Avoid a layout jump when reaching the last page with empty rows.
  var emptyRows = rowsPerPage - count % rowsPerPage;
  var isLastPage = Math.ceil(count / rowsPerPage) - 1 == page;
  var actionableEntities = useMemo(function () {
    return entityInstances.filter(function (inst) {
      return inst.checked;
    });
  }, [entityInstances]);
  return /*#__PURE__*/React.createElement("div", {
    className: "entity-table-root ".concat(config.className)
  }, actions && /*#__PURE__*/React.createElement("div", {
    className: "actions-panel"
  }, /*#__PURE__*/React.createElement(EntityActionsPanel, {
    actions: actions,
    entity: actionableEntities,
    type: entityType,
    context: context
  })), /*#__PURE__*/React.createElement("div", {
    className: "entity-table__count-toolbar"
  }, /*#__PURE__*/React.createElement(EntityTableToolbar, {
    numSelected: entities.length,
    entitySingular: entitySingular,
    entityPlural: entityPlural
  })), /*#__PURE__*/React.createElement(TableContainer, null, /*#__PURE__*/React.createElement(Table, {
    ref: tableRef,
    sx: {
      minWidth: 280
    },
    "aria-labelledby": "tableTitle",
    size: dense ? 'small' : 'medium',
    className: 'entity-table'
  }, /*#__PURE__*/React.createElement(EntityTableHead, {
    allChecked: allChecked,
    handleAllCheck: handleAllCheck,
    lastColumnSticky: config.lastColumnSticky,
    multiselect: config.multiselect,
    columns: columns,
    currentSort: currentSort,
    sortEntitiesBy: sortEntitiesBy
  }), /*#__PURE__*/React.createElement(TableBody, null, _.orderBy(entityInstances, currentSort.valueAccessor, currentSort.order).slice(page * rowsPerPage, page * rowsPerPage + rowsPerPage).map(function (instance, index) {
    var isItemSelected = instance.checked;
    var handleChange = function handleChange() {
      return handleCheck(instance);
    };
    return /*#__PURE__*/React.createElement(TableRow, {
      hover: true,
      onClick: function onClick(event) {
        return _.noop(event, instance);
      },
      role: "checkbox",
      "aria-checked": isItemSelected,
      tabIndex: -1,
      key: instance._id,
      selected: isItemSelected,
      className: "content-row"
    }, config.multiselect && /*#__PURE__*/React.createElement(TableCell, {
      padding: "checkbox",
      className: "content-column checkbox sticky",
      key: 0
    }, /*#__PURE__*/React.createElement(RoundCheckbox, {
      checked: instance.checked,
      onChange: handleChange
    })), columns.map(buildTableCell(instance, config)));
  }), isLastPage > 0 && page > 0 && /*#__PURE__*/React.createElement(TableRow, {
    style: {
      height: (dense ? 31 : 41) * emptyRows
    }
  }, /*#__PURE__*/React.createElement(TableCell, {
    colSpan: 1 + columns.length
  }))))), /*#__PURE__*/React.createElement(TablePagination, {
    rowsPerPageOptions: [5, 50, 100, 200],
    component: "div",
    count: entities.length,
    rowsPerPage: rowsPerPage,
    page: page,
    onPageChange: handleChangePage,
    onRowsPerPageChange: handleChangeRowsPerPage,
    labelRowsPerPage: ""
  }));
};

var css_248z$1 = ".cm-s-monokai-sublime {\n\tfont-size: 1em;\n\tline-height: 1.5em;\n\tfont-family: inconsolata, monospace;\n\tletter-spacing: 0.3px;\n\tword-spacing: 1px;\n\tbackground: #272822;\n\tcolor: #F8F8F2;\n}\n.cm-s-monokai-sublime .CodeMirror-lines {\n\tpadding: 8px 0;\n}\n.cm-s-monokai-sublime .CodeMirror-gutters {\n\tbox-shadow: 1px 0 2px 0 rgba(0, 0, 0, 0.5);\n\t-webkit-box-shadow: 1px 0 2px 0 rgba(0, 0, 0, 0.5);\n\tbackground-color: #272822;\n\tpadding-right: 10px;\n\tz-index: 3;\n\tborder: none;\n}\n.cm-s-monokai-sublime div.CodeMirror-cursor {\n\tborder-left: 3px solid #F8F8F2;\n}\n.cm-s-monokai-sublime .CodeMirror-activeline-background {\n\tbackground: #3E3D32;\n}\n.cm-s-monokai-sublime .CodeMirror-selected {\n\tbackground: #49483E;\n}\n.cm-s-monokai-sublime .cm-comment {\n\tcolor: #75715E;\n}\n.cm-s-monokai-sublime .cm-string {\n\tcolor: #E6DB74;\n}\n.cm-s-monokai-sublime .cm-number {\n\tcolor: #66D9EF;\n}\n.cm-s-monokai-sublime .cm-atom {\n\tcolor: #66D9EF;\n}\n.cm-s-monokai-sublime .cm-keyword {\n\tcolor: #F92672;\n}\n.cm-s-monokai-sublime .cm-variable {\n\tcolor: #A6E22E;\n}\n.cm-s-monokai-sublime .cm-def {\n\tfont-style: italic;\n\tcolor: #FD971F;\n}\n.cm-s-monokai-sublime .cm-variable-2 {\n\tcolor: #F92672;\n}\n.cm-s-monokai-sublime .cm-property {\n\tcolor: #66D9EF;\n}\n.cm-s-monokai-sublime .cm-operator {\n\tcolor: #F92672;\n}\n.cm-s-monokai-sublime .CodeMirror-linenumber {\n\tcolor: #75715E;\n}\n";
styleInject(css_248z$1);

var JSONEditor = function JSONEditor(_ref) {
  var jsonValue = _ref.jsonValue,
    readonly = _ref.readonly,
    onChange = _ref.onChange;
  return /*#__PURE__*/React.createElement(Controlled, {
    value: jsonValue,
    options: {
      mode: {
        name: 'javascript',
        json: true
      },
      dragDrop: false,
      readOnly: readonly,
      theme: 'monokai-sublime',
      lineNumbers: true,
      // matchBrackets: true,
      autoCloseBrackets: true,
      foldGutter: true,
      gutters: ['CodeMirror-linenumbers', 'CodeMirror-foldgutter']
    },
    onBeforeChange: onChange
  });
};

function withGenericPageErrorBoundary(WrappedComponent) {
  return /*#__PURE__*/function (_React$Component) {
    function GenericPageErrorBoundary(props) {
      var _this;
      _classCallCheck(this, GenericPageErrorBoundary);
      _this = _callSuper(this, GenericPageErrorBoundary, [props]);
      _this.state = {
        hasError: false
      };
      //console.log("GENERIC PAGE ERROR BOUNDARY constructor props.userConfig",{...props.userConfig});
      return _this;
    }
    _inherits(GenericPageErrorBoundary, _React$Component);
    return _createClass(GenericPageErrorBoundary, [{
      key: "componentDidCatch",
      value: function componentDidCatch(error, errorInfo) {
        // You can also do more with the error here
        console.error(error);
        console.error(errorInfo);
      }
    }, {
      key: "render",
      value: function render() {
        //console.log("GENERIC PAGE ERROR BOUNDARY render this.props.userConfig",{...this.props.userConfig});
        return this.state.hasError ? /*#__PURE__*/React.createElement("div", {
          className: "inv-error-boundary-container"
        }, /*#__PURE__*/React.createElement("span", null, /*#__PURE__*/React.createElement("i", {
          className: "fas fa-exclamation-circle point-icon point-error"
        }), "Something went wrong")) : /*#__PURE__*/React.createElement(WrappedComponent, this.props);
      }
    }], [{
      key: "getDerivedStateFromError",
      value: function getDerivedStateFromError(error) {
        // Update state so the next render will show the fallback UI.
        return {
          hasError: true
        };
      }
    }]);
  }(React.Component);
}

export { EntityDataStack as E, JSONEditor as J, withEntitySearch as a, withEntityConfig as b, withEntityAvailableGroups as c, withGenericPageErrorBoundary as d, EntityDataContainer$1 as e, EntityDataGroupContainer$2 as f, EntityTableContainer as g, useEntityData as u, withEntityStore as w };
