import { s as styleInject, e as _inherits, f as _createClass, h as _classCallCheck, i as _callSuper, _ as _asyncToGenerator, a as _regenerator, g as _objectSpread2, n as _defineProperty, d as _slicedToArray, j as _toConsumableArray, l as _extends } from '../style-inject.es-ebcb980f.js';
import React, { useState, useEffect, Fragment } from 'react';
import _ from 'lodash';
import '@dtplatform/platform-api';
import 'jszip';
import 'file-saver';
import { f as ScriptCache, S as ScriptHelper, b as FilterControl, g as getRandomString } from '../TreeRendererHelper-7d89f2f1.js';
export { b as FilterControl, G as GenericMatButton } from '../TreeRendererHelper-7d89f2f1.js';
import { s as selectStyles, l as loadPlainInitialValueWithScriptedSelectFormat, a as useWithLinkedSelectChange, G as GroupControl } from '../EntityListView-43ddf04c.js';
export { A as AdvancedSearch, B as BaseTextInput, r as CollapsibleTextInput, C as ControlProvider, q as ControlTextOverlay, d as CreatableScriptedSelects, e as EnhancedFetchControl, F as FancyTreeControl, h as FetchButton, i as FetchingLegend, G as GroupControl, I as Image, O as OrDivider, j as Overlay, P as PinkCheckbox, k as ReactiveTreeControl, R as RoundCheckbox, S as ScriptedChart, f as ScriptedLinkedSelects, g as ScriptedSelects, m as SimpleSelect, o as SimpleTabbedTable, n as SimpleTable, b as SquareInSquareCheckbox, T as TextSearch, c as TickCheckbox, p as TreeSearch, u as useChecked } from '../EntityListView-43ddf04c.js';
import clsx from 'clsx';
import Button from '@mui/material/Button';
import '@mui/material/CircularProgress';
import '@dtplatform/iaf-script-engine';
import '@dtplatform/ui-utils';
import 'immer';
import Select from 'react-select';
import 'react-click-outside';
import 'react-date-picker';
import 'react-datetime-picker';
import CreatableSelect from 'react-select/creatable';
import 'prop-types';
import 'moment';
import 'interactjs';
export { S as StackableDrawer } from '../StackableDrawer-e9e633e1.js';
import '@nivo/pie';
import '@nivo/bar';
import '@nivo/line';
export { B as BigButtonBar, a as Cell, C as ChartStack, b as CompactButtonBar, c as CrossEntitySearch, G as GenericIframe, T as Table } from '../Table-4fbf94ec.js';
import 'redux';
import 'react-redux';
import '@reduxjs/toolkit';
import '@dtplatform/react-ifef';
import '../GenericModal-a2a94ca2.js';
import { Tooltip } from '@mui/material';
import '@mui/material/Checkbox';
import '@mui/material/SvgIcon';
import '@mui/system';
import '@mui/icons-material/CheckBox';
import '@mui/icons-material/CheckBoxOutlineBlank';
import '@mui/icons-material/IndeterminateCheckBoxRounded';
import '@mui/icons-material/CheckCircle';
import '@mui/icons-material/RadioButtonUnchecked';
import '@mui/icons-material/LinkTwoTone';
import '@mui/icons-material/LinkOff';
import '@mui/icons-material/ExpandLess';
import '@mui/icons-material/ExpandMore';
import Autosuggest from 'react-autosuggest';
export { G as GenericButton, R as RadioButtons } from '../RadioButtons-8e63c696.js';
import { d as distinct } from '../list-bfa909f6.js';
import 'classnames';
import 'react-router-dom';
export { I as Item, L as LinkedIcon } from '../LinkedIcon-2299f4b5.js';
export { S as SimpleTextThrobber } from '../SimpleTextThrobber-687e4daa.js';
import Grid from '@mui/material/Grid';
import ButtonGroup from '@mui/material/ButtonGroup';
import { ArrowDropDown, CheckCircleRounded, Cancel, Warning } from '@mui/icons-material';
import ClickAwayListener from '@mui/material/ClickAwayListener';
import Grow from '@mui/material/Grow';
import Paper from '@mui/material/Paper';
import Popper from '@mui/material/Popper';
import MenuItem from '@mui/material/MenuItem';
import MenuList from '@mui/material/MenuList';
import '@mui/material/Radio';
import '@mui/material/RadioGroup';
import '@mui/material/FormControlLabel';
import '@mui/material/FormControl';

var css_248z = ".mini-button {\n  cursor: pointer;\n  font-size: 14px;\n  background-color: lightgray;\n  border-radius: 10px;\n  display: inline-block;\n  margin: 0 10px;\n  padding: 0 10px;\n}\n\n.mini-icon-button {\n  cursor: pointer;\n  font-size: 14px;\n  background-color: lightgray;\n  border-radius: 10px;\n  display: inline-block;\n  margin: 0 5px;\n  padding: 3px 0;\n}\n\n.mini-icon-button i {\n  padding-left: 10px;\n}";
styleInject(css_248z);

/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2019] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */
var MiniButton = function MiniButton(_ref) {
  var className = _ref.className,
    _onClick = _ref.onClick,
    value = _ref.value;
  return /*#__PURE__*/React.createElement("div", {
    className: (className || "") + " mini-button",
    onClick: function onClick(e) {
      e.stopPropagation();
      _onClick();
    }
  }, value);
};
var MiniIconButton = function MiniIconButton(_ref2) {
  var className = _ref2.className,
    icon = _ref2.icon,
    _onClick2 = _ref2.onClick;
  return /*#__PURE__*/React.createElement("div", {
    className: (className || "") + " mini-icon-button",
    onClick: function onClick(e) {
      e.stopPropagation();
      _onClick2();
    }
  }, /*#__PURE__*/React.createElement("i", {
    className: icon
  }));
};

var defaultTheme = {
  container: {
    position: 'relative'
  },
  input: {
    width: 240,
    height: 30,
    padding: '10px 20px',
    fontFamily: 'Helvetica, sans-serif',
    fontWeight: 300,
    fontSize: 16,
    border: '1px solid #aaa',
    borderTopLeftRadius: 4,
    borderTopRightRadius: 4,
    borderBottomLeftRadius: 4,
    borderBottomRightRadius: 4
  },
  inputFocused: {
    outline: 'none'
  },
  inputOpen: {
    borderBottomLeftRadius: 0,
    borderBottomRightRadius: 0
  },
  suggestionsContainer: {
    display: 'none'
  },
  suggestionsContainerOpen: {
    display: 'block',
    position: 'relative',
    width: 280,
    border: '1px solid #aaa',
    backgroundColor: '#fff',
    fontFamily: 'Helvetica, sans-serif',
    fontWeight: 300,
    fontSize: 16,
    borderBottomLeftRadius: 4,
    borderBottomRightRadius: 4,
    maxHeight: '200px',
    overflowY: 'auto',
    zIndex: 1000
  },
  suggestionsList: {
    margin: 0,
    padding: 0,
    listStyleType: 'none'
  },
  suggestion: {
    cursor: 'pointer',
    padding: '10px 20px'
  },
  suggestionHighlighted: {
    backgroundColor: '#ddd'
  }
};
var DynamicAttributeInput = /*#__PURE__*/function (_React$Component) {
  function DynamicAttributeInput(props) {
    var _this;
    _classCallCheck(this, DynamicAttributeInput);
    _this = _callSuper(this, DynamicAttributeInput, [props]);
    _this.state = {
      dynamicValues: [],
      suggestions: []
    };
    _this.getSuggestions = _this.getSuggestions.bind(_this);
    _this.getSuggestionValue = _this.getSuggestionValue.bind(_this);
    _this.renderSuggestion = _this.renderSuggestion.bind(_this);
    _this.onSuggestionsFetchRequested = _this.onSuggestionsFetchRequested.bind(_this);
    _this.onSuggestionsClearRequested = _this.onSuggestionsClearRequested.bind(_this);
    _this.fetchOnFocus = _this.fetchOnFocus.bind(_this);
    return _this;
  }
  _inherits(DynamicAttributeInput, _React$Component);
  return _createClass(DynamicAttributeInput, [{
    key: "getSuggestions",
    value: function getSuggestions(value) {
      var inputValue = value.trim().toLowerCase();
      var suggs;
      if (inputValue.length === 0) return [];else if (!!this.props.dynamicValues) {
        suggs = this.props.dynamicValues.filter(function (dynVal) {
          return dynVal.toLowerCase().includes(inputValue);
        });
      } else {
        suggs = this.state.dynamicValues.filter(function (dynVal) {
          return dynVal.toLowerCase().includes(inputValue);
        });
      }
      return suggs;
    }
  }, {
    key: "getSuggestionValue",
    value: function getSuggestionValue(suggestion) {
      return suggestion;
    }
  }, {
    key: "renderSuggestion",
    value: function renderSuggestion(suggestion) {
      return /*#__PURE__*/React.createElement("div", null, suggestion);
    }
  }, {
    key: "onSuggestionsFetchRequested",
    value: function () {
      var _onSuggestionsFetchRequested = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(_ref) {
        var value;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              value = _ref.value;
              this.setState({
                suggestions: this.getSuggestions(value)
              });
            case 1:
              return _context.a(2);
          }
        }, _callee, this);
      }));
      function onSuggestionsFetchRequested(_x) {
        return _onSuggestionsFetchRequested.apply(this, arguments);
      }
      return onSuggestionsFetchRequested;
    }()
  }, {
    key: "onSuggestionsClearRequested",
    value: function onSuggestionsClearRequested() {
      this.setState({
        suggestions: []
      });
    }
  }, {
    key: "fetchOnFocus",
    value: function fetchOnFocus() {
      var _this2 = this;
      this.props.fetchValuesOnFocus().then(function (values) {
        if (!values) values = [];
        _this2.setState({
          dynamicValues: values
        });
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;
      var _this$state = this.state,
        value = _this$state.value,
        suggestions = _this$state.suggestions;
      var inputProps = {
        onFocus: !!this.props.fetchValuesOnFocus ? this.fetchOnFocus : null,
        value: this.props.value,
        onChange: function onChange(e, _ref2) {
          var newValue = _ref2.newValue;
          return _this3.props.onChange(_this3.props.attribute, newValue);
        },
        type: 'text',
        disabled: !!this.props.isDisabled
      };
      if (!!this.props.onBlur) inputProps.onBlur = this.props.onBlur;
      var theme = Object.assign({}, defaultTheme, this.props.themeOptions);
      return /*#__PURE__*/React.createElement(Autosuggest, {
        id: this.props.attribute,
        inputProps: inputProps,
        suggestions: suggestions,
        onSuggestionsFetchRequested: this.onSuggestionsFetchRequested,
        onSuggestionsClearRequested: this.onSuggestionsClearRequested,
        getSuggestionValue: this.getSuggestionValue,
        renderSuggestion: this.renderSuggestion,
        theme: theme
      });
    }
  }]);
}(React.Component);

var asSelectOption = function asSelectOption(option) {
  return {
    value: option.value,
    label: option.display,
    key: option.display
  };
};
var asSelectOptions = function asSelectOptions(options) {
  return options.map(asSelectOption);
};
var EnhancedPickListSelect = function EnhancedPickListSelect(_ref) {
  var currentValue = _ref.currentValue,
    onChange = _ref.onChange,
    disabled = _ref.disabled,
    selectsConfig = _ref.selects,
    compact = _ref.compact,
    horizontal = _ref.horizontal,
    selectOverrideStyles = _ref.selectOverrideStyles,
    _ref$isClearable = _ref.isClearable,
    isClearable = _ref$isClearable === void 0 ? true : _ref$isClearable,
    pickListScript = _ref.pickListScript,
    initialPickListType = _ref.initialPickListType,
    canCreateItems = _ref.canCreateItems,
    updateScript = _ref.updateScript;
  var _useState = useState(selectsConfig.reduce(function (acc, select, i) {
      return _objectSpread2(_objectSpread2({}, acc), {}, _defineProperty({}, select.display, {
        display: select.display,
        index: i,
        options: [],
        createPickListOnUpdate: select.createPickListOnUpdate && canCreateItems
      }));
    }, {})),
    _useState2 = _slicedToArray(_useState, 2),
    selects = _useState2[0],
    setSelects = _useState2[1];
  var value = currentValue || {};
  var getSelectedValue = function getSelectedValue(option) {
    return {
      value: option.value,
      display: option.label
    };
  };
  var fetchOptions = /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(currentSelect, currentSelectValue) {
      var nextSelect, selectOptions;
      return _regenerator().w(function (_context) {
        while (1) switch (_context.n) {
          case 0:
            nextSelect = _.values(selects)[currentSelect ? currentSelect.index + 1 : 0];
            if (!nextSelect) {
              _context.n = 2;
              break;
            }
            _context.n = 1;
            return ScriptCache.runScript(pickListScript, {
              type: currentSelect ? currentSelectValue[currentSelect.display][0].value : initialPickListType
            });
          case 1:
            selectOptions = _context.v;
            setSelects(function (selects) {
              return _objectSpread2(_objectSpread2({}, selects), {}, _defineProperty({}, nextSelect.display, _objectSpread2(_objectSpread2({}, nextSelect), {}, {
                type: selectOptions[0].type,
                options: selectOptions[0].values.sort(function (a, b) {
                  return a.display.localeCompare(b.display);
                })
              })));
            });
          case 2:
            loadPlainInitialValueWithScriptedSelectFormat(onChange, currentValue, selects);
          case 3:
            return _context.a(2);
        }
      }, _callee);
    }));
    return function fetchOptions(_x, _x2) {
      return _ref2.apply(this, arguments);
    };
  }();
  var _useWithLinkedSelectC = useWithLinkedSelectChange(selects, setSelects, value, getSelectedValue, onChange, fetchOptions),
    _useWithLinkedSelectC2 = _slicedToArray(_useWithLinkedSelectC, 1),
    onLinkedSelectChange = _useWithLinkedSelectC2[0];
  useEffect(function () {
    updateFetchOptions();
  }, [currentValue]);
  var updateFetchOptions = function updateFetchOptions() {
    fetchOptions();
    if (currentValue) {
      var selectKeys = Object.keys(selects);
      Promise.all(selectKeys.filter(function (k) {
        return currentValue[k] && currentValue[k].length;
      }).map(function (selectKey) {
        fetchOptions(selects[selectKey], currentValue);
      }));
    }
  };
  var updatePickList = /*#__PURE__*/function () {
    var _ref3 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(select, displayValue, optionValue) {
      var scriptArgs;
      return _regenerator().w(function (_context2) {
        while (1) switch (_context2.n) {
          case 0:
            scriptArgs = {
              type: select.type,
              newValue: {
                display: displayValue,
                value: optionValue
              }
            };
            if (select.createPickListOnUpdate) {
              scriptArgs = _objectSpread2(_objectSpread2({}, scriptArgs), {}, {
                newType: optionValue
              });
            }
            _context2.n = 1;
            return ScriptCache.runScript(updateScript, {
              pickList: scriptArgs
            });
          case 1:
            return _context2.a(2, _context2.v);
        }
      }, _callee2);
    }));
    return function updatePickList(_x3, _x4, _x5) {
      return _ref3.apply(this, arguments);
    };
  }();
  var refreshParentPickListCachedResult = /*#__PURE__*/function () {
    var _ref4 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3(selectId) {
      var index, parentPickListType, parentPickList;
      return _regenerator().w(function (_context3) {
        while (1) switch (_context3.n) {
          case 0:
            index = selects[selectId].index;
            parentPickListType = initialPickListType;
            if (index > 0) {
              parentPickList = Object.entries(selects).filter(function (e) {
                return e[1].index === index - 1;
              }).map(function (s) {
                return s[0];
              });
              parentPickListType = value[parentPickList[0]][0].value;
            }
            _context3.n = 1;
            return ScriptCache.runScript(pickListScript, {
              type: parentPickListType
            }, {
              ignoreCachedScriptResult: true
            });
          case 1:
            return _context3.a(2);
        }
      }, _callee3);
    }));
    return function refreshParentPickListCachedResult(_x6) {
      return _ref4.apply(this, arguments);
    };
  }();
  var parentHasValue = function parentHasValue(selectId) {
    var index = selects[selectId].index;
    if (index === 0) return true;
    var parentPickList = Object.entries(selects).filter(function (e) {
      return e[1].index === index - 1;
    }).map(function (s) {
      return s[0];
    });
    return value[parentPickList[0]] && value[parentPickList[0]].length;
  };
  var handleCreatableChange = function handleCreatableChange(selectId, selected, select) {
    if (selected && selected.__isNew__) {
      var tempSelects = _.cloneDeep(selects);
      var newSelectValue = select.createPickListOnUpdate ? selected.value + select.type : selected.value;
      tempSelects[selectId].options.push({
        display: selected.value,
        value: newSelectValue
      });
      tempSelects[selectId].options.sort(function (a, b) {
        return a.display.localeCompare(b.display);
      });
      setSelects(tempSelects);
      updatePickList(select, selected.value, newSelectValue);
      refreshParentPickListCachedResult(selectId);
      onLinkedSelectChange(selectId, {
        label: selected.value,
        value: newSelectValue
      }, selects[selectId]);
    } else {
      onLinkedSelectChange(selectId, selected, selects[selectId]);
    }
  };
  return /*#__PURE__*/React.createElement("div", {
    className: clsx("scripted-selects-control", compact && 'compact', horizontal && 'horizontal')
  }, _.values(_.mapValues(selects, function (select, selectId) {
    return /*#__PURE__*/React.createElement(Fragment, {
      key: selectId
    }, !compact && /*#__PURE__*/React.createElement("span", {
      className: clsx("select-title", select.required && "required")
    }, selectId), !canCreateItems && /*#__PURE__*/React.createElement(Select, {
      styles: selectOverrideStyles || {
        control: selectStyles
      },
      isMulti: false,
      value: value[selectId] ? asSelectOptions(value[selectId]) : [],
      onChange: function onChange(selected) {
        return onLinkedSelectChange(selectId, selected, select);
      },
      options: asSelectOptions(select.options),
      className: "select-element",
      closeMenuOnSelect: true,
      isClearable: isClearable,
      placeholder: "Select a ".concat(selectId),
      isDisabled: _.isEmpty(select.options) || disabled,
      menuPlacement: "auto",
      menuPosition: "fixed"
    }), canCreateItems && /*#__PURE__*/React.createElement(CreatableSelect, {
      styles: selectOverrideStyles || {
        control: selectStyles
      },
      isMulti: false,
      value: value[selectId] ? asSelectOptions(value[selectId]) : null,
      onChange: function onChange(selected) {
        return handleCreatableChange(selectId, selected, select);
      },
      options: asSelectOptions(select.options),
      className: "select-element",
      closeMenuOnSelect: true,
      isClearable: isClearable,
      placeholder: "Create or Select a ".concat(selectId),
      menuPlacement: "auto",
      menuPosition: "fixed",
      isDisabled: disabled || !parentHasValue(selectId)
    }));
  })));
};

var LinkedSelectsProgressive = /*#__PURE__*/function (_React$Component) {
  /* props
   * 
   * attributes = [
   *      {
   *          name: name, 
   *          isMulti: true/false, 
   *          values: [
   *              "value1", "value2"
   *          ],
   *          placeholder: "text'
   *      }
   * ]
   * 
   * onChange = function()
   * 
   * options = {
   *      direction: horizontal - default
   *                 vertical,
   *      hasLabel: true - default,
   *      isRequired: false - default
   *      
   * }
   */

  function LinkedSelectsProgressive(props) {
    var _this;
    _classCallCheck(this, LinkedSelectsProgressive);
    _this = _callSuper(this, LinkedSelectsProgressive, [props]);
    _this.state = {
      valueOptions: [],
      direction: null
    };
    _this.updateValueOptions = _this.updateValueOptions.bind(_this);
    _this.handleSelectValue = _this.handleSelectValue.bind(_this);
    return _this;
  }
  _inherits(LinkedSelectsProgressive, _React$Component);
  return _createClass(LinkedSelectsProgressive, [{
    key: "componentDidMount",
    value: function () {
      var _componentDidMount = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
        var direction;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              this.updateValueOptions();
              direction = "horizontal";
              if (!!this.props.options && !!this.props.options.direction && this.props.options.direction === 'vertical') direction = this.props.options.direction;
              _context.n = 1;
              return this.setState({
                direction: direction
              });
            case 1:
              return _context.a(2);
          }
        }, _callee, this);
      }));
      function componentDidMount() {
        return _componentDidMount.apply(this, arguments);
      }
      return componentDidMount;
    }()
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (!!this.props.defaultSelections && !_.isEqual(this.props.defaultSelections, prevProps.defaultSelections)) this.updateValueOptions();
    }
  }, {
    key: "updateValueOptions",
    value: function updateValueOptions() {
      var _this2 = this;
      //create state for tracking the selected options of each 
      //attribute in props.attributes    
      var valueOptions = [];
      this.props.attributes.forEach(function (att) {
        //create the options for the default selections for each attribute
        if (_this2.props.defaultSelections && _this2.props.defaultSelections[att.name]) {
          if (Array.isArray(_this2.props.defaultSelections[att.name])) {
            valueOptions[att.name] = _this2.props.defaultSelections[att.name].map(function (val) {
              return {
                value: val,
                label: val,
                key: val
              };
            });
          } else {
            var val = _this2.props.defaultSelections[att.name];
            valueOptions[att.name] = [{
              value: val,
              label: val,
              key: val
            }];
          }
        } else {
          valueOptions[att.name] = [];
        }
      });
      this.setState({
        valueOptions: valueOptions
      });
    }
  }, {
    key: "handleSelectValue",
    value: function () {
      var _handleSelectValue = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(att, options, index) {
        var valueOptions, i, values, key;
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              valueOptions = this.state.valueOptions; //update the state tracking the selected items
              if (att.isMulti) {
                if (!options) valueOptions[att.name] = [];else valueOptions[att.name] = options;
              } else {
                if (!options) valueOptions[att.name] = []; //when a single select if cleared options is null
                else valueOptions[att.name] = [options];
              }

              //always cascade a clear to later selects when a select changes
              for (i = index + 1; i < this.props.attributes.length; i++) {
                valueOptions[this.props.attributes[i].name] = [];
              }
              this.setState({
                valueOptions: valueOptions
              });

              //reduce the values sent to the props.onChange to just the selected values by attribute
              values = {};
              for (key in valueOptions) {
                values[key] = !!valueOptions[key] ? valueOptions[key].map(function (val) {
                  return val.value;
                }) : [];
              }
              this.props.onChange(values);
            case 1:
              return _context2.a(2);
          }
        }, _callee2, this);
      }));
      function handleSelectValue(_x, _x2, _x3) {
        return _handleSelectValue.apply(this, arguments);
      }
      return handleSelectValue;
    }()
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;
      var styles = {};
      var containerStyles = {};
      var subcontainerStyles = {};
      if (!!this.state.direction && this.state.direction === 'horizontal') {
        var width = '200px';
        styles = {
          container: function container(styles) {
            return _objectSpread2(_objectSpread2({}, styles), {}, {
              display: 'inline-block',
              minWidth: width,
              marginRight: '20px'
            });
          }
        };
        subcontainerStyles = {
          display: 'inline-flex',
          flexWrap: 'wrap',
          margin: '10px'
        };
        containerStyles = {
          display: 'inline-flex',
          flexWrap: 'wrap',
          margin: '10px'
        };
      } else {
        styles = {
          control: function control(styles) {
            return _objectSpread2(_objectSpread2({}, styles), {}, {
              width: '100%'
            });
          },
          container: function container(styles) {
            return _objectSpread2(_objectSpread2({}, styles), {}, {
              display: 'block',
              width: '100%'
            });
          }
        };
      }
      var selectsControls = !!this.props.attributes ? this.props.attributes.map(function (att, index) {
        var selectDisabled = false;
        if (att.values.length === 0) selectDisabled = true;else if (index !== 0 && (!_this3.state.valueOptions[_this3.props.attributes[index - 1].name] || _this3.state.valueOptions[_this3.props.attributes[index - 1].name].length === 0)) selectDisabled = true;else if (!!_this3.props.disabled) selectDisabled = true;
        return /*#__PURE__*/React.createElement("div", {
          key: att.name,
          style: subcontainerStyles
        }, !!_this3.props.options && _this3.props.options.hasLabel && /*#__PURE__*/React.createElement("label", {
          style: {
            display: 'block',
            margin: '10px',
            fontWeight: 'bold'
          },
          className: "mbsc-label"
        }, att.name, _this3.props.options.isRequired && ' (required)'), /*#__PURE__*/React.createElement(Select, {
          styles: styles,
          isMulti: att.isMulti,
          name: 'select-' + att.name,
          key: 'select-' + att.name,
          value: _this3.state.valueOptions[att.name],
          options: att.values.map(function (val) {
            return {
              value: val,
              label: val,
              key: val
            };
          }),
          className: "basic-multi-select",
          classNamePrefix: "select",
          closeMenuOnSelect: !att.isMulti,
          isClearable: true,
          placeholder: att.placeholder,
          onChange: function onChange(options) {
            return _this3.handleSelectValue(att, options, index);
          },
          isDisabled: selectDisabled
        }));
      }) : [];
      return /*#__PURE__*/React.createElement("div", {
        style: containerStyles
      }, selectsControls, !!this.props.btn && this.props.btn);
    }
  }]);
}(React.Component);

/*
 * Props
 * 
 * selectConfigs: array of select objects containing a name and a script to fetch it's values.
 * onChange()
 */

/**
 * @Deprecated, use {@link ./EnhancedScriptedLinkedSelects} instead
 */
var ScriptedLinkedSelects = /*#__PURE__*/function (_React$Component) {
  function ScriptedLinkedSelects(props) {
    var _this;
    _classCallCheck(this, ScriptedLinkedSelects);
    _this = _callSuper(this, ScriptedLinkedSelects, [props]);
    _this.state = {
      selectOptions: [],
      selectedOptions: {}
    };
    _this.onChange = _this.onChange.bind(_this);
    return _this;
  }
  _inherits(ScriptedLinkedSelects, _React$Component);
  return _createClass(ScriptedLinkedSelects, [{
    key: "componentDidMount",
    value: function () {
      var _componentDidMount = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
        var _this2 = this;
        var firstSelectValues, selectOptions, selectedOptions;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              if (!(this.props.selectConfigs.length < 2)) {
                _context.n = 1;
                break;
              }
              console.error('ScriptedLinkedSelects control requires at least two select configurations!');
              _context.n = 3;
              break;
            case 1:
              _context.n = 2;
              return ScriptHelper.executeScript(this.props.selectConfigs[0].script);
            case 2:
              firstSelectValues = _context.v;
              selectOptions = [];
              selectedOptions = {};
              this.props.selectConfigs.forEach(function (config, index) {
                selectOptions.push({
                  name: config.display,
                  isMulti: index === _this2.props.selectConfigs.length - 1 ? config.isMulti : false,
                  values: index === 0 ? firstSelectValues.sort(function (a, b) {
                    return a.localeCompare(b);
                  }) : [],
                  placeholder: "Select " + config.display + "..."
                });
                selectedOptions[config.display] = [];
              });
              this.setState({
                selectOptions: selectOptions,
                selectedOptions: selectedOptions
              });
            case 3:
              return _context.a(2);
          }
        }, _callee, this);
      }));
      function componentDidMount() {
        return _componentDidMount.apply(this, arguments);
      }
      return componentDidMount;
    }()
  }, {
    key: "onChange",
    value: function () {
      var _onChange = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(selectedValues) {
        var input, i, selectDisplay, nextSelectValues, selectOptions, replaceValues, currentSelections;
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              input = {};
              i = 0;
            case 1:
              if (!(i < this.props.selectConfigs.length)) {
                _context2.n = 6;
                break;
              }
              selectDisplay = this.props.selectConfigs[i].display; //if the current select has changed and was not cleared
              if (!(!_.isEqual(this.state.selectedOptions[selectDisplay], selectedValues[selectDisplay]) && !!selectedValues[selectDisplay].length)) {
                _context2.n = 4;
                break;
              }
              if (!(i + 1 < this.props.selectConfigs.length)) {
                _context2.n = 3;
                break;
              }
              input[selectDisplay] = selectedValues[selectDisplay][0];
              _context2.n = 2;
              return ScriptHelper.executeScript(this.props.selectConfigs[i + 1].script, {
                input: input
              });
            case 2:
              nextSelectValues = _context2.v;
              selectOptions = this.state.selectOptions;
              replaceValues = _.find(selectOptions, {
                name: this.props.selectConfigs[i + 1].display
              });
              replaceValues.values = nextSelectValues;
              this.setState({
                selectOptions: selectOptions
              });
              return _context2.a(3, 6);
            case 3:
              _context2.n = 5;
              break;
            case 4:
              input[selectDisplay] = selectedValues[selectDisplay][0];
            case 5:
              i++;
              _context2.n = 1;
              break;
            case 6:
              this.setState({
                selectedOptions: selectedValues
              });
              if (this.props.onChange) {
                currentSelections = {};
                Object.keys(selectedValues).forEach(function (key) {
                  if (selectedValues[key].length > 0) currentSelections[key] = selectedValues[key];
                });
                this.props.onChange(currentSelections);
              }
            case 7:
              return _context2.a(2);
          }
        }, _callee2, this);
      }));
      function onChange(_x) {
        return _onChange.apply(this, arguments);
      }
      return onChange;
    }()
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement(LinkedSelectsProgressive, {
        attributes: this.state.selectOptions,
        onChange: this.onChange,
        options: {
          hasLabel: true
        }
      });
    }
  }]);
}(React.Component);

var GROUP_SELECT_STYLES = {
  control: function control(styles) {
    return _objectSpread2(_objectSpread2({}, styles), {}, {
      width: '90%',
      margin: '10px 0'
    });
  },
  container: function container(styles) {
    return _objectSpread2(_objectSpread2({}, styles), {}, {
      display: 'block',
      width: '90%'
    });
  }
};
var FILTER_SELECT_STYLES = {
  control: function control(styles) {
    return _objectSpread2(_objectSpread2({}, styles), {}, {
      width: '100%',
      margin: '10px 0'
    });
  },
  container: function container(styles) {
    return _objectSpread2(_objectSpread2({}, styles), {}, {
      display: 'block',
      width: '100%'
    });
  }
};
var distinctPropNames = function distinctPropNames(entities) {
  return distinct(entities.flatMap(function (e) {
    return _.keys(e.properties);
  })).sort();
};
var makeFilterFrom = function makeFilterFrom(entities) {
  return function (propName) {
    return {
      name: propName,
      type: entities.find(function (e) {
        return _.get(e, "properties[".concat(propName, "].type"));
      }).properties[propName].type,
      values: distinct(entities.map(function (e) {
        return _.get(e.properties, "".concat(propName, ".val")) || "_empty_";
      }))
    };
  };
};
var GroupAndFilterControl = function GroupAndFilterControl(_ref) {
  var fetchedEntities = _ref.fetchedEntities,
    _ref$nonGroupableProp = _ref.nonGroupableProperties,
    nonGroupableProperties = _ref$nonGroupableProp === void 0 ? [] : _ref$nonGroupableProp,
    _ref$nonFilterablePro = _ref.nonFilterableProperties,
    nonFilterableProperties = _ref$nonFilterablePro === void 0 ? [] : _ref$nonFilterablePro,
    fetching = _ref.fetching,
    selectedFilters = _ref.selectedFilters,
    selectedGroups = _ref.selectedGroups,
    onGroupChange = _ref.onGroupChange,
    onFilterChange = _ref.onFilterChange;
  var availableGroups = function availableGroups() {
    return _.difference(distinctPropNames(fetchedEntities), nonGroupableProperties);
  };
  var availableFilters = function availableFilters() {
    return _.difference(distinctPropNames(fetchedEntities), nonFilterableProperties).map(makeFilterFrom(fetchedEntities)).reduce(function (filtersMap, filter) {
      return _objectSpread2(_objectSpread2({}, filtersMap), {}, _defineProperty({}, filter.name, filter));
    }, {
      "Entity Name": {
        values: fetchedEntities.map(function (e) {
          return e['Entity Name'];
        }),
        type: "text"
      }
    });
  };
  return /*#__PURE__*/React.createElement("div", {
    className: "entity-tree-panel"
  }, fetching && /*#__PURE__*/React.createElement("div", {
    className: "centered"
  }, "Retrieving data"), /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("label", null, "Group by:"), /*#__PURE__*/React.createElement(GroupControl, {
    className: "entity-group",
    styles: GROUP_SELECT_STYLES,
    groups: availableGroups(),
    selected: selectedGroups,
    onChange: onGroupChange
  }), /*#__PURE__*/React.createElement("label", null, "Filter by:"), /*#__PURE__*/React.createElement(FilterControl, {
    className: "entities-filter",
    styles: FILTER_SELECT_STYLES,
    onChange: onFilterChange,
    filters: selectedFilters,
    availableFilters: availableFilters()
  })));
};

var HierarchyAttributeSelects = /*#__PURE__*/function (_React$Component) {
  function HierarchyAttributeSelects(props) {
    var _this;
    _classCallCheck(this, HierarchyAttributeSelects);
    _this = _callSuper(this, HierarchyAttributeSelects, [props]);
    _this.state = {
      selects: []
    };
    _this.buildSelects = _this.buildSelects.bind(_this);
    _this.handleChange = _this.handleChange.bind(_this);
    return _this;
  }
  _inherits(HierarchyAttributeSelects, _React$Component);
  return _createClass(HierarchyAttributeSelects, [{
    key: "_getValuesRecursive",
    value: function _getValuesRecursive(selectedValues, i, attributeBranch) {
      var _this2 = this;
      var selects = this.state.selects;
      var hierAtt = this.props.hierarchyAttributes[i]; //the current hierarchical attribute
      var isNextAtt = !!this.props.hierarchyAttributes[i + 1]; //whether there is a next attribute to get values for

      //if the selectedValues have values for that attribute and there is a next hierarchy attribute
      if (!!selectedValues[hierAtt] && isNextAtt) {
        //foreach selected value add it's subvalues to the values for the next attribute
        var attributeKeys = selectedValues[this.props.hierarchyAttributes[i]];
        if (!Array.isArray(attributeKeys)) {
          attributeKeys = [attributeKeys];
        }
        attributeKeys.forEach(function (key) {
          //if the values are an array then they are leafs
          if (Array.isArray(attributeBranch[key])) {
            var cleanedValues = attributeBranch[key].filter(function (val) {
              return !!val;
            }); //remove undefined and null values
            selects[i + 1].values = _toConsumableArray(cleanedValues);
            selects[i + 1].values.sort();
          } else {
            //else if the values are an object there are nested levels below
            if (!!attributeBranch[key]) {
              //get the values for this level
              selects[i + 1].values = _toConsumableArray(Object.keys(attributeBranch[key]));
              selects[i + 1].values.sort();
              //check the level below
              _this2._getValuesRecursive(selectedValues, i + 1, attributeBranch[key]);
            }
          }
        });
        this.setState({
          selects: selects
        });
      }
    }
  }, {
    key: "handleChange",
    value: function () {
      var _handleChange = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(selectedValues) {
        var selects, i;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              //clear out all later options in the selects
              selects = this.state.selects;
              for (i = 1; i < selects.length; i++) {
                selects[i].values = [];
              }
              _context.n = 1;
              return this.setState({
                selects: selects
              });
            case 1:
              //recursively populate the options in the selects from teh structured data
              this._getValuesRecursive(selectedValues, 0, this.props.attributeValues);
              this.props.onChange(selectedValues);
            case 2:
              return _context.a(2);
          }
        }, _callee, this);
      }));
      function handleChange(_x) {
        return _handleChange.apply(this, arguments);
      }
      return handleChange;
    }()
  }, {
    key: "buildSelects",
    value: function () {
      var _buildSelects = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2() {
        var selects, i;
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              selects = [];
              for (i = 0; i < this.props.hierarchyAttributes.length; i++) {
                selects.push({
                  name: this.props.hierarchyAttributes[i],
                  isMulti: this.props.options && this.props.options.isMulti && i === this.props.hierarchyAttributes.length - 1,
                  values: i === 0 ? Object.keys(this.props.attributeValues) : [],
                  placeholder: 'Select ' + this.props.hierarchyAttributes[i] + '...'
                });
              }
              _context2.n = 1;
              return this.setState({
                selects: selects
              });
            case 1:
              //if defaultSelections have been passed load those select options
              if (!!this.props.defaultSelections) this._getValuesRecursive(this.props.defaultSelections, 0, this.props.attributeValues);
            case 2:
              return _context2.a(2);
          }
        }, _callee2, this);
      }));
      function buildSelects() {
        return _buildSelects.apply(this, arguments);
      }
      return buildSelects;
    }()
  }, {
    key: "componentDidMount",
    value: function () {
      var _componentDidMount = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3() {
        return _regenerator().w(function (_context3) {
          while (1) switch (_context3.n) {
            case 0:
              _context3.n = 1;
              return this.buildSelects();
            case 1:
              return _context3.a(2);
          }
        }, _callee3, this);
      }));
      function componentDidMount() {
        return _componentDidMount.apply(this, arguments);
      }
      return componentDidMount;
    }()
  }, {
    key: "componentDidUpdate",
    value: function () {
      var _componentDidUpdate = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4(prevProps, prevState) {
        return _regenerator().w(function (_context4) {
          while (1) switch (_context4.n) {
            case 0:
              if (!(!!this.props.defaultSelections && !!prevProps.defaultSelections && !_.isEqual(prevProps.defaultSelections, this.props.defaultSelections))) {
                _context4.n = 1;
                break;
              }
              _context4.n = 1;
              return this.buildSelects();
            case 1:
              return _context4.a(2);
          }
        }, _callee4, this);
      }));
      function componentDidUpdate(_x2, _x3) {
        return _componentDidUpdate.apply(this, arguments);
      }
      return componentDidUpdate;
    }()
  }, {
    key: "render",
    value: function render() {
      var cntrl = this.state.selects.length > 0 ? /*#__PURE__*/React.createElement(LinkedSelectsProgressive, {
        attributes: this.state.selects,
        options: this.props.options,
        onChange: this.handleChange,
        defaultSelections: this.props.defaultSelections,
        btn: this.props.btn,
        disabled: this.props.disabled
      }) : /*#__PURE__*/React.createElement("div", null);
      return cntrl;
    }
  }]);
}(React.Component);

/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2019] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */
var SimpleMultiSelect = function SimpleMultiSelect(_ref) {
  var propName = _ref.propName,
    available = _ref.available,
    selections = _ref.selections,
    update = _ref.update;
  var selected = selections.slice(0);
  var options = available.filter(function (v) {
    return selected.indexOf(v) < 0;
  }).map(function (v) {
    return /*#__PURE__*/React.createElement("option", {
      key: v
    }, v);
  });
  options.unshift(/*#__PURE__*/React.createElement("option", {
    key: "_none"
  }, selected.length == 0 ? "Choose a value..." : "Choose another value..."));
  var select = /*#__PURE__*/React.createElement("select", {
    onChange: function onChange(e) {
      selectionAdded(e);
    }
  }, options);
  var selectionAdded = function selectionAdded(e) {
    selected.push(e.target.value);
    update(propName, selected);
  };
  var selectionRemoved = function selectionRemoved(v) {
    selected = selected.filter(function (vv) {
      return vv != v;
    });
    update(propName, selected);
  };
  var i = 0;
  return /*#__PURE__*/React.createElement("div", {
    className: "filter-multi-select"
  }, selections.map(function (v) {
    return /*#__PURE__*/React.createElement("div", {
      key: "filter-multi-selet" + i++,
      className: "filter-multi-select-value",
      onClick: function onClick(e) {
        return selectionRemoved(v);
      }
    }, v);
  }), select);
};

var SimpleTextReducer = function SimpleTextReducer(_ref) {
  var text = _ref.text,
    limit = _ref.limit;
  var newText;
  if (text.length > limit) {
    newText = text.substring(0, limit) + "...";
  }
  return /*#__PURE__*/React.createElement("div", null, newText ? /*#__PURE__*/React.createElement(Tooltip, {
    title: text
  }, /*#__PURE__*/React.createElement("i", {
    style: {
      cursor: 'pointer'
    }
  }, newText)) : /*#__PURE__*/React.createElement("i", null, text));
};

var TreeControl = function TreeControl(_ref) {
  var tree = _ref.tree,
    renderBranchNode = _ref.renderBranchNode,
    renderLeafNode = _ref.renderLeafNode,
    renderLeaves = _ref.renderLeaves,
    selectedNodes = _ref.selectedNodes;
  if (!tree) return null;
  var toggle = function toggle(e, branch) {
    var el = document.querySelector("." + branch);
    Array.from(el.children).forEach(function (e) {
      return e.classList.toggle("expanded");
    });
    e.stopPropagation();
  };
  var _getNodes = function getNodes(nodes, depth, selected) {
    if (!nodes) return;
    var children;
    if (Array.isArray(nodes)) {
      if (renderLeaves) children = renderLeaves(nodes);else {
        children = nodes.map(function (n) {
          return /*#__PURE__*/React.createElement("li", {
            key: n._id,
            className: depth <= 2 ? "expanded" : ""
          }, /*#__PURE__*/React.createElement("a", {
            className: selected || selectedNodes.includes(n._id) ? "selected" : ""
          }, renderLeafNode(n)));
        });
      }
    } else {
      children = [];
      depth++;
      Object.entries(nodes).forEach(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
          nodeName = _ref3[0],
          nodeValue = _ref3[1];
        var branchClassName = getRandomString("branch_");
        var isSelected = selected || selectedNodes.includes(nodeName);
        children.push(/*#__PURE__*/React.createElement("li", {
          key: nodeName,
          className: depth <= 3 ? "expanded" : ""
        }, /*#__PURE__*/React.createElement("a", {
          onClick: function onClick(e) {
            return toggle(e, branchClassName);
          },
          className: isSelected ? "selected" : ""
        }, ">\xA0", renderBranchNode ? renderBranchNode(nodeName, nodeValue) : nodeName), /*#__PURE__*/React.createElement("ul", {
          className: branchClassName,
          key: nodeName + "_children"
        }, _getNodes(nodeValue, depth, isSelected))));
      });
    }
    return children;
  };
  return /*#__PURE__*/React.createElement("ul", {
    className: "tree"
  }, _getNodes(tree, 1));
};

function SplitButton(_ref) {
  var options = _ref.options,
    airaLabel = _ref.airaLabel,
    onClick = _ref.onClick,
    containerClass = _ref.containerClass,
    buttonClass = _ref.buttonClass,
    disabled = _ref.disabled,
    _ref$dropdown_disable = _ref.dropdown_disabled,
    dropdown_disabled = _ref$dropdown_disable === void 0 ? false : _ref$dropdown_disable,
    onOptionChange = _ref.onOptionChange;
  var _React$useState = React.useState(false),
    _React$useState2 = _slicedToArray(_React$useState, 2),
    open = _React$useState2[0],
    setOpen = _React$useState2[1];
  var anchorRef = React.useRef(null);
  var _React$useState3 = React.useState(1),
    _React$useState4 = _slicedToArray(_React$useState3, 2),
    selectedIndex = _React$useState4[0],
    setSelectedIndex = _React$useState4[1];
  var handleClick = function handleClick() {
    onClick(options[selectedIndex]);
  };
  var handleMenuItemClick = function handleMenuItemClick(event, index) {
    setSelectedIndex(index);
    setOpen(false);
    onOptionChange(options[index]);
  };
  var handleToggle = function handleToggle() {
    setOpen(function (prevOpen) {
      return !prevOpen;
    });
  };
  var handleClose = function handleClose(event) {
    if (anchorRef.current && anchorRef.current.contains(event.target)) {
      return;
    }
    setOpen(false);
  };
  return /*#__PURE__*/React.createElement(Grid, {
    container: true,
    direction: "column",
    alignItems: "center",
    className: containerClass !== null && containerClass !== void 0 ? containerClass : ''
  }, /*#__PURE__*/React.createElement(Grid, {
    item: true,
    xs: 12
  }, /*#__PURE__*/React.createElement(ButtonGroup, {
    variant: "contained",
    color: "inherit",
    ref: anchorRef,
    "aria-label": "split button"
  }, /*#__PURE__*/React.createElement(Button, {
    onClick: handleClick,
    disabled: disabled,
    className: buttonClass !== null && buttonClass !== void 0 ? buttonClass : ''
  }, options[selectedIndex]), /*#__PURE__*/React.createElement(Button, {
    className: buttonClass !== null && buttonClass !== void 0 ? buttonClass : '',
    color: "inherit",
    size: "small",
    "aria-controls": open ? 'split-button-menu' : undefined,
    "aria-expanded": open ? 'true' : undefined,
    "aria-label": airaLabel,
    "aria-haspopup": "menu",
    onClick: handleToggle,
    disabled: dropdown_disabled
  }, /*#__PURE__*/React.createElement(ArrowDropDown, null))), /*#__PURE__*/React.createElement(Popper, {
    open: open,
    anchorEl: anchorRef.current,
    role: undefined,
    transition: true,
    disablePortal: true
  }, function (_ref2) {
    var TransitionProps = _ref2.TransitionProps,
      placement = _ref2.placement;
    return /*#__PURE__*/React.createElement(Grow, _extends({}, TransitionProps, {
      style: {
        transformOrigin: placement === 'bottom' ? 'center top' : 'center bottom'
      }
    }), /*#__PURE__*/React.createElement(Paper, null, /*#__PURE__*/React.createElement(ClickAwayListener, {
      onClickAway: handleClose
    }, /*#__PURE__*/React.createElement(MenuList, {
      id: "split-button-menu"
    }, options.map(function (option, index) {
      return /*#__PURE__*/React.createElement(MenuItem, {
        key: option,
        disabled: index === 2,
        selected: index === selectedIndex,
        onClick: function onClick(event) {
          return handleMenuItemClick(event, index);
        }
      }, option);
    })))));
  })));
}

var css_248z$1 = ".alert-indicator {\n  color: #CD2026;\n}";
styleInject(css_248z$1);

var AlertIndicator = function AlertIndicator(_ref) {
  var className = _ref.className,
    descriptions = _ref.descriptions;
  return /*#__PURE__*/React.createElement(Tooltip, {
    title: /*#__PURE__*/React.createElement("div", null, descriptions.map(function (a) {
      return /*#__PURE__*/React.createElement("p", null, a);
    }))
  }, /*#__PURE__*/React.createElement("i", {
    className: "alert-indicator ".concat(className || "", " fa fa-exclamation-triangle")
  }));
};

var css_248z$2 = ".toast-notification {\n  position: absolute;\n  right: 0;\n  margin: 24px;\n}\n.toast-notification .icon {\n  margin-right: 15px;\n}\n.toast-notification .error-toast,\n.toast-notification .success-toast,\n.toast-notification .warning-toast {\n  position: relative;\n  padding: 16px;\n  border-radius: 2px;\n  min-width: 208px;\n  max-width: 344px;\n  color: #FFFFFF;\n  display: flex;\n  align-items: center;\n  animation: movein 0.5s ease forwards;\n}\n@keyframes movein {\n  from {\n    right: -500px;\n  }\n  to {\n    right: 0px;\n  }\n}\n.toast-notification .error-toast {\n  background: #D32F2F;\n}\n.toast-notification .success-toast {\n  background: #689F38;\n}\n.toast-notification .warning-toast {\n  background: #E86826;\n}";
styleInject(css_248z$2);

var toastCount = 0;
var useToast = function useToast() {
  var _useState = useState([]),
    _useState2 = _slicedToArray(_useState, 2),
    toasts = _useState2[0],
    setToasts = _useState2[1];
  function addToast(_ref) {
    var toast = _ref.toast,
      delay = _ref.delay;
    var id = toastCount++;
    var newToast = {
      toast: toast,
      id: id
    };
    setToasts(function (prev) {
      return [].concat(_toConsumableArray(prev), [newToast]);
    });
    var timer = setTimeout(function () {
      setToasts(function (toasts) {
        return toasts.filter(function (toast) {
          return toast.id !== id;
        });
      });
    }, delay);
  }
  return [toasts, addToast];
};
var ToastContainer = function ToastContainer(_ref2) {
  var children = _ref2.children,
    toasts = _ref2.toasts;
  return /*#__PURE__*/React.createElement("div", {
    className: "toast-notification"
  }, toasts ? toasts.map(function (_ref3) {
    var toast = _ref3.toast,
      id = _ref3.id;
    return /*#__PURE__*/React.createElement("div", {
      key: id
    }, toast);
  }) : {
    children: children
  });
};

var Toast = function Toast(_ref) {
  var children = _ref.children,
    className = _ref.className;
  return /*#__PURE__*/React.createElement("div", {
    className: "toast-notification ".concat(className)
  }, children);
};
var SuccessToast = function SuccessToast(_ref2) {
  var message = _ref2.message;
  return /*#__PURE__*/React.createElement(Toast, {
    className: 'success-toast'
  }, /*#__PURE__*/React.createElement(CheckCircleRounded, {
    className: "icon"
  }), message);
};
var ErrorToast = function ErrorToast(_ref3) {
  var message = _ref3.message;
  return /*#__PURE__*/React.createElement(Toast, {
    className: 'error-toast'
  }, /*#__PURE__*/React.createElement(Cancel, {
    className: "icon"
  }), message);
};
var WarningToast = function WarningToast(_ref4) {
  var message = _ref4.message;
  return /*#__PURE__*/React.createElement(Toast, {
    className: 'warning-toast'
  }, /*#__PURE__*/React.createElement(Warning, {
    className: "icon"
  }), message);
};

export { AlertIndicator, DynamicAttributeInput, EnhancedPickListSelect, ErrorToast, GroupAndFilterControl, HierarchyAttributeSelects, LinkedSelectsProgressive, MiniButton, MiniIconButton, ScriptedLinkedSelects as ScriptedLinkedSelectsOld, SimpleMultiSelect, SimpleTextReducer, SplitButton, SuccessToast, Toast, ToastContainer, TreeControl, WarningToast, defaultTheme, useToast };
