import { d as _slicedToArray, s as styleInject } from '../style-inject.es-ebcb980f.js';
import React, { useState, useRef } from 'react';
import clsx from 'clsx';
import 'interactjs';
import { D as DEFAULT_DRAWER_WIDTH } from '../StackableDrawer-e9e633e1.js';
export { S as StackableDrawer } from '../StackableDrawer-e9e633e1.js';
import '@dtplatform/react-ifef';
export { G as GenericModal } from '../GenericModal-a2a94ca2.js';

var StackableContentDrawer = function StackableContentDrawer(_ref) {
  var children = _ref.children,
    anchor = _ref.anchor,
    childrenMinWidth = _ref.childrenMinWidth;
  var _useState = useState(childrenMinWidth || DEFAULT_DRAWER_WIDTH),
    _useState2 = _slicedToArray(_useState, 1),
    contentMinWidth = _useState2[0];
  var drawer = useRef();
  return /*#__PURE__*/React.createElement("div", {
    ref: drawer,
    className: clsx('drawer', anchor == 'right' && 'drawer-anchor-right'),
    style: {
      width: '100%',
      flexGrow: 1
    }
  }, /*#__PURE__*/React.createElement("div", {
    className: clsx({
      'drawer-content': true,
      'drawer-content-open': true
    })
  }, /*#__PURE__*/React.createElement("div", {
    style: {
      minWidth: contentMinWidth,
      transitionDelay: '1s'
    }
  }, children)));
};

var css_248z = ".stackable-drawers-container {\n  position: absolute;\n  width: auto;\n  height: 100%;\n  top: 0px;\n  display: flex;\n}\n.stackable-drawers-container.stackable-drawers-container-fw {\n  width: 100%;\n}\n.stackable-drawers-container.stackable-drawers-container-a-right {\n  right: 0;\n}";
styleInject(css_248z);

var StackableDrawerContainer = function StackableDrawerContainer(_ref) {
  var children = _ref.children,
    fullWidth = _ref.fullWidth,
    anchor = _ref.anchor,
    customClass = _ref.customClass;
  return /*#__PURE__*/React.createElement("div", {
    className: clsx("stackable-drawers-container", fullWidth && "stackable-drawers-container-fw", anchor && "stackable-drawers-container-a-" + anchor, customClass)
  }, children);
};

export { StackableContentDrawer, StackableDrawerContainer };
