import { s as styleInject, e as _inherits, f as _createClass, h as _classCallCheck, i as _callSuper, g as _objectSpread2, d as _slicedToArray, _ as _asyncToGenerator, a as _regenerator, l as _extends } from '../style-inject.es-ebcb980f.js';
import React, { useState, useEffect } from 'react';
import _ from 'lodash';
import { IafPassSvc, axiosInstance, IafSession } from '@dtplatform/platform-api';
import 'jszip';
import 'file-saver';
import { F as FileHelpers, B as getTitleBarInfoFromProps, y as getPlatform } from '../TreeRendererHelper-7d89f2f1.js';
import '../EntityListView-43ddf04c.js';
import clsx from 'clsx';
import '@mui/material/Button';
import '@mui/material/CircularProgress';
import '@dtplatform/iaf-script-engine';
import '@dtplatform/ui-utils';
import { enableMapSet } from 'immer';
import 'react-select';
import 'react-click-outside';
import 'react-date-picker';
import 'react-datetime-picker';
import 'react-select/creatable';
import PropTypes__default, { string, object, func } from 'prop-types';
import 'moment';
import 'interactjs';
import '../StackableDrawer-e9e633e1.js';
import '@nivo/pie';
import '@nivo/bar';
import '@nivo/line';
import '../Table-4fbf94ec.js';
import 'redux';
import { connect, Provider } from 'react-redux';
import '@reduxjs/toolkit';
import { IfefBody } from '@dtplatform/react-ifef';
import '../GenericModal-a2a94ca2.js';
import '@mui/material';
import '@mui/material/Checkbox';
import '@mui/material/SvgIcon';
import '@mui/system';
import '@mui/icons-material/CheckBox';
import '@mui/icons-material/CheckBoxOutlineBlank';
import '@mui/icons-material/IndeterminateCheckBoxRounded';
import '@mui/icons-material/CheckCircle';
import '@mui/icons-material/RadioButtonUnchecked';
import '@mui/icons-material/LinkTwoTone';
import '@mui/icons-material/LinkOff';
import '@mui/icons-material/ExpandLess';
import '@mui/icons-material/ExpandMore';
import '../RadioButtons-8e63c696.js';
import classnames from 'classnames';
import { HashRouter, Switch } from 'react-router-dom';
import { L as LinkedIcon, I as Item } from '../LinkedIcon-2299f4b5.js';
import '../SimpleTextThrobber-687e4daa.js';
import '@mui/icons-material';
import '@mui/material/Radio';
import '@mui/material/RadioGroup';
import '@mui/material/FormControlLabel';
import '@mui/material/FormControl';
import { A as AppContext } from '../appContext-07909014.js';
import '../bytesunit-e53abe5f.js';
import '../genericPageContext-de32d520.js';
import '../GenericPageErrorBoundary-27ba825c.js';
import 'react-codemirror2';
import 'codemirror/lib/codemirror.css';
import 'codemirror/addon/fold/foldgutter.css';
import 'codemirror/mode/javascript/javascript.js';
import 'codemirror/addon/edit/matchbrackets.js';
import 'codemirror/addon/edit/closebrackets.js';
import 'codemirror/addon/fold/foldcode.js';
import 'codemirror/addon/fold/foldgutter.js';
import 'codemirror/addon/fold/brace-fold.js';
import 'codemirror/addon/fold/comment-fold.js';
import 'codemirror/addon/comment/comment.js';
import { l as store } from '../store-31878c8e.js';
import { TransitionGroup, CSSTransition } from 'react-transition-group';
import { g as getPlatformPath, A as AppProvider } from '../AppProvider-2702c389.js';
import '@dtplatform/iaf-lib';
import 'qs';
import '@mui/material/Dialog';
import 'mime-types';
import 'codemirror/addon/hint/show-hint.js';
import 'codemirror/addon/hint/show-hint.css';
import 'json5';
import '@mui/material/Switch';
import { IafAuth } from '@dtplatform/platform-ui-components';
import { parse } from 'querystring';
import isTouchDevice from 'is-touch-device';
import { useSwipeable } from 'react-swipeable';

var css_248z = "#SidePanelContent nav {\n  height: 100%;\n}\n#SidePanelContent nav .main-nav {\n  height: 100%;\n  overflow-x: hidden;\n  overflow-y: scroll;\n}\n#SidePanelContent nav .main-nav::-webkit-scrollbar {\n  display: none;\n}";
styleInject(css_248z);

var FlexContainer = /*#__PURE__*/function (_React$Component) {
  function FlexContainer(props) {
    _classCallCheck(this, FlexContainer);
    return _callSuper(this, FlexContainer, [props]);
  }
  _inherits(FlexContainer, _React$Component);
  return _createClass(FlexContainer, [{
    key: "render",
    value: function render() {
      var classes = classnames({
        'flex-container': true
      }, this.props.customClasses);
      return /*#__PURE__*/React.createElement("div", {
        className: classes,
        id: "SidePanelContent",
        "data-snap-ignore": false
      }, this.props.children);
    }
  }]);
}(React.Component);

var css_248z$1 = ".flex-content {\n  background-color: white;\n}\n\n.scroll-overflowY {\n  overflow-y: auto !important;\n  height: 100%;\n}\n.scroll-overflowY::-webkit-scrollbar {\n  width: 7px;\n  height: 7px;\n}\n.scroll-overflowY::-webkit-scrollbar-track {\n  background: white;\n}\n.scroll-overflowY::-webkit-scrollbar-thumb {\n  background: #DCDCDC;\n  border-radius: 2rem;\n}\n.scroll-overflowY::-webkit-scrollbar-thumb:hover {\n  background: #B8B8B8;\n}";
styleInject(css_248z$1);

var FlexContent = /*#__PURE__*/function (_React$Component) {
  function FlexContent(props) {
    _classCallCheck(this, FlexContent);
    return _callSuper(this, FlexContent, [props]);
  }
  _inherits(FlexContent, _React$Component);
  return _createClass(FlexContent, [{
    key: "render",
    value: function render() {
      var classes = classnames({
        'flex-content': true
      }, {
        'scroll-overflowY': true
      }, this.props.customClasses);
      return /*#__PURE__*/React.createElement("div", {
        className: classes
      }, this.props.children);
    }
  }]);
}(React.Component);

var FlexLeftNav = /*#__PURE__*/function (_React$Component) {
  function FlexLeftNav() {
    _classCallCheck(this, FlexLeftNav);
    return _callSuper(this, FlexLeftNav, arguments);
  }
  _inherits(FlexLeftNav, _React$Component);
  return _createClass(FlexLeftNav, [{
    key: "render",
    value: function render() {
      var classes = classnames(this.props.customClasses);
      return /*#__PURE__*/React.createElement("div", {
        className: classes
      }, this.props.children);
    }
  }]);
}(React.Component);
FlexLeftNav.propTypes = {
  customClasses: string
};
FlexLeftNav.defaultProps = {
  customClasses: ''
};

function SwipeablePanel(props) {
  var handlers = useSwipeable({
    onSwipedLeft: props.onSwipeLeft,
    onSwipedRight: props.onSwipeRight,
    onSwipedUp: props.onSwipeUp,
    onSwipedDown: props.onSwipeDown
  });
  return /*#__PURE__*/React.createElement("div", handlers, props.children);
}
SwipeablePanel.propTypes = {
  onSwipeRight: PropTypes__default.func,
  onSwipeLeft: PropTypes__default.func,
  onSwipeUp: PropTypes__default.func,
  onSwipeDown: PropTypes__default.func
};
var DraggablePanel = /*#__PURE__*/function (_React$Component) {
  function DraggablePanel(props) {
    var _this;
    _classCallCheck(this, DraggablePanel);
    _this = _callSuper(this, DraggablePanel, [props]);
    var position = props.position || {};
    _this.state = {
      pos: {
        left: position.left || 100,
        top: position.top || 100
      }
    };
    _this.handleDrag = _this.handleDrag.bind(_this);
    return _this;
  }
  _inherits(DraggablePanel, _React$Component);
  return _createClass(DraggablePanel, [{
    key: "handleDrag",
    value: function handleDrag(newPos) {
      this.setState({
        pos: {
          left: newPos.left,
          top: newPos.top
        }
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var pos = this.state.pos;
      return /*#__PURE__*/React.createElement("div", {
        style: _objectSpread2(_objectSpread2({}, pos), {}, {
          position: 'absolute'
        }),
        draggable: "true",
        onDrag: function onDrag(e) {
          e.preventDefault();
          _this2.handleDrag({
            left: e.clientX,
            top: e.clientY
          });
        },
        onDragEnd: function onDragEnd() {
          return console.log('drag ended.');
        }
      }, this.props.children);
    }
  }]);
}(React.Component);
var TouchPanel = {
  SwipeablePanel: SwipeablePanel,
  DraggablePanel: DraggablePanel
};

var SwipeablePanel$1 = TouchPanel.SwipeablePanel;
var FlexLeftNavs = /*#__PURE__*/function (_React$Component) {
  function FlexLeftNavs(props) {
    var _this;
    _classCallCheck(this, FlexLeftNavs);
    _this = _callSuper(this, FlexLeftNavs, [props]);

    //TODO: we should remove this props to state copy
    _this.state = {
      classes: classnames(_this.props.customClasses)
    };
    _this.isTouchDevice = isTouchDevice();
    _this.handleSwipeRight = _this.handleSwipeRight.bind(_this);
    _this.handleSwipeLeft = _this.handleSwipeLeft.bind(_this);
    return _this;
  }
  _inherits(FlexLeftNavs, _React$Component);
  return _createClass(FlexLeftNavs, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      //TODO: this will no longer be needed after we remove the props to state copy
      if (this.props.customClasses !== prevProps.customClasses) {
        this.setState({
          classes: classnames(this.props.customClasses)
        });
      }
    }
  }, {
    key: "handleSwipeRight",
    value: function handleSwipeRight() {
      if (!this.isTouchDevice) return;
      var classes = classnames(this.props.customClasses, 'navExpanded');
      this.setState({
        classes: classes
      });
    }
  }, {
    key: "handleSwipeLeft",
    value: function handleSwipeLeft() {
      if (!this.isTouchDevice) return;
      var classes = classnames(this.props.customClasses, 'navCollapsed');
      this.setState({
        classes: classes
      });
    }
  }, {
    key: "render",
    value: function render() {
      var classes = this.state.classes;
      return /*#__PURE__*/React.createElement(SwipeablePanel$1, {
        onSwipeRight: this.handleSwipeRight,
        onSwipeLeft: this.handleSwipeLeft
      }, /*#__PURE__*/React.createElement("nav", {
        className: classes
      }, this.props.children));
    }
  }]);
}(React.Component);

/*
 * Snap.js - This version of snap has specific code for the SidePanel, it is not the original snap.js
 * 
 * 
 * Copyright 2013, Jacob Kelley - http://jakiestfu.com/
 * Released under the MIT Licence
 * http://opensource.org/licenses/MIT
 *
 * Github:  http://github.com/jakiestfu/Snap.js/
 * Version: 1.9.3
 * 
 */
/*jslint browser: true*/
/*global define, module, ender*/
var snapModule = {};
(function (win, doc) {

  var Snap = Snap || function (userOpts) {
    var settings = {
        element: null,
        bottomElement: null,
        dragger: null,
        disable: 'none',
        addBodyClasses: true,
        hyperextensible: true,
        resistance: 0.5,
        flickThreshold: 50,
        transitionSpeed: 0.3,
        easing: 'ease',
        maxPosition: 266,
        minPosition: -266,
        tapToClose: true,
        touchToDrag: true,
        slideIntent: 40,
        // degrees
        minDragDistance: 5,
        adjustContentWidth: true // adjust main content panel width when side panel is open
      },
      cache = {
        simpleStates: {
          opening: null,
          towards: null,
          hyperExtending: null,
          halfway: null,
          flick: null,
          translation: {
            absolute: 0,
            relative: 0,
            sinceDirectionChange: 0,
            percentage: 0
          }
        }
      },
      eventList = {},
      utils = {
        hasTouch: 'ontouchstart' in doc.documentElement || win.navigator.msPointerEnabled,
        eventType: function eventType(action) {
          var eventTypes = {
            down: utils.hasTouch ? 'touchstart' : 'mousedown',
            move: utils.hasTouch ? 'touchmove' : 'mousemove',
            up: utils.hasTouch ? 'touchend' : 'mouseup',
            out: utils.hasTouch ? 'touchcancel' : 'mouseout'
          };
          return eventTypes[action];
        },
        page: function page(t, e) {
          return utils.hasTouch && e.touches.length && e.touches[0] ? e.touches[0]['page' + t] : e['page' + t];
        },
        klass: {
          has: function has(el, name) {
            return el.className.indexOf(name) !== -1;
          },
          add: function add(el, name) {
            if (!utils.klass.has(el, name) && settings.addBodyClasses) {
              el.className += " " + name;
            }
          },
          remove: function remove(el, name) {
            if (settings.addBodyClasses) {
              el.className = el.className.replace(name, "").replace(/^\s+|\s+$/g, '');
            }
          }
        },
        dispatchEvent: function dispatchEvent(type) {
          if (typeof eventList[type] === 'function') {
            return eventList[type].call();
          }
        },
        vendor: function vendor() {
          var tmp = doc.createElement("div"),
            prefixes = 'webkit Moz O ms'.split(' '),
            i;
          for (i in prefixes) {
            if (typeof tmp.style[prefixes[i] + 'Transition'] !== 'undefined') {
              return prefixes[i];
            }
          }
        },
        transitionCallback: function transitionCallback() {
          return cache.vendor === 'Moz' || cache.vendor === 'ms' ? 'transitionend' : cache.vendor + 'TransitionEnd';
        },
        canTransform: function canTransform() {
          return typeof settings.element.style[cache.vendor + 'Transform'] !== 'undefined';
        },
        deepExtend: function deepExtend(destination, source) {
          var property;
          for (property in source) {
            if (source[property] && source[property].constructor && source[property].constructor === Object) {
              destination[property] = destination[property] || {};
              utils.deepExtend(destination[property], source[property]);
            } else {
              destination[property] = source[property];
            }
          }
          return destination;
        },
        angleOfDrag: function angleOfDrag(x, y) {
          var degrees, theta;
          // Calc Theta
          theta = Math.atan2(-(cache.startDragY - y), cache.startDragX - x);
          if (theta < 0) {
            theta += 2 * Math.PI;
          }
          // Calc Degrees
          degrees = Math.floor(theta * (180 / Math.PI) - 180);
          if (degrees < 0 && degrees > -180) {
            degrees = 360 - Math.abs(degrees);
          }
          return Math.abs(degrees);
        },
        events: {
          addEvent: function addEvent(element, eventName, func) {
            if (element.addEventListener) {
              return element.addEventListener(eventName, func, false);
            } else if (element.attachEvent) {
              return element.attachEvent("on" + eventName, func);
            }
          },
          removeEvent: function addEvent(element, eventName, func) {
            if (element.addEventListener) {
              return element.removeEventListener(eventName, func, false);
            } else if (element.attachEvent) {
              return element.detachEvent("on" + eventName, func);
            }
          },
          prevent: function prevent(e) {
            if (e.preventDefault) {
              e.preventDefault();
            } else {
              e.returnValue = false;
            }
          }
        },
        parentUntil: function parentUntil(el, attr) {
          var isStr = typeof attr === 'string';
          while (el.parentNode) {
            if (isStr && el.getAttribute && el.getAttribute(attr)) {
              return el;
            } else if (!isStr && el === attr) {
              return el;
            }
            el = el.parentNode;
          }
          return null;
        }
      },
      action = {
        translate: {
          get: {
            matrix: function matrix(index) {
              if (!utils.canTransform()) {
                return parseInt(settings.element.style.left, 10);
              } else {
                var matrix = win.getComputedStyle(settings.element)[cache.vendor + 'Transform'].match(/\((.*)\)/),
                  ieOffset = 8;
                if (matrix) {
                  matrix = matrix[1].split(',');
                  if (matrix.length === 16) {
                    index += ieOffset;
                  }
                  return parseInt(matrix[index], 10);
                }
                return 0;
              }
            }
          },
          easeCallback: function easeCallback() {
            settings.element.style[cache.vendor + 'Transition'] = '';
            if (settings.bottomElement) {
              settings.bottomElement.style[cache.vendor + 'Transition'] = '';
            }
            cache.translation = action.translate.get.matrix(4);
            cache.easing = false;
            clearInterval(cache.animatingInterval);
            if (cache.easingTo === 0) {
              utils.klass.remove(doc.body, 'snapjs-right');
              utils.klass.remove(doc.body, 'snapjs-left');
            }
            utils.dispatchEvent('animated');
            utils.events.removeEvent(settings.element, utils.transitionCallback(), action.translate.easeCallback);
          },
          easeTo: function easeTo(n) {
            if (!utils.canTransform()) {
              cache.translation = n;
              action.translate.x(n);
            } else {
              cache.easing = true;
              cache.easingTo = n;
              settings.element.style[cache.vendor + 'Transition'] = 'all ' + settings.transitionSpeed + 's ' + settings.easing;
              if (settings.bottomElement) {
                settings.bottomElement.style[cache.vendor + 'Transition'] = 'all ' + settings.transitionSpeed + 's ' + settings.easing;
              }
              cache.animatingInterval = setInterval(function () {
                utils.dispatchEvent('animating');
              }, 1);
              utils.events.addEvent(settings.element, utils.transitionCallback(), action.translate.easeCallback);
              action.translate.x(n);
            }
            if (n === 0) {
              settings.element.style[cache.vendor + 'Transform'] = '';
              if (settings.bottomElement) {
                settings.bottomElement.style[cache.vendor + 'Transform'] = '';
              }
            }
            action.translate.adjustContentWidth(n);
          },
          // New BottomPanel animation support; jl 05/08/2019
          easeUp: function easeUp(open) {
            cache.easing = true;
            cache.easingUp = true;
            settings.element.style[cache.vendor + 'Transition'] = 'all ' + settings.transitionSpeed + 's ' + settings.easing;
            cache.animatingInterval = setInterval(function () {
              utils.dispatchEvent('animating');
            }, 1);
            utils.events.addEvent(settings.element, utils.transitionCallback(), action.translate.easeCallback);
            if (open) {
              var elementBottomDimension = settings.elementBottomDimension ? settings.elementBottomDimension : 350;
              settings.element.style.bottom = elementBottomDimension;
            } else {
              settings.element.style.bottom = 0;
            }
          },
          adjustContentWidth: function adjustContentWidth(n) {
            if (!settings.adjustContentWidth) {
              return;
            } else {
              var el = settings.element,
                bottomEl = settings.bottomElement;
              if (n === 0) {
                el.style.width = win.innerWidth; // assume content pane is full width!
                el.style.left = 0;
                if (bottomEl) {
                  bottomEl.style.width = win.innerWidth; // assume content pane is full width!
                  bottomEl.style.left = 0;
                }
              } else if (n > 0 && el.clientWidth > 680) {
                el.style.left = 0; // In case right panel was open
                el.style.width = el.clientWidth - n;
                if (bottomEl) {
                  bottomEl.style.left = 0; // In case right panel was open
                  bottomEl.style.width = bottomEl.clientWidth - n;
                }
              } else if (n < 0 && el.clientWidth > 680) {
                // In this case, the left is already translated so it needs to be offset back.
                el.style.width = el.clientWidth + n;
                el.style.left = -n;
                if (bottomEl) {
                  bottomEl.style.width = bottomEl.clientWidth + n;
                  bottomEl.style.left = -n;
                }
              }
            }
          },
          x: function x(n) {
            if (settings.disable === 'left' && n > 0 || settings.disable === 'right' && n < 0) {
              return;
            }
            if (!settings.hyperextensible) {
              if (n === settings.maxPosition || n > settings.maxPosition) {
                n = settings.maxPosition;
              } else if (n === settings.minPosition || n < settings.minPosition) {
                n = settings.minPosition;
              }
            }
            n = parseInt(n, 10);
            if (isNaN(n)) {
              n = 0;
            }
            if (utils.canTransform()) {
              var theTranslate = 'translate3d(' + n + 'px, 0,0)';
              settings.element.style[cache.vendor + 'Transform'] = theTranslate;
              if (settings.bottomElement) {
                settings.bottomElement.style[cache.vendor + 'Transform'] = theTranslate;
              }
            } else {
              settings.element.style.width = (win.innerWidth || doc.documentElement.clientWidth) + 'px';
              settings.element.style.left = n + 'px';
              settings.element.style.right = '';
            }
          }
        },
        drag: {
          listen: function listen() {
            cache.translation = 0;
            cache.easing = false;
            utils.events.addEvent(settings.element, utils.eventType('down'), action.drag.startDrag);
            utils.events.addEvent(settings.element, utils.eventType('move'), action.drag.dragging);
            utils.events.addEvent(settings.element, utils.eventType('up'), action.drag.endDrag);
          },
          stopListening: function stopListening() {
            utils.events.removeEvent(settings.element, utils.eventType('down'), action.drag.startDrag);
            utils.events.removeEvent(settings.element, utils.eventType('move'), action.drag.dragging);
            utils.events.removeEvent(settings.element, utils.eventType('up'), action.drag.endDrag);
          },
          startDrag: function startDrag(e) {
            // No drag on ignored elements
            var target = e.target ? e.target : e.srcElement,
              ignoreParent = utils.parentUntil(target, 'data-snap-ignore');
            if (ignoreParent) {
              utils.dispatchEvent('ignore');
              return;
            }
            if (settings.dragger) {
              var dragParent = utils.parentUntil(target, settings.dragger);

              // Only use dragger if we're in a closed state
              if (!dragParent && cache.translation !== settings.minPosition && cache.translation !== settings.maxPosition) {
                return;
              }
            }
            utils.dispatchEvent('start');
            settings.element.style[cache.vendor + 'Transition'] = '';
            cache.isDragging = true;
            cache.hasIntent = null;
            cache.intentChecked = false;
            cache.startDragX = utils.page('X', e);
            cache.startDragY = utils.page('Y', e);
            cache.dragWatchers = {
              current: 0,
              last: 0,
              hold: 0,
              state: ''
            };
            cache.simpleStates = {
              opening: null,
              towards: null,
              hyperExtending: null,
              halfway: null,
              flick: null,
              translation: {
                absolute: 0,
                relative: 0,
                sinceDirectionChange: 0,
                percentage: 0
              }
            };
          },
          dragging: function dragging(e) {
            if (cache.isDragging && settings.touchToDrag) {
              var thePageX = utils.page('X', e),
                thePageY = utils.page('Y', e),
                translated = cache.translation,
                absoluteTranslation = action.translate.get.matrix(4),
                whileDragX = thePageX - cache.startDragX,
                openingLeft = absoluteTranslation > 0,
                translateTo = whileDragX,
                diff;

              // Shown no intent already
              if (cache.intentChecked && !cache.hasIntent) {
                return;
              }
              if (settings.addBodyClasses) {
                if (absoluteTranslation > 0) {
                  utils.klass.add(doc.body, 'snapjs-left');
                  utils.klass.remove(doc.body, 'snapjs-right');
                } else if (absoluteTranslation < 0) {
                  utils.klass.add(doc.body, 'snapjs-right');
                  utils.klass.remove(doc.body, 'snapjs-left');
                }
              }
              if (cache.hasIntent === false || cache.hasIntent === null) {
                var deg = utils.angleOfDrag(thePageX, thePageY),
                  inRightRange = deg >= 0 && deg <= settings.slideIntent || deg <= 360 && deg > 360 - settings.slideIntent,
                  inLeftRange = deg >= 180 && deg <= 180 + settings.slideIntent || deg <= 180 && deg >= 180 - settings.slideIntent;
                if (!inLeftRange && !inRightRange) {
                  cache.hasIntent = false;
                } else {
                  cache.hasIntent = true;
                }
                cache.intentChecked = true;
              }
              if (settings.minDragDistance >= Math.abs(thePageX - cache.startDragX) ||
              // Has user met minimum drag distance?
              cache.hasIntent === false) {
                return;
              }
              utils.events.prevent(e);
              utils.dispatchEvent('drag');
              cache.dragWatchers.current = thePageX;
              // Determine which direction we are going
              if (cache.dragWatchers.last > thePageX) {
                if (cache.dragWatchers.state !== 'left') {
                  cache.dragWatchers.state = 'left';
                  cache.dragWatchers.hold = thePageX;
                }
                cache.dragWatchers.last = thePageX;
              } else if (cache.dragWatchers.last < thePageX) {
                if (cache.dragWatchers.state !== 'right') {
                  cache.dragWatchers.state = 'right';
                  cache.dragWatchers.hold = thePageX;
                }
                cache.dragWatchers.last = thePageX;
              }
              if (openingLeft) {
                // Pulling too far to the right
                if (settings.maxPosition < absoluteTranslation) {
                  diff = (absoluteTranslation - settings.maxPosition) * settings.resistance;
                  translateTo = whileDragX - diff;
                }
                cache.simpleStates = {
                  opening: 'left',
                  towards: cache.dragWatchers.state,
                  hyperExtending: settings.maxPosition < absoluteTranslation,
                  halfway: absoluteTranslation > settings.maxPosition / 2,
                  flick: Math.abs(cache.dragWatchers.current - cache.dragWatchers.hold) > settings.flickThreshold,
                  translation: {
                    absolute: absoluteTranslation,
                    relative: whileDragX,
                    sinceDirectionChange: cache.dragWatchers.current - cache.dragWatchers.hold,
                    percentage: absoluteTranslation / settings.maxPosition * 100
                  }
                };
              } else {
                // Pulling too far to the left
                if (settings.minPosition > absoluteTranslation) {
                  diff = (absoluteTranslation - settings.minPosition) * settings.resistance;
                  translateTo = whileDragX - diff;
                }
                cache.simpleStates = {
                  opening: 'right',
                  towards: cache.dragWatchers.state,
                  hyperExtending: settings.minPosition > absoluteTranslation,
                  halfway: absoluteTranslation < settings.minPosition / 2,
                  flick: Math.abs(cache.dragWatchers.current - cache.dragWatchers.hold) > settings.flickThreshold,
                  translation: {
                    absolute: absoluteTranslation,
                    relative: whileDragX,
                    sinceDirectionChange: cache.dragWatchers.current - cache.dragWatchers.hold,
                    percentage: absoluteTranslation / settings.minPosition * 100
                  }
                };
              }
              action.translate.x(translateTo + translated);
            }
          },
          endDrag: function endDrag(e) {
            if (cache.isDragging) {
              utils.dispatchEvent('end');
              var translated = action.translate.get.matrix(4);

              // Tap Close
              if (cache.dragWatchers.current === 0 && translated !== 0 && settings.tapToClose) {
                utils.dispatchEvent('close');
                utils.events.prevent(e);
                action.translate.easeTo(0);
                cache.isDragging = false;
                cache.startDragX = 0;
                return;
              }

              // Revealing Left
              if (cache.simpleStates.opening === 'left') {
                // Halfway, Flicking, or Too Far Out
                if (cache.simpleStates.halfway || cache.simpleStates.hyperExtending || cache.simpleStates.flick) {
                  if (cache.simpleStates.flick && cache.simpleStates.towards === 'left') {
                    // Flicking Closed
                    action.translate.easeTo(0);
                  } else if (cache.simpleStates.flick && cache.simpleStates.towards === 'right' ||
                  // Flicking Open OR
                  cache.simpleStates.halfway || cache.simpleStates.hyperExtending // At least halfway open OR hyperextending
                  ) {
                    action.translate.easeTo(settings.maxPosition); // Open Left
                  }
                } else {
                  action.translate.easeTo(0); // Close Left
                }
                // Revealing Right
              } else if (cache.simpleStates.opening === 'right') {
                // Halfway, Flicking, or Too Far Out
                if (cache.simpleStates.halfway || cache.simpleStates.hyperExtending || cache.simpleStates.flick) {
                  if (cache.simpleStates.flick && cache.simpleStates.towards === 'right') {
                    // Flicking Closed
                    action.translate.easeTo(0);
                  } else if (cache.simpleStates.flick && cache.simpleStates.towards === 'left' ||
                  // Flicking Open OR
                  cache.simpleStates.halfway || cache.simpleStates.hyperExtending // At least halfway open OR hyperextending
                  ) {
                    action.translate.easeTo(settings.minPosition); // Open Right
                  }
                } else {
                  action.translate.easeTo(0); // Close Right
                }
              }
              cache.isDragging = false;
              cache.startDragX = utils.page('X', e);
            }
          }
        }
      },
      init = function init(opts) {
        if (opts.element) {
          utils.deepExtend(settings, opts);
          cache.vendor = utils.vendor();
          action.drag.listen();
        }
      };
    /*
     * Public
     */
    this.open = function (side) {
      utils.dispatchEvent('open');
      utils.klass.remove(doc.body, 'snapjs-expand-left');
      utils.klass.remove(doc.body, 'snapjs-expand-right');
      if (side === 'left') {
        cache.simpleStates.opening = 'left';
        cache.simpleStates.towards = 'right';
        utils.klass.add(doc.body, 'snapjs-left');
        utils.klass.remove(doc.body, 'snapjs-right');
        action.translate.easeTo(settings.maxPosition);
      } else if (side === 'right') {
        cache.simpleStates.opening = 'right';
        cache.simpleStates.towards = 'left';
        utils.klass.remove(doc.body, 'snapjs-left');
        utils.klass.add(doc.body, 'snapjs-right');
        action.translate.easeTo(settings.minPosition);
      } else if (side === 'bottom') {
        cache.simpleStates.opening = 'bottom';
        utils.klass.add(doc.body, 'snapjs-bottom');
        action.translate.easeUp(true);
      }
    };
    this.close = function () {
      utils.dispatchEvent('close');
      action.translate.easeTo(0);
    };
    this.closeBottom = function () {
      utils.dispatchEvent('close');
      action.translate.easeUp(false);
    };
    this.expand = function (side) {
      var to = win.innerWidth || doc.documentElement.clientWidth;
      if (side === 'left') {
        utils.dispatchEvent('expandLeft');
        utils.klass.add(doc.body, 'snapjs-expand-left');
        utils.klass.remove(doc.body, 'snapjs-expand-right');
      } else {
        utils.dispatchEvent('expandRight');
        utils.klass.add(doc.body, 'snapjs-expand-right');
        utils.klass.remove(doc.body, 'snapjs-expand-left');
        to *= -1;
      }
      action.translate.easeTo(to);
    };
    this.on = function (evt, fn) {
      eventList[evt] = fn;
      return this;
    };
    this.off = function (evt) {
      if (eventList[evt]) {
        eventList[evt] = false;
      }
    };
    this.enable = function () {
      utils.dispatchEvent('enable');
      action.drag.listen();
    };
    this.disable = function () {
      utils.dispatchEvent('disable');
      action.drag.stopListening();
    };
    this.settings = function (opts) {
      utils.deepExtend(settings, opts);
    };
    this.state = function () {
      // Now supports multiple panel and bottom open; jl 05/08/2019
      var state,
        fromLeft = action.translate.get.matrix(4);
      if (fromLeft === settings.maxPosition) {
        state = 'left';
      } else if (fromLeft === settings.minPosition) {
        state = 'right';
      } else {
        state = 'closed';
      }
      if (parseInt(settings.element.style.bottom)) {
        state = state + " bottom";
      }
      return {
        state: state,
        info: cache.simpleStates
      };
    };
    init(userOpts);
  };
  if (typeof module !== 'undefined' && module.exports) {
    module.exports = Snap;
  }
  if (typeof ender === 'undefined') {
    this.Snap = Snap;
  }
  if (typeof define === "function" && define.amd) {
    define("snap", [], function () {
      return Snap;
    });
  }
}).call(undefined || snapModule, window, document);
var Snap = snapModule.Snap;

var IfefSidePanelContainer = /*#__PURE__*/function (_React$Component) {
  function IfefSidePanelContainer(props) {
    var _this;
    _classCallCheck(this, IfefSidePanelContainer);
    _this = _callSuper(this, IfefSidePanelContainer, [props]);
    _this.state = {
      elementBottomDimension: _.get(props, 'settings.elementBottomDimension')
    };
    return _this;
  }
  _inherits(IfefSidePanelContainer, _React$Component);
  return _createClass(IfefSidePanelContainer, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      var prevElementBottomDimension = _.get(prevProps, 'settings.elementBottomDimension');
      var curElementBottomDimension = _.get(this, 'props.settings.elementBottomDimension');
      if (curElementBottomDimension !== prevElementBottomDimension) {
        var snapper = this.context.ifefSnapper;
        snapper.settings({
          elementBottomDimension: curElementBottomDimension
        });
        snapper.open();
        document.getElementById('SidePanelContent').style.bottom = curElementBottomDimension;
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var sideMenuContent = document.getElementById('SidePanelContent');
      var bottomPanel = document.getElementById('BottomPanel');
      var snapper = new Snap(_objectSpread2({
        element: sideMenuContent,
        bottomElement: bottomPanel
      }, this.props.settings));
      if (typeof snapper.toggle === 'undefined') {
        // add a toggle method if it doesn't exist yet (in some future version)
        snapper.toggle = function (direction) {
          // Now needs to support bottom as a (somewhat) special case
          if (direction === "bottom") {
            if (this.state().state.includes("bottom")) {
              this.closeBottom();
            } else {
              this.open("bottom");
            }
          } else if (this.state().state.includes(direction)) {
            this.close();
          } else {
            this.open(direction);
          }
        };
      }
      this.context.ifefSetSnapper(snapper);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.context.ifefSetSnapper(null);
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement("div", null, this.props.children);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var nextElementBottomDimension = _.get(nextProps, 'settings.elementBottomDimension');
      var curElementBottomDimension = prevState.elementBottomDimension;
      if (nextElementBottomDimension && nextElementBottomDimension !== curElementBottomDimension) {
        return {
          elementBottomDimension: nextElementBottomDimension
        };
      } else {
        return null;
      }
    }
  }]);
}(React.Component);
IfefSidePanelContainer.contextTypes = {
  ifefSnapper: object,
  ifefSetSnapper: func
};
IfefSidePanelContainer.propTypes = {
  settings: object
};
IfefSidePanelContainer.defaultProps = {
  settings: {}
};

var css_248z$2 = ".asf-panel-bottom {\n  position: sticky !important;\n  z-index: 1;\n}";
styleInject(css_248z$2);

// There is only one BottomPanel, which we make work like the Right/Left drawers
// We provide an id so apps can find it to load app-specific content in it.
// This may not be needed as we could look up by class.  ToDo: review.  jl 05/07/2019
var BottomPanel = /*#__PURE__*/function (_React$Component) {
  function BottomPanel(props) {
    var _this;
    _classCallCheck(this, BottomPanel);
    _this = _callSuper(this, BottomPanel, [props]);
    _this.clientHeight = document.documentElement.clientHeight;
    return _this;
  }
  _inherits(BottomPanel, _React$Component);
  return _createClass(BottomPanel, [{
    key: "onDrag",
    value: function onDrag(evt) {
      var pageY = evt.pageY;
      if (pageY !== 0) {
        this.bottomPanelStyle.height = this.clientHeight - pageY;
        this.sidePanelStyle.height = pageY;
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this.sidePanelStyle = document.getElementById('SidePanelContent').style;
      this.bottomPanelStyle = document.getElementById('BottomPanel').style;
    }
  }, {
    key: "render",
    value: function render() {
      var display = this.props.hideOnLoad ? 'none' : 'block';
      return /*#__PURE__*/React.createElement("div", {
        className: "asf-panel snap-drawer-bottom asf-panel-bottom",
        id: "BottomPanel",
        style: {
          'height': this.props.height,
          'display': display
        }
      }, this.props.children);
    }
  }]);
}(React.Component);

var HeaderBar = /*#__PURE__*/function (_React$Component) {
  function HeaderBar(props) {
    _classCallCheck(this, HeaderBar);
    return _callSuper(this, HeaderBar, [props]);
  }
  _inherits(HeaderBar, _React$Component);
  return _createClass(HeaderBar, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.context.ifefUpdateHasX && this.context.ifefUpdateHasX('ifefHasHeader', true);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.context.ifefUpdateHasX && this.context.ifefUpdateHasX('ifefHasHeader', false);
    }
  }, {
    key: "render",
    value: function render() {
      var classes = classnames(this.props.customClasses);
      return /*#__PURE__*/React.createElement("header", {
        className: classes
      }, this.props.children);
    }
  }]);
}(React.Component);
HeaderBar.propTypes = {
  customClasses: string
};
HeaderBar.defaultProps = {
  customClasses: ''
};
HeaderBar.contextTypes = {
  ifefUpdateHasX: func,
  ifefPlatform: object
};

var css_248z$3 = ".logo-wrapper {\n  display: inline-flex;\n  align-items: center;\n}\n\n.appName {\n  font-size: 25px;\n  font-weight: 500;\n  font-family: Inter, sans-serif;\n  margin-left: 25px;\n  color: var(--head-appname-color);\n}";
styleInject(css_248z$3);

var Logo = function Logo(_ref) {
  var appName = _ref.appName,
    children = _ref.children,
    homepage = _ref.homepage,
    contextProps = _ref.contextProps;
  console.log(contextProps);
  var _useState = useState(""),
    _useState2 = _slicedToArray(_useState, 2),
    imgSrc = _useState2[0],
    setImgSrc = _useState2[1];
  useEffect(function () {
    var getImgSrc = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(settings) {
        var _contextProps$selecte;
        var result, _imgSrc, _imgSrc2, _imgSrc3, _imgSrc4;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.n) {
            case 0:
              if (settings) {
                _context.n = 9;
                break;
              }
              if (!((_contextProps$selecte = contextProps.selectedItems.ipaConfig.referenceAppConfig) !== null && _contextProps$selecte !== void 0 && _contextProps$selecte.refApp)) {
                _context.n = 6;
                break;
              }
              _context.n = 1;
              return IafPassSvc.getConfigs();
            case 1:
              result = _context.v;
              if (!(result.themes.login === 'default')) {
                _context.n = 3;
                break;
              }
              _context.n = 2;
              return import('../twinit-white-12171104.js');
            case 2:
              _imgSrc = _context.v;
              setImgSrc(_imgSrc["default"]);
              _context.n = 5;
              break;
            case 3:
              if (!(result.themes.login === 'mirrana')) {
                _context.n = 5;
                break;
              }
              _context.n = 4;
              return import('../mirranaLogo-a606a2d1.js');
            case 4:
              _imgSrc2 = _context.v;
              setImgSrc(_imgSrc2["default"]);
            case 5:
              _context.n = 8;
              break;
            case 6:
              _context.n = 7;
              return import('../invicara-logo_white-bb7b6092.js');
            case 7:
              _imgSrc3 = _context.v;
              setImgSrc(_imgSrc3["default"]);
            case 8:
              _context.n = 12;
              break;
            case 9:
              if (!(imgSettings && imgSettings.url)) {
                _context.n = 10;
                break;
              }
              setImgSrc(imgSettings.url);
              _context.n = 12;
              break;
            case 10:
              if (!(imgSettings && imgSettings.filename)) {
                _context.n = 12;
                break;
              }
              _context.n = 11;
              return FileHelpers.getFileUrlForFilename(imgSettings.filename);
            case 11:
              _imgSrc4 = _context.v;
              setImgSrc(_imgSrc4);
            case 12:
              return _context.a(2);
          }
        }, _callee);
      }));
      return function getImgSrc(_x) {
        return _ref2.apply(this, arguments);
      };
    }();
    var imgSettings = contextProps.userConfig.settings && contextProps.userConfig.settings.appImage ? contextProps.userConfig.settings.appImage : null;
    getImgSrc(imgSettings);
  }, [contextProps]);
  return /*#__PURE__*/React.createElement("div", {
    id: "logo",
    className: "logo-wrapper"
  }, children ? children : /*#__PURE__*/React.createElement("a", {
    href: homepage
  }, /*#__PURE__*/React.createElement("img", {
    src: imgSrc
  })), /*#__PURE__*/React.createElement("span", {
    className: "appName"
  }, appName));
};

var img = "data:image/svg+xml,%3csvg id='Layer_1' data-name='Layer 1' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 800 800'%3e%3cdefs%3e%3cstyle%3e.cls-1%7bfill:white%3b%7d%3c/style%3e%3c/defs%3e%3cpath class='cls-1' d='M720%2c399.87%2c527.11%2c207l-64.3%2c64.3L548.54%2c357H248.48v85.73H548.54l-85.73%2c85.73%2c64.3%2c64.3Z'/%3e%3cpolygon class='cls-1' points='377.82 235.41 377.82 149.68 120 149.68 120 650.32 377.82 650.32 377.82 564.59 206.06 564.59 206.06 235.41 377.82 235.41'/%3e%3c/svg%3e";

var img$1 = "data:image/svg+xml,%3csvg id='Layer_1' data-name='Layer 1' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 800 800'%3e%3cdefs%3e%3cstyle%3e.cls-1%7bfill:white%3b%7d%3c/style%3e%3c/defs%3e%3ccircle class='cls-1' cx='400' cy='230.87' r='130.62'/%3e%3cpath class='cls-1' d='M658.59%2c561.71c-1.84-75.09-116.9-161-258.59-161s-256.75%2c85.93-258.59%2c161h0V700.25H658.64V561.71Z'/%3e%3c/svg%3e";

var css_248z$4 = ".always-flex {\n  display: flex !important;\n}\n\n#active-session-text {\n  display: flex;\n  justify-content: flex-end;\n  align-items: center;\n  height: 100%;\n}\n\n.titlebar-header {\n  z-index: 1;\n  box-shadow: none;\n}\n\n.session-dropdown {\n  float: right;\n  height: 100%;\n  display: flex;\n  align-items: center;\n}\n.session-dropdown .session-options {\n  position: absolute;\n  top: 80px;\n  right: 0;\n  visibility: hidden;\n  height: 1px;\n  width: 400px;\n  background-color: var(--head-menu-bkg-color);\n  transition: all 0.5s;\n  display: flex;\n  flex-direction: column;\n  box-shadow: -12px 15px 10px 0 rgba(0, 0, 0, 0.2);\n}\n.session-dropdown .session-options .session-item:nth-child(1) {\n  visibility: hidden;\n  transition: visibility 0.25s;\n}\n.session-dropdown .session-options .session-item:nth-child(2) {\n  visibility: hidden;\n  transition: visibility 0.2s;\n}\n.session-dropdown .session-options .session-item:nth-child(3) {\n  visibility: hidden;\n  transition: visibility 0.15s;\n}\n.session-dropdown .session-options .session-item:nth-child(4) {\n  visibility: hidden;\n  transition: visibility 0.1s;\n}\n.session-dropdown .session-options .session-item {\n  height: 60px;\n  width: 100%;\n  flex: 1;\n  display: flex;\n  padding: 15px;\n  font-size: 18px;\n  color: white;\n}\n.session-dropdown .session-options .session-item a {\n  display: flex;\n  align-items: center;\n  color: white;\n  width: 100%;\n  text-decoration: none;\n}\n.session-dropdown .session-options .session-item a:hover {\n  text-decoration: none;\n}\n.session-dropdown .session-options .session-item:hover {\n  background-color: var(--head-menu-hover-color);\n  transition: all 0.5s;\n}\n.session-dropdown .icofont-rounded-down {\n  transition: all 0.5s;\n}\n\n.session-dropdown:hover .icofont-rounded-down {\n  transform: rotate(180deg);\n}\n.session-dropdown:hover .session-options {\n  visibility: visible;\n  height: 300px;\n}\n.session-dropdown:hover .session-options .session-item {\n  visibility: visible;\n}";
styleInject(css_248z$4);

var css_248z$5 = ".ipa-icon-svg {\n  width: 42px;\n  height: 42px;\n  display: inline-block;\n  background-size: 42px;\n  transform: translateX(-7px);\n  background-repeat: no-repeat;\n}";
styleInject(css_248z$5);

var TitleBar = /*#__PURE__*/function (_React$Component) {
  function TitleBar() {
    _classCallCheck(this, TitleBar);
    return _callSuper(this, TitleBar, arguments);
  }
  _inherits(TitleBar, _React$Component);
  return _createClass(TitleBar, [{
    key: "render",
    value: function render() {
      var _version;
      var titleInfo = getTitleBarInfoFromProps('', this.props.contextProps);
      var _firstname = this.props.contextProps.user && this.props.contextProps.user._firstname;
      var _lastname = this.props.contextProps.user && this.props.contextProps.user._lastname;
      var switchProj = function switchProj(e) {
        e.preventDefault();
        titleInfo.switchProject();
      };
      var goToUserAccount = function goToUserAccount(e) {
        e.preventDefault();
        window.open(getPlatformPath('USER_ACCOUNT'));
      };
      return /*#__PURE__*/React.createElement(HeaderBar, {
        customClasses: "always-flex titlebar-header"
      }, /*#__PURE__*/React.createElement(Logo, {
        homepage: "#/",
        appName: this.props.ipaConfig.appName,
        contextProps: this.props.contextProps
      }), /*#__PURE__*/React.createElement("div", {
        id: "active-session"
      }, /*#__PURE__*/React.createElement("div", {
        id: "active-session-text"
      }, /*#__PURE__*/React.createElement("div", {
        className: 'session-dropdown'
      }, titleInfo.projectName, /*#__PURE__*/React.createElement("i", {
        className: 'icofont-rounded-down'
      }), /*#__PURE__*/React.createElement("div", {
        className: 'session-options'
      }, /*#__PURE__*/React.createElement(LinkedIcon, {
        customClass: 'session-item',
        clickHandler: switchProj,
        icon: 'icofont-refresh icofont-2x',
        linkText: 'Switch Project'
      }), /*#__PURE__*/React.createElement(LinkedIcon, {
        customClass: 'session-item',
        clickHandler: this.props.parent.props.userLogout,
        iconClasses: 'ipa-icon-svg',
        iconImg: img,
        linkText: 'Logout'
      }), /*#__PURE__*/React.createElement(LinkedIcon, {
        customClass: 'session-item',
        clickHandler: goToUserAccount,
        iconClasses: 'ipa-icon-svg',
        iconImg: img$1,
        linkText: _firstname + " " + _lastname
      }), /*#__PURE__*/React.createElement("div", {
        className: 'session-item'
      }, (_version = version) === null || _version === void 0 ? void 0 : _version.version))))));
    }
  }]);
}(React.Component);

var css_248z$6 = ".grouped-left-nav-bar .fas,\n.grouped-left-nav-bar .icofont,\n.grouped-left-nav-bar .icofont-2x,\n.grouped-left-nav-bar .icofont-3x {\n  color: var(--nav-icon-color);\n}\n.grouped-left-nav-bar .nav-group-li.active-group .fas,\n.grouped-left-nav-bar .nav-group-li.active-group .icofont,\n.grouped-left-nav-bar .nav-group-li.active-group .icofont-2x,\n.grouped-left-nav-bar .nav-group-li.active-group .icofont-3x {\n  color: var(--app-accent-color);\n}\n.grouped-left-nav-bar .scroll-overflowY {\n  overflow-y: auto !important;\n  height: 100%;\n}\n.grouped-left-nav-bar .scroll-overflowY::-webkit-scrollbar {\n  width: 7px;\n  height: 7px;\n}\n.grouped-left-nav-bar .scroll-overflowY::-webkit-scrollbar-track {\n  background: white;\n}\n.grouped-left-nav-bar .scroll-overflowY::-webkit-scrollbar-thumb {\n  background: #DCDCDC;\n  border-radius: 2rem;\n}\n.grouped-left-nav-bar .scroll-overflowY::-webkit-scrollbar-thumb:hover {\n  background: #B8B8B8;\n}\n.grouped-left-nav-bar .flex-container {\n  display: flex;\n  flex-direction: column;\n  height: calc(100% - 80px);\n  position: fixed;\n  width: 100%;\n  top: 80px;\n}\n.grouped-left-nav-bar .flex-content {\n  width: 100%;\n  background-color: white;\n}\n.grouped-left-nav-bar .has-left-nav {\n  margin-left: 80px;\n}\n.grouped-left-nav-bar .navCollapsed {\n  width: 80px;\n}\n.grouped-left-nav-bar .grouped-nav {\n  position: absolute;\n  display: flex;\n  visibility: hidden;\n  left: 80px;\n  width: 1px;\n  flex-direction: column;\n  height: 100%;\n  top: 0;\n  z-index: -1;\n  background-color: white;\n  box-shadow: 10px 0 10px 0 rgba(0, 0, 0, 0.2);\n  transition: all 0.5s;\n  overflow-y: auto;\n}\n.grouped-left-nav-bar .grouped-nav span.menu-item {\n  opacity: 0 !important;\n  transition: none;\n}\n.grouped-left-nav-bar .grouped-nav li {\n  transition: all 0.2s;\n  visibility: hidden;\n  height: 80px;\n  margin: 0 15px 20px;\n  border-radius: 15px;\n  box-shadow: -2px 3px 20px -5px rgba(0, 0, 0, 0.35);\n}\n.grouped-left-nav-bar .grouped-nav li span {\n  color: hsl(0, 0%, 50%);\n}\n.grouped-left-nav-bar .grouped-nav li .inv-icon-svg {\n  mask-position: 0px -5px;\n  -webkit-mask-position: -5px -5px;\n}\n.grouped-left-nav-bar .grouped-nav li .inv-icon-smartBuilding {\n  background-position-y: inherit;\n}\n.grouped-left-nav-bar .grouped-nav .group-header {\n  height: 150px;\n  display: flex;\n  justify-content: center;\n  flex-direction: column;\n  align-items: center;\n  visibility: hidden;\n  transition-delay: 0.2s;\n  margin-bottom: 10px;\n}\n.grouped-left-nav-bar .grouped-nav .group-header i {\n  mask-size: 64px;\n  -webkit-mask-size: 64px;\n  mask-position: center;\n  -webkit-mask-position: center;\n  width: 105px;\n  height: 80px;\n  margin-right: 0;\n}\n.grouped-left-nav-bar .grouped-nav .group-header .fas,\n.grouped-left-nav-bar .grouped-nav .group-header .icofont,\n.grouped-left-nav-bar .grouped-nav .group-header .icofont-2x,\n.grouped-left-nav-bar .grouped-nav .group-header .icofont-3x {\n  font-size: 5em;\n  width: auto;\n}\n.grouped-left-nav-bar .grouped-nav .group-header .group-name {\n  margin-top: 10px;\n  color: var(--app-accent-color);\n  font-size: 17px;\n  font-weight: bold;\n}\n.grouped-left-nav-bar .grouped-nav .group-header .inv-icon-smartBuilding {\n  background-size: 80px;\n}\n.grouped-left-nav-bar .grouped-nav .active-page {\n  border: 2px solid var(--app-accent-color);\n}\n.grouped-left-nav-bar .grouped-nav .active-page span {\n  color: var(--app-accent-color);\n}\n.grouped-left-nav-bar .grouped-nav .purple {\n  color: var(--app-accent-color);\n}\n.grouped-left-nav-bar .nav-group-li:hover .grouped-nav {\n  visibility: visible;\n  width: 300px;\n  transition: all 0.5s;\n  z-index: 99;\n}\n.grouped-left-nav-bar .nav-group-li:hover .grouped-nav li {\n  visibility: visible;\n}\n.grouped-left-nav-bar .nav-group-li:hover .grouped-nav .group-header {\n  visibility: visible;\n}\n.grouped-left-nav-bar .nav-group-li:hover .grouped-nav span.menu-item {\n  transition: all 0.5s;\n  transition-delay: 0.2s;\n  opacity: 1 !important;\n}\n\nnav.grouped-left-nav-bar {\n  background-color: var(--nav-bkg-color);\n  width: 80px;\n  height: 100%;\n  display: flex;\n  flex-direction: column;\n  box-shadow: 10px 0 10px 0 rgba(0, 0, 0, 0.2);\n  position: absolute;\n  z-index: 99;\n}\nnav.grouped-left-nav-bar .active-group {\n  background-color: var(--nav-activegrp-bkg-color);\n  border-left: 10px solid var(--app-accent-color) !important;\n}\nnav.grouped-left-nav-bar li {\n  padding: 25px 25px 25px 15px;\n}\nnav.grouped-left-nav-bar a {\n  color: white;\n  text-decoration: none;\n}\nnav.grouped-left-nav-bar ul > li > a {\n  font-size: 16px;\n  position: relative;\n  display: block;\n  text-decoration: none;\n}\nnav.grouped-left-nav-bar .main-nav {\n  overflow-x: hidden;\n  overflow-y: scroll;\n  width: 100%;\n  flex: 1 0 auto;\n}\nnav.grouped-left-nav-bar .main-nav li {\n  display: block;\n  border-left: 10px solid rgba(0, 0, 0, 0);\n}\nnav.grouped-left-nav-bar .main-nav .main-nav .icofont-2x {\n  margin-right: 15px;\n}";
styleInject(css_248z$6);

var css_248z$7 = ".main-nav .icofont-2x {\n  margin-right: 15px;\n}\n.main-nav .inv-icon-svg {\n  margin-right: 15px;\n}\n.main-nav .fa-2x {\n  margin-right: 15px;\n}\n.main-nav .nav-li {\n  position: relative;\n}";
styleInject(css_248z$7);

var css_248z$8 = ".model-viewer-toolbar {\n  position: absolute;\n  border-radius: 30px;\n  top: 0;\n  right: 5px;\n}\n\n.model-viewer-toolbar div {\n  display: inline-block;\n  width: 30px;\n  height: 30px;\n  margin: 5px;\n  font-weight: bold;\n  border-radius: 50%;\n  cursor: pointer;\n}\n\n.model-viewer-splitter {\n  cursor: row-resize !important;\n}\n\n.model-viewer-splitter i {\n  padding-top: 6px;\n  padding-left: 12px;\n}\n\n.model-viewer-full-screen i {\n  padding-top: 6px;\n  padding-left: 12px;\n}\n\n.model-viewer-default-size i {\n  padding-top: 3px;\n  padding-left: 8px;\n}\n\n.model-viewer-close {\n  padding-top: 6px;\n  padding-left: 8px;\n}\n\n.model-viewer-close::before {\n  content: \"X\";\n}\n\n.show-model-viewer {\n  position: absolute;\n  bottom: 10px;\n  right: 10px;\n  width: 30px;\n  height: 30px;\n  background-color: lightgray;\n  border-radius: 50%;\n  font-weight: bold;\n  padding: 5px;\n  cursor: pointer;\n}\n\n.snapjs-bottom .show-model-viewer {\n  display: none;\n}\n\n.show-model-viewer::after {\n  content: \"3D\";\n}\n\n.no-sidebar .has-left-nav {\n  margin-left: 0;\n}\n\n.no-titlebar #SidePanelContent {\n  height: 100%;\n  top: 0;\n}";
styleInject(css_248z$8);

var Layout = /*#__PURE__*/function (_React$Component) {
  function Layout(props) {
    var _this;
    _classCallCheck(this, Layout);
    _this = _callSuper(this, Layout, [props]);
    _this._getIcon = function (icon, customClass) {
      var iconClass = icon;
      iconClass += icon.startsWith('icofont') ? ' icofont-2x' : '';
      iconClass += customClass ? ' ' + customClass : '';
      return /*#__PURE__*/React.createElement("i", {
        className: iconClass
      });
    };
    _this.state = {
      bottomPanelHeight: props.contextProps.bottomPanelHeight
    };
    return _this;
  }
  _inherits(Layout, _React$Component);
  return _createClass(Layout, [{
    key: "_mouseDown",
    value: function _mouseDown(e) {
      this.beginDrag = e.screenY;
      this.originalHeight = this.state.bottomPanelHeight;
    }
  }, {
    key: "_mouseUp",
    value: function _mouseUp() {
      this.beginDrag = undefined;
    }
  }, {
    key: "_mouseMove",
    value: function _mouseMove(e) {
      if (this.beginDrag) {
        var delta = this.beginDrag - e.screenY;
        if (this.originalHeight + delta <= window.innerHeight - 80 && this.originalHeight + delta >= 80) this.setState({
          bottomPanelHeight: this.originalHeight + delta
        });
      }
    }
  }, {
    key: "_fullScreen",
    value: function _fullScreen() {
      this.setState({
        bottomPanelHeight: window.innerHeight - 80
      });
    }
  }, {
    key: "_defaultScreen",
    value: function _defaultScreen() {
      this.setState({
        bottomPanelHeight: this.props.contextProps.defaultBottomPanelHeight
      });
    }
  }, {
    key: "isActivePage",
    value: function isActivePage(path) {
      var loc = window.location.hash && window.location.hash.substr(1);
      loc = loc.split('?')[0];
      var pageRegex = new RegExp(path + '(?:/|$)');
      return pageRegex.test(loc);
    }
  }, {
    key: "getNavItem",
    value: function getNavItem(page, activeClass, iconClass) {
      if (page.dontindex) return null;
      var loc = window.location.hash && window.location.hash.substr(1);
      loc = loc.split('?')[0];
      var pageRegex = new RegExp(page.path + '(?:/|$)');
      return /*#__PURE__*/React.createElement("li", {
        className: clsx('nav-li', pageRegex.test(loc) ? activeClass : ''),
        key: page.path ? page.path : page.key
      }, /*#__PURE__*/React.createElement(Item, {
        link: page.path,
        key: page.path ? page.path : page.key,
        customClasses: page.customClasses,
        onClick: page.onClick,
        item: false
      }, this._getIcon(page.icon, iconClass), /*#__PURE__*/React.createElement("span", {
        className: "menu-item"
      }, " ", page.title)));
    }
  }, {
    key: "getGroupedNavItem",
    value: function getGroupedNavItem(group) {
      var _this2 = this;
      var isActiveGroup = group.items.some(function (p) {
        return _this2.isActivePage(p.path);
      });
      var items = group.items.map(function (p) {
        return _this2.getNavItem(p, 'active-page', 'purple active');
      });
      var groupClasses = classnames({
        'nav-group-li': true,
        'active-group': isActiveGroup
      });
      return /*#__PURE__*/React.createElement("li", {
        className: groupClasses,
        key: group.groupName
      }, /*#__PURE__*/React.createElement(Item, {
        item: false
      }, this._getIcon(group.icon, isActiveGroup ? 'purple active' : undefined)), /*#__PURE__*/React.createElement(FlexLeftNav, {
        customClasses: "grouped-nav"
      }, /*#__PURE__*/React.createElement("div", {
        className: 'group-header'
      }, this._getIcon(group.icon, 'purple active'), /*#__PURE__*/React.createElement("div", {
        className: 'group-name'
      }, group.groupName)), /*#__PURE__*/React.createElement("ul", null, items)));
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this,
        _this$props$modal,
        _this$props$modal2;
      var contextProps = this.props.contextProps;
      var items = this.props.pageGroups.length > 0 ? this.props.pageGroups.map(function (g) {
        return _this3.getGroupedNavItem(g);
      }) : this.props.pageList.map(function (p) {
        return _this3.getNavItem(p, 'main-nav-active');
      });
      var sidePanelSettings = {
        tapToClose: false,
        elementBottomDimension: this.state.bottomPanelHeight
      };
      var bottomPanelToolbar = /*#__PURE__*/React.createElement("div", {
        style: {
          padding: '5px'
        }
      }, /*#__PURE__*/React.createElement("div", {
        className: "model-viewer-toolbar"
      }, /*#__PURE__*/React.createElement("div", {
        className: "model-viewer-default-size",
        onClick: this._defaultScreen.bind(this)
      }, /*#__PURE__*/React.createElement("i", {
        className: "fas fa-window-minimize"
      })), /*#__PURE__*/React.createElement("div", {
        className: "model-viewer-full-screen",
        onClick: this._fullScreen.bind(this)
      }, /*#__PURE__*/React.createElement("i", {
        className: "fas fa-window-maximize"
      })), /*#__PURE__*/React.createElement("div", {
        className: "model-viewer-splitter",
        onMouseDown: this._mouseDown.bind(this)
      }, /*#__PURE__*/React.createElement("i", {
        className: "fas fa-arrows-alt-v"
      })), /*#__PURE__*/React.createElement("div", {
        className: "model-viewer-close",
        onClick: contextProps.actions.toggleBottomPanel
      })));
      var showTitle = true;
      var showSidebar = true;
      var settings = this.props.contextProps.userConfig.settings;
      var cn = "";
      if (settings && settings.noSideBar === true) {
        cn += " no-sidebar";
        showSidebar = false;
      }
      if (settings && settings.noTitleBar === true) {
        cn += " no-titlebar";
        showTitle = false;
      }
      return /*#__PURE__*/React.createElement("div", {
        className: cn,
        onMouseMove: this._mouseMove.bind(this),
        onMouseUp: this._mouseUp.bind(this)
      }, showTitle && /*#__PURE__*/React.createElement(TitleBar, {
        contextProps: this.props.contextProps,
        parent: this,
        ipaConfig: this.props.ipaConfig
      }), /*#__PURE__*/React.createElement(IfefSidePanelContainer, _extends({
        settings: sidePanelSettings
      }, this.props), /*#__PURE__*/React.createElement(FlexContainer, this.props, showSidebar && /*#__PURE__*/React.createElement(FlexLeftNavs, {
        customClasses: this.props.pageGroups.length > 0 ? "grouped-left-nav-bar" : ''
      }, /*#__PURE__*/React.createElement(FlexLeftNav, {
        customClasses: "main-nav"
      }, /*#__PURE__*/React.createElement("ul", null, items))), /*#__PURE__*/React.createElement(FlexContent, _extends({}, this.props, {
        location: this.context.location,
        customClasses: "has-left-nav"
      }), this.props.children, /*#__PURE__*/React.createElement(BottomPanel, {
        height: this.state.bottomPanelHeight,
        hideOnLoad: true
      }, bottomPanelToolbar, this.props.bottomPanelContent ? /*#__PURE__*/React.createElement(this.props.bottomPanelContent, {
        contextProps: contextProps
      }) : "")))), ((_this$props$modal = this.props.modal) === null || _this$props$modal === void 0 ? void 0 : _this$props$modal.open) && ((_this$props$modal2 = this.props.modal) === null || _this$props$modal2 === void 0 ? void 0 : _this$props$modal2.component) && /*#__PURE__*/React.createElement(this.props.modal.component, this.props.modal.props));
    }
  }]);
}(React.Component);
Layout.contextTypes = {
  ifefSnapper: object,
  ifefPlatform: object,
  location: object,
  appContext: object
};
var mapStateToProps = function mapStateToProps(state) {
  return {
    modal: state.modal
  };
};
var mapDispatchToProps = {};
var Layout$1 = connect(mapStateToProps, mapDispatchToProps)(Layout);

var css_248z$9 = "@font-face {\n  font-family: \"Inter\";\n  src: url(\"../fonts/Inter/Inter-VariableFont_slnt,wght.ttf\") format(\"truetype\") tech(\"variations\"), url(\"../fonts/Inter/Inter-VariableFont_slnt,wght.ttf\") format(\"truetype-variations\");\n  font-weight: 100 1000;\n  font-stretch: 25% 151%;\n}\n* {\n  font-family: \"Inter\", Arial, Helvetica, sans-serif;\n}\n\nheader {\n  background-color: var(--head-bkg-color) !important;\n}\n\nnav {\n  background-color: var(--nav-bkg-color) !important;\n}\nnav a {\n  color: var(--nav-icon-color) !important;\n}\nnav .main-nav li:hover {\n  background-color: var(--nav-hover-color) !important;\n}\nnav .main-nav-active {\n  background-color: var(--nav-activegrp-bkg-color) !important;\n  border-left: 10px solid var(--app-accent-color) !important;\n}\nnav .main-nav-active a {\n  color: var(--app-accent-color) !important;\n}";
styleInject(css_248z$9);

var _this$props$ipaConfig;
var AuthProvider = IafAuth.AuthProvider,
  AuthService = IafAuth.AuthService;
var redirectToLoginPage = function redirectToLoginPage() {
  localStorage.removeItem('lastError');
  authService.authorize();
};
var authService = new AuthService({
  //Added authService for rotated refresh token
  clientId: endPointConfig.appId || ((_this$props$ipaConfig = undefined.props.ipaConfig) === null || _this$props$ipaConfig === void 0 ? void 0 : _this$props$ipaConfig.applicationId),
  location: window.location,
  redirectUri: endPointConfig.baseRoot,
  scopes: ["read write"],
  passportServiceBaseUrl: "".concat(endPointConfig.passportServiceOrigin, "/passportsvc/api")
});
var interceptedRequestsInIpa = [];
axiosInstance.interceptors.request.use(function (config) {
  var _lastError$config;
  // Do something before request is sent
  // console.log('axios request config IPA', config.url);
  var lastError = JSON.parse(localStorage.getItem('lastError') || '{}');
  if (lastError.status === 401 && ((_lastError$config = lastError.config) === null || _lastError$config === void 0 ? void 0 : _lastError$config.url) === config.url) {
    // If the last error was a 401 for this URL, we don't want to send the request again
    console.warn('Skipping request due to previous 401 error for this URL IPA:', config.url);
    interceptedRequestsInIpa.push(config);
    return Promise.reject(new Error('Skipping request due to previous 401 error'));
  }
  return config;
}, function (error) {
  // Do something with request error
  console.log('axios request error config IPA', error);
  return Promise.reject(error);
});
axiosInstance.interceptors.response.use(
/*#__PURE__*/
// Any status code that lie within the range of 2xx cause this function to trigger
function () {
  var _ref = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(response) {
    var lastError;
    return _regenerator().w(function (_context) {
      while (1) switch (_context.n) {
        case 0:
          lastError = JSON.parse(localStorage.getItem('lastError') || '{}');
          if (lastError.status === 401) {
            localStorage.removeItem('lastError');
          }
          return _context.a(2, response);
      }
    }, _callee);
  }));
  return function (_x) {
    return _ref.apply(this, arguments);
  };
}(),
/*#__PURE__*/
// Any status codes that falls outside the range of 2xx cause this function to trigger
function () {
  var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(error) {
    var _error$response$confi, tokens, refreshToken, updatedToken, configWithNewAccessToken, result, _t, _t2;
    return _regenerator().w(function (_context2) {
      while (1) switch (_context2.p = _context2.n) {
        case 0:
          if (error.response) {
            _context2.n = 1;
            break;
          }
          return _context2.a(2);
        case 1:
          _context2.p = 1;
          if (!(error.response.status === 403 && (_error$response$confi = error.response.config) !== null && _error$response$confi !== void 0 && (_error$response$confi = _error$response$confi.url) !== null && _error$response$confi !== void 0 && _error$response$confi.endsWith('passportsvc/api/v1/oauth/token'))) {
            _context2.n = 2;
            break;
          }
          console.warn('This user does NOT have enough permission! IPA Main Layout');
          // setTokenReturn403(true)
          redirectToLoginPage();
          return _context2.a(2);
        case 2:
          if (!(error.response.status === 401)) {
            _context2.n = 13;
            break;
          }
          if (!(endPointConfig.authType === 'implicit')) {
            _context2.n = 3;
            break;
          }
          //If authType is implicit it user will logout
          console.log('intercept 1 IPA');
          redirectToLoginPage();
          _context2.n = 12;
          break;
        case 3:
          if (!(endPointConfig.authType === 'pkce')) {
            _context2.n = 12;
            break;
          }
          _context2.n = 4;
          return authService.getAuthTokens();
        case 4:
          tokens = _context2.v;
          refreshToken = tokens === null || tokens === void 0 ? void 0 : tokens.refresh_token; // c9a0c660-7b53-401f-ad5c-07e823d9cd4c
          console.log('intercept 2 IPA', refreshToken);
          if (!refreshToken) {
            _context2.n = 11;
            break;
          }
          _context2.p = 5;
          if (!error.response.config.url.endsWith('passportsvc/api/v1/oauth/token')) {
            _context2.n = 6;
            break;
          }
          console.log('token relogin IPA');
          redirectToLoginPage();
          return _context2.a(2);
        case 6:
          _context2.n = 7;
          return authService.fetchToken(refreshToken, true);
        case 7:
          updatedToken = _context2.v;
          console.log('updatedToken IPA', updatedToken.error);
          // if refresh token expires, then ask user to login
          if (!(updatedToken.error === 'invalid_grant')) {
            _context2.n = 8;
            break;
          }
          console.log('Invalid refresh token, relogin IPA');
          redirectToLoginPage();
          return _context2.a(2);
        case 8:
          // save access token into the session storage with key "manage"
          IafSession.setAuthToken(updatedToken.access_token, undefined); //Updated token in session storage
          configWithNewAccessToken = _objectSpread2(_objectSpread2({}, error.config), {}, {
            headers: _objectSpread2(_objectSpread2({}, error.config.headers), {}, {
              Authorization: "Bearer ".concat(updatedToken.access_token)
            })
          });
          interceptedRequestsInIpa.forEach(function (req) {
            console.log('IPA Resending request with new access token', req.url);
          });
          // resend previous request with new access token
          _context2.n = 9;
          return axiosInstance.request(configWithNewAccessToken);
        case 9:
          result = _context2.v;
          return _context2.a(2, Promise.resolve(result));
        case 10:
          _context2.p = 10;
          _t = _context2.v;
          console.log('Error happened during fetching access token with refresh token, relogin IPA');
          redirectToLoginPage();
          console.error(_t);
          _context2.n = 12;
          break;
        case 11:
          // no token returned, could be due to 500
          console.log('no refreshToken found/returned after authService.getAuthTokens(), could be due to 500. IPA Main Layout');
          redirectToLoginPage();
        case 12:
          _context2.n = 14;
          break;
        case 13:
          return _context2.a(2, Promise.reject(error));
        case 14:
          _context2.n = 16;
          break;
        case 15:
          _context2.p = 15;
          _t2 = _context2.v;
          if (error.response.status !== 401) {
            console.log('Error happened dealing with access token and refresh token, relogin IPA');
            redirectToLoginPage();
          }
          console.error(_t2);
        case 16:
          return _context2.a(2);
      }
    }, _callee2, null, [[5, 10], [1, 15]]);
  }));
  return function (_x2) {
    return _ref2.apply(this, arguments);
  };
}());
enableMapSet();
var App = /*#__PURE__*/function (_React$Component) {
  function App(props) {
    var _this;
    _classCallCheck(this, App);
    _this = _callSuper(this, App, [props]);
    _this.state = {
      platformOverride: _this.props.location.search ? parse(_this.props.location.search).platformOverride : ""
    };
    return _this;
  }
  _inherits(App, _React$Component);
  return _createClass(App, [{
    key: "UNSAFE_componentWillReceiveProps",
    value: function UNSAFE_componentWillReceiveProps(newProps) {
      var newPlatformOverride = newProps.location.search ? parse(newProps.location.search).platformOverride : "";
      if (newPlatformOverride) {
        if (newPlatformOverride !== this.state.platformOverride) {
          this.setState({
            platformOverride: newPlatformOverride
          });
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      var platform = getPlatform(this.state.platformOverride);
      return /*#__PURE__*/React.createElement(IfefBody, {
        platform: platform,
        history: this.props.history,
        location: this.props.location
      }, this.props.children);
    }
  }]);
}(React.Component);
var IpaMainLayout = /*#__PURE__*/function (_React$Component2) {
  function IpaMainLayout(props) {
    _classCallCheck(this, IpaMainLayout);
    return _callSuper(this, IpaMainLayout, [props]);
  }
  _inherits(IpaMainLayout, _React$Component2);
  return _createClass(IpaMainLayout, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (this.props.enableAxiosInterceptor !== prevProps.enableAxiosInterceptor) {
        if (this.props.enableAxiosInterceptor) {
          sessionStorage.setItem('enableAxiosInterceptor', 'true');
        }
      }
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.enableAxiosInterceptor) {
        sessionStorage.setItem('enableAxiosInterceptor', 'true');
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      return /*#__PURE__*/React.createElement(Provider, {
        store: store
      }, /*#__PURE__*/React.createElement(HashRouter, null, /*#__PURE__*/React.createElement(App, {
        history: history,
        location: location
      }, /*#__PURE__*/React.createElement(AuthProvider, {
        authService: authService
      }, /*#__PURE__*/React.createElement(AppProvider, {
        enableAxiosInterceptor: this.props.enableAxiosInterceptor,
        location: location,
        history: history,
        ipaConfig: this.props.ipaConfig,
        onConfigLoad: this.props.onConfigLoad
      }, /*#__PURE__*/React.createElement(AppContext.Consumer, null, function (contextProps) {
        return contextProps.isLoading ? /*#__PURE__*/React.createElement("div", null, contextProps.loadingText) : /*#__PURE__*/React.createElement(Layout$1, {
          pageList: contextProps.router.pageList,
          pageGroups: contextProps.router.pageGroups,
          userLogout: contextProps.actions.userLogout,
          contextProps: contextProps,
          bottomPanelContent: _this2.props.bottomPanelContent,
          ipaConfig: _this2.props.ipaConfig
        }, /*#__PURE__*/React.createElement(TransitionGroup, null, /*#__PURE__*/React.createElement(CSSTransition, {
          key: location.pathname,
          timeout: 500,
          classNames: "nav-view",
          onEnter: _this2.transitionEnter
        }, /*#__PURE__*/React.createElement(Switch, null, contextProps.router.pageRoutes))));
      }))))));
    }
  }]);
}(React.Component);

export { IpaMainLayout };
