import { e as _inherits, f as _createClass, h as _classCallCheck, i as _callSuper, g as _objectSpread2, _ as _asyncToGenerator, a as _regenerator, o as _createForOfIteratorHelper } from '../style-inject.es-ebcb980f.js';
import React from 'react';
import _ from 'lodash';
import { IafFetch, IafProj, IafSession } from '@dtplatform/platform-api';
import 'jszip';
import 'file-saver';
import { S as ScriptHelper } from '../TreeRendererHelper-7d89f2f1.js';
import { aC as addUserConfig, ay as addEntityComponents } from '../EntityListView-43ddf04c.js';
import 'clsx';
import '@mui/material/Button';
import '@mui/material/CircularProgress';
import '@dtplatform/iaf-script-engine';
import '@dtplatform/ui-utils';
import 'immer';
import 'react-select';
import 'react-click-outside';
import 'react-date-picker';
import 'react-datetime-picker';
import 'react-select/creatable';
import { object, func } from 'prop-types';
import 'moment';
import 'interactjs';
import '../StackableDrawer-e9e633e1.js';
import '@nivo/pie';
import '@nivo/bar';
import '@nivo/line';
import '../Table-4fbf94ec.js';
import 'redux';
import { Provider } from 'react-redux';
import '@reduxjs/toolkit';
import '@dtplatform/react-ifef';
import '../GenericModal-a2a94ca2.js';
import '@mui/material';
import '@mui/material/Checkbox';
import '@mui/material/SvgIcon';
import '@mui/system';
import '@mui/icons-material/CheckBox';
import '@mui/icons-material/CheckBoxOutlineBlank';
import '@mui/icons-material/IndeterminateCheckBoxRounded';
import '@mui/icons-material/CheckCircle';
import '@mui/icons-material/RadioButtonUnchecked';
import '@mui/icons-material/LinkTwoTone';
import '@mui/icons-material/LinkOff';
import '@mui/icons-material/ExpandLess';
import '@mui/icons-material/ExpandMore';
import '../RadioButtons-8e63c696.js';
import { MemoryRouter } from 'react-router-dom';
import '../SimpleTextThrobber-687e4daa.js';
import '@mui/icons-material';
import '@mui/material/Radio';
import '@mui/material/RadioGroup';
import '@mui/material/FormControlLabel';
import '@mui/material/FormControl';
import { A as AppContext } from '../appContext-07909014.js';
import '../bytesunit-e53abe5f.js';
import '../genericPageContext-de32d520.js';
import '../GenericPageErrorBoundary-27ba825c.js';
import 'react-codemirror2';
import 'codemirror/lib/codemirror.css';
import 'codemirror/addon/fold/foldgutter.css';
import 'codemirror/mode/javascript/javascript.js';
import 'codemirror/addon/edit/matchbrackets.js';
import 'codemirror/addon/edit/closebrackets.js';
import 'codemirror/addon/fold/foldcode.js';
import 'codemirror/addon/fold/foldgutter.js';
import 'codemirror/addon/fold/brace-fold.js';
import 'codemirror/addon/fold/comment-fold.js';
import 'codemirror/addon/comment/comment.js';
import { l as store, G as addReducerSlice, H as addUser, I as addDashboardComponents } from '../store-31878c8e.js';
import { A as AppProvider } from '../AppProvider-2702c389.js';
import '@dtplatform/iaf-lib';
import 'qs';
import '@mui/material/Dialog';
import 'mime-types';
import 'codemirror/addon/hint/show-hint.js';
import 'codemirror/addon/hint/show-hint.css';
import 'json5';
import '@mui/material/Switch';
import '@dtplatform/platform-ui-components';
import { createMemoryHistory } from 'history';

/**
 * Legacy context support thanks to:
 * this post : https://gazedash.com/all/how-to-support-legacy-react-context/
 * this post was only missing info about `childContextTypes` which I got from here:
 * https://reactjs.org/docs/legacy-context.html
 */
var createLegacyContextSupport = function createLegacyContextSupport(contextTypes) {
  var LegacyContextSupport = /*#__PURE__*/function (_React$Component) {
    function LegacyContextSupport() {
      _classCallCheck(this, LegacyContextSupport);
      return _callSuper(this, LegacyContextSupport, arguments);
    }
    _inherits(LegacyContextSupport, _React$Component);
    return _createClass(LegacyContextSupport, [{
      key: "getChildContext",
      value: function getChildContext() {
        return this.props.context;
      }
    }, {
      key: "render",
      value: function render() {
        return this.props.children;
      }
    }]);
  }(React.Component);
  LegacyContextSupport.contextTypes = contextTypes;
  LegacyContextSupport.childContextTypes = contextTypes;
  return LegacyContextSupport;
};

var MockAppProvider = /*#__PURE__*/function (_AppProvider) {
  function MockAppProvider(props) {
    var _this;
    _classCallCheck(this, MockAppProvider);
    Object.assign(IafFetch.CONFIG, endPointConfig);
    _this = _callSuper(this, MockAppProvider, [props]);
    _this.getPageArray = function () {
      console.log("GET PAGE ARRAY");
      var currentPath = "/";
      if (_this.props.history.entries.length) {
        currentPath = _this.props.history.entries[_this.props.history.entries.length - 1].pathname;
      }
      var path = 'http://localhost:8083/digitaltwin/#' + currentPath;
      return path.split('?')[0].split('/');
    };
    console.log('MockAppProvider state', _this.state);
    _this.state.actions.reloadConfig = _this.initialize.bind(_this, false);
    _this.state.actions.restartApp = _this.initialize.bind(_this);
    console.log('MockAppProvider state', _this.state);
    return _this;
  }
  _inherits(MockAppProvider, _AppProvider);
  return _createClass(MockAppProvider, [{
    key: "handleRequestError",
    value: function handleRequestError(error) {
      console.error(error);
    }
  }, {
    key: "handlePageHandlerLoadError",
    value: function handlePageHandlerLoadError(error) {
      console.error(error);
    }
  }, {
    key: "initialize",
    value: function () {
      var _initialize = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
        var _this2 = this;
        var url,
          currProject,
          currUserGroup,
          _this$props,
          _this$props2,
          options,
          projects,
          project,
          userGroups,
          _iterator,
          _step,
          sliceFile,
          sliceModule,
          slice,
          newReducer,
          dashComponents,
          _iterator2,
          _step2,
          dashCompFile,
          dashCompModule,
          dashComp,
          entityActionComponents,
          _iterator3,
          _step3,
          actionCompFile,
          actCompModule,
          actComp,
          entityDataComponents,
          _iterator4,
          _step4,
          dataCompFile,
          dataComp,
          dataCompFactory,
          _iterator5,
          _step5,
          styleSheet,
          customCss,
          config,
          userConfig,
          configs,
          _t,
          _t2,
          _t3,
          _t4,
          _t5,
          _t6,
          _t7,
          _t8,
          _t9,
          _t0;
        return _regenerator().w(function (_context) {
          while (1) switch (_context.p = _context.n) {
            case 0:
              if (!this.props.manageLoggedInUser) {
                _context.n = 2;
                break;
              }
              if (!IafSession.loggedIn()) {
                url = IafSession.getAuthUrl(window.location.href);
                window.location.assign(url);
              }
              if (!(document.location.hash && document.location.hash !== '')) {
                _context.n = 2;
                break;
              }
              _context.n = 1;
              return IafSession.setSessionData(IafSession.extractToken(document.location.hash));
            case 1:
              window.location.assign(document.location.pathname);
            case 2:
              currProject = undefined;
              currUserGroup = undefined;
              if (!this.props.ipaConfig.access_token) {
                _context.n = 3;
                break;
              }
              _context.n = 3;
              return IafSession.setSessionData(this.props.ipaConfig.access_token);
            case 3:
              if (!this.props.ipaConfig.project_name) {
                _context.n = 8;
                break;
              }
              options = {
                _pageSize: 50
              };
              _context.n = 4;
              return IafProj.getProjects({
                _name: this.props.ipaConfig.project_name
              }, undefined, options);
            case 4:
              projects = _context.v;
              project = projects === null || projects === void 0 ? void 0 : projects[0];
              _context.n = 5;
              return IafProj.switchProject(project._id);
            case 5:
              //sessionStorage.setItem("ipaSelectedProjectId", project._id);
              IafSession.setSessionStorage("project", project);
              IafSession.setSessionStorage("ipaSelectedProjectId", project._id);
              _context.n = 6;
              return IafProj.getCurrent();
            case 6:
              currProject = _context.v;
              _context.n = 7;
              return IafProj.getProjectUserGroupsForCurrentUser(currProject._id);
            case 7:
              userGroups = _context.v;
              currUserGroup = userGroups.find(function (ug) {
                return ug._name == _this2.props.ipaConfig.user_group_name;
              });

              //for page components
              this.setSelectedItems({
                selectedProject: currProject,
                selectedUserGroupId: currUserGroup._id
              });

              //for non page components
              if ((_this$props = this.props) !== null && _this$props !== void 0 && (_this$props = _this$props.sampleSelectedItems) !== null && _this$props !== void 0 && _this$props.selectedProject && (_this$props2 = this.props) !== null && _this$props2 !== void 0 && (_this$props2 = _this$props2.sampleSelectedItems) !== null && _this$props2 !== void 0 && _this$props2.selectedUserGroupId) {
                this.setSelectedItems({
                  selectedProject: this.props.sampleSelectedItems.selectedProject,
                  selectedUserGroupId: this.props.sampleSelectedItems.selectedUserGroupId
                });
              }
            case 8:
              if (!(this.props.ipaConfig && this.props.ipaConfig.redux && this.props.ipaConfig.redux.slices && this.props.ipaConfig.redux.slices.length)) {
                _context.n = 20;
                break;
              }
              _iterator = _createForOfIteratorHelper(this.props.ipaConfig.redux.slices);
              _context.p = 9;
              _iterator.s();
            case 10:
              if ((_step = _iterator.n()).done) {
                _context.n = 16;
                break;
              }
              sliceFile = _step.value;
              _context.p = 11;
              _context.n = 12;
              return import("../../../../../app/ipaCore/redux/".concat(sliceFile.file));
            case 12:
              sliceModule = _context.v;
              _context.n = 13;
              return sliceModule["default"];
            case 13:
              slice = _context.v;
              newReducer = addReducerSlice({
                name: sliceFile.name,
                slice: slice
              });
              store.replaceReducer(newReducer);
              _context.n = 15;
              break;
            case 14:
              _context.p = 14;
              _t = _context.v;
              console.error(_t);
              console.error('Slice not able to be loaded: ' + sliceFile.name);
            case 15:
              _context.n = 10;
              break;
            case 16:
              _context.n = 18;
              break;
            case 17:
              _context.p = 17;
              _t2 = _context.v;
              _iterator.e(_t2);
            case 18:
              _context.p = 18;
              _iterator.f();
              return _context.f(18);
            case 19:
              _context.n = 21;
              break;
            case 20:
              console.warn("No ipa-core redux configuration found");
            case 21:
              if (!(this.props.ipaConfig && this.props.ipaConfig.components)) {
                _context.n = 57;
                break;
              }
              if (!(this.props.ipaConfig.components.dashboard && this.props.ipaConfig.components.dashboard.length)) {
                _context.n = 33;
                break;
              }
              dashComponents = [];
              _iterator2 = _createForOfIteratorHelper(this.props.ipaConfig.components.dashboard);
              _context.p = 22;
              _iterator2.s();
            case 23:
              if ((_step2 = _iterator2.n()).done) {
                _context.n = 29;
                break;
              }
              dashCompFile = _step2.value;
              _context.p = 24;
              _context.n = 25;
              return import("../../../../../app/ipaCore/components/".concat(dashCompFile.file));
            case 25:
              dashCompModule = _context.v;
              _context.n = 26;
              return dashCompModule["default"];
            case 26:
              dashComp = _context.v;
              dashComponents.push({
                name: dashCompFile.name,
                component: dashComp
              });
              _context.n = 28;
              break;
            case 27:
              _context.p = 27;
              _t3 = _context.v;
              console.error(_t3);
              console.error('Dashboard component not able to be loaded: ' + dashCompFile.name);
            case 28:
              _context.n = 23;
              break;
            case 29:
              _context.n = 31;
              break;
            case 30:
              _context.p = 30;
              _t4 = _context.v;
              _iterator2.e(_t4);
            case 31:
              _context.p = 31;
              _iterator2.f();
              return _context.f(31);
            case 32:
              if (dashComponents.length) store.dispatch(addDashboardComponents(dashComponents));
            case 33:
              if (!(this.props.ipaConfig.components.entityAction && this.props.ipaConfig.components.entityAction.length)) {
                _context.n = 45;
                break;
              }
              entityActionComponents = [];
              _iterator3 = _createForOfIteratorHelper(this.props.ipaConfig.component.entityAction);
              _context.p = 34;
              _iterator3.s();
            case 35:
              if ((_step3 = _iterator3.n()).done) {
                _context.n = 41;
                break;
              }
              actionCompFile = _step3.value;
              _context.p = 36;
              _context.n = 37;
              return import("../../../../../app/ipaCore/components/".concat(actionCompFile.file));
            case 37:
              actCompModule = _context.v;
              _context.n = 38;
              return actCompModule[actionCompFile.name + 'Factory'];
            case 38:
              actComp = _context.v;
              entityActionComponents.push({
                name: actionCompFile.name,
                component: actComp
              });
              _context.n = 40;
              break;
            case 39:
              _context.p = 39;
              _t5 = _context.v;
              console.error(_t5);
              console.error('Entity Action component not able to be loaded: ' + actionCompFile.name);
            case 40:
              _context.n = 35;
              break;
            case 41:
              _context.n = 43;
              break;
            case 42:
              _context.p = 42;
              _t6 = _context.v;
              _iterator3.e(_t6);
            case 43:
              _context.p = 43;
              _iterator3.f();
              return _context.f(43);
            case 44:
              if (entityActionComponents.length) store.dispatch(addEntityComponents('action', entityActionComponents));
            case 45:
              if (!(this.props.ipaConfig.components.entityData && this.props.ipaConfig.components.entityData.length)) {
                _context.n = 57;
                break;
              }
              entityDataComponents = [];
              _iterator4 = _createForOfIteratorHelper(this.props.ipaConfig.components.entityData);
              _context.p = 46;
              _iterator4.s();
            case 47:
              if ((_step4 = _iterator4.n()).done) {
                _context.n = 53;
                break;
              }
              dataCompFile = _step4.value;
              _context.p = 48;
              _context.n = 49;
              return import("../../../../../app/ipaCore/components/".concat(dataCompFile.file));
            case 49:
              dataComp = _context.v;
              _context.n = 50;
              return dataComp[dataCompFile.name + 'Factory'];
            case 50:
              dataCompFactory = _context.v;
              entityDataComponents.push({
                name: dataCompFile.name,
                component: dataCompFactory
              });
              _context.n = 52;
              break;
            case 51:
              _context.p = 51;
              _t7 = _context.v;
              console.error(_t7);
              console.error('Entity Action component not able to be loaded: ' + dataCompFile.name);
            case 52:
              _context.n = 47;
              break;
            case 53:
              _context.n = 55;
              break;
            case 54:
              _context.p = 54;
              _t8 = _context.v;
              _iterator4.e(_t8);
            case 55:
              _context.p = 55;
              _iterator4.f();
              return _context.f(55);
            case 56:
              if (entityDataComponents.length) store.dispatch(addEntityComponents('data', entityDataComponents));
            case 57:
              if (!(this.props.ipaConfig && Array.isArray(_.get(this.props.ipaConfig, 'css')))) {
                _context.n = 67;
                break;
              }
              _iterator5 = _createForOfIteratorHelper(this.props.ipaConfig.css);
              _context.p = 58;
              _iterator5.s();
            case 59:
              if ((_step5 = _iterator5.n()).done) {
                _context.n = 64;
                break;
              }
              styleSheet = _step5.value;
              _context.p = 60;
              _context.n = 61;
              return import("../../../../../app/ipaCore/css/".concat(styleSheet));
            case 61:
              customCss = _context.v;
              _context.n = 63;
              break;
            case 62:
              _context.p = 62;
              _t9 = _context.v;
            case 63:
              _context.n = 59;
              break;
            case 64:
              _context.n = 66;
              break;
            case 65:
              _context.p = 65;
              _t0 = _context.v;
              _iterator5.e(_t0);
            case 66:
              _context.p = 66;
              _iterator5.f();
              return _context.f(66);
            case 67:
              //config loader
              config = this.props.initialConfig;
              if (!this.props.ipaConfig.user_config_name) {
                _context.n = 69;
                break;
              }
              userConfig = currUserGroup._userAttributes.userConfigs.find(function (uc) {
                return uc._name == _this2.props.ipaConfig.user_config_name;
              });
              _context.n = 68;
              return IafProj.getUserConfigs(currProject, {
                _id: userConfig._id
              });
            case 68:
              configs = _context.v;
              config = JSON.parse(configs[0]._versions.find(function (uc) {
                return uc._version == configs[0]._tipVersion;
              })._userData);
            case 69:
              console.log("MockAppProvider initialized config, ", config);
              this.onConfigLoad(config, this.testConfig(config), this.props.ipaConfig.access_token, {});
            case 70:
              return _context.a(2);
          }
        }, _callee, this, [[60, 62], [58, 65, 66, 67], [48, 51], [46, 54, 55, 56], [36, 39], [34, 42, 43, 44], [24, 27], [22, 30, 31, 32], [11, 14], [9, 17, 18, 19]]);
      }));
      function initialize() {
        return _initialize.apply(this, arguments);
      }
      return initialize;
    }()
  }, {
    key: "onConfigLoad",
    value: function () {
      var _onConfigLoad = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(config, routes, token, user) {
        var loadThese, i, execThese, _i;
        return _regenerator().w(function (_context2) {
          while (1) switch (_context2.n) {
            case 0:
              console.log("MockAppProvider on config load, ", config);
              store.dispatch(addUserConfig(config));
              store.dispatch(addUser(user));

              //load all config level scripts
              if (!(!!config.onConfigLoad && !!config.onConfigLoad.load && config.onConfigLoad.load.length > 0)) {
                _context2.n = 3;
                break;
              }
              //load each script
              loadThese = config.onConfigLoad.load;
              i = 0;
            case 1:
              if (!(i < loadThese.length)) {
                _context2.n = 3;
                break;
              }
              _context2.n = 2;
              return ScriptHelper.loadScript({
                _userType: loadThese[i]
              });
            case 2:
              i++;
              _context2.n = 1;
              break;
            case 3:
              if (!(!!config.onConfigLoad && !!config.onConfigLoad.exec && config.onConfigLoad.exec.length > 0)) {
                _context2.n = 6;
                break;
              }
              //load each script
              execThese = config.onConfigLoad.exec;
              _i = 0;
            case 4:
              if (!(_i < execThese.length)) {
                _context2.n = 6;
                break;
              }
              _context2.n = 5;
              return ScriptHelper.executeScript(execThese[_i]);
            case 5:
              _i++;
              _context2.n = 4;
              break;
            case 6:
              _context2.n = 7;
              return routes;
            case 7:
              routes = _context2.v;
              if (routes) {
                this.setState({
                  router: {
                    pageList: routes.pageList,
                    pageRoutes: routes.pageRoutes,
                    pageGroups: routes.pageGroups
                  }
                });
              }
              console.log("MockAppProvider routes", routes);
              this.setState({
                isLoading: false
              });
              if (this.props.onConfigLoad) this.props.onConfigLoad(store, config, this.state);
            case 8:
              return _context2.a(2);
          }
        }, _callee2, this);
      }));
      function onConfigLoad(_x, _x2, _x3, _x4) {
        return _onConfigLoad.apply(this, arguments);
      }
      return onConfigLoad;
    }()
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement(AppContext.Provider, {
        value: this.state
      }, this.props.children);
    }
  }]);
}(AppProvider);
MockAppProvider.contextTypes = {
  ifefSnapper: object,
  ifefShowModal: func
};
var decorateWithMockAppProvider = function decorateWithMockAppProvider(Component) {
  var ipaConfig = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var userConfig = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var currentPath = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "/assets";
  var sampleSelectedItems = arguments.length > 4 ? arguments[4] : undefined;
  var optionalProps = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : {};
  //console.log("withMockAppProvider props",props)
  var history = createMemoryHistory({
    initialEntries: [currentPath],
    // The initial URLs in the history stack
    initialIndex: 0,
    // The starting index in the history stack
    //keyLength: 6, // The length of location.key
    // A function to use to confirm navigation with the user. Required
    // if you return string prompts from transition hooks (see below)
    getUserConfirmation: null
  });
  var LegacyContextProvider = createLegacyContextSupport({
    ifefPlatform: object,
    ifefUpdatePopover: func
  });
  var context = {
    ifefPlatform: {},
    ifefUpdatePopover: _.noop
  };
  var providerProps = _objectSpread2({
    initialConfig: userConfig,
    location: history.location,
    history: history,
    ipaConfig: ipaConfig,
    onConfigLoad: _.noop,
    sampleSelectedItems: sampleSelectedItems
  }, optionalProps);
  return /*#__PURE__*/React.createElement(Provider, {
    store: store
  }, /*#__PURE__*/React.createElement(MockAppProvider, providerProps, /*#__PURE__*/React.createElement(MemoryRouter, {
    initialEntries: [currentPath]
  }, /*#__PURE__*/React.createElement(LegacyContextProvider, {
    context: context
  }, /*#__PURE__*/React.createElement(Component, null)))));
};

export { MockAppProvider, createLegacyContextSupport, decorateWithMockAppProvider };
