import { e as _inherits, f as _createClass, h as _classCallCheck, i as _callSuper } from '../style-inject.es-ebcb980f.js';
import React from 'react';
import 'lodash';
import '@dtplatform/platform-api';
import 'jszip';
import 'file-saver';
import '../TreeRendererHelper-7d89f2f1.js';
import { a3 as EntitySelectionPanel, a4 as TreeSelectMode, a2 as EntityActionsPanel, E as EntityListView, a0 as useSortEntities, a1 as usePaginateEntities, a5 as ASCENDING_ORDER, a6 as DESCENDING_ORDER, a7 as ENTITY_LIST_SORT_PREFERENCE } from '../EntityListView-43ddf04c.js';
import 'clsx';
import '@mui/material/Button';
import '@mui/material/CircularProgress';
import '@dtplatform/iaf-script-engine';
import '@dtplatform/ui-utils';
import 'immer';
import 'react-select';
import 'react-click-outside';
import 'react-date-picker';
import 'react-datetime-picker';
import 'react-select/creatable';
import 'prop-types';
import 'moment';
import '@nivo/pie';
import '@nivo/bar';
import '@nivo/line';
import 'redux';
import 'react-redux';
import '@reduxjs/toolkit';
import '@dtplatform/react-ifef';
import '../GenericModal-a2a94ca2.js';
import '@mui/material';
import '@mui/material/Checkbox';
import '@mui/material/SvgIcon';
import '@mui/system';
import '@mui/icons-material/CheckBox';
import '@mui/icons-material/CheckBoxOutlineBlank';
import '@mui/icons-material/IndeterminateCheckBoxRounded';
import '@mui/icons-material/CheckCircle';
import '@mui/icons-material/RadioButtonUnchecked';
import '@mui/icons-material/LinkTwoTone';
import '@mui/icons-material/LinkOff';
import '@mui/icons-material/ExpandLess';
import '@mui/icons-material/ExpandMore';
import '../SimpleTextThrobber-687e4daa.js';
import '../appContext-07909014.js';
import { G as GenericPageContext, w as withGenericPageContext } from '../genericPageContext-de32d520.js';
import { w as withEntityStore, a as withEntitySearch, b as withEntityConfig, c as withEntityAvailableGroups, d as withGenericPageErrorBoundary, E as EntityDataStack, e as EntityDataContainer, f as EntityDataGroupContainer, u as useEntityData, g as EntityTableContainer, J as JSONEditor } from '../GenericPageErrorBoundary-27ba825c.js';
import 'react-codemirror2';
import 'codemirror/lib/codemirror.css';
import 'codemirror/addon/fold/foldgutter.css';
import 'codemirror/mode/javascript/javascript.js';
import 'codemirror/addon/edit/matchbrackets.js';
import 'codemirror/addon/edit/closebrackets.js';
import 'codemirror/addon/fold/foldcode.js';
import 'codemirror/addon/fold/foldgutter.js';
import 'codemirror/addon/fold/brace-fold.js';
import 'codemirror/addon/fold/comment-fold.js';
import 'codemirror/addon/comment/comment.js';

function withGenericErrorBoundary(WrappedComponent) {
  var GenericErrorBoundary = /*#__PURE__*/function (_React$Component) {
    function GenericErrorBoundary(props) {
      var _this;
      _classCallCheck(this, GenericErrorBoundary);
      _this = _callSuper(this, GenericErrorBoundary, [props]);
      _this.state = {
        hasError: false
      };
      return _this;
    }
    _inherits(GenericErrorBoundary, _React$Component);
    return _createClass(GenericErrorBoundary, [{
      key: "componentDidCatch",
      value: function componentDidCatch(error, errorInfo) {
        // You can also do more with the error here
        console.error(error);
        console.error(errorInfo);
      }
    }, {
      key: "render",
      value: function render() {
        return this.state.hasError ? /*#__PURE__*/React.createElement("div", {
          className: "inv-error-boundary-container"
        }, /*#__PURE__*/React.createElement("span", null, /*#__PURE__*/React.createElement("i", {
          className: "fas fa-exclamation-circle point-icon point-error"
        }), "Something went wrong")) : /*#__PURE__*/React.createElement(WrappedComponent, this.props);
      }
    }], [{
      key: "getDerivedStateFromError",
      value: function getDerivedStateFromError(error) {
        // Update state so the next render will show the fallback UI.
        return {
          hasError: true
        };
      }
    }]);
  }(React.Component);
  return GenericErrorBoundary;
}

var IpaPageComponents = {
  //higher order components
  withEntityStore: withEntityStore,
  withEntitySearch: withEntitySearch,
  withEntityConfig: withEntityConfig,
  withEntityAvailableGroups: withEntityAvailableGroups,
  withGenericErrorBoundary: withGenericErrorBoundary,
  GenericPageContext: GenericPageContext,
  withGenericPageContext: withGenericPageContext,
  withGenericPageErrorBoundary: withGenericPageErrorBoundary,
  //components
  EntitySelectionPanel: EntitySelectionPanel,
  EntityDataStack: EntityDataStack,
  EntityDataContainer: EntityDataContainer,
  EntityDataGroupContainer: EntityDataGroupContainer,
  useEntityData: useEntityData,
  TreeSelectMode: TreeSelectMode,
  EntityActionsPanel: EntityActionsPanel,
  EntityListView: EntityListView,
  EntityTableContainer: EntityTableContainer,
  JSONEditor: JSONEditor,
  //custom hooks
  useSortEntities: useSortEntities,
  usePaginateEntities: usePaginateEntities,
  //static strings
  ASCENDING_ORDER: ASCENDING_ORDER,
  DESCENDING_ORDER: DESCENDING_ORDER,
  ENTITY_LIST_SORT_PREFERENCE: ENTITY_LIST_SORT_PREFERENCE
};

export default IpaPageComponents;
