import { e as _inherits, f as _createClass, h as _classCallCheck, i as _callSuper } from './style-inject.es-ebcb980f.js';
import React from 'react';
import { bool, oneOfType, string, element, func } from 'prop-types';
import classnames from 'classnames';
import { Link } from 'react-router-dom';

var Item = /*#__PURE__*/function (_React$Component) {
  function Item() {
    _classCallCheck(this, Item);
    return _callSuper(this, Item, arguments);
  }
  _inherits(Item, _React$Component);
  return _createClass(Item, [{
    key: "render",
    value: function render() {
      var classes = classnames({
        'item': this.props.item,
        'item-text-wrap': this.props.wrap,
        'item-divider': this.props.divider,
        'item-icon-left': this.props.iconLeft,
        'item-icon-right': this.props.iconRight,
        'item-avatar': this.props.avatar,
        'item-image': this.props.image,
        'item-body': this.props.body,
        'item-input': this.props.input,
        'item-button-right': this.props.buttonRight,
        'item-button-left': this.props.buttonLeft,
        'item-thumbnail-left': this.props.thumbnailLeft,
        'item-thumbnail-right': this.props.thumbnailRight,
        'item-checkbox': this.props.checkboxLeft || this.props.checkboxRight,
        'item-checkbox-right': this.props.checkboxRight
      }, this.props.customClasses);
      var item;
      //TODO: replace by a more declarative option
      if (this.props.link) {
        item = /*#__PURE__*/React.createElement(Link, {
          className: classes,
          to: this.props.link,
          onClick: this.props.onClick
        }, this.props.children);
      } else if (this.props.href) {
        item = /*#__PURE__*/React.createElement("a", {
          className: classes,
          href: this.props.href,
          target: this.props.target,
          onClick: this.props.onClick
        }, this.props.children);
      } else {
        // This is now a pass through for extra props to support generic eventing.
        // Decided to use item_id as our universal identifier.  jl 11/17/2019
        // And a universal (Script) "action" packet.
        item = /*#__PURE__*/React.createElement("div", {
          className: classes,
          onClick: this.props.onClick,
          item_id: this.props.item_id,
          action: this.props.action
        }, this.props.children);
      }
      return item;
    }
  }]);
}(React.Component);
Item.propTypes = {
  'item': bool,
  'link': oneOfType([string, element]),
  href: string,
  target: string,
  'wrap': bool,
  'divider': bool,
  'iconLeft': bool,
  'iconRight': bool,
  'avatar': bool,
  'image': bool,
  'body': bool,
  'input': bool,
  'buttonRight': bool,
  'buttonLeft': bool,
  'thumbnailLeft': bool,
  'thumbnailRight': bool,
  'checkboxLeft': bool,
  'checkboxRight': bool,
  'customClasses': string,
  'onClick': func
};
Item.defaultProps = {
  'item': true,
  'link': null,
  href: null,
  target: null,
  'wrap': false,
  'divider': false,
  'iconLeft': false,
  'iconRight': false,
  'avatar': false,
  'image': false,
  'body': false,
  'input': false,
  'buttonRight': false,
  'buttonLeft': false,
  'thumbnailLeft': false,
  'thumbnailRight': false,
  'checkboxLeft': false,
  'checkboxRight': false,
  'customClasses': '',
  'onClick': null
};

var LinkedIcon = /*#__PURE__*/function (_React$Component) {
  function LinkedIcon() {
    _classCallCheck(this, LinkedIcon);
    return _callSuper(this, LinkedIcon, arguments);
  }
  _inherits(LinkedIcon, _React$Component);
  return _createClass(LinkedIcon, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement("div", {
        className: this.props.customClass
      }, /*#__PURE__*/React.createElement("a", {
        href: "#",
        onClick: this.props.clickHandler
      }, this.props.icon ? /*#__PURE__*/React.createElement("i", {
        className: this.props.icon
      }) : /*#__PURE__*/React.createElement("img", {
        className: this.props.iconClasses,
        src: this.props.iconImg
      }), /*#__PURE__*/React.createElement("span", null, this.props.linkText)));
    }
  }]);
}(React.Component);

export { Item as I, LinkedIcon as L };
