import { s as styleInject, d as _slicedToArray } from './style-inject.es-ebcb980f.js';
import React, { useState, useRef, useCallback, useEffect } from 'react';
import clsx from 'clsx';
import interact from 'interactjs';

var css_248z = ".drawer {\n  display: flex;\n  position: relative;\n  transition: width 1s, min-width 1s;\n  height: 100%;\n}\n.drawer .handle {\n  width: 2px;\n  height: 100%;\n  cursor: col-resize;\n}\n.drawer .drawer-content {\n  flex-grow: 1;\n  opacity: 0;\n  transition: opacity 1s;\n  overflow-y: auto;\n  overflow-x: hidden;\n  max-height: 100%;\n}\n.drawer .drawer-content::-webkit-scrollbar {\n  width: 7px;\n  height: 7px;\n}\n.drawer .drawer-content::-webkit-scrollbar-track {\n  background: white;\n}\n.drawer .drawer-content::-webkit-scrollbar-thumb {\n  background: #DCDCDC;\n  border-radius: 2rem;\n}\n.drawer .drawer-content::-webkit-scrollbar-thumb:hover {\n  background: #B8B8B8;\n}\n.drawer .drawer-content-open {\n  opacity: 1;\n}\n.drawer .drawer-toggle {\n  z-index: 5;\n  cursor: pointer;\n  position: absolute;\n  right: 0;\n  transform: translate(100%, 0);\n  font-size: 24px;\n  width: 50px;\n  background: #EAEAEA;\n  display: flex;\n  justify-content: center;\n  align-content: center;\n  height: 50px;\n  color: #666666;\n  border-radius: 0 23px 23px 0;\n}\n.drawer .drawer-toggle > i {\n  padding: 0;\n  height: 24px;\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%, -50%);\n}\n.drawer .drawer-toggle .dbm-tooltip {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  transform: scale(0.75);\n}\n.drawer .drawer-toggle .dbm-tooltip .dbm-tooltiptext {\n  bottom: 0px;\n  left: 299%;\n  transform: scale(0.75);\n}\n.drawer .drawer-toggle-open {\n  transform: translate(0, 0);\n  border-radius: 23px 0 0 23px;\n  opacity: 0.8;\n}\n.drawer.drawer-anchor-right {\n  margin-left: auto;\n}\n.drawer.drawer-anchor-right .drawer-toggle {\n  right: auto;\n  left: 0;\n  transform: translate(-100%, 0);\n  border-radius: 23px 0 0 23px;\n  opacity: 1;\n}\n.drawer.drawer-anchor-right .drawer-toggle-open {\n  transform: translate(0, 0);\n  border-radius: 0 23px 23px 0;\n  opacity: 0.8;\n}";
styleInject(css_248z);

var toggleHeight = 50;
var DEFAULT_DRAWER_WIDTH = 360;
var StackableDrawer = function StackableDrawer(_ref) {
  var _ref$level = _ref.level,
    level = _ref$level === void 0 ? 1 : _ref$level,
    iconKey = _ref.iconKey,
    children = _ref.children,
    _ref$onOpen = _ref.onOpen,
    onOpen = _ref$onOpen === void 0 ? _.noop : _ref$onOpen,
    _ref$onClose = _ref.onClose,
    onClose = _ref$onClose === void 0 ? _.noop : _ref$onClose,
    _ref$isDrawerOpen = _ref.isDrawerOpen,
    isDrawerOpen = _ref$isDrawerOpen === void 0 ? true : _ref$isDrawerOpen,
    reopenKey = _ref.reopenKey,
    _ref$fixedWidth = _ref.fixedWidth,
    fixedWidth = _ref$fixedWidth === void 0 ? 0 : _ref$fixedWidth,
    tooltip = _ref.tooltip,
    _ref$anchor = _ref.anchor,
    anchor = _ref$anchor === void 0 ? 'left' : _ref$anchor,
    childrenMinWidth = _ref.childrenMinWidth;
  var _useState = useState(isDrawerOpen ? DEFAULT_DRAWER_WIDTH : 0),
    _useState2 = _slicedToArray(_useState, 2),
    stableWidth = _useState2[0],
    setStableWidth = _useState2[1];
  var _useState3 = useState(childrenMinWidth || stableWidth),
    _useState4 = _slicedToArray(_useState3, 1),
    contentMinWidth = _useState4[0];
  var drawer = useRef();
  var toggleOpen = useCallback(function () {
    if (stableWidth === 0) onOpen();else onClose();
    setStableWidth(function (stableWidth) {
      return stableWidth === 0 ? fixedWidth != 0 ? fixedWidth : DEFAULT_DRAWER_WIDTH : 0;
    });
  }, [stableWidth]);
  useEffect(function () {
    if (isDrawerOpen) setStableWidth(fixedWidth != 0 ? fixedWidth : DEFAULT_DRAWER_WIDTH);else setStableWidth(0);
  }, [isDrawerOpen, reopenKey]);
  useEffect(function () {
    interact(drawer.current).resizable({
      edges: {
        left: anchor == 'right',
        right: anchor == 'left',
        bottom: false,
        top: false
      },
      listeners: {
        move: function move(event) {
          var target = event.target;
          event.target.style['width'] = "".concat(event.rect.width, "px"); //this line allows the drawer to be minimized manually
        },
        start: function start(event) {
          event.target.style['transition'] = 'none';
        },
        end: function end(event) {
          event.target.style['transition'] = 'width 1s, min-width 1s';
          setStableWidth(event.target.offsetWidth);
        }
      }
    });
  }, [drawer.current, anchor]);
  var open = stableWidth !== 0;
  return /*#__PURE__*/React.createElement("div", {
    ref: drawer,
    className: clsx('drawer', anchor == 'right' && 'drawer-anchor-right'),
    style: {
      width: stableWidth
    }
  }, iconKey && /*#__PURE__*/React.createElement("div", {
    style: {
      top: "".concat(20 + toggleHeight * (level - 1), "px")
    },
    className: clsx({
      'drawer-toggle': true,
      'drawer-toggle-open': open
    }),
    onClick: toggleOpen
  }, tooltip ? /*#__PURE__*/React.createElement("div", {
    className: "dbm-tooltip"
  }, /*#__PURE__*/React.createElement("i", {
    className: clsx('fas', open && anchor == 'right' ? "fa-arrow-right" : iconKey)
  }), /*#__PURE__*/React.createElement("span", {
    className: "dbm-tooltiptext"
  }, tooltip)) : /*#__PURE__*/React.createElement("i", {
    className: "fas ".concat(iconKey)
  })), /*#__PURE__*/React.createElement("div", {
    className: clsx({
      'drawer-content': true,
      'drawer-content-open': open
    })
  }, /*#__PURE__*/React.createElement("div", {
    style: {
      minWidth: contentMinWidth,
      transitionDelay: '1s'
    }
  }, children)));
};

export { DEFAULT_DRAWER_WIDTH as D, StackableDrawer as S };
