import { l as _extends, s as styleInject, d as _slicedToArray, _ as _asyncToGenerator, a as _regenerator } from './style-inject.es-ebcb980f.js';
import React, { useState, useMemo, useCallback } from 'react';
import _ from 'lodash';
import { S as ScriptHelper, i as isValidUrl } from './TreeRendererHelper-7d89f2f1.js';
import { S as ScriptedChart, u as useChecked, R as RoundCheckbox, T as TextSearch, E as EntityListView } from './EntityListView-43ddf04c.js';
import clsx from 'clsx';
import produce from 'immer';
import { Tooltip } from '@mui/material';

var ChartStack = function ChartStack(props) {
  var i = 1;
  return /*#__PURE__*/React.createElement("div", {
    className: "chart-stack",
    style: {
      height: "100%",
      display: "grid",
      gridTemplateColumns: "100%",
      gridTemplateRows: "repeat(".concat(props.charts.length, ", ").concat(100 / props.charts.length, "%)")
    }
  }, props.charts.map(function (config) {
    return /*#__PURE__*/React.createElement(ScriptedChart, _extends({
      key: "chart-".concat(i++)
    }, config));
  }));
};

var css_248z = ".cross-entity-search {\n  display: flex;\n  overflow: hidden;\n  height: 100%;\n}\n.cross-entity-search .entity-types {\n  display: flex;\n  flex-wrap: wrap;\n  width: 90%;\n  justify-content: space-between;\n}\n.cross-entity-search .search-term {\n  flex: 1;\n}\n.cross-entity-search .search-term .no-results {\n  color: #666666;\n  font-style: italic;\n  margin-left: 5px;\n}\n.cross-entity-search .search-results {\n  overflow: scroll;\n  height: 100%;\n  flex: 3;\n  max-width: 700px;\n  transition: flex, max-width 3s;\n  margin-left: 10px;\n}\n.cross-entity-search .search-results::-webkit-scrollbar {\n  width: 7px;\n  height: 7px;\n}\n.cross-entity-search .search-results::-webkit-scrollbar-track {\n  background: white;\n}\n.cross-entity-search .search-results::-webkit-scrollbar-thumb {\n  background: #DCDCDC;\n  border-radius: 2rem;\n}\n.cross-entity-search .search-results::-webkit-scrollbar-thumb:hover {\n  background: #B8B8B8;\n}\n.cross-entity-search .search-results.collapsed {\n  flex: 0;\n  max-width: 0;\n}";
styleInject(css_248z);

var CrossEntitySearch = function CrossEntitySearch(_ref) {
  var _ref$searchableEntiti = _ref.searchableEntities,
    searchableEntities = _ref$searchableEntiti === void 0 ? [] : _ref$searchableEntiti,
    script = _ref.script,
    doAction = _ref.dashboard.doAction;
  var _useState = useState(''),
    _useState2 = _slicedToArray(_useState, 2),
    searchTerm = _useState2[0],
    setSearchTerm = _useState2[1];
  var _useState3 = useState(false),
    _useState4 = _slicedToArray(_useState3, 2),
    fetching = _useState4[0],
    setFetching = _useState4[1];
  var _useState5 = useState([]),
    _useState6 = _slicedToArray(_useState5, 2),
    fetchedEntities = _useState6[0],
    setFetchedEntities = _useState6[1];
  var entities = useMemo(function () {
    return searchableEntities.map(produce(function (se) {
      se.checked = se["default"];
    }));
  }, [searchableEntities]);
  var _useChecked = useChecked(entities),
    handleCheck = _useChecked.handleCheck,
    rawSearchableEntities = _useChecked.items;
  var onFetch = useCallback(/*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee() {
    var _t;
    return _regenerator().w(function (_context) {
      while (1) switch (_context.n) {
        case 0:
          setFetching(true);
          _t = setFetchedEntities;
          _context.n = 1;
          return ScriptHelper.executeScript(script, {
            entityTypes: rawSearchableEntities.filter(function (et) {
              return et.checked;
            }).map(function (et) {
              return et.entityType.plural;
            }),
            searchQuery: {
              $text: {
                $search: searchTerm
              }
            }
          });
        case 1:
          _t(_context.v);
          setFetching(false);
        case 2:
          return _context.a(2);
      }
    }, _callee);
  })), [rawSearchableEntities, searchTerm]);
  var searchEntities = /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", null, "Search among:"), /*#__PURE__*/React.createElement("div", {
    className: 'entity-types'
  }, rawSearchableEntities.map(function (et) {
    return /*#__PURE__*/React.createElement("div", {
      key: et.entityType.plural
    }, /*#__PURE__*/React.createElement(RoundCheckbox, {
      checked: et.checked,
      onChange: function onChange() {
        return handleCheck(et);
      }
    }), et.entityType.plural);
  })));
  var navigate = useCallback(function (entity) {
    var currentSearchableEntity = rawSearchableEntities.find(function (e) {
      return e.entityType.plural === entity.entityType;
    });
    doAction({
      type: "navigate",
      //TODO model action types as enum rather than string
      navigateTo: currentSearchableEntity.handler,
      query: {
        selectedEntities: [entity._id],
        entityType: currentSearchableEntity.entityType.singular
      }
    });
  }, [rawSearchableEntities]);
  var config = useMemo(function () {
    return {
      columns: [{
        "name": "Entity Name",
        "accessor": "entityName"
      }, {
        "name": "Entity Type",
        "accessor": "entityType"
      }]
    };
  }, []);
  return /*#__PURE__*/React.createElement("div", {
    className: 'cross-entity-search'
  }, /*#__PURE__*/React.createElement("div", {
    className: 'search-term'
  }, /*#__PURE__*/React.createElement(TextSearch, {
    display: 'Search entities',
    touched: !_.isEmpty(searchTerm),
    currentValue: searchTerm,
    additionalOptions: searchEntities,
    onChange: setSearchTerm,
    onFetch: onFetch,
    isFetching: fetching
  }), _.isEmpty(fetchedEntities) && /*#__PURE__*/React.createElement("div", {
    className: 'no-results'
  }, "No results fetched")), /*#__PURE__*/React.createElement("div", {
    className: clsx('search-results', _.isEmpty(fetchedEntities) && 'collapsed')
  }, /*#__PURE__*/React.createElement(EntityListView, {
    config: config,
    entities: fetchedEntities,
    onDetail: navigate
  })));
};

var css_248z$1 = ".generic-iframe-container {\n  width: 100%;\n  height: 100%;\n  padding: 15px;\n}";
styleInject(css_248z$1);

var GenericIframe = function GenericIframe(_ref) {
  var url = _ref.url,
    allowFullscreen = _ref.allowFullscreen,
    width = _ref.width,
    height = _ref.height;
  var isValidConfig = function isValidConfig() {
    return !!url;
  };
  var component = /*#__PURE__*/React.createElement("div", null, "Loading");
  if (!isValidConfig()) {
    component = /*#__PURE__*/React.createElement("span", null, "Please provide a valid url configuration!");
  } else if (url) {
    var styles = {
      maxWidth: width ? width : '100%',
      minWidth: width ? width : '100%',
      minHeight: height ? height : '100%',
      maxHeight: height ? height : '100%'
    };
    component = /*#__PURE__*/React.createElement("iframe", {
      src: url,
      style: styles,
      className: "responsive-iframe",
      frameBorder: "0",
      allowFullScreen: !!allowFullscreen,
      allow: "xr-spatial-tracking"
    });
  }
  return /*#__PURE__*/React.createElement("div", {
    className: "generic-iframe-container"
  }, component);
};

var css_248z$2 = ".big-button-bar.horizontal {\n  height: 100%;\n  maxHeight: 100%;\n  padding-top: 50px;\n  display: grid;\n}\n\n.big-button-bar .big-button-bar-button {\n  display: grid;\n  grid-template-rows: 50% 50%;\n  grid-template-columns: 33% 66%;\n}\n.big-button-bar .big-button-bar-button.horizontal {\n  display: grid;\n  grid-template-rows: 25% 75%;\n  grid-template-columns: fit-content(50%) auto;\n}\n.big-button-bar img {\n  max-height: 150px;\n  cursor: pointer;\n}\n.big-button-bar h1 {\n  padding-top: 20px;\n  cursor: pointer;\n}\n.big-button-bar span {\n  cursor: pointer;\n}";
styleInject(css_248z$2);

var BigButtonBar = function BigButtonBar(props) {
  var orientation = props.orientation || "horizontal";
  var barClass = orientation == "horizontal" ? "big-button-bar horizontal" : "big-button-bar";
  var btnClass = orientation == "horizontal" ? "big-button-bar-button horizontal" : "big-button-bar-button";
  var doAction = function doAction(key) {
    props.dashboard.doAction(props.actions[key]);
  };
  var buttons = Object.entries(props.actions).map(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
      key = _ref2[0],
      a = _ref2[1];
    return /*#__PURE__*/React.createElement("div", {
      key: key,
      className: btnClass
    }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("img", {
      onClick: function onClick(e) {
        return doAction(key);
      },
      src: "/digitaltwin/" + a.icon
    })), /*#__PURE__*/React.createElement("div", {
      onClick: function onClick(e) {
        return doAction(key);
      }
    }, /*#__PURE__*/React.createElement("h1", null, a.title)), /*#__PURE__*/React.createElement("div", null), /*#__PURE__*/React.createElement("div", {
      onClick: function onClick(e) {
        return doAction(key);
      }
    }, /*#__PURE__*/React.createElement("span", null, a.text)));
  });
  var barStyle = {};
  if (orientation == "horizontal") {
    barStyle = {
      gridTemplateColumns: "repeat(".concat(buttons.length, ", ").concat(100 / buttons.length, "%)")
    };
  }
  return /*#__PURE__*/React.createElement("div", {
    className: barClass,
    style: barStyle
  }, buttons);
};

var css_248z$3 = ".compact-button-bar {\n  display: flex;\n  align-items: center;\n  flex-direction: column;\n  justify-content: flex-start;\n  min-height: 100%;\n}\n.compact-button-bar.horizontal {\n  flex-direction: row;\n  min-height: auto;\n}\n.compact-button-bar .compact-button-bar-button {\n  display: inline-flex;\n  flex-direction: row;\n  border-radius: 10px;\n  box-shadow: -1px 1px 15px 0px rgba(166, 163, 166, 0.66);\n  padding: 5px 10px;\n  align-items: center;\n  cursor: pointer;\n  width: 100%;\n  height: 100px;\n  margin-bottom: 10px;\n}\n.compact-button-bar .compact-button-bar-button.horizontal {\n  margin-right: 20px;\n}\n.compact-button-bar .compact-button-bar-image {\n  flex: 1;\n  margin-left: 10px;\n}\n.compact-button-bar .compact-button-bar-button-text-container {\n  flex: 3;\n  font-size: 10px;\n}\n.compact-button-bar img {\n  height: 45px;\n}\n.compact-button-bar .compact-button-text {\n  font-size: 13px;\n}";
styleInject(css_248z$3);

var CompactButtonBar = function CompactButtonBar(props) {
  var orientation = props.orientation || "horizontal";
  var barClass = orientation == "horizontal" ? "compact-button-bar horizontal" : "compact-button-bar";
  var btnClass = orientation == "horizontal" ? "compact-button-bar-button horizontal" : "compact-button-bar-button";
  var doAction = function doAction(key) {
    props.dashboard.doAction(props.actions[key]);
  };
  var buttons = Object.entries(props.actions).map(function (_ref) {
    var _props$dashboard;
    var _ref2 = _slicedToArray(_ref, 2),
      key = _ref2[0],
      a = _ref2[1];
    return /*#__PURE__*/React.createElement("div", {
      key: key,
      className: btnClass,
      onClick: function onClick(e) {
        return doAction(key);
      }
    }, /*#__PURE__*/React.createElement("div", {
      className: "compact-button-bar-image"
    }, /*#__PURE__*/React.createElement("img", {
      src: (props !== null && props !== void 0 && (_props$dashboard = props.dashboard) !== null && _props$dashboard !== void 0 && (_props$dashboard = _props$dashboard.props) !== null && _props$dashboard !== void 0 && (_props$dashboard = _props$dashboard.selectedItems) !== null && _props$dashboard !== void 0 && (_props$dashboard = _props$dashboard.ipaConfig) !== null && _props$dashboard !== void 0 && (_props$dashboard = _props$dashboard.referenceAppConfig) !== null && _props$dashboard !== void 0 && _props$dashboard.refApp ? "/reference/" : "/digitaltwin/") + a.icon
    })), /*#__PURE__*/React.createElement("div", {
      className: "compact-button-bar-button-text-container"
    }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("h1", null, a.title)), /*#__PURE__*/React.createElement("div", {
      className: "compact-button-text"
    }, a.text)));
  });
  var barStyle = {};
  return /*#__PURE__*/React.createElement("div", {
    className: barClass,
    style: barStyle
  }, buttons);
};

var css_248z$4 = ".cell p {\n  padding: 0;\n  margin: 0;\n}\n.cell .cell__content--text, .cell .cell__content--date, .cell .cell__content--datetime, .cell .cell__content--number {\n  text-overflow: ellipsis;\n  overflow: hidden;\n  white-space: nowrap;\n}\n.cell .cell__content--tag {\n  background-color: #333;\n  color: var(--white);\n  margin-right: 4px;\n  padding: 2px 4px;\n  border-radius: 4px;\n  white-space: nowrap;\n}";
styleInject(css_248z$4);

var parseTextCell = function parseTextCell(val) {
  return isValidUrl(val) ? /*#__PURE__*/React.createElement("a", {
    href: val,
    target: "_blank"
  }, val) : val;
};
var parseDateCell = function parseDateCell(val) {
  var d = new Date(val);
  return d.toLocaleDateString();
};
var parseDatetimeCell = function parseDatetimeCell(val) {
  var d = new Date(val);
  return d.toLocaleString();
};
var TYPE_WITH_TOOLTIP = ["text", "date", "datetime"];
var wrapWithTooltip = function wrapWithTooltip(type, element) {
  if (!TYPE_WITH_TOOLTIP.includes(type)) {
    return element;
  }
  return /*#__PURE__*/React.createElement(Tooltip, {
    key: "cell-tooltip",
    title: element,
    placement: "bottom-start",
    enterDelay: 500
  }, element);
};
var getCellContent = function getCellContent(type, val) {
  switch (type) {
    case "text":
      return /*#__PURE__*/React.createElement("p", {
        className: "cell__content cell__content--text"
      }, parseTextCell(val));
    case "date":
      return /*#__PURE__*/React.createElement("p", {
        className: "cell__content cell__content--date"
      }, parseDateCell(val));
    case "datetime":
      return /*#__PURE__*/React.createElement("p", {
        className: "cell__content cell__content--datetime"
      }, parseDatetimeCell(val));
    case "tags":
      return /*#__PURE__*/React.createElement("div", {
        className: "cell__content cell__content--tags"
      }, val.map(function (tag) {
        return /*#__PURE__*/React.createElement("span", {
          className: "cell__content cell__content--tag"
        }, tag);
      }));
    default:
      return val;
  }
};
function Cell(props) {
  var cellContent = getCellContent(props.type, props.val);
  return /*#__PURE__*/React.createElement("div", {
    className: "cell ".concat(props.className || "")
  }, wrapWithTooltip(props.type, cellContent));
}

var css_248z$5 = "table {\n  table-layout: fixed;\n}\ntable td, table th {\n  padding: 0px 8px;\n}";
styleInject(css_248z$5);

function Table(_ref) {
  var rows = _ref.rows,
    className = _ref.className,
    headers = _ref.headers,
    options = _ref.options;
  var hasData = rows && rows.length > 0;
  return /*#__PURE__*/React.createElement("table", {
    className: className
  }, /*#__PURE__*/React.createElement("tbody", null, headers && /*#__PURE__*/React.createElement("tr", null, headers === null || headers === void 0 ? void 0 : headers.map(function (header) {
    return /*#__PURE__*/React.createElement("th", {
      key: header
    }, /*#__PURE__*/React.createElement(Cell, {
      type: "text",
      val: header
    }));
  })), hasData && rows.map(function (row, idx) {
    return /*#__PURE__*/React.createElement("tr", {
      key: idx
    }, row.map(function (cell, idx) {
      return /*#__PURE__*/React.createElement("td", {
        key: idx
      }, /*#__PURE__*/React.createElement(Cell, {
        type: cell.type,
        val: cell.val,
        className: cell.className
      }));
    }));
  }), !hasData && /*#__PURE__*/React.createElement("tr", null, /*#__PURE__*/React.createElement("td", {
    colSpan: headers === null || headers === void 0 ? void 0 : headers.length,
    className: "table__empty-message ".concat((options === null || options === void 0 ? void 0 : options.emptyMessageClassName) || "")
  }, options === null || options === void 0 ? void 0 : options.emptyMessage))));
}

export { BigButtonBar as B, ChartStack as C, GenericIframe as G, Table as T, Cell as a, CompactButtonBar as b, CrossEntitySearch as c };
