import { _ as _asyncToGenerator, a as _regenerator, b as _toArray, c as _arrayLikeToArray, d as _slicedToArray, s as styleInject, e as _inherits, f as _createClass, g as _objectSpread2, h as _classCallCheck, i as _callSuper, j as _toConsumableArray } from './style-inject.es-ebcb980f.js';
import React, { useRef, useEffect } from 'react';
import _$1 from 'lodash';
import * as PlatformApi from '@dtplatform/platform-api';
import { IafFileSvc, IafProj, IafFile, IafSession } from '@dtplatform/platform-api';
import JSZip from 'jszip';
import FileSaver from 'file-saver';
import Button from '@mui/material/Button';
import { IafScriptEngine } from '@dtplatform/iaf-script-engine';
import * as UiUtils from '@dtplatform/ui-utils';
import 'immer';
import Select from 'react-select';
import enhanceWithClickOutside from 'react-click-outside';
import DatePicker from 'react-date-picker';
import DateTimePicker from 'react-datetime-picker';
import moment from 'moment';

function downloadDocuments(_x) {
  return _downloadDocuments.apply(this, arguments);
}
function _downloadDocuments() {
  _downloadDocuments = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4(fileItems) {
    var fileUrls, urlPromises, i;
    return _regenerator().w(function (_context4) {
      while (1) switch (_context4.n) {
        case 0:
          console.log('fileItems', fileItems);
          fileUrls = [];
          urlPromises = [];
          for (i = 0; i < fileItems.length; i++) {
            urlPromises.push(IafFileSvc.getFileUrl(fileItems[i]._fileId).then(function (urlObj) {
              fileUrls.push(urlObj);
            }));
          }
          Promise.all(urlPromises).then(/*#__PURE__*/_asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3() {
            var urlFetchPromises, allFileBuffs, _i;
            return _regenerator().w(function (_context3) {
              while (1) switch (_context3.n) {
                case 0:
                  if (fileUrls.length === 1) window.location.href = fileUrls[0]._url;else if (fileUrls.length > 1) {
                    urlFetchPromises = [];
                    allFileBuffs = {};
                    for (_i = 0; _i < fileUrls.length; _i++) {
                      urlFetchPromises.push(fetch(fileUrls[_i]._url).then(function (resp) {
                        return new Promise(function (resolve, reject) {
                          resp.arrayBuffer().then(function (buff) {
                            resolve({
                              buff: buff,
                              resp: resp
                            });
                          });
                        });
                      }).then(function (bufferInfo) {
                        return new Promise(function (resolve, reject) {
                          var fileUrlObj = _$1.find(fileUrls, {
                            _url: bufferInfo.resp.url
                          });
                          allFileBuffs[fileUrlObj._name] = bufferInfo.buff;
                          resolve(bufferInfo.buff);
                        });
                      }));
                    }
                    Promise.all(urlFetchPromises).then(function () {
                      var buffs = Object.keys(allFileBuffs);
                      var zip = new JSZip();
                      buffs.forEach(function (filebuff) {
                        var fileToZip = new File([allFileBuffs[filebuff]], filebuff);
                        zip.file(filebuff, fileToZip, {
                          binary: true
                        });
                      });
                      zip.generateAsync({
                        type: 'blob'
                      }).then(function (zippedContent) {
                        FileSaver.saveAs(zippedContent, 'DownloadedFiles.zip');
                      });
                    });
                  }
                case 1:
                  return _context3.a(2);
              }
            }, _callee3);
          })));
        case 1:
          return _context4.a(2);
      }
    }, _callee4);
  }));
  return _downloadDocuments.apply(this, arguments);
}
var getFileUrlForFilename = /*#__PURE__*/function () {
  var _ref = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(filename) {
    var project;
    return _regenerator().w(function (_context) {
      while (1) switch (_context.n) {
        case 0:
          project = IafProj.getCurrent();
          return _context.a(2, IafFile.getFileItems(project.rootContainer, {
            name: filename
          }).then(function (fileItems) {
            var fileItem = _$1.find(fileItems._list, {
              name: filename
            });
            var fileVersion = _$1.find(fileItem.versions, {
              versionNumber: fileItem.tipVersionNumber
            });
            return IafFileSvc.getFileVersionUrl(fileItem._fileId, fileVersion._fileVersionId).then(function (result) {
              return result._url;
            });
          }));
      }
    }, _callee);
  }));
  return function getFileUrlForFilename(_x2) {
    return _ref.apply(this, arguments);
  };
}();

//need to fix this, it defaults to to returning the fist version and not the latest
var getFileUrl = /*#__PURE__*/function () {
  var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(fileId, versionId) {
    var result, _t, _t2, _t3;
    return _regenerator().w(function (_context2) {
      while (1) switch (_context2.n) {
        case 0:
          _t = IafFileSvc;
          _t2 = fileId;
          if (!versionId) {
            _context2.n = 1;
            break;
          }
          _t3 = versionId;
          _context2.n = 3;
          break;
        case 1:
          _context2.n = 2;
          return IafFileSvc.getFileVersions(fileId)._list[0]._id;
        case 2:
          _t3 = _context2.v;
        case 3:
          _context2.n = 4;
          return _t.getFileVersionUrl.call(_t, _t2, _t3);
        case 4:
          result = _context2.v;
          return _context2.a(2, result._url);
      }
    }, _callee2);
  }));
  return function getFileUrl(_x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}();
var FileHelpers = {
  downloadDocuments: downloadDocuments,
  getFileUrlForFilename: getFileUrlForFilename,
  getFileUrl: getFileUrl
};

var getPlatform = function getPlatform(platformOverride) {
  var isCordova = typeof Meteor !== 'undefined' && Meteor.isCordova;
  var iOS = {
    isIOS: true,
    isAndroid: false,
    isCordova: isCordova,
    transitionTimeOut: 450,
    name: 'iOS'
  };
  var android = {
    isIOS: false,
    isAndroid: true,
    isCordova: isCordova,
    transitionTimeOut: 320,
    name: 'Android'
  };

  // jl override to test various iOS components
  //if (platformOverride === 'iOS') { return iOS; }
  if (!platformOverride) {
    return iOS;
  }
  if (typeof cordova !== 'undefined' && cordova.platformId === 'ios') {
    return iOS;
  }
  if (!!navigator.userAgent.match(/iPad/i) || !!navigator.userAgent.match(/iPhone/i) || !!navigator.userAgent.match(/iPod/i)) {
    return iOS;
  }
  if (platformOverride === 'Android') {
    return android;
  }
  if (typeof cordova !== 'undefined' && cordova.platformId === 'android') {
    return android;
  }
  if (navigator.userAgent.indexOf('Android') > 0) {
    return android;
  }
  return {
    isIOS: false,
    isAndroid: false,
    isCordova: isCordova,
    transitionTimeOut: 450,
    name: 'Web'
  };
};
function parseQuery(queryString) {
  var query = {};
  var pairs = (queryString[0] === '?' ? queryString.substr(1) : queryString).split('&');
  for (var i = 0; i < pairs.length; i++) {
    var pair = pairs[i].split('=');
    query[decodeURIComponent(pair[0])] = decodeURIComponent(pair[1] || '');
  }
  return query;
}
function getTitleBarInfoFromProps(pageName, props) {
  return {
    pageName: pageName,
    projectName: _$1.get(props, 'selectedItems.selectedProject._name', ""),
    switchProject: props.actions ? props.actions.reloadConfig : null,
    userName: props.user ? props.user._firstname + " " + props.user._lastname : "",
    logout: props.actions ? props.actions.userLogout : null
  };
}
var getRandomString = function getRandomString(prefix) {
  return (prefix || "") + Math.random().toString(36).substring(2, 15);
};
var group = function group(assets, groupProperty, getPropertyValue) {
  return assets.reduce(function (result, a) {
    var groupName = getPropertyValue(a, groupProperty) || "".concat(groupProperty, " not set");
    var groupContents = result[groupName] || [];
    groupContents.push(a);
    result[groupName] = groupContents;
    return result;
  }, {});
};
var _nestedGroup = function nestedGroup(values, keys, getPropertyValue) {
  if (!keys.length) return values;
  var _keys = _toArray(keys),
    groupKey = _keys[0],
    remainingKeys = _arrayLikeToArray(_keys).slice(1);
  var entries = Object.entries(group(values, groupKey, getPropertyValue));
  entries.sort(function (a, b) {
    return a[0].localeCompare(b[0]);
  });
  return entries.reduce(function (result, _ref) {
    var _ref2 = _slicedToArray(_ref, 2),
      groupName = _ref2[0],
      groupValues = _ref2[1];
    result[groupName] = _nestedGroup(groupValues, remainingKeys, getPropertyValue);
    return result;
  }, {});
};
var isValidUrl = function isValidUrl(testString) {
  var url = null;
  try {
    url = new URL(testString);
  } catch (err) {
    return false;
  }
  return url.protocol === 'http:' || url.protocol === 'https:';
};
var makePromiseIgnorable = function makePromiseIgnorable(promise) {
  var hadIgnored = false;
  var wrappedPromise = new Promise(function (resolve, reject) {
    promise.then(function (val) {
      return hadIgnored ? reject({
        isIgnored: true
      }) : resolve(val);
    })["catch"](function (error) {
      return hadIgnored ? reject({
        isIgnored: true
      }) : reject(error);
    });
  });
  return {
    promise: wrappedPromise,
    ignore: function ignore() {
      hadIgnored = true;
    }
  };
};

var css_248z = ".GenericMatButton button {\n  -webkit-transition: background-color 1s linear;\n  -moz-transition: background-color 1s linear;\n  -o-transition: background-color 1s linear;\n  transition: background-color 1s linear;\n}\n\n.attention {\n  background-color: var(--app-accent-color) !important;\n  color: white !important;\n}";
styleInject(css_248z);

var GenericMatButton = /*#__PURE__*/function (_React$Component) {
  function GenericMatButton() {
    _classCallCheck(this, GenericMatButton);
    return _callSuper(this, GenericMatButton, arguments);
  }
  _inherits(GenericMatButton, _React$Component);
  return _createClass(GenericMatButton, [{
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement("div", {
        className: "GenericMatButton ".concat(this.props.className)
      }, /*#__PURE__*/React.createElement(Button, {
        variant: "contained",
        size: this.props.size,
        style: _objectSpread2({}, this.props.styles),
        onClick: this.props.onClick,
        disabled: this.props.disabled,
        className: this.props.customClasses,
        sx: _objectSpread2({
          "padding": "6px 16px !important"
        }, !this.props.disabled && {
          '&.MuiButton-contained': {
            color: 'rgba(0, 0, 0, 0.87)',
            boxShadow: '0px 3px 1px -2px rgba(0,0,0,0.2), 0px 2px 2px 0px rgba(0,0,0,0.14), 0px 1px 5px 0px rgba(0,0,0,0.12)',
            backgroundColor: '#e0e0e0'
          }
        })
      }, this.props.children));
    }
  }]);
}(React.Component);

function loadScript(_x, _x2) {
  return _loadScript.apply(this, arguments);
} // async function evalExpressions(str, operand, ctx) {
//   let res = await expression.evalExpressions(eval(str), operand, ctx || _expressionExecCtx);
//   return res;
// }
// Internal function for executing a script and (optionally) retrieving a scriptResVar
// async function _execScript(scriptName, operand, scriptResVar, ctx) {
//   let scriptRes = await expression.execScript(scriptName, operand, scriptResVar, ctx);
//   return scriptRes;
// }
function _loadScript() {
  _loadScript = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(query, ctx) {
    var _ctx, criteria, scriptModule, loadedScripts;
    return _regenerator().w(function (_context) {
      while (1) switch (_context.n) {
        case 0:
          console.log('ScriptHelper loadScript query', query);
          if (query) {
            _context.n = 1;
            break;
          }
          console.warn("ScriptHelper loadScript: No script query in loadScript");
          return _context.a(2);
        case 1:
          if (!isProjectNextGenJs()) {
            _context.n = 6;
            break;
          }
          _ctx = {
            _namespaces: IafProj.getCurrent()._namespaces,
            authToken: IafSession.getAuthToken()
          };
          criteria = {
            query: {
              _userType: query._userType
            }
          };
          console.log('ScriptHelper loadScript criteria', criteria);
          _context.n = 2;
          return IafScriptEngine.dynamicImport(criteria, _ctx);
        case 2:
          scriptModule = _context.v;
          if (!scriptModule) {
            _context.n = 5;
            break;
          }
          console.log("ScriptHelper loadScript scriptModule", scriptModule);
          _context.n = 3;
          return IafScriptEngine.getVar('loadedScripts');
        case 3:
          loadedScripts = _context.v;
          console.log("ScriptHelper loadScript loadedScripts", loadedScripts);
          if (!loadedScripts) loadedScripts = scriptModule["default"];else loadedScripts = _.assign({}, loadedScripts, scriptModule["default"]);
          console.log("ScriptHelper loadScript loadedScripts2", loadedScripts);
          _context.n = 4;
          return IafScriptEngine.setVar('loadedScripts', loadedScripts);
        case 4:
          _context.n = 6;
          break;
        case 5:
          console.warn("ScriptHelper loadScript: No script type ".concat(query._userType, " found."));
        case 6:
          return _context.a(2);
      }
    }, _callee);
  }));
  return _loadScript.apply(this, arguments);
}
function executeScript(_x3, _x4, _x5, _x6, _x7) {
  return _executeScript.apply(this, arguments);
} // async function executeScriptCallback(callbackName, operand, scriptResVar, ctx) {
//   let scriptName = getScriptVar(callbackName, ctx || _expressionExecCtx);
//   let scriptRes;
//   if (scriptName) {
//     scriptRes = await _execScript(scriptName, operand, scriptResVar, ctx || _expressionExecCtx);
//   }
//   return scriptRes;
// }
// function getScriptVar(scriptVar, ctx) {
//   if (isProjectNextGenJs())
//     return IafScriptEngine.getVar(scriptVar)
//   else
//     return expression.getHeapVar(scriptVar, ctx || _expressionExecCtx);
// }
// function setScriptVar(scriptVar, value, ctx) {
//   if (isProjectNextGenJs())
//     return IafScriptEngine.setVar(scriptVar, value)
//   else
//     return expression.setHeapVar(scriptVar, value, ctx || _expressionExecCtx);
// }
// Replacements for the above; decouple from IAF_EXT_ specifics.  jl 01/26/19
// This returns a function that can be used on an array.filter call
// function getFilterFunction (filters, filterOpts) {
//   return sift.getFilter(filters, filterOpts);
// }
// This returns a query object compatible with BE queries (and FE sift)
// function getFilterQuery (filters, filterOpts) {
//   return sift.getFilterQuery(filters, filterOpts);
// }
// Set up a sort of "global" expression exec context in the browser;  jl 08/04/2019
// let _expressionExecCtx;
// function initExpressionExecCtx() {
//   _expressionExecCtx = expression.getExpressionExecCtx();
// }
// function releaseExpressionExecCtx() {
//   expression.releaseExpressionExecCtx(_expressionExecCtx);
// }
// function getScriptOperators() {
//   return expression.getOperators()
// }
function _executeScript() {
  _executeScript = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(scriptName, operand, scriptResVar, ctx, callback) {
    var loadedScripts, overloadedPlatformApi, libraries, result;
    return _regenerator().w(function (_context2) {
      while (1) switch (_context2.n) {
        case 0:
          if (!isProjectNextGenJs()) {
            _context2.n = 4;
            break;
          }
          //execute js script
          loadedScripts = IafScriptEngine.getVar('loadedScripts');
          console.log("ScriptHelper executeScript loadedScripts", loadedScripts);
          if (loadedScripts) {
            _context2.n = 1;
            break;
          }
          console.error("loadedScripts is undefined");
          _context2.n = 4;
          break;
        case 1:
          if (loadedScripts[scriptName]) {
            _context2.n = 2;
            break;
          }
          //log console error and throw exception
          console.error("executeScript \"".concat(scriptName, "\" not found on loadedScripts "));
          _context2.n = 4;
          break;
        case 2:
          //Now that iaf-script-engine lies outside of PlatformAPI we have to put it back to keep scripts compatible
          overloadedPlatformApi = _objectSpread2(_objectSpread2({}, PlatformApi), {}, {
            IafScriptEngine: IafScriptEngine
          });
          libraries = {
            PlatformApi: overloadedPlatformApi,
            UiUtils: UiUtils,
            IafScriptEngine: IafScriptEngine
          };
          console.log("ScriptHelper executeScript libraries", libraries);
          result = loadedScripts[scriptName](operand, libraries, ctx, callback);
          result = Promise.resolve(result);
          _context2.n = 3;
          return result;
        case 3:
          result = _context2.v;
          console.log(scriptName + " loadedScript result:", result);
          return _context2.a(2, result);
        case 4:
          return _context2.a(2);
      }
    }, _callee2);
  }));
  return _executeScript.apply(this, arguments);
}
function isProjectNextGenJs() {
  var sessionProject = JSON.parse(sessionStorage.getItem('project'));
  console.log("sessionProject", sessionProject);
  if (sessionProject._userAttributes.hasOwnProperty('nextScriptEngine')) {
    console.log("sessionProject._userAttributes.nextScriptEngine", sessionProject._userAttributes.nextScriptEngine);
    return sessionProject._userAttributes.nextScriptEngine;
  } else {
    var _currentProject$_user;
    var currentProject = IafProj.getCurrent();
    console.log("currentProject", currentProject);
    return currentProject !== null && currentProject !== void 0 && (_currentProject$_user = currentProject._userAttributes) !== null && _currentProject$_user !== void 0 && _currentProject$_user.nextScriptEngine ? currentProject._userAttributes.nextScriptEngine : false;
  }
}
var ScriptHelper = {
  loadScript: loadScript,
  // evalExpressions: evalExpressions,
  executeScript: executeScript,
  // executeScriptCallback: executeScriptCallback,
  // getScriptVar: getScriptVar,
  // setScriptVar: setScriptVar,
  // getFilterFunction: getFilterFunction,
  // getFilterQuery: getFilterQuery, 
  // initExpressionExecCtx: initExpressionExecCtx,
  // releaseExpressionExecCtx: releaseExpressionExecCtx,
  // getScriptOperators: getScriptOperators,
  isProjectNextGenJs: isProjectNextGenJs
};

var TreeNodeStatus = {
  ON: 'on',
  PARTIAL: 'partial',
  OFF: 'off'
};
var TreeNodeActionName = {
  PROPAGATE_UP: 'propagateNodeStatusUp',
  PROPAGATE_DOWN: 'propagateNodeStatusDown'
};
var defaultLeafRenderer = function defaultLeafRenderer(_ref, toggleCurrentNode) {
  var nodeValue = _ref.nodeValue;
  return nodeValue && /*#__PURE__*/React.createElement("div", null, nodeValue["Entity Name"], nodeValue["EntityWarningMessage"] && /*#__PURE__*/React.createElement("div", {
    className: "tooltip-wrapper"
  }, /*#__PURE__*/React.createElement("div", {
    className: "dbm-tooltip"
  }, /*#__PURE__*/React.createElement("i", {
    className: "fas fa-exclamation-circle"
  }), /*#__PURE__*/React.createElement("span", {
    className: "dbm-tooltiptext"
  }, nodeValue["EntityWarningMessage"]))));
};
var defaultBranchRenderer = function defaultBranchRenderer(_ref2, childrenCount, toggleCurrentNode) {
  var nodeValue = _ref2.nodeValue;
  return /*#__PURE__*/React.createElement("span", null, nodeValue, /*#__PURE__*/React.createElement("span", {
    className: "count",
    style: {
      fontSize: "0.8em"
    }
  }, childrenCount));
};
var withoutPropagation = function withoutPropagation(whatToDo) {
  return function (e) {
    e.stopPropagation();
    whatToDo();
  };
};
var _propagateNodeStatusDown = function propagateNodeStatusDown(property) {
  return function (nodeIndex, nodeId, newNodeStatus) {
    var selectedNode = nodeIndex[nodeId];
    if (selectedNode) {
      selectedNode[property] = newNodeStatus;
      var off = _$1.get(selectedNode, "treeActions.".concat(property, ".").concat(TreeNodeActionName.PROPAGATE_DOWN), TreeNodeStatus.ON) === TreeNodeStatus.OFF;
      if (off) {
        return;
      }
      selectedNode.children.forEach(function (childName) {
        return _propagateNodeStatusDown(property)(nodeIndex, childName, newNodeStatus);
      });
    }
  };
};
var propagateNodeStatusUp = function propagateNodeStatusUp(property) {
  return function (nodeIndex, nodeId) {
    var selectedNode = nodeIndex[nodeId];
    var off = _$1.get(selectedNode, "treeActions.".concat(property, ".").concat(TreeNodeActionName.PROPAGATE_UP), TreeNodeStatus.ON) === TreeNodeStatus.OFF;
    if (off) {
      return;
    }
    selectedNode.parents.slice().reverse().forEach(function (parentName) {
      return recalculateNodeStatus(property)(nodeIndex, parentName);
    });
  };
};
var recalculateNodeStatus = function recalculateNodeStatus(property) {
  return function (nodeIndex, nodeId) {
    var currentNode = nodeIndex[nodeId];
    var children = currentNode.children.map(function (childName) {
      return nodeIndex[childName];
    });
    if (children.every(function (childNode) {
      return childNode[property] === TreeNodeStatus.ON;
    })) {
      currentNode[property] = TreeNodeStatus.ON;
    } else if (children.every(function (childNode) {
      return childNode[property] === TreeNodeStatus.OFF;
    })) {
      currentNode[property] = TreeNodeStatus.OFF;
    } else {
      currentNode[property] = TreeNodeStatus.PARTIAL;
    }
  };
};

var curriedFlip = function curriedFlip(f) {
  return function (a) {
    return function (b) {
      return f(b)(a);
    };
  };
};

var Operators = {
  startsWith: "startsWith",
  endsWith: "endsWith",
  contains: "contains",
  doesNotStartsWith: "doesNotStartsWith",
  doesNotEndsWith: "doesNotEndsWith",
  doesNotContains: "doesNotContains",
  lessThan: "lessThan",
  lessThanEquals: "lessThanEquals",
  greaterThan: "greaterThan",
  greaterThanEquals: "greaterThanEquals",
  equals: "equals",
  notEquals: "notEquals",
  exists: "exists",
  inRange: "inRange",
  outOfRange: "outOfRange"
};
var QueryBuilders = {
  startsWith: function startsWith(q) {
    return buildRegex(q, "^{value}");
  },
  endsWith: function endsWith(q) {
    return buildRegex(q, "{value}$");
  },
  contains: function contains(q) {
    return buildRegex(q, "{value}");
  },
  doesNotStartsWith: function doesNotStartsWith(q) {
    return buildRegex(q, "^(?!{value})");
  },
  doesNotEndsWith: function doesNotEndsWith(q) {
    return buildRegex(q, "(?<!{value})$");
  },
  doesNotContains: function doesNotContains(q) {
    return buildRegex(q, "^((?!{value}).)*$");
  },
  lessThan: function lessThan(q) {
    return buildRelationalOps(q, "$lt");
  },
  lessThanEquals: function lessThanEquals(q) {
    return buildRelationalOps(q, "$lte");
  },
  greaterThan: function greaterThan(q) {
    return buildRelationalOps(q, "$gt");
  },
  greaterThanEquals: function greaterThanEquals(q) {
    return buildRelationalOps(q, "$gte");
  },
  equals: function equals(q) {
    return q.type == "text" ? buildRegex(q, "^{value}$") : buildRelationalOps(q, "$eq");
  },
  notEquals: function notEquals(q) {
    return q.type == "text" ? buildRegex(q, "^(?!{value}$)") : buildRelationalOps(q, "ne");
  },
  exists: function exists(q) {
    return buildRelationalOps(q, "$exists");
  },
  inRange: function inRange(q) {
    return buildRelationalRangeOp(q, true);
  },
  outOfRange: function outOfRange(q) {
    return buildRelationalRangeOp(q, false);
  }
};
function buildRelationalOps(q, op) {
  var query = {};
  query[q.property] = {};
  query[q.property][op] = q.value;
  return query;
}
function buildRelationalRangeOp(q, inRange) {
  var rangeStart = buildRelationalOps({
    property: q.property,
    value: q.value.from
  }, inRange ? "$gte" : "$lt");
  var rangeEnd = buildRelationalOps({
    property: q.property,
    value: q.value.to
  }, inRange ? "$lte" : "$gt");
  var op = inRange ? "$and" : "$or";
  var query = {};
  query[op] = [rangeStart, rangeEnd];
  return query;
}
function escapeRegExp(string) {
  return string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&'); // $& means the whole matched string
}
function buildRegex(q, pattern) {
  var query = {};
  query[q.property] = {
    "$regex": pattern.replace("{value}", escapeRegExp(q.value))
  };
  if (q.options) {
    query[q.property]["$options"] = q.options;
  }
  return query;
}

/**
 * @example
 *
 *  // Usage
 *  let operators = AdvSearchQueryBuilder.Operators;
 *  let query = [
 *      {property: "dtCategory", op:operators.contains, value: "Internal"},
 *      {property: "warrantyExpireDate", op:operators.lessThanEquals, value: 1585840038649}
 *  ]
 *
 *  let criteria = {query: AdvSearchQueryBuilder.build(query)};
 *  let res = await IafItemSvc.getRelatedItems(userCollection._id, criteria, ctx);
 *
 *
 * //Sample Queries, By default its case sensitive
 *
 *  [
 *      {property: "dtCategory", op:operators.startsWith, value: "Window"},
 *      {property: "dtCategory", op:operators.endsWith, value: "Bell"}
 *  ]
 *
 * // Case insensitive, use options: "i"
 *
 *  [
 *      {property: "dtCategory", op:operators.startsWith, value: "window", options:"i"},
 *      {property: "dtCategory", op:operators.endsWith, value: "Bell"}
 *  ]
 *
 * // Numbers
 *  [
 *      {property: "warrantyExpireDate", op:operators.greaterThanEquals, value: 1585840038649},
 *      {property: "warrantyExpireDate", op:operators.lessThanEquals, value: 1585840038649}
 *  ]
 *

 * @param query
 * @return {{$and: Array}}
 */
function build(query) {
  var op = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "$and";
  if (!query || query.length == 0) {
    console.warn("query is empty");
    return;
  }
  var andQ = [];
  query.forEach(function (q) {
    if (!q.property || !q.op) {
      throw new Error("Either property or op is missing");
    }
    andQ.push(QueryBuilders[q.op](q));
  });
  var result = {};
  result[op] = andQ;
  return result;
}
var AdvSearchQueryBuilder = {
  Operators: Operators,
  build: build
};

var css_248z$1 = ".filter-container {\n  display: inline-block;\n  position: relative;\n  margin-bottom: 10px;\n  max-width: 400px;\n}\n.filter-container .control {\n  background-color: white;\n  display: inline-block;\n  border: solid #e6e6e6 2px;\n  border-radius: 4px;\n  min-width: 265px;\n  min-height: 38px;\n  position: relative;\n}\n.filter-container .control div {\n  display: inline-block;\n}\n.filter-container .control .placeholder {\n  color: gray;\n  padding: 6px;\n}\n.filter-container .control .buttons {\n  position: absolute;\n  right: 0;\n  color: lightgray;\n}\n.filter-container .control .buttons svg {\n  display: inline-block;\n  fill: currentColor;\n  line-height: 1;\n  stroke: currentColor;\n  stroke-width: 0;\n}\n.filter-container .control .buttons div {\n  margin: 7px 0px;\n  padding: 0 8px;\n  border-left: solid lightgray 1px;\n}\n.filter-container .control .buttons div:first-child {\n  border-left: none;\n}\n.filter-container .filter-drop-down-panel.hidden {\n  display: none;\n}\n.filter-container .filter-drop-down-panel {\n  position: absolute;\n  background-color: white;\n  border: solid #e6e6e6 2px;\n  padding: 20px;\n  width: 300px;\n  z-index: 2;\n  margin-top: 10px;\n  border-radius: 4px;\n}\n.filter-container .filter-drop-down-panel .filter-input-value {\n  display: inline-block;\n  width: 256px;\n  height: 38px;\n  border: solid #e6e6e6 2px;\n  border-radius: 2px;\n  margin-bottom: 10px;\n  padding: 10px;\n}\n.filter-container .filter-drop-down-panel .range label {\n  display: block;\n}\n.filter-container .filter-drop-down-panel .GenericMatButton {\n  display: inline-block;\n}\n.filter-container .filter-drop-down-panel .GenericMatButton button {\n  width: 105px;\n  margin: 10px;\n}\n.filter-container .available-filter {\n  display: grid;\n  grid-template-columns: 150px 100px auto 20px;\n  grid-gap: 10px;\n  margin: 5px;\n}\n.filter-container .filter-multi-select {\n  display: inline-block;\n}\n.filter-container .filter-multi-select-value {\n  display: inline-block;\n  background-color: hsl(0, 0%, 90%);\n  border-radius: 2px;\n  padding: 3px;\n  padding-left: 6px;\n  margin: 4px;\n  color: hsl(0, 0%, 20%);\n  font-size: 85%;\n  width: 75%;\n}";
styleInject(css_248z$1);

var FUNCTIONS = [
// these funcs take any type from a pick list of unique actual values
{
  name: "equals",
  input: "single-pick",
  types: "*",
  test: function test(propVal, filterVal) {
    return propVal === filterVal;
  }
}, {
  name: "in",
  input: "multi-pick",
  types: "*",
  test: function test(propVal, filterVal) {
    return filterVal.indexOf(propVal) >= 0;
  }
}, {
  name: "does not equal",
  input: "single-pick",
  types: "*",
  test: function test(propVal, filterVal) {
    return propVal !== filterVal;
  }
}, {
  name: "is not in",
  input: "multi-pick",
  types: "*",
  test: function test(propVal, filterVal) {
    return filterVal.indexOf(propVal) < 0;
  }
},
// these funcs take text input - all comparisons are case insensitive
{
  name: "starts with",
  input: "text",
  types: "|text|",
  test: function test(propVal, filterVal) {
    return propVal.toLowerCase().startsWith(new String(filterVal).toLowerCase());
  }
}, {
  name: "ends with",
  input: "text",
  types: "|text|",
  test: function test(propVal, filterVal) {
    return propVal.toLowerCase().endsWith(new String(filterVal).toLowerCase());
  }
}, {
  name: "contains",
  input: "text",
  types: "|text|",
  test: function test(propVal, filterVal) {
    return propVal.toLowerCase().indexOf(new String(filterVal).toLowerCase()) >= 0;
  }
}, {
  name: "does not start with",
  input: "text",
  types: "|text|",
  test: function test(propVal, filterVal) {
    return !propVal.toLowerCase().startsWith(new String(filterVal).toLowerCase());
  }
}, {
  name: "does not end with",
  input: "text",
  types: "|text|",
  test: function test(propVal, filterVal) {
    return !propVal.toLowerCase().endsWith(new String(filterVal).toLowerCase());
  }
}, {
  name: "does not contain",
  input: "text",
  types: "|text|",
  test: function test(propVal, filterVal) {
    return propVal.toLowerCase().indexOf(new String(filterVal).toLowerCase()) < 0;
  }
},
// these funcs take one or two numeric or date or datetime inputs
{
  name: "less than",
  input: "single",
  types: "|number|date|datetime|",
  test: function test(propVal, filterVal) {
    return propVal < filterVal;
  }
}, {
  name: "less than or equal to",
  input: "single",
  types: "|number|date|datetime|",
  test: function test(propVal, filterVal) {
    return propVal <= filterVal;
  }
}, {
  name: "greater than",
  input: "single",
  types: "|number|date|datetime|",
  test: function test(propVal, filterVal) {
    return propVal > filterVal;
  }
}, {
  name: "greater than or equal to",
  input: "single",
  types: "|number|date|datetime|",
  test: function test(propVal, filterVal) {
    return propVal >= filterVal;
  }
}, {
  name: "between",
  input: "range",
  types: "|number|date|datetime|",
  test: function test(propVal, filterVal) {
    return propVal >= filterVal.from && propVal <= filterVal.to;
  }
}, {
  name: "outside of",
  input: "range",
  types: "|number|date|datetime|",
  test: function test(propVal, filterVal) {
    return propVal < filterVal.from || propVal > filterVal.to;
  }
}];
var isNumericOp = function isNumericOp(op) {
  return (
    // op == "equals" ||
    // op == "does not equal" ||
    op == "less than" || op == "less than or equal to" || op == "greater than" || op == "greater than or equal to" || op == "between" || op == "outside of"
  );
};
var getFormattedDateFromTimestamp = function getFormattedDateFromTimestamp(ts, type) {
  var d = new Date(ts);
  if (type == "dateTime") return d.toLocaleString();else return d.toLocaleDateString();
};
var FilterControl = /*#__PURE__*/function (_React$Component) {
  function FilterControl(props) {
    var _this;
    _classCallCheck(this, FilterControl);
    _this = _callSuper(this, FilterControl, [props]);
    _this.onFilterChange = function (filters) {
      _this.setState({
        filters: filters
      });
      var allFilters = Object.keys(filters);
      var completeFilters = Object.assign({}, filters);
      allFilters.forEach(function (f) {
        if (!completeFilters[f].value) delete completeFilters[f];
      });
      _this.setState({
        completeFilters: completeFilters
      });
      _this.props.onChange(completeFilters);
    };
    _this.handleClickOutside = function () {
      document.querySelector(".filter-drop-down-panel." + _this.state.key).classList.add("hidden");
    };
    _this.state = {
      filters: Object.assign({}, _this.props.filters),
      completeFilters: Object.assign({}, _this.props.filters),
      key: getRandomString("filter-")
    };
    return _this;
  }
  _inherits(FilterControl, _React$Component);
  return _createClass(FilterControl, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (!_$1.isEqual(prevProps.filters, this.props.filters)) {
        //fire onFilterChange event ONLY for the same entity, changes in filters due to entity swap should be ignored
        if (_$1.isEqual(prevProps.entitySingular, this.props.entitySingular)) {
          this.onFilterChange(this.props.filters);
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement("div", {
        className: this.props.className == "assets-filter" ? "assets-filter-container" : "filter-container"
      }, /*#__PURE__*/React.createElement(CurrentFilters, {
        placeholder: this.props.placeholder,
        parentKey: this.state.key,
        filters: this.state.completeFilters,
        onChange: this.onFilterChange
      }), /*#__PURE__*/React.createElement(FilterDropDownPanel, {
        parentKey: this.state.key,
        styles: this.props.styles,
        filters: this.state.filters,
        available: this.props.availableFilters,
        functions: this.props.availableOperators,
        onChange: this.onFilterChange
      }));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var derivedState = _objectSpread2(_objectSpread2({}, prevState), {}, {
        filters: Object.assign({}, nextProps.filters),
        completeFilters: Object.assign({}, nextProps.filters)
      });
      return derivedState;
    }
  }]);
}(React.Component);
var CurrentFilters = function CurrentFilters(_ref) {
  var placeholder = _ref.placeholder,
    parentKey = _ref.parentKey,
    filters = _ref.filters,
    onChange = _ref.onChange;
  var togglePanel = function togglePanel() {
    document.querySelector(".filter-drop-down-panel." + parentKey).classList.toggle("hidden");
  };
  var clearFilters = function clearFilters(e) {
    e.stopPropagation();
    document.querySelector(".filter-drop-down-panel." + parentKey).classList.add("hidden");
    if (Object.keys(filters).length != 0) onChange({});
  };
  var removeFilter = function removeFilter(e, key) {
    e.stopPropagation();
    var newFilters = JSON.parse(JSON.stringify(filters));
    delete newFilters[key];
    onChange(newFilters);
  };
  var filterList = Object.entries(filters).map(function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
      key = _ref3[0],
      f = _ref3[1];
    var val = Array.isArray(f.value) ? f.value.join(",") : f.value;
    if (f.type == "date" || f.type == "datetime") {
      if (typeof val.to != 'undefined') {
        val = "".concat(getFormattedDateFromTimestamp(val.from, f.type), " and ").concat(getFormattedDateFromTimestamp(val.to, f.type));
      } else {
        val = getFormattedDateFromTimestamp(val, f.type);
      }
    } else if (typeof val.to != 'undefined') {
      val = "".concat(val.from, " and ").concat(val.to);
    }
    return /*#__PURE__*/React.createElement("div", {
      key: "applied-filter-" + key,
      className: "filter-multi-select-value"
    }, key, " ", f.op, " ", val, /*#__PURE__*/React.createElement("i", {
      className: "fas fa-times",
      style: {
        marginLeft: '8px'
      },
      onClick: function onClick(e) {
        return removeFilter(e, key);
      }
    }));
  });
  return /*#__PURE__*/React.createElement("div", {
    className: "control",
    onClick: togglePanel
  }, /*#__PURE__*/React.createElement("div", null, filterList.length ? filterList : /*#__PURE__*/React.createElement("div", {
    className: "placeholder"
  }, placeholder || "Choose filters")), /*#__PURE__*/React.createElement("div", {
    className: "buttons"
  }, /*#__PURE__*/React.createElement("svg", {
    onClick: clearFilters,
    height: "20",
    width: "20",
    viewBox: "0 0 20 20",
    "aria-hidden": "true",
    focusable: "false"
  }, /*#__PURE__*/React.createElement("path", {
    d: "M14.348 14.849c-0.469 0.469-1.229 0.469-1.697 0l-2.651-3.030-2.651 3.029c-0.469 0.469-1.229 0.469-1.697 0-0.469-0.469-0.469-1.229 0-1.697l2.758-3.15-2.759-3.152c-0.469-0.469-0.469-1.228 0-1.697s1.228-0.469 1.697 0l2.652 3.031 2.651-3.031c0.469-0.469 1.228-0.469 1.697 0s0.469 1.229 0 1.697l-2.758 3.152 2.758 3.15c0.469 0.469 0.469 1.229 0 1.698z"
  })), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("svg", {
    height: "20",
    width: "20",
    viewBox: "0 0 20 20",
    "aria-hidden": "true",
    focusable: "false"
  }, /*#__PURE__*/React.createElement("path", {
    d: "M4.516 7.548c0.436-0.446 1.043-0.481 1.576 0l3.908 3.747 3.908-3.747c0.533-0.481 1.141-0.446 1.574 0 0.436 0.445 0.408 1.197 0 1.615-0.406 0.418-4.695 4.502-4.695 4.502-0.217 0.223-0.502 0.335-0.787 0.335s-0.57-0.112-0.789-0.335c0 0-4.287-4.084-4.695-4.502s-0.436-1.17 0-1.615z"
  })))));
};
var FilterDropDownPanel = /*#__PURE__*/function (_React$Component2) {
  function FilterDropDownPanel(props) {
    var _this2;
    _classCallCheck(this, FilterDropDownPanel);
    _this2 = _callSuper(this, FilterDropDownPanel, [props]);
    _this2.defaultState = {
      selectedProperty: null,
      selectedFunction: null,
      selectedValue: null,
      availableFunctions: null,
      isReady: false
    };
    _this2.hide = function (el) {
      while (!el.classList.contains(_this2.props.parentKey)) el = el.parentElement;
      el.classList.add('hidden');
      _this2.setState(_this2.defaultState);
    };
    _this2.cancel = function (e) {
      _this2.hide(e.target);
    };
    _this2.add = function (e) {
      var copyOfFilters = _$1.cloneDeep(_this2.props.filters);
      var filter = copyOfFilters[_this2.state.selectedProperty] || {};
      var type = filter.op = _this2.state.selectedFunction;
      filter.value = _this2.state.selectedValue;
      filter.type = _this2.props.available[_this2.state.selectedProperty].type;
      copyOfFilters[_this2.state.selectedProperty] = filter;
      _this2.props.onChange(copyOfFilters);
      _this2.hide(e.target);
    };
    _this2.propertyChanged = function (v) {
      var selection = v ? v.value : null;
      var filter = _this2.props.filters[selection];
      if (filter) {
        _this2.setState({
          selectedProperty: selection,
          selectedFunction: filter.op,
          selectedValue: filter.value,
          availableFunctions: _this2.getAvailableFunctions(selection),
          isReady: true
        });
      } else {
        _this2.setState({
          selectedProperty: selection,
          selectedFunction: null,
          selectedValue: null,
          availableFunctions: _this2.getAvailableFunctions(selection),
          isReady: false
        });
      }
    };
    _this2.functionChanged = function (v) {
      var selection = v ? v.value : null;
      _this2.setState({
        selectedFunction: selection,
        selectedValue: null,
        isReady: false
      });
    };
    _this2.listValueChanged = function (v) {
      var selection = !v ? "" : v.value;
      _this2.setState({
        selectedValue: selection,
        isReady: selection != ""
      });
    };
    _this2.multiListValueChanged = function (v) {
      var selection = !v ? "" : v.map(function (vv) {
        return vv.value;
      });
      _this2.setState({
        selectedValue: selection,
        isReady: selection != ""
      });
    };
    _this2.inputValueChanged = function (e) {
      var input = e.target.value;
      _this2.setState({
        selectedValue: input,
        isReady: input != ""
      });
    };
    _this2.rangeChanged = function (input, field) {
      var selectedValue = _$1.cloneDeep(_this2.state.selectedValue);
      var num = parseFloat(input);
      if (_$1.isObject(selectedValue)) selectedValue[field] = num;else {
        selectedValue = {};
        selectedValue[field] = num;
      }
      var ready = false;
      if (_$1.isNumber(selectedValue.from) && _$1.isNumber(selectedValue.to)) {
        ready = true;
        if (selectedValue.from > selectedValue.to) {
          var tempValue = selectedValue.to;
          selectedValue.to = selectedValue.from;
          selectedValue.from = tempValue;
        }
      }
      _this2.setState({
        selectedValue: selectedValue,
        isReady: ready
      });
    };
    _this2.dateChanged = function (input) {
      _this2.setState({
        selectedValue: !!input ? input.getTime() : null,
        isReady: !!input
      });
    };
    _this2.dateRangeChanged = function (input, field) {
      var selectedValue = _$1.cloneDeep(_this2.state.selectedValue);
      if (_$1.isObject(selectedValue)) selectedValue[field] = !!input ? input.getTime() : null;else {
        selectedValue = {};
        selectedValue[field] = !!input ? input.getTime() : null;
      }
      var ready = false;
      if (_$1.isNumber(selectedValue.from) && _$1.isNumber(selectedValue.to)) {
        ready = true;
        if (selectedValue.from > selectedValue.to) {
          var tempValue = selectedValue.to;
          selectedValue.to = selectedValue.from;
          selectedValue.from = tempValue;
        }
      }
      _this2.setState({
        selectedValue: selectedValue,
        isReady: ready
      });
    };
    _this2.hasValues = function (prop) {
      return prop.values && prop.values.length;
    };
    _this2.getAvailableFunctions = function (selectedProperty) {
      if (!selectedProperty) return [];
      var hasValues = _this2.hasValues(_this2.props.available[selectedProperty]);
      var type = "|" + _this2.props.available[selectedProperty].type + "|";
      return FUNCTIONS.filter(function (f) {
        return !_this2.props.functions || _this2.props.functions.includes(f.name);
      }).filter(function (f) {
        return f.types == "*" || f.types.indexOf(type) >= 0;
      }).filter(function (f) {
        return hasValues || !f.input.indexOf("pick") >= 0;
      }).map(function (f) {
        return {
          value: f.name,
          label: f.name
        };
      });
    };
    _this2.getAvailableValues = function (selectedFunction) {
      var hasValues = _this2.hasValues(_this2.props.available[_this2.state.selectedProperty]);
      if (Array.isArray(_this2.props.available[_this2.state.selectedProperty])) {
        return _this2.props.available[_this2.state.selectedProperty].map(function (v) {
          return {
            value: v,
            label: v
          };
        });
      } else if (hasValues) {
        return _this2.props.available[_this2.state.selectedProperty].values.map(function (v) {
          return {
            value: v,
            label: v
          };
        });
      }
    };
    _this2.getDateControl = function (type, range) {
      var value;
      if (range == false) value = _this2.state.selectedValue ? new Date(_this2.state.selectedValue) : null;else {
        value = {};
        value.from = _this2.state.selectedValue && _this2.state.selectedValue.from ? new Date(_this2.state.selectedValue.from) : null;
        value.to = _this2.state.selectedValue && _this2.state.selectedValue.to ? new Date(_this2.state.selectedValue.to) : null;
      }
      if (type == 'date') {
        if (range == false) {
          return /*#__PURE__*/React.createElement(DatePicker, {
            onChange: _this2.dateChanged,
            value: value,
            calendarIcon: null
          });
        } else {
          return /*#__PURE__*/React.createElement("span", {
            className: "range"
          }, /*#__PURE__*/React.createElement("label", null, "From"), /*#__PURE__*/React.createElement(DatePicker, {
            onChange: function onChange(e) {
              return _this2.dateRangeChanged(e, "from");
            },
            value: value.from,
            calendarIcon: null
          }), /*#__PURE__*/React.createElement("label", null, "To"), /*#__PURE__*/React.createElement(DatePicker, {
            onChange: function onChange(e) {
              return _this2.dateRangeChanged(e, "to");
            },
            value: value.to,
            calendarIcon: null
          }));
        }
      } else if (type == "datetime") {
        if (range == false) {
          return /*#__PURE__*/React.createElement(DateTimePicker, {
            onChange: _this2.dateChanged,
            value: value,
            calendarIcon: null
          });
        } else {
          return /*#__PURE__*/React.createElement("span", {
            className: "range"
          }, /*#__PURE__*/React.createElement("label", null, "From"), /*#__PURE__*/React.createElement(DateTimePicker, {
            onChange: function onChange(e) {
              return _this2.dateRangeChanged(e, "from");
            },
            value: value.from,
            calendarIcon: null,
            disableClock: true
          }), /*#__PURE__*/React.createElement("label", null, "To"), /*#__PURE__*/React.createElement(DateTimePicker, {
            onChange: function onChange(e) {
              return _this2.dateRangeChanged(e, "to");
            },
            value: value.to,
            calendarIcon: null,
            disableClock: true
          }));
        }
      }
      return null;
    };
    _this2.getInputControl = function () {
      var func = FUNCTIONS.find(function (f) {
        return f.name == _this2.state.selectedFunction;
      });
      if (!func) return null;
      var type = _this2.props.available[_this2.state.selectedProperty].type;
      var hasValues = _this2.hasValues(_this2.props.available[_this2.state.selectedProperty]);
      var textControl = /*#__PURE__*/React.createElement("input", {
        onChange: _this2.inputValueChanged,
        value: _this2.state.selectedValue ? _this2.state.selectedValue : "",
        placeholder: "Enter Value",
        className: "filter-input-value"
      });
      var numberControl = /*#__PURE__*/React.createElement("input", {
        type: "number",
        onChange: _this2.inputValueChanged,
        value: _this2.state.selectedValue ? _this2.state.selectedValue : "",
        placeholder: "Enter Value",
        className: "filter-input-value"
      });
      var noValueControl;
      if (func.input == 'single-pick') {
        if (type == "date" || type == "datetime") noValueControl = _this2.getDateControl(type, false);else if (type == "number") noValueControl = numberControl;else noValueControl = textControl;
      }
      switch (func.input) {
        case 'single-pick':
          return hasValues ? /*#__PURE__*/React.createElement(Select, {
            onChange: _this2.listValueChanged,
            styles: _this2.props.styles,
            placeholder: "Select Value",
            options: _this2.getAvailableValues(),
            value: _this2.state.selectedValue ? {
              value: _this2.state.selectedValue,
              label: _this2.state.selectedValue
            } : null,
            disabled: !_this2.state.selectedProperty,
            menuPlacement: "auto",
            menuPosition: "fixed",
            isSearchable: true,
            isClearable: true
          }) : noValueControl;
        case 'multi-pick':
          return hasValues ? /*#__PURE__*/React.createElement(Select, {
            onChange: _this2.multiListValueChanged,
            styles: _this2.props.styles,
            placeholder: "Select Value",
            options: _this2.getAvailableValues(),
            value: _this2.state.selectedValue ? _this2.state.selectedValue.map(function (v) {
              return {
                value: v,
                label: v
              };
            }) : null,
            disabled: !_this2.state.selectedProperty,
            menuPlacement: "auto",
            menuPosition: "fixed",
            isMulti: true,
            isSearchable: true,
            isClearable: true
          }) : noValueControl;
        case 'text':
          return textControl;
        case 'single':
          if (type == "date" || type == "datetime") {
            return _this2.getDateControl(type, false);
          } else {
            return numberControl;
          }
        case 'range':
          if (type == "date" || type == "datetime") {
            return _this2.getDateControl(type, true);
          } else {
            return /*#__PURE__*/React.createElement("span", {
              className: "range"
            }, /*#__PURE__*/React.createElement("label", null, "From"), /*#__PURE__*/React.createElement("input", {
              type: "number",
              onChange: function onChange(e) {
                return _this2.rangeChanged(e.target.value, "from");
              },
              value: _this2.state.selectedValue && _this2.state.selectedValue.from !== undefined ? _this2.state.selectedValue.from : "",
              placeholder: "from",
              className: "filter-input-value"
            }), /*#__PURE__*/React.createElement("label", null, "To"), /*#__PURE__*/React.createElement("input", {
              type: "number",
              onChange: function onChange(e) {
                return _this2.rangeChanged(e.target.value, "to");
              },
              value: _this2.state.selectedValue && _this2.state.selectedValue.from !== undefined ? _this2.state.selectedValue.to : "",
              placeholder: "to",
              className: "filter-input-value"
            }));
          }
        default:
          console.error("Unknown input for ", func);
          return /*#__PURE__*/React.createElement("div", null, "Unknown data type! (", func.input, ")");
      }
    };
    _this2.state = _this2.defaultState;
    return _this2;
  }
  _inherits(FilterDropDownPanel, _React$Component2);
  return _createClass(FilterDropDownPanel, [{
    key: "render",
    value: function render() {
      var _this3 = this;
      var properties = Object.keys(this.props.available).sort().map(function (a) {
        return {
          label: a + (_this3.props.filters[a] ? " *" : ""),
          value: a
        };
      });
      return /*#__PURE__*/React.createElement("div", {
        className: "hidden filter-drop-down-panel " + this.props.parentKey
      }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Select, {
        onChange: this.propertyChanged,
        styles: this.props.styles,
        value: this.state.selectedProperty ? {
          value: this.state.selectedProperty,
          label: this.state.selectedProperty
        } : null,
        placeholder: "Select Property",
        options: properties,
        menuPlacement: "auto",
        menuPosition: "fixed",
        isSearchable: true,
        isClearable: true
      })), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Select, {
        onChange: this.functionChanged,
        styles: this.props.styles,
        placeholder: "Select Function",
        options: this.state.availableFunctions,
        value: this.state.selectedFunction ? {
          value: this.state.selectedFunction,
          label: this.state.selectedFunction
        } : null,
        disabled: !this.state.availableFunctions,
        menuPlacement: "auto",
        menuPosition: "fixed",
        isSearchable: true,
        isClearable: true
      })), /*#__PURE__*/React.createElement("div", null, this.getInputControl()), /*#__PURE__*/React.createElement(GenericMatButton, {
        onClick: this.cancel
      }, "Cancel"), /*#__PURE__*/React.createElement(GenericMatButton, {
        disabled: !this.state.isReady,
        onClick: this.add
      }, "Add"));
    }
  }]);
}(React.Component);
var applyFilters = function applyFilters(array, filters, getProperty) {
  var result = _toConsumableArray(array);
  if (!_$1.isEmpty(filters)) {
    Object.entries(filters).forEach(function (_ref4) {
      var _ref5 = _slicedToArray(_ref4, 2),
        filterProp = _ref5[0],
        filter = _ref5[1];
      result = result.filter(function (a) {
        var prop = getProperty(a, filterProp);
        var propVal;
        if (_$1.isString(prop) || prop === undefined) {
          propVal = prop;
        } else {
          propVal = prop.val;
          if (prop.type == "date" || prop.type == "datetime") {
            if (isNumericOp(filter.op)) {
              propVal = prop.epoch;
            }
          }
        }
        if (!propVal) {
          if (filter.value == "_empty_" && (filter.op == "equals" || filter.op == "in")) return true;
          if (filter.value != "_empty_" && (filter.op.startsWith("does not") || filter.op == "is not in")) return true;else return false;
        }
        var f = FUNCTIONS.find(function (f) {
          return f.name == filter.op;
        });
        if (!f) {
          console.error("no implementation for filter operator: " + filter.op);
          return true;
        } else return f.test(propVal, filter.value);
      });
    });
  }
  return result;
};
var FilterControl$1 = enhanceWithClickOutside(FilterControl);

var asSelectOption = function asSelectOption(option) {
  return option ? {
    value: option,
    label: option,
    key: option
  } : undefined;
};
var asSelectOptions = function asSelectOptions(options) {
  return _$1.defaultTo(options, []).map(asSelectOption);
};

var cachedPromises = {};
var SCRIPT_EXPIRATION_MINUTES_KEY = 'scriptExpirationMinutes';
var SCRIPT_EXPIRATION_ARGS_KEY = 'scriptExpiration';
var DEFAULT_EXPIRATION_MINUTES = 10;
var IGNORE_CACHED_RESULT_ARGS_KEY = 'ignoreCachedScriptResult';
var saveToCache = function saveToCache(key, value, expirationMins) {
  cachedPromises[key] = {
    value: value,
    exp: moment().add(expirationMins, 'minutes')
  };
};
var getCached = function getCached(key) {
  var _ref = cachedPromises[key] || {},
    value = _ref.value,
    exp = _ref.exp;
  if (exp && exp.isAfter(moment())) {
    return value;
  } else {
    delete cachedPromises[key];
    return undefined;
  }
};
var getCachingArguments = function getCachingArguments(args) {
  var expirationPartition = _$1.partition(args, function (e) {
    return typeof e !== "undefined" && e.hasOwnProperty(SCRIPT_EXPIRATION_ARGS_KEY);
  });
  var scriptExpiration = expirationPartition[0];
  var scriptArgs = _$1.partition(expirationPartition[1], function (e) {
    return typeof e !== "undefined" && e.hasOwnProperty(IGNORE_CACHED_RESULT_ARGS_KEY);
  });
  return {
    scriptArgs: scriptArgs[1],
    scriptExpiration: sessionStorage.getItem(SCRIPT_EXPIRATION_MINUTES_KEY) || (scriptExpiration.length && scriptExpiration[0].hasOwnProperty('scriptExpiration') ? scriptExpiration[0].scriptExpiration : DEFAULT_EXPIRATION_MINUTES),
    ignoreCachedResult: scriptArgs[0] && scriptArgs[0].length ? scriptArgs[0][0].ignoreCachedScriptResult : false
  };
};
var runScript = function runScript() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }
  console.log("runScript args", args);
  var _getCachingArguments = getCachingArguments(args),
    scriptArgs = _getCachingArguments.scriptArgs,
    scriptExpiration = _getCachingArguments.scriptExpiration,
    ignoreCachedResult = _getCachingArguments.ignoreCachedResult;
  console.log("ignoreCachedResult", ignoreCachedResult);
  var plainArgs = JSON.stringify(scriptArgs);
  var cachedPromise = getCached(plainArgs);
  if (cachedPromise && !ignoreCachedResult) {
    console.log(scriptArgs[0] + " cachedPromise result:", cachedPromise);
    return cachedPromise;
  } else {
    var scriptResultPromise = ScriptHelper.executeScript.apply(ScriptHelper, _toConsumableArray(scriptArgs));
    if (scriptExpiration > 0) {
      saveToCache(plainArgs, scriptResultPromise, scriptExpiration);
    }
    return scriptResultPromise;
  }
};
var clearCache = function clearCache() {
  cachedPromises = {};
};
var ScriptCache = {
  runScript: runScript,
  clearCache: clearCache
};

function usePrevious(value) {
  var ref = useRef();
  useEffect(function () {
    ref.current = value;
  });
  return ref.current;
}

/**
 * Checks if to lists have the same elements, in the same order. Considers empty lists as equal.
 * If lists are same by reference, it skips the deep comparison
 * @param list
 * @param otherList
 * @returns {boolean}
 */
var listEquals = function listEquals(list, otherList) {
  return list === otherList || listIncludes(list, otherList) && listIncludes(otherList, list);
};

/**
 * Checks if all elements of `otherList` are included in `list`, maintaining the order
 * @param list
 * @param otherList
 * @returns {boolean}
 */
var listIncludes = function listIncludes() {
  var list = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  var otherList = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  return otherList.every(function (element, i) {
    return list[i] === element;
  });
};

/**
 * Checks if a given set of propNames are equal among 2 prop objects. Useful for component memoization
 * Based on lodash's `eq`
 * @param propNames
 * @returns {function(*, *): *}
 */
var propsEqual = function propsEqual(propNames) {
  return function (prevProps, nextProps) {
    return propNames.every(function (propName) {
      return _$1.eq(prevProps[propName], nextProps[propName]);
    });
  };
};

/**
 * Checks if all elements of `includer` are included in `included`, disregarding the order.
 * Applies `idGetter` to elements to extract identifier. If none provided, `idGetter` defaults to identity
 * Complexity is n^2, not recommended for big sets
 * @param includer
 * @param included
 * @param idGetter
 * @returns {boolean}
 */
var setIncludesBy = function setIncludesBy() {
  var includer = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  var included = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  var idGetter = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _$1.identity;
  return included.every(function (includedElement) {
    return includer.some(function (includerElement) {
      return idGetter(includerElement) === idGetter(includedElement);
    });
  });
};

var getFilteredEntitiesBy = function getFilteredEntitiesBy(entities, filters) {
  return applyFilters(entities, filters, function (a, p) {
    return p == "Entity Name" ? a["Entity Name"] : a.properties[p];
  });
};
var getEntityFromModel = /*#__PURE__*/function () {
  var _ref = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(script, modelEntity) {
    var entity;
    return _regenerator().w(function (_context) {
      while (1) switch (_context.n) {
        case 0:
          _context.n = 1;
          return ScriptHelper.executeScript(script, {
            modelInfo: modelEntity
          });
        case 1:
          entity = _context.v;
          if (!entity) {
            _context.n = 2;
            break;
          }
          return _context.a(2, _objectSpread2(_objectSpread2({}, entity), {}, {
            modelViewerIds: [modelEntity.id]
          }));
        case 2:
          return _context.a(2, undefined);
        case 3:
          return _context.a(2);
      }
    }, _callee);
  }));
  return function getEntityFromModel(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();

var css_248z$2 = ".dbm-tooltip {\n  position: relative;\n  display: flex;\n}\n\n.dbm-tooltip .dbm-tooltiptext {\n  visibility: hidden;\n  background-color: black;\n  color: white;\n  text-align: center;\n  padding: 5px 0;\n  border-radius: 6px;\n  position: absolute;\n  width: 120px;\n  bottom: 100%;\n  left: 50%;\n  margin-left: -60px;\n}\n\n.dbm-tooltip:hover .dbm-tooltiptext {\n  visibility: visible;\n}";
styleInject(css_248z$2);

//TODO Remove once fancy tree is everywhere replaced by ReactiveTree
var leafNodeRenderer = function leafNodeRenderer(entity) {
  return /*#__PURE__*/React.createElement("div", {
    title: entity["Entity Name"]
  }, entity["Entity Name"], entity["EntityWarningMessage"] && /*#__PURE__*/React.createElement("div", {
    className: "tooltip-wrapper"
  }, /*#__PURE__*/React.createElement("div", {
    className: "dbm-tooltip"
  }, /*#__PURE__*/React.createElement("i", {
    className: "fas fa-exclamation-circle"
  }), /*#__PURE__*/React.createElement("span", {
    className: "dbm-tooltiptext"
  }, entity["EntityWarningMessage"]))));
};
var branchNodeRenderer = function branchNodeRenderer(groupName, values) {
  var _sumChildren = function sumChildren(values, acc) {
    if (Array.isArray(values)) {
      return acc + values.length;
    }
    Object.keys(values).forEach(function (key) {
      acc = _sumChildren(values[key], acc);
    });
    return acc;
  };
  return /*#__PURE__*/React.createElement("span", null, groupName, /*#__PURE__*/React.createElement("span", {
    className: "count",
    style: {
      fontSize: "0.8em"
    }
  }, _sumChildren(values, 0)));
};

export { AdvSearchQueryBuilder as A, getTitleBarInfoFromProps as B, group as C, recalculateNodeStatus as D, applyFilters as E, FileHelpers as F, GenericMatButton as G, TreeNodeActionName as H, makePromiseIgnorable as I, ScriptHelper as S, TreeNodeStatus as T, _propagateNodeStatusDown as _, defaultLeafRenderer as a, FilterControl$1 as b, curriedFlip as c, defaultBranchRenderer as d, asSelectOptions as e, ScriptCache as f, getRandomString as g, getFilteredEntitiesBy as h, isValidUrl as i, _nestedGroup as j, getEntityFromModel as k, leafNodeRenderer as l, branchNodeRenderer as m, listEquals as n, listIncludes as o, propagateNodeStatusUp as p, propsEqual as q, asSelectOption as r, setIncludesBy as s, downloadDocuments as t, usePrevious as u, getFileUrlForFilename as v, withoutPropagation as w, getFileUrl as x, getPlatform as y, parseQuery as z };
