import { _ as _asyncToGenerator, a as _regenerator, g as _objectSpread2, q as _typeof, k as _objectWithoutProperties, n as _defineProperty, o as _createForOfIteratorHelper, d as _slicedToArray, s as styleInject, j as _toConsumableArray } from './style-inject.es-ebcb980f.js';
import React, { useRef, useEffect, useState } from 'react';
import _$1 from 'lodash';
import { IafFileSvc, IafItemSvc, IafFile } from '@dtplatform/platform-api';
import { S as ScriptHelper, G as GenericMatButton, r as asSelectOption, e as asSelectOptions } from './TreeRendererHelper-7d89f2f1.js';
import { C as ControlProvider, d as CreatableScriptedSelects, S as ScriptedChart, B as BaseTextInput, I as Image, a8 as entitiesGeneral, a9 as entitiesPluggableSearch, aa as entityRelations, ab as entityUI, ac as userConfig, ad as modal } from './EntityListView-43ddf04c.js';
import clsx from 'clsx';
import { IafScriptEngine } from '@dtplatform/iaf-script-engine';
import produce from 'immer';
import Select from 'react-select';
import { T as Table, C as ChartStack, B as BigButtonBar, b as CompactButtonBar, c as CrossEntitySearch, G as GenericIframe } from './Table-4fbf94ec.js';
import { combineReducers } from 'redux';
import { createSlice, createEntityAdapter, createAsyncThunk, createSelector, configureStore, getDefaultMiddleware } from '@reduxjs/toolkit';
import { Tooltip } from '@mui/material';
import { w as withGenericPageContext } from './genericPageContext-de32d520.js';

var initialState = {
  _firstname: "Unknown",
  _lastname: "User",
  _email: "UnknownUser"
};
var userSlice = createSlice({
  name: 'user',
  initialState: initialState,
  reducers: {
    setUser: function setUser(state, _ref) {
      var user = _ref.payload;
      return user;
    }
  }
});
var actions = userSlice.actions,
  reducer = userSlice.reducer;
var getUser = function getUser(store) {
  return store.user;
};

//Action creators
var setUser = actions.setUser;
var addUser = function addUser(user) {
  return function (dispatch, getState) {
    dispatch(setUser(user));
  };
};

var NAMED_USER_ITEM_FEATURE_KEY = 'namedUserItem';
var namedUserItemAdapter = createEntityAdapter({
  //IDs are stored in a customized field ("_id")
  selectId: function selectId(namedUserItem) {
    return namedUserItem._id;
  },
  // Keep the "all IDs" array sorted based on names
  sortComparer: function sortComparer(a, b) {
    return a._name.localeCompare(b._name);
  }
});
/**
 * Export an effect using createAsyncThunk from
 * the Redux Toolkit: https://redux-toolkit.js.org/api/createAsyncThunk
 *
 * e.g.
 * ```
 * import React, { useEffect } from 'react';
 * import { useDispatch } from 'react-redux';
 *
 * // ...
 *
 * const dispatch = useDispatch();
 * useEffect(() => {
 *   dispatch(fetchNamedUserItem())
 * }, [dispatch]);
 * ```
 */
var fetchNamedUserItemItems = createAsyncThunk('namedUserItem/fetchStatus', /*#__PURE__*/function () {
  var _ref = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(args, thunkAPI) {
    var scriptName, userItemId, userItemVersionId, ctx;
    return _regenerator().w(function (_context) {
      while (1) switch (_context.n) {
        case 0:
          scriptName = args.scriptName, userItemId = args.userItemId, userItemVersionId = args.userItemVersionId, ctx = args.ctx;
          if (scriptName) {
            _context.n = 1;
            break;
          }
          return _context.a(2, IafScriptEngine.getItems({
            query: {},
            _userItemId: userItemId,
            options: {
              "page": {
                "_pageSize": 5,
                "_offset": 0,
                "getPageInfo": true
              }
              //userItemVersionId: model_rel_coll_prev._userItemVersionId
            }
          }, ctx));
        case 1:
          return _context.a(2, ScriptHelper.executeScript(scriptName, userItemId));
        case 2:
        case 3:
          return _context.a(2);
      }
    }, _callee);
  }));
  return function (_x, _x2) {
    return _ref.apply(this, arguments);
  };
}());
var fetchNamedUserTotalAmountOfItems = createAsyncThunk('namedUserItemTotalItems/fetchStatus', /*#__PURE__*/function () {
  var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(args, thunkAPI) {
    var collectionsArray, ctx, resultArr;
    return _regenerator().w(function (_context2) {
      while (1) switch (_context2.n) {
        case 0:
          collectionsArray = args.collectionsArray, ctx = args.ctx;
          resultArr = collectionsArray.map(function (item) {
            return {
              query: {},
              _userItemId: item._userItemId,
              options: {
                "page": {
                  "getPageInfo": true
                }
              }
            };
          });
          return _context2.a(2, IafScriptEngine.getItemsMulti(resultArr, ctx));
      }
    }, _callee2);
  }));
  return function (_x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}());
var collectionIndexes = [];
var fetchAssocitedFileSvcData = createAsyncThunk('namedUserItemFileSvcData/fetchStatus', /*#__PURE__*/function () {
  var _ref3 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3(args, thunkAPI) {
    var fileItems, idx, ctx, fileSvcRes, i, criteria;
    return _regenerator().w(function (_context3) {
      while (1) switch (_context3.n) {
        case 0:
          fileItems = args.fileItems, idx = args.idx, ctx = args.ctx;
          i = 0;
        case 1:
          if (!(i < fileItems.length)) {
            _context3.n = 6;
            break;
          }
          if (fileItems[i]._fileId) {
            _context3.n = 3;
            break;
          }
          criteria = {
            "_name": fileItems[i].filename || fileItems[i].name
          };
          _context3.n = 2;
          return IafFileSvc.getFiles(criteria, ctx);
        case 2:
          fileSvcRes = _context3.v;
        case 3:
          if (!collectionIndexes.includes(idx)) {
            _context3.n = 4;
            break;
          }
          return _context3.a(3, 6);
        case 4:
          if (fileSvcRes) collectionIndexes.push(idx);
        case 5:
          i++;
          _context3.n = 1;
          break;
        case 6:
          return _context3.a(2, collectionIndexes);
      }
    }, _callee3);
  }));
  return function (_x5, _x6) {
    return _ref3.apply(this, arguments);
  };
}());

/*
export const fetchNamedUserItems = createAsyncThunk(
    'namedUserItems/fetchStatus',
    async (args, thunkAPI) => {
      const criteria = {query: {
                  "_itemClass": {"$in": ["NamedUserCollection","NamedFileCollection"]}
              }};
      return IafItemSvc.getNamedUserItems(criteria, args.ctx, args.options);
    }
);
*/
var fetchAllNamedUserItems = createAsyncThunk('allNamedUserItems/fetchStatus', /*#__PURE__*/function () {
  var _ref4 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4(args, thunkAPI) {
    var scriptName, criteria, ctx, options;
    return _regenerator().w(function (_context4) {
      while (1) switch (_context4.n) {
        case 0:
          scriptName = args.scriptName;
          if (scriptName) {
            _context4.n = 1;
            break;
          }
          /**
           * @param {criteria: NamedUserItemCriteria, ctx: Ctx, options: NamedUserItemCriteriaOptions} - args
           * @returns {Promise<Array<NamedUserItem>>}
           */
          //always filter _itemClass
          criteria = {
            query: {
              "_itemClass": {
                "$in": ["NamedUserCollection", "NamedFileCollection"]
              }
            }
          };
          ctx = _objectSpread2({}, args.ctx) || {};
          options = args.options;
          return _context4.a(2, IafItemSvc.getAllNamedUserItems(criteria, ctx, options));
        case 1:
          _context4.n = 2;
          return ScriptHelper.executeScript(scriptName);
        case 2:
          return _context4.a(2, _context4.v);
        case 3:
          return _context4.a(2);
      }
    }, _callee4);
  }));
  return function (_x7, _x8) {
    return _ref4.apply(this, arguments);
  };
}());
var fileImport = createAsyncThunk('importData/importStatus', /*#__PURE__*/function () {
  var _ref5 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee5(args, thunkAPI) {
    var importScriptName;
    return _regenerator().w(function (_context5) {
      while (1) switch (_context5.n) {
        case 0:
          importScriptName = args.importScriptName;
          return _context5.a(2, ScriptHelper.executeScript(importScriptName));
      }
    }, _callee5);
  }));
  return function (_x9, _x0) {
    return _ref5.apply(this, arguments);
  };
}());
var importDataValidation = createAsyncThunk('importData/ValidationStatus', /*#__PURE__*/function () {
  var _ref6 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee6(args, thunkAPI) {
    var valScriptName, importFileResult;
    return _regenerator().w(function (_context6) {
      while (1) switch (_context6.n) {
        case 0:
          valScriptName = args.valScriptName, importFileResult = args.importFileResult;
          _context6.n = 1;
          return ScriptHelper.executeScript(valScriptName, {
            thunkAPI: thunkAPI,
            importFileResult: importFileResult
          });
        case 1:
          return _context6.a(2, _context6.v);
      }
    }, _callee6);
  }));
  return function (_x1, _x10) {
    return _ref6.apply(this, arguments);
  };
}());
var initialNamedUserItemState = namedUserItemAdapter.getInitialState({
  loadingStatus: 'not loaded',
  error: null
});
var namedUserItemSlice = createSlice({
  name: NAMED_USER_ITEM_FEATURE_KEY,
  initialState: initialNamedUserItemState,
  reducers: {
    add: namedUserItemAdapter.addOne,
    remove: namedUserItemAdapter.removeOne,
    setAll: namedUserItemAdapter.setAll
    // ...
  },
  extraReducers: function extraReducers(builder) {
    builder.addCase(fetchNamedUserItemItems.pending, function (state) {
      state.loadingStatus = 'loading';
    }).addCase(fetchAllNamedUserItems.pending, function (state) {
      state.loadingStatus = 'loading';
    }).addCase(fetchNamedUserTotalAmountOfItems.pending, function (state) {
      state.loadingStatus = 'loading';
    }).addCase(fetchAssocitedFileSvcData.pending, function (state) {
      state.loadingStatus = 'loading';
    }).addCase(importDataValidation.pending, function (state) {
      state.loadingStatus = 'loading';
    }).addCase(fileImport.pending, function (state) {
      state.loadingStatus = 'loading';
    }).addCase(fetchNamedUserItemItems.fulfilled, function (state, action) {
      namedUserItemAdapter.updateOne(state, action.payload);
      state.loadingStatus = 'loaded';
    }).addCase(fetchAllNamedUserItems.fulfilled, function (state, action) {
      namedUserItemAdapter.setAll(state, action.payload._list);
      state.loadingStatus = 'loaded';
    }).addCase(fetchNamedUserTotalAmountOfItems.fulfilled, function (state, action) {
      namedUserItemAdapter.updateOne(state, action.payload);
      state.loadingStatus = 'loaded';
    }).addCase(fetchAssocitedFileSvcData.fulfilled, function (state, action) {
      namedUserItemAdapter.updateOne(state, action.payload);
      state.loadingStatus = 'loaded';
    }).addCase(importDataValidation.fulfilled, function (state, action) {
      namedUserItemAdapter.updateOne(state, action.payload);
      state.loadingStatus = 'loaded';
      state.error = null;
    }).addCase(fileImport.fulfilled, function (state, action) {
      namedUserItemAdapter.updateOne(state, action.payload);
      state.loadingStatus = 'loaded';
      state.error = null;
    }).addCase(fetchNamedUserItemItems.rejected, function (state, action) {
      state.loadingStatus = 'error';
      state.error = action.error.message;
    }).addCase(fetchAllNamedUserItems.rejected, function (state, action) {
      state.loadingStatus = 'error';
      state.error = action.error.message;
    }).addCase(fetchNamedUserTotalAmountOfItems.rejected, function (state, action) {
      state.loadingStatus = 'error';
      state.error = action.error.message;
    }).addCase(fetchAssocitedFileSvcData.rejected, function (state, action) {
      state.loadingStatus = 'error';
      state.error = action.error.message;
    }).addCase(importDataValidation.rejected, function (state, action) {
      state.loadingStatus = 'error';
      state.error = action.payload;
    }).addCase(fileImport.rejected, function (state, action) {
      state.loadingStatus = 'error';
      state.error = action.payload;
    });
  }
});
/*
 * Export reducer for store configuration.
 */
var namedUserItemReducer = namedUserItemSlice.reducer;
/*
 * Export action creators to be dispatched. For use with the `useDispatch` hook.
 *
 * e.g.
 * ```
 * import React, { useEffect } from 'react';
 * import { useDispatch } from 'react-redux';
 *
 * // ...
 *
 * const dispatch = useDispatch();
 * useEffect(() => {
 *   dispatch(namedUserItemActions.add({ id: 1 }))
 * }, [dispatch]);
 * ```
 *
 * See: https://react-redux.js.org/next/api/hooks#usedispatch
 */
var namedUserItemActions = namedUserItemSlice.actions;
/*
 * Export selectors to query state. For use with the `useSelector` hook.
 *
 * e.g.
 * ```
 * import { useSelector } from 'react-redux';
 *
 * // ...
 *
 * const entities = useSelector(selectAllNamedUserItem);
 * ```
 *
 * See: https://react-redux.js.org/next/api/hooks#useselector
 */
var _namedUserItemAdapter = namedUserItemAdapter.getSelectors(),
  selectAll = _namedUserItemAdapter.selectAll,
  selectEntities = _namedUserItemAdapter.selectEntities,
  selectById = _namedUserItemAdapter.selectById;
var getNamedUserItemSlice = function getNamedUserItemSlice(rootState) {
  return rootState[NAMED_USER_ITEM_FEATURE_KEY];
};
var getLoadingStatus = function getLoadingStatus(slice) {
  return slice.loadingStatus;
};
var getErrorStatus = function getErrorStatus(slice) {
  return slice.error;
};
var selectNamedUserItemById = createSelector(getNamedUserItemSlice, function (state, id) {
  return id;
}, selectById);
var selectAllNamedUserItem = createSelector(getNamedUserItemSlice, selectAll);
var selectNamedUserItemEntities = createSelector(getNamedUserItemSlice, selectEntities);
var selectNamedUserItemsLoadingStatus = createSelector(getNamedUserItemSlice, getLoadingStatus);
var SelectNamedUserItemsErrorStatus = createSelector(getNamedUserItemSlice, getErrorStatus);
var SelectNamedUserItemsImportStatus = createSelector(getNamedUserItemSlice, getLoadingStatus);

var fileSelectStyles = {
  control: function control(provided, _ref) {
    var isFocused = _ref.isFocused,
      isDisabled = _ref.isDisabled;
    return {
      backgroundColor: isDisabled ? "hsl(0, 0%, 95%)" : "hsl(0, 0%, 100%)",
      border: "none",
      display: 'flex',
      minWidth: '200px'
    };
  },
  indicatorSeparator: function indicatorSeparator() {
    return {
      display: 'none'
    };
  }
};
var Star = function Star() {
  return /*#__PURE__*/React.createElement("span", {
    className: "required-mark"
  }, "*");
};
var FileTableSelect = function FileTableSelect(_ref2) {
  var _ref2$options = _ref2.options,
    options = _ref2$options === void 0 ? [] : _ref2$options,
    _onChange = _ref2.onChange,
    value = _ref2.value;
  return /*#__PURE__*/React.createElement(Select, {
    styles: fileSelectStyles,
    isMulti: false,
    value: value && asSelectOption(value),
    onChange: function onChange(e) {
      return _onChange(e === null || e === void 0 ? void 0 : e.value);
    },
    options: asSelectOptions(options),
    className: "select-element",
    closeMenuOnSelect: true,
    placeholder: "Choose",
    isDisabled: false,
    menuPlacement: "auto",
    menuPosition: "fixed",
    isClearable: true
  });
};

//This component has a delayed onChange to avoid hitting the store too often
//If this approach complicates matters at some point alternatives are:
//a) Make fully controlled and hit the store on every stroke, maybe performance is ok anyways
//b) Move table state management to UploadWizardObject either via common state variables (+immer) or `useReducer` hook
var FileTableInput = function FileTableInput(_ref3) {
  var onChange = _ref3.onChange,
    _ref3$initialValue = _ref3.initialValue,
    initialValue = _ref3$initialValue === void 0 ? '' : _ref3$initialValue;
  var input = useRef();
  useEffect(function () {
    input.current.value = initialValue;
  }, [input, initialValue]);
  var onChangeDebounced = _$1.debounce(onChange, 350);
  return /*#__PURE__*/React.createElement("input", {
    ref: input,
    className: 'file-table-input',
    onChange: function onChange(e) {
      return onChangeDebounced(e.target.value);
    }
  });
};
var PanelToggle = function PanelToggle(_ref4) {
  var onClick = _ref4.onClick,
    disabled = _ref4.disabled;
  return /*#__PURE__*/React.createElement("div", {
    className: clsx('panel-toggle', disabled && 'disabled'),
    onClick: disabled ? _$1.noop : onClick
  }, /*#__PURE__*/React.createElement("i", {
    className: "fas fa-cloud-upload-alt cloud-icon"
  }));
};
var WizardButtons = function WizardButtons(originalOptions) {
  return function (_ref5) {
    var optionsOverride = _ref5.optionsOverride;
    var options = _objectSpread2(_objectSpread2({}, originalOptions), optionsOverride);
    return /*#__PURE__*/React.createElement("div", {
      className: 'file-wizard-actions'
    }, _$1.get(options, 'hidePrimary') || /*#__PURE__*/React.createElement(GenericMatButton, {
      customClasses: "main-button",
      disabled: _$1.get(options, 'primaryDisabled', false),
      onClick: _$1.get(options, 'onPrimaryClick', _$1.noop)
    }, _$1.get(options, 'primaryContent', 'Next')), _$1.get(options, 'hideSecondary') || /*#__PURE__*/React.createElement(GenericMatButton, {
      customClasses: "cancel-button",
      disabled: _$1.get(options, 'secondaryDisabled', false),
      onClick: _$1.get(options, 'onSecondaryClick', _$1.noop)
    }, _$1.get(options, 'secondaryContent', 'Previous')));
  };
};

var fallbackControlBuilder = /*#__PURE__*/function () {
  var _ref = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(column) {
    return _regenerator().w(function (_context) {
      while (1) switch (_context.n) {
        case 0:
          throw new Error("Error in file column config for ".concat(column.name, ": Unknown control for string query ").concat(column.query));
        case 1:
          return _context.a(2);
      }
    }, _callee);
  }));
  return function fallbackControlBuilder(_x) {
    return _ref.apply(this, arguments);
  };
}();
var controlBuilders = {
  '<<CREATABLE_SCRIPTED_SELECTS>>': function CREATABLE_SCRIPTED_SELECTS(column) {
    if (!column.script) throw new Error("Error in file column config for ".concat(column.name, ": <<CREATABLE_SCRIPTED_SELECTS>> require a script to populate select options"));
    return function (value, onChange, entity) {
      //If this needs to be turned into an arrow function, be careful with the `this` reference
      return /*#__PURE__*/React.createElement(CreatableScriptedSelects, {
        currentValue: value,
        onChange: onChange,
        noFetch: true,
        compact: true,
        horizontal: true,
        isClearable: false,
        selectOverrideStyles: fileSelectStyles,
        filterInfo: entity,
        script: this.script
      });
    };
  },
  '<<TEXT>>': function TEXT() {
    return function (value, onChange) {
      return /*#__PURE__*/React.createElement(FileTableInput, {
        initialValue: value,
        onChange: onChange
      });
    };
  },
  '<<SIMPLE_SELECT>>': function () {
    var _SIMPLE_SELECT = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(column) {
      var values, _t;
      return _regenerator().w(function (_context2) {
        while (1) switch (_context2.n) {
          case 0:
            if (column.script) {
              _context2.n = 1;
              break;
            }
            throw new Error("Error in file column config for ".concat(column.name, ": <<SIMPLE_SELECT>> requires a script to populate select options"));
          case 1:
            _t = _$1;
            _context2.n = 2;
            return ScriptHelper.executeScript(column.script);
          case 2:
            values = _t.values.call(_t, _context2.v)[0];
            return _context2.a(2, function (value, onChange) {
              return /*#__PURE__*/React.createElement(FileTableSelect, {
                value: value,
                options: values,
                onChange: onChange
              });
            });
        }
      }, _callee2);
    }));
    function SIMPLE_SELECT(_x2) {
      return _SIMPLE_SELECT.apply(this, arguments);
    }
    return SIMPLE_SELECT;
  }()
};
var validateMulti = function validateMulti(query) {
  if (query.multi || _$1.get(query, 'selects', []).some(function (select) {
    return select.multi;
  })) throw new Error('Cannot use "multi" selects in file upload table');
};
var buildConfig = function buildConfig(displayNames) {
  return produce(/*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3(column) {
      var Control, columnNameArray;
      return _regenerator().w(function (_context3) {
        while (1) switch (_context3.n) {
          case 0:
            if (!(_typeof(column.query) === 'object')) {
              _context3.n = 1;
              break;
            }
            Control = ControlProvider.getControlComponent(column.query);
            validateMulti(column.query);
            column.control = function (value, onChange) {
              //If this needs to be turned into an arrow function, be careful with the `this` reference
              return /*#__PURE__*/React.createElement(Control, {
                currentValue: value,
                onChange: onChange,
                noFetch: true,
                selects: this.query.selects,
                compact: true,
                horizontal: true,
                isClearable: false,
                selectOverrideStyles: fileSelectStyles
              });
            };
            _context3.n = 4;
            break;
          case 1:
            if (!(typeof column.query === 'string')) {
              _context3.n = 3;
              break;
            }
            _context3.n = 2;
            return (controlBuilders[column.query] || fallbackControlBuilder)(column);
          case 2:
            column.control = _context3.v;
            _context3.n = 4;
            break;
          case 3:
            throw new Error("Error in file column config for ".concat(column.name, ": Requires a query (either object or string) to populate select options"));
          case 4:
            columnNameArray = typeof column.name === 'string' ? [column.name] : column.name;
            column.displayAs = displayNames.filter(function (_ref3) {
              var prop = _ref3.prop;
              return _$1.includes(columnNameArray, prop);
            }).map(function (_ref4) {
              var dName = _ref4.dName;
              return dName;
            }).join(' & ');
            column.isCompositeAttribute = Array.isArray(column.name);
          case 5:
            return _context3.a(2);
        }
      }, _callee3);
    }));
    return function (_x3) {
      return _ref2.apply(this, arguments);
    };
  }());
};

//This component encapsulates the complexity of turning column config into actual controls
var FileConfigReader = {
  buildConfig: buildConfig
};

var _excluded = ["name"],
  _excluded2 = ["name"];

//Small ADT to keep File blob objects outside the store since they're not serializable
var fileBlobs = {};
var addFileBlob = function addFileBlob(fileBlob) {
  return fileBlobs[fileBlob.name] = fileBlob;
};
var clearFileBlobs = function clearFileBlobs() {
  return fileBlobs = {};
};
var columnConfig = {};
var FileStatus = {
  PENDING: 'Pending',
  PROGRESS: 'In progress',
  COMPLETE: 'Complete',
  ERROR: 'Error'
};
var buildFile = function buildFile(blob, overrideName) {
  var initialAttributes = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var attributeKeys = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : ['manufacturer', ['dtType', 'dtCategory']];
  addFileBlob(blob);
  var fileAttributes = _$1.fromPairs(attributeKeys.map(function (attrKey) {
    if (typeof attrKey === 'string') {
      return [attrKey, _$1.isEmpty(initialAttributes[attrKey]) ? '' : initialAttributes[attrKey]];
    } else if (Array.isArray(attrKey)) {
      var complexValue = _$1.toPairs(initialAttributes).filter(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 2),
          attrName = _ref2[0],
          attrValue = _ref2[1];
        return _$1.includes(attrKey, attrName);
      }).map(function (_ref3) {
        var _ref4 = _slicedToArray(_ref3, 2),
          attrName = _ref4[0],
          attrValue = _ref4[1];
        return attrValue;
      });
      return [attrKey, _$1.isEmpty(complexValue) ? attrKey.map(function () {
        return '';
      }) : complexValue];
    } else {
      throw new Error('Invalid attribute key, must be either a string or an array of strings:', attrKey);
    }
  }));
  return {
    status: FileStatus.PENDING,
    name: overrideName ? overrideName : blob.name,
    originalName: blob.name,
    version: 1,
    //Optimistically populate version
    bytesUploaded: 0,
    fileAttributes: fileAttributes
  };
};
var getBlob = function getBlob(file) {
  return fileBlobs[file.originalName];
};
var initialState$1 = {
  columnConfig: [],
  toUpload: [],
  associatedEntities: [],
  rejected: []
};
var entitiesSlice = createSlice({
  name: 'files',
  initialState: initialState$1,
  reducers: {
    addFiles: function addFiles(state, _ref5) {
      var newFiles = _ref5.payload;
      state.toUpload = state.toUpload.concat(newFiles);
    },
    updateFile: function updateFile(state, _ref6) {
      var _ref6$payload = _ref6.payload,
        name = _ref6$payload.name,
        updates = _objectWithoutProperties(_ref6$payload, _excluded);
      var toUpdate = state.toUpload.find(function (f) {
        return f.name === name;
      }); //TODO if this gets too slow, use direct access instead of an array
      _$1.assign(toUpdate, updates);
    },
    updateFileName: function updateFileName(state, _ref7) {
      var _ref7$payload = _ref7.payload,
        name = _ref7$payload.name,
        newName = _ref7$payload.newName;
      var toUpdate = state.toUpload.find(function (f) {
        return f.name === name;
      }); //TODO if this gets too slow, use direct access instead of an array
      _$1.assign(toUpdate, {
        name: newName
      });
    },
    updateFileAttribute: function updateFileAttribute(state, _ref8) {
      var _ref8$payload = _ref8.payload,
        name = _ref8$payload.name,
        updates = _objectWithoutProperties(_ref8$payload, _excluded2);
      var toUpdate = state.toUpload.find(function (f) {
        return f.name === name;
      }); //TODO if this gets too slow, use direct access instead of an array
      toUpdate.fileAttributes = _$1.assign(toUpdate.fileAttributes, updates);
    },
    removeAllFiles: function removeAllFiles(state) {
      state.toUpload = [];
    },
    setAssociatedEntities: function setAssociatedEntities(state, _ref9) {
      var _ref9$payload = _ref9.payload,
        entities = _ref9$payload.entities,
        entityType = _ref9$payload.entityType;
      state.associatedEntities = entities.map(produce(function (e) {
        e.entityType = entityType;
      }));
    },
    setRejectedFiles: function setRejectedFiles(state, _ref0) {
      var rejectedFiles = _ref0.payload;
      state.rejected = rejectedFiles;
    },
    setColumnConfig: function setColumnConfig(state, _ref1) {
      var config = _ref1.payload;
      state.columnConfig = config;
    }
  }
});
var actions$1 = entitiesSlice.actions,
  reducer$1 = entitiesSlice.reducer;

//Selectors

var getFilesSlice = function getFilesSlice(store) {
  return store.files;
};
var getFilesToUpload = createSelector(getFilesSlice, function (filesSlice) {
  return filesSlice.toUpload.map(function (f) {
    return _objectSpread2(_objectSpread2({}, f), {}, {
      fileBlob: getBlob(f)
    });
  });
});
var getAssociatedEntities = createSelector(getFilesSlice, function (filesSlice) {
  return filesSlice.associatedEntities;
});
var getRejectedFiles = createSelector(getFilesSlice, function (filesSlice) {
  return filesSlice.rejected;
});
var getColumnConfig = createSelector(getFilesSlice, function (filesSlice) {
  return filesSlice.columnConfig.map(function (name) {
    return columnConfig[name];
  });
});
var getFilesMetadata = createSelector(getFilesSlice, function (filesSlice) {
  return filesSlice.toUpload;
});

//Action creators
var addFiles = actions$1.addFiles,
  removeAllFiles = actions$1.removeAllFiles,
  updateFile = actions$1.updateFile,
  updateFileName = actions$1.updateFileName,
  setAssociatedEntities = actions$1.setAssociatedEntities,
  updateFileAttribute = actions$1.updateFileAttribute,
  setRejectedFiles = actions$1.setRejectedFiles,
  setColumnConfig = actions$1.setColumnConfig;
var fetchColumnConfig = function fetchColumnConfig(config) {
  return /*#__PURE__*/function () {
    var _ref10 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee(dispatch) {
      var displayNames, columnValues;
      return _regenerator().w(function (_context) {
        while (1) switch (_context.n) {
          case 0:
            _context.n = 1;
            return ScriptHelper.getScriptVar("iaf_attributeDisplayNames");
          case 1:
            displayNames = _context.v;
            _context.n = 2;
            return Promise.all(config.columns.map(FileConfigReader.buildConfig(displayNames)));
          case 2:
            columnValues = _context.v;
            columnConfig = columnValues.reduce(function (cols, col) {
              return _objectSpread2(_objectSpread2({}, cols), {}, _defineProperty({}, col.name, col));
            }, {});
            dispatch(setColumnConfig(columnValues.map(function (_ref11) {
              var name = _ref11.name;
              return name;
            })));
          case 3:
            return _context.a(2);
        }
      }, _callee);
    }));
    return function (_x) {
      return _ref10.apply(this, arguments);
    };
  }();
};
var addFilesToUpload = function addFilesToUpload(newFileBlobs, container, preProcessScript) {
  return /*#__PURE__*/function () {
    var _ref12 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee2(dispatch, getState) {
      var _yield$preProcess, accepted, rejected, columnNames, files, fileVersions;
      return _regenerator().w(function (_context2) {
        while (1) switch (_context2.n) {
          case 0:
            _context2.n = 1;
            return preProcess(newFileBlobs, preProcessScript);
          case 1:
            _yield$preProcess = _context2.v;
            accepted = _yield$preProcess.accepted;
            rejected = _yield$preProcess.rejected;
            columnNames = getColumnConfig(getState()).map(function (_ref13) {
              var name = _ref13.name;
              return name;
            });
            files = accepted.map(function (acc) {
              return buildFile(newFileBlobs.find(function (b) {
                return b.name === acc.name;
              }), acc.overrideName, acc.fileAttributes, columnNames);
            });
            dispatch(setRejectedFiles(rejected.map(function (f) {
              return {
                name: f.name
              };
            })));
            _context2.n = 2;
            return dispatch(addFiles(files));
          case 2:
            _context2.n = 3;
            return Promise.all(files.map(withVersion(container)));
          case 3:
            fileVersions = _context2.v;
            fileVersions.forEach(function (fv) {
              return dispatch(updateFile(fv));
            });
          case 4:
            return _context2.a(2);
        }
      }, _callee2);
    }));
    return function (_x2, _x3) {
      return _ref12.apply(this, arguments);
    };
  }();
};
var cleanFiles = function cleanFiles() {
  return /*#__PURE__*/function () {
    var _ref14 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee3(dispatch) {
      return _regenerator().w(function (_context3) {
        while (1) switch (_context3.n) {
          case 0:
            clearFileBlobs();
            dispatch(removeAllFiles());
          case 1:
            return _context3.a(2);
        }
      }, _callee3);
    }));
    return function (_x4) {
      return _ref14.apply(this, arguments);
    };
  }();
};
var updateMultipleFileAttribute = function updateMultipleFileAttribute(fileUpdates) {
  return /*#__PURE__*/function () {
    var _ref15 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee4(dispatch) {
      return _regenerator().w(function (_context4) {
        while (1) switch (_context4.n) {
          case 0:
            fileUpdates.forEach(function (fu) {
              return dispatch(updateFileAttribute(fu));
            });
          case 1:
            return _context4.a(2);
        }
      }, _callee4);
    }));
    return function (_x5) {
      return _ref15.apply(this, arguments);
    };
  }();
};
var uploadFiles = function uploadFiles(container, processUploadScript, postProcessScript) {
  var batchSize = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 5;
  return /*#__PURE__*/function () {
    var _ref16 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee5(dispatch, getState) {
      var batches, _iterator, _step, batch, _t;
      return _regenerator().w(function (_context5) {
        while (1) switch (_context5.p = _context5.n) {
          case 0:
            batches = _$1.chunk(getFilesMetadata(getState()), batchSize);
            _iterator = _createForOfIteratorHelper(batches);
            _context5.p = 1;
            _iterator.s();
          case 2:
            if ((_step = _iterator.n()).done) {
              _context5.n = 4;
              break;
            }
            batch = _step.value;
            _context5.n = 3;
            return dispatch(uploadFileBatch(container, batch, processUploadScript));
          case 3:
            _context5.n = 2;
            break;
          case 4:
            _context5.n = 6;
            break;
          case 5:
            _context5.p = 5;
            _t = _context5.v;
            _iterator.e(_t);
          case 6:
            _context5.p = 6;
            _iterator.f();
            return _context5.f(6);
          case 7:
            if (postProcessScript) dispatch(postProcessFiles(postProcessScript));
          case 8:
            return _context5.a(2);
        }
      }, _callee5, null, [[1, 5, 6, 7]]);
    }));
    return function (_x6, _x7) {
      return _ref16.apply(this, arguments);
    };
  }();
};
var uploadFileBatch = function uploadFileBatch(container, batch, processUploadScript) {
  return /*#__PURE__*/function () {
    var _ref17 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee7(dispatch) {
      var refreshBytes;
      return _regenerator().w(function (_context7) {
        while (1) switch (_context7.n) {
          case 0:
            refreshBytes = function refreshBytes(file) {
              return function (bytes) {
                return dispatch(updateFile({
                  name: file.name,
                  bytesUploaded: bytes
                }));
              };
            };
            return _context7.a(2, Promise.all(batch.map(/*#__PURE__*/function () {
              var _ref18 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee6(file) {
                var overrideName, uploaded, _t2;
                return _regenerator().w(function (_context6) {
                  while (1) switch (_context6.p = _context6.n) {
                    case 0:
                      //allow the processUploadScript one last chance to modify the file name
                      overrideName = null;
                      if (!processUploadScript) {
                        _context6.n = 2;
                        break;
                      }
                      _context6.n = 1;
                      return ScriptHelper.executeScript(processUploadScript, {
                        file: file
                      });
                    case 1:
                      overrideName = _context6.v;
                      if (overrideName) {
                        dispatch(updateFileName({
                          name: file.name,
                          newName: overrideName
                        }));
                        file = produce(file, function (file) {
                          file.name = overrideName;
                        });
                      }
                    case 2:
                      dispatch(updateFile({
                        name: file.name,
                        status: FileStatus.PROGRESS
                      }));
                      _context6.p = 3;
                      _context6.n = 4;
                      return uploadFile(container, file, refreshBytes(file));
                    case 4:
                      uploaded = _context6.v;
                      dispatch(updateFile({
                        name: file.name,
                        status: FileStatus.COMPLETE,
                        uploadResult: uploaded
                      }));
                      _context6.n = 6;
                      break;
                    case 5:
                      _context6.p = 5;
                      _t2 = _context6.v;
                      dispatch(updateFile({
                        name: file.name,
                        status: FileStatus.ERROR
                      }));
                    case 6:
                      return _context6.a(2);
                  }
                }, _callee6, null, [[3, 5]]);
              }));
              return function (_x9) {
                return _ref18.apply(this, arguments);
              };
            }())));
        }
      }, _callee7);
    }));
    return function (_x8) {
      return _ref17.apply(this, arguments);
    };
  }();
};
var loadAssociatedEntities = function loadAssociatedEntities(_ref19) {
  var selectedEntities = _ref19.selectedEntities,
    script = _ref19.script,
    entityType = _ref19.entityType;
  return /*#__PURE__*/function () {
    var _ref20 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee8(dispatch) {
      var query, entities;
      return _regenerator().w(function (_context8) {
        while (1) switch (_context8.n) {
          case 0:
            if (!selectedEntities) {
              _context8.n = 2;
              break;
            }
            query = {
              _id: {
                $in: selectedEntities
              }
            };
            _context8.n = 1;
            return ScriptHelper.executeScript(script, {
              entityInfo: query
            });
          case 1:
            entities = _context8.v;
            dispatch(setAssociatedEntities({
              entities: entities,
              entityType: entityType
            }));
            _context8.n = 3;
            break;
          case 2:
            dispatch(setAssociatedEntities({
              entities: []
            }));
          case 3:
            return _context8.a(2);
        }
      }, _callee8);
    }));
    return function (_x0) {
      return _ref20.apply(this, arguments);
    };
  }();
};
var postProcessFiles = function postProcessFiles(postProcessScript) {
  return /*#__PURE__*/function () {
    var _ref21 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee9(dispatch, getState) {
      var entitiesByType;
      return _regenerator().w(function (_context9) {
        while (1) switch (_context9.n) {
          case 0:
            entitiesByType = _$1.groupBy(getAssociatedEntities(getState()), function (_ref22) {
              var entityType = _ref22.entityType;
              return entityType;
            });
            _$1.keys(entitiesByType).forEach(function (entityType) {
              return ScriptHelper.executeScript(postProcessScript, {
                entityType: entityType,
                entities: entitiesByType[entityType] || [],
                fileItems: getFilesToUpload(getState()).map(function (_ref23) {
                  var uploadResult = _ref23.uploadResult;
                  return uploadResult;
                })
              });
            });
          case 1:
            return _context9.a(2);
        }
      }, _callee9);
    }));
    return function (_x1, _x10) {
      return _ref21.apply(this, arguments);
    };
  }();
};

//Other
var withVersion = function withVersion(container) {
  return /*#__PURE__*/function () {
    var _ref24 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee0(file) {
      var existingCheck, version;
      return _regenerator().w(function (_context0) {
        while (1) switch (_context0.n) {
          case 0:
            _context0.n = 1;
            return IafFile.getFileItems(container, {
              name: file.name
            }, null, null, null);
          case 1:
            existingCheck = _context0.v;
            version = !!existingCheck && existingCheck._list.length > 0 ? existingCheck._list[0].tipVersionNumber : 1;
            return _context0.a(2, {
              name: file.name,
              version: version
            });
        }
      }, _callee0);
    }));
    return function (_x11) {
      return _ref24.apply(this, arguments);
    };
  }();
};
var uploadFile = function uploadFile(container, file, refreshBytes) {
  return new Promise(function (resolve, reject) {
    var newFile = new File([getBlob(file)], file.name, {
      type: getBlob(file).type
    });
    newFile.fileItem = {
      fileAttributes: _$1.fromPairs(_$1.toPairs(file.fileAttributes).flatMap(function (_ref25) {
        var _ref26 = _slicedToArray(_ref25, 2),
          attrName = _ref26[0],
          attrValue = _ref26[1];
        return comesFromComplexSelect(attrValue) ? asValuePair(attrName, attrValue) : [[attrName, attrValue]];
      }))
    };
    IafFile.uploadFileResumable(container, newFile, {
      filename: file.name,
      onComplete: resolve,
      onError: reject,
      onProgress: refreshBytes
    });
  });
};

//We always take the first value bc we are not allowing multi-selects for file upload. See configReader for validation.
var asValuePair = function asValuePair(attrName, attrValue) {
  var selectValues = _$1.values(attrValue);
  var attrNames = attrName.split(','); //Turn to array again
  return _$1.values(attrValue).map(function (selectValue, i) {
    return [attrNames[i], selectValue[0]];
  });
};
var preProcess = /*#__PURE__*/function () {
  var _ref27 = _asyncToGenerator(/*#__PURE__*/_regenerator().m(function _callee1(files, script) {
    var result;
    return _regenerator().w(function (_context1) {
      while (1) switch (_context1.n) {
        case 0:
          if (!script) {
            _context1.n = 2;
            break;
          }
          _context1.n = 1;
          return ScriptHelper.executeScript(script, {
            files: files
          });
        case 1:
          result = _context1.v;
          return _context1.a(2, {
            accepted: (result.accepted || []).map(function (file) {
              return _objectSpread2(_objectSpread2({}, _$1.omit(file, 'fileItem')), {}, {
                fileAttributes: file.fileItem.fileAttributes
              });
            }),
            rejected: result.rejected || []
          });
        case 2:
          return _context1.a(2, {
            accepted: files
          });
        case 3:
          return _context1.a(2);
      }
    }, _callee1);
  }));
  return function preProcess(_x12, _x13) {
    return _ref27.apply(this, arguments);
  };
}();
var isComplete = function isComplete(file) {
  return file.status === FileStatus.COMPLETE;
};
var isReadyFor = function isReadyFor(columns) {
  return function (file) {
    return columns.filter(function (col) {
      return col.required;
    }).every(function (col) {
      return col.isCompositeAttribute ? col.name.every(function (name) {
        return !_$1.isEmpty(_$1.get(file.fileAttributes, "".concat(col.name, ".").concat(name)));
      }) : !!_$1.get(file.fileAttributes, col.name);
    });
  };
};
var isPending = function isPending(file) {
  return file.status === FileStatus.PENDING;
};
var isInProgress = function isInProgress(file) {
  return file.status === FileStatus.PROGRESS;
};
var comesFromComplexSelect = function comesFromComplexSelect(attrValue) {
  return _typeof(attrValue) === "object";
};

var ChartTestPage = function ChartTestPage(_ref) {
  var charts = _ref.charts,
    scripts = _ref.scripts;
  var _useState = useState(),
    _useState2 = _slicedToArray(_useState, 2),
    script = _useState2[0],
    setScript = _useState2[1];
  var _useState3 = useState(),
    _useState4 = _slicedToArray(_useState3, 2),
    chart = _useState4[0],
    setChart = _useState4[1];
  var _useState5 = useState("{}"),
    _useState6 = _slicedToArray(_useState5, 2),
    newChartConfig = _useState6[0],
    setNewChartConfig = _useState6[1];
  var _useState7 = useState({}),
    _useState8 = _slicedToArray(_useState7, 2),
    chartConfig = _useState8[0],
    setChartConfig = _useState8[1];
  return /*#__PURE__*/React.createElement("div", {
    style: {
      display: "grid",
      gridTemplateColumns: "25% 75%"
    }
  }, /*#__PURE__*/React.createElement("div", {
    style: {
      paddingRight: "20px"
    }
  }, /*#__PURE__*/React.createElement(Select, {
    placeholder: "Select data",
    onChange: function onChange(o) {
      return setScript(o.value);
    },
    options: scripts.map(function (s) {
      return {
        label: s.title,
        value: s.name
      };
    })
  }), /*#__PURE__*/React.createElement(Select, {
    placeholder: "Select chart",
    onChange: function onChange(o) {
      return setChart(o.value);
    },
    options: charts.map(function (c) {
      return {
        label: c,
        value: c
      };
    })
  }), /*#__PURE__*/React.createElement("textarea", {
    onChange: function onChange(e) {
      return setNewChartConfig(e.target.value);
    },
    value: newChartConfig,
    style: {
      margin: "20px 0",
      width: "100%",
      height: "250px"
    }
  }), /*#__PURE__*/React.createElement("button", {
    onClick: function onClick(e) {
      return setChartConfig(JSON.parse(newChartConfig));
    },
    style: {
      padding: "5px 10px"
    }
  }, "Update Chart Config"), /*#__PURE__*/React.createElement("br", null), "See the following links for available chart configuration:", /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("a", {
    href: "https://nivo.rocks/components?filter=SVG",
    target: "_blank"
  }, "Nivo Chart Documentation"), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement("a", {
    href: "https://nivo.rocks/components?filter=SVG",
    target: "_blank"
  }, "Inivcara Chart Extensions")), /*#__PURE__*/React.createElement("div", {
    style: {
      margin: "5px",
      padding: "10px",
      height: "calc(100vh - 175px)",
      minHeight: "300px"
    }
  }, /*#__PURE__*/React.createElement(ScriptedChart, {
    script: script,
    chart: chart,
    chartConfig: chartConfig
  })));
};

var css_248z = ".alert-table {\n  border: solid 0px transparent;\n  border-radius: 8px;\n  background-color: white;\n  box-shadow: 0 0 5px 5px tgba(0, 0, 0, 0.1);\n  padding-bottom: 56px;\n  filter: drop-shadow(0px 2px 4px rgba(0, 0, 0, 0.08)) drop-shadow(0px 0px 1px rgba(0, 0, 0, 0.16));\n}\n.alert-table .alert-table__title {\n  padding: 16px 24px;\n  font-style: normal;\n  font-weight: 700;\n  font-size: 16px;\n  line-height: 24px;\n  color: var(--black);\n  margin: 0;\n}\n.alert-table .alert-table__filter {\n  padding: 16px 24px;\n  background-color: #F9F9F9;\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n  border: solid 1px #E9E9E9;\n}\n.alert-table .alert-table__filter .alert-table__filter-label {\n  font-style: normal;\n  font-weight: 500;\n  font-size: 14px;\n  line-height: 24px;\n  margin-right: 24px;\n  flex-grow: 0;\n}\n.alert-table .alert-table__filter .alert-table__filter-input {\n  flex-grow: 1;\n  margin-right: 24px;\n}\n.alert-table .alert-table__filter .alert-table__filter-button {\n  flex-grow: 0;\n  border: 0;\n  background-color: transparent;\n  height: 32px;\n  width: 32px;\n  border-radius: 8px;\n  transition: all 0.3s ease;\n}\n.alert-table .alert-table__filter .alert-table__filter-button:hover, .alert-table .alert-table__filter .alert-table__filter-button:focus {\n  background-color: #E9E9E9;\n}\n.alert-table .alert-table__filter .alert-table__filter-button.alert-table__filter-button--disabled {\n  background-color: transparent;\n}\n.alert-table .alert-table__filter .alert-table__filter-button i {\n  padding: 0;\n}\n.alert-table .alert-table__table {\n  font-style: normal;\n  font-weight: 400;\n  font-size: 14px;\n  line-height: 24px;\n}\n.alert-table .alert-table__table tr {\n  border-bottom: solid 1px #E9E9E9;\n}\n.alert-table .alert-table__table tr th:first-child, .alert-table .alert-table__table tr td:first-child {\n  padding-left: 24px;\n}\n.alert-table .alert-table__table tr th:last-child {\n  width: 40px;\n  padding: 0;\n}\n.alert-table .alert-table__table tr th {\n  font-weight: 600;\n  padding-top: 10px;\n  padding-bottom: 10px;\n}\n.alert-table .alert-table__table tr td:last-child {\n  width: 40px;\n  padding: 0 8 0 0px;\n}\n.alert-table .alert-table__table tr td {\n  padding-top: 12px;\n  padding-bottom: 12px;\n}\n.alert-table .alert-table__table .cell--urgency .cell__content {\n  font-size: 12px;\n  padding: 2px 12px;\n  height: 24px;\n  border-radius: 12px;\n  white-space: nowrap;\n  display: inline;\n}\n.alert-table .alert-table__table .cell--urgency-high .cell__content {\n  background-color: #CD2026;\n  color: var(--white);\n}\n.alert-table .alert-table__table .cell--urgency-medium .cell__content {\n  background-color: #E86826;\n  color: var(--white);\n}\n.alert-table .alert-table__table .cell--urgency-low .cell__content {\n  background-color: #1D1D1D;\n  color: var(--white);\n}\n.alert-table .alert-table__table .cell__content--tag {\n  font-size: 12px;\n  background-color: var(--app-accent-color);\n  color: var(--white);\n}\n.alert-table .alert-table__table .alert-table__row-action-button {\n  background-color: transparent;\n  border: 0;\n  border-radius: 8px;\n  padding: 8px;\n  width: 100%;\n  transition: all 0.3s ease;\n}\n.alert-table .alert-table__table .alert-table__row-action-button:hover, .alert-table .alert-table__table .alert-table__row-action-button:focus {\n  background-color: #E9E9E9;\n}\n.alert-table .alert-table__table .alert-table__row-action-button i {\n  padding: 0;\n}\n.alert-table .alert-table__table .alert-table__empty-message {\n  color: #B8B8B8;\n  padding: 16px !important;\n  width: 100%;\n  text-align: center;\n}";
styleInject(css_248z);

var getHeaders = function getHeaders(columns) {
  var headers = columns.filter(function (c) {
    return c.active === true;
  }).map(function (c) {
    return c.name;
  });
  headers.push('');
  return headers;
};
var URGENCY_CLASSNAMES = {
  "High": "cell--urgency cell--urgency-high",
  "Medium": "cell--urgency cell--urgency-medium",
  "Low": "cell--urgency cell--urgency-low"
};
var getRowFromAlert = function getRowFromAlert(alert, activeColumns, navigationConfig, onNavigate) {
  console.log('getRowFromAlert alert', alert);
  console.log('getRowFromAlert activeColumns', activeColumns);
  var row = activeColumns.map(function (c) {
    var className = undefined;
    var property = _.get(alert, c.accessor);
    if (property.dname === "Urgency") {
      className = URGENCY_CLASSNAMES[property.val];
    }
    return _objectSpread2(_objectSpread2({}, _.get(alert, c.accessor)), {}, {
      className: className
    });
  });
  console.log('getRowFromAlert row', row);

  //TODO create and push the action menu
  row.push({
    type: "action",
    val: /*#__PURE__*/React.createElement(Tooltip, {
      key: "cell-tooltip",
      title: "Navigate to Source",
      enterDelay: 500
    }, /*#__PURE__*/React.createElement("button", {
      className: "alert-table__row-action-button",
      onClick: function onClick() {
        console.log("button onClick alert", alert);
        console.log("button onClick navigationConfig", navigationConfig);
        if (alert.Source !== null) {
          var entityType = alert.Source.entityType;
          var selectedEntities = alert.Source.entities.map(function (e) {
            return e._id;
          });
          var selectionInfo = {
            entityType: entityType,
            selectedEntities: selectedEntities,
            senderEntityType: entityType,
            queryParams: {
              query: {
                value: selectedEntities
              }
            }
          };
          console.log("button onClick selectionInfo", selectionInfo);
          onNavigate(navigationConfig[entityType], selectionInfo);
        }
      }
    }, /*#__PURE__*/React.createElement("i", {
      className: "fa fa-arrow-right",
      "aria-hidden": "true"
    }))),
    className: "alert-table__row-action"
  });
  return row;
};
var getRowsFromAlerts = function getRowsFromAlerts(alerts, columns, navigationConfig, onNavigate) {
  var activeColumns = columns.filter(function (c) {
    return c.active === true;
  });
  var rows = alerts.map(function (a) {
    return getRowFromAlert(a, activeColumns, navigationConfig, onNavigate);
  });
  return rows;
};
var AlertTable = function AlertTable(props) {
  console.log('AlertTable props', props);
  var _useState = useState(null),
    _useState2 = _slicedToArray(_useState, 2),
    filterInput = _useState2[0],
    setFilterInput = _useState2[1];
  return /*#__PURE__*/React.createElement("div", {
    className: "alert-table"
  }, /*#__PURE__*/React.createElement("h1", {
    className: "alert-table__title"
  }, props.title), /*#__PURE__*/React.createElement("div", {
    className: "alert-table__body"
  }, /*#__PURE__*/React.createElement("div", {
    className: "alert-table__filter"
  }, /*#__PURE__*/React.createElement("label", {
    className: "alert-table__filter-label"
  }, "Filter By: "), /*#__PURE__*/React.createElement(BaseTextInput, {
    className: "alert-table__filter-input",
    inputProps: {
      disabled: true,
      type: "text",
      value: filterInput,
      onChange: function onChange(e) {
        return setFilterInput(e.target.value);
      }
    }
  }), /*#__PURE__*/React.createElement("button", {
    disabled: true,
    className: "alert-table__filter-button alert-table__filter-button--disabled "
  }, /*#__PURE__*/React.createElement("i", {
    className: "fa fa-sliders"
  }))), /*#__PURE__*/React.createElement(Table, {
    className: "alert-table__table",
    headers: getHeaders(props.columns),
    rows: getRowsFromAlerts(props.alerts, props.columns, props.navigateTo, props.onNavigate),
    options: {
      emptyMessage: 'No data',
      emptyMessageClassName: 'alert-table__empty-message'
    }
  })));
};
var AlertTable$1 = withGenericPageContext(AlertTable);

function ScriptedAlertTable(props) {
  console.log("ScriptedAlertTable props", props);
  return /*#__PURE__*/React.createElement(AlertTable$1, {
    title: props.config.title,
    columns: props.config.columns,
    navigateTo: props.config.navigateTo,
    alerts: props.data._list
  });
}

var DASHBOARD_COMPONENTS = {
  "ChartTestPage": ChartTestPage,
  "ChartStack": ChartStack,
  "BigButtonBar": BigButtonBar,
  "CompactButtonBar": CompactButtonBar,
  "CrossEntitySearch": CrossEntitySearch,
  "Image": Image,
  "Iframe": GenericIframe,
  "ScriptedAlertTable": ScriptedAlertTable
};
var applicatonDashboardComponents = {};
var addApplicationDashboardComponent = function addApplicationDashboardComponent(component) {
  return applicatonDashboardComponents[component.name] = component.component;
};
var initialState$2 = {
  frameworkComponents: Object.keys(DASHBOARD_COMPONENTS),
  applicationComponents: []
};
var dashboardsSlice = createSlice({
  name: 'dashboardsUI',
  initialState: initialState$2,
  reducers: {
    setApplicationComponents: function setApplicationComponents(state, _ref) {
      var dashboardComponents = _ref.payload;
      state.applicationComponents = dashboardComponents;
    }
  }
});
var actions$2 = dashboardsSlice.actions,
  reducer$2 = dashboardsSlice.reducer;

//Action creators
var setApplicationComponents = actions$2.setApplicationComponents;

//Thunks
var addDashboardComponents = function addDashboardComponents(components) {
  return function (dispatch, getState) {
    components.forEach(function (comp) {
      addApplicationDashboardComponent(comp);
    });
    var dashboardComponents = Object.keys(applicatonDashboardComponents);
    dispatch(setApplicationComponents(dashboardComponents));
  };
};
var getDashboardComponent = function getDashboardComponent(componentName) {
  return function (dispatch, getState) {
    var component = null;
    component = applicatonDashboardComponents[componentName];
    if (!component) component = DASHBOARD_COMPONENTS[componentName];
    return component;
  };
};

var frameworkReducers = _defineProperty({
  entitiesGeneral: entitiesGeneral,
  entitiesPluggableSearch: entitiesPluggableSearch,
  entityRelations: entityRelations,
  entityUI: entityUI,
  userConfig: userConfig,
  user: reducer,
  files: reducer$1,
  dashboardUI: reducer$2,
  modal: modal
}, NAMED_USER_ITEM_FEATURE_KEY, namedUserItemReducer);
var appReducers = {};
var combinedReducers = combineReducers(_objectSpread2(_objectSpread2({}, frameworkReducers), appReducers));
var addReducerSlice = function addReducerSlice(addSlice) {
  appReducers[addSlice.name] = addSlice.slice;
  return combineReducers(_objectSpread2(_objectSpread2({}, frameworkReducers), appReducers));
};
var rootReducer = function rootReducer(state, action) {
  if (action.type === "Project_SWITCHED") state = undefined;
  return combinedReducers(state, action);
};
var store = configureStore({
  reducer: rootReducer,
  middleware: _toConsumableArray(getDefaultMiddleware()),
  devTools: process.env.NODE_ENV !== 'production'
});

export { addFilesToUpload as A, cleanFiles as B, uploadFiles as C, loadAssociatedEntities as D, updateMultipleFileAttribute as E, fetchColumnConfig as F, addReducerSlice as G, addUser as H, addDashboardComponents as I, PanelToggle as P, SelectNamedUserItemsErrorStatus as S, WizardButtons as W, fetchAllNamedUserItems as a, fetchNamedUserItemItems as b, selectNamedUserItemEntities as c, selectNamedUserItemsLoadingStatus as d, selectNamedUserItemById as e, fetchAssocitedFileSvcData as f, getUser as g, SelectNamedUserItemsImportStatus as h, fetchNamedUserTotalAmountOfItems as i, importDataValidation as j, fileImport as k, store as l, getDashboardComponent as m, namedUserItemActions as n, Star as o, comesFromComplexSelect as p, isReadyFor as q, isComplete as r, setUser as s, isPending as t, isInProgress as u, getBlob as v, getFilesToUpload as w, getAssociatedEntities as x, getRejectedFiles as y, getColumnConfig as z };
