import React, { createContext, useState, useContext, useEffect, useMemo } from 'react';
import filesPage from '../../scripts/NextScriptEngine/scripts/js/iaf_files_page';
import * as PlatformApi from '@dtplatform/platform-api'
import { IafSession, IafProj } from '@dtplatform/platform-api';

export const AppContext = createContext();

const AppProvider = ({ children }) => {
  const [ctx, setCtx] = useState({});
  const [project, setProject] = useState({});
  const [rootFolder, setRootFolder] = useState({});
  const [projUsers, setProjUsers] = useState([]);
  const [projCheck, setProjCheck] = useState(false);
  const [folderCheck, setFolderCheck] = useState(false);

  const lastError = JSON.parse(localStorage.getItem('lastError'))
  const accessToken = sessionStorage.getItem('manage')
  // const sessionUser = (sessionStorage.getItem('sessionUser'))

  // useEffect(() => {
  //   const fetchUser = async () => {
  //     try {
  //       user = await IafSession.setSessionData();
  //       console.log('fetchUser', user);
  //     } catch (error) {
  //       console.error('fetchUser error: ', error);
  //     }
  //   }
  //   if (!sessionUser) {
  //     fetchUser()
  //   }
  // }, [accessToken])

  useEffect(() => {
    const fetchProject = async () => {
      try {
        const proj = await IafProj.getCurrent();
        setProject(proj);
      } catch (error) {
      }
    };
    fetchProject();
  }, []);

  useEffect(() => {
    const fetchContext = async () => {
      try {
        if (project && Object.keys(project).length > 0) {
          const context = {
            _namespaces: project._namespaces
          };
          console.log("returning context", context);
          setCtx(context);
        }
      } catch (error) {
        console.error('Error fetching context:', error);
      }
    };
    fetchContext();
  }, [project]);


  useEffect(() => {
    const fetchRootFolder = async () => {
      try {
        if (ctx && Object.keys(ctx).length > 0) {
          await filesPage.getFolderByPath('/', ctx, PlatformApi).then(folder => {
            console.log("returning root folder", folder)
            setRootFolder(folder)
          });
        }
      } catch (error) {
        console.error('Error fetching root folder:', error);
      }
    }
    if (lastError?.status !== 401 && accessToken) {
      fetchRootFolder();
    }
  }, [ctx, lastError?.status, accessToken]);

  useEffect(() => {
    const fetchProjUsers = async () => {
      if (project && Object.keys(project).length > 0) {
        try {
          const users = await IafProj.getUsers(project, {});
          console.log("returning users", users);
          setProjUsers(users);
        } catch (e) {
          console.log('Error fetching project users:', e)
        }
      }
    };

    fetchProjUsers();
  }, [project]);



  const values = useMemo(() => ({
    ctx,
    setCtx,
    project,
    setProject,
    rootFolder,
    setRootFolder,
    projUsers,
    setProjUsers,
    projCheck,
    setProjCheck,
    folderCheck,
    setFolderCheck
  }), [ctx, project, rootFolder, projUsers, projCheck, folderCheck, setFolderCheck]);

  return (
    <AppContext.Provider value={values}>
      {children}
    </AppContext.Provider>
  );
};

export default AppProvider;

