/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2023] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

import { render } from "react-dom";
import React from "react";
import _ from "lodash";
import "./styles/app.scss";
import * as PlatformApi from '@dtplatform/platform-api';
import { IafProj, IafSession, IafPassSvc, axiosInstance, IafPermission, IafUserGroup } from "@dtplatform/platform-api";
import common from "../ipaCore/helpers/common";
//import { Provider } from "react-keep-alive";
import { IpaMainLayout } from "@dtplatform/platform-app-conflux/modules/IpaLayouts";
import ipaConfig from "../ipaCore/ipaConfig";
import { IafScriptEngine } from "@dtplatform/iaf-script-engine";
import AppProvider from "./AppContext";
import { QueryContextProvider } from "../ipaCore/Context/QueryContext";

IafSession.setConfig(endPointConfig);

// save the intercepted requests in a queue
let interceptedRequestsRef = [];

axiosInstance.interceptors.request.use(function (config) {
  // Do something before request is sent
  // console.log('axios request config Ref', config.url);
  const lastError = JSON.parse(localStorage.getItem('lastError') || '{}');
  if (lastError.status === 401 && lastError.config?.url === config.url) {
    // If the last error was a 401 for this URL, we don't want to send the request again
    console.warn('Skipping request[save request in a queue] due to previous 401 error for this URL IPA:', config.url);
    interceptedRequestsRef.push(config);
    return Promise.reject(new Error('Skipping request due to previous 401 error'));
  }
  return config;
}, function (error) {
  // Do something with request error
  console.log('axios request error config Ref', error);
  return Promise.reject(error);
});

axiosInstance.interceptors.response.use(
  // Any status code that lie within the range of 2xx cause this function to trigger
  async function (response) {
    if (interceptedRequestsRef.length > 0) {
      // If there are requests in the queue, process them
      console.log('Processing queued requests Ref:', interceptedRequestsRef);

      // Clear the queue after processing
      // interceptedRequestsRef = []

    }
    return response
  },
  // Any status codes that falls outside the range of 2xx cause this function to trigger
  async function (error) {
    if (!error.response) {
      return
    }
    try {
      if (error.response?.status === 401) {
        console.log(
          'Ref, had 401, adding request to queue'
        )
      }
      return Promise.reject(error)
    } catch (err) {
      console.error(
        'Error happened in Ref', err
      )
    }
  }
)

const onConfigLoad = async (store, userConfig, AppContext) => {
  const proj = await IafProj.getCurrent();
  let { ctx } = await common.getCurrentProjectInfo();
  console.log("onConfigLoad ->", AppContext, store, userConfig);
  setStyleProperties();
  deleteScheduleOrchsInProject();

  const isValidModel = (model) => {
    let result = true;
    if (model) {
      result = !!Object.entries(model).length;
      if (result) result = !!model._versions && !!model._versions.length;
      if (result) result = !!model._id && !!model._name && !!model._tipId;
    } else {
      result = false;
    }

    return result;
  };


  const models = Array.isArray(await IafProj.getModels(proj)) 
    ? [...(await IafProj.getModels(proj))].reverse()
    : [];
  
  console.log('index models: ', models);

  const sessionModel = IafSession.getSessionStorage('model')

  let selectedModel;
  if (sessionModel) {
    selectedModel = sessionModel;
    IafSession.setSessionStorage('model', '');
  } else {
    console.log('no model in session storage')
    selectedModel = models[0];
  }

  const iafViewerModelData = models?.map(m => ({
    model: {
      model: m._id,
      modelVersionId: m._versions[0]._id,
    },
    bimpk: {
      filename: m._name + '.bimpk'
    }
  }));
  const updatedProjDef = {
    ...proj,
    _userAttributes: {
      ...proj._userAttributes,
      currentModels: [
        ...(Array.isArray(iafViewerModelData) ? iafViewerModelData : [])
      ]
    }
  }
  try {
    const updatedProj = await IafProj.update(updatedProjDef);
    console.log('updatedProj: ', updatedProj);
    AppContext.actions.setSelectedItems({ selectedProject: updatedProj })
    IafSession.setSessionStorage('project', updatedProj)
  } catch (e) {
    console.log('updateProj err: ', e)
    AppContext.actions.setSelectedItems({ selectedProject: updatedProjDef })
    IafSession.setSessionStorage('project', updatedProjDef)
  }

  //only reload the model if there is no loaded model already or
  //if the model which would be loaded is different than the model already loaded
  if (isValidModel(selectedModel)) {
    console.log('isValidModel')
    if (
      !AppContext.selectedItems ||
      !AppContext.selectedItems.selectedModel ||
      selectedModel._id !== AppContext.selectedItems.selectedModel._id
    ) {
      AppContext.actions.setSelectedItems({ selectedModel: selectedModel });
    }
  } else {
    AppContext.actions.setSelectedItems({ selectedModel: null });
    console.log('is not ValidModel')
  }


};

const setStyleProperties = async () => {
  let { ctx } = await common.getCurrentProjectInfo();
  const result = await IafPassSvc.getConfigs(ctx);
  const root = document.documentElement;
  console.log(result.themes.login);

  const accentColor = result.themes.login === "mirrana" ? "#E04F29" : "#4bade8";
  const fancytreeOneColor =
    result.themes.login === "mirrana" ? "#e98469" : "#4bade8";
  const fancytreeOneChannelColor =
    result.themes.login === "mirrana" ? "#e98469" : "#dbecee";
  const filterValue =
    result.themes.login === "mirrana"
      ? "invert(39%) sepia(96%) saturate(446%) hue-rotate(326deg) brightness(92%) contrast(111%)"
      : "invert(57%) sepia(100%) saturate(639%) hue-rotate(174deg) brightness(95%) contrast(91%)";

  root.style.setProperty("--app-accent-color", accentColor);
  root.style.setProperty("--fancytree-one-color", fancytreeOneColor);
  root.style.setProperty(
    "--fancytree-one-channel-color",
    fancytreeOneChannelColor
  );
  root.style.setProperty("--filter", filterValue);
};

const deleteScheduleOrchsInProject = async () => {
  try {
    let { ctx } = await common.getCurrentProjectInfo();
    let allScheduleOrchs = await IafScriptEngine.getOrchestratorSchedules(
      undefined,
      ctx
    );
    console.log("allScheduleOrchs", allScheduleOrchs);
    if (allScheduleOrchs && allScheduleOrchs.length > 0) {
      let req = {
        id: allScheduleOrchs[0]._id,
      };
      let deleteScheduleOrch = await IafScriptEngine.deleteOrchestratorSchedule(
        req,
        ctx
      );
      console.log("deleteScheduleOrch", deleteScheduleOrch);
    }
  } catch (e) {
    console.log(e)
  }

};

render(
  <AppProvider>
    <QueryContextProvider>
      <IpaMainLayout enableAxiosInterceptor ipaConfig={ipaConfig} onConfigLoad={onConfigLoad} />
    </QueryContextProvider>
  </AppProvider>,
  document.getElementById("app")
);

if (module.hot) {
  module.hot.accept();
}

