import React, { createContext, useState, useContext, useEffect, useMemo } from 'react';
import filesPage from '../../../scripts/NextScriptEngine/scripts/js/iaf_files_page';
import * as PlatformApi from '@dtplatform/platform-api'
import { AppContext } from '../../client/AppContext';

const QueryContext = createContext();

const QueryContextProvider = ({ children }) => {

  const { rootFolder, ctx } = useContext(AppContext);

  const [global, setGlobal] = useState(false);
  const [currentFolder, setCurrentFolder] = useState({});
  const [filterType, setFilterType] = useState('');
  const [filterValue, setFilterValue] = useState('');
  const [searchTerm, setSearchTerm] = useState('');
  const [backNav, setBackNav] = useState(false);
  const [backNavcounter, setBackNavcounter] = useState(0);
  const [updateCounter, setUpdateCounter] = useState(0);
  const [pageSize, setPageSize] = useState(5);
  const [pageNum, setPageNum] = useState(1);
  const [filtered, setFiltered] = useState(false);
  const [sortBy, setSortBy] = useState('Name');
  const [sortDescend, setSortDescend] = useState(false);
  const [clearSearch, setClearSearch] = useState(false);

  useEffect(() => {
    const rootChange = () => {
      console.log("root change in context", rootFolder)
      setCurrentFolder(rootFolder);
    }
    rootChange()
  }, [rootFolder])

  const state = useMemo(() => ({
    global,
    currentFolder,
    filterType,
    filterValue,
    searchTerm,
    filtered,
    backNav,
    backNavcounter,
    pageSize,
    pageNum,
    updateCounter,
    sortBy,
    sortDescend,
    clearSearch
  }), [global,
    currentFolder,
    filterType,
    filterValue,
    searchTerm,
    filtered,
    backNav,
    backNavcounter,
    pageSize,
    pageNum,
    updateCounter,
    sortBy,
    sortDescend,
    clearSearch
  ]);

  const actions = useMemo(() => ({
    setGlobal,
    setCurrentFolder,
    setFilterType,
    setFilterValue,
    setSearchTerm,
    setFiltered,
    setBackNav,
    setBackNavcounter,
    setPageSize,
    setPageNum,
    setUpdateCounter,
    setSortBy,
    setSortDescend,
    setClearSearch
  }), [
    setGlobal,
    setCurrentFolder,
    setFilterType,
    setFilterValue,
    setSearchTerm,
    setFiltered,
    setBackNav,
    setBackNavcounter,
    setPageSize,
    setPageNum,
    setUpdateCounter,
    setSortBy,
    setSortDescend,
    setClearSearch
  ]);

  useEffect(() => {
    async function setParentFolderAsCurrent() {
      if (Object.keys(currentFolder).length > 0) {
        const parent = await filesPage.getFolderByPath(currentFolder._versions[0]._userAttributes.parentPath, ctx, PlatformApi);
        if (!parent) {
          parent = rootFolder;
        }
        setCurrentFolder(parent)
        setBackNav(true);
      }
    };
    setParentFolderAsCurrent()
  }, [backNavcounter]);

  return (
    <QueryContext.Provider value={{ state, actions }}>
      {children}
    </QueryContext.Provider>
  );
};

const useQueryContext = () => useContext(QueryContext);

export { QueryContextProvider, useQueryContext };
