import { useContext, useEffect, useState } from 'react';
import filesPage from '../../../scripts/NextScriptEngine/scripts/js/iaf_files_page';
import * as PlatformApi from '@dtplatform/platform-api'
import { AppContext } from '../../client/AppContext';

/**
 * @function  getFilesAndFolders
 * Hook that loads files and folders for the selected UI context
 * @return {Array<User>}
 */
const useFilesAndFolders = (
  ctx,
  folder,
  filterType,
  filterValue,
  filtered,
  searchTerm,
  global,
  backNav,
  pageSize, 
  pageNum,
  updateCounter,
  sortBy,
  sortDescend
) => {
  const { projCheck } = useContext(AppContext);
  const [workingFolder, setWorkingFolder] = useState({});
  const [subfolders, setSubfolders] = useState([]);
  const [subfiles, setSubfiles] = useState([]);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    const logWorkingFolder = () => {
      console.log("logWorkingFolder", workingFolder)
    }
    logWorkingFolder()
  }, [workingFolder])

  useEffect(() => {
    const logSubfolders = () => {
      console.log("logSubfolders", subfolders)
    }
    logSubfolders()
  }, [subfolders])

  useEffect(() => {
    const logSubfiles = () => {
      console.log("logSubfiles", subfiles)
    }
    logSubfiles()
  }, [subfiles])

  useEffect(() => {
    const logLoading = () => {
      console.log("logLoading", loading)
    }
    logLoading()
  }, [loading])

  const fetchData = async (
    ctx,
    folder,
    filterType,
    filterValue,
    filtered,
    searchTerm,
    global,
    backNav,
    pageSize, 
    pageNum,
    sortBy,
    sortDescend 
  ) => {
    const { 
      fetchedFolder,
      fetchedSubfolders,
      fetchedSubfiles
    } = await filesPage.getFilesAndFolders(
      ctx,
      folder,
      filterType,
      filterValue,
      filtered,
      searchTerm,
      global,
      backNav,
      pageSize, 
      pageNum,
      sortBy,
      sortDescend,
      PlatformApi 
    );
    if (Object.keys(fetchedFolder).length > 0) {
      console.log(`filesHook returning folder: ${fetchedFolder}, subfolders: ${fetchedSubfolders}, fetchedSubfiles: ${fetchedSubfiles}`)
      return {
        fetchedFolder: fetchedFolder,
        fetchedSubfolders: fetchedSubfolders,
        fetchedSubfiles: fetchedSubfiles
      }  
    }
  }

  useEffect(() => {
    
    const fetchDataAndSetState = async () => {
      setLoading(true)
      if (projCheck) {
        try {
          const { 
            fetchedFolder,
            fetchedSubfolders,
            fetchedSubfiles
          } = await fetchData(
            ctx, 
            folder, 
            filterType, 
            filterValue, 
            filtered, 
            searchTerm, 
            global, 
            backNav, 
            pageSize, 
            pageNum,
            sortBy,
            sortDescend
          );
      
          setWorkingFolder(fetchedFolder);
          setSubfolders(fetchedSubfolders);
          setSubfiles(fetchedSubfiles);
          
        } catch (error) {
          console.error('Error fetchDataAndSetState:', error);
        } finally {
          setLoading(false);
        }
      }

    };
    
  
    fetchDataAndSetState();
    
    
  }, [ folder, filterType, filterValue, filtered, searchTerm, global, backNav, pageSize, pageNum, updateCounter, sortBy, sortDescend]);

  return { loading, workingFolder, subfolders, subfiles };
};

export default useFilesAndFolders;