import React from 'react';
import Button from "@mui/material/Button";

const StyledButton = ({ text, onClick, children }) => {

  const buttonAccent = {
    color: "var(--app-accent-color)",
  };
  
  return (
    <Button className="controllerButtons" onClick={onClick}>
      {children}
      <span style={buttonAccent}>{text}</span>
    </Button>
  );
};

export default StyledButton;