import React, { useState } from 'react';
import Button from "@mui/material/Button";

const ToggleStyledButton = ({ text, onClick, children }) => {

  const [clicked, setClicked] = useState(false);

  const buttonAccent = {
    color: "var(--app-accent-color)",
  };

  const buttonMargin = {
    marginRight: "5px"
  };

  const backgroundColor = {
    backgroundColor: clicked ? "#f5f5f5" : "white"
  };
  
  return (
    <Button 
      className="controllerButtons" 
      onClick={ () => {
        onClick();
        setClicked(!clicked);
      }}
      style={{
        ...backgroundColor
      }}
    >
      {children}
      <span style={buttonAccent}>{text}</span>
    </Button>
  );
};

export default ToggleStyledButton;