import React, { useState, useRef, useEffect } from 'react'
import IconButton from '@mui/material/IconButton'
import Menu from '@mui/material/Menu'
import MenuItem from '@mui/material/MenuItem'

const DropdownList = ({ icon, items, onClick, menuWidth }) => {
  const [menuOpen, setMenuOpen] = useState(false);
  const [anchorElem, setAnchorElem] = useState(null);
  const menuRef = useRef(null);

  const open = Boolean(anchorElem);

  const handleOutsideClick = (event) => {
    if (menuRef.current && !menuRef.current.contains(event.target)) {
      setMenuOpen(false);
    }
  };

  useEffect(() => {
    document.addEventListener('click', handleOutsideClick);
    return () => {
      document.removeEventListener('click', handleOutsideClick);
    };
  }, []);

  const handleClick = (event) => {
    setAnchorElem(event.currentTarget);
    setMenuOpen(!menuOpen);
  };

  const handleClose = () => {
    setMenuOpen(false);
  };

  const handleAction = (action) => {
    onClick(action);
    handleClose();
  }

  return (
    <div ref={menuRef} style={{ position: 'relative' }}>
      <div onClick={handleClick} style={{ cursor: 'pointer' }}>
        {icon}
      </div>
      {menuOpen && 
        <Menu 
          anchorEl={anchorElem}
          open={open}
          onClose={handleClose}
          getContentAnchorEl={null}
          anchorOrigin={{
            vertical: 'bottom',
            horizontal: 'center',
          }}
          transformOrigin={{
            vertical: 'top',
            horizontal: 'center',
          }}
          PaperProps={{ style: { minWidth: menuWidth.toString() + "px" } }}
        >
          {items && items.map((item) => (
            <MenuItem
              onClick={() => handleAction(item)}
              key={item}
            >
              {item}
            </MenuItem>
          ))}
        </Menu>
      }
    </div>
  )
}

export default DropdownList
