import React, { useState, useEffect } from 'react';
import TextInput from '../Input/TextInput';
import { ArrowDownIcon } from '../icons/ArrowIcon/ArrowIcon';
import './DropdownMenu.css';
import DropdownList from '../DropdownList/DropdownList';

const DropdownMenu = ({ options, onOptionSelected, placeholder, resetSelectedOption, width, iconSize }) => {
  const [selectedOption, setSelectedOption] = useState(`${placeholder}`);

  const setOption = (option) => {
    console.log("setOption:", option);
    setSelectedOption(option);
    onOptionSelected(option);
  };

  useEffect(() => {
    resetSelectedOption && setSelectedOption(placeholder)
  }, [resetSelectedOption]); 

  const dropdownElem = () => {
    return (
      <div className='dropdown-container'>
        <div>
          <TextInput value={selectedOption} end={true} width={width.toString() + "px"}>
            <ArrowDownIcon width={iconSize} height={iconSize} padding={"4px"}/>
          </TextInput>
        </div>
      </div>
    )
  }

  return (
    <DropdownList icon={dropdownElem()} items={options} onClick={(option) => setOption(option)} menuWidth={width + iconSize}/>
  );
};

export default DropdownMenu;
