/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2023] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

import React from "react";
import _ from "lodash";
import { useState, useEffect } from "react";
import { GenericMatButton } from "@dtplatform/platform-app-conflux/modules/IpaControls";
import { IafItemSvc } from "@dtplatform/platform-api";
import PropTypes from "prop-types";
import common from "../helpers/common";
import "./EntityModalEdit.css";
import DeleteConfirmationDialog from "../helpers/DeleteConfirmationDialog";

const EntityModalEdit = ({ config, data }) => {
  const [values, setValues] = useState({
    description: data[0] ? data[0]["Warranty Description"]?.val : "",
    startDate: data[0] ? data[0]["Warranty Start Date"]?.val : "",
    duration: data[0] ? data[0]["Warranty Duration"]?.val : "",
  });
  const [valueFieldEditable, setvalueFieldEditable] = useState(false);
  const [EditClicked, setEditClicked] = useState(false);
  const [recordDeleted, setrecordDeleted] = useState(false);
  const [editbtn, setEditBtn] = useState(true);
  const [deletebtn, setDeleteBtn] = useState(true);
  const [addbtn, setAddBtn] = useState(true);
  const [ctx, setCtx] = useState();
  const [deleteModal, setDeleteModal] = useState(false);
  const [newDataAdded, setNewDataAdded] = useState(false);
  const [relatedItemID, setRelatedItemID] = useState(data[2]?.RelatedItemID);

  /**
   * @function handleClose
   * This function closes the delete dialog
   */
  function handleClose() {
    setDeleteModal(false);
  }
  console.log("data", data);
  /**
   * @function handleValueChange
   * Handles the three values of warranty data ( descripion, startDate & duration )
   * @param {Event} e
   */
  const handleValueChange = (e) => {
    const { name, value } = e.target;

    setValues((p) => {
      return { ...p, [name]: value };
    });
  };
  function getUserGroup() {
    let userType = window.localStorage.getItem("selectedUserGroup");
    console.log(userType);
    if (userType == "Viewer") {
      setEditBtn(false);
      setDeleteBtn(false);
      setAddBtn(false);
    } else {
      setEditBtn(true);
      setDeleteBtn(true);
      setAddBtn(true);
    }
  }

  /**
   * @function clearValues
   * Clears the three values of warranty data ( descripion, startDate & duration )
   * @param {Event} e
   */
  const clearValues = () => {
    data[0]["Warranty Description"].val = "";
    data[0]["Warranty Start Date"].val = "";
    data[0]["Warranty Duration"].val = "";
    for (let key in values) {
      handleValueChange({ target: { name: key, value: "" } });
    }
  };

  /**
   * @function updateElement
   * updates value of Comissioned Date and Warranty Start Date
   */
  async function updateElement() {
    let updatedData = {
      properties: {
        "Warranty Description": {
          dName: "Warranty Description",
          val: values.description,
        },
        "Warranty Start Date": {
          dName: "Warranty Start Date",
          val: values.startDate,
        },
        "Warranty Duration": {
          dName: "Warranty Duration",
          val: values.duration,
        },
      },
    };

    IafItemSvc.updateRelatedItem(
      data[1].userItemID,
      relatedItemID,
      updatedData,
      ctx
    );
    console.log(
      "🚀 ~ file: EntityModalEdit.jsx:82 ~ updateElement ~ data",
      data
    );

    if (!data[0]) {
      data[0] = updatedData.properties;
    }

    data[0]["Warranty Description"].val = values.description;
    data[0]["Warranty Start Date"].val = values.startDate;
    data[0]["Warranty Duration"].val = values.duration;

    handleCancel();
    setDeleteBtn(true);
  }

  /**
   * @function handleDelete
   * This function deletes Comissioned Date and Warranty Start Date fields
   */
  async function handleDelete() {
    handleClose();
    await IafItemSvc.deleteRelatedItem(data[1].userItemID, relatedItemID, ctx);
    clearValues();
    setrecordDeleted(true);
    setNewDataAdded(false);
  }

  /**
   * @function handleCancel
   * makes the value fields uneditable
   * @param {Boolean} _default to set default warranty values if true
   */
  async function handleCancel(_default = false) {
    if (_default) {
      if (data[0] == undefined || data[0]["Warranty Description"].val == "") {
        handleClose();
        await IafItemSvc.deleteRelatedItem(
          data[1].userItemID,
          relatedItemID,
          ctx
        );
        setrecordDeleted(true);
        setNewDataAdded(false);
      } else {
        setValues({
          description: data[0] ? data[0]["Warranty Description"].val : "",
          startDate: data[0] ? data[0]["Warranty Start Date"].val : "",
          duration: data[0] ? data[0]["Warranty Duration"].val : "",
        });
      }
    }
    setEditClicked(false);
    setvalueFieldEditable(false);
  }

  /**
   * @function makeFieldEditable
   * makes value fields editable
   */
  function makeFieldEditable() {
    setvalueFieldEditable(true);
    setEditClicked(true);
    setDeleteBtn(true);
  }

  /**
   * @function addRelatedItem
   * Creates a Warranty data with empty values
   */
  async function addRelatedItem() {
    let relatedItems = [
      {
        properties: {
          "Warranty Description": {
            dName: "Warranty Description",
            val: "",
          },
          "Warranty Start Date": {
            dName: "Warranty Start Date",
            val: "",
          },
          "Warranty Duration": {
            dName: "Warranty Duration",
            val: "",
          },
        },
      },
    ];
    let warrentyRelatedItem = await IafItemSvc.createRelatedItems(
      data[1].userItemID,
      relatedItems,
      ctx
    );
    let relatedToID = warrentyRelatedItem._list[0]._id;
    let relationShips = [
      {
        _relatedFromId: data[4].parentId, // parent id
        _relatedToIds: [relatedToID], // children from tip version
        _relatedUserItemDbId: data[1].userItemID,
      },
    ];
    let relations = await IafItemSvc.addRelations(
      data[3].typeCollectionId,
      relationShips,
      ctx
    );
    setRelatedItemID(relatedToID);
    setNewDataAdded(true);
    setrecordDeleted(false);
    makeFieldEditable();
    setDeleteBtn(false);
  }

  useEffect(() => {
    const getCtxValue = async () => {
      const { project, ctx } = await common.getCurrentProjectInfo();
      setCtx(ctx);
    };
    getCtxValue();
    getUserGroup();
  }, []);

  return (
    <div>
      <DeleteConfirmationDialog
        state={deleteModal}
        handleClose={handleClose}
        handleDelete={handleDelete}
        message="This will Delete all the fields permanently"
      ></DeleteConfirmationDialog>
      {(data !== "return" && data[0] && !recordDeleted) || newDataAdded ? (
        <div>
          <table
            style={{
              borderCollapse: "separate",
              borderSpacing: "10px",
            }}
          >
            <tr>
              <th>Property</th>
              <th>Value</th>
            </tr>
            <tr>
              <td style={{ marginRight: "25px" }}>
                {data[0]
                  ? data[0]["Warranty Description"].dName
                  : "Warranty Description"}
              </td>
              <td>
                {valueFieldEditable ? (
                  <input
                    value={values.description}
                    name="description"
                    style={{ height: "25px" }}
                    className={
                      valueFieldEditable
                        ? "enabled_warranty_input"
                        : "disabled_warranty_input"
                    }
                    readOnly={!valueFieldEditable}
                    onChange={handleValueChange}
                  />
                ) : (
                  <p>{values.description}</p>
                )}
              </td>
            </tr>
            <tr>
              <td style={{ marginRight: "25px" }}>
                {data[0]
                  ? data[0]["Warranty Start Date"].dName
                  : "Warranty Start Date"}
              </td>
              <td>
                <input
                  value={values.startDate}
                  name="startDate"
                  className={
                    valueFieldEditable
                      ? "enabled_warranty_input"
                      : "disabled_warranty_input"
                  }
                  readOnly={!valueFieldEditable}
                  onChange={handleValueChange}
                />
              </td>
            </tr>
            <tr>
              <td style={{ marginRight: "25px" }}>
                {data[0]
                  ? data[0]["Warranty Duration"].dName
                  : "Warranty Duration"}
              </td>
              <td>
                <input
                  value={values.duration}
                  name="duration"
                  className={
                    valueFieldEditable
                      ? "enabled_warranty_input"
                      : "disabled_warranty_input"
                  }
                  readOnly={!valueFieldEditable}
                  onChange={handleValueChange}
                />
              </td>
            </tr>
          </table>

          <div
            style={{
              textAlign: "center",
              paddingTop: "10px",
              display: "flex",
              flexDirection: "row",
            }}
          >
            {editbtn && !EditClicked ? (
              <div
                style={{
                  paddingRight: "10px",
                }}
              >
                <GenericMatButton
                  customClasses="systems-secondary-button"
                  onClick={() => makeFieldEditable()}
                >
                  Edit
                </GenericMatButton>
              </div>
            ) : (
              <div
                style={{
                  paddingRight: "10px",
                }}
              >
                {editbtn && (
                  <GenericMatButton
                    customClasses="systems-secondary-button"
                    onClick={() => handleCancel(true)}
                  >
                    Cancel
                  </GenericMatButton>
                )}
              </div>
            )}
            {EditClicked && (
              <div
                style={{
                  paddingRight: "10px",
                }}
              >
                <GenericMatButton
                  customClasses="systems-secondary-button"
                  style={{
                    width: "4rem",
                    padding: "5px 10px 5px 10px",
                    borderRadius: "10px",
                    marginLeft: "5px",
                  }}
                  onClick={() => updateElement()}
                >
                  Save
                </GenericMatButton>
              </div>
            )}
            <div>
              {deletebtn && (
                <GenericMatButton
                  customClasses="systems-secondary-button"
                  style={{
                    width: "4rem",
                    padding: "5px 10px 5px 10px",
                    borderRadius: "10px",
                    marginLeft: "5px",
                  }}
                  onClick={() => setDeleteModal(true)}
                >
                  Delete
                </GenericMatButton>
              )}
            </div>
          </div>
        </div>
      ) : (
        <div>
          <div>No Data Available</div>
          {addbtn && (
            <GenericMatButton
              customClasses="systems-secondary-button"
              style={{
                width: "4rem",
                padding: "5px 10px 5px 10px",
                borderRadius: "10px",
                marginLeft: "5px",
              }}
              onClick={() => addRelatedItem()}
            >
              Add
            </GenericMatButton>
          )}
        </div>
      )}
    </div>
  );
};

export const EntityModalEditFactory = {
  create: ({ config, data }) => {
    return <EntityModalEdit config={config} data={data} />;
  },
};

EntityModalEditFactory.PropTypes = {
  config: PropTypes.object,
  data: PropTypes.array,
};

export default EntityModalEdit;
