import React, { useState } from 'react';
import { Card, CardContent, TextField } from '@mui/material';
import { GenericMatButton } from "@dtplatform/platform-app-conflux/modules/IpaControls";
import { useApplicationContext } from '../../Hooks/appCtxHook';
import mapBox from '../../../../scripts/NextScriptEngine/scripts/js/iaf_map_box';
import * as PlatformApi from '@dtplatform/platform-api';

const MapboxSecretSubmit = ({ onSubmit }) => {
  const [secret, setSecret] = useState('');
  const [username, setUsername] = useState('');
  const [scopes, setScopes] = useState('');
  const [expiry, setExpiry] = useState('');
  const [status, setStatus] = useState('');
  const appContext = useApplicationContext();
  const [project, setProject] = useState(appContext.selectedItems.selectedProject);
  const ctx = { "_namespaces": project._namespaces };

  const handleSubmit = async (e) => {
    e.preventDefault();
    await addMapConfig();
  };

  const handleUsernameEdit = (event) => {
    setUsername(event.target.value);
  };

  const handleScopesEdit = (event) => {
    setScopes(event.target.value);
  };

  const handleExpiryEdit = (event) => {
    setExpiry(event.target.value);
  };

  const handleSecretEdit = (event) => {
    setSecret(event.target.value);
  };

  const addMapConfig = async () => {
    setStatus('Adding Mapbox temp token config')
    const mapboxColl = await mapBox.checkForMapconfigColl(PlatformApi, ctx);
    await mapBox.addSecretToMapboxColl(
      username,
      JSON.parse(scopes),
      expiry,
      secret, 
      mapboxColl,
      appContext.selectedItems.selectedProject._id, 
      PlatformApi,
      ctx
    );
    setStatus('Mapbox temp token config uploaded');
    setSecret('');
    setUsername('');
    setScopes('');
    setExpiry('');
    await new Promise(resolve => setTimeout(resolve, 3000)); 
    setStatus('');
  }

  const labelStyle = {
    marginTop: '0', 
    marginBottom: '0',
    fontWeight: 'bold'
  }

  return (
    <Card sx={{
      marginTop: '24px'
    }}>
      <CardContent>
        <form onSubmit={handleSubmit} style={{ display: 'flex', flexDirection: 'column', gap: '16px' }}>
          <label style={labelStyle}>Username:</label>
          <TextField
            label="Pass your Mapbox account username"
            variant="outlined"
            value={username}
            onChange={handleUsernameEdit}
            fullWidth
          />
          <label style={labelStyle}>Scopes:</label>
          <TextField
            label='For example, ["tokens:write", "styles:read", "datasets:read", "map:read", "fonts:read"]'
            variant="outlined"
            value={scopes}
            onChange={handleScopesEdit}
            fullWidth
          />
          <label style={labelStyle}>Expiry:</label>
          <TextField
            label="Set expiry time in seconds for temp token, for example, 3600 is 1 hour"
            variant="outlined"
            value={expiry}
            onChange={handleExpiryEdit}
            fullWidth
          />
          <label style={labelStyle}>Secret token:</label>
          <TextField
            label="Mapbox secret token for current model"
            variant="outlined"
            value={secret}
            onChange={handleSecretEdit}
            fullWidth
          />
          <p>{status}</p>
          <GenericMatButton
            onClick={handleSubmit}
          >
            Add temp token config
          </GenericMatButton>
        </form>
      </CardContent>
    </Card>
  );
};

export default MapboxSecretSubmit;