import React, { useEffect, useState } from 'react';
import { useQueryContext } from '../../Context/QueryContext';

const TextInput = ({ value, onChange, children, end, width }) => {
  const [ text, setText ] = useState(value);
  const { state } = useQueryContext();
  const { clearSearch } = state;

  useEffect(() => {
    console.log("TextInput text changed:", text);
  }, [text]);

    useEffect(() => {
    console.log("TextInput value changed:", value);
    setText(value);
  }, [value]);

  useEffect(() => {
    const clearText = () => {
      console.log('Clearing text');
      setText('');
    };
    clearSearch && clearText();
  }, [clearSearch]);

  const handleInputChange = (event) => {
    const inputValue = event.target.value;
    onChange(inputValue);
  };

  //const placeholder = value ? value : "Search..."

  return (
    <div className="text-input-border" style={{ display: 'flex', alignItems: 'center' }}>
      <input
        type="text"
        style={{ width: width }} 
        placeholder={value}
        value={text}
        onChange={handleInputChange}
        className='text-input'
      />
      {children && (
        <div style={{ display: 'flex', justifyContent: end? 'flex-end' : 'flex-start', flexGrow: 1}}>
          {children}
        </div>
      )}
    </div>
  );
};

export default TextInput;