import React, { useState, useRef, useEffect } from 'react'
import IconButton from '@mui/material/IconButton'
import MoreVertIcon from '@mui/icons-material/MoreVert'
import Menu from '@mui/material/Menu'
import MenuItem from '@mui/material/MenuItem'

const KebabMenu = ({ actions, onClick }) => {
  const [menuOpen, setMenuOpen] = useState(false);
  const [anchorElem, setAnchorElem] = React.useState(null);
  const menuRef = useRef(null);

  const open = Boolean(anchorElem);

  const handleOutsideClick = (event) => {
    if (menuRef.current && !menuRef.current.contains(event.target)) {
      setMenuOpen(false);
    }
  };

  useEffect(() => {
    document.addEventListener('click', handleOutsideClick);
    return () => {
      document.removeEventListener('click', handleOutsideClick);
    };
  }, []);

  const handleClick = (event) => {
    setAnchorElem(event.currentTarget)
    setMenuOpen(!menuOpen);
  };

  const handleClose = () => {
    setMenuOpen(!menuOpen);
  };

  const handleAction = (action) => {
    console.log("handleAction:", action);
    onClick(action);
  }

  return (
    <div ref={menuRef}>
      <IconButton onClick={handleClick} size="large">
        <MoreVertIcon/>
      </IconButton>
      {menuOpen && 
        <Menu 
          anchorEl={anchorElem}
          open={open}
        >
          {actions && 
            actions.map(( action ) => (
              <MenuItem
                onClick={() => {
                  handleAction(action);
                  handleClose();
                }}
                key={"id" + action}
              >
                {action}
              </MenuItem>
          ))}
        </Menu>
      }
    </div>
  );
}

export default KebabMenu