import React, { useState } from 'react';
import Modal from './Modal';

function AddFolderDialog({currentFolder, childFolders, onCreateFolder, onClose}) {
  const [folderName, setFolderName] = useState("");
  const [errorMsg, setErrorMsg] = useState(false);
  const [description, setDescription] = useState("");
  const [shortName, setShortName] = useState("");
  const [userType, setUserType] = useState("");
  const [duplicateNameError, setDuplicateNameError] = useState("");

  const handleCreateFolder = () => {
    if (!folderName) {
      setErrorMsg(true);
    } else {
      setErrorMsg(false);
      if (!isDuplicateFolderName()) {
        setDuplicateNameError(false);
        console.log(`Creating folder ${folderName} in ${currentFolder}`);
        const newFolderDef = {
          _name: folderName,
          _description: description !== "" ? description : "Test Project folder",
          _shortName: shortName !== "" ? shortName : "testProjDoc",
          _userType: userType !== "" ? userType : "model_docs",
        };
        onCreateFolder(newFolderDef);        
      } else {
        setDuplicateNameError(true);
      }
    }   
  };

  const isDuplicateFolderName = () => {
    return childFolders.some(folder => folder._name === folderName)
  }
  const handleNameChange = (event) => {
    setFolderName(event.target.value);
  };
    const handleDescChange = (event) => {
    setDescription(event.target.value);
  };
    const handleShortNameChange = (event) => {
    setShortName(event.target.value);
  };
    const handleUserTypeChange = (event) => {
    setUserType(event.target.value);
  };

  return (
    <Modal
      title={`Add Folder to ${currentFolder}`}
      primaryButtonText={"Create Folder"}
      primaryButtonFunc={handleCreateFolder}
      onClose={onClose}
    >
      <p style={{marginBottom: "5px"}}>Folder name:</p>
      {errorMsg && (
        <p style={{ marginBottom: '5px', color: '#8B0000' }}>You must enter a folder name</p>
      )}
      {duplicateNameError && (
        <p style={{ marginBottom: '5px', color: '#8B0000' }}>A folder with this name already exists in the current folder</p>
      )}
      
      <input 
        type="text" 
        value={folderName} 
        onChange={handleNameChange} 
        className="formInputField"
      />
      <p style={{marginBottom: "5px"}}>Description:</p>
      <input 
        type="text" 
        value={description} 
        onChange={handleDescChange} 
        className="formInputField"
      />
      <p style={{marginBottom: "5px"}}>Short name:</p>
      <input 
        type="text" 
        value={shortName} 
        onChange={handleShortNameChange} 
        className="formInputField"
      />
      <p style={{marginBottom: "5px"}}>User type:</p>
      <input 
        type="text" 
        value={userType} 
        onChange={handleUserTypeChange} 
        className="formInputField"
      />
    </Modal>        
  );
}

export default AddFolderDialog;
