import React from 'react';
import Modal from './Modal';

const DeleteFileModal = ({ item, onClose, onFileDelete }) => {

  const name = item.name ? item.name : item._name;
  const type = item._fileId ? "file" : "folder";

  const deleteFile = () => {
    onFileDelete(item);
    onClose()
  }

  return(
    <Modal
      title={`Delete ${type}`}
      primaryButtonText={"Delete"}
      primaryButtonFunc={deleteFile}
      onClose={onClose}
    >
      <p>Are you sure you want to delete the {type} {name}?</p>
    </Modal>
  )
}

export default DeleteFileModal;