import React from 'react';
import Modal from './Modal';

const DeleteFileVersionModal = ({ versionObj, fileItem, onClose, onDeleteFileVersion }) => {

  const versionNum = versionObj._version;
  const fileName = fileItem.name;

  const deleteFileVersion = () => {
    onDeleteFileVersion();
    onClose()
  }

  return(
    <Modal
      title={`Delete file version`}
      primaryButtonText={"Delete"}
      primaryButtonFunc={deleteFileVersion}
      onClose={onClose}
    >
      <p>Are you sure you want to delete version {versionNum} of {fileName}?</p>
    </Modal>
  )
}

export default DeleteFileVersionModal;