import React, { useEffect, useState, useContext } from 'react';
import Modal from './Modal';
import { FileFolderIcon, FileIcon } from '../icons/FileServiceIcon';
import * as PlatformApi from '@dtplatform/platform-api'
import filesPage from '../../../../scripts/NextScriptEngine/scripts/js/iaf_files_page';
import { AppContext } from '../../../client/AppContext';

const DeleteFolderModal = ({ folder, onClose, onFolderDelete }) => {
  const [subfolders, setSubfolders] = useState([]);
  const [subfiles, setSubfiles] = useState([]);
  // Context
  const { ctx } = useContext(AppContext);

  const deleteFolder = () => {
    onFolderDelete({
      folder: folder,
      subfolders: subfolders,
      subfiles: subfiles
    });
  }

  useEffect(() => {
    const checkForSubcontents = async () => {
      await filesPage.loadFolderSubfolders(folder, ctx, {}, PlatformApi)
        .then(response => {
          if (response) {
            setSubfolders(response)
          } 
        })
        .catch(error => {
          console.error('loading subfolders:', error);
        });
      await filesPage.loadFolderSubfiles(folder, {}, ctx, {}, PlatformApi)
        .then(response => {
          if (response) {
            setSubfiles(response)
          } 
        })
        .catch(error => {
          console.error('loading subfiles:', error);
        });
    };
    checkForSubcontents()
  }, []);

  return(
    <Modal
      title={`Delete Folder`}
      primaryButtonText={"Delete Folder"}
      primaryButtonFunc={deleteFolder}
      onClose={onClose}
    >
      <>
        <p>Are you sure you want to delete {folder._name}?</p> 
        {(subfiles.length > 0 || subfolders.length > 0) && (
          <>
            <p style={{ color: '#8B0000' }}>You will also permanently delete the following items:</p>
            <ul>
              {subfolders.length > 0 && 
                subfolders.map(subfolder => 
                  <li className='inline' key={subfolder._id}><FileFolderIcon /> {subfolder._name}</li>
              )}
              {subfiles.length > 0 && 
                subfiles.map(file => 
                  <li className='inline' key={file._id}><FileIcon /> {file.name}</li>
              )}
            </ul>
          </>
        )}
      </>
    </Modal>
  )
}

export default DeleteFolderModal;