/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2023] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

import React from "react";
import IafDocViewer from "@dtplatform/iaf-doc-viewer";
import * as PropTypes from "prop-types";

export const DocViewerModal = ({ show, docUrls, hideDocViewer }) => {
  /**
   * open link in new browser tab
   * @param {string} link document link
   */
  const openLink = (link) => {
    window.open(link, "_blank");
  };

  return (
    <div
      className="doc_viewer_modal_main"
      id={!show ? "hide_doc_viewer_modal" : ""}
    >
      <div className="doc_viewer_modal_child">
        <div>
          <div className="doc_viewer_button close_btn" onClick={hideDocViewer}>
            <i style={{ display: "contents" }} className="fas fa-times"></i>
          </div>
        </div>
        {show && <IafDocViewer className="documentViewer" docIds={docUrls} />}
      </div>
    </div>
  );
};

DocViewerModal.contextTypes = {
  show: PropTypes.bool,
  docUrls: PropTypes.array,
  hideDocViewer: PropTypes.func,
};
