import React from 'react';
import Modal from './Modal';
import IafDocViewer from "@dtplatform/iaf-doc-viewer";

const DocViewerModal = ({ 
  docIds=[], 
  onClose 
}) => {

  const shouldRender = docIds.length > 0;

  return(
    <Modal
      onClose={onClose}
      fullScreen={true}
    >
      { shouldRender && (
        <IafDocViewer 
          docIds={docIds} 
          style={{ height: '100%', width: '100%', zIndex: 100 }}
        /> 
      )}
    </Modal>
  )
}

export default DocViewerModal;