import React, { useState, useEffect } from 'react';
import Modal from './Modal';
import { IafFileSvc } from '@dtplatform/platform-api';

const DownloadModal = ({ item, onClose }) => {

  const name = item.name ? item.name : item._name;
  const type = item._fileId ? "file" : "folder";

  const [fileUrl, setFileUrl] = useState("");

  useEffect(() => {
    async function getDownloadUrl() {
      try {
        const srcFile = await IafFileSvc.getFileUrl(item._fileId)
        setFileUrl(srcFile._url)
      } catch (error) {
        console.error('Error fetching download URL:', error);
      }
    }
    getDownloadUrl();
  }, []);

  const handleDownloadClick = async () => {
    const response = await fetch(fileUrl);
    const blob = await response.blob();
    const objectUrl = URL.createObjectURL(blob);

    const link = document.createElement('a');
    link.style.display = 'none';
    link.href = objectUrl;
    link.setAttribute('download', name);
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
    onClose()
  }

  return (
    <Modal
      title={`Download ${type}`}
      primaryButtonText={"Download"}
      primaryButtonFunc={handleDownloadClick}
      onClose={onClose}
      primaryButtonDisabled={fileUrl === ""}
    >
      <p>Download the {type} {name}?</p>
    </Modal>
  )
}

export default DownloadModal;