import React, { useState } from 'react';
import Dialog from '@mui/material/Dialog'
import DialogTitle from '@mui/material/DialogTitle';
import DialogContent from '@mui/material/DialogContent';
import DialogActions from '@mui/material/DialogActions';
import CloseIcon from '@mui/icons-material/Close';
import Button from '@mui/material/Button';
import './Modal.css';

const Modal = ({
  maxWidth,
  title,
  primaryButtonText,
  primaryButtonFunc,
  secondaryButtonText,
  secondaryButtonFunc,
  onClose,
  primaryButtonDisabled = false,
  fullScreen = false,
  children
}) => {
  const [open, setOpen] = useState(true);

  const handleClose = () => {
    setOpen(false);
    onClose();
  };

  const handlePrimaryButtonFunc = () => {
    primaryButtonFunc();
  };

  const handleSecondaryButtonFunc = () => {
    secondaryButtonFunc();
  };

  const formSubmitButtonStyle = {
    color: 'var(--app-accent-color)',
    padding: '10px 15px',
    border: 'none',
    borderRadius: '4px',
    cursor: 'pointer',
    fontSize: '1rem',
  };

  return (
    <div className="modalBackground">
      <Dialog
        open={open}
        onClose={handleClose}
        fullWidth
        maxWidth={maxWidth}
        fullScreen={fullScreen}
      >
        <DialogTitle
          sx={{
            margin: 0,
            padding: 2,
            display: 'flex',
            justifyContent: 'space-between',
          }}
        >
          <span>{title}</span>
          <div style={{ position: 'absolute', right: 8, top: 8 }}>
            <Button onClick={handleClose} className="closeButton">
              <CloseIcon />
            </Button>
          </div>
        </DialogTitle>
        <DialogContent
          sx={{
            padding: 2,
          }}
        >
          <div style={{ height: '100%', width: '100%' }}>
            {children}
          </div>
        </DialogContent>
        <DialogActions
          sx={{
            margin: 0,
            padding: 1,
          }}
        >
          {secondaryButtonText &&
            <Button onClick={handleSecondaryButtonFunc} color="primary" style={formSubmitButtonStyle}>
              {secondaryButtonText}
            </Button>
          }
          {primaryButtonText &&
            <Button disabled={primaryButtonDisabled} onClick={handlePrimaryButtonFunc} color="primary" style={formSubmitButtonStyle}>
              {primaryButtonText}
            </Button>
          }
        </DialogActions>
      </Dialog>
    </div>
  );
};

export default Modal;
