import React, { useState } from 'react';
import '../../pageComponents/uploadFile/FolderView/FolderView.css';
import Modal from './Modal';
import { LinearProgress } from '@mui/material';

const UploadFileDialog = ({ currentFolder, onClose, onUploadFile }) => {
  const [loading, setLoading] = useState(false);

  const handleFileChange = () => {
    setLoading(true)
    onUploadFile();
  };

  return (
    <Modal 
      title={`Upload file to ${currentFolder}`} 
      onClose={onClose}
      primaryButtonText={"Choose file"}
      primaryButtonFunc={handleFileChange}
    >
      {loading &&
        <LinearProgress style={{marginTop: '8px'}} size={20}/>
      }
    </Modal>
  );
};

export default UploadFileDialog;