import React, { useState, useContext } from 'react';
import Modal from './Modal';
import FolderViewRow from '../../pageComponents/uploadFile/FolderView/FolderViewRow';
import filesPage from '../../../../scripts/NextScriptEngine/scripts/js/iaf_files_page';
import * as PlatformApi from '@dtplatform/platform-api'
import { useQueryContext } from '../../Context/QueryContext';
import '../../pageComponents/uploadFile/FolderView/FolderView.css'
import { DeleteIconHover } from '../icons/DeleteIcon/DeleteIcon';
import { IafFileSvc } from '@dtplatform/platform-api';
import { ActionDialogs } from '../../pageComponents/uploadFile/FolderView/ActionDialogs';
import { EyeIconHover } from '../icons/EyeIcon/EyeIcon';
import { DownloadIconHover } from '../icons/DownloadIcon/DownloadIcon';
import { AppContext } from '../../../client/AppContext';

export const VersionHistoryModal = ({
  item, 
  onClose
}) => {

  // Context
  
  const { ctx, projUsers } = useContext(AppContext);
  const { state } = useQueryContext();
  const { currentFolder } = state;

  const [displayActionModal, setDisplayActionModal] = useState(false);
  const [modalAction, setModalAction] = useState("");
  const [actionModalObj, setActionModalObj] = useState({});
  const [versions, setVersions] = useState([...item.versions]);

  console.log("item", item);
  console.log("versions", versions);

  const getUpdatedByUser = (userId) => {
    const user = projUsers.filter(user => user._id === userId);
    if (user[0]) {
      return user[0]._firstname + " " + user[0]._lastname
    }
  }

  const pStyle = {
    fontSize: "12px"
  }

  const colTitles = ['Version', 'Size', 'Updated date', 'Updater', '', '', '' ]
  const colWidths = [15, 15, 25, 25, 5, 5, 5]

  const handleViewFileVersion = async (fileId, versionId) => {
    setActionModalObj(await IafFileSvc.getFileVersionUrl(fileId, versionId, ctx))
    setModalAction('View')
    setDisplayActionModal(true)
  }

  const handleDownloadFileVersion = async (fileId, versionId) => {
    setActionModalObj(await IafFileSvc.getFileVersionUrl(fileId, versionId, ctx))
    setModalAction('Download')
    setDisplayActionModal(true)
  }

  const handleDeleteFileVersion = async (fileId, versionId) => {
    setActionModalObj(await IafFileSvc.getFileVersion(fileId, versionId, ctx))
    setModalAction('DeleteVersion')
    setDisplayActionModal(true)
  }

  const deleteFileVersion = async () => {
    try {
      console.log("version to delete:", actionModalObj._id);
      console.log("all versions:", versions);
      const updatedVersions = versions.filter(version => version._fileVersionId !== actionModalObj._id);
      setVersions([...updatedVersions]);
      await filesPage.deleteFileVersion(item, actionModalObj, currentFolder, ctx, PlatformApi);
    } catch(e) {
      console.log("error deleting file version from history modal", e);
    }
  }

  const renderActionDialog = () => {
    console.log("actionModalObj", actionModalObj)
    return (
      <ActionDialogs
        modalAction={modalAction}
        actionModalObj={actionModalObj}
        onClose={() => setDisplayActionModal(false)}
        onDeleteFileVersion={() => {
          deleteFileVersion();
          setDisplayActionModal(false)
        }}
        versionFileItem={item}
      />
    )
  }

  return (
    <>
      { displayActionModal && renderActionDialog() }
      <Modal
        title={'Version history'}
        onClose={onClose}
      >
        <h6>{item.name}</h6>
        <div className="table">
          <table style={{width: "100%"}}>
            <thead>
            <tr>
              {colTitles.map((title, index) => (
                <td key={index} style={{borderTop: '0px', width: `${colWidths[index]}%` }}>
                    <h6>{title}</h6>
                </td>
              ))}
            </tr>
            </thead>
            <tbody>
              {versions.map((version) => (
                <FolderViewRow 
                  rowColumns={[
                    <p style={pStyle}>{version.versionNumber}</p>,
                    <p style={pStyle}>{version.fileSize} bytes</p>,
                    <p style={pStyle}>{filesPage.formatDate(version.metadata._updatedAt)}</p>,
                    <p style={pStyle}>{getUpdatedByUser(version.metadata._updatedById)}</p>,
                    <EyeIconHover onClick={() => { handleViewFileVersion(item._fileId, version._fileVersionId) }}/>,
                    <DownloadIconHover onClick={() => { handleDownloadFileVersion(item._fileId, version._fileVersionId) }}/>,
                    <DeleteIconHover onClick={() => { handleDeleteFileVersion(item._fileId, version._fileVersionId) }}/>
                  ]} 
                  colWidths={colWidths}
                  height={"10px"}
                />
              ))}
            </tbody>
          </table>
        </div>
      </Modal>
    </>
  )
}