/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2023] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

import * as PropTypes from "prop-types";
import React, { useState } from "react";
import { IafFileSvc } from "@dtplatform/platform-api";
import _ from "lodash";
import {
  getRandomString,
  ScriptHelper,
} from "@dtplatform/platform-app-conflux/modules/IpaUtils";
import { DocViewerModal } from "./Modals/DocViewer";
import common from "../helpers/common";
import "./RelatedFiles.css";
import DeleteConfirmationDialog from "../helpers/DeleteConfirmationDialog";

const RelatedFiles = ({ header, rows, objects, columns, className }) => {
  console.log("mounting RelatedFiles");
  if (objects.length && objects[0]?.is_temp) {
    objects = [];
  }
  const [value, setValue] = useState(objects);
  const [dummyState, setDummyState] = useState(objects.length + 1);
  const [show, setShow] = useState(false);
  const [data, setModalData] = useState(null);
  const [deleteModal, setDeleteModal] = useState(false);
  const [fileIndex, setIndex] = useState(null);

  /**
   * @function handleClose
   * This function closes the delete dialog
   */
  function handleClose() {
    setDeleteModal(false);
  }

  /**
   * @function showDocViewer
   * Show DOC viewer on element click
   * @param { event } e click event
   * @param {object} obj file Object
   */

  const showDocViewer = async (e, obj) => {
    e.preventDefault();

    let { project, ctx } = await common.getCurrentProjectInfo();
    const modalDataArray = []; // Array to store selected file id
    const fileDataSelected = await IafFileSvc.getFileUrl(obj.id, ctx);
    const extensionSelected = fileDataSelected._name.split(".").pop();
    modalDataArray.push({
      uri: fileDataSelected._url,
      fileType: extensionSelected,
      _fileId: fileDataSelected._id,
    });
    for (const item of objects) {
      const fileData = await IafFileSvc.getFileUrl(item.id, ctx);
      const extension = fileData._name.split(".").pop();
      modalDataArray.push({
        uri: fileData._url,
        fileType: extension,
        _fileId: fileData._id,
      });
    }
    const seenFileIds = {}; // Remove the selected file id as it gets repeated

    const filteredArray = modalDataArray.filter((item) => {
      // Array to store all file id
      if (!seenFileIds[item._fileId]) {
        seenFileIds[item._fileId] = true;
        return true;
      }
      return false;
    });
    setModalData(filteredArray);
    setShow(true);
  };

  /**
   * @function hideDocViewer
   * Hide DocViewer callback
   */
  const hideDocViewer = () => {
    setShow(false);
    setModalData(null);
  };

  /**
   * @function removeIndex
   * Remove related Item
   * @param {number} index
   */
  const removeIndex = async () => {
    handleClose();
    await ScriptHelper.executeScript("deleteRelatedItem", {
      query: { data: objects[fileIndex] },
    });
    let files = value;
    files.splice(fileIndex, 1);
    setValue(files);
    setDummyState(dummyState - 1);
  };

  let keyBase = getRandomString("st_") + "_";
  let i = 0;
  let key = () => keyBase + "_" + i++;

  if (!rows && Array.isArray(objects) && columns) {
    let tinfo = objectsToHeaderAndRows(objects, columns);
    header = tinfo.header;
    rows = tinfo.rows;
  }

  if (!Array.isArray(rows)) {
    console.warn("SimpleTable can't render", rows);
    return (
      <div style={{ color: "red" }}>
        SimpleTable was passed data that it cannot render:
        <pre>{JSON.stringify(rows, null, 2)}</pre>
      </div>
    );
  }

  return (
    <div>
      <DeleteConfirmationDialog
        state={deleteModal}
        handleClose={handleClose}
        handleDelete={removeIndex}
        message="Delete relationship between item and file"
      ></DeleteConfirmationDialog>
      <table className={className} style={{ minWidth: "300px" }}>
        {dummyState && header && header.length > 0 ? (
          <thead>
            <tr>
              {header
                .map((c) => <th key={key()}>{c}</th>)
                .concat(<th>Delete</th>)}
            </tr>
          </thead>
        ) : (
          <span>No files uploaded</span>
        )}
        {value && rows && (
          <tbody>
            {rows.map((r, i) => (
              <tr key={key()}>
                {r
                  .map((c) => (
                    <td key={key()}>
                      {r.indexOf(c) === 0 ? (
                        <a
                          href="#"
                          onClick={(e) => showDocViewer(e, objects[i])}
                        >
                          {c}
                        </a>
                      ) : (
                        c
                      )}
                    </td>
                  ))
                  .concat(
                    <td>
                      <i
                        onClick={() => {
                          setDeleteModal(true);
                          setIndex(i);
                          console.log(value);
                        }}
                        title="Delete"
                        className="trash_icon fas fa-trash"
                      ></i>
                    </td>
                  )}
              </tr>
            ))}
          </tbody>
        )}
      </table>
      <DocViewerModal
        show={show}
        docUrls={data}
        hideDocViewer={hideDocViewer}
      />
    </div>
  );
};

/**
 *  Convert object to table header and rows
 * @param {Array} objects
 * @param {Array} columns
 * @returns {header, rows}
 */
function objectsToHeaderAndRows(objects, columns) {
  let header = [];
  let rows = [];
  let first = true;
  objects.forEach((o) => {
    let row = [];
    columns.forEach((c) => {
      if (first && c.name) header.push(c.name);
      let value = _.get(o, c.accessor);
      row.push(value);
    });
    rows.push(row);
    first = false;
  });
  return { header, rows };
}

RelatedFiles.contextTypes = {
  header: PropTypes.array,
  rows: PropTypes.array,
  objects: PropTypes.array,
  columns: PropTypes.array,
  className: PropTypes.string,
};

/**
 * Factory method for RelatedFiles component
 */
export const RelatedFilesFactory = {
  create: ({ config, data }) => {
    if (config.columns)
      return (
        <RelatedFiles
          className={config.className}
          objects={data}
          columns={config.columns}
        />
      );
    else return <RelatedFiles className={config.className} rows={data} />;
  },
};

export default RelatedFiles;
