/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2023] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

import React, { useState, useEffect } from "react";
import _ from "lodash";
import { ResponsiveLine } from "@nivo/line";
import {
  IafItemSvc,
  IafProj,
  IafDataSource,
  IafSession,
  IafPassSvc,
  IafUserGroup
} from "@dtplatform/platform-api";
import "./Telemetry.css";
import { IafScriptEngine } from "@dtplatform/iaf-script-engine";
//import DeleteConfirmationDialog from "../helpers/DeleteConfirmationDialog";

import { Button } from "@mui/material";
import Dialog from "@mui/material/Dialog";
import DialogActions from "@mui/material/DialogActions";
import DialogContent from "@mui/material/DialogContent";
import DialogContentText from "@mui/material/DialogContentText";
import DialogTitle from "@mui/material/DialogTitle";
import { GenericMatButton } from "@dtplatform/platform-app-conflux/modules/IpaControls";
import DatetimePicker from "react-datetime-picker";
import InfoIcon from "@mui/icons-material/Info";
import { Spinner } from "./icons/Spinners";
import { useApplicationContext } from "../Hooks/appCtxHook";

const Telemetry = ({ config, data }) => {
  const applicationContext = useApplicationContext();

  const [sensorData, setSensorData] = useState({});
  const [floorName, setFloorName] = useState("");
  const [roomName, setRoomName] = useState("");
  const [startTelemetryReadings, setStartTelemetryReadings] = useState(true);
  const [stopTelemetryReadings, setStopTelemetryReadings] = useState(false);
  const [isSensorSelected, setIsSensorSelected] = useState();
  const [fetchLatestReadings, setFetchLatestReadings] = useState(true);
  const [deleteModal, setDeleteModal] = useState(false);
  const [loadingMsg, setLoadingMsg] = useState("");
  const [graphData, setGraphData] = useState(null);
  const [userSelectedTime, setUserSelectedTime] = useState(new Date());
  const [model, setModel] = useState(applicationContext.selectedItems.selectedModel);
  const [elemColl, setElemColl] = useState(null)

  useEffect(() => {
    if (floorName == "") getTelemetryData();
  }, []);

  useEffect(() => {
    const currentDate = new Date();
    if (userSelectedTime !== null && userSelectedTime < currentDate) {
      setGraphdata();
    }
  }, [userSelectedTime]);

  /**
   * @function handleClose
   * This function closes the delete dialog
   */
  function handleClose() {
    setDeleteModal(false);
  }

  /**
   * @function getTelemetryData
   * used to show the list of telemetry families
   */
  const getTelemetryData = async () => {
    console.log(data);
    setGraphdata();
    setLoadingMsg("Getting telemetry data");
    let project = IafProj.getCurrent();
    let ctx = { _namespaces: project._namespaces };
    let _namespaces = ctx._namespaces;
    if (!data.collectionId) return;
    setLoadingMsg("Getting relations of selected element");
    const elemCollRes = 
      await IafScriptEngine.getCollectionInComposite(
        model._id,
        { _userType: "rvt_elements" },
        { _namespaces: applicationContext.selectedItems.selectedProject._namespaces }
      );
    console.log('setting elem coll: ', elemCollRes);
    setElemColl(elemCollRes);
    let relations = await IafItemSvc.getRelations(
      elemCollRes._itemId,
      {
        query: { 
          _relatedFromId: data.selectedElementId,
          _relatedUserType: 'ref_app_telementary_collection' 
        },
      },
      ctx
    );
    console.log(relations);
    if (
      data.selectedElementId == relations._list[0]._relatedFromId ||
      data.selectedElementId == relations._list[1]._relatedFromId
    ) {
      setIsSensorSelected(true);
      let query = { _namespaces, _name: "Schedule Orchestrator" };
      setLoadingMsg("Getting telemetry orchestrator");
      let getOrch = await IafScriptEngine.getDatasources(query, ctx);
      console.log("getOrch", getOrch);
      setLoadingMsg("Getting related telemetry readings");
      let getRelatedReading = await IafItemSvc.getRelatedReadingItems(
        data.collectionId,
        undefined,
        ctx,
        undefined
      );
      console.log("getRelatedReading", getRelatedReading);
      /**
       *
       * @function checkOrch
       * used to check whaeather the list contains schedule orchestor or not
       */
      const checkOrch = async () => {
        setLoadingMsg("Checking for orchestrator");
        let flag = false;
        for (const ele of getOrch) {
          if (ele._name == "Schedule Orchestrator") {
            flag = true;
          }
        }
        return flag;
      };
      setLoadingMsg("Getting orchestrator schedule");
      let getScheduleOrch = await IafScriptEngine.getOrchestratorSchedules(
        ctx,
        ctx
      );
      console.log("getScheduleOrch", getScheduleOrch);
      setLoadingMsg(false);

      /**
       * @function getData
       * used to get data from backend using rest architecture(api)
       * @returns relateditems,relateditems2
       */
      const getData = async () => {
        setLoadingMsg("Getting telemetry items");
        let relatedItems = await IafItemSvc.getRelatedItems(
          data.collectionId,
          {
            _userType: "ref_app_telementary_collection",
            _name: `${model._name} Named Telemetry Collection`,
          },
          ctx,
          undefined
        );
        console.log('getData relatedItems', relatedItems);
        setLoadingMsg("Getting relations of selected element");
        console.log('Elemcoll', elemColl)
        const elemCollRes = 
          await IafScriptEngine.getCollectionInComposite(
            model._id,
            { _userType: "rvt_elements" },
            { _namespaces: applicationContext.selectedItems.selectedProject._namespaces }
          );
        let relations = await IafItemSvc.getRelations(
          elemCollRes._itemId,
          {
            query: { 
              _relatedFromId: data.selectedElementId,
              _relatedUserType: 'ref_app_telementary_collection' 
            },
            options: { page: { getAllItems: true } },
          },
          ctx
        );
        setLoadingMsg(false);
        console.log('relations', relations);
        return { relatedItems, relations };
      };

      let selectedItems = JSON.parse(
        window.localStorage.getItem('ipadt_selectedItems')
      )
      console.log('selecteditems', selectedItems)
      let userGroupId = selectedItems.selectedUserGroupId;
      console.log('userGroupId', userGroupId)
      const userGroup = await IafUserGroup.getById(userGroupId);
      console.log('userGroup', userGroup)

      const isScheduleorch = await checkOrch();
      
      setLoadingMsg("Checking user permissions");
      if ( userGroup._name.includes("Proj Admin") ) {
        if (isScheduleorch) {
          setStartTelemetryReadings(false);
          setStopTelemetryReadings(true);
          setFetchLatestReadings(true);
        } else {
          setStartTelemetryReadings(true);
          setStopTelemetryReadings(false);
          setFetchLatestReadings(true);
        }
      } else {
        setStartTelemetryReadings(false);
        setStopTelemetryReadings(false);
        setFetchLatestReadings(true);
      }
      let { relatedItems, relations } = await getData();
      setLoadingMsg("Setting sensor data");
      setSensorData(relatedItems._list[0]);
      setFloorName(relatedItems._list[0].floorname);
      setRoomName(relatedItems._list[0].roomname);
    } else {
      setIsSensorSelected(false);
    }
    setLoadingMsg(false);
  };

  /**
   * @function setGraphdata
   * used to fetch data from api and seting up the line chart
   */
  const setGraphdata = async () => {
    setLoadingMsg("Setting graph data");
    let project = IafProj.getCurrent();
    let ctx = { _namespaces: project._namespaces };
    setLoadingMsg("Getting telemetry collection");
    // let namedItemsAll = await IafItemSvc.getNamedUserItems();
    // let telCollections = namedItemsAll._list.find(
    //   (item) => item._userType === "ref_app_telementary_collection"
    // );
    console.log('setGraphdata data: ', data)
    const telemColl = await IafItemSvc.getNamedUserItem(
      data.collectionId,
      ctx
    )
    console.log('telemColl at setGraphdata: ', telemColl)
    // const telemColl = data.telemColl
    setLoadingMsg("Getting telemetry items");
    let getRelatedReading = await IafItemSvc.getRelatedReadingItems(
      telemColl._id,
      undefined,
      ctx,
      undefined
    );
    console.log('getRelatedReading', getRelatedReading)
    setLoadingMsg("Mapping readings data to axes");
    const datum = [
      {
        id: "data",
        data: getRelatedReading?._list
          ?.slice(-10)
          .map((entry, index) => {
            const date = new Date(userSelectedTime);
            date.setMinutes(date.getMinutes() - index * 5); // Adjust initial time and reduce by 5 minutes for each reading
            const formattedDate = date.toLocaleString();

            return {
              x: `${date.getHours().toString().padStart(2, "0")}:${date
                .getMinutes()
                .toString()
                .padStart(2, "0")}`,
              y: entry.Temperature || 0, // Assuming Temperature is the property holding the temperature value
              z: formattedDate,
            };
          })
          .reverse(),
      },
    ];
    setLoadingMsg(false);
    console.log("data", datum);
    setGraphData(datum);
  };

  const handleUserTimeChange = (date) => {
    // Check if the selected date is valid
    if (date instanceof Date && !isNaN(date.getTime())) {
      // Check if the selected date is in the future
      const currentDate = new Date();
      if (date > currentDate) {
        // Invalid date (future date), show an error message
        console.error(
          "Selected date is in the future. Please choose a date in the past or present."
        );
        setLoadingMsg(
          "Selected date is in the future. Please choose a valid date in the past or present."
        );
      } else {
        // Valid date, update the state
        setLoadingMsg(false);
        setUserSelectedTime(date);
      }
    } else {
      // Invalid date, show an error message
      console.error("Invalid date selected. Please choose a valid date.");
      setLoadingMsg("Invalid date");
    }
  };

  /**
   * @function handleDeleteOrch
   * to delete the orchestor
   */
  const handleDeleteOrch = async () => {
    handleClose();
    setLoadingMsg("Getting telemetry orchestrator");
    let project = await IafProj.getCurrent();
    let ctx = { _namespaces: project._namespaces };
    let _namespaces = ctx._namespaces;
    let query = { _namespaces, _name: "Schedule Orchestrator" };
    let getOrch = await IafScriptEngine.getDatasources(query, ctx);
    try {
      for (var orch in getOrch)
        if (getOrch[orch]._name == "Schedule Orchestrator") {
          setLoadingMsg("Deleting telemetry orchestrator");
          let res = await IafDataSource.deleteOrchestrator(
            getOrch[orch].id,
            ctx
          );
        }
    } catch (error) {}
    let getScheduleOrch = await IafScriptEngine.getOrchestratorSchedules(
      ctx,
      ctx
    );
    setStartTelemetryReadings(true);
    setStopTelemetryReadings(false);
    setFetchLatestReadings(true);
    setLoadingMsg(false);
    setGraphdata();
    getTelemetryData();
  };

  /**
   * @function handleCreate
   * used to create a new orchestor for the user
   */
  const handleCreate = async () => {
    setLoadingMsg("Creating telemetry channel");
    if (floorName == "") getTelemetryData();
    setLoadingMsg("Getting related items in telemetry collection");
    let project = IafProj.getCurrent();
    let ctx = { _namespaces: project._namespaces };
    ctx.authToken = IafSession.getAuthToken();
    let relatedItems = await IafItemSvc.getRelatedItems(
      data.collectionId,
      {
        _userType: "ref_app_telementary_collection",
        _name: `${model._name} Named Telemetry Collection`,
      },
      ctx,
      undefined
    );
    console.log('create relatedItems: ', relatedItems)
    setLoadingMsg("Getting relations to selected element");
    const elemCollRes = 
      await IafScriptEngine.getCollectionInComposite(
        model._id,
        { _userType: "rvt_elements" },
        { _namespaces: applicationContext.selectedItems.selectedProject._namespaces }
      );
    let relations = await IafItemSvc.getRelations(
      elemCollRes._itemId,
      {
        query: { 
          _relatedFromId: data.selectedElementId,
          _relatedUserType: 'ref_app_telementary_collection' 
        },
        options: { page: { getAllItems: true } },
      },
      ctx
    );
    console.log('relations: ', relations)
    setLoadingMsg("Getting permission profile");
    let criteria = { _userType: "viewer_orch_perms" };
    let options = { _pageSize: 25, _offset: 0 };
    let permissionProfiles = await IafPassSvc.getPermissionProfiles(
      criteria,
      ctx,
      options
    );
    console.log("permissionProfiles", permissionProfiles);
    setLoadingMsg("Checking for existing orchestrator");
    let allDatasources = await IafDataSource.getOrchestrators();
    let telemetryDataSource = allDatasources._list.find(
      (item) => item._name === "Schedule Orchestrator"
    );
    if (!telemetryDataSource) {
      setLoadingMsg("Creating telemetry orchestrator");
      const task = {
        name: "default_script_target",
        _actualparams: {
          userType: "orchestrator",
          _scriptName: "telemetryTemperature",
          TelemetryCollectionId: data.collectionId,
          RelatedItemId: relations._list[0]._relatedToIds[0],
          sensorId: relatedItems._list[0]._sourceId,
        },
        _sequenceno: 1,
      }
      console.log('task: ', task)
      let scheduleOrchestrator = await IafScriptEngine.addDatasource(
        {
          _name: "Schedule Orchestrator",
          _description:
            "Orchestrator to get temperature for telemetry collection",
          _namespaces: project._namespaces,
          _userType: "orchestrator",
          _instant: true,
          _permissionprofileid: permissionProfiles._list[0]._id,
          _params: {
            tasks: [
              task,
            ],
          },
        },
        ctx
      );
      console.log("scheduleOrchestrator", scheduleOrchestrator);
    }
    setLoadingMsg(false);
    setStartTelemetryReadings(false);
    setStopTelemetryReadings(true);
    setFetchLatestReadings(true);
    setGraphdata();
    getTelemetryData();
  };

  const runTelemetryOrch = async () => {
    setLoadingMsg("Getting telemetry orchestrator");
    let project = IafProj.getCurrent();
    let ctx = { _namespaces: project._namespaces };
    let _namespaces = ctx._namespaces;
    let queryTelemetry = { _namespaces, _name: "Schedule Orchestrator" };
    let orchList = await IafScriptEngine.getDatasources(queryTelemetry, ctx);
    for (var orch in orchList) {
      if (orchList[orch]._name === "Schedule Orchestrator") {
        let req = {
          orchestratorId: orchList[orch].id,
        };
        console.log("req", req);
        setLoadingMsg("Running telemetry orchestrator");
        let telemetryOrchestratorRun = await IafScriptEngine.runDatasource(
          req,
          ctx
        );
        console.log(telemetryOrchestratorRun, "telemetryOrchestratorRun");
      }
    }
    setLoadingMsg(false);
    setGraphdata();
  };
  /**
   *
   * @function displaySensorData
   * used to show the data such as floorname,roomname & sorce id from an api
   */
  const displaySensorData = () => {
    return (
      <div>
        <div className="detailRow">
          <p>
            <strong>Floor Name : </strong>
            {sensorData?.floorname ? floorName : "null"}
          </p>
        </div>
        <div className="detailRow">
          <p>
            <strong>Room Name : </strong>
            {sensorData?.roomname ? roomName : "null"}
          </p>
        </div>
        <div className="detailRow">
          <p>
            <strong> Source ID : </strong>
            {sensorData?._sourceId ? sensorData._sourceId : "null"}
          </p>
        </div>
      </div>
    );
  };

  if (isSensorSelected) {
    return (
      <>
        {
          <div>
            <Dialog
              open={deleteModal}
              onClose={handleClose}
              aria-labelledby="alert-dialog-title"
              aria-describedby="alert-dialog-description"
            >
              <DialogTitle id="alert-dialog-title">
                {"Are you sure you want to delete readings?"}
              </DialogTitle>
              <DialogContent>
                <DialogContentText id="alert-dialog-description">
                  This will delete orchestrator to stop generating new readings
                </DialogContentText>
              </DialogContent>
              <DialogActions>
                <Button
                  onClick={handleDeleteOrch}
                  style={{
                    background: "var(--app-accent-color)",
                    color: "#fff",
                  }}
                  variant="contained"
                  autoFocus
                >
                  Stop
                </Button>
                <Button onClick={handleClose}>Cancel</Button>
              </DialogActions>
            </Dialog>
            <div style={{ display: "flex", flexDirection: "row" }}>
              {stopTelemetryReadings && (
                <div
                  style={{
                    paddingRight: "10px",
                  }}
                >
                  <GenericMatButton
                    onClick={() => setDeleteModal(true)}
                    customClasses="systems-secondary-button"
                  >
                    Remove Orchestrator
                  </GenericMatButton>
                </div>
              )}{" "}
              {startTelemetryReadings && (
                <div
                  style={{
                    paddingRight: "10px",
                  }}
                >
                  <GenericMatButton
                    onClick={handleCreate}
                    customClasses="systems-secondary-button"
                  >
                    Create Orchestrator
                  </GenericMatButton>
                </div>
              )}
              {stopTelemetryReadings && fetchLatestReadings && (
                <div
                  style={{
                    paddingRight: "10px",
                  }}
                >
                  <GenericMatButton
                    onClick={() => runTelemetryOrch()}
                    customClasses="systems-secondary-button"
                  >
                    Generate Reading
                  </GenericMatButton>
                </div>
              )}
              <div
                className="dbm-tooltip"
                style={{
                  display: "flex",
                  flexDirection: "column",
                  justifyContent: "center",
                  transform: "scale(0.95)",
                  position: "relative",
                  zIndex: "1",
                }}
              >
                <InfoIcon
                  className="info-icon"
                  style={{
                    cursor: "pointer",
                    color: "white",
                    backgroundColor: "black",
                    borderRadius: "50%",
                  }}
                  fontSize="large"
                />
                <span
                  className="dbm-tooltiptext"
                  style={{
                    bottom: "50%",
                    right: "100%",
                    transform: "translate(61px, 66%) scale(0.80)",
                    position: "absolute",
                    width: "220px",
                    backgroundColor: "white",
                    color: "black",
                  }}
                  dangerouslySetInnerHTML={{
                    __html: `
      The telemetry collection contains a sensor's temperature readings. To get readings, click <strong>CREATE ORCHESTRATOR</strong> to create an orchestrator, then click <strong>GENERATE READINGS</strong> to get 10 new readings. Readings are stored in the telemetry collection for 24 hours. To delete the orchestrator, click <strong>REMOVE ORCHESTRATOR</strong>.
    `,
                  }}
                />
              </div>
            </div>
            {loadingMsg && (
              <>
                <h5 style={{ marginTop: "10px" }}>{loadingMsg}...</h5>
                <Spinner/>              
              </>
            )}
          </div>
        }
        {displaySensorData(sensorData)}
        {graphData && (
          <div>
            {/* Use react-datetime-picker to select time */}
            <label htmlFor="timeInput">Last 10 readings upto: </label>
            <DatetimePicker
              onChange={handleUserTimeChange}
              value={userSelectedTime}
              format="MM/dd/yyyy HH:mm"
              amPm={false}
            />
            <br />
          </div>
        )}
        <div style={{ height: "300px" }}>
          <h1 style={{ textAlign: "center" }}>Temperature Vs Time</h1>
          {graphData && graphData[0].data && (
            <ResponsiveLine
              data={graphData}
              width={500}
              height={300}
              margin={{ top: 50, right: 50, bottom: 80, left: 50 }}
              xScale={{
                type: "point",
              }}
              xFormat={(value) => `${value}`}
              axisBottom={{
                orient: "bottom",
                tickSize: 5,
                tickPadding: 5,
                tickRotation: -90,
                legend: "Time",
                legendOffset: 75,
                legendPosition: "middle",
              }}
              axisLeft={{
                orient: "left",
                tickSize: 5,
                tickPadding: 5,
                tickRotation: 0,
                legend: "Temperature",
                legendOffset: -40,
                legendPosition: "middle",
              }}
              enableGridX={false}
              enableGridY={true}
              colors={["var(--app-accent-color)"]}
              enablePoints={false}
              pointSize={8}
              pointColor={{ from: "color", modifiers: [] }}
              enableArea={false}
              animate={true}
              motionStiffness={90}
              motionDamping={15}
              useMesh={true}
              tooltip={({ point }) => (
                <div
                  style={{
                    background: "white",
                    padding: "9px 12px",
                    border: "1px solid #ccc",
                  }}
                >
                  <strong>Time:</strong> {point.data.z}
                  <br />
                  <strong>Temperature:</strong> {point.data.yFormatted}
                </div>
              )}
            />
          )}
        </div>
      </>
    );
  } else {
    return <h5>Selected Element does not have telemetry Collection</h5>;
  }
};
export const TelemetryFactory = {
  create: ({ config, data }) => {
    return <Telemetry config={config} data={data} />;
  },
};
export default Telemetry;
