/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2023] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

import React, {useEffect, useState} from "react"
import clsx from "clsx";

import {SimpleTable} from '@dtplatform/platform-app-conflux/modules/IpaControls'
import {ScriptHelper, FileHelpers}  from '@dtplatform/platform-app-conflux/modules/IpaUtils'
import _ from "lodash";

const PropertyInfoTable = (props) => {

  const [propertyInfo, setPropertyInfo] = useState({})
  const [picUrl, setPicUrl] = useState()

  useEffect(() => {
    const fetchData = async () => {
      const result = await ScriptHelper.executeScript(props.script)
      setPropertyInfo(result)
    }
    fetchData()
  }, [])

  if (_.keys(propertyInfo).length==0) {
    return <div>Loading...</div>
  }

  let pi = Object.assign({}, propertyInfo)
  let name = pi.Name
  let address = pi.Address
  let picInfo = pi.ImageFile
  delete pi.Name
  delete pi.Address
  delete pi.ImageFile
  let rows = Object.entries(pi).filter(([k,v]) => typeof(v)=="string" || typeof(v)=="number")

  let twoCol = !!picInfo.fileId && (!!name || !!address || !!rows.length > 0)

  let pic = {}
  if (!picUrl && picInfo.fileId)
    FileHelpers.getFileUrl(picInfo.fileId).then(url => setPicUrl(url))
  else
    pic = {backgroundImage: `url("${picUrl}")`}

  return (
    <div className={clsx({"property-info-table": true, "two-col": twoCol, "one-col": !twoCol})}>
      {twoCol && <div>
        <div className="picture-container" style={pic}> </div>
      </div>}
      <div>
        <h1>{name}</h1>
        <h2>{address}</h2>
        <SimpleTable className="property-info-sub-table" rows={rows} />
      </div>
    </div>
  )
}

export default PropertyInfoTable
