import React, { useState } from 'react'

export const ArrowRightIcon = ({
  width = 20,
  height = 20,
  svgColor = '#707070',
  onClick,
  marginLeft
}) => {
  return (
    <ArrowRightBlack width={width} height={height} svgColor={svgColor} rotate={0} onClick={onClick} marginLeft={marginLeft}/>
  )
}

export const ArrowLeftIcon = ({
  width = 20,
  height = 20,
  svgColor = '#707070',
  onClick,
  marginLeft
}) => {
  return (
    <ArrowRightBlack width={width} height={height} svgColor={svgColor} rotate={180} onClick={onClick} marginLeft={marginLeft}/>
  )
}

export const ArrowDownIcon = ({
  width = 20,
  height = 20,
  onClick,
  marginLeft
}) => {
  const [isHovered, setIsHovered] = useState(false);

  const handleMouseEnter = () => setIsHovered(true);
  const handleMouseLeave = () => setIsHovered(false);

  return (
    <div
      style={{ cursor: isHovered ? 'pointer' : 'default' }}
      onMouseEnter={handleMouseEnter}
      onMouseLeave={handleMouseLeave}
      onClick={onClick}
    >
      <ArrowRightBlack width={width} height={height} svgColor={isHovered ? 'var(--app-accent-color)' : '#707070'} rotate={90} marginLeft={marginLeft}/>
    </div>
  )
}


export const ArrowUpIcon = ({
  width = 20,
  height = 20,
  onClick,
  marginLeft
}) => {
  const [isHovered, setIsHovered] = useState(false);

  const handleMouseEnter = () => setIsHovered(true);
  const handleMouseLeave = () => setIsHovered(false);
  return (
    <div
      style={{ cursor: isHovered ? 'pointer' : 'default' }}
      onMouseEnter={handleMouseEnter}
      onMouseLeave={handleMouseLeave}
      onClick={onClick}
    >
      <ArrowRightBlack width={width} height={height} svgColor={isHovered ? 'var(--app-accent-color)' : '#707070'} rotate={-90} onClick={onClick} marginLeft={marginLeft}/>
    </div>
  )
}

export const ArrowRightBlack = ({
  width = 20,
  height = 20,
  svgColor = '#707070',
  rotate,
  marginLeft,
  onClick
}) => {
  return (
    <div onClick={onClick} style={{ marginLeft: `${marginLeft}px` }}> 
      <svg
        version="1.1"
        id="Layer_1"
        xmlns="http://www.w3.org/2000/svg"
        x="0px"
        y="0px"
        width={width}
        height={height}
        viewBox="0 0 32 32"
        style={{ enableBackground: 'new 0 0 32 32', transform: `rotate(${rotate}deg)` }}
      >
        <g>
          <path
            fill={svgColor}
            d="M17.4,16.1l-4.9-5l1.4-1.4l6.4,6.4l-6.4,6.4l-1.4-1.4L17.4,16.1z"
          />
        </g>
      </svg>
    </div>
  );
}