import React, { useState } from 'react';

export const DownloadIcon = ({ colour }) => {
  return (
    <div>
      <svg width="18" height="21" viewBox="0 0 18 21" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path 
          d="M10 10.5H13L9 14.5L5 10.5H8V6.5H10V10.5ZM12 2.5H2V18.5H16V6.5H12V2.5ZM0 1.49C0 0.94 0.45 0.5 1 0.5H13L18 5.5V19.49C18 20.04 17.56 20.49 17.01 20.5H0.99C0.44 20.5 0 20.05 0 19.51V1.49Z" 
          fill={colour}
        />
      </svg>
    </div>
  )
}

export const DownloadIconHover = ({ onClick }) => {
  const [isHovered, setIsHovered] = useState(false);

  const handleMouseEnter = () => setIsHovered(true);
  const handleMouseLeave = () => setIsHovered(false);

  return (
    <div
      style={{ cursor: isHovered ? 'pointer' : 'default' }}
      onMouseEnter={handleMouseEnter}
      onMouseLeave={handleMouseLeave}
      onClick={onClick}
    >
      <DownloadIcon colour={isHovered ? 'var(--app-accent-color)' : '#707070'} />
    </div>
  );
};