import React, { useState } from 'react';

export const EyeIcon = ({
  colour
}) => {
  return (
    <div>
      <svg 
        width="24" 
        height="25" 
        viewBox="0 0 24 25" 
        fill="none" 
        xmlns="http://www.w3.org/2000/svg"
      >
        <g clip-path="url(#clip0_1269_9744)">
          <mask id="mask0_1269_9744" style={{maskType: "alpha"}} maskUnits="userSpaceOnUse" x="0" y="0" width="24" height="25">
            <rect y="0.5" width="24" height="24" fill="#D9D9D9"/>
          </mask>
          <g mask="url(#mask0_1269_9744)">
            <path 
              d="M12 16.5C13.25 16.5 14.3127 16.0627 15.188 15.188C16.0627 14.3127 16.5 13.25 16.5 12C16.5 10.75 16.0627 9.68733 15.188 8.812C14.3127 7.93733 13.25 7.5 12 7.5C10.75 7.5 9.68733 7.93733 8.812 8.812C7.93733 9.68733 7.5 10.75 7.5 12C7.5 13.25 7.93733 14.3127 8.812 15.188C9.68733 16.0627 10.75 16.5 12 16.5ZM12 14.7C11.25 14.7 10.6127 14.4373 10.088 13.912C9.56267 13.3873 9.3 12.75 9.3 12C9.3 11.25 9.56267 10.6123 10.088 10.087C10.6127 9.56233 11.25 9.3 12 9.3C12.75 9.3 13.3877 9.56233 13.913 10.087C14.4377 10.6123 14.7 11.25 14.7 12C14.7 12.75 14.4377 13.3873 13.913 13.912C13.3877 14.4373 12.75 14.7 12 14.7ZM12 19.5C9.56667 19.5 7.35 18.8207 5.35 17.462C3.35 16.104 1.9 14.2833 1 12C1.9 9.71667 3.35 7.89567 5.35 6.537C7.35 5.179 9.56667 4.5 12 4.5C14.4333 4.5 16.65 5.179 18.65 6.537C20.65 7.89567 22.1 9.71667 23 12C22.1 14.2833 20.65 16.104 18.65 17.462C16.65 18.8207 14.4333 19.5 12 19.5ZM12 17.5C13.8833 17.5 15.6127 17.004 17.188 16.012C18.7627 15.0207 19.9667 13.6833 20.8 12C19.9667 10.3167 18.7627 8.979 17.188 7.987C15.6127 6.99567 13.8833 6.5 12 6.5C10.1167 6.5 8.38733 6.99567 6.812 7.987C5.23733 8.979 4.03333 10.3167 3.2 12C4.03333 13.6833 5.23733 15.0207 6.812 16.012C8.38733 17.004 10.1167 17.5 12 17.5Z" 
              fill={colour}
            />
          </g>
        </g>
        <defs>
          <clipPath id="clip0_1269_9744">
            <rect width="24" height="24" fill="white" transform="translate(0 0.5)"/>
          </clipPath>
        </defs>
      </svg>
    </div>
  )
}

export const EyeIconHover = ({ onClick }) => {
  const [isHovered, setIsHovered] = useState(false);

  const handleMouseEnter = () => setIsHovered(true);
  const handleMouseLeave = () => setIsHovered(false);

  return (
    <div
      style={{ cursor: isHovered ? 'pointer' : 'default' }}
      onMouseEnter={handleMouseEnter}
      onMouseLeave={handleMouseLeave}
      onClick={onClick}
    >
      <EyeIcon colour={isHovered ? 'var(--app-accent-color)' : '#707070'} />
    </div>
  );
};