import React, { useContext } from 'react'
import { BaseIcon } from '../BaseIcon'

export const FileServiceIcon = ({ classes = '', isLastClicked }) => {
  const target = {
    default: {
      mirrana: require('./file-service-mirrana.svg'),
      default: require('./file-service.svg')
    },
    highlighted: {
      mirrana: require('./file-service-mirrana.svg'),
      default: require('./file-service-highlighted.svg')
    }
  }


  return (
    <BaseIcon
      classes={classes}
      alt="File service"
      src={target[isLastClicked ? 'highlighted' : 'default']}
      //src={target[isLastClicked ? 'highlighted' : 'default'][theme]}
    />
  )
}

export const ServerIcon = ({ width = 16, height = 16, classes = '', fill = 'black' }) => {
  return (
    <div className={`${classes}`}>
      <svg
        width={width}
        height={height}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <mask
          id="mask0_1319_22125"
          style={{ maskType: 'alpha' }}
          maskUnits="userSpaceOnUse"
          x="0"
          y="0"
          width="16"
          height="16"
        >
          <rect width="16" height="16" fill="#D9D9D9" />
        </mask>
        <g mask="url(#mask0_1319_22125)">
          <path
            d="M2.66667 2H13.3333C13.7 2 14 2.3 14 2.66667V7.33333H2V2.66667C2 2.3 2.3 2 2.66667 2ZM2 8.66667H14V13.3333C14 13.7 13.7 14 13.3333 14H2.66667C2.3 14 2 13.7 2 13.3333V8.66667ZM4.66667 10.6667V12H6.66667V10.6667H4.66667ZM4.66667 4V5.33333H6.66667V4H4.66667Z"
            fill={fill}
          />
        </g>
      </svg>
    </div>
  )
}

export const FileFolderIcon = ({ width = 16, height = 16, classes = '', fill = 'black' }) => {
  return (
    <div className={`${classes}`}>
      <svg
        width={width}
        height={height}
        viewBox="0 0 16 17"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <mask
          id="mask0_1319_22132"
          style={{ maskType: 'alpha' }}
          maskUnits="userSpaceOnUse"
          x="0"
          y="0"
          width="16"
          height="17"
        >
          <rect y="0.5" width="16" height="16" fill="#D9D9D9" />
        </mask>
        <g mask="url(#mask0_1319_22132)">
          <path
            d="M14 6.12995V13.2411C14 13.3982 13.9368 13.549 13.8243 13.6601C13.7117 13.7712 13.5591 13.8337 13.4 13.8337H2.6C2.44087 13.8337 2.28826 13.7712 2.17574 13.6601C2.06321 13.549 2 13.3982 2 13.2411V5.53736H13.4C13.5591 5.53736 13.7117 5.5998 13.8243 5.71093C13.9368 5.82206 14 5.97279 14 6.12995ZM8.2484 4.35218H2V3.75958C2 3.60242 2.06321 3.45169 2.17574 3.34056C2.28826 3.22943 2.44087 3.16699 2.6 3.16699H7.0484L8.2484 4.35218Z"
            fill={fill}
          />
        </g>
      </svg>
    </div>
  )
}

export const FileIcon = ({ width = 16, height = 16, classes = '' }) => {
  return (
    <div className={`${classes}`}>
      <svg
        width="20"
        height="21"
        viewBox="0 0 20 21"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
      >
        <mask
          id="mask0_2295_15274"
          style={{ maskType: 'alpha' }}
          maskUnits="userSpaceOnUse"
          x="0"
          y="0"
          width="20"
          height="21"
        >
          <rect y="0.5" width="20" height="20" fill="#D9D9D9" />
        </mask>
        <g mask="url(#mask0_2295_15274)">
          <path
            d="M17.5 7.16699V17.992C17.5 18.4503 17.1333 18.8253 16.675 18.8337H3.325C2.86667 18.8337 2.5 18.467 2.5 18.0087V2.99199C2.5 2.54199 2.875 2.16699 3.33333 2.16699H12.5L17.5 7.16699ZM15.8333 8.00033H11.6667V3.83366H4.16667V17.167H15.8333V8.00033ZM6.66667 6.33366H9.16667V8.00033H6.66667V6.33366ZM6.66667 9.66699H13.3333V11.3337H6.66667V9.66699ZM6.66667 13.0003H13.3333V14.667H6.66667V13.0003Z"
            fill="black"
          />
        </g>
      </svg>
    </div>
  )
}
