import React, { useState } from 'react';

const IconHover = ({ onClick, children }) => {
  const [isHovered, setIsHovered] = useState(false);

  const iconStyle = {
    color: isHovered ? "var(--app-accent-color)" : "black",
    cursor: isHovered ? 'pointer' : 'default',
  };

  return (
    <div
      style={iconStyle}
      onMouseEnter={() => setIsHovered(true)}
      onMouseLeave={() => setIsHovered(false)}
      onClick={onClick}
    >
      {React.cloneElement(children, { style: iconStyle })}
    </div>
  );
};

export default IconHover;
