import React from 'react'

export const SearchIcon = ({
  width = 24,
  height = 24,
  classes = '',
  onClick
}) => {
  return (
    <div className={`${classes}`} onClick={onClick}>
      <svg
        version="1.1"
        id="Layer_1"
        xmlns="http://www.w3.org/2000/svg"
        x="0px"
        y="0px"
        width={width}
        height={height}
        viewBox="-4 0 24 24"
        style={{ enableBackground: 'new 0 0 24 24' }}
      >
        <g>
          <path
            mask="url(#mask0_2295_6471_00000127007871994708450310000014135548372959947650_)"
            d="M16.6,15.5l3.4,3.4L18.9,20l-3.4-3.4c-1.3,1-2.8,1.6-4.4,1.6C7.2,18.2,4,15,4,11.1C4,7.2,7.2,4,11.1,4
				c3.9,0,7.1,3.2,7.1,7.1C18.2,12.7,17.6,14.3,16.6,15.5z M15,14.9c1-1,1.6-2.4,1.6-3.8c0-3-2.5-5.5-5.5-5.5c-3,0-5.5,2.5-5.5,5.5
				c0,3,2.5,5.5,5.5,5.5c1.4,0,2.8-0.6,3.8-1.6L15,14.9z"
          />
        </g>
      </svg>
    </div>
  )
}
