import React, { useContext } from 'react'
import Backdrop from '@mui/material/Backdrop'
import CircularProgress from '@mui/material/CircularProgress'
import {makeStyles} from "@mui/material";


const useStyles = (themeColor) =>
  makeStyles(() => {
    return {
      svg: {
        color: themeColor || '#EE67B8'
      }
    }
  })

export const Spinner = ({ color, size = 40 }) => (
  <CircularProgress color={color} size={size} />
)

export const SmallSpinner = () => <Spinner size={20} />