/**
 * ****************************************************************************
 *
 * INVICARA INC CONFIDENTIAL __________________
 *
 * Copyright (C) [2012] - [2020] INVICARA INC, INVICARA Pte Ltd, INVICARA INDIA
 * PVT LTD All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Invicara Inc and its suppliers, if any. The intellectual and technical
 * concepts contained herein are proprietary to Invicara Inc and its suppliers
 * and may be covered by U.S. and Foreign Patents, patents in process, and are
 * protected by trade secret or copyright law. Dissemination of this information
 * or reproduction of this material is strictly forbidden unless prior written
 * permission is obtained from Invicara Inc.
 */

import React from "react";
import { CompactPicker } from "react-color";
import "./ColorPicker.css";
import * as EntitySelectionPanel from "../pageComponents/entities/EntitySelectionPanel";
class ColorPicker extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      open: false,
      //default a (opacity) to 1 if not predefined
      currentColor: Object.assign({ a: 1 }, props.currentColor),
      rgb: {},
    };
  }

  hexToRgb(hexColor) {
    // Remove any leading "#" characters
    hexColor = hexColor.replace(/^#/, "");

    // Parse the hex values for red, green, and blue
    const r = parseInt(hexColor.substring(0, 2), 16);
    const g = parseInt(hexColor.substring(2, 4), 16);
    const b = parseInt(hexColor.substring(4, 6), 16);

    // Return the RGB value as a object
    return { r: r, g: g, b: b };
  }

  componentDidMount() {
    const rgbVal = this.hexToRgb(`${EntitySelectionPanel.ThemeColor.color}`);
    this.setState({
      currentColor: EntitySelectionPanel.ThemeColor.color,
      rgb: rgbVal,
    });
  }
  togglePicker = () => {
    const { open } = this.state;
    this.setState({ open: !open });
  };

  closePicker = () => {
    this.setState({ open: false });
  };

  changeColor = (color) => {
    console.log(color);
    const { name } = this.props;
    this.setState({ currentColor: color.hex, open: false, rgb: color.rgb });
    this.props.handleColorChange(name, color.hex);
    this.hexToRgb(`${this.state.currentColor}`);
  };

  render() {
    const { currentColor, open, rgb } = this.state;
    console.log("currentColor", currentColor);
    const { title } = this.props;
    let styles = {
      color: {
        height: "14px",
        borderRadius: "2px",
        background: currentColor,
      },
      swatch: {
        padding: "5px",
        background: "#fff",
        border: "solid #e6e6e6 2px",
        borderRadius: "4px",
        display: "inline-block",
        cursor: "pointer",
      },
      popover: {
        position: "relative",
        zIndex: "8",
        top: "-40px",
        left: "0px",
      },
      cover: {
        position: "fixed",
        top: "0px",
        right: "0px",
        bottom: "0px",
        left: "0px",
      },
    };

    return (
      <div style={{ display: "flex", flexDirection: "column" }}>
        <div className="title">{title}</div>
        <div className="form-group row">
          <div
            className="col-sm-2"
            style={styles.swatch}
            onClick={this.togglePicker}
          >
            <div style={styles.color} />
          </div>
          <div className="col-sm-7">
            rgb({rgb.r}, {rgb.g}, {rgb.b})
          </div>

          {open ? (
            <div style={styles.popover}>
              <div style={styles.cover} onClick={this.closePicker} />
              <CompactPicker
                color={this.props.currentColor}
                onChange={this.changeColor}
              />
            </div>
          ) : null}
        </div>
      </div>
    );
  }
}

export default ColorPicker;
