import React from "react";
import Modal from "../components/Modals/Modal";

const LongBimpkNameModal = ({ name, onCancel }) => {
  return (
    <Modal
      title="Filename too long"
      primaryButtonText="Cancel"
      primaryButtonFunc={onCancel}
      onClose={onCancel}
      maxWidth="sm" 
    >
      <div>
        <p>Your bimpk file name is {name.length - 100} chars above the 100 char name length limit. Rename the file with {name.length - 100} fewer characters before uploading again.</p>
      </div>
    </Modal>
  );
};

export default LongBimpkNameModal;