import React from "react";
import "./ProgressBar.css"; 

const ProgressBar = ({ progress, label }) => {
  return (
    <div className="progress-container">
      <div className="progress-bar-container">
        <div
          className="progress-bar"
          style={{ width: `${Math.min(Math.max(progress, 0), 100)}%` }}
        />
      </div>
      {label && (
        <p className="progress-label">
          {label}: {Math.min(Math.max(progress, 0), 100)}%
        </p>
      )}
    </div>
  );
};

export default ProgressBar;
