import React, { useState } from "react";
import Modal from "../components/Modals/Modal";

const ShortenBimpkNameModal = ({ originalName, onSubmit, onCancel }) => {
  const [newName, setNewName] = useState(originalName);
  return (
    <Modal
      title="Filename too long"
      primaryButtonText="Save"
      primaryButtonFunc={() => { newName.length <= 100 && onSubmit(newName)}}
      secondaryButtonText="Cancel"
      secondaryButtonFunc={onCancel}
      onClose={onCancel}
      maxWidth="sm" 
    >
      <div>
        <p>Rename the file with fewer than 100 characters</p>
        <p style={{ color: newName.length > 100 ? 'red' : 'green' }}>
          {newName.length} chars
        </p>
        <input
          type="text"
          value={newName}
          onChange={(e) => setNewName(e.target.value)}
          style={{ width: '100%', padding: '8px', marginBottom: '10px' }}
        />
      </div>
    </Modal>
  );
};

export default ShortenBimpkNameModal;