import React, { useEffect, useState } from "react";
import { ArrowDropDownCircle, RemoveCircle } from "@mui/icons-material";
import { SimpleTreeView as MaterialTreeView, TreeItem } from "@mui/x-tree-view";
import "./TreeView.css";

export default function TreeView(props) {
  const [nodeIds, setNodeIds] = useState([]);
  const [expanded, setExpanded] = useState([]);

  useEffect(() => {
    const nodeIds = renderNodeIds(props.treeData, "");
    setNodeIds(nodeIds);
    setExpanded([]);
  }, [props.treeData]);

  const handleExpandAll = () => {
    setExpanded(nodeIds);
  };

  const handleCollapseAll = () => {
    setExpanded([]);
  };

  const handleToggle = (event, nodeIds) => {
    setExpanded(nodeIds);
  };

  const renderNodeIds = (node, path) => {
    if (typeof node === "object" && node !== null) {
      if (Array.isArray(node)) {
        return node.flatMap((item, index) => {
          const nodeId = `${path}-${index}`;
          const nestedNodeIds = renderNodeIds(item, nodeId);
          return [nodeId, ...nestedNodeIds];
        });
      } else {
        return Object.keys(node).flatMap((key) => {
          const nodeId = `${path}-${key}`;
          const nestedNodeIds = renderNodeIds(node[key], nodeId);
          return [nodeId, ...nestedNodeIds];
        });
      }
    } else {
      return [];
    }
  };

  const renderNode = (node, path) => {
    if (typeof node === "object" && node !== null) {
      if (Array.isArray(node)) {
        return node.map((item, index) => {
          const nodeId = `${path}-${index}`;
          return (
            <TreeItem key={nodeId} itemId={nodeId} label={`[${index}]`}>
              {renderNode(item, nodeId)}
            </TreeItem>
          );
        });
      } else {
        return Object.keys(node).map((key) => {
          const nodeId = `${path}-${key}`;
          return (
            <TreeItem key={nodeId} itemId={nodeId} label={key}>
              {renderNode(node[key], nodeId)}
            </TreeItem>
          );
        });
      }
    } else {
      return (
        <TreeItem
          key={`${path}-leaf`}
          itemId={`${path}-leaf`}
          label={
            typeof node === "boolean" || typeof node === "number" ? (
              <p style={{ marginBottom: "0px", color: "blue" }}>{`${node}`}</p>
            ) : (
              <p style={{ marginBottom: "0px", color: "red" }}>{`"${node}"`}</p>
            )
          }
        />
      );
    }
  };

  return (
    <div className="tree-view">
      
      <div
        style={{
          padding: "10px",
          justifyContent: "space-between",
          display: "flex",
          flexDirection: "row",
        }}
      >
        <div
          style={{
            display: "flex",
            justifyContent: "center",
            alignItems: "center",
          }}
        >
          <h5 style={{ margin: "0px" }}>{props.title}</h5>
        </div>
        {nodeIds.length > 0 && (
          <div
            style={{
              display: "flex",
              flexDirection: "row",
              gap: "15px",
              alignItems: "center",
            }}
          >
            {expanded.length === 0 ? (
              <ArrowDropDownCircle
                className="custom-icon"
                onClick={handleExpandAll}
              />
            ) : (
              <RemoveCircle
                className="custom-icon"
                onClick={handleCollapseAll}
              />
            )}
          </div>
        )}
      </div>
      <h5 style={{ padding: "10px", margin: "0px" }}>Status code: {props.responseStatus}</h5>
      <MaterialTreeView
        expandedItems={expanded}
        onExpandedItemsChange={handleToggle}
        style={{ padding: "0px 15px 10px 15px" }}
      >
        {renderNode(props.treeData, "")}
      </MaterialTreeView>
    </div>
  );
}
